/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm;

import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.FloatTerm;
import gnu.prolog.term.IntegerTerm;
import gnu.prolog.term.JavaObjectTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.BacktrackInfo;
import gnu.prolog.vm.Environment;
import gnu.prolog.vm.HasEnvironment;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.PrologHalt;
import gnu.prolog.vm.PrologStream;
import gnu.prolog.vm.UndoData;
import gnu.prolog.vm.interpreter.Predicate_call;
import gnu.prolog.vm.interpreter.Tracer;
import java.util.HashMap;
import java.util.Map;

public final class Interpreter
implements HasEnvironment {
    static final double FLOAT_EPSILON = 1.0E-7;
    private Environment environment;
    private Tracer tracer;
    private PrologHalt haltExitCode;
    @Deprecated
    private Map<String, Object> context;
    private static final int PAGESIZE = 4096;
    private static final int GROWSIZE = 4096;
    private BacktrackInfo[] backtrackInfoStack = new BacktrackInfo[4096];
    private int backtrackInfoAmount = 0;
    private int backtrackInfoMax = this.backtrackInfoStack.length;
    protected VariableTerm[] variables = new VariableTerm[4096];
    protected int variablesAmount = 0;
    private UndoData[] undoData = new UndoData[4096];
    private int undoDataAmount = 0;
    private boolean undoPositionAsked = true;
    private Goal currentGoal;
    private Map<Goal, ReturnPoint> returnPoints = new HashMap<Goal, ReturnPoint>();

    protected Interpreter(Environment environment) {
        this.environment = environment;
        PrologStream outstream = null;
        try {
            outstream = environment.getUserOutput();
        }
        catch (PrologException e) {
            System.err.println("Could not get an output stream:");
            e.printStackTrace();
        }
        this.tracer = new Tracer(outstream);
        this.context = new HashMap<String, Object>();
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    @Deprecated
    public Object putContext(String key, Object contextValue) {
        return this.context.put(key, contextValue);
    }

    @Deprecated
    public Object getContext(String key) {
        return this.context.get(key);
    }

    public void pushBacktrackInfo(BacktrackInfo bi) {
        if (this.backtrackInfoAmount == this.backtrackInfoMax) {
            BacktrackInfo[] tmp = new BacktrackInfo[this.backtrackInfoMax + 4096];
            System.arraycopy(this.backtrackInfoStack, 0, tmp, 0, this.backtrackInfoAmount);
            this.backtrackInfoStack = tmp;
            this.backtrackInfoMax += 4096;
        }
        this.backtrackInfoStack[this.backtrackInfoAmount++] = bi;
    }

    public BacktrackInfo popBacktrackInfo() {
        BacktrackInfo rc = this.backtrackInfoStack[--this.backtrackInfoAmount];
        this.backtrackInfoStack[this.backtrackInfoAmount] = null;
        return rc;
    }

    public void popBacktrackInfoUntil(BacktrackInfo cutPoint) {
        int pos = this.backtrackInfoAmount - 1;
        while (pos >= 0 && cutPoint != this.backtrackInfoStack[pos]) {
            --pos;
        }
        if (pos < 0) {
            throw new IllegalArgumentException("cutPoint not found");
        }
        int i = pos + 1;
        while (i < this.backtrackInfoAmount) {
            this.backtrackInfoStack[i] = null;
            ++i;
        }
        this.backtrackInfoAmount = pos + 1;
    }

    public BacktrackInfo peekBacktrackInfo() {
        return this.backtrackInfoStack[this.backtrackInfoAmount - 1];
    }

    public int getUndoPosition() {
        this.undoPositionAsked = true;
        return this.undoDataAmount;
    }

    public void undo(int position) {
        int i = this.undoDataAmount - 1;
        while (i >= position) {
            this.undoData[i].undo();
            this.undoData[i] = null;
            --i;
        }
        this.undoDataAmount = position;
        this.undoPositionAsked = true;
    }

    public void addVariableUndo(VariableTerm variable) {
        if (this.undoPositionAsked || !(this.undoData[this.undoDataAmount - 1] instanceof VariableUndoData)) {
            this.addSpecialUndo(new VariableUndoData());
        }
        if (this.variablesAmount == this.variables.length) {
            VariableTerm[] tmp = new VariableTerm[4096 + this.variables.length];
            System.arraycopy(this.variables, 0, tmp, 0, this.variablesAmount);
            this.variables = tmp;
        }
        this.variables[this.variablesAmount] = variable;
        ++this.variablesAmount;
    }

    public void addSpecialUndo(UndoData undoDatum) {
        if (this.undoDataAmount == this.undoData.length) {
            UndoData[] tmp = new UndoData[4096 + this.undoData.length];
            System.arraycopy(this.undoData, 0, tmp, 0, this.undoDataAmount);
            this.undoData = tmp;
        }
        this.undoData[this.undoDataAmount] = undoDatum;
        ++this.undoDataAmount;
    }

    public int simpleUnify(Term t1, Term t2) throws PrologException {
        int rc = 1;
        if (t1 != t2) {
            if (t1 instanceof VariableTerm) {
                VariableTerm vt1 = (VariableTerm)t1;
                this.addVariableUndo(vt1);
                vt1.value = t2;
            } else if (t2 instanceof VariableTerm) {
                VariableTerm vt2 = (VariableTerm)t2;
                this.addVariableUndo(vt2);
                vt2.value = t1;
            } else if (t1.getClass() != t2.getClass()) {
                rc = -1;
            } else if (t1 instanceof CompoundTerm) {
                CompoundTerm ct1 = (CompoundTerm)t1;
                CompoundTerm ct2 = (CompoundTerm)t2;
                if (ct1.tag != ct2.tag) {
                    rc = -1;
                } else {
                    Term[] args1 = ct1.args;
                    Term[] args2 = ct2.args;
                    int i = args2.length - 1;
                    while (i >= 0) {
                        rc = this.simpleUnify(args1[i].dereference(), args2[i].dereference());
                        if (rc != -1) {
                            --i;
                            continue;
                        }
                        break;
                    }
                }
            } else if (t1 instanceof FloatTerm) {
                FloatTerm ct1 = (FloatTerm)t1;
                FloatTerm ct2 = (FloatTerm)t2;
                if (ct1.value != ct2.value && Math.abs(ct1.value - ct2.value) > 1.0E-7) {
                    rc = -1;
                }
            } else if (t1 instanceof IntegerTerm) {
                IntegerTerm ct1 = (IntegerTerm)t1;
                IntegerTerm ct2 = (IntegerTerm)t2;
                if (ct1.value != ct2.value) {
                    rc = -1;
                }
            } else if (t1 instanceof JavaObjectTerm) {
                JavaObjectTerm ct1 = (JavaObjectTerm)t1;
                JavaObjectTerm ct2 = (JavaObjectTerm)t2;
                if (ct1.value != ct2.value) {
                    rc = -1;
                }
            } else {
                rc = -1;
            }
        }
        return rc;
    }

    public int unify(Term t1, Term t2) throws PrologException {
        int undoPos = this.getUndoPosition();
        int rc = this.simpleUnify(t1, t2);
        if (rc == -1) {
            this.undo(undoPos);
        }
        return rc;
    }

    public Goal prepareGoal(Term term) {
        ReturnPoint rp = null;
        if (this.currentGoal != null) {
            rp = new ReturnPoint();
            rp.rContext = this.context;
            rp.rBacktrackInfoStack = (BacktrackInfo[])this.backtrackInfoStack.clone();
            rp.rBacktrackInfoAmount = this.backtrackInfoAmount;
            rp.rBacktrackInfoMax = this.backtrackInfoMax;
            rp.rVariables = (VariableTerm[])this.variables.clone();
            rp.rVariablesAmount = this.variablesAmount;
            rp.rUndoData = (UndoData[])this.undoData.clone();
            rp.rUndoDataAmount = this.undoDataAmount;
            rp.rUndoPositionAsked = this.undoPositionAsked;
            rp.rCurrentGoal = this.currentGoal;
        }
        this.currentGoal = new Goal(term);
        this.context.clear();
        if (rp != null) {
            this.returnPoints.put(this.currentGoal, rp);
        }
        return this.currentGoal;
    }

    public int execute(Goal goal) throws PrologException {
        int n;
        this.haltExitCode = null;
        if (this.currentGoal == null) {
            throw new IllegalStateException("The goal is not prepared");
        }
        if (this.currentGoal != goal) {
            throw new IllegalArgumentException("The goal is not currently active");
        }
        if (goal.stopped) {
            throw new Stopped();
        }
        try {
            int rc = Predicate_call.staticExecute(this, !goal.firstTime, goal.getGoal());
            switch (rc) {
                case -1: 
                case 1: {
                    goal.stopped = true;
                    this.currentGoal = null;
                    break;
                }
                case 0: {
                    goal.firstTime = false;
                }
            }
            n = rc;
        }
        catch (Throwable throwable) {
            try {
                try {
                    this.environment.getUserOutput().flushOutput(null);
                    throw throwable;
                }
                catch (RuntimeException rex) {
                    PrologException.systemError(rex);
                    throw rex;
                }
                catch (StackOverflowError se) {
                    PrologException.systemError(se);
                    throw se;
                }
            }
            catch (PrologHalt ph) {
                this.stop(goal);
                this.haltExitCode = ph;
                return -2;
            }
            catch (PrologException ex) {
                this.stop(goal);
                throw ex;
            }
        }
        this.environment.getUserOutput().flushOutput(null);
        return n;
    }

    public void stop(Goal goal) {
        if (this.currentGoal != goal) {
            throw new IllegalArgumentException("The goal is not currently active");
        }
        if (goal.stopped) {
            throw new Stopped();
        }
        int i = 0;
        while (i < this.backtrackInfoAmount) {
            this.backtrackInfoStack[i] = null;
            ++i;
        }
        this.backtrackInfoAmount = 0;
        this.currentGoal = null;
        ReturnPoint rp = this.returnPoints.get(goal);
        if (rp != null) {
            this.returnPoints.remove(rp.rCurrentGoal);
            this.context = rp.rContext;
            this.backtrackInfoStack = rp.rBacktrackInfoStack;
            this.backtrackInfoAmount = rp.rBacktrackInfoAmount;
            this.backtrackInfoMax = rp.rBacktrackInfoMax;
            this.variables = rp.rVariables;
            this.undoData = rp.rUndoData;
            this.undoDataAmount = rp.rUndoDataAmount;
            this.undoPositionAsked = rp.rUndoPositionAsked;
            this.currentGoal = rp.rCurrentGoal;
        }
    }

    public int runOnce(Term goalTerm) throws PrologException {
        Goal goal = this.prepareGoal(goalTerm);
        try {
            int rc;
            int n = rc = this.execute(goal);
            return n;
        }
        finally {
            if (!goal.stopped) {
                this.stop(goal);
            }
        }
    }

    public int getExitCode() {
        if (this.haltExitCode == null) {
            throw new IllegalStateException("Prolog Interpreter was not halted");
        }
        return this.haltExitCode.getExitCode();
    }

    public static final class Goal {
        private Term goal;
        protected boolean firstTime = true;
        protected boolean stopped = false;

        protected Goal(Term goal) {
            this.goal = goal;
        }

        protected Term getGoal() {
            return this.goal;
        }
    }

    static class ReturnPoint {
        public Map<String, Object> rContext;
        public BacktrackInfo[] rBacktrackInfoStack;
        public int rBacktrackInfoAmount;
        public int rBacktrackInfoMax;
        public VariableTerm[] rVariables;
        public int rVariablesAmount;
        public UndoData[] rUndoData;
        public int rUndoDataAmount;
        public boolean rUndoPositionAsked;
        public Goal rCurrentGoal;

        ReturnPoint() {
        }
    }

    private static class Stopped
    extends IllegalStateException {
        private static final long serialVersionUID = 1L;

        public Stopped() {
            super("The goal is already stopped");
        }
    }

    private class VariableUndoData
    implements UndoData {
        private int startPosion;

        protected VariableUndoData() {
            this.startPosion = Interpreter.this.variablesAmount;
        }

        public void undo() {
            int i = Interpreter.this.variablesAmount - 1;
            while (i >= this.startPosion) {
                Interpreter.this.variables[i].value = null;
                Interpreter.this.variables[i] = null;
                --i;
            }
            Interpreter.this.variablesAmount = this.startPosion;
        }
    }
}

