/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm;

import gnu.prolog.io.CharConversionTable;
import gnu.prolog.io.ParseException;
import gnu.prolog.io.ReadOptions;
import gnu.prolog.io.TermReader;
import gnu.prolog.io.WriteOptions;
import gnu.prolog.term.JavaObjectTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.PrologStream;
import gnu.prolog.vm.RandomAccessFileReader;
import gnu.prolog.vm.TermConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;

public class TextInputPrologStream
extends PrologStream {
    protected TermReader termReader;
    protected RandomAccessFileReader fileReader;
    private CharConversionTable charConversion;

    private TextInputPrologStream(PrologStream.OpenOptions options) {
        super(options);
        this.charConversion = this.environment.getPrologTextLoaderState().getConversionTable();
    }

    public TextInputPrologStream(PrologStream.OpenOptions options, Reader rd) throws PrologException {
        this(options);
        this.termReader = new TermReader(new BufferedReader(rd), this.environment);
    }

    public TextInputPrologStream(PrologStream.OpenOptions options, RandomAccessFile raf) {
        this(options);
        this.fileReader = new RandomAccessFileReader(raf);
        this.termReader = new TermReader(this.fileReader, this.environment);
    }

    public int getByte(Term streamTerm, Interpreter interptreter) throws PrologException {
        this.checkExists();
        PrologException.permissionError(inputAtom, TermConstants.textStreamAtom, streamTerm);
        return 0;
    }

    public int peekByte(Term streamTerm, Interpreter interptreter) throws PrologException {
        this.checkExists();
        PrologException.permissionError(inputAtom, TermConstants.textStreamAtom, streamTerm);
        return 0;
    }

    public void putByte(Term streamTerm, Interpreter interptreter, int _byte) throws PrologException {
        this.checkExists();
        PrologException.permissionError(outputAtom, TermConstants.textStreamAtom, streamTerm);
    }

    public Term getPosition(Term streamTerm, Interpreter interptreter) throws PrologException {
        this.checkExists();
        if (this.fileReader != null) {
            try {
                return new JavaObjectTerm(this.fileReader.getPosition());
            }
            catch (IOException ex) {
                this.debug(ex);
                PrologException.systemError(ex);
                return null;
            }
        }
        PrologException.permissionError(repositionAtom, TermConstants.textStreamAtom, streamTerm);
        return null;
    }

    public void setPosition(Term streamTerm, Interpreter interptreter, Term position) throws PrologException {
        this.checkExists();
        if (this.fileReader != null) {
            try {
                long pos;
                if (this.reposition == TermConstants.falseAtom) {
                    PrologException.permissionError(repositionAtom, streamAtom, this.getStreamTerm());
                }
                if (position instanceof VariableTerm) {
                    PrologException.instantiationError();
                } else if (!(position instanceof JavaObjectTerm)) {
                    PrologException.domainError(TermConstants.streamPositionAtom, position);
                }
                JavaObjectTerm jt = (JavaObjectTerm)position;
                if (!(jt.value instanceof Long)) {
                    PrologException.domainError(TermConstants.streamPositionAtom, position);
                }
                if ((pos = ((Long)jt.value).longValue()) > this.fileReader.size()) {
                    PrologException.domainError(TermConstants.streamPositionAtom, position);
                }
                this.fileReader.seek(pos);
            }
            catch (IOException ex) {
                this.debug(ex);
                PrologException.systemError(ex);
            }
            return;
        }
        PrologException.permissionError(repositionAtom, streamAtom, streamTerm);
    }

    public int getCode(Term streamTerm, Interpreter interptreter) throws PrologException {
        int rc;
        block6: {
            block5: {
                this.checkExists();
                try {
                    if (this.endOfStream != pastAtom) break block5;
                    if (this.eofAction == errorAtom) {
                        PrologException.permissionError(inputAtom, TermConstants.pastEndOfStreamAtom, streamTerm);
                        break block5;
                    }
                    if (this.eofAction != eofCodeAtom) break block5;
                    return -1;
                }
                catch (IOException ex) {
                    this.debug(ex);
                    PrologException.systemError(ex);
                    return -1;
                }
            }
            rc = this.termReader.read();
            if (rc != -1) break block6;
            this.endOfStream = pastAtom;
            return -1;
        }
        return rc;
    }

    public int peekCode(Term streamTerm, Interpreter interptreter) throws PrologException {
        int rc;
        block6: {
            block5: {
                this.checkExists();
                try {
                    if (this.endOfStream != pastAtom) break block5;
                    if (this.eofAction == errorAtom) {
                        PrologException.permissionError(inputAtom, TermConstants.pastEndOfStreamAtom, streamTerm);
                        break block5;
                    }
                    if (this.eofAction != eofCodeAtom) break block5;
                    return -1;
                }
                catch (IOException ex) {
                    this.debug(ex);
                    PrologException.systemError(ex);
                    return -1;
                }
            }
            this.termReader.mark(1);
            rc = this.termReader.read();
            this.termReader.reset();
            if (rc != -1) break block6;
            this.endOfStream = atAtom;
            return -1;
        }
        return rc;
    }

    public void putCode(Term streamTerm, Interpreter interptreter, int code) throws PrologException {
        this.checkExists();
        PrologException.permissionError(outputAtom, streamAtom, streamTerm);
    }

    public void putCodeSequence(Term streamTerm, Interpreter interptreter, String seq) throws PrologException {
        this.checkExists();
        PrologException.permissionError(outputAtom, streamAtom, streamTerm);
    }

    public Term readTerm(Term streamTerm, Interpreter interptreter, ReadOptions options) throws PrologException {
        this.checkExists();
        try {
            Term term;
            if (this.endOfStream == pastAtom) {
                if (this.eofAction == errorAtom) {
                    PrologException.permissionError(inputAtom, TermConstants.pastEndOfStreamAtom, streamTerm);
                } else if (this.eofAction == eofCodeAtom) {
                    PrologException.syntaxError(TermConstants.pastEndOfStreamAtom);
                }
            }
            if ((term = this.termReader.readTerm(options)) == null) {
                this.endOfStream = pastAtom;
                term = PrologStream.endOfFileAtom;
            } else {
                term = this.charConversion.charConvert(term, this.environment);
            }
            return term;
        }
        catch (ParseException ex) {
            this.debug(ex);
            PrologException.syntaxError(ex);
            return null;
        }
    }

    public void writeTerm(Term streamTerm, Interpreter interptreter, WriteOptions options, Term term) throws PrologException {
        this.checkExists();
        PrologException.permissionError(outputAtom, streamAtom, streamTerm);
    }

    public void flushOutput(Term streamTerm) throws PrologException {
        this.checkExists();
        PrologException.permissionError(outputAtom, streamAtom, streamTerm);
    }

    public void close(boolean force) throws PrologException {
        block2: {
            this.checkExists();
            try {
                this.termReader.close();
            }
            catch (IOException ex) {
                this.debug(ex);
                if (force) break block2;
                PrologException.systemError(ex);
            }
        }
        super.close(force);
    }

    public int getCurrentLine() {
        return this.termReader.getCurrentLine();
    }

    public int getCurrentColumn() {
        return this.termReader.getCurrentColumn();
    }
}

