
/*
    Copyright 2000  Li-Cheng (Andy) Tai

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include "util.h"

#include "clipboard.h"

#include "image_buf.h"

GdkPixbuf *clipboard = 0;
GdkPoint clipboard_pts[MAX_NUM_POINTS]; /* a temporary array for storing points */
int clipboard_num_pts;

/* taken from gd.c in gd 1.8.3 */
static int cmp_int(const void *a, const void *b)
{
	return (*(const int *)a) - (*(const int *)b);
}

static void fill_polygon(unsigned char *data, int pixelsize, int rowstride, unsigned char value[4], unsigned char mask[4], GdkPoint *pts, int num_pts, int xoffset, int yoffset)
{
   /* this assumes the data is in RGBA format, each channel takes 1 bytes (thus 4 bytes per pixel) */

   int x;
   int j;
   unsigned char *c;
   
/* taken from gd.c in gd 1.8.3 */
   
   int i;
   int y;
   int miny, maxy;
   int x1, y1;
   int x2, y2;
   int ind1, ind2;
   int ints;
   int * polyInts = 0;
   int polyAllocated = 0;
   
   assert(xoffset >= 0);
   assert(yoffset >= 0);
   
   if (!num_pts) {
	   return;
   }
   if (!polyAllocated) {
	   polyInts = (int *) malloc(sizeof(int) * num_pts);
	   polyAllocated = num_pts;
   }		

   miny = pts[0].y;
   maxy = pts[0].y;
   for (i=1; (i < num_pts); i++) {
	   if (pts[i].y < miny) {
		   miny = pts[i].y;
	   }
	   if (pts[i].y > maxy) {
		   maxy = pts[i].y;
	   }
   }
   /* Fix in 1.3: count a vertex only once */
   for (y=miny; (y <= maxy); y++) {
/*1.4		int interLast = 0; */
/*		int dirLast = 0; */
/*		int interFirst = 1; */
	   ints = 0;
	   for (i=0; (i < num_pts); i++) {
		   if (!i) {
			   ind1 = num_pts-1;
			   ind2 = 0;
		   } else {
			   ind1 = i-1;
			   ind2 = i;
		   }
		   y1 = pts[ind1].y;
		   y2 = pts[ind2].y;
		   if (y1 < y2) {
			   x1 = pts[ind1].x;
			   x2 = pts[ind2].x;
		   } else if (y1 > y2) {
			   y2 = pts[ind1].y;
			   y1 = pts[ind2].y;
			   x2 = pts[ind1].x;
			   x1 = pts[ind2].x;
		   } else {
			   continue;
		   }
		   if ((y >= y1) && (y < y2)) {
			   polyInts[ints++] = (y-y1) * (x2-x1) / (y2-y1) + x1;
		   } else if ((y == maxy) && (y > y1) && (y <= y2)) {
			   polyInts[ints++] = (y-y1) * (x2-x1) / (y2-y1) + x1;
		   }
	   }
	   qsort(polyInts, ints, sizeof(int), cmp_int);

	   for (i=0; (i < (ints)); i+=2) {
	      c = data + (y - yoffset) * rowstride + (polyInts[i] - xoffset) * pixelsize;
	      for (x = polyInts[i]; x <= polyInts[i+1] ; x++)
	      {
	         for (j = 0; j < pixelsize; j++, c++)
		 {
		    if (mask[j])
		       *c = value[j];
		 }
                 
	      }
	      
	   }
   }
   if (polyInts)
      free(polyInts);
}
   
      	 
	 
static void get_image_to_clipboard(image_buf *ibuf)
{
   GdkRectangle rect;
   unsigned char alphaonly[4] = {0, 0, 0, 1};
   unsigned char *data = 0, *c, *d;
   unsigned char default_pixel[4] = {0, 0, 0, 255};
   int x, y, i;
   int pixel_size;
   assert((ibuf->current_tool == LASSO) || (ibuf->current_tool == POLSELECT));
   rect = compute_cover_rect(ibuf->pts, ibuf->num_pts);
   
   image_buf_pixmap_to_rgbbuf(ibuf, &rect);
   
   if (clipboard)
      gdk_pixbuf_unref(clipboard);
   clipboard = gdk_pixbuf_new(GDK_COLORSPACE_RGB, TRUE, 8, rect.width, rect.height);
   assert(clipboard);
   pixel_size = gdk_pixbuf_get_n_channels(clipboard) * gdk_pixbuf_get_bits_per_sample(clipboard) / 8;
   
   gdk_pixbuf_copy_area(ibuf->rgbbuf, rect.x, rect.y, rect.width, rect.height, clipboard, 0, 0);
   data = gdk_pixbuf_get_pixels(clipboard);
   for (y = 0, c = data; y < rect.height; y++, c += gdk_pixbuf_get_rowstride(clipboard))
   {
      d = c;
      for (x = 0; x < rect.width; x++, d += pixel_size)
      {
         *(d + 3) = 0;/* default everything is transparent */
      }
   }
   
   fill_polygon(data, pixel_size, gdk_pixbuf_get_rowstride(clipboard), default_pixel, alphaonly, ibuf->pts, ibuf->num_pts, rect.x, rect.y);
   memcpy(clipboard_pts, ibuf->pts, sizeof(GdkPoint) * ibuf->num_pts);
   clipboard_num_pts = ibuf->num_pts;
   for (i = 0; i < clipboard_num_pts; i++)
   {
      clipboard_pts[i].x -= rect.x;
      clipboard_pts[i].y -= rect.y;
   }
}   
         
      

void image_buf_cut(image_buf *ibuf)
{
 
   image_buf_copy(ibuf);
   image_buf_delete(ibuf);  


}

void image_buf_copy(image_buf *ibuf)
{
   image_buf_clear_flash(ibuf);
   get_image_to_clipboard(ibuf);
}

void image_buf_delete(image_buf *ibuf)
{
   GdkGCValues gcvalues;
   GdkRectangle clientrect ;
   assert((ibuf->current_tool == LASSO) || (ibuf->current_tool == POLSELECT));
   
   
   clientrect.x = clientrect.y = 0;
   clientrect.width = image_buf_width(ibuf);
   clientrect.height = image_buf_height(ibuf);
   
   gdk_gc_get_values(ibuf->gc, &gcvalues);
   gdk_gc_set_clip_origin(ibuf->gc, 0, 0);
   gdk_gc_set_clip_rectangle(ibuf->gc, &clientrect);
   image_buf_clear_flash(ibuf);
   
   gdk_gc_set_foreground(ibuf->gc, &(gcvalues.background));
   
   gdk_draw_polygon(ibuf->pixmap, ibuf->gc, TRUE, ibuf->pts, ibuf->num_pts);
   gdk_draw_polygon(ibuf->drawing_area->window, ibuf->gc, TRUE, ibuf->pts, ibuf->num_pts);
   
   IMAGE_MODIFIED;
   image_buf_pixmap_to_rgbbuf(ibuf, 0);

   gdk_gc_set_foreground(ibuf->gc, &(gcvalues.foreground));
   
}


void image_buf_paste(image_buf *ibuf)
{
   image_buf_clear_flash(ibuf);

   image_buf_enter_paste_mode(ibuf);
   memcpy(ibuf->pts, clipboard_pts, sizeof(GdkPoint) * clipboard_num_pts);
   ibuf->num_pts = clipboard_num_pts;
   image_buf_put_clipboard_image(ibuf, 0, 0);   
}
