.TH GROHTML @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
grohtml \- HTML driver for groff
.
.
.\" license
.\"
.\" Copyright (C) 1999-2014 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" ====================================================================
.SH SYNOPSIS
.\" ====================================================================
.
.SY grohtml
.OP \-bhlnprv
.OP \-a \%aa-text-bits
.OP \-D dir
.OP \-F dir
.OP \-g \%aa-graphic-bits
.OP \-i \%resolution
.OP \-I \%image-stem
.OP \-j \%filename
.OP \-o \%image-vertical-offset
.OP \-s size
.OP \-S level
.OP \-x \%html-dialect
.RI "[\ " files\|.\|.\|. "\ ]"
.YS
.
.
.\" ====================================================================
.SH DESCRIPTION
.\" ====================================================================
.
The
.B grohtml
front end (which consists of a preprocessor,
.BR pre-grohtml ,
and a device driver,
.BR post-grohtml )
translates the output of GNU
.B troff
to HTML.
.
Users should always invoke
.B grohtml
via the groff command with a
.B \-Thtml
option.
.
If no files are given,
.B grohtml
will read the standard input.
.
A filename of
.B \-
will also cause
.B grohtml
to read the standard input.
.
Html output is written to the standard output.
.
When
.B grohtml
is run by
.B groff
options can be passed to
.B grohtml
using
.BR groff 's
.B \-P
option.
.
.
.PP
.B grohtml
invokes
.B groff
twice.
In the first pass, pictures, equations, and tables are rendered
using the
.B ps
device, and in the second pass HTML output is generated by the
.B html
device.
.
.
.PP
.B grohtml
always writes output in \%UTF-8 encoding and has built-in entities for
all non-composite unicode characters.
.
In spite of this, groff may issue warnings about unknown special
characters if they can't be found during the first pass.
.
Such warnings can be safely ignored unless the special characters
appear inside a table or equation.
.
.
.\" ====================================================================
.SH OPTIONS
.\" ====================================================================
.
.TP
.BI \-a aa-text-bits
Number of bits of antialiasing information to be used by
.I text
when generating PNG images.
.
The default is\~4 but valid values are 0, 1, 2, and\~4.
.
Note your version of
.B gs
needs to support the
.B \%\-dTextAlphaBits
and
.B \%\-dGraphicAlphaBits
options in order to exploit antialiasing.
.
A value of\~0 stops
.B grohtml
from issuing antialiasing commands to
.BR gs .
.
.TP
.B \-b
Initialize the background color to white.
.
.TP
.BI \-D dir
Inform
.B grohtml
to place all image files into directory
.IR dir .
.
.TP
.B \-e
This option should not be directly invoked by the user as it is an
internal option utilized by
.B groff
when
.B \-Thtml
or
.B \-Txhtml
is specified.
It is used by the
.B grohtml
preprocessor to determine whether
.B eqn
should attempt to produce MathML (if
.B \-Txhtml
is specified).
.
.TP
.BI \-F dir
Prepend directory
.IB dir /dev name
to the search path for font and device description files;
.I name
is the name of the device, usually
.BR html .
.
.TP
.BI \-g aa-graphic-bits
Number of bits of antialiasing information to be used by
.I graphics
when generating PNG images.
.
The default is\~4 but valid values are 0, 1, 2, and\~4.
.
Note your version of
.B gs
needs to support the
.B \%\-dTextAlphaBits
and
.B \%\-dGraphicAlphaBits
options in order to exploit antialiasing.
.
A value of\~0 stops
.B grohtml
from issuing antialiasing commands to
.BR gs .
.
.TP
.B \-h
Generate section and number headings by using
.BR <B> .\|.\|. </B>
and increasing the font size, rather than using the
.BI <H n >\c
\&.\|.\|.\c
.BI </H n >
tags.
.
.TP
.BI \-i resolution
Select the resolution for all images.
.
By default this is 100 pixels per inch.
.
Example:
.B \-i200
indicates 200 pixels per inch.
.
.TP
.BI \-I stem
Determine the image stem name.
.
If omitted grohtml uses
.BI \%grohtml- XXX
.RI ( XXX
is the process ID).
.
.TP
.BI \-j filename
Inform
.B grohtml
to split the HTML output into multiple files.
.
The
.I filename
is the stem and specified section headings (default is level one)
start a new file, named
.IR filename-n.html .
.
.TP
.B \-l
Turn off the production of automatic section links at the top of the
document.
.
.TP
.B \-n
Generate simple heading anchors whenever a section/number heading is
found.
.
Without the option the anchor value is the textual heading.
.
This can cause problems when a heading contains a \(oq?\(cqa on older
versions of some browsers (Netscape).
.
This flag is automatically turned on if a heading contains an image.
.
.TP
.BI \-o vertical-offset
Specify the vertical offset of images in points.
.
.TP
.B \-p
Display page rendering progress to stderr.
.B grohtml
only displays a page number when an image is required.
.
.TP
.B \-r
Turn off the automatic header and footer line (HTML rule).
.
.TP
.B \-s size
Set the base point size of the source file.
.
Thereafter when this point size is used in the source it will
correspond to the HTML base size.
.
Every increase of two points in the source will yield a
.B <big>
tag, and conversely when a decrease of two points is seen a
.B <small>
tag is emitted.
.
.TP
.BI \-S level
When splitting HTML output,
split at the heading level (or higher) defined by
.IR level .
.
.TP
.B \-v
Print the version number.
.
.TP
.B \-V
Create an XHTML or HTML validator button at the bottom of each page of
the document.
.
.TP
.BI \-x dialect
Select HTML dialect.
.
Currently,
.I dialect
should be either the digit\~\c
.B 4
or the letter\~\c
.B x
which indicates whether
.B grohtml
should generate HTML\~4 or XHTML, respectively.
.
This option should not be directly invoked by the user as it is
an internal option utilized by
.B groff
when
.B \-Thtml
or
.B \-Txhtml
is specified.
.
.TP
.B \-y
Produce a right-justified groff signature at the end of the document.
.
This is only generated if the
.B \-V
flag is also specified.
.
.
.\" ====================================================================
.SH USAGE
.\" ====================================================================
.
There are styles called
.BR R ,
.BR I ,
.BR B ,
and
.B BI
mounted at font positions 1 to\~4.
.
.
.\" ====================================================================
.SH DEPENDENCIES
.\" ====================================================================
.
.B grohtml
is dependent upon the PNG utilities
.RB ( \%pnmcut ,
.BR \%pnmcrop ,
.BR \%pnmtopng )
and GhostScript
.RB ( gs ).
.
.B \%pnmtopng
(version 2.37.6 or greater)
and
.B \%pnmcut
from the netpbm package (version 9.16 or greater) will work also.
.
It is also dependent upon
.B \%psselect
from the
.B PSUtils
package.
.
Images are generated whenever a table, picture, equation or line is
encountered.
.
.
.\" ====================================================================
.SH FILES
.\" ====================================================================
.
.B grohtml
uses temporary files.
.
See the
.BR groff (@MAN1EXT@)
man page for details where such files are created.
.
.
.\" ====================================================================
.SH ENVIRONMENT
.\" ====================================================================
.
.TP
.SM
.B GROFF_FONT_PATH
A list of directories in which to search for the
.BI dev name
directory in addition to the default ones.
.
See
.BR @g@troff (@MAN1EXT@)
and
.BR \%groff_font (@MAN5EXT@)
for more details.
.
.
.TP
.SM
.B SOURCE_DATE_EPOCH
A timestamp (expressed as seconds since the Unix epoch) to use as the
creation timestamp in place of the current time.
.
.
.\" ====================================================================
.SH BUGS
.\" ====================================================================
.
.B Grohtml
has been completely redesigned and rewritten.
.
It is still beta code.
.
.
.\" ====================================================================
.SH "SEE ALSO"
.\" ====================================================================
.
.BR afmtodit (@MAN1EXT@),
.BR groff (@MAN1EXT@),
.BR @g@troff (@MAN1EXT@),
.BR psbb (@MAN1EXT@),
.BR groff_out (@MAN5EXT@),
.BR groff_font (@MAN5EXT@),
.BR groff_char (@MAN7EXT@)
.
.
.\" Local Variables:
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff:
