;;; GNU Guix --- Functional package management for GNU
;;; Copyright © 2012, 2013, 2014, 2015, 2016 Ludovic Courtès <ludo@gnu.org>
;;;
;;; This file is part of GNU Guix.
;;;
;;; GNU Guix is free software; you can redistribute it and/or modify it
;;; under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 3 of the License, or (at
;;; your option) any later version.
;;;
;;; GNU Guix is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Guix.  If not, see <http://www.gnu.org/licenses/>.

(define-module (guix config)
  #:export (%guix-package-name
            %guix-version
            %guix-bug-report-address
            %guix-home-page-url

            %storedir
            %localstatedir
            %sysconfdir
            %sbindir

            %store-directory
            %state-directory
            %config-directory
            %guix-register-program

            %system
            %libgcrypt
            %libz
            %nix-instantiate
            %gzip
            %bzip2
            %xz))

;;; Commentary:
;;;
;;; Compile-time configuration of Guix.  When adding a substitution variable
;;; here, make sure to equip (guix scripts pull) to substitute it.
;;;
;;; Code:

(define %guix-package-name
  "GNU Guix")

(define %guix-version
  "0.12.0")

(define %guix-bug-report-address
  "bug-guix@gnu.org")

(define %guix-home-page-url
  "http://www.gnu.org/software/guix/")

(define %storedir
  "/gnu/store")

(define %localstatedir
  "/var")

(define %sysconfdir
  "/etc")

(define %sbindir
  "/gnu/store/dimnx4s5szziah90smi9amr1bwb0h718-guix-0.12.0-2.b291/sbin")

(define %store-directory
  (or (and=> (getenv "NIX_STORE_DIR") canonicalize-path)
      %storedir))

(define %state-directory
  ;; This must match `NIX_STATE_DIR' as defined in `nix/local.mk'.
  (or (getenv "NIX_STATE_DIR")
      (string-append %localstatedir "/guix")))

(define %config-directory
  ;; This must match `GUIX_CONFIGURATION_DIRECTORY' as defined in `nix/local.mk'.
  (or (getenv "GUIX_CONFIGURATION_DIRECTORY")
      (string-append %sysconfdir "/guix")))

(define %guix-register-program
  ;; The 'guix-register' program.
  (or (getenv "GUIX_REGISTER")
      (string-append %sbindir "/guix-register")))

(define %system
  "mips64el-linux")

(define %libgcrypt
  "/gnu/store/qjynd4zhzvf3i9m7dy56v0jyxhcg7l68-libgcrypt-1.7.3/lib/libgcrypt")

(define %libz
  "/gnu/store/x2d9wfcxa1404nii8wwg7h8j8k592076-zlib-1.2.8/lib/libz")

(define %nix-instantiate
  "nix-instantiate")

(define %gzip
  "/gnu/store/hr2d72nsp3yfiqbbcp6vxkcznmviwsv3-gzip-1.8/bin/gzip")

(define %bzip2
  "/gnu/store/j7f9g3s63rl5544yqvn3hg34w3d7jnw9-bzip2-1.0.6/bin/bzip2")

(define %xz
  "/gnu/store/26k7vwcmqrs628l1dj2rspks1fz0094v-xz-5.2.2/bin/xz")

;;; config.scm ends here
