;;; Disarchive
;;; Copyright © 2020 Timothy Sample <samplet@ngyro.com>
;;;
;;; This file is part of Disarchive.
;;;
;;; Disarchive is free software: you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation, either version 3 of the License, or
;;; (at your option) any later version.
;;;
;;; Disarchive is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with Disarchive.  If not, see <http://www.gnu.org/licenses/>.

(define-module (disarchive config)
  #:export (%tar
            %gzip
            %xz
            %zgz
            %disarchive-directory-cache))

;;; Commentary:
;;;
;;; This module provides system-specific values.
;;;
;;; Code:

(define DISARCHIVE_O_NOFOLLOW 131072)

;; Older versions of Guile do not have O_NOFOLLOW, but newer ones do.
;; Hence, we check for O_NOFOLLOW and use the Guile version if we can.
(unless (and=> (module-variable (resolve-interface '(guile)) 'O_NOFOLLOW)
               variable-bound?)
  (export (DISARCHIVE_O_NOFOLLOW . O_NOFOLLOW)))

(define %tar "/gnu/store/g2ajyl8xk9aarxrgjbng2hkj3qm2v0z2-tar-1.34/bin/tar")

(define %gzip "/gnu/store/iixwcv3k49ks1rf34pjgfzmzyhhgwng3-gzip-1.10/bin/gzip")

(define %xz "/gnu/store/c8isj4jq6knv0icfgr43di6q3nvdzkx7-xz-5.2.5/bin/xz")

(define (%zgz)
  (or (getenv "DISARCHIVE_ZGZ")
      "/gnu/store/v06gnr579r0jmr36aha3wkbd1y27ccg7-disarchive-0.4.0/libexec/disarchive-zgz"))

(define %disarchive-directory-cache (make-parameter #f))
