dnl -*- Autoconf -*-
dnl Copyright (C) 1993-2017 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License as published by the Free Software Foundation;
dnl either version 2 of the License, or (at your option) any later version.
dnl As a special exception to the GNU General Public License, this file
dnl may be distributed as part of a program that contains a configuration
dnl script generated by Autoconf, under the same distribution terms as
dnl the rest of that program.

dnl From Bruno Haible, Marcus Daniels, Sam Steingold.

AC_PREREQ([2.61])

AC_DEFUN([FFCALL_COMMON_LIBTOOL],
[
  LT_INIT([disable-shared])
])

AC_DEFUN([FFCALL_COMMON_TRAMPOLINE],
[
  AC_REQUIRE([AC_HEADER_STDC])
  AC_REQUIRE([CL_GETPAGESIZE])
  AC_REQUIRE([CL_MACH_VM])
  AC_REQUIRE([FFCALL_MMAP])
  AC_REQUIRE([FFCALL_MPROTECT])
  AC_REQUIRE([CL_SHM_H])
  AC_REQUIRE([CL_SHM])
  AC_REQUIRE([FFCALL_CODEEXEC])
  AC_REQUIRE([FFCALL_CODEEXEC_PAX])
])

AC_DEFUN([CL_CHECK],
[
  AC_CACHE_CHECK([for $2],[$3],
    [$1([AC_LANG_PROGRAM([$4],[$5])],[$3=yes],[$3=no])])
  AS_IF([test $$3 = yes], [$6], [$7])
])

AC_DEFUN([CL_LINK_CHECK],
[
  CL_CHECK([AC_LINK_IFELSE],$@)
])

dnl Expands to the "extern ..." prefix used for system declarations.
dnl AC_LANG_EXTERN
AC_DEFUN([AC_LANG_EXTERN],
[extern
#ifdef __cplusplus
"C"
#endif
])
