/* stringprep.h		Header file for stringprep functions.         -*- c -*-
 * Copyright (C) 2002, 2003  Simon Josefsson
 *
 * This file is part of GNU Libidn.
 *
 * GNU Libidn is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * GNU Libidn is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNU Libidn; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _STRINGPREP_H
#define _STRINGPREP_H

#ifdef __cplusplus
extern "C"
{
#endif

#include <stddef.h>		/* size_t */
#include <unistd.h>		/* ssize_t */

#define STRINGPREP_VERSION "0.1.9"

/* Error codes. */
  enum
  {
    STRINGPREP_OK = 0,
    /* Stringprep errors. */
    STRINGPREP_CONTAINS_UNASSIGNED = 1,
    STRINGPREP_CONTAINS_PROHIBITED = 2,
    STRINGPREP_BIDI_BOTH_L_AND_RAL = 3,
    STRINGPREP_BIDI_LEADTRAIL_NOT_RAL = 4,
    STRINGPREP_BIDI_CONTAINS_PROHIBITED = 5,
    /* Error in calling application. */
    STRINGPREP_TOO_SMALL_BUFFER = 100,
    STRINGPREP_PROFILE_ERROR = 101,
    STRINGPREP_FLAG_ERROR = 102,
    /* Internal errors. */
    STRINGPREP_NFKC_FAILED = 200,
    STRINGPREP_MALLOC_ERROR = 201
  } Stringprep_rc;

/* Flags used when calling stringprep(). */
  enum
  {
    STRINGPREP_NO_NFKC = 1,
    STRINGPREP_NO_BIDI = 2,
    STRINGPREP_NO_UNASSIGNED = 4
  } Stringprep_profile_flags;

/* Steps in a stringprep profile. */
  enum
  {
    STRINGPREP_NFKC = 1,
    STRINGPREP_BIDI = 2,
    STRINGPREP_MAP_TABLE = 3,
    STRINGPREP_UNASSIGNED_TABLE = 4,
    STRINGPREP_PROHIBIT_TABLE = 5,
    STRINGPREP_BIDI_PROHIBIT_TABLE = 6,
    STRINGPREP_BIDI_RAL_TABLE = 7,
    STRINGPREP_BIDI_L_TABLE = 8
  } Stringprep_profile_steps;

#define STRINGPREP_MAX_MAP_CHARS 4

  struct Stringprep_table_element
  {
    unsigned long start;
    unsigned long end;				/* 0 if only one character */
    unsigned long map[STRINGPREP_MAX_MAP_CHARS];/* NULL if end is not 0 */
  };
  typedef struct Stringprep_table_element Stringprep_table_element;

  struct Stringprep_table
  {
    int operation;
    int flags;
    Stringprep_table_element *table;
    char *name;
  };
  typedef struct Stringprep_table Stringprep_profile;

/* API */

  extern int stringprep (char *in, size_t maxlen, int flags,
			 Stringprep_profile * profile);

  extern const char *stringprep_check_version (const char *req_version);

/* Utility */

  extern int stringprep_unichar_to_utf8 (unsigned long c, char *outbuf);
  extern unsigned long stringprep_utf8_to_unichar (const char *p);

  extern unsigned long *stringprep_utf8_to_ucs4 (const char *str, ssize_t len,
						 size_t *items_written);
  extern char *stringprep_ucs4_to_utf8 (const unsigned long *str, ssize_t len,
					size_t *items_read,
					size_t *items_written);

  extern char *stringprep_utf8_nfkc_normalize (const char *str, ssize_t len);
  extern unsigned long *stringprep_ucs4_nfkc_normalize (unsigned long *str,
							ssize_t len);

  extern const char *stringprep_locale_charset (void);
  extern char *stringprep_convert (const char *str,
				   const char *to_codeset,
				   const char *from_codeset);
  extern char *stringprep_locale_to_utf8 (const char *str);
  extern char *stringprep_utf8_to_locale (const char *str);

#ifdef __cplusplus
}
#endif
#endif				/* _STRINGPREP_H */
