/*
  File autogenerated by gengetopt version 2.10
  generated with the following command:
  gengetopt --input idn.ggo --file-name ./idn_cmd 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "getopt.h"

#include "./idn_cmd.h"

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
  "Purpose:\n"
  "  Command line interface to the internationalized domain name library.\n"
  "  \n"
  "  Valid stringprep profiles are 'generic', 'Nameprep', 'KRBprep', 'Nodeprep',\n"
  "  'Resourceprep', 'plain', 'SASLprep', and 'ISCSIprep'.\n"
  "\n"
  "Usage: %s [OPTIONS]...\n", CMDLINE_PARSER_PACKAGE);
  printf("   -h         --help                Print help and exit\n");
  printf("   -V         --version             Print version and exit\n");
  printf("   -s         --stringprep          Prepare string according to nameprep profile\n");
  printf("   -d         --punycode-decode     Decode Punycode\n");
  printf("   -e         --punycode-encode     Encode Punycode\n");
  printf("   -a         --idna-to-ascii       Convert to ACE according to IDNA\n");
  printf("   -u         --idna-to-unicode     Convert from ACE according to IDNA\n");
  printf("              --allow-unassigned    Toggle IDNA AllowUnassigned flag (default=off)\n");
  printf("              --usestd3asciirules   Toggle IDNA UseSTD3ASCIIRules flag (default=off)\n");
  printf("   -pSTRING   --profile=STRING      Use specified stringprep profile instead\n");
  printf("              --debug               Print debugging information (default=off)\n");
  printf("              --quiet               Don't print the welcome greeting (default=off)\n");
}


static char *gengetopt_strdup (const char *s);

/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  int c;	/* Character of the parsed option.  */
  int missing_required_options = 0;

  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->stringprep_given = 0 ;
  args_info->punycode_decode_given = 0 ;
  args_info->punycode_encode_given = 0 ;
  args_info->idna_to_ascii_given = 0 ;
  args_info->idna_to_unicode_given = 0 ;
  args_info->allow_unassigned_given = 0 ;
  args_info->usestd3asciirules_given = 0 ;
  args_info->profile_given = 0 ;
  args_info->debug_given = 0 ;
  args_info->quiet_given = 0 ;
#define clear_args() { \
  args_info->allow_unassigned_flag = 0;\
  args_info->usestd3asciirules_flag = 0;\
  args_info->profile_arg = NULL; \
  args_info->debug_flag = 0;\
  args_info->quiet_flag = 0;\
}

  clear_args();

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "stringprep",	0, NULL, 's' },
        { "punycode-decode",	0, NULL, 'd' },
        { "punycode-encode",	0, NULL, 'e' },
        { "idna-to-ascii",	0, NULL, 'a' },
        { "idna-to-unicode",	0, NULL, 'u' },
        { "allow-unassigned",	0, NULL, 0 },
        { "usestd3asciirules",	0, NULL, 0 },
        { "profile",	1, NULL, 'p' },
        { "debug",	0, NULL, 0 },
        { "quiet",	0, NULL, 0 },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVsdeaup:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          clear_args ();
          cmdline_parser_print_help ();
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          clear_args ();
          cmdline_parser_print_version ();
          exit (EXIT_SUCCESS);

        case 's':	/* Prepare string according to nameprep profile.  */
          if (args_info->stringprep_given)
            {
              fprintf (stderr, "%s: `--stringprep' (`-s') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->stringprep_given = 1;
          break;

        case 'd':	/* Decode Punycode.  */
          if (args_info->punycode_decode_given)
            {
              fprintf (stderr, "%s: `--punycode-decode' (`-d') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->punycode_decode_given = 1;
          break;

        case 'e':	/* Encode Punycode.  */
          if (args_info->punycode_encode_given)
            {
              fprintf (stderr, "%s: `--punycode-encode' (`-e') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->punycode_encode_given = 1;
          break;

        case 'a':	/* Convert to ACE according to IDNA.  */
          if (args_info->idna_to_ascii_given)
            {
              fprintf (stderr, "%s: `--idna-to-ascii' (`-a') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->idna_to_ascii_given = 1;
          break;

        case 'u':	/* Convert from ACE according to IDNA.  */
          if (args_info->idna_to_unicode_given)
            {
              fprintf (stderr, "%s: `--idna-to-unicode' (`-u') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->idna_to_unicode_given = 1;
          break;

        case 'p':	/* Use specified stringprep profile instead.  */
          if (args_info->profile_given)
            {
              fprintf (stderr, "%s: `--profile' (`-p') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->profile_given = 1;
          args_info->profile_arg = gengetopt_strdup (optarg);
          break;


        case 0:	/* Long option with no short option */
          /* Toggle IDNA AllowUnassigned flag.  */
          if (strcmp (long_options[option_index].name, "allow-unassigned") == 0)
          {
            if (args_info->allow_unassigned_given)
              {
                fprintf (stderr, "%s: `--allow-unassigned' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->allow_unassigned_given = 1;
            args_info->allow_unassigned_flag = !(args_info->allow_unassigned_flag);
            break;
          }
          
          /* Toggle IDNA UseSTD3ASCIIRules flag.  */
          else if (strcmp (long_options[option_index].name, "usestd3asciirules") == 0)
          {
            if (args_info->usestd3asciirules_given)
              {
                fprintf (stderr, "%s: `--usestd3asciirules' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->usestd3asciirules_given = 1;
            args_info->usestd3asciirules_flag = !(args_info->usestd3asciirules_flag);
            break;
          }
          
          /* Print debugging information.  */
          else if (strcmp (long_options[option_index].name, "debug") == 0)
          {
            if (args_info->debug_given)
              {
                fprintf (stderr, "%s: `--debug' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->debug_given = 1;
            args_info->debug_flag = !(args_info->debug_flag);
            break;
          }
          
          /* Don't print the welcome greeting.  */
          else if (strcmp (long_options[option_index].name, "quiet") == 0)
          {
            if (args_info->quiet_given)
              {
                fprintf (stderr, "%s: `--quiet' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->quiet_given = 1;
            args_info->quiet_flag = !(args_info->quiet_flag);
            break;
          }
          

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          exit (EXIT_FAILURE);

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c\n", CMDLINE_PARSER_PACKAGE, c);
          abort ();
        } /* switch */
    } /* while */


  if ( missing_required_options )
    exit (EXIT_FAILURE);

  return 0;
}
