////////////////////////////////////////////////////////////////////////
//
// Copyright (C) 1993-2020 The Octave Project Developers
//
// See the file COPYRIGHT.md in the top-level directory of this
// distribution or <https://octave.org/copyright/>.
//
// This file is part of Octave.
//
// Octave is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Octave is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Octave; see the file COPYING.  If not, see
// <https://www.gnu.org/licenses/>.
//
////////////////////////////////////////////////////////////////////////

#if defined (HAVE_CONFIG_H)
#  include "config.h"
#endif

#if defined (HAVE_PRAGMA_GCC_DIAGNOSTIC)
   // This one needs to be global.
#  pragma GCC diagnostic ignored "-Wunused-function"
   // Disable these warnings for code that is generated by flex,
   // including pattern rules.  Push the current state so we can
   // restore the warning state prior to functions we define at
   // the bottom of the file.
#  pragma GCC diagnostic push
#  pragma GCC diagnostic ignored "-Wold-style-cast"
#  pragma GCC diagnostic ignored "-Wsign-compare"
#  pragma GCC diagnostic ignored "-Wzero-as-null-pointer-constant"
#  if defined (HAVE_WARN_IMPLICIT_FALLTHROUGH)
#    pragma GCC diagnostic ignored "-Wimplicit-fallthrough"
#  endif
#endif

// Define away the deprecated register storage class specifier to avoid
// potential warnings about it.
#if ! defined (register)
#  define register
#endif

#line 53 "libinterp/parse-tree/lex.cc"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

#ifdef yy_create_buffer
#define octave__create_buffer_ALREADY_DEFINED
#else
#define yy_create_buffer octave__create_buffer
#endif

#ifdef yy_delete_buffer
#define octave__delete_buffer_ALREADY_DEFINED
#else
#define yy_delete_buffer octave__delete_buffer
#endif

#ifdef yy_scan_buffer
#define octave__scan_buffer_ALREADY_DEFINED
#else
#define yy_scan_buffer octave__scan_buffer
#endif

#ifdef yy_scan_string
#define octave__scan_string_ALREADY_DEFINED
#else
#define yy_scan_string octave__scan_string
#endif

#ifdef yy_scan_bytes
#define octave__scan_bytes_ALREADY_DEFINED
#else
#define yy_scan_bytes octave__scan_bytes
#endif

#ifdef yy_init_buffer
#define octave__init_buffer_ALREADY_DEFINED
#else
#define yy_init_buffer octave__init_buffer
#endif

#ifdef yy_flush_buffer
#define octave__flush_buffer_ALREADY_DEFINED
#else
#define yy_flush_buffer octave__flush_buffer
#endif

#ifdef yy_load_buffer_state
#define octave__load_buffer_state_ALREADY_DEFINED
#else
#define yy_load_buffer_state octave__load_buffer_state
#endif

#ifdef yy_switch_to_buffer
#define octave__switch_to_buffer_ALREADY_DEFINED
#else
#define yy_switch_to_buffer octave__switch_to_buffer
#endif

#ifdef yypush_buffer_state
#define octave_push_buffer_state_ALREADY_DEFINED
#else
#define yypush_buffer_state octave_push_buffer_state
#endif

#ifdef yypop_buffer_state
#define octave_pop_buffer_state_ALREADY_DEFINED
#else
#define yypop_buffer_state octave_pop_buffer_state
#endif

#ifdef yyensure_buffer_stack
#define octave_ensure_buffer_stack_ALREADY_DEFINED
#else
#define yyensure_buffer_stack octave_ensure_buffer_stack
#endif

#ifdef yylex
#define octave_lex_ALREADY_DEFINED
#else
#define yylex octave_lex
#endif

#ifdef yyrestart
#define octave_restart_ALREADY_DEFINED
#else
#define yyrestart octave_restart
#endif

#ifdef yylex_init
#define octave_lex_init_ALREADY_DEFINED
#else
#define yylex_init octave_lex_init
#endif

#ifdef yylex_init_extra
#define octave_lex_init_extra_ALREADY_DEFINED
#else
#define yylex_init_extra octave_lex_init_extra
#endif

#ifdef yylex_destroy
#define octave_lex_destroy_ALREADY_DEFINED
#else
#define yylex_destroy octave_lex_destroy
#endif

#ifdef yyget_debug
#define octave_get_debug_ALREADY_DEFINED
#else
#define yyget_debug octave_get_debug
#endif

#ifdef yyset_debug
#define octave_set_debug_ALREADY_DEFINED
#else
#define yyset_debug octave_set_debug
#endif

#ifdef yyget_extra
#define octave_get_extra_ALREADY_DEFINED
#else
#define yyget_extra octave_get_extra
#endif

#ifdef yyset_extra
#define octave_set_extra_ALREADY_DEFINED
#else
#define yyset_extra octave_set_extra
#endif

#ifdef yyget_in
#define octave_get_in_ALREADY_DEFINED
#else
#define yyget_in octave_get_in
#endif

#ifdef yyset_in
#define octave_set_in_ALREADY_DEFINED
#else
#define yyset_in octave_set_in
#endif

#ifdef yyget_out
#define octave_get_out_ALREADY_DEFINED
#else
#define yyget_out octave_get_out
#endif

#ifdef yyset_out
#define octave_set_out_ALREADY_DEFINED
#else
#define yyset_out octave_set_out
#endif

#ifdef yyget_leng
#define octave_get_leng_ALREADY_DEFINED
#else
#define yyget_leng octave_get_leng
#endif

#ifdef yyget_text
#define octave_get_text_ALREADY_DEFINED
#else
#define yyget_text octave_get_text
#endif

#ifdef yyget_lineno
#define octave_get_lineno_ALREADY_DEFINED
#else
#define yyget_lineno octave_get_lineno
#endif

#ifdef yyset_lineno
#define octave_set_lineno_ALREADY_DEFINED
#else
#define yyset_lineno octave_set_lineno
#endif

#ifdef yyget_column
#define octave_get_column_ALREADY_DEFINED
#else
#define yyget_column octave_get_column
#endif

#ifdef yyset_column
#define octave_set_column_ALREADY_DEFINED
#else
#define yyset_column octave_set_column
#endif

#ifdef yywrap
#define octave_wrap_ALREADY_DEFINED
#else
#define yywrap octave_wrap
#endif

#ifdef yyget_lval
#define octave_get_lval_ALREADY_DEFINED
#else
#define yyget_lval octave_get_lval
#endif

#ifdef yyset_lval
#define octave_set_lval_ALREADY_DEFINED
#else
#define yyset_lval octave_set_lval
#endif

#ifdef yyalloc
#define octave_alloc_ALREADY_DEFINED
#else
#define yyalloc octave_alloc
#endif

#ifdef yyrealloc
#define octave_realloc_ALREADY_DEFINED
#else
#define yyrealloc octave_realloc
#endif

#ifdef yyfree
#define octave_free_ALREADY_DEFINED
#else
#define yyfree octave_free
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin , yyscanner )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

void yyrestart ( FILE *input_file , yyscan_t yyscanner );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size , yyscan_t yyscanner );
void yy_delete_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yy_flush_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
void yypop_buffer_state ( yyscan_t yyscanner );

static void yyensure_buffer_stack ( yyscan_t yyscanner );
static void yy_load_buffer_state ( yyscan_t yyscanner );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file , yyscan_t yyscanner );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER , yyscanner)

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len , yyscan_t yyscanner );

void *yyalloc ( yy_size_t , yyscan_t yyscanner );
void *yyrealloc ( void *, yy_size_t , yyscan_t yyscanner );
void yyfree ( void * , yyscan_t yyscanner );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define octave_wrap(yyscanner) (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

typedef int yy_state_type;

#define yytext_ptr yytext_r

static yy_state_type yy_get_previous_state ( yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  , yyscan_t yyscanner);
static int yy_get_next_buffer ( yyscan_t yyscanner );
static void yynoreturn yy_fatal_error ( const char* msg , yyscan_t yyscanner );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yyg->yy_c_buf_p = yy_cp;
#define YY_NUM_RULES 122
#define YY_END_OF_BUFFER 123
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_accept[302] =
    {   0,
        0,    0,    5,    5,   10,   10,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  123,  121,
       53,   63,   63,   94,   65,  121,   58,   79,   64,   99,
      100,   83,   91,   95,   92,  101,   84,   52,   52,   66,
       90,   81,  102,   82,  121,   61,   14,   85,   15,   86,
       58,   58,  119,   80,  120,   93,   53,  121,    9,    8,
        3,    3,    7,  122,    5,    6,    4,    9,   10,   11,
       11,   12,   13,   10,    1,    1,  122,   19,   19,  122,
      122,   23,   23,   23,   23,   23,   23,   40,   41,   41,
       25,   39,  122,   44,   45,   45,   43,   49,   47,   49,

       46,   49,   53,    0,   63,   76,    0,   20,   20,    0,
       58,    0,    0,   88,  117,   87,  105,   97,  103,   98,
      104,   96,   69,   67,   68,    0,   70,   52,   71,   72,
      106,   52,   52,    0,    0,   50,    0,   74,   75,   78,
        0,   60,    0,   62,    0,   55,   55,    0,  107,  113,
       58,   58,  118,   89,   77,   53,    0,    0,    9,    8,
        3,    0,    3,    5,    6,    0,   10,   11,   10,    1,
        0,   19,   19,    0,    0,    0,    0,    0,    0,   23,
        0,   22,   22,    0,    0,    0,   40,   41,   24,    0,
       38,   38,   37,   37,   26,   28,   29,   30,   31,   32,

       33,   34,   38,   44,   45,   42,   47,   49,    0,   46,
        0,    0,    0,    0,    0,   59,  114,   73,  110,  108,
      109,    0,  111,   52,    0,  112,  115,   51,   52,   52,
        0,   52,   52,    0,   60,    0,    0,   62,    0,    0,
       56,   56,   58,    0,   16,   16,    0,    0,   17,   17,
        0,   18,   18,    0,   21,   21,    0,    0,   36,   36,
       26,   27,    0,   46,    0,    0,    0,   59,    0,  116,
        0,   54,   54,    0,   52,   52,   52,    0,   60,    0,
       62,    0,   57,    0,    2,    2,    0,   35,   35,   26,
       46,    0,   48,   48,    0,   59,   52,   60,   62,   59,

        0
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    5,    6,    7,    8,    7,    9,   10,   11,
       12,   13,   14,   15,   16,   17,   18,   19,   20,   21,
       21,   21,   21,   21,   21,   22,   22,   23,   24,   25,
       26,   27,   28,   29,   30,   31,   30,   32,   32,   30,
        8,    8,   33,   33,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,   34,    8,    8,
       35,   36,   37,   38,   39,    1,   40,   41,   30,   32,

       42,   43,   44,    8,   33,   33,    8,    8,    8,   45,
        8,    8,    8,   46,   47,   48,    8,   49,    8,   50,
        8,    8,   51,   52,   53,   54,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static const YY_CHAR yy_meta[55] =
    {   0,
        1,    2,    3,    3,    1,    4,    5,    6,    1,    7,
        5,    5,    1,    1,    5,    1,    8,    1,    9,    9,
        9,    9,    1,    5,    1,    1,    1,    1,   10,   11,
       11,   11,   12,    6,    5,   13,    5,    1,   12,   11,
       11,   11,   11,    6,    6,    6,    6,    6,    6,    6,
        5,    1,    5,    1
    } ;

static const flex_int16_t yy_base[341] =
    {   0,
        0,   53,   59,  111,   54,   83,  814,  812,   64,   75,
       91,   95,  102,  127,  137,  139,  164,    0,  815, 1029,
       57, 1029,  811,  784, 1029,   69,   87,   66, 1029, 1029,
     1029,   75,  111, 1029,  108,  209,  781,  231,  205, 1029,
     1029,  779,  778,  777,  793,  789, 1029,  230, 1029,  745,
      240,  242, 1029,   77, 1029,  741,  125,  217,    0,  764,
     1029,  716, 1029,   77,  232,  223, 1029,  701,  143, 1029,
      713, 1029, 1029,  149, 1029,  712,  149, 1029,  711,  283,
      271, 1029,  152,  710,  154,  153,  237,    0, 1029,  706,
      702,  690,  323,    0, 1029,  703,  694, 1029,  701,  699,

      275,  681,  247,  275, 1029, 1029,  290, 1029,  694,  278,
      287,  694,  693, 1029, 1029,  667, 1029, 1029, 1029, 1029,
     1029, 1029,  283,  666,  665,  667,  656,  278,  655,  654,
     1029,  364,    0,  282,  314, 1029,    0, 1029, 1029, 1029,
      584,  289,  583,  301,  343, 1029,  581,  309, 1029, 1029,
      312,  350, 1029, 1029, 1029,  259,  336,  351,    0,  581,
     1029,  328,  579,  327,  339,  563,  354, 1029,  363, 1029,
      345, 1029,  573,  386,  354,  406,  409,  373,  391, 1029,
      411, 1029,  572,  397,  413,  416,    0, 1029, 1029,  557,
     1029,  419, 1029,  560,  405, 1029, 1029, 1029, 1029, 1029,

     1029, 1029,    0,    0, 1029, 1029,  531, 1029,  306,  425,
      493,  466,  475,  426,  468,  427, 1029,  419, 1029, 1029,
     1029,  427, 1029,  414,  438, 1029, 1029, 1029,  429,  446,
      418,  453,  408,  461,  465,  430,  467,  474,  399,  477,
     1029,  388,  485,  486, 1029,  378,  490,  495, 1029,  356,
      501, 1029,  334,  504, 1029,  316,  507,  513, 1029,  312,
      499,    0,  303,  510,  497,  511,  519,  520,  256, 1029,
      520, 1029,  235,  510,  522,  526,  191,  159,  532,  137,
      533,  549, 1029,  522, 1029,  108,  550, 1029,  106, 1029,
      554,  535, 1029,   97,   82,  555,  548,  556,  560,  562,

     1029,  587,  600,  613,  626,  639,  652,  665,  677,  688,
      699,  711,  724,  737,  750,  763,  775,  788,  800,  811,
      822,  826,  836,  847,  859,  864,  874,  885,  896,  908,
      913,  924,  935,  947,  959,  971,  983,  994, 1005, 1016
    } ;

static const flex_int16_t yy_def[341] =
    {   0,
      301,    1,  302,  302,    1,    1,  303,  303,  304,  304,
      305,  305,  306,  306,  307,  307,  301,   17,  301,  301,
      301,  301,  301,  301,  301,  308,  309,  301,  301,  301,
      301,  301,  301,  301,  301,  301,  301,  301,   38,  301,
      301,  301,  301,  301,  310,  311,  301,  301,  301,  301,
      309,  309,  301,  301,  301,  301,  301,  308,  312,  301,
      301,  301,  301,  313,  301,  301,  301,  301,  301,  301,
      301,  301,  301,  301,  301,  301,  314,  301,  301,  314,
      314,  301,  301,  301,  315,  301,  315,  316,  301,  301,
      301,  301,  317,  318,  301,  301,  301,  301,  301,  301,

      319,  301,  301,  308,  301,  301,  308,  301,  301,  301,
      309,  320,  321,  301,  301,  301,  301,  301,  301,  301,
      301,  301,  301,  301,  301,  301,  301,  301,  301,  301,
      301,  301,   39,  301,  301,  301,  322,  301,  301,  301,
      310,  323,  311,  324,  301,  301,  301,  325,  301,  301,
      309,  309,  301,  301,  301,  301,  308,  308,  312,  301,
      301,  313,  301,  301,  301,  301,  301,  301,  301,  301,
      314,  301,  301,  314,  314,  314,  314,  301,  315,  301,
      315,  301,  301,  301,  315,  315,  316,  301,  301,  301,
      301,  301,  301,  301,  301,  301,  301,  301,  301,  301,

      301,  301,  326,  318,  301,  301,  301,  301,  301,  319,
      327,  301,  320,  328,  321,  329,  301,  301,  301,  301,
      301,  330,  301,  301,  301,  301,  301,  301,  301,  301,
      301,  301,  331,  301,  323,  332,  301,  324,  333,  325,
      301,  301,  309,  308,  301,  301,  334,  314,  301,  301,
      314,  301,  301,  315,  301,  301,  301,  301,  301,  301,
      301,  326,  327,  335,  336,  328,  301,  329,  337,  301,
      330,  301,  301,  301,  301,  301,  331,  332,  338,  333,
      339,  301,  301,  334,  301,  301,  301,  301,  301,  301,
      335,  336,  301,  301,  337,  340,  301,  338,  339,  340,

        0,  301,  301,  301,  301,  301,  301,  301,  301,  301,
      301,  301,  301,  301,  301,  301,  301,  301,  301,  301,
      301,  301,  301,  301,  301,  301,  301,  301,  301,  301,
      301,  301,  301,  301,  301,  301,  301,  301,  301,  301
    } ;

static const flex_int16_t yy_nxt[1084] =
    {   0,
       20,   21,   22,   23,   24,   25,   26,   27,   28,   29,
       30,   31,   32,   33,   34,   35,   36,   37,   38,   39,
       39,   39,   40,   41,   42,   43,   44,   45,   46,   27,
       27,   27,   27,   27,   47,   48,   49,   50,   27,   27,
       27,   27,   27,   51,   27,   27,   52,   27,   27,   27,
       53,   54,   55,   56,   57,   69,   70,   71,  103,   58,
       60,   61,   62,  104,   63,   64,   78,   79,   63,   65,
       66,  108,  109,   67,  114,   68,   80,   78,   79,  161,
      163,   81,   67,  295,   74,   70,   71,  116,  110,   58,
       72,  115,   83,   65,   84,   66,   86,   85,   84,  293,

      117,   87,  153,  112,   89,   90,   73,   91,  288,   65,
      285,   66,   60,   61,   62,  113,   63,   64,   92,   72,
       63,   65,   66,  120,  118,   67,  156,   68,  154,   89,
       90,  157,   91,  121,   67,   73,  119,   93,  280,   95,
       96,   95,   96,   92,  167,   65,   97,   66,   97,  104,
      169,  172,  173,  178,  184,  157,  182,  183,  179,  185,
      278,   65,   93,   66,   98,   99,   98,  100,   98,   98,
       98,  101,   98,   98,   98,   98,   98,   98,   98,   98,
      102,   98,   98,   98,   98,   98,   98,   98,   98,   98,
       98,   98,   98,  101,  101,  101,  101,  101,   98,   98,

       98,   98,  101,  101,  101,  101,  101,  101,  101,  101,
      101,  101,  101,  101,   98,   98,   98,   98,  122,  108,
      109,  123,  124,  136,  125,  126,  127,  128,  128,  128,
      128,  145,  146,  147,  165,  301,  148,  272,  301,  182,
      183,  110,  164,  110,  129,  301,  130,  132,  103,  133,
      133,  133,  133,  104,  301,  149,  112,  295,  112,  165,
      156,  134,  135,  136,  137,  157,  164,  158,  113,  133,
      113,  134,  135,  172,  173,  165,  209,  108,  109,  110,
      137,  151,  164,  152,  174,  172,  173,  186,  110,  175,
      234,  211,  108,  109,  112,  218,  224,  224,  224,  224,

      230,  230,  237,  112,  263,  236,  113,  209,  219,  225,
      136,  241,  242,  110,  259,  113,  224,  239,  255,  225,
      230,  176,  211,  177,  192,  193,  194,  231,  112,  231,
      161,  163,  232,  232,  232,  232,  252,  164,  108,  109,
      113,  195,  195,  195,  145,  146,  147,  172,  173,  148,
      165,  110,  244,  245,  246,  167,  172,  173,  249,  243,
      104,  164,  196,  197,  169,  198,  112,  199,  200,  157,
      201,  202,  203,  228,  178,  165,  228,  164,  113,  179,
      245,  228,  229,  229,  229,  229,  158,  174,  172,  173,
      241,  165,  175,  182,  183,  135,  136,  243,  184,  228,

      280,  228,  229,  185,  176,  135,  177,  248,  249,  250,
      251,  252,  253,  182,  183,  182,  183,  254,  255,  256,
      258,  259,  260,  261,  261,  261,  209,  110,  267,  272,
      273,  278,  224,  224,  224,  224,  232,  232,  232,  232,
      136,  211,  112,  269,  270,  225,  136,  229,  229,  229,
      229,  274,  224,  274,  113,  225,  275,  275,  275,  275,
      135,  136,  234,  186,  230,  230,  234,  229,  237,  215,
      135,  276,  276,  276,  276,  237,  213,  236,  136,  241,
      242,  236,  265,  239,  230,  136,  282,  244,  245,  246,
      239,  276,  285,  286,  263,  283,  248,  249,  250,  293,

      294,  112,  251,  252,  253,  254,  255,  256,  287,  288,
      289,  209,  110,  113,  258,  259,  260,  290,  290,  290,
      267,  267,  272,  273,  285,  286,  211,  112,  275,  275,
      275,  275,  207,  234,  237,  269,  269,  293,  294,  113,
      297,  297,  297,  297,  276,  276,  276,  276,  236,  239,
      282,  287,  288,  289,  136,  209,  267,  234,  136,  283,
      297,  237,  193,  267,  276,  112,  297,  297,  297,  297,
      211,  269,  236,  257,  182,  172,  239,  113,  269,  247,
      136,  161,  160,  146,  143,  141,  297,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,

       75,   75,   75,   75,   75,   75,   75,   75,   75,   75,
       75,   75,   75,   77,   77,   77,   77,   77,   77,   77,
       77,   77,   77,   77,   77,   77,   82,   82,   82,   82,
       82,   82,   82,   82,   82,   82,   82,   82,   82,   88,
       88,   88,   88,   88,   88,   88,   88,   88,   88,   88,
       88,   88,   94,   94,   94,   94,   94,   94,   94,   94,
       94,   94,   94,   94,   94,  107,  107,  107,  107,  107,
      107,  107,  107,  107,  107,  107,  107,  107,  111,  227,
      226,  223,  111,  222,  111,  111,  111,  111,  111,  142,
      221,  220,  217,  142,  215,  213,  108,  212,  142,  142,

      144,  208,  207,  206,  144,  205,  190,  189,  188,  144,
      144,  159,  180,  172,  170,  168,  159,  166,  161,  159,
      159,  159,  159,  159,  162,  162,  162,  162,  162,  162,
      162,  162,  162,  162,  162,  162,  162,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      181,  181,  181,  181,  181,  181,  181,  181,  181,  181,
      181,  181,  181,  187,  187,  160,  155,  187,  187,  187,
      150,  187,  187,  187,  187,  191,  191,  191,  191,  191,
      191,  191,  191,  191,  191,  191,  191,  191,  204,  204,
      143,  204,  204,  204,  141,  204,  204,  204,  204,  204,

      204,  210,  140,  139,  138,  210,  131,  210,  210,  106,
      210,  210,  214,  105,  301,   76,  214,   76,  301,  301,
      301,  214,  214,  216,  301,  301,  301,  216,  301,  301,
      301,  301,  216,  216,  233,  301,  233,  235,  301,  301,
      301,  235,  301,  235,  235,  301,  235,  235,  238,  301,
      301,  301,  238,  301,  238,  238,  301,  238,  238,  240,
      240,  240,  240,  240,  240,  240,  240,  240,  240,  240,
      240,  240,  262,  301,  262,  264,  301,  301,  301,  264,
      301,  301,  301,  301,  264,  264,  266,  301,  301,  301,
      266,  301,  266,  266,  266,  266,  266,  268,  301,  301,

      301,  268,  301,  268,  268,  301,  268,  268,  271,  271,
      271,  271,  271,  271,  271,  271,  271,  271,  271,  271,
      271,  277,  301,  277,  277,  279,  301,  301,  301,  279,
      301,  301,  301,  301,  279,  279,  281,  301,  301,  301,
      281,  301,  301,  301,  301,  281,  281,  284,  284,  284,
      284,  284,  284,  284,  284,  284,  284,  284,  284,  284,
      291,  301,  301,  301,  291,  301,  291,  291,  301,  291,
      291,  292,  292,  292,  292,  292,  292,  292,  292,  292,
      292,  292,  292,  292,  296,  301,  301,  301,  296,  301,
      301,  301,  301,  296,  296,  298,  301,  301,  301,  298,

      301,  298,  298,  301,  298,  298,  299,  301,  301,  301,
      299,  301,  299,  299,  301,  299,  299,  300,  301,  301,
      301,  300,  301,  300,  300,  301,  300,  300,   19,  301,
      301,  301,  301,  301,  301,  301,  301,  301,  301,  301,
      301,  301,  301,  301,  301,  301,  301,  301,  301,  301,
      301,  301,  301,  301,  301,  301,  301,  301,  301,  301,
      301,  301,  301,  301,  301,  301,  301,  301,  301,  301,
      301,  301,  301,  301,  301,  301,  301,  301,  301,  301,
      301,  301,  301
    } ;

static const flex_int16_t yy_chk[1084] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    2,    5,    5,    5,   21,    2,
        3,    3,    3,   21,    3,    3,    9,    9,    3,    3,
        3,   26,   26,    3,   28,    3,   10,   10,   10,   64,
       64,   10,    3,  295,    6,    6,    6,   32,   27,    6,
        5,   28,   11,    3,   11,    3,   12,   11,   12,  294,

       32,   12,   54,   27,   13,   13,    5,   13,  289,    3,
      286,    3,    4,    4,    4,   27,    4,    4,   13,    6,
        4,    4,    4,   35,   33,    4,   57,    4,   54,   14,
       14,   57,   14,   35,    4,    6,   33,   13,  280,   15,
       15,   16,   16,   14,   69,    4,   15,    4,   16,   69,
       74,   77,   77,   83,   86,   74,   85,   85,   83,   86,
      278,    4,   14,    4,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,

       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   36,   58,
       58,   36,   36,  277,   36,   36,   36,   36,   36,   36,
       36,   48,   48,   48,   66,   39,   48,  273,   39,   87,
       87,   51,   65,   52,   36,   39,   36,   38,  103,   38,
       38,   38,   38,  103,   39,   48,   51,  269,   52,   66,
      156,   38,   38,   38,   38,  156,   65,   58,   51,   38,
       52,   38,   38,   81,   81,   66,  101,  104,  104,  110,
       38,   51,   65,   52,   80,   80,   80,   87,  111,   80,
      142,  101,  107,  107,  110,  123,  128,  128,  128,  128,

      134,  134,  144,  111,  263,  142,  110,  209,  123,  128,
      128,  148,  148,  151,  260,  111,  128,  144,  256,  128,
      134,   81,  209,   81,   93,   93,   93,  135,  151,  135,
      162,  162,  135,  135,  135,  135,  253,  164,  157,  157,
      151,   93,   93,   93,  145,  145,  145,  171,  171,  145,
      165,  152,  158,  158,  158,  167,  175,  175,  250,  151,
      167,  164,   93,   93,  169,   93,  152,   93,   93,  169,
       93,   93,   93,  132,  178,  165,  132,  164,  152,  178,
      246,  132,  132,  132,  132,  132,  157,  174,  174,  174,
      242,  165,  174,  179,  179,  132,  132,  152,  184,  132,

      239,  132,  132,  184,  175,  132,  175,  176,  176,  176,
      177,  177,  177,  181,  181,  185,  185,  186,  186,  186,
      192,  192,  192,  195,  195,  195,  210,  214,  216,  222,
      222,  236,  224,  224,  224,  224,  231,  231,  231,  231,
      233,  210,  214,  216,  218,  224,  224,  229,  229,  229,
      229,  225,  224,  225,  214,  224,  225,  225,  225,  225,
      229,  229,  234,  185,  230,  230,  235,  229,  237,  215,
      229,  232,  232,  232,  232,  238,  213,  234,  230,  240,
      240,  235,  212,  237,  230,  232,  243,  244,  244,  244,
      238,  232,  247,  247,  211,  243,  248,  248,  248,  265,

      265,  243,  251,  251,  251,  254,  254,  254,  257,  257,
      257,  264,  266,  243,  258,  258,  258,  261,  261,  261,
      267,  268,  271,  271,  284,  284,  264,  266,  274,  274,
      274,  274,  207,  279,  281,  267,  268,  292,  292,  266,
      275,  275,  275,  275,  276,  276,  276,  276,  279,  281,
      282,  287,  287,  287,  275,  291,  296,  298,  276,  282,
      275,  299,  194,  300,  276,  282,  297,  297,  297,  297,
      291,  296,  298,  190,  183,  173,  299,  282,  300,  166,
      297,  163,  160,  147,  143,  141,  297,  302,  302,  302,
      302,  302,  302,  302,  302,  302,  302,  302,  302,  302,

      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  304,  304,  304,  304,  304,  304,  304,
      304,  304,  304,  304,  304,  304,  305,  305,  305,  305,
      305,  305,  305,  305,  305,  305,  305,  305,  305,  306,
      306,  306,  306,  306,  306,  306,  306,  306,  306,  306,
      306,  306,  307,  307,  307,  307,  307,  307,  307,  307,
      307,  307,  307,  307,  307,  308,  308,  308,  308,  308,
      308,  308,  308,  308,  308,  308,  308,  308,  309,  130,
      129,  127,  309,  126,  309,  309,  309,  309,  309,  310,
      125,  124,  116,  310,  113,  112,  109,  102,  310,  310,

      311,  100,   99,   97,  311,   96,   92,   91,   90,  311,
      311,  312,   84,   79,   76,   71,  312,   68,   62,  312,
      312,  312,  312,  312,  313,  313,  313,  313,  313,  313,
      313,  313,  313,  313,  313,  313,  313,  314,  314,  314,
      314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
      315,  315,  315,  315,  315,  315,  315,  315,  315,  315,
      315,  315,  315,  316,  316,   60,   56,  316,  316,  316,
       50,  316,  316,  316,  316,  317,  317,  317,  317,  317,
      317,  317,  317,  317,  317,  317,  317,  317,  318,  318,
       46,  318,  318,  318,   45,  318,  318,  318,  318,  318,

      318,  319,   44,   43,   42,  319,   37,  319,  319,   24,
      319,  319,  320,   23,   19,    8,  320,    7,    0,    0,
        0,  320,  320,  321,    0,    0,    0,  321,    0,    0,
        0,    0,  321,  321,  322,    0,  322,  323,    0,    0,
        0,  323,    0,  323,  323,    0,  323,  323,  324,    0,
        0,    0,  324,    0,  324,  324,    0,  324,  324,  325,
      325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
      325,  325,  326,    0,  326,  327,    0,    0,    0,  327,
        0,    0,    0,    0,  327,  327,  328,    0,    0,    0,
      328,    0,  328,  328,  328,  328,  328,  329,    0,    0,

        0,  329,    0,  329,  329,    0,  329,  329,  330,  330,
      330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
      330,  331,    0,  331,  331,  332,    0,    0,    0,  332,
        0,    0,    0,    0,  332,  332,  333,    0,    0,    0,
      333,    0,    0,    0,    0,  333,  333,  334,  334,  334,
      334,  334,  334,  334,  334,  334,  334,  334,  334,  334,
      335,    0,    0,    0,  335,    0,  335,  335,    0,  335,
      335,  336,  336,  336,  336,  336,  336,  336,  336,  336,
      336,  336,  336,  336,  337,    0,    0,    0,  337,    0,
        0,    0,    0,  337,  337,  338,    0,    0,    0,  338,

        0,  338,  338,    0,  338,  338,  339,    0,    0,    0,
      339,    0,  339,  339,    0,  339,  339,  340,    0,    0,
        0,  340,    0,  340,  340,    0,  340,  340,  301,  301,
      301,  301,  301,  301,  301,  301,  301,  301,  301,  301,
      301,  301,  301,  301,  301,  301,  301,  301,  301,  301,
      301,  301,  301,  301,  301,  301,  301,  301,  301,  301,
      301,  301,  301,  301,  301,  301,  301,  301,  301,  301,
      301,  301,  301,  301,  301,  301,  301,  301,  301,  301,
      301,  301,  301
    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
/*

We are using the pure parser interface and the reentrant lexer interface
but the Octave parser and lexer are NOT properly reentrant because both
still use many global variables.  It should be safe to create a parser
object and call it while another parser object is active (to parse a
callback function while the main interactive parser is waiting for
input, for example) if you take care to properly save and restore
(typically with an unwind_protect object) relevant global values before
and after the nested call.

*/









#line 91 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"

#include <cctype>
#include <cstring>

#include <iostream>
#include <set>
#include <sstream>
#include <string>
#include <stack>

#include "cmd-edit.h"
#include "lo-mappers.h"
#include "quit.h"
#include "unistd-wrappers.h"

// These would be alphabetical, but oct-parse.h must be included before
// oct-gperf.h and oct-parse.h must be included after token.h and the tree
// class declarations.  We can't include oct-parse.h in oct-gperf.h
// because it may not be protected to allow it to be included multiple
// times.

#include "Cell.h"
#include "defun.h"
#include "error.h"
#include "errwarn.h"
#include "input.h"
#include "interpreter.h"
#include "lex.h"
#include "octave.h"
#include "ov.h"
#include "parse.h"
#include "pt-all.h"
#include "symtab.h"
#include "token.h"
#include "utils.h"
#include "variables.h"
#include "oct-parse.h"
#include "oct-gperf.h"

// FIXME: with bison 3.x, OCTAVE_STYPE appears in the generated
// oct-parse.h file, but there is no definition for YYSTYPE, which is
// needed by the code that is generated by flex.  I can't seem to find a
// way to tell flex to use OCTAVE_STYPE instead of YYSTYPE in the code
// it generates, or to tell bison to provide the definition of YYSTYPE
// in the generated oct-parse.h file.

#if defined (OCTAVE_STYPE_IS_DECLARED) && ! defined YYSTYPE
#  define YYSTYPE OCTAVE_STYPE
#endif

#define YY_NO_UNISTD_H 1
#define isatty octave_isatty_wrapper

#if ! (defined (FLEX_SCANNER)                                           \
       && defined (YY_FLEX_MAJOR_VERSION) && YY_FLEX_MAJOR_VERSION >= 2 \
       && defined (YY_FLEX_MINOR_VERSION) && YY_FLEX_MINOR_VERSION >= 5)
#error lex.l requires flex version 2.5.4 or later
#endif

#define YY_EXTRA_TYPE octave::base_lexer *
#define curr_lexer yyextra

// Arrange to get input via readline.

#if defined (YY_INPUT)
#  undef YY_INPUT
#endif
#define YY_INPUT(buf, result, max_size)                 \
  result = curr_lexer->fill_flex_buffer (buf, max_size)

// Try to avoid crashing out completely on fatal scanner errors.

#if defined (YY_FATAL_ERROR)
#  undef YY_FATAL_ERROR
#endif
#define YY_FATAL_ERROR(msg)                     \
   (yyget_extra (yyscanner))->fatal_error (msg)

#define CMD_OR_OP(PATTERN, TOK, COMPAT)                                 \
   do                                                                   \
     {                                                                  \
       curr_lexer->lexer_debug (PATTERN);                               \
                                                                        \
       if (curr_lexer->looks_like_command_arg ())                       \
         {                                                              \
           yyless (0);                                                  \
           curr_lexer->push_start_state (COMMAND_START);                \
         }                                                              \
       else                                                             \
         return curr_lexer->handle_op (TOK, false, COMPAT);             \
     }                                                                  \
   while (0)

#define CMD_OR_COMPUTED_ASSIGN_OP(PATTERN, TOK)                         \
   do                                                                   \
     {                                                                  \
       curr_lexer->lexer_debug (PATTERN);                               \
                                                                        \
       if (curr_lexer->previous_token_may_be_command ()                 \
           && curr_lexer->space_follows_previous_token ())              \
         {                                                              \
           yyless (0);                                                  \
           curr_lexer->push_start_state (COMMAND_START);                \
         }                                                              \
       else                                                             \
         return curr_lexer->handle_op (TOK, false, false);              \
     }                                                                  \
   while (0)

#define CMD_OR_UNARY_OP(PATTERN, TOK, COMPAT)                           \
   do                                                                   \
     {                                                                  \
       curr_lexer->lexer_debug (PATTERN);                               \
                                                                        \
       if (curr_lexer->previous_token_may_be_command ())                \
         {                                                              \
           if (curr_lexer->looks_like_command_arg ())                   \
             {                                                          \
               yyless (0);                                              \
               curr_lexer->push_start_state (COMMAND_START);            \
             }                                                          \
           else                                                         \
             return curr_lexer->handle_op (TOK, false, COMPAT);         \
         }                                                              \
       else                                                             \
         {                                                              \
           if (curr_lexer->maybe_unput_comma_before_unary_op (TOK))     \
             {                                                          \
               yyless (0);                                              \
               curr_lexer->xunput (',');                                \
             }                                                          \
           else                                                         \
             return curr_lexer->handle_op (TOK, false, COMPAT);         \
         }                                                              \
     }                                                                  \
   while (0)

#define HANDLE_EOB_OR_EOF(STATUS)                       \
   do                                                   \
     {                                                  \
       if (curr_lexer->is_push_lexer ())                \
         {                                              \
           if (curr_lexer->at_end_of_buffer ())         \
             return STATUS;                             \
                                                        \
           if (curr_lexer->at_end_of_file ())           \
             return curr_lexer->handle_end_of_input (); \
         }                                              \
     }                                                  \
   while (0)

// If we are at the end of the buffer, ask for more input.
// If we are at the end of the file, deal with it.
// Otherwise, just keep going with the text from the current buffer.
#define HANDLE_STRING_CONTINUATION                      \
   do                                                   \
     {                                                  \
       curr_lexer->m_filepos.next_line ();              \
                                                        \
       HANDLE_EOB_OR_EOF (-1);                          \
     }                                                  \
   while (0)

#define HANDLE_IDENTIFIER(pattern, get_set)                             \
   do                                                                   \
     {                                                                  \
       curr_lexer->lexer_debug (pattern);                               \
                                                                        \
       int tok = curr_lexer->previous_token_value ();                   \
                                                                        \
       if (curr_lexer->whitespace_is_significant ()                     \
           && curr_lexer->space_follows_previous_token ()               \
           && ! (tok == '[' || tok == '{'                               \
                 || curr_lexer->previous_token_is_binop ()))            \
         {                                                              \
           yyless (0);                                                  \
           unput (',');                                                 \
         }                                                              \
       else                                                             \
         {                                                              \
           if (! curr_lexer->m_looking_at_decl_list                     \
               && curr_lexer->previous_token_may_be_command ())         \
             {                                                          \
               yyless (0);                                              \
               curr_lexer->push_start_state (COMMAND_START);            \
             }                                                          \
           else                                                         \
             {                                                          \
               if (get_set)                                             \
                 {                                                      \
                   yyless (3);                                          \
                   curr_lexer->m_filepos.increment_column (3);          \
                   curr_lexer->m_maybe_classdef_get_set_method = false; \
                 }                                                      \
                                                                        \
               return curr_lexer->handle_identifier ();                 \
             }                                                          \
         }                                                              \
     }                                                                  \
   while (0)

static inline bool
is_space_or_tab (char c)
{
  return c == ' ' || c == '\t';
}

static inline bool
is_space_or_tab_or_eol (char c)
{
  return c == ' ' || c == '\t' || c == '\n' || c == '\r';
}

namespace octave
{
  bool iskeyword (const std::string& s)
  {
    // Parsing function names like "set.property_name" inside
    // classdef-style class definitions is simplified by handling the
    // "set" and "get" portions of the names using the same mechanism
    // as is used for keywords.  However, they are not really keywords
    // in the language, so omit them from the list of possible
    // keywords.  Likewise for "enumeration", "events", "methods", and
    // "properties".

    return (octave_kw_hash::in_word_set (s.c_str (), s.length ()) != nullptr
            && ! (s == "set" || s == "get"
                  || s == "enumeration" || s == "events"
                  || s == "methods" || s == "properties"));
  }
}

#line 1293 "libinterp/parse-tree/lex.cc"
#line 1294 "libinterp/parse-tree/lex.cc"

#define INITIAL 0
#define COMMAND_START 1
#define MATRIX_START 2
#define INPUT_FILE_START 3
#define BLOCK_COMMENT_START 4
#define LINE_COMMENT_START 5
#define DQ_STRING_START 6
#define SQ_STRING_START 7
#define FQ_IDENT_START 8

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    int yy_n_chars;
    int yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    YYSTYPE * yylval_r;

    }; /* end struct yyguts_t */

static int yy_init_globals ( yyscan_t yyscanner );

    /* This must go here because YYSTYPE and YYLTYPE are included
     * from bison output in section 1.*/
    #    define yylval yyg->yylval_r
    
int yylex_init (yyscan_t* scanner);

int yylex_init_extra ( YY_EXTRA_TYPE user_defined, yyscan_t* scanner);

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( yyscan_t yyscanner );

int yyget_debug ( yyscan_t yyscanner );

void yyset_debug ( int debug_flag , yyscan_t yyscanner );

YY_EXTRA_TYPE yyget_extra ( yyscan_t yyscanner );

void yyset_extra ( YY_EXTRA_TYPE user_defined , yyscan_t yyscanner );

FILE *yyget_in ( yyscan_t yyscanner );

void yyset_in  ( FILE * _in_str , yyscan_t yyscanner );

FILE *yyget_out ( yyscan_t yyscanner );

void yyset_out  ( FILE * _out_str , yyscan_t yyscanner );

			int yyget_leng ( yyscan_t yyscanner );

char *yyget_text ( yyscan_t yyscanner );

int yyget_lineno ( yyscan_t yyscanner );

void yyset_lineno ( int _line_number , yyscan_t yyscanner );

int yyget_column  ( yyscan_t yyscanner );

void yyset_column ( int _column_no , yyscan_t yyscanner );

YYSTYPE * yyget_lval ( yyscan_t yyscanner );

void yyset_lval ( YYSTYPE * yylval_param , yyscan_t yyscanner );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( yyscan_t yyscanner );
#else
extern int yywrap ( yyscan_t yyscanner );
#endif
#endif

#ifndef YY_NO_UNPUT
    
    static void yyunput ( int c, char *buf_ptr  , yyscan_t yyscanner);
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int , yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * , yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( yyscan_t yyscanner );
#else
static int input ( yyscan_t yyscanner );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex \
               (YYSTYPE * yylval_param , yyscan_t yyscanner);

#define YY_DECL int yylex \
               (YYSTYPE * yylval_param , yyscan_t yyscanner)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    yylval = yylval_param;

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack (yyscanner);
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
		}

		yy_load_buffer_state( yyscanner );
		}

	{
#line 342 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"



#line 346 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
// Make script and function files start with an invalid token. This makes
// the parser go down a special path.


#line 1588 "libinterp/parse-tree/lex.cc"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yyg->yy_start;
		yy_current_state += YY_AT_BOL();
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				yyg->yy_last_accepting_state = yy_current_state;
				yyg->yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 302 )
					yy_c = yy_meta[yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 1029 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = yyg->yy_last_accepting_cpos;
			yy_current_state = yyg->yy_last_accepting_state;
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yyg->yy_hold_char;
			yy_cp = yyg->yy_last_accepting_cpos;
			yy_current_state = yyg->yy_last_accepting_state;
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 350 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<INPUT_FILE_START>{ANY_INCLUDING_NL}");

    curr_lexer->xunput (yytext[0]);

    // May be reset later if we see "function" or "classdef" appears
    // as the first token.
    curr_lexer->m_reading_script_file = true;

    curr_lexer->pop_start_state ();

    return curr_lexer->show_token (INPUT_FILE);
  }
	YY_BREAK
case YY_STATE_EOF(INPUT_FILE_START):
#line 364 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<INPUT_FILE_START><<EOF>>");

    // May be reset later if we see "function" or "classdef" appears
    // as the first token.
    curr_lexer->m_reading_script_file = true;

    curr_lexer->pop_start_state ();

    return curr_lexer->show_token (INPUT_FILE);
  }
	YY_BREAK

// Help and other command-style functions.


// Commands can be continued on a second line using the ellipsis.
// If an argument is in construction, it is completed.

case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 385 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<COMMAND_START>(\\.\\.\\.){ANY_EXCEPT_NL}*{NL}");

    if (! curr_lexer->m_string_text.empty ())
      {
        yyless (0);
        curr_lexer->m_tok_end = curr_lexer->m_filepos;
        return curr_lexer->finish_command_arg ();
      }

    HANDLE_STRING_CONTINUATION;
  }
	YY_BREAK

// Commands normally end at the end of a line or a semicolon.

case 3:
/* rule 3 can match eol */
YY_RULE_SETUP
#line 402 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<COMMAND_START>({CCHAR}{ANY_EXCEPT_NL}*)?{NL}");

    if (! curr_lexer->m_string_text.empty ())
      {
        yyless (0);
        curr_lexer->m_tok_end = curr_lexer->m_filepos;
        return curr_lexer->finish_command_arg ();
      }

    curr_lexer->update_token_positions (yyleng);

    curr_lexer->m_filepos.next_line ();
    curr_lexer->m_looking_for_object_index = false;
    curr_lexer->m_at_beginning_of_statement = true;
    curr_lexer->pop_start_state ();

    return curr_lexer->handle_token ('\n');
  }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 422 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<COMMAND_START>[\\,\\;]");

    if (yytext[0] != ',' || curr_lexer->m_command_arg_paren_count == 0)
      {
        if (! curr_lexer->m_string_text.empty ())
          {
            yyless (0);
            curr_lexer->m_tok_end = curr_lexer->m_filepos;
            return curr_lexer->finish_command_arg ();
          }

        curr_lexer->update_token_positions (yyleng);

        curr_lexer->m_looking_for_object_index = false;
        curr_lexer->m_at_beginning_of_statement = true;
        curr_lexer->pop_start_state ();

        return curr_lexer->handle_token (yytext[0]);
      }
    else
      {
        curr_lexer->m_string_text += yytext;
        curr_lexer->m_filepos.increment_column (yyleng);
      }
  }
	YY_BREAK

// Unbalanced parentheses serve as pseudo-quotes: they are included in
// the final argument string, but they cause parentheses and quotes to
// be slurped into that argument as well.

case 5:
YY_RULE_SETUP
#line 455 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<COMMAND_START>[\\(\\[\\{]+");

    curr_lexer->m_command_arg_paren_count += yyleng;
    curr_lexer->m_string_text += yytext;
    curr_lexer->m_filepos.increment_column (yyleng);
  }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 463 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
   curr_lexer->lexer_debug ("<COMMAND_START>[\\)\\]\\}]+");

   curr_lexer->m_command_arg_paren_count -= yyleng;
   curr_lexer->m_string_text += yytext;
   curr_lexer->m_filepos.increment_column (yyleng);
}
	YY_BREAK

// Handle quoted strings.  Quoted strings that are not separated by
// whitespace from other argument text are combined with that previous
// text.  For instance,
//
//   command 'text1'"text2"
//
// has a single argument text1text2, not two separate arguments.
// That's why we must test to see if we are in command argument mode
// when processing the end of a string.

case 7:
YY_RULE_SETUP
#line 483 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<COMMAND_START>[\\\"\\']");

    if (curr_lexer->m_command_arg_paren_count == 0)
      curr_lexer->begin_string (yytext[0] == '"'
                                ? DQ_STRING_START : SQ_STRING_START);
    else
      curr_lexer->m_string_text += yytext;

    curr_lexer->m_filepos.increment_column (yyleng);
  }
	YY_BREAK

// In standard command argument processing, whitespace separates
// arguments.  In the presence of unbalanced parentheses, it is
// incorporated into the argument.

case 8:
YY_RULE_SETUP
#line 501 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<COMMAND_START>{S}*");

    if (curr_lexer->m_command_arg_paren_count == 0)
      {
        if (! curr_lexer->m_string_text.empty ())
          {
            yyless (0);
            curr_lexer->m_tok_end = curr_lexer->m_filepos;
            return curr_lexer->finish_command_arg ();
          }
      }
    else
      curr_lexer->m_string_text += yytext;

    curr_lexer->m_filepos.increment_column (yyleng);
  }
	YY_BREAK

// Everything else is slurped into the command arguments.

case 9:
YY_RULE_SETUP
#line 523 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<COMMAND_START>([\\.]|[^#% \\t\\r\\n\\.\\,\\;\\\"\\'\\(\\[\\{\\}\\]\\)]*");

    curr_lexer->m_string_text += yytext;
    curr_lexer->m_filepos.increment_column (yyleng);
  }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 530 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<MATRIX_START>{S}*");

    curr_lexer->m_filepos.increment_column (yyleng);

    curr_lexer->mark_previous_token_trailing_space ();
  }
	YY_BREAK
case 11:
/* rule 11 can match eol */
YY_RULE_SETUP
#line 538 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<MATRIX_START>{NL}");

    curr_lexer->m_filepos.next_line ();

    if (curr_lexer->m_nesting_level.is_paren ())
      curr_lexer->warn_language_extension ("bare newline inside parentheses");
    else
      {
        int tok = curr_lexer->previous_token_value ();

        if (! (tok == ';' || tok == '[' || tok == '{'))
          curr_lexer->xunput (';');
      }
  }
	YY_BREAK

// For this and the next two rules, we're looking at ']', and we
// need to know if the next token is '=' or '=='.
//
// It would have been so much easier if the delimiters were simply
// different for the expression on the left hand side of the equals
// operator.
//
// It's also a pain in the ass to decide whether to insert a comma
// after seeing a ']' character...

// FIXME: we need to handle block comments here.

case 12:
YY_RULE_SETUP
#line 568 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<MATRIX_START>\\]");

    curr_lexer->update_token_positions (yyleng);
    return curr_lexer->handle_close_bracket (']');
  }
	YY_BREAK

// FIXME: we need to handle block comments here.

case 13:
YY_RULE_SETUP
#line 579 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<MATRIX_START>\\}*");

    curr_lexer->update_token_positions (yyleng);
    return curr_lexer->handle_close_bracket ('}');
  }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 586 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("\\[");

        bool unput_comma = false;

    if (curr_lexer->whitespace_is_significant ()
        && curr_lexer->space_follows_previous_token ())
      {
        int tok = curr_lexer->previous_token_value ();

        if (! (tok == '[' || tok == '{'
               || curr_lexer->previous_token_is_binop ()))
          unput_comma = true;
      }

    if (unput_comma)
      {
        yyless (0);
        curr_lexer->xunput (',');
      }
    else
      {
        curr_lexer->update_token_positions (yyleng);

        curr_lexer->m_nesting_level.bracket ();

        curr_lexer->m_looking_at_object_index.push_front (false);

        curr_lexer->m_looking_for_object_index = false;
        curr_lexer->m_at_beginning_of_statement = false;

        if (curr_lexer->m_defining_func
            && ! curr_lexer->m_parsed_function_name.top ())
          curr_lexer->m_looking_at_return_list = true;
        else
          curr_lexer->m_looking_at_matrix_or_assign_lhs = true;

        curr_lexer->m_bracketflag++;

        curr_lexer->push_start_state (MATRIX_START);

        return curr_lexer->count_token ('[');
      }
  }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 631 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("\\]");

    curr_lexer->update_token_positions (yyleng);

    curr_lexer->m_nesting_level.remove ();

    curr_lexer->m_looking_at_object_index.pop_front ();

    curr_lexer->m_looking_for_object_index = true;
    curr_lexer->m_at_beginning_of_statement = false;

    return curr_lexer->handle_token (']');
  }
	YY_BREAK

// Gobble comments.  Both BLOCK_COMMENT_START and LINE_COMMENT_START
// are exclusive start states.  We try to grab a continuous series of
// line-oriented comments as a single collection of comments.


// Start of a block comment.  Since comment start states are exclusive,
// this pattern will not match a block comment that immediately follows
// a line-oriented comment.  All we need to do is push the matched text
// back on the input stream and push the new start state.

case 16:
/* rule 16 can match eol */
YY_RULE_SETUP
#line 659 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("^{S}*{CCHAR}\\{{S}*{NL}");

    yyless (0);

    curr_lexer->push_start_state (BLOCK_COMMENT_START);
  }
	YY_BREAK
case 17:
/* rule 17 can match eol */
YY_RULE_SETUP
#line 667 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<BLOCK_COMMENT_START>^{S}*{CCHAR}\\{{S}*{NL}");

    curr_lexer->m_filepos.next_line ();

    if (curr_lexer->m_block_comment_nesting_level)
      curr_lexer->m_comment_text = "\n";

    curr_lexer->m_block_comment_nesting_level++;

    HANDLE_EOB_OR_EOF (-1);
  }
	YY_BREAK

// End of a block comment.  If this block comment is nested inside
// another, wait for the outermost block comment to be closed before
// storing the comment.

// NOTE: This pattern must appear before the one below.  Both may match
// the same text and this one should take precedence over the one that
// follows.

case 18:
/* rule 18 can match eol */
YY_RULE_SETUP
#line 690 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<BLOCK_COMMENT_START>^{S}*{CCHAR}\\}{S}*{NL}");

    curr_lexer->m_filepos.next_line ();

    if (curr_lexer->m_block_comment_nesting_level > 1)
      curr_lexer->m_comment_text = "\n";
    else
      curr_lexer->finish_comment (octave::comment_elt::block);

    curr_lexer->m_block_comment_nesting_level--;

    int status = -1;

    if (curr_lexer->m_block_comment_nesting_level == 0)
      {
        status = -2;

        curr_lexer->pop_start_state ();
      }

    HANDLE_EOB_OR_EOF (status);
  }
	YY_BREAK

// Body of a block comment.

case 19:
/* rule 19 can match eol */
YY_RULE_SETUP
#line 718 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<BLOCK_COMMENT_START>{ANY_EXCEPT_NL}*{NL}");

    curr_lexer->m_filepos.next_line ();
    curr_lexer->m_comment_text += yytext;

    HANDLE_EOB_OR_EOF (-1);
  }
	YY_BREAK

// Full-line or end-of-line comment.

case 20:
/* rule 20 can match eol */
YY_RULE_SETUP
#line 731 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("{S}*{CCHAR}{ANY_EXCEPT_NL}*{NL}");

    curr_lexer->push_start_state (LINE_COMMENT_START);
    yyless (0);
  }
	YY_BREAK

// Beginning of a block comment while we are looking at a series of
// line-oriented comments.  Finish previous comment, push current
// text back on input stream, and switch start states.

// NOTE: This pattern must appear before the one below.  Both may match
// the same text and this one should take precedence over the one that
// follows.

case 21:
/* rule 21 can match eol */
YY_RULE_SETUP
#line 748 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<LINE_COMMENT_START>^{S}*{CCHAR}\\{{S}*{NL}");

    if (! curr_lexer->m_comment_text.empty ())
      curr_lexer->finish_comment (octave::comment_elt::full_line);

    curr_lexer->pop_start_state ();
    curr_lexer->push_start_state (BLOCK_COMMENT_START);
    yyless (0);
  }
	YY_BREAK

// Line-oriented comment.  If we are at the beginning of a line, this is
// part of a series of full-line comments.  Otherwise, this is an end of
// line comment.  We don't need to parse the matched text to determine
// whether we are looking at the start of a block comment as that
// pattern is handled above.

// NOTE: This pattern must appear before the one below.  Both may match
// the same text and this one should take precedence over the one that
// follows.

case 22:
/* rule 22 can match eol */
YY_RULE_SETUP
#line 771 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<LINE_COMMENT_START>{S}*{CCHAR}{ANY_EXCEPT_NL}*{NL}");

    // Grab text of comment without leading space or comment
    // characters.

    size_t i = 0;
    while (i < yyleng && is_space_or_tab (yytext[i]))
      i++;

    bool have_space = (i > 0);

    while (i < yyleng && (yytext[i] == '#' || yytext[i] == '%'))
      i++;

    curr_lexer->m_comment_text += &yytext[i];

    if (curr_lexer->m_filepos.column () == 1)
      {
        curr_lexer->m_filepos.next_line ();
      }
    else
      {
        // End of line comment.

        if (have_space)
          curr_lexer->mark_previous_token_trailing_space ();

        curr_lexer->finish_comment (octave::comment_elt::end_of_line);

        curr_lexer->pop_start_state ();

        // Push the newline character back on the input and skip
        // incrementing the line count so we don't have to duplicate
        // all the possible actions that happen with newlines here.

        curr_lexer->xunput ('\n');

        // The next action should recognize a newline character and set
        // the input column back to 1, but we should try to keep the
        // input column location accurate anyway, so update here.
        curr_lexer->m_filepos.increment_column (yyleng);
      }
  }
	YY_BREAK

// End of a series of full-line because some other character was
// found on the input stream.

case 23:
/* rule 23 can match eol */
YY_RULE_SETUP
#line 821 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<LINE_COMMENT_START>{ANY_INCLUDING_NL}");

    if (yytext[0] == '\001')
      {
        // We are here because we are using the push parser/lexer
        // interface and we hit the end of the input buffer or file.
        // The special ASCII 1 marker is added to the input by
        // push_lexer::fill_flex_buffer.

        if (curr_lexer->pending_token_count () > 0)
          {
            // We are in the middle of parsing a command, expresison,
            // etc., so set the return status so that if we are at the
            // end of the buffer we'll continue looking for more input,
            // possibly buffering a series of line oriented comments as
            // a single block.

            HANDLE_EOB_OR_EOF (-1);
          }
        else
          {
            // We are not in the process of parsing a command,
            // expression, etc., so end any current sequence of comments
            // with this full line comment, pop the start state and
            // return as if we have just finished parsing a complete
            // statement.

            curr_lexer->finish_comment (octave::comment_elt::full_line);

            curr_lexer->pop_start_state ();

            HANDLE_EOB_OR_EOF (-2);
          }
      }
    else
      {
        // End any current sequence of comments, pop the start state,
        // and unput the pending input character that ended the series
        // of comments.

        curr_lexer->finish_comment (octave::comment_elt::full_line);

        curr_lexer->pop_start_state ();

        curr_lexer->xunput (yytext[0]);
      }
  }
	YY_BREAK

// End of file will also end a series of full-line comments.

case YY_STATE_EOF(LINE_COMMENT_START):
#line 874 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<LINE_COMMENT_START><<EOF>>");

    curr_lexer->finish_comment (octave::comment_elt::full_line);

    curr_lexer->pop_start_state ();
  }
	YY_BREAK

// Double-quoted character strings.

case 24:
YY_RULE_SETUP
#line 886 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\\\"\\\"");

    curr_lexer->m_filepos.increment_column (yyleng);
    curr_lexer->m_string_text += '"';
  }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 893 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\\\"");

    // m_tok_beg was set when we started parsing the string.
    curr_lexer->m_tok_end = curr_lexer->m_filepos;
    curr_lexer->m_filepos.increment_column ();

    curr_lexer->pop_start_state ();

    if (curr_lexer->start_state() != COMMAND_START)
      {
        curr_lexer->m_looking_for_object_index = true;
        curr_lexer->m_at_beginning_of_statement = false;

        curr_lexer->push_token (new octave::token (DQ_STRING,
                                                   curr_lexer->m_string_text,
                                                   curr_lexer->m_tok_beg,
                                                   curr_lexer->m_tok_end));

        curr_lexer->m_string_text = "";

        return curr_lexer->count_token_internal (DQ_STRING);
      }
  }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 918 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\\\\[0-7]{1,3}");

    curr_lexer->update_token_positions (yyleng);

    unsigned int result;
    sscanf (yytext+1, "%o", &result);

    if (result > 0xff)
      {
        // Use location of octal digits for error token.
        octave::token *tok
          = new octave::token (LEXICAL_ERROR,
                               "invalid octal escape sequence in character string",
                               curr_lexer->m_tok_beg, curr_lexer->m_tok_end);

        curr_lexer->push_token (tok);

        return curr_lexer->count_token_internal (LEXICAL_ERROR);
      }
    else
      curr_lexer->m_string_text += static_cast<unsigned char> (result);
  }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 942 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\\\\x[0-9a-fA-F]+");

    curr_lexer->m_filepos.increment_column (yyleng);

    unsigned int result;
    sscanf (yytext+2, "%x", &result);

    // Truncate the value silently instead of checking the range like
    // we do for octal above.  This is to match C/C++ where any number
    // of digits is allowed but the value is implementation-defined if
    // it exceeds the range of the character type.
    curr_lexer->m_string_text += static_cast<unsigned char> (result);
  }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 957 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\"\\\\a\"");

    curr_lexer->m_filepos.increment_column (yyleng);
    curr_lexer->m_string_text += '\a';
  }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 964 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\"\\\\b\"");

    curr_lexer->m_filepos.increment_column (yyleng);
    curr_lexer->m_string_text += '\b';
  }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 971 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\"\\\\f\"");

    curr_lexer->m_filepos.increment_column (yyleng);
    curr_lexer->m_string_text += '\f';
  }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 978 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\"\\\\n\"");

    curr_lexer->m_filepos.increment_column (yyleng);
    curr_lexer->m_string_text += '\n';
  }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 985 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\"\\\\r\"");

    curr_lexer->m_filepos.increment_column (yyleng);
    curr_lexer->m_string_text += '\r';
  }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 992 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\"\\\\t\"");

    curr_lexer->m_filepos.increment_column (yyleng);
    curr_lexer->m_string_text += '\t';
  }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 999 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\"\\\\v\"");

    curr_lexer->m_filepos.increment_column (yyleng);
    curr_lexer->m_string_text += '\v';
  }
	YY_BREAK
case 35:
/* rule 35 can match eol */
YY_RULE_SETUP
#line 1006 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>(\\.\\.\\.){S}*{NL}");

    static const char *msg = "'...' continuations in double-quoted character strings are obsolete and will not be allowed in a future version of Octave; please use '\\' instead";

    std::string nm = curr_lexer->m_fcn_file_full_name;

    if (nm.empty ())
      warning_with_id ("Octave:deprecated-syntax", "%s", msg);
    else
      warning_with_id ("Octave:deprecated-syntax",
                       "%s; near line %d of file '%s'", msg,
                       curr_lexer->m_filepos.line (), nm.c_str ());

    HANDLE_STRING_CONTINUATION;
  }
	YY_BREAK
case 36:
/* rule 36 can match eol */
YY_RULE_SETUP
#line 1023 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\\\\{S}+{NL}");

    static const char *msg = "white space and comments after continuation markers in double-quoted character strings are obsolete and will not be allowed in a future version of Octave";

    std::string nm = curr_lexer->m_fcn_file_full_name;

    if (nm.empty ())
      warning_with_id ("Octave:deprecated-syntax", "%s", msg);
    else
      warning_with_id ("Octave:deprecated-syntax",
                       "%s; near line %d of file '%s'", msg,
                       curr_lexer->m_filepos.line (), nm.c_str ());

    HANDLE_STRING_CONTINUATION;
  }
	YY_BREAK
case 37:
/* rule 37 can match eol */
YY_RULE_SETUP
#line 1040 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\\\\{NL}");

    HANDLE_STRING_CONTINUATION;
  }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 1046 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\\\\.");

    curr_lexer->m_filepos.increment_column (yyleng);
    curr_lexer->m_string_text += yytext[1];
  }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 1053 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\\.");

    curr_lexer->m_filepos.increment_column ();
    curr_lexer->m_string_text += yytext[0];
  }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 1060 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>[^\\.\\\\\\r\\n\\\"]+");

    curr_lexer->m_filepos.increment_column (yyleng);
    curr_lexer->m_string_text += yytext;
  }
	YY_BREAK
case 41:
/* rule 41 can match eol */
YY_RULE_SETUP
#line 1067 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>{NL}");

    // Use current file position for error token.
    octave::token *tok
      = new octave::token (LEXICAL_ERROR,
                           "unterminated character string constant",
                           curr_lexer->m_filepos, curr_lexer->m_filepos);

    curr_lexer->push_token (tok);

    curr_lexer->m_filepos.next_line ();

    return curr_lexer->count_token_internal (LEXICAL_ERROR);
  }
	YY_BREAK

// Single-quoted character strings.

case 42:
YY_RULE_SETUP
#line 1087 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<SQ_STRING_START>\\'\\'");

    curr_lexer->m_filepos.increment_column (yyleng);
    curr_lexer->m_string_text += '\'';
  }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 1094 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<SQ_STRING_START>\\'");

    // m_tok_beg was set when we started parsing the string.
    curr_lexer->m_tok_end = curr_lexer->m_filepos;
    curr_lexer->m_filepos.increment_column ();

    curr_lexer->pop_start_state ();

    if (curr_lexer->start_state() != COMMAND_START)
      {
        curr_lexer->m_looking_for_object_index = true;
        curr_lexer->m_at_beginning_of_statement = false;

        curr_lexer->push_token (new octave::token (SQ_STRING,
                                                   curr_lexer->m_string_text,
                                                   curr_lexer->m_tok_beg,
                                                   curr_lexer->m_tok_end));

        curr_lexer->m_string_text = "";

        return curr_lexer->count_token_internal (SQ_STRING);
      }
  }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 1119 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<SQ_STRING_START>[^\\'\\n\\r]+");

    curr_lexer->m_filepos.increment_column (yyleng);
    curr_lexer->m_string_text += yytext;
  }
	YY_BREAK
case 45:
/* rule 45 can match eol */
YY_RULE_SETUP
#line 1126 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<SQ_STRING_START>{NL}");

    // Use current file position for error token.
    octave::token *tok
      = new octave::token (LEXICAL_ERROR,
                           "unterminated character string constant",
                           curr_lexer->m_filepos, curr_lexer->m_filepos);

    curr_lexer->push_token (tok);

    curr_lexer->m_filepos.next_line ();

    return curr_lexer->count_token_internal (LEXICAL_ERROR);
  }
	YY_BREAK

// Fully-qualified identifiers (used for classdef).

case 46:
YY_RULE_SETUP
#line 1146 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<FQ_IDENT_START>{FQIDENT}{S}*");

    curr_lexer->pop_start_state ();

    curr_lexer->update_token_positions (yyleng);

    int id_tok = curr_lexer->handle_fq_identifier ();

    if (id_tok >= 0)
      {
        curr_lexer->m_looking_for_object_index = true;

        return curr_lexer->count_token_internal (id_tok);
      }
  }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 1163 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<FQ_IDENT_START>{S}+");

    curr_lexer->m_filepos.increment_column (yyleng);

    curr_lexer->mark_previous_token_trailing_space ();
  }
	YY_BREAK
case 48:
/* rule 48 can match eol */
YY_RULE_SETUP
#line 1171 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<FQ_IDENT_START>(\\.\\.\\.){ANY_EXCEPT_NL}*{NL}");

    curr_lexer->m_filepos.next_line ();
  }
	YY_BREAK
case 49:
/* rule 49 can match eol */
YY_RULE_SETUP
#line 1177 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<FQ_IDENT_START>{ANY_INCLUDING_NL}");

    // If input doesn't match FQIDENT, return char and go to previous
    // start state.

    yyless (0);
    curr_lexer->pop_start_state ();
  }
	YY_BREAK

// Imaginary numbers.

case 50:
YY_RULE_SETUP
#line 1191 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("{NUMBER}{Im}");

    if (curr_lexer->previous_token_may_be_command ()
        &&  curr_lexer->space_follows_previous_token ())
      {
        yyless (0);
        curr_lexer->push_start_state (COMMAND_START);
      }
    else
      {
        int tok = curr_lexer->previous_token_value ();

        if (curr_lexer->whitespace_is_significant ()
            && curr_lexer->space_follows_previous_token ()
            && ! (tok == '[' || tok == '{'
                  || curr_lexer->previous_token_is_binop ()))
          {
            yyless (0);
            unput (',');
          }
        else
          {
            curr_lexer->handle_number ();
            return curr_lexer->count_token_internal (IMAG_NUM);
          }
      }
  }
	YY_BREAK

// Real numbers.  Don't grab the '.' part of a dot operator as part of
// the constant.

case 51:
*yy_cp = yyg->yy_hold_char; /* undo effects of setting up yytext */
yyg->yy_c_buf_p = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
#line 1226 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
case 52:
YY_RULE_SETUP
#line 1226 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("{D}{D_}*/\\.[\\*/\\\\^\\']|{NUMBER}");

    if (curr_lexer->previous_token_may_be_command ()
        &&  curr_lexer->space_follows_previous_token ())
      {
        yyless (0);
        curr_lexer->push_start_state (COMMAND_START);
      }
    else
      {
        int tok = curr_lexer->previous_token_value ();

        if (curr_lexer->whitespace_is_significant ()
            && curr_lexer->space_follows_previous_token ()
            && ! (tok == '[' || tok == '{'
                  || curr_lexer->previous_token_is_binop ()))
          {
            yyless (0);
            unput (',');
          }
        else
          {
            curr_lexer->handle_number ();
            return curr_lexer->count_token_internal (NUM);
          }
      }
  }
	YY_BREAK

// Eat whitespace.  Whitespace inside matrix constants is handled by
// the <MATRIX_START> start state code above.

case 53:
YY_RULE_SETUP
#line 1260 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->m_filepos.increment_column (yyleng);

    curr_lexer->mark_previous_token_trailing_space ();
  }
	YY_BREAK

// Continuation lines.  Allow arbitrary text after continuations.

case 54:
/* rule 54 can match eol */
YY_RULE_SETUP
#line 1270 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("\\.\\.\\.{ANY_EXCEPT_NL}*{NL}");

    curr_lexer->handle_continuation ();
  }
	YY_BREAK

// Deprecated C preprocessor style continuation markers.

case 55:
/* rule 55 can match eol */
#line 1281 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
case 56:
/* rule 56 can match eol */
YY_RULE_SETUP
#line 1281 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("\\\\{S}*{NL}|\\\\{S}*{CCHAR}{ANY_EXCEPT_NL}*{NL}");

    static const char *msg = "using continuation marker \\ outside of double quoted strings is deprecated and will be removed from a future version of Octave, use ... instead";

    std::string nm = curr_lexer->m_fcn_file_full_name;

    if (nm.empty ())
      warning_with_id ("Octave:deprecated-syntax", "%s", msg);
    else
      warning_with_id ("Octave:deprecated-syntax",
                       "%s; near line %d of file '%s'", msg,
                       curr_lexer->m_filepos.line (), nm.c_str ());

    curr_lexer->handle_continuation ();
  }
	YY_BREAK

// End of file.

case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(COMMAND_START):
case YY_STATE_EOF(MATRIX_START):
case YY_STATE_EOF(BLOCK_COMMENT_START):
case YY_STATE_EOF(DQ_STRING_START):
case YY_STATE_EOF(SQ_STRING_START):
case YY_STATE_EOF(FQ_IDENT_START):
#line 1302 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
   return curr_lexer->handle_end_of_input ();
  }
	YY_BREAK

// Identifiers.

// Don't allow get and set to be recognized as keywords if they are
// followed by "(".

case 57:
YY_RULE_SETUP
#line 1313 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    HANDLE_IDENTIFIER ("(set|get){S}*\\(", true);
  }
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 1317 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    HANDLE_IDENTIFIER ("{IDENT}", false);
  }
	YY_BREAK

// Superclass method identifiers.

case 59:
YY_RULE_SETUP
#line 1325 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("{FQIDENT}{S}*@{S}*{FQIDENT}");

    if (curr_lexer->previous_token_may_be_command ())
      {
        yyless (0);
        curr_lexer->push_start_state (COMMAND_START);
      }
    else
      {
        if (curr_lexer->m_at_beginning_of_statement)
          {
            std::string txt = yytext;

            size_t at_or_dot_pos = txt.find_first_of ("@.");

            if (at_or_dot_pos != std::string::npos)
              {
                size_t spc_pos = txt.find_first_of (" \t");

                if (spc_pos != std::string::npos && spc_pos < at_or_dot_pos)
                  {
                    yyless (spc_pos);
                    curr_lexer->m_filepos.increment_column (spc_pos);

                    return curr_lexer->handle_identifier ();
                  }
              }
          }

        curr_lexer->m_looking_for_object_index = true;
        curr_lexer->m_at_beginning_of_statement = false;

        return curr_lexer->handle_superclass_identifier ();
      }
  }
	YY_BREAK

// Metaclass query

case 60:
YY_RULE_SETUP
#line 1366 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("\\?{S}*{FQIDENT}");

    if (curr_lexer->previous_token_may_be_command ()
        &&  curr_lexer->space_follows_previous_token ())
      {
        yyless (0);
        curr_lexer->push_start_state (COMMAND_START);
      }
    else
      {
        curr_lexer->update_token_positions (yyleng);

        int id_tok = curr_lexer->handle_meta_identifier ();

        if (id_tok >= 0)
          {
            curr_lexer->m_looking_for_object_index = true;

            return curr_lexer->count_token_internal (id_tok);
          }
      }
  }
	YY_BREAK
case 61:
#line 1391 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
case 62:
YY_RULE_SETUP
#line 1391 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("\\@|\\@{S}*{FQIDENT}");

    if (curr_lexer->previous_token_may_be_command ()
        &&  curr_lexer->space_follows_previous_token ())
      {
        yyless (0);
        curr_lexer->push_start_state (COMMAND_START);
      }
    else
      {
        int tok_val = curr_lexer->previous_token_value ();

        if (curr_lexer->whitespace_is_significant ()
            && curr_lexer->space_follows_previous_token ()
            && ! (tok_val == '[' || tok_val == '{'
                  || curr_lexer->previous_token_is_binop ()))
          {
            yyless (0);
            unput (',');
          }
        else
          {
            curr_lexer->update_token_positions (yyleng);

            curr_lexer->m_at_beginning_of_statement = false;

            std::string ident = yytext;

            if (ident == "@")
              {
                curr_lexer->m_looking_at_function_handle++;
                curr_lexer->m_looking_for_object_index = false;

                return curr_lexer->count_token ('@');
              }
            else
              {
                ident = ident.substr (1);
                ident.erase (std::remove_if (ident.begin (), ident.end (),
                                             is_space_or_tab), ident.end ());

                octave::token *tok;

                if (octave::iskeyword (ident))
                  tok = new octave::token (LEXICAL_ERROR,
                                           "function handles may not refer to keywords",
                                           curr_lexer->m_tok_beg,
                                           curr_lexer->m_tok_end);
                else
                  {
                    curr_lexer->m_looking_for_object_index = true;

                    tok = new octave::token (FCN_HANDLE, ident,
                                             curr_lexer->m_tok_beg,
                                             curr_lexer->m_tok_end);
                  }

                curr_lexer->push_token (tok);

                return curr_lexer->count_token_internal (tok->token_value ());
              }
          }
      }
  }
	YY_BREAK

// A new line character.  New line characters inside matrix constants
// are handled by the <MATRIX_START> start state code above.  If closest
// nesting is inside parentheses, don't return a row separator.

case 63:
/* rule 63 can match eol */
YY_RULE_SETUP
#line 1463 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("{NL}");

    if (curr_lexer->m_nesting_level.is_paren ())
      {
        curr_lexer->m_filepos.next_line ();

        curr_lexer->m_at_beginning_of_statement = false;
        curr_lexer->warn_language_extension
          ("bare newline inside parentheses");
      }
    else if (curr_lexer->m_nesting_level.none ()
        || curr_lexer->m_nesting_level.is_anon_fcn_body ())
      {
        curr_lexer->update_token_positions (yyleng);
        curr_lexer->m_filepos.next_line ();

        curr_lexer->m_at_beginning_of_statement = true;

        return curr_lexer->count_token ('\n');
      }
    else if (curr_lexer->m_nesting_level.is_bracket_or_brace ())
      {
        curr_lexer->update_token_positions (yyleng);
        curr_lexer->m_filepos.next_line ();

        // Use current file position for error token.
        octave::token *tok
          = new octave::token (LEXICAL_ERROR,
                               "unexpected internal lexer error",
                               curr_lexer->m_filepos, curr_lexer->m_filepos);

        curr_lexer->push_token (tok);

        return curr_lexer->count_token_internal (LEXICAL_ERROR);
      }
  }
	YY_BREAK

// Single quote can either be the beginning of a string or a transpose
// operator.

case 64:
YY_RULE_SETUP
#line 1506 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("'");

    if (curr_lexer->previous_token_may_be_command ()
        &&  curr_lexer->space_follows_previous_token ())
      {
        curr_lexer->m_filepos.increment_column ();
        curr_lexer->push_start_state (COMMAND_START);
        curr_lexer->begin_string (SQ_STRING_START);
      }
    else if (curr_lexer->m_at_beginning_of_statement)
      {
        curr_lexer->m_filepos.increment_column ();
        curr_lexer->begin_string (SQ_STRING_START);
      }
    else
      {
        int tok = curr_lexer->previous_token_value ();

        if (curr_lexer->whitespace_is_significant ())
          {
            if (curr_lexer->space_follows_previous_token ())
              {
                if (tok == '[' || tok == '{'
                    || curr_lexer->previous_token_is_binop ())
                  {
                    curr_lexer->m_filepos.increment_column ();
                    curr_lexer->begin_string (SQ_STRING_START);
                  }
                else
                  {
                    yyless (0);
                    curr_lexer->xunput (',');
                  }
              }
            else
              {
                if (tok == '[' || tok == '{'
                    || curr_lexer->previous_token_is_binop ()
                    || curr_lexer->previous_token_is_keyword ())
                  {
                    curr_lexer->m_filepos.increment_column ();
                    curr_lexer->begin_string (SQ_STRING_START);
                  }
                else
                  {
                    curr_lexer->m_filepos.increment_column ();
                    return curr_lexer->count_token (HERMITIAN);
                  }
              }
          }
        else
          {
            if (! tok || tok == '[' || tok == '{' || tok == '('
                || curr_lexer->previous_token_is_binop ()
                || curr_lexer->previous_token_is_keyword ())
              {
                curr_lexer->m_filepos.increment_column ();
                curr_lexer->begin_string (SQ_STRING_START);
              }
            else
              {
                curr_lexer->m_filepos.increment_column ();
                return curr_lexer->count_token (HERMITIAN);
              }
          }
      }
  }
	YY_BREAK

// Double quotes always begin strings.

case 65:
YY_RULE_SETUP
#line 1579 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("\\\"");

    if (curr_lexer->previous_token_may_be_command ()
        &&  curr_lexer->space_follows_previous_token ())
      {
        curr_lexer->m_filepos.increment_column ();
        curr_lexer->push_start_state (COMMAND_START);
        curr_lexer->begin_string (DQ_STRING_START);
      }
    else
      {
        int tok = curr_lexer->previous_token_value ();

        if (curr_lexer->whitespace_is_significant ())
          {
            if (curr_lexer->space_follows_previous_token ())
              {
                if (tok == '[' || tok == '{'
                    || curr_lexer->previous_token_is_binop ())
                  {
                    curr_lexer->m_filepos.increment_column ();
                    curr_lexer->begin_string (DQ_STRING_START);
                  }
                else
                  {
                    yyless (0);
                    curr_lexer->xunput (',');
                  }
              }
            else
              {
                curr_lexer->m_filepos.increment_column ();
                curr_lexer->begin_string (DQ_STRING_START);
              }
          }
        else
          {
            curr_lexer->m_filepos.increment_column ();
            curr_lexer->begin_string (DQ_STRING_START);
          }
      }
  }
	YY_BREAK

// Other operators.

case 66:
YY_RULE_SETUP
#line 1627 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (":", ':', true); }
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 1628 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (".+", EPLUS, false); }
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 1629 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (".-", EMINUS, false); }
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 1630 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (".*", EMUL, true); }
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 1631 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("./", EDIV, true); }
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 1632 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (".\\", ELEFTDIV, true); }
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 1633 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (".^", EPOW, true); }
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 1634 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (".**", EPOW, false); }
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 1635 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("<=", EXPR_LE, true); }
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 1636 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("==", EXPR_EQ, true); }
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 1637 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("!=", EXPR_NE, false); }
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 1638 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("~=", EXPR_NE, true); }
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 1639 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (">=", EXPR_GE, true); }
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 1640 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("&", EXPR_AND, true); }
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 1641 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("|", EXPR_OR, true); }
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 1642 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("<", EXPR_LT, true); }
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 1643 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (">", EXPR_GT, true); }
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 1644 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("*", '*', true); }
	YY_BREAK
case 84:
YY_RULE_SETUP
#line 1645 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("/", '/', true); }
	YY_BREAK

// In Matlab, '\' may also trigger command syntax.

case 85:
YY_RULE_SETUP
#line 1651 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("\\");

    return curr_lexer->handle_op (LEFTDIV);
  }
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 1657 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("^", POW, true); }
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 1658 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("**", POW, false); }
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 1659 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("&&", EXPR_AND_AND, true); }
	YY_BREAK
case 89:
YY_RULE_SETUP
#line 1660 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("||", EXPR_OR_OR, true); }
	YY_BREAK
case 90:
YY_RULE_SETUP
#line 1662 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug (";");

    bool at_beginning_of_statement
      = (! (curr_lexer->whitespace_is_significant ()
            || curr_lexer->m_looking_at_object_index.front ()));

    return curr_lexer->handle_op (';', at_beginning_of_statement);
  }
	YY_BREAK
case 91:
YY_RULE_SETUP
#line 1672 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_UNARY_OP ("+", '+', true); }
	YY_BREAK
case 92:
YY_RULE_SETUP
#line 1673 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_UNARY_OP ("-", '-', true); }
	YY_BREAK
case 93:
YY_RULE_SETUP
#line 1675 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_UNARY_OP ("~", EXPR_NOT, true); }
	YY_BREAK
case 94:
YY_RULE_SETUP
#line 1676 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_UNARY_OP ("!", EXPR_NOT, false); }
	YY_BREAK
case 95:
YY_RULE_SETUP
#line 1678 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug (",");

    bool at_beginning_of_statement
      = (! (curr_lexer->whitespace_is_significant ()
            || curr_lexer->m_looking_at_object_index.front ()));

    return curr_lexer->handle_op (',', at_beginning_of_statement);
  }
	YY_BREAK
case 96:
YY_RULE_SETUP
#line 1688 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug (".'");

    return curr_lexer->handle_op (TRANSPOSE);
  }
	YY_BREAK
case 97:
YY_RULE_SETUP
#line 1694 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_UNARY_OP ("++", PLUS_PLUS, false); }
	YY_BREAK
case 98:
YY_RULE_SETUP
#line 1695 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_UNARY_OP ("--", MINUS_MINUS, false); }
	YY_BREAK
case 99:
YY_RULE_SETUP
#line 1697 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("(");

    curr_lexer->update_token_positions (yyleng);

    bool unput_comma = false;

    if (curr_lexer->whitespace_is_significant ()
        && curr_lexer->space_follows_previous_token ())
      {
        int tok = curr_lexer->previous_token_value ();

        if (! (tok == '[' || tok == '{'
               || curr_lexer->previous_token_is_binop ()))
          unput_comma = true;
      }

    if (unput_comma)
      {
        yyless (0);
        curr_lexer->xunput (',');
      }
    else
      {
        curr_lexer->update_token_positions (yyleng);

        // If we are looking for an object index, then push TRUE for
        // m_looking_at_object_index.  Otherwise, just push whatever state
        // is current (so that we can pop it off the stack when we find
        // the matching close paren).

        curr_lexer->m_looking_at_object_index.push_front
          (curr_lexer->m_looking_for_object_index);

        curr_lexer->m_looking_at_indirect_ref = false;
        curr_lexer->m_looking_for_object_index = false;
        curr_lexer->m_at_beginning_of_statement = false;

        curr_lexer->m_nesting_level.paren ();

        return curr_lexer->handle_token ('(');
      }
  }
	YY_BREAK
case 100:
YY_RULE_SETUP
#line 1741 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug (")");

    curr_lexer->update_token_positions (yyleng);

    curr_lexer->m_nesting_level.remove ();

    curr_lexer->m_looking_at_object_index.pop_front ();

    curr_lexer->m_looking_for_object_index = true;
    curr_lexer->m_at_beginning_of_statement = false;

    if (curr_lexer->m_looking_at_anon_fcn_args)
      {
        curr_lexer->m_looking_at_anon_fcn_args = false;
        curr_lexer->m_nesting_level.anon_fcn_body ();
      }

    return curr_lexer->count_token (')');
  }
	YY_BREAK
case 101:
YY_RULE_SETUP
#line 1762 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug (".");

    if (curr_lexer->previous_token_may_be_command ()
        && curr_lexer->space_follows_previous_token ())
      {
        yyless (0);
        curr_lexer->push_start_state (COMMAND_START);
      }
    else
      {
        curr_lexer->update_token_positions (yyleng);

        curr_lexer->m_looking_for_object_index = false;
        curr_lexer->m_at_beginning_of_statement = false;

        return curr_lexer->handle_token ('.');
      }
  }
	YY_BREAK

// = and op= operators.

case 102:
YY_RULE_SETUP
#line 1786 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("=");

    curr_lexer->maybe_mark_previous_token_as_variable ();

    return curr_lexer->handle_op ('=');
  }
	YY_BREAK
case 103:
YY_RULE_SETUP
#line 1794 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP ("+=", ADD_EQ); }
	YY_BREAK
case 104:
YY_RULE_SETUP
#line 1795 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP ("-=", SUB_EQ); }
	YY_BREAK
case 105:
YY_RULE_SETUP
#line 1796 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP ("*=", MUL_EQ); }
	YY_BREAK
case 106:
YY_RULE_SETUP
#line 1797 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP ("/=", DIV_EQ); }
	YY_BREAK
case 107:
YY_RULE_SETUP
#line 1798 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP ("\\=", LEFTDIV_EQ); }
	YY_BREAK
case 108:
YY_RULE_SETUP
#line 1799 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP (".+=", ADD_EQ); }
	YY_BREAK
case 109:
YY_RULE_SETUP
#line 1800 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP (".-=", SUB_EQ); }
	YY_BREAK
case 110:
YY_RULE_SETUP
#line 1801 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP (".*=", EMUL_EQ); }
	YY_BREAK
case 111:
YY_RULE_SETUP
#line 1802 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP ("./=", EDIV_EQ); }
	YY_BREAK
case 112:
YY_RULE_SETUP
#line 1803 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP (".\\=", ELEFTDIV_EQ); }
	YY_BREAK
case 113:
YY_RULE_SETUP
#line 1804 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP ("^=", POW_EQ); }
	YY_BREAK
case 114:
YY_RULE_SETUP
#line 1805 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP ("^=", POW_EQ); }
	YY_BREAK
case 115:
YY_RULE_SETUP
#line 1806 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP (".^=", EPOW_EQ); }
	YY_BREAK
case 116:
YY_RULE_SETUP
#line 1807 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP (".^=", EPOW_EQ); }
	YY_BREAK
case 117:
YY_RULE_SETUP
#line 1808 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP ("&=", AND_EQ); }
	YY_BREAK
case 118:
YY_RULE_SETUP
#line 1809 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP ("|=", OR_EQ); }
	YY_BREAK

// In Matlab, '{' may also trigger command syntax.

case 119:
YY_RULE_SETUP
#line 1815 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("{");

    bool unput_comma = false;

    if (curr_lexer->whitespace_is_significant ()
        && curr_lexer->space_follows_previous_token ())
      {
        int tok = curr_lexer->previous_token_value ();

        if (! (tok == '[' || tok == '{'
               || curr_lexer->previous_token_is_binop ()))
          unput_comma = true;
      }

    if (unput_comma)
      {
        yyless (0);
        curr_lexer->xunput (',');
      }
    else
      {
        curr_lexer->m_nesting_level.brace ();

        curr_lexer->m_looking_at_object_index.push_front
          (curr_lexer->m_looking_for_object_index);

        curr_lexer->m_filepos.increment_column (yyleng);
        curr_lexer->m_looking_for_object_index = false;
        curr_lexer->m_at_beginning_of_statement = false;

        curr_lexer->m_braceflag++;

        curr_lexer->push_start_state (MATRIX_START);

        return curr_lexer->count_token ('{');
      }
  }
	YY_BREAK
case 120:
YY_RULE_SETUP
#line 1854 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("}");

    curr_lexer->update_token_positions (yyleng);

    curr_lexer->m_looking_at_object_index.pop_front ();

    curr_lexer->m_looking_for_object_index = true;
    curr_lexer->m_at_beginning_of_statement = false;

    curr_lexer->m_nesting_level.remove ();

    return curr_lexer->handle_token ('}');
  }
	YY_BREAK

// Unrecognized input is a lexical error.

case 121:
YY_RULE_SETUP
#line 1873 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug (".");

    curr_lexer->xunput (yytext[0]);

    int c = curr_lexer->text_yyinput ();

    if (c == 1)
      return -1;
    else if (c == EOF)
      return curr_lexer->handle_end_of_input ();
    else
      {
        std::ostringstream buf;

        buf << "invalid character '"
            << octave::undo_string_escape (static_cast<char> (c))
            << "' (ASCII " << c << ")";

        // Use current file position for error token.
        octave::token *tok
          = new octave::token (LEXICAL_ERROR, buf.str (),
                               curr_lexer->m_filepos, curr_lexer->m_filepos);

        curr_lexer->push_token (tok);

        curr_lexer->m_filepos.increment_column ();

        return curr_lexer->count_token_internal (LEXICAL_ERROR);
      }
  }
	YY_BREAK

#if defined (HAVE_PRAGMA_GCC_DIAGNOSTIC)
   // Disable these warnings for flex code.
#  pragma GCC diagnostic ignored "-Wold-style-cast"
#  pragma GCC diagnostic ignored "-Wunused-parameter"
#endif

case 122:
YY_RULE_SETUP
#line 1913 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
ECHO;
	YY_BREAK
#line 3609 "libinterp/parse-tree/lex.cc"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yyg->yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( yywrap( yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = yyg->yytext_ptr;
	int number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) (yyg->yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yyg->yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  , yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size , yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_current_state = yyg->yy_start;
	yy_current_state += YY_AT_BOL();

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yyg->yy_last_accepting_state = yy_current_state;
			yyg->yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 302 )
				yy_c = yy_meta[yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
{
	int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */
	char *yy_cp = yyg->yy_c_buf_p;

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yyg->yy_last_accepting_state = yy_current_state;
		yyg->yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 302 )
			yy_c = yy_meta[yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	yy_is_jam = (yy_current_state == 301);

	(void)yyg;
	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

    static void yyunput (int c, char * yy_bp , yyscan_t yyscanner)
{
	char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    yy_cp = yyg->yy_c_buf_p;

	/* undo effects of setting up yytext */
	*yy_cp = yyg->yy_hold_char;

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		int number_to_move = yyg->yy_n_chars + 2;
		char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			yyg->yy_n_chars = (int) YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

	yyg->yytext_ptr = yy_bp;
	yyg->yy_hold_char = *yy_cp;
	yyg->yy_c_buf_p = yy_cp;
}

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr);
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin , yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( yyscanner ) )
						return 0;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = (c == '\n');

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack (yyscanner);
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file , yyscanner);
	yy_load_buffer_state( yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack (yyscanner);
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( yyscanner );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yyg->yy_did_buffer_switch_on_eof = 1;
}

static void yy_load_buffer_state  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file , yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * @param yyscanner The scanner object.
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf , yyscanner );

	yyfree( (void *) b , yyscanner );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_flush_buffer( b , yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( yyscanner );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack(yyscanner);

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		yyg->yy_buffer_stack_top++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( yyscanner );
	yyg->yy_did_buffer_switch_on_eof = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */
void yypop_buffer_state (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER , yyscanner);
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if (yyg->yy_buffer_stack_top > 0)
		--yyg->yy_buffer_stack_top;

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( yyscanner );
		yyg->yy_did_buffer_switch_on_eof = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (yyscan_t yyscanner)
{
	yy_size_t num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyrealloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b , yyscanner );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr , yyscan_t yyscanner)
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) , yyscanner);
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n , yyscanner );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n , yyscanner);
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;
	fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */
YY_EXTRA_TYPE yyget_extra  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyextra;
}

/** Get the current line number.
 * @param yyscanner The scanner object.
 */
int yyget_lineno  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yylineno;
}

/** Get the current column number.
 * @param yyscanner The scanner object.
 */
int yyget_column  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yycolumn;
}

/** Get the input stream.
 * @param yyscanner The scanner object.
 */
FILE *yyget_in  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyin;
}

/** Get the output stream.
 * @param yyscanner The scanner object.
 */
FILE *yyget_out  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyout;
}

/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */
int yyget_leng  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyleng;
}

/** Get the current token.
 * @param yyscanner The scanner object.
 */

char *yyget_text  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yytext;
}

/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void yyset_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/** Set the current line number.
 * @param _line_number line number
 * @param yyscanner The scanner object.
 */
void yyset_lineno (int  _line_number , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* lineno is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "yyset_lineno called with no buffer" );
    
    yylineno = _line_number;
}

/** Set the current column.
 * @param _column_no column number
 * @param yyscanner The scanner object.
 */
void yyset_column (int  _column_no , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* column is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "yyset_column called with no buffer" );
    
    yycolumn = _column_no;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyin = _in_str ;
}

void yyset_out (FILE *  _out_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyout = _out_str ;
}

int yyget_debug  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yy_flex_debug;
}

void yyset_debug (int  _bdebug , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yy_flex_debug = _bdebug ;
}

/* Accessor methods for yylval and yylloc */

YYSTYPE * yyget_lval  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yylval;
}

void yyset_lval (YYSTYPE *  yylval_param , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yylval = yylval_param;
}

/* User-visible API */

/* yylex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */
int yylex_init(yyscan_t* ptr_yy_globals)
{
    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), NULL );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    return yy_init_globals ( *ptr_yy_globals );
}

/* yylex_init_extra has the same functionality as yylex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to yyalloc in
 * the yyextra field.
 */
int yylex_init_extra( YY_EXTRA_TYPE yy_user_defined, yyscan_t* ptr_yy_globals )
{
    struct yyguts_t dummy_yyguts;

    yyset_extra (yy_user_defined, &dummy_yyguts);

    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), &dummy_yyguts );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in
    yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    yyset_extra (yy_user_defined, *ptr_yy_globals);

    return yy_init_globals ( *ptr_yy_globals );
}

static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = NULL;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = NULL;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER , yyscanner );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state(yyscanner);
	}

	/* Destroy the stack itself. */
	yyfree(yyg->yy_buffer_stack , yyscanner);
	yyg->yy_buffer_stack = NULL;

    /* Destroy the start condition stack. */
        yyfree( yyg->yy_start_stack , yyscanner );
        yyg->yy_start_stack = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( yyscanner);

    /* Destroy the main struct (reentrant only). */
    yyfree ( yyscanner , yyscanner );
    yyscanner = NULL;
    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;

	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s , yyscan_t yyscanner)
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

#define YYTABLES_NAME "yytables"

#line 1913 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"


#if defined (HAVE_PRAGMA_GCC_DIAGNOSTIC)
   // Restore prevailing warning state for remainder of the file.
#  pragma GCC diagnostic pop
#endif

void *
octave_alloc (yy_size_t size, yyscan_t)
{
  return std::malloc (size);
}

void *
octave_realloc (void *ptr, yy_size_t size, yyscan_t)
{
  return std::realloc (ptr, size);
}

void
octave_free (void *ptr, yyscan_t)
{
  std::free (ptr);
}

static void
display_character (char c)
{
  if (isgraph (c))
    std::cerr << c;
  else
    switch (c)
      {
      case 0:
        std::cerr << "NUL";
        break;

      case 1:
        std::cerr << "SOH";
        break;

      case 2:
        std::cerr << "STX";
        break;

      case 3:
        std::cerr << "ETX";
        break;

      case 4:
        std::cerr << "EOT";
        break;

      case 5:
        std::cerr << "ENQ";
        break;

      case 6:
        std::cerr << "ACK";
        break;

      case 7:
        std::cerr << "\\a";
        break;

      case 8:
        std::cerr << "\\b";
        break;

      case 9:
        std::cerr << "\\t";
        break;

      case 10:
        std::cerr << "\\n";
        break;

      case 11:
        std::cerr << "\\v";
        break;

      case 12:
        std::cerr << "\\f";
        break;

      case 13:
        std::cerr << "\\r";
        break;

      case 14:
        std::cerr << "SO";
        break;

      case 15:
        std::cerr << "SI";
        break;

      case 16:
        std::cerr << "DLE";
        break;

      case 17:
        std::cerr << "DC1";
        break;

      case 18:
        std::cerr << "DC2";
        break;

      case 19:
        std::cerr << "DC3";
        break;

      case 20:
        std::cerr << "DC4";
        break;

      case 21:
        std::cerr << "NAK";
        break;

      case 22:
        std::cerr << "SYN";
        break;

      case 23:
        std::cerr << "ETB";
        break;

      case 24:
        std::cerr << "CAN";
        break;

      case 25:
        std::cerr << "EM";
        break;

      case 26:
        std::cerr << "SUB";
        break;

      case 27:
        std::cerr << "ESC";
        break;

      case 28:
        std::cerr << "FS";
        break;

      case 29:
        std::cerr << "GS";
        break;

      case 30:
        std::cerr << "RS";
        break;

      case 31:
        std::cerr << "US";
        break;

      case 32:
        std::cerr << "SPACE";
        break;

      case 127:
        std::cerr << "DEL";
        break;
      }
}

DEFUN (iskeyword, args, ,
       doc: /* -*- texinfo -*-
@deftypefn  {} {} iskeyword ()
@deftypefnx {} {} iskeyword (@var{name})
Return true if @var{name} is an Octave keyword.

If @var{name} is omitted, return a list of keywords.
@seealso{isvarname, exist}
@end deftypefn */)
{
  octave_value retval;

  int nargin = args.length ();

  if (nargin > 1)
    print_usage ();

  if (nargin == 0)
    {
      // Neither set nor get are keywords.  See the note in the
      // iskeyword function for additional details.

      string_vector lst (TOTAL_KEYWORDS);

      int j = 0;

      for (int i = 0; i < TOTAL_KEYWORDS; i++)
        {
          std::string kword = wordlist[i].name;

          if (! (kword == "set" || kword == "get"
                 || kword == "enumeration" || kword == "events"
                 || kword == "methods" || kword == "properties"))
            lst[j++] = kword;
        }

      lst.resize (j);

      retval = Cell (lst.sort ());
    }
  else
    {
      std::string name = args(0).xstring_value ("iskeyword: NAME must be a string");
      retval = octave::iskeyword (name);
    }

  return retval;
}

/*

%!assert (iskeyword ("for"))
%!assert (iskeyword ("fort"), false)
%!assert (iskeyword ("fft"), false)
%!assert (iskeyword ("get"), false)
%!assert (iskeyword ("set"), false)

%!error iskeyword ("A", "B")
%!error <NAME must be a string> iskeyword (1)

*/

namespace octave
{
  void
  lexical_feedback::symbol_table_context::clear (void)
  {
    while (! m_frame_stack.empty ())
      m_frame_stack.pop_front ();
  }

  void
  lexical_feedback::symbol_table_context::pop (void)
  {
    if (empty ())
      panic_impossible ();

    m_frame_stack.pop_front ();
  }

  symbol_scope
  lexical_feedback::symbol_table_context::curr_scope (void) const
  {
    if (empty ())
      return m_interpreter.get_current_scope ();
    else
      return m_frame_stack.front ();
  }

  symbol_scope
  lexical_feedback::symbol_table_context::parent_scope (void) const
  {
    size_t sz = size ();

    return (sz > 1
            ? m_frame_stack[1]
            : (sz == 1 ? m_frame_stack[0] : symbol_scope ()));
  }

  lexical_feedback::~lexical_feedback (void)
  {
    m_tokens.clear ();
  }

  void
  lexical_feedback::init (void)
  {
    // The closest paren, brace, or bracket nesting is not an object
    // index.
    m_looking_at_object_index.push_front (false);
  }

  void
  lexical_feedback::reset (void)
  {
    m_end_of_input = false;
    m_allow_command_syntax = true;
    m_at_beginning_of_statement = true;
    m_looking_at_anon_fcn_args = false;
    m_looking_at_return_list = false;
    m_looking_at_parameter_list = false;
    m_looking_at_decl_list = false;
    m_looking_at_initializer_expression = false;
    m_looking_at_matrix_or_assign_lhs = false;
    m_looking_for_object_index = false;
    m_looking_at_indirect_ref = false;
    m_parsing_anon_fcn_body = false;
    m_parsing_class_method = false;
    m_parsing_classdef = false;
    m_parsing_classdef_decl = false;
    m_parsing_classdef_superclass = false;
    m_maybe_classdef_get_set_method = false;
    m_parsing_classdef_get_method = false;
    m_parsing_classdef_set_method = false;
    m_quote_is_transpose = false;
    m_force_script = false;
    m_reading_fcn_file = false;
    m_reading_script_file = false;
    m_reading_classdef_file = false;
    m_buffer_function_text = false;
    m_bracketflag = 0;
    m_braceflag = 0;
    m_looping = 0;
    m_defining_func = 0;
    m_looking_at_function_handle = 0;
    m_block_comment_nesting_level = 0;
    m_command_arg_paren_count = 0;
    m_token_count = 0;
    m_filepos = filepos ();
    m_tok_beg = filepos ();
    m_tok_end = filepos ();
    m_string_text = "";
    m_current_input_line = "";
    m_comment_text = "";
    m_help_text = "";
    m_function_text = "";
    m_fcn_file_name = "";
    m_fcn_file_full_name = "";
    m_dir_name = "";
    m_package_name = "";
    m_looking_at_object_index.clear ();
    m_looking_at_object_index.push_front (false);

    while (! m_parsed_function_name.empty ())
      m_parsed_function_name.pop ();

    m_pending_local_variables.clear ();
    m_symtab_context.clear ();
    m_nesting_level.reset ();
    m_tokens.clear ();
  }

  int
  lexical_feedback::previous_token_value (void) const
  {
    const token *tok = m_tokens.front ();
    return tok ? tok->token_value () : 0;
  }

  bool
  lexical_feedback::previous_token_value_is (int tok_val) const
  {
    const token *tok = m_tokens.front ();
    return tok ? tok->token_value_is (tok_val) : false;
  }

  void
  lexical_feedback::mark_previous_token_trailing_space (void)
  {
    token *tok = m_tokens.front ();
    if (tok && ! previous_token_value_is ('\n'))
      tok->mark_trailing_space ();
  }

  bool
  lexical_feedback::space_follows_previous_token (void) const
  {
    const token *tok = m_tokens.front ();
    return tok ? tok->space_follows_token () : false;
  }

  bool
  lexical_feedback::previous_token_is_binop (void) const
  {
    int tok = previous_token_value ();

    return (tok == '+' || tok == '-' || tok == '@'
            || tok == ',' || tok == ';' || tok == '*' || tok == '/'
            || tok == ':' || tok == '=' || tok == ADD_EQ
            || tok == AND_EQ || tok == DIV_EQ || tok == EDIV
            || tok == EDIV_EQ || tok == ELEFTDIV || tok == ELEFTDIV_EQ
            || tok == EMINUS || tok == EMUL || tok == EMUL_EQ
            || tok == EPOW || tok == EPOW_EQ || tok == EXPR_AND
            || tok == EXPR_AND_AND || tok == EXPR_EQ || tok == EXPR_GE
            || tok == EXPR_GT || tok == EXPR_LE || tok == EXPR_LT
            || tok == EXPR_NE || tok == EXPR_NOT || tok == EXPR_OR
            || tok == EXPR_OR_OR || tok == LEFTDIV || tok == LEFTDIV_EQ
            || tok == MUL_EQ || tok == OR_EQ || tok == POW
            || tok == POW_EQ || tok == SUB_EQ);
  }

  bool
  lexical_feedback::previous_token_is_keyword (void) const
  {
    const token *tok = m_tokens.front ();
    return tok ? tok->iskeyword () : false;
  }

  bool
  lexical_feedback::previous_token_may_be_command (void) const
  {
    if (! m_allow_command_syntax)
      return false;

    const token *tok = m_tokens.front ();
    return tok ? tok->may_be_command () : false;
  }

  void
  lexical_feedback::maybe_mark_previous_token_as_variable (void)
  {
    token *tok = m_tokens.front ();

    if (tok && tok->is_symbol ())
      m_pending_local_variables.insert (tok->symbol_name ());
  }

  void
  lexical_feedback::mark_as_variables (const std::list<std::string>& lst)
  {
    for (const auto& var : lst)
      m_pending_local_variables.insert (var);
  }
}

static bool
looks_like_copyright (const std::string& s)
{
  if (s.empty ())
    return false;

  // Comment characters have been stripped but whitespace
  // (including newlines) remains.

  size_t offset = s.find_first_not_of (" \t\n\r");

  return (offset != std::string::npos
          && (s.substr (offset, 9) == "Copyright"
              || s.substr (offset, 6) == "Author"
              || s.substr (offset, 23) == "SPDX-License-Identifier"));
}

static bool
looks_like_shebang (const std::string& s)
{
  return ((! s.empty ()) && (s[0] == '!'));
}

namespace octave
{
  void
  base_lexer::input_buffer::fill (const std::string& input, bool eof_arg)
  {
    m_buffer = input;
    m_chars_left = m_buffer.length ();
    m_offset = 0;
    m_eof = eof_arg;
  }

  // If BY_LINES is true, return chunks to the lexer line by line.
  int
  base_lexer::input_buffer::copy_chunk (char *buf, size_t max_size,
                                        bool by_lines)
  {
    static const char * const eol = "\n";

    size_t len = 0;
    if (by_lines)
      {
        size_t newline_pos = m_buffer.find ('\n', m_offset);
        len = (newline_pos != std::string::npos
               ? newline_pos - m_offset + 1
               : (max_size > m_chars_left ? m_chars_left : max_size));
      }
    else
      len = max_size > m_chars_left ? m_chars_left : max_size;

    assert (len > 0);
    memcpy (buf, m_buffer.c_str () + m_offset, len);

    m_chars_left -= len;
    m_offset += len;

    // Make sure the final input returned to the lexer ends with a new
    // line character.

    if (m_chars_left == 0 && buf[len-1] != '\n')
      {
        if (len < max_size)
          {
            // There is enough room to plug the newline character in
            // the buffer.
            buf[len++] = '\n';
          }
        else
          {
            // There isn't enough room to plug the newline character
            // in BUF so arrange to have it returned on the next call
            // to base_lexer::read.

            // At this point we've exhausted the original input
            // (m_chars_left is zero) so we can overwrite the initial
            // buffer with a single newline character to be returned on
            // the next call.

            m_buffer = eol;
            m_chars_left = 1;
            m_offset = 0;
          }
      }

    return len;
  }

  base_lexer::~base_lexer (void)
  {
    yylex_destroy (m_scanner);
  }

  void
  base_lexer::init (void)
  {
    yylex_init (&m_scanner);

    // Make base_lexer object available through yyextra in
    // flex-generated lexer.
    yyset_extra (this, m_scanner);

    clear_start_state ();
  }

  // Inside Flex-generated functions, yyg is the scanner cast to its real
  // type.  Some flex macros that we use in base_lexer member functions
  // (for example, BEGIN) use yyg.  If we could perform the actions of
  // these macros with functions instead, we could eliminate the
  // OCTAVE_YYG macro.

#define OCTAVE_YYG                                                      \
  struct yyguts_t *yyg = static_cast<struct yyguts_t*> (m_scanner)

  void
  base_lexer::reset (void)
  {
    // Start off on the right foot.
    clear_start_state ();

    m_symtab_context.clear ();

    // Only ask for input from stdin if we are expecting interactive
    // input.

    if (m_interpreter.interactive ()
        && ! (m_reading_fcn_file
              || m_reading_classdef_file
              || m_reading_script_file
              || input_from_eval_string ()))
      yyrestart (stdin, m_scanner);

    lexical_feedback::reset ();

    m_comment_buf.reset ();
  }

  void
  base_lexer::prep_for_file (void)
  {
    m_reading_script_file = true;

    push_start_state (INPUT_FILE_START);
  }

  void
  base_lexer::begin_string (int state)
  {
    m_tok_beg = m_filepos;

    push_start_state (state);
  }

  int
  base_lexer::handle_end_of_input (void)
  {
    lexer_debug ("<<EOF>>");

    m_tok_beg = m_filepos;
    m_tok_end = m_filepos;

    if (m_block_comment_nesting_level != 0)
      {
        warning ("block comment open at end of input");

        if ((m_reading_fcn_file || m_reading_script_file || m_reading_classdef_file)
            && ! m_fcn_file_name.empty ())
          warning ("near line %d of file '%s.m'",
                   m_filepos.line (), m_fcn_file_name.c_str ());
      }

    token *tok_val = new token (END_OF_INPUT, m_tok_beg, m_tok_end);

    push_token (tok_val);

    return count_token_internal (END_OF_INPUT);
  }

  char *
  base_lexer::flex_yytext (void)
  {
    return yyget_text (m_scanner);
  }

  int
  base_lexer::flex_yyleng (void)
  {
    return yyget_leng (m_scanner);
  }

  int
  base_lexer::text_yyinput (void)
  {
    int c = yyinput (m_scanner);

    if (debug_flag ())
      {
        std::cerr << "I: ";
        display_character (c);
        std::cerr << std::endl;
      }

    // Convert CRLF into just LF and single CR into LF.

    if (c == '\r')
      {
        c = yyinput (m_scanner);

        if (debug_flag ())
          {
            std::cerr << "I: ";
            display_character (c);
            std::cerr << std::endl;
          }

        if (c != '\n')
          {
            xunput (c);
            c = '\n';
          }
      }

    return c;
  }

  void
  base_lexer::xunput (char c, char *buf)
  {
    if (c != EOF)
      {
        if (debug_flag ())
          {
            std::cerr << "U: ";
            display_character (c);
            std::cerr << std::endl;
          }

        yyunput (c, buf, m_scanner);
      }
  }

  void
  base_lexer::xunput (char c)
  {
    char *yytxt = flex_yytext ();

    xunput (c, yytxt);
  }

  void
  base_lexer::update_token_positions (int tok_len)
  {
    m_tok_beg = m_filepos;
    m_tok_end = m_filepos;

    if (tok_len > 1)
      m_tok_end.increment_column (tok_len - 1);

    m_filepos.increment_column (tok_len);
  }

bool
  base_lexer::looking_at_space (void)
  {
    int c = text_yyinput ();
    xunput (c);
    return is_space_or_tab (c);
  }

  bool
  base_lexer::inside_any_object_index (void)
  {
    bool retval = false;

    for (const bool is_obj_idx : m_looking_at_object_index)
      {
        if (is_obj_idx)
          {
            retval = true;
            break;
          }
      }

    return retval;
  }

  bool
  base_lexer::is_variable (const std::string& name,
                           const symbol_scope& /*scope*/)
  {
    return ((m_interpreter.at_top_level ()
             && m_interpreter.is_variable (name))
            || (m_pending_local_variables.find (name)
                != m_pending_local_variables.end ()));
  }

  int
  base_lexer::make_keyword_token (const std::string& s)
  {
    int slen = s.length ();

    const octave_kw *kw = octave_kw_hash::in_word_set (s.c_str (), slen);

    if (! kw)
      return 0;

    bool previous_at_bos = m_at_beginning_of_statement;

    // May be reset to true for some token types.
    m_at_beginning_of_statement = false;

    update_token_positions (slen);

    token *tok_val = nullptr;

    switch (kw->kw_id)
      {
      case break_kw:
      case catch_kw:
      case continue_kw:
      case else_kw:
      case otherwise_kw:
      case return_kw:
      case unwind_protect_cleanup_kw:
        m_at_beginning_of_statement = true;
        break;

      case persistent_kw:
      case global_kw:
        m_looking_at_decl_list = true;
        break;

      case case_kw:
      case elseif_kw:
      case until_kw:
        break;

      case end_kw:
        if (inside_any_object_index ()
            || (m_defining_func
                && ! (m_looking_at_return_list
                      || m_parsed_function_name.top ())))
          {
            m_at_beginning_of_statement = previous_at_bos;
            return 0;
          }

        tok_val = new token (end_kw, token::simple_end, m_tok_beg, m_tok_end);
        m_at_beginning_of_statement = true;
        break;

      case end_try_catch_kw:
        tok_val = new token (end_try_catch_kw, token::try_catch_end, m_tok_beg,
                             m_tok_end);
        m_at_beginning_of_statement = true;
        break;

      case end_unwind_protect_kw:
        tok_val = new token (end_unwind_protect_kw,
                             token::unwind_protect_end, m_tok_beg, m_tok_end);
        m_at_beginning_of_statement = true;
        break;

      case endfor_kw:
        tok_val = new token (endfor_kw, token::for_end, m_tok_beg, m_tok_end);
        m_at_beginning_of_statement = true;
        break;

      case endfunction_kw:
        tok_val = new token (endfunction_kw, token::function_end, m_tok_beg,
                             m_tok_end);
        m_at_beginning_of_statement = true;
        break;

      case endif_kw:
        tok_val = new token (endif_kw, token::if_end, m_tok_beg, m_tok_end);
        m_at_beginning_of_statement = true;
        break;

      case endparfor_kw:
        tok_val = new token (endparfor_kw, token::parfor_end, m_tok_beg,
                             m_tok_end);
        m_at_beginning_of_statement = true;
        break;

      case endswitch_kw:
        tok_val = new token (endswitch_kw, token::switch_end, m_tok_beg,
                             m_tok_end);
        m_at_beginning_of_statement = true;
        break;

      case endwhile_kw:
        tok_val = new token (endwhile_kw, token::while_end, m_tok_beg,
                             m_tok_end);
        m_at_beginning_of_statement = true;
        break;

      case endclassdef_kw:
        tok_val = new token (endclassdef_kw, token::classdef_end, m_tok_beg,
                             m_tok_end);
        m_at_beginning_of_statement = true;
        break;

      case endenumeration_kw:
        tok_val = new token (endenumeration_kw, token::enumeration_end,
                             m_tok_beg, m_tok_end);
        m_at_beginning_of_statement = true;
        break;

      case endevents_kw:
        tok_val = new token (endevents_kw, token::events_end, m_tok_beg,
                             m_tok_end);
        m_at_beginning_of_statement = true;
        break;

      case endmethods_kw:
        tok_val = new token (endmethods_kw, token::methods_end, m_tok_beg,
                             m_tok_end);
        m_at_beginning_of_statement = true;
        break;

      case endproperties_kw:
        tok_val = new token (endproperties_kw, token::properties_end, m_tok_beg,
                             m_tok_end);
        m_at_beginning_of_statement = true;
        break;


      case for_kw:
      case parfor_kw:
      case while_kw:
        m_looping++;
        break;

      case do_kw:
        m_at_beginning_of_statement = true;
        m_looping++;
        break;

      case try_kw:
      case unwind_protect_kw:
        m_at_beginning_of_statement = true;
        break;

      case if_kw:
      case switch_kw:
        break;

      case get_kw:
      case set_kw:
        // 'get' and 'set' are keywords in classdef method
        // declarations.
        if (! m_maybe_classdef_get_set_method)
          {
            m_at_beginning_of_statement = previous_at_bos;
            return 0;
          }
        break;

      case enumeration_kw:
      case events_kw:
      case methods_kw:
      case properties_kw:
        // 'properties', 'methods' and 'events' are keywords for
        // classdef blocks.
        if (! m_parsing_classdef)
          {
            m_at_beginning_of_statement = previous_at_bos;
            return 0;
          }
        // fall through ...

      case classdef_kw:
        // 'classdef' is always a keyword.
        if (! m_force_script && m_token_count == 0 && input_from_file ())
          {
            m_reading_classdef_file = true;
            m_reading_script_file = false;
          }
        break;

      case function_kw:
        m_defining_func++;
        m_parsed_function_name.push (false);

        if (! m_force_script && m_token_count == 0 && input_from_file ())
          {
            m_reading_fcn_file = true;
            m_reading_script_file = false;
          }

        if (! (m_reading_fcn_file || m_reading_script_file
               || m_reading_classdef_file))
          {
            // Input must be coming from the terminal or stdin?
            m_buffer_function_text = true;
            m_function_text += (m_current_input_line + "\n");

            // FIXME: do we need to save and restore the file position
            // or just reset the line number here?  The goal is to
            // track line info for command-line functions relative
            // to the function keyword.

            m_filepos = filepos ();
            update_token_positions (slen);
          }
        break;

      case magic_file_kw:
        {
          if ((m_reading_fcn_file || m_reading_script_file
               || m_reading_classdef_file)
              && ! m_fcn_file_full_name.empty ())
            tok_val = new token (magic_file_kw, m_fcn_file_full_name,
                                 m_tok_beg, m_tok_end);
          else
            tok_val = new token (magic_file_kw, "stdin", m_tok_beg, m_tok_end);
        }
        break;

      case magic_line_kw:
        {
          int l = m_tok_beg.line ();
          tok_val = new token (magic_line_kw, static_cast<double> (l),
                               "", m_tok_beg, m_tok_end);
        }
        break;

      default:
        panic_impossible ();
      }

    if (! tok_val)
      tok_val = new token (kw->tok, true, m_tok_beg, m_tok_end);

    push_token (tok_val);

    return kw->tok;
  }

  bool
  base_lexer::fq_identifier_contains_keyword (const std::string& s)
  {
    size_t p1 = 0;
    size_t p2;

    std::string s_part;

    do
      {
        p2 = s.find ('.', p1);

        if (p2 != std::string::npos)
          {
            s_part = s.substr (p1, p2 - p1);
            p1 = p2 + 1;
          }
        else
          s_part = s.substr (p1);

        if (iskeyword (s_part))
          return true;
      }
    while (p2 != std::string::npos);

    return false;
  }

  bool
  base_lexer::whitespace_is_significant (void)
  {
    return (m_nesting_level.is_bracket ()
            || (m_nesting_level.is_brace ()
                && ! m_looking_at_object_index.front ()));
  }
}

static inline bool
looks_like_bin (const char *s, int len)
{
  return (len > 2 && s[0] == '0' && (s[1] == 'b' || s[1] == 'B'));
}

static inline bool
looks_like_hex (const char *s, int len)
{
  return (len > 2 && s[0] == '0' && (s[1] == 'x' || s[1] == 'X'));
}

namespace octave
{
  void
  base_lexer::handle_number (void)
  {
    double value = 0.0;
    int nread = 0;

    char *yytxt = flex_yytext ();

    // Strip any underscores
    char *tmptxt = strsave (yytxt);
    char *rptr = tmptxt;
    char *wptr = tmptxt;
    while (*rptr)
      {
        *wptr = *rptr++;
        wptr += (*wptr != '_');
      }
    *wptr = '\0';

    if (looks_like_hex (tmptxt, strlen (tmptxt)))
      {
        uintmax_t long_int_value;

        nread = sscanf (tmptxt, "%jx", &long_int_value);

        value = static_cast<double> (long_int_value);
      }
    else if (looks_like_bin (tmptxt, strlen (tmptxt)))
      {
        uintmax_t long_int_value = 0;

        for (size_t i = 0; i < strlen (tmptxt); i++)
          {
            if (tmptxt[i] == '0')
              long_int_value <<= 1;
            else if (tmptxt[i] == '1')
            {
              long_int_value <<= 1;
              long_int_value += 1;
            }
          }

        value = static_cast<double> (long_int_value);

        nread = 1;  // Just to pass the assert stmt below
      }
    else
      {
        char *idx = strpbrk (tmptxt, "Dd");

        if (idx)
          *idx = 'e';

        nread = sscanf (tmptxt, "%lf", &value);
      }

    delete [] tmptxt;

    // If yytext doesn't contain a valid number, we are in deep doo doo.

    assert (nread == 1);

    m_looking_for_object_index = false;
    m_at_beginning_of_statement = false;

    update_token_positions (flex_yyleng ());

    push_token (new token (NUM, value, yytxt, m_tok_beg, m_tok_end));
  }

  void
  base_lexer::handle_continuation (void)
  {
    char *yytxt = flex_yytext ();
    int yylng = flex_yyleng ();

    int offset = 1;
    if (yytxt[0] == '\\')
      warn_language_extension_continuation ();
    else
      offset = 3;

    bool have_space = false;
    while (offset < yylng)
      {
        char c = yytxt[offset];
        if (is_space_or_tab (c))
          {
            have_space = true;
            offset++;
          }
        else
          break;
      }

    if (have_space)
      mark_previous_token_trailing_space ();

    bool have_comment = false;
    while (offset < yylng)
      {
        char c = yytxt[offset];
        if (c == '#' || c == '%')
          {
            have_comment = true;
            offset++;
          }
        else
          break;
      }

    if (have_comment)
      {
        m_comment_text = &yytxt[offset];

        // finish_comment sets m_at_beginning_of_statement to true but
        // that's not be correct if we are handling a continued
        // statement.  Preserve the current state.

        bool saved_bos = m_at_beginning_of_statement;

        finish_comment (comment_elt::end_of_line);

        m_at_beginning_of_statement = saved_bos;
      }

    m_filepos.next_line ();
  }

  void
  base_lexer::finish_comment (comment_elt::comment_type typ)
  {
    bool copyright = looks_like_copyright (m_comment_text);

    if (m_nesting_level.none () && m_help_text.empty () && ! m_comment_text.empty ()
        && ! copyright && ! looks_like_shebang (m_comment_text))
      m_help_text = m_comment_text;

    if (copyright)
      typ = comment_elt::copyright;

    m_comment_buf.append (m_comment_text, typ);

    m_comment_text = "";

    m_at_beginning_of_statement = true;
  }

  int
  base_lexer::handle_close_bracket (int bracket_type)
  {
    m_looking_at_object_index.pop_front ();

    m_looking_for_object_index = true;
    m_at_beginning_of_statement = false;

    if (! m_nesting_level.none ())
      {
        m_nesting_level.remove ();

        if (bracket_type == ']')
          m_bracketflag--;
        else if (bracket_type == '}')
          m_braceflag--;
        else
          panic_impossible ();
      }

    pop_start_state ();

    return count_token (bracket_type);
  }

  bool
  base_lexer::looks_like_command_arg (void)
  {
    if (! m_allow_command_syntax)
      return false;

    bool space_before = space_follows_previous_token ();
    bool space_after = looking_at_space ();

    return (space_before && ! space_after
            && previous_token_may_be_command ());
  }

  int
  base_lexer::handle_superclass_identifier (void)
  {
    update_token_positions (flex_yyleng ());

    std::string txt = flex_yytext ();

    txt.erase (std::remove_if (txt.begin (), txt.end (), is_space_or_tab),
               txt.end ());

    size_t pos = txt.find ("@");

    std::string meth = txt.substr (0, pos);
    std::string cls = txt.substr (pos + 1);

    if (iskeyword (meth) || fq_identifier_contains_keyword (cls))
      {
        token *tok
          = new token (LEXICAL_ERROR,
                       "method, class, and package names may not be keywords",
                       m_tok_beg, m_tok_end);

        push_token (tok);

        return count_token_internal (LEXICAL_ERROR);
      }

    push_token (new token (SUPERCLASSREF, meth, cls, m_tok_beg, m_tok_end));

    m_filepos.increment_column (flex_yyleng ());

    return count_token_internal (SUPERCLASSREF);
  }

  int
  base_lexer::handle_meta_identifier (void)
  {
    std::string txt = flex_yytext ();

    txt.erase (std::remove_if (txt.begin (), txt.end (), is_space_or_tab),
               txt.end ());

    // Eliminate leading '?'
    std::string cls = txt.substr (1);

    // Token positions should have already been updated before this
    // function is called.

    if (fq_identifier_contains_keyword (cls))
      {
        token *tok = new token (LEXICAL_ERROR,
                                "class and package names may not be keywords",
                                m_tok_beg, m_tok_end);
        push_token (tok);

        return count_token_internal (LEXICAL_ERROR);
      }

    push_token (new token (METAQUERY, cls, m_tok_beg, m_tok_end));

    m_filepos.increment_column (flex_yyleng ());

    return METAQUERY;
  }

  int
  base_lexer::handle_fq_identifier (void)
  {
    std::string txt = flex_yytext ();

    txt.erase (std::remove_if (txt.begin (), txt.end (), is_space_or_tab),
               txt.end ());

    // Token positions should have already been updated before this
    // function is called.

    if (fq_identifier_contains_keyword (txt))
      {
        token *tok
          = new token (LEXICAL_ERROR,
                       "function, method, class, and package names may not be keywords",
                       m_tok_beg, m_tok_end);

        push_token (tok);

        return count_token_internal (LEXICAL_ERROR);
      }

    push_token (new token (FQ_IDENT, txt, m_tok_beg, m_tok_end));

    m_filepos.increment_column (flex_yyleng ());

    return FQ_IDENT;
  }

  // Figure out exactly what kind of token to return when we have seen
  // an identifier.  Handles keywords.  Return -1 if the identifier
  // should be ignored.

  int
  base_lexer::handle_identifier (void)
  {
    update_token_positions (flex_yyleng ());

    std::string ident = flex_yytext ();

    // If we are expecting a structure element, avoid recognizing
    // keywords and other special names and return STRUCT_ELT, which is
    // a string that is also a valid identifier.

    if (m_looking_at_indirect_ref)
      {
        push_token (new token (STRUCT_ELT, ident, m_tok_beg, m_tok_end));

        m_looking_for_object_index = true;

        return STRUCT_ELT;
      }

    // If ident is a keyword token, then make_keyword_token will set
    // m_at_beginning_of_statement.  For example, if tok is an IF
    // token, then m_at_beginning_of_statement will be false.

    int kw_token = make_keyword_token (ident);

    // If we have a regular keyword, return it.
    // Keywords can be followed by identifiers.

    if (kw_token)
      {
        m_looking_for_object_index = false;

        // The call to make_keyword_token set m_at_beginning_of_statement.

        return count_token_internal (kw_token);
      }

    // Find the token in the symbol table.

    symbol_scope scope = m_symtab_context.curr_scope ();

    symbol_record sr = (scope ? scope.insert (ident) : symbol_record (ident));

    token *tok = new token (NAME, sr, m_tok_beg, m_tok_end);

    // The following symbols are handled specially so that things like
    //
    //   pi +1
    //
    // are parsed as an addition expression instead of as a command-style
    // function call with the argument "+1".

    if (m_at_beginning_of_statement
        && ! (m_parsing_anon_fcn_body
              || is_variable (ident, scope)
              || ident == "e" || ident == "pi"
              || ident == "I" || ident == "i"
              || ident == "J" || ident == "j"
              || ident == "Inf" || ident == "inf"
              || ident == "NaN" || ident == "nan"))
      tok->mark_may_be_command ();

    push_token (tok);

    // The magic end index can't be indexed.

    if (ident != "end")
      m_looking_for_object_index = true;

    m_at_beginning_of_statement = false;

    return count_token_internal (NAME);
  }

  void
  base_lexer::maybe_warn_separator_insert (char sep)
  {
    std::string nm = m_fcn_file_full_name;

    if (nm.empty ())
      warning_with_id ("Octave:separator-insert",
                       "potential auto-insertion of '%c' near line %d",
                       sep, m_filepos.line ());
    else
      warning_with_id ("Octave:separator-insert",
                       "potential auto-insertion of '%c' near line %d of file %s",
                       sep, m_filepos.line (), nm.c_str ());
  }

  void
  base_lexer::warn_single_quote_string (void)
  {
    std::string nm = m_fcn_file_full_name;

    if (nm.empty ())
      warning_with_id ("Octave:single-quote-string",
                       "single quote delimited string near line %d",
                       m_filepos.line ());
    else
      warning_with_id ("Octave:single-quote-string",
                       "single quote delimited string near line %d of file %s",
                       m_filepos.line (), nm.c_str ());
  }

  void
  base_lexer::warn_language_extension (const std::string& msg)
  {
    std::string nm = m_fcn_file_full_name;

    if (nm.empty ())
      warning_with_id ("Octave:language-extension",
                       "Octave language extension used: %s",
                       msg.c_str ());
    else
      warning_with_id ("Octave:language-extension",
                       "Octave language extension used: %s near line %d offile %s",
                       msg.c_str (), m_filepos.line (), nm.c_str ());
  }

  void
  base_lexer::maybe_warn_language_extension_comment (char c)
  {
    if (c == '#')
      warn_language_extension ("# used as comment character");
  }

  void
  base_lexer::warn_language_extension_continuation (void)
  {
    warn_language_extension ("\\ used as line continuation marker");
  }

  void
  base_lexer::warn_language_extension_operator (const std::string& op)
  {
    std::string t = op;
    int n = t.length ();
    if (t[n-1] == '\n')
      t.resize (n-1);
    warn_language_extension (t + " used as operator");
  }

  void
  base_lexer::push_token (token *tok)
  {
    YYSTYPE *lval = yyget_lval (m_scanner);
    lval->tok_val = tok;
    m_tokens.push (tok);
  }

  token *
  base_lexer::current_token (void)
  {
    YYSTYPE *lval = yyget_lval (m_scanner);
    return lval->tok_val;
  }

  size_t
  base_lexer::pending_token_count (void) const
  {
    return m_tokens.size ();
  }

  void
  base_lexer::display_token (int tok)
  {
    switch (tok)
      {
      case '=': std::cerr << "'='\n"; break;
      case ':': std::cerr << "':'\n"; break;
      case '-': std::cerr << "'-'\n"; break;
      case '+': std::cerr << "'+'\n"; break;
      case '*': std::cerr << "'*'\n"; break;
      case '/': std::cerr << "'/'\n"; break;
      case ADD_EQ: std::cerr << "ADD_EQ\n"; break;
      case SUB_EQ: std::cerr << "SUB_EQ\n"; break;
      case MUL_EQ: std::cerr << "MUL_EQ\n"; break;
      case DIV_EQ: std::cerr << "DIV_EQ\n"; break;
      case LEFTDIV_EQ: std::cerr << "LEFTDIV_EQ\n"; break;
      case POW_EQ: std::cerr << "POW_EQ\n"; break;
      case EMUL_EQ: std::cerr << "EMUL_EQ\n"; break;
      case EDIV_EQ: std::cerr << "EDIV_EQ\n"; break;
      case ELEFTDIV_EQ: std::cerr << "ELEFTDIV_EQ\n"; break;
      case EPOW_EQ: std::cerr << "EPOW_EQ\n"; break;
      case AND_EQ: std::cerr << "AND_EQ\n"; break;
      case OR_EQ: std::cerr << "OR_EQ\n"; break;
      case EXPR_AND_AND: std::cerr << "EXPR_AND_AND\n"; break;
      case EXPR_OR_OR: std::cerr << "EXPR_OR_OR\n"; break;
      case EXPR_AND: std::cerr << "EXPR_AND\n"; break;
      case EXPR_OR: std::cerr << "EXPR_OR\n"; break;
      case EXPR_NOT: std::cerr << "EXPR_NOT\n"; break;
      case EXPR_LT: std::cerr << "EXPR_LT\n"; break;
      case EXPR_LE: std::cerr << "EXPR_LE\n"; break;
      case EXPR_EQ: std::cerr << "EXPR_EQ\n"; break;
      case EXPR_NE: std::cerr << "EXPR_NE\n"; break;
      case EXPR_GE: std::cerr << "EXPR_GE\n"; break;
      case EXPR_GT: std::cerr << "EXPR_GT\n"; break;
      case LEFTDIV: std::cerr << "LEFTDIV\n"; break;
      case EMUL: std::cerr << "EMUL\n"; break;
      case EDIV: std::cerr << "EDIV\n"; break;
      case ELEFTDIV: std::cerr << "ELEFTDIV\n"; break;
      case EPLUS: std::cerr << "EPLUS\n"; break;
      case EMINUS: std::cerr << "EMINUS\n"; break;
      case HERMITIAN: std::cerr << "HERMITIAN\n"; break;
      case TRANSPOSE: std::cerr << "TRANSPOSE\n"; break;
      case PLUS_PLUS: std::cerr << "PLUS_PLUS\n"; break;
      case MINUS_MINUS: std::cerr << "MINUS_MINUS\n"; break;
      case POW: std::cerr << "POW\n"; break;
      case EPOW: std::cerr << "EPOW\n"; break;

      case NUM:
      case IMAG_NUM:
        {
          token *tok_val = current_token ();
          std::cerr << (tok == NUM ? "NUM" : "IMAG_NUM")
                    << " [" << tok_val->number () << "]\n";
        }
        break;

      case STRUCT_ELT:
        {
          token *tok_val = current_token ();
          std::cerr << "STRUCT_ELT [" << tok_val->text () << "]\n";
        }
        break;

      case NAME:
        {
          token *tok_val = current_token ();
          symbol_record sr = tok_val->sym_rec ();
          std::cerr << "NAME [" << sr.name () << "]\n";
        }
        break;

      case END: std::cerr << "END\n"; break;

      case DQ_STRING:
      case SQ_STRING:
        {
          token *tok_val = current_token ();

          std::cerr << (tok == DQ_STRING ? "DQ_STRING" : "SQ_STRING")
                    << " [" << tok_val->text () << "]\n";
        }
        break;

      case FOR: std::cerr << "FOR\n"; break;
      case WHILE: std::cerr << "WHILE\n"; break;
      case DO: std::cerr << "DO\n"; break;
      case UNTIL: std::cerr << "UNTIL\n"; break;
      case IF: std::cerr << "IF\n"; break;
      case ELSEIF: std::cerr << "ELSEIF\n"; break;
      case ELSE: std::cerr << "ELSE\n"; break;
      case SWITCH: std::cerr << "SWITCH\n"; break;
      case CASE: std::cerr << "CASE\n"; break;
      case OTHERWISE: std::cerr << "OTHERWISE\n"; break;
      case BREAK: std::cerr << "BREAK\n"; break;
      case CONTINUE: std::cerr << "CONTINUE\n"; break;
      case FUNC_RET: std::cerr << "FUNC_RET\n"; break;
      case UNWIND: std::cerr << "UNWIND\n"; break;
      case CLEANUP: std::cerr << "CLEANUP\n"; break;
      case TRY: std::cerr << "TRY\n"; break;
      case CATCH: std::cerr << "CATCH\n"; break;
      case GLOBAL: std::cerr << "GLOBAL\n"; break;
      case PERSISTENT: std::cerr << "PERSISTENT\n"; break;
      case FCN_HANDLE: std::cerr << "FCN_HANDLE\n"; break;
      case END_OF_INPUT: std::cerr << "END_OF_INPUT\n\n"; break;
      case LEXICAL_ERROR: std::cerr << "LEXICAL_ERROR\n\n"; break;
      case FCN: std::cerr << "FCN\n"; break;
      case INPUT_FILE: std::cerr << "INPUT_FILE\n"; break;
      case SUPERCLASSREF: std::cerr << "SUPERCLASSREF\n"; break;
      case METAQUERY: std::cerr << "METAQUERY\n"; break;
      case GET: std::cerr << "GET\n"; break;
      case SET: std::cerr << "SET\n"; break;
      case PROPERTIES: std::cerr << "PROPERTIES\n"; break;
      case METHODS: std::cerr << "METHODS\n"; break;
      case EVENTS: std::cerr << "EVENTS\n"; break;
      case CLASSDEF: std::cerr << "CLASSDEF\n"; break;
      case '\n': std::cerr << "\\n\n"; break;
      case '\r': std::cerr << "\\r\n"; break;
      case '\t': std::cerr << "TAB\n"; break;
      default:
        {
          if (tok < 256 && tok > 31)
            std::cerr << static_cast<char> (tok) << "\n";
          else
            std::cerr << "UNKNOWN(" << tok << ")\n";
        }
        break;
      }
  }

  void
  base_lexer::fatal_error (const char *msg)
  {
    error ("fatal lexer error: %s", msg);
  }

  bool
  base_lexer::debug_flag (void) const
  {
    settings& stgs = m_interpreter.get_settings ();
    return stgs.lexer_debug_flag ();
  }

  bool
  base_lexer::display_tokens (void) const
  {
    settings& stgs = m_interpreter.get_settings ();
    return stgs.display_tokens ();
  }

  void
  base_lexer::increment_token_count (void)
  {
    settings& stgs = m_interpreter.get_settings ();
    stgs.increment_token_count ();

    m_token_count++;
  }

  void
  base_lexer::lexer_debug (const char *pattern)
  {
    if (debug_flag ())
      {
        std::cerr << std::endl;

        display_start_state ();

        std::cerr << "P: " << pattern << std::endl;
        std::cerr << "T: " << flex_yytext () << std::endl;
      }
  }

  bool
  base_lexer::input_from_tmp_history_file (void)
  {
    history_system& history_sys = m_interpreter.get_history_system ();

    return history_sys.input_from_tmp_file ();
  }

  void
  base_lexer::push_start_state (int state)
  {
    OCTAVE_YYG;

    start_state_stack.push (state);

    BEGIN (start_state ());
  }

  void
  base_lexer::pop_start_state (void)
  {
    OCTAVE_YYG;

    start_state_stack.pop ();

    BEGIN (start_state ());
  }

  void
  base_lexer::clear_start_state (void)
  {
    while (! start_state_stack.empty ())
      start_state_stack.pop ();

    push_start_state (INITIAL);
  }

  void
  base_lexer::display_start_state (void) const
  {
    std::cerr << "S: ";

    switch (start_state ())
      {
      case INITIAL:
        std::cerr << "INITIAL" << std::endl;
        break;

      case COMMAND_START:
        std::cerr << "COMMAND_START" << std::endl;
        break;

      case MATRIX_START:
        std::cerr << "MATRIX_START" << std::endl;
        break;

      case INPUT_FILE_START:
        std::cerr << "INPUT_FILE_START" << std::endl;
        break;

      case BLOCK_COMMENT_START:
        std::cerr << "BLOCK_COMMENT_START" << std::endl;
        break;

      case LINE_COMMENT_START:
        std::cerr << "LINE_COMMENT_START" << std::endl;
        break;

      case DQ_STRING_START:
        std::cerr << "DQ_STRING_START" << std::endl;
        break;

      case SQ_STRING_START:
        std::cerr << "SQ_STRING_START" << std::endl;
        break;

      case FQ_IDENT_START:
        std::cerr << "FQ_IDENT_START" << std::endl;
        break;

      default:
        std::cerr << "UNKNOWN START STATE!" << std::endl;
        break;
      }
  }

  bool
  base_lexer::maybe_unput_comma_before_unary_op (int tok)
  {
    int prev_tok = previous_token_value ();

    bool unput_comma = false;

    if (whitespace_is_significant () && space_follows_previous_token ())
      {
        int c = text_yyinput ();
        xunput (c);

        bool space_after = is_space_or_tab (c);

        if (! (prev_tok == '[' || prev_tok == '{'
               || previous_token_is_binop ()
               || ((tok == '+' || tok == '-') && space_after)))
          unput_comma = true;
      }

    return unput_comma;
  }

  int
  base_lexer::handle_op (int tok, bool bos, bool compat)
  {
    if (! compat)
      warn_language_extension_operator (flex_yytext ());

    update_token_positions (flex_yyleng ());

    push_token (new token (tok, m_tok_beg, m_tok_end));

    m_looking_for_object_index = false;
    m_at_beginning_of_statement = bos;

    switch (tok)
      {
      case EXPR_LT:
        if (m_parsing_classdef_decl)
          {
            m_parsing_classdef_superclass = true;
            push_start_state (FQ_IDENT_START);
          }
        break;

      case EXPR_AND:
        if (m_parsing_classdef_superclass)
          push_start_state (FQ_IDENT_START);
        break;

      default:
        break;
      }

    return count_token_internal (tok);
  }

  // When a command argument boundary is detected, push out the current
  // argument being built.  This one seems like a good candidate for a
  // function call.

  int
  base_lexer::finish_command_arg (void)
  {
    int tok = SQ_STRING;

    token *tok_val = new token (tok, m_string_text, m_tok_beg, m_tok_end);

    m_string_text = "";
    m_command_arg_paren_count = 0;

    return handle_token (tok, tok_val);
  }

  int
  base_lexer::handle_token (int tok, token *tok_val)
  {
    if (! tok_val)
      tok_val = new token (tok, m_tok_beg, m_tok_end);

    push_token (tok_val);

    return count_token_internal (tok);
  }

  int
  base_lexer::count_token (int tok)
  {
    token *tok_val = new token (tok, m_tok_beg, m_tok_end);

    push_token (tok_val);

    return count_token_internal (tok);
  }

  int
  base_lexer::count_token_internal (int tok)
  {
    if (tok != '\n')
      increment_token_count ();

    return show_token (tok);
  }

  int
  base_lexer::show_token (int tok)
  {

    if (display_tokens ())
      display_token (tok);

    if (debug_flag ())
      {
        std::cerr << "R: ";
        display_token (tok);
        std::cerr << std::endl;
      }

    return tok;
  }

  int
  lexer::fill_flex_buffer (char *buf, unsigned max_size)
  {
    int status = 0;

    if (m_input_buf.empty ())
      {
        input_system& input_sys = m_interpreter.get_input_system ();

        std::string ps
          = m_initial_input ? input_sys.PS1 () : input_sys.PS2 ();

        std::string prompt = command_editor::decode_prompt_string (ps);

        bool eof = false;
        m_current_input_line = m_reader.get_input (prompt, eof);

        m_input_buf.fill (m_current_input_line, eof);

        // Attempt to capture text for functions defined on the
        // command line.
        //
        // FIXME: the handling of newline here seems a bit clumsy.
        //
        // See also comments in push_lexer::append_input.

        if (m_buffer_function_text)
          {
            if (! m_current_input_line.empty ())
            {
              m_function_text += m_current_input_line;
              if (m_current_input_line.back () != '\n')
                m_function_text += '\n';
            }
          }
      }

    if (! m_input_buf.empty ())
      status = m_input_buf.copy_chunk (buf, max_size);
    else
      status = YY_NULL;

    m_initial_input = false;

    return status;
  }

  void
  push_lexer::append_input (const std::string& input, bool eof)
  {
    // FIXME: input may contain more than one line, so how can we
    // properly start buffering input for command-line functions?
    //
    // Currently, base_lexer::make_keyword_token starts buffering text
    // for command-line functions by setting the initial value of
    // m_function_text to m_current_input_line when function_kw is
    // recognized.  To make that work, we need to do something like
    // maintain a queue of input strings and pass them to the flex
    // buffer one line at a time, while also setting
    // m_current_input_line.  Some care will be needed if a single line
    // of input arrives in multiple calls to append_input.
    //
    // OR, should we require that the input string to append_input
    // IS a single line of input?  That seems to be what we are doing
    // here by setting m_current_input_line to input.

    m_input_buf.fill (input, eof);
    m_current_input_line = input;
  }

  int
  push_lexer::fill_flex_buffer (char *buf, unsigned max_size)
  {
    int status = 0;

    if (m_input_buf.empty () && ! m_input_buf.at_eof ())
      {
        // If the input buffer is empty or we are at the end of the
        // buffer, insert ASCII 1 as a marker for subsequent rules.
        // Don't insert a newline character in this case.  Instead of
        // calling input_buffer::fill followed immediately by
        // input_buffer::copy_chunk, simply insert the marker directly
        // in BUF.

        assert (max_size > 0);

        buf[0] = static_cast<char> (1);
        status = 1;
      }
    else
      {
        // Note that the copy_chunk function may append a newline
        // character to the input.

        if (! m_input_buf.empty ())
          status = m_input_buf.copy_chunk (buf, max_size, true);
        else
          status = YY_NULL;
      }

    return status;
  }
}

