/* PSPP - computes sample statistics.
   Copyright (C) 1997, 1998 Free Software Foundation, Inc.
   Written by Ben Pfaff <blp@gnu.org>.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA. */

#if !arena_h
#define arena_h 1

#include <stddef.h>

/* Fast, low-overhead allocator, released all at once. */
typedef struct arena
  {
    struct arena *prev;		/* Pointer to previous arena header in chain. */
    struct arena *next;		/* Pointer to next arena header in chain. */
    size_t size;		/* Number of bytes allocated, incl. header. */
    size_t used;		/* Number of bytes used up, incl. header. */
  }
arena;

/* General routines. */
void arena_create (arena **);
void arena_destroy (arena **);
void arena_clear (arena **a);

/* Alloc sub-blocks. */
struct a_string;
void *arena_alloc (arena **, size_t size);
char *arena_sd_strdup (arena **, const char *s1, const char *s2);
char *arena_strdup (arena **, const char *string);
struct c_string *arena_ca_strdup (arena **, const struct a_string *s);
struct c_string *arena_cs_strdup (arena **, const char *string);

/* Malloc blocks. */
void *arena_malloc (arena **, size_t size);
void *arena_realloc (arena **, void *p, size_t amt);
void arena_free (void *);

#if GLOBAL_DEBUGGING
void arena_dump (arena **, const char *title);
#endif

#endif /* arena_h */
