/* src/language/data-io/file-handle.c		-*- mode: c; buffer-read-only: t -*-

   Generated by q2c from ../src/language/data-io/file-handle.q.
   Do not modify!
 */
#line 1 "../src/language/data-io/file-handle.q"
/* PSPP - a program for statistical analysis.
   Copyright (C) 1997-9, 2000, 2006 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>. */

#include <config.h>
#include <language/data-io/file-handle.h>
#include <libpspp/message.h>
#include <errno.h>
#include <stdlib.h>
#include <data/file-name.h>
#include <language/command.h>
#include <language/lexer/lexer.h>
#include <libpspp/assertion.h>
#include <libpspp/message.h>
#include <libpspp/str.h>
#include <data/variable.h>
#include <data/file-handle-def.h>

#include "xalloc.h"

#include "gettext.h"
#define _(msgid) gettext (msgid)

#line 43 "src/language/data-io/file-handle.c"
#include <stdlib.h>
#include <libpspp/assertion.h>
#include <libpspp/message.h>
#include <language/lexer/lexer.h>
#include <language/lexer/variable-parser.h>
#include <data/settings.h>
#include <libpspp/str.h>
#include <language/lexer/subcommand-list.h>
#include <data/variable.h>

#include "xalloc.h"

#include "gettext.h"
#define _(msgid) gettext (msgid)

#line 37 "../src/language/data-io/file-handle.q"


#line 62 "src/language/data-io/file-handle.c"
#line 47 "../src/language/data-io/file-handle.q"
#line 64 "src/language/data-io/file-handle.c"
struct dataset;
/* Settings for subcommand specifiers. */
enum
  {
    FH_CHARACTER = 1000,
    FH_BINARY,
    FH_IMAGE,
    FH_360,
    FH_SCRATCH,
    FH_FIXED,
    FH_F,
    FH_VARIABLE,
    FH_V,
    FH_SPANNED,
    FH_VS
  };

#define MAXLISTS 10
/* FILE HANDLE structure. */
struct cmd_file_handle
  {
    /* NAME subcommand. */
    int sbc_name;
    char *s_name;
    
    /* LRECL subcommand. */
    int sbc_lrecl;
    long n_lrecl[MAXLISTS];
    
    /* TABWIDTH subcommand. */
    int sbc_tabwidth;
    long n_tabwidth[MAXLISTS];
    
    /* MODE subcommand. */
    int sbc_mode;
    long mode;
    
    /* RECFORM subcommand. */
    int sbc_recform;
    long recform;
  };

/* Command parsing functions. */
static int parse_file_handle (struct lexer *, struct dataset *, struct cmd_file_handle *, void *);
static void free_file_handle (struct cmd_file_handle *);

#line 48 "../src/language/data-io/file-handle.q"
#line 112 "src/language/data-io/file-handle.c"
static int
parse_file_handle (struct lexer *lexer, struct dataset *ds UNUSED, struct cmd_file_handle *p, void *aux UNUSED)
{
  p->sbc_name = 0;
  p->s_name = NULL;
  p->sbc_lrecl = 0;
  {
    int i;
    for (i = 0; i < MAXLISTS; ++i)
      p->n_lrecl[i] = LONG_MIN;
  }
  p->sbc_tabwidth = 0;
  {
    int i;
    for (i = 0; i < MAXLISTS; ++i)
      p->n_tabwidth[i] = LONG_MIN;
  }
  p->sbc_mode = 0;
  p->mode = FH_CHARACTER;
  p->sbc_recform = 0;
  p->recform = -1;
  for (;;)
    {
      if (lex_match_id (lexer, "NAME"))
        {
          lex_match (lexer, '=');
          p->sbc_name++;
          if (p->sbc_name > 1)
            {
              msg (SE, _("NAME subcommand may be given only once."));
              goto lossage;
            }
          if (!lex_force_string (lexer))
            return false;
          free(p->s_name);
          p->s_name = ds_xstrdup (lex_tokstr (lexer));
          lex_get (lexer);
        }
      else if (lex_match_id (lexer, "LRECL"))
        {
          lex_match (lexer, '=');
          p->sbc_lrecl++;
          if (p->sbc_lrecl > 1)
            {
              msg (SE, _("LRECL subcommand may be given only once."));
              goto lossage;
            }
          {
            int x;
            if (!lex_force_int (lexer))
              goto lossage;
            x = lex_integer (lexer);
            lex_get(lexer);
            p->n_lrecl[p->sbc_lrecl - 1] = x;
          }
        }
      else if (lex_match_id (lexer, "TABWIDTH"))
        {
          lex_match (lexer, '=');
          p->sbc_tabwidth++;
          if (p->sbc_tabwidth > 1)
            {
              msg (SE, _("TABWIDTH subcommand may be given only once."));
              goto lossage;
            }
          {
            int x;
            if (!lex_force_int (lexer))
              goto lossage;
            x = lex_integer (lexer);
            lex_get(lexer);
            if (!(x>=0))
              {
                msg (SE, "TABWIDTH must be nonnegative");
                goto lossage;
              }
              p->n_tabwidth[p->sbc_tabwidth - 1] = x;
            }
          }
        else if (lex_match_id (lexer, "MODE"))
          {
            lex_match (lexer, '=');
            p->sbc_mode++;
            if (p->sbc_mode > 1)
              {
                msg (SE, _("MODE subcommand may be given only once."));
                goto lossage;
              }
            while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
              {
                if (lex_match_id (lexer, "CHARACTER"))
                  p->mode = FH_CHARACTER;
                else if (lex_match_id (lexer, "BINARY"))
                  p->mode = FH_BINARY;
                else if (lex_match_id (lexer, "IMAGE"))
                  p->mode = FH_IMAGE;
                else if (lex_match_int (lexer, 360))
                  p->mode = FH_360;
                else if (lex_match_id (lexer, "SCRATCH"))
                  p->mode = FH_SCRATCH;
                else
                  {
                    lex_error (lexer, NULL);
                    goto lossage;
                  }
                lex_match (lexer, ',');
              }
          }
        else if (lex_match_id (lexer, "RECFORM"))
          {
            lex_match (lexer, '=');
            p->sbc_recform++;
            if (p->sbc_recform > 1)
              {
                msg (SE, _("RECFORM subcommand may be given only once."));
                goto lossage;
              }
            while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
              {
                if (lex_match_id (lexer, "FIXED"))
                  p->recform = FH_FIXED;
                else if (lex_match_id (lexer, "F"))
                  p->recform = FH_F;
                else if (lex_match_id (lexer, "VARIABLE"))
                  p->recform = FH_VARIABLE;
                else if (lex_match_id (lexer, "V"))
                  p->recform = FH_V;
                else if (lex_match_id (lexer, "SPANNED"))
                  p->recform = FH_SPANNED;
                else if (lex_match_id (lexer, "VS"))
                  p->recform = FH_VS;
                else
                  {
                    lex_error (lexer, NULL);
                    goto lossage;
                  }
                lex_match (lexer, ',');
              }
          }
        else if ( settings_get_syntax () != COMPATIBLE && lex_match_id(lexer, "ALGORITHM"))
          {
            lex_match (lexer, '=');
            if (lex_match_id(lexer, "COMPATIBLE"))
              settings_set_cmd_algorithm (COMPATIBLE);
            else if (lex_match_id(lexer, "ENHANCED"))
              settings_set_cmd_algorithm (ENHANCED);
            }
          if (!lex_match (lexer, '/'))
            break;
        }
      
      if (lex_token (lexer) != '.')
        {
          lex_error (lexer, _("expecting end of command"));
          goto lossage;
        }
        
    return true;
    
  lossage:
    free_file_handle (p);
    return false;
  }
  
static void
free_file_handle (struct cmd_file_handle *p UNUSED)
{
  free (p->s_name);
}
#line 49 "../src/language/data-io/file-handle.q"

int
cmd_file_handle (struct lexer *lexer, struct dataset *ds)
{
  char handle_name[VAR_NAME_LEN + 1];
  struct cmd_file_handle cmd;
  struct file_handle *handle;

  if (!lex_force_id (lexer))
    return CMD_CASCADING_FAILURE;
  str_copy_trunc (handle_name, sizeof handle_name, lex_tokid (lexer));

  handle = fh_from_id (handle_name);
  if (handle != NULL)
    {
      msg (SE, _("File handle %s is already defined.  "
                 "Use CLOSE FILE HANDLE before redefining a file handle."),
	   handle_name);
      return CMD_CASCADING_FAILURE;
    }

  lex_get (lexer);
  if (!lex_force_match (lexer, '/'))
    return CMD_CASCADING_FAILURE;

  if (!parse_file_handle (lexer, ds, &cmd, NULL))
    return CMD_CASCADING_FAILURE;

  if (lex_end_of_command (lexer) != CMD_SUCCESS)
    goto lossage;

  if (cmd.mode != FH_SCRATCH)
    {
      struct fh_properties properties = *fh_default_properties ();

      if (cmd.s_name == NULL)
        {
          lex_sbc_missing (lexer, "NAME");
          goto lossage;
        }

      switch (cmd.mode)
        {
        case FH_CHARACTER:
          properties.mode = FH_MODE_TEXT;
          if (cmd.sbc_tabwidth)
            properties.tab_width = cmd.n_tabwidth[0];
          break;
        case FH_IMAGE:
          properties.mode = FH_MODE_FIXED;
          break;
        case FH_BINARY:
          properties.mode = FH_MODE_VARIABLE;
          break;
        case FH_360:
          properties.encoding = LEGACY_EBCDIC;
          if (cmd.recform == FH_FIXED || cmd.recform == FH_F)
            properties.mode = FH_MODE_FIXED;
          else if (cmd.recform == FH_VARIABLE || cmd.recform == FH_V)
            {
              properties.mode = FH_MODE_360_VARIABLE;
              properties.record_width = 8192;
            }
          else if (cmd.recform == FH_SPANNED || cmd.recform == FH_VS)
            {
              properties.mode = FH_MODE_360_SPANNED;
              properties.record_width = 8192;
            }
          else
            {
              msg (SE, _("RECFORM must be specified with MODE=360."));
              goto lossage;
            }
          break;
        default:
          NOT_REACHED ();
        }

      if (properties.mode == FH_MODE_FIXED || cmd.n_lrecl[0] != LONG_MIN)
        {
          if (cmd.n_lrecl[0] == LONG_MIN)
            msg (SE, _("The specified file mode requires LRECL.  "
                       "Assuming %d-character records."),
                 properties.record_width);
          else if (cmd.n_lrecl[0] < 1 || cmd.n_lrecl[0] >= (1UL << 31))
            msg (SE, _("Record length (%ld) must be between 1 and %lu bytes.  "
                       "Assuming %d-character records."),
                 cmd.n_lrecl[0], (1UL << 31) - 1, properties.record_width);
          else
            properties.record_width = cmd.n_lrecl[0];
        }

      fh_create_file (handle_name, cmd.s_name, &properties);
    }
  else
    fh_create_scratch (handle_name);

  free_file_handle (&cmd);
  return CMD_SUCCESS;

 lossage:
  free_file_handle (&cmd);
  return CMD_CASCADING_FAILURE;
}

int
cmd_close_file_handle (struct lexer *lexer, struct dataset *ds UNUSED)
{
  struct file_handle *handle;

  if (!lex_force_id (lexer))
    return CMD_CASCADING_FAILURE;
  handle = fh_from_id (lex_tokid (lexer));
  if (handle == NULL)
    return CMD_CASCADING_FAILURE;

  fh_unname (handle);
  return CMD_SUCCESS;
}

/* Returns the name for REFERENT. */
static const char *
referent_name (enum fh_referent referent)
{
  switch (referent)
    {
    case FH_REF_FILE:
      return _("file");
    case FH_REF_INLINE:
      return _("inline file");
    case FH_REF_SCRATCH:
      return _("scratch file");
    default:
      NOT_REACHED ();
    }
}

/* Parses a file handle name, which may be a file name as a string
   or a file handle name as an identifier.  The allowed types of
   file handle are restricted to those in REFERENT_MASK.  Returns
   the file handle when successful, a null pointer on failure.

   The caller is responsible for fh_unref()'ing the returned
   file handle when it is no longer needed. */
struct file_handle *
fh_parse (struct lexer *lexer, enum fh_referent referent_mask)
{
  struct file_handle *handle;

  if (lex_match_id (lexer, "INLINE"))
    handle = fh_inline_file ();
  else
    {
      if (lex_token (lexer) != T_ID && lex_token (lexer) != T_STRING)
        {
          lex_error (lexer, _("expecting a file name or handle name"));
          return NULL;
        }

      handle = NULL;
      if (lex_token (lexer) == T_ID)
        handle = fh_from_id (lex_tokid (lexer));
      if (handle == NULL)
        {
          if (lex_token (lexer) != T_ID || lex_tokid (lexer)[0] != '#' || settings_get_syntax () != ENHANCED)
            handle = fh_create_file (NULL, ds_cstr (lex_tokstr (lexer)),
                                     fh_default_properties ());
          else
            handle = fh_create_scratch (lex_tokid (lexer));
        }
      lex_get (lexer);
    }

  if (!(fh_get_referent (handle) & referent_mask))
    {
      msg (SE, _("Handle for %s not allowed here."),
           referent_name (fh_get_referent (handle)));
      fh_unref (handle);
      return NULL;
    }

  return handle;
}

/*
   Local variables:
   mode: c
   End:
*/
