
/*  A Bison parser, made from gram.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define	EOL	257
#define	AUTH	258
#define	ACCT	259
#define	SEND	260
#define	EXPECT	261
#define	EQ	262
#define	LT	263
#define	GT	264
#define	NE	265
#define	LE	266
#define	GE	267
#define	PRINT	268
#define	ALL	269
#define	VARS	270
#define	EXIT	271
#define	IDENT	272
#define	NAME	273
#define	NUMBER	274
#define	QUOTE	275
#define	IPADDRESS	276

#line 1 "gram.y"

/* This file is part of GNU Radius.
   Copyright (C) 2000,2001,2002,2003,2004 Free Software Foundation, Inc.

   Written by Sergey Poznyakoff
  
   GNU Radius is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   GNU Radius is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with GNU Radius; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#if defined(HAVE_CONFIG_H)        
# include <config.h>
#endif
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <netinet/in.h>
         
#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include <fcntl.h>
#include <ctype.h>
#include <unistd.h>
#include <signal.h>
#include <errno.h>
#include <sys/wait.h>

#include <common.h>
#include <radtest.h>

extern grad_locus_t source_locus;

char *print_ident(Variable *var);
int subscript(Variable *var, char *attr_name, int all, Variable *ret_var);

extern int yylex();
int yyerror(char *s);


#line 75 "gram.y"
typedef union {
        char *string;
        int number;
        grad_uint32_t ipaddr;
        Variable *ident;
        grad_avp_t *pair;
        grad_avp_t *vector;
        struct {
                grad_avp_t *head, *tail;
        } pair_list;
        Variable variable;
	grad_symtab_t *symtab;
	enum grad_operator op;
} YYSTYPE;
#ifndef YYDEBUG
#define YYDEBUG 1
#endif

#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		75
#define	YYFLAG		-32768
#define	YYNTBASE	28

#define YYTRANSLATE(x) ((unsigned)(x) <= 276 ? yytranslate[x] : 47)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,    27,    23,    24,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
    25,     2,    26,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
    17,    18,    19,    20,    21,    22
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     1,     4,     6,     9,    11,    15,    20,    27,    32,
    35,    37,    39,    41,    43,    45,    46,    48,    50,    53,
    57,    59,    63,    64,    66,    68,    70,    73,    77,    80,
    84,    86,    88,    90,    92,    94,    96,    98,   100,   102,
   104,   106,   108,   110,   112,   114,   119,   125,   127,   129,
   132
};

static const short yyrhs[] = {    -1,
    29,    30,     0,    31,     0,    30,    31,     0,     3,     0,
    14,    45,     3,     0,    19,     8,    37,     3,     0,     6,
    34,    32,    33,    38,     3,     0,     7,    33,    38,     3,
     0,     1,     3,     0,    17,     0,     4,     0,     5,     0,
    20,     0,    18,     0,     0,    35,     0,    36,     0,    35,
    36,     0,    19,     8,    20,     0,    44,     0,    37,    23,
    44,     0,     0,    37,     0,    40,     0,    41,     0,    40,
    41,     0,    40,    24,    41,     0,    40,     1,     0,    19,
    43,    42,     0,    21,     0,    19,     0,    20,     0,    18,
     0,    22,     0,     8,     0,     9,     0,    10,     0,    11,
     0,    12,     0,    13,     0,    20,     0,    22,     0,    21,
     0,    18,     0,    18,    25,    19,    26,     0,    18,    25,
    19,    27,    26,     0,    39,     0,    46,     0,    45,    46,
     0,    37,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
    92,    93,    95,    99,   105,   106,   110,   123,   129,   157,
   162,   168,   172,   178,   179,   190,   194,   197,   206,   216,
   224,   225,   239,   243,   250,   256,   260,   272,   283,   290,
   297,   298,   299,   305,   309,   317,   321,   325,   329,   333,
   337,   343,   349,   355,   361,   365,   370,   375,   383,   384,
   387
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","EOL","AUTH",
"ACCT","SEND","EXPECT","EQ","LT","GT","NE","LE","GE","PRINT","ALL","VARS","EXIT",
"IDENT","NAME","NUMBER","QUOTE","IPADDRESS","'+'","','","'['","']'","'*'","input",
"@1","list","stmt","port_type","code","send_flags","send_flag_list","send_flag",
"expr","maybe_expr","vector","pair_list","pair","string","op","value","prlist",
"pritem", NULL
};
#endif

static const short yyr1[] = {     0,
    29,    28,    30,    30,    31,    31,    31,    31,    31,    31,
    31,    32,    32,    33,    33,    34,    34,    35,    35,    36,
    37,    37,    38,    38,    39,    40,    40,    40,    40,    41,
    42,    42,    42,    42,    42,    43,    43,    43,    43,    43,
    43,    44,    44,    44,    44,    44,    44,    44,    45,    45,
    46
};

static const short yyr2[] = {     0,
     0,     2,     1,     2,     1,     3,     4,     6,     4,     2,
     1,     1,     1,     1,     1,     0,     1,     1,     2,     3,
     1,     3,     0,     1,     1,     1,     2,     3,     2,     3,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     4,     5,     1,     1,     2,
     1
};

static const short yydefact[] = {     1,
     0,     0,     5,    16,     0,     0,    11,     0,     0,     3,
    10,     0,     0,    17,    18,    15,    14,    23,    45,     0,
    42,    44,    43,    51,    48,     0,    26,    21,     0,    49,
     0,     4,     0,    12,    13,     0,    19,    24,     0,     0,
    36,    37,    38,    39,    40,    41,     0,     0,    29,     0,
    27,     6,    50,     0,    20,    23,     9,     0,    34,    32,
    33,    31,    35,    30,    22,    28,     7,     0,    46,     0,
     8,    47,     0,     0,     0
};

static const short yydefgoto[] = {    73,
     1,     9,    10,    36,    18,    13,    14,    15,    24,    39,
    25,    26,    27,    64,    47,    28,    29,    30
};

static const short yypact[] = {-32768,
    48,    18,-32768,    16,    -8,    -4,-32768,    29,    33,-32768,
-32768,    40,    15,    16,-32768,-32768,-32768,    -4,    28,    -5,
-32768,-32768,-32768,    41,-32768,     8,-32768,-32768,    38,-32768,
    -4,-32768,    43,-32768,-32768,    -8,-32768,    41,    58,    47,
-32768,-32768,-32768,-32768,-32768,-32768,    24,    -4,-32768,    49,
-32768,-32768,-32768,    -1,-32768,    -4,-32768,    -3,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,    66,-32768,    44,
-32768,-32768,    71,    72,-32768
};

static const short yypgoto[] = {-32768,
-32768,-32768,    64,-32768,    39,-32768,-32768,    60,   -18,    20,
-32768,-32768,   -25,-32768,-32768,    30,-32768,    50
};


#define	YYLAST		79


static const short yytable[] = {    38,
    51,    67,    41,    42,    43,    44,    45,    46,    49,    16,
   -25,    17,    54,    19,    20,    21,    22,    23,    34,    35,
    11,    48,    69,    70,    66,   -25,    20,   -25,   -25,   -25,
   -25,    50,    -2,     2,    12,     3,    31,    38,     4,     5,
    52,    59,    60,    61,    62,    63,     6,    33,     2,     7,
     3,     8,    40,     4,     5,    19,    20,    21,    22,    23,
    57,     6,    55,    48,     7,    58,     8,    20,    71,    72,
    74,    75,    32,    37,    56,    68,     0,    65,    53
};

static const short yycheck[] = {    18,
    26,     3,     8,     9,    10,    11,    12,    13,     1,    18,
     3,    20,    31,    18,    19,    20,    21,    22,     4,     5,
     3,    23,    26,    27,    50,    18,    19,    20,    21,    22,
    23,    24,     0,     1,    19,     3,     8,    56,     6,     7,
     3,    18,    19,    20,    21,    22,    14,     8,     1,    17,
     3,    19,    25,     6,     7,    18,    19,    20,    21,    22,
     3,    14,    20,    23,    17,    19,    19,    19,     3,    26,
     0,     0,     9,    14,    36,    56,    -1,    48,    29
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/usr/share/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 1:
#line 92 "gram.y"
{ prompt(); ;
    break;}
case 3:
#line 96 "gram.y"
{
                        prompt();
                ;
    break;}
case 4:
#line 100 "gram.y"
{
                        prompt();
                ;
    break;}
case 6:
#line 107 "gram.y"
{
                        printf("\n");
                ;
    break;}
case 7:
#line 111 "gram.y"
{
                        Variable *var;
                        
                        if ((var = (Variable*) grad_sym_lookup(vartab, yyvsp[-3].string)) == NULL)
                                var = (Variable*) grad_sym_install(vartab, yyvsp[-3].string);
                        if (var->type == Builtin)
                                var->datum.builtin.set(&yyvsp[-1].variable);
                        else {
                                var->type = yyvsp[-1].variable.type;
                                var->datum = yyvsp[-1].variable.datum;
                        }
                ;
    break;}
case 8:
#line 124 "gram.y"
{
                        radtest_send(yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].ident, yyvsp[-4].symtab);
                        tempvar_free(yyvsp[-1].ident);
			grad_symtab_free(&yyvsp[-4].symtab);
                ;
    break;}
case 9:
#line 130 "gram.y"
{
                        int pass = 1;
                        if (verbose) {
                                printf("expect %d\n", yyvsp[-2].number);
                                printf("got    %d\n", reply_code);
                        }
                        if (reply_code != yyvsp[-2].number) {
                                if (abort_on_failure) {
                                        parse_error("expect failed: got %d\n",
                                                    reply_code);
                                        YYACCEPT;
                                }
                                pass = 0;
                        }
                        if (yyvsp[-1].ident) {
                                if (yyvsp[-1].ident->type != Vector) {
                                        parse_error("expecting vector");
                                        YYERROR;
                                }
                                if (compare_lists(reply_list,
                                                  yyvsp[-1].ident->datum.vector))
                                        pass = 0;
                                tempvar_free(yyvsp[-1].ident);
                                grad_free(yyvsp[-1].ident);
                        }
                        printf("%s\n", pass ? "PASS" : "FAIL");
                ;
    break;}
case 10:
#line 158 "gram.y"
{
                        yyclearin;
                        yyerrok;
                ;
    break;}
case 11:
#line 163 "gram.y"
{
                        YYACCEPT;
                ;
    break;}
case 12:
#line 169 "gram.y"
{
                        yyval.number = PORT_AUTH;
                ;
    break;}
case 13:
#line 173 "gram.y"
{
                        yyval.number = PORT_ACCT;
                ;
    break;}
case 15:
#line 180 "gram.y"
{
                        if (yyvsp[0].ident->type != Integer) {
                                yyerror("expected integer value");
                                YYERROR;
                        } else {
                                yyval.number = yyvsp[0].ident->datum.number;
                        }
                ;
    break;}
case 16:
#line 191 "gram.y"
{
			yyval.symtab = NULL;
		;
    break;}
case 18:
#line 198 "gram.y"
{
			Variable *var;
			
			yyval.symtab = grad_symtab_create(sizeof(Variable), var_free);
			var = (Variable*) grad_sym_install(yyval.symtab, yyvsp[0].variable.name);
			var->type = yyvsp[0].variable.type;
			var->datum = yyvsp[0].variable.datum;
		;
    break;}
case 19:
#line 207 "gram.y"
{
			Variable *var;
			var = (Variable*) grad_sym_install(yyvsp[-1].symtab, yyvsp[0].variable.name);
			var->type = yyvsp[0].variable.type;
			var->datum = yyvsp[0].variable.datum;
			yyval.symtab = yyvsp[-1].symtab;
		;
    break;}
case 20:
#line 217 "gram.y"
{
                        yyval.variable.name = yyvsp[-2].string;
                        yyval.variable.type = Integer;
                        yyval.variable.datum.number = yyvsp[0].number;
		;
    break;}
case 22:
#line 226 "gram.y"
{
                        if (yyvsp[-2].variable.type != Vector) {
                                parse_error("bad datatype of larg in +");
                        } else if (yyvsp[0].variable.type != Vector) {
                                parse_error("bad datatype of rarg in +");
                        } else {
                                grad_avl_add_list(&yyvsp[-2].variable.datum.vector,
						  yyvsp[0].variable.datum.vector);
                                yyval.variable = yyvsp[-2].variable;
                        }
                ;
    break;}
case 23:
#line 240 "gram.y"
{
                        yyval.ident = NULL;
                ;
    break;}
case 24:
#line 244 "gram.y"
{
			yyval.ident = grad_emalloc(sizeof(*yyval.ident));
                        *yyval.ident = yyvsp[0].variable;
                ;
    break;}
case 25:
#line 251 "gram.y"
{
                        yyval.vector = yyvsp[0].pair_list.head;
                ;
    break;}
case 26:
#line 257 "gram.y"
{
                        yyval.pair_list.head = yyval.pair_list.tail = yyvsp[0].pair;
                ;
    break;}
case 27:
#line 261 "gram.y"
{
                        if (yyvsp[0].pair) {
                                if (yyval.pair_list.tail) {
                                        yyval.pair_list.tail->next = yyvsp[0].pair;
                                } else {
                                        yyval.pair_list.head = yyvsp[0].pair;
                                }
				for (yyval.pair_list.tail = yyvsp[0].pair; yyval.pair_list.tail->next; yyval.pair_list.tail = yyval.pair_list.tail->next)
					;	
                        } 
                ;
    break;}
case 28:
#line 273 "gram.y"
{
                        if (yyvsp[0].pair) {
                                if (yyval.pair_list.tail) {
                                        yyval.pair_list.tail->next = yyvsp[0].pair;
                                        yyval.pair_list.tail = yyvsp[0].pair;
                                } else {
                                        yyval.pair_list.head = yyval.pair_list.tail = yyvsp[0].pair;
                                }
                        }
                ;
    break;}
case 29:
#line 284 "gram.y"
{
                        grad_avl_free(yyvsp[-1].pair_list.head);
                        yyval.pair_list.head = yyval.pair_list.tail = NULL;
                ;
    break;}
case 30:
#line 291 "gram.y"
{
                        yyval.pair = grad_create_pair(&source_locus, yyvsp[-2].string, yyvsp[-1].op, yyvsp[0].string);
                        grad_free(yyvsp[0].string);
                ;
    break;}
case 33:
#line 300 "gram.y"
{
                        char buf[64];
                        sprintf(buf, "%d", yyvsp[0].number);
                        yyval.string = grad_estrdup(buf);
                ;
    break;}
case 34:
#line 306 "gram.y"
{
                        yyval.string = print_ident(yyvsp[0].ident);
                ;
    break;}
case 35:
#line 310 "gram.y"
{
                        char buf[DOTTED_QUAD_LEN];
                        grad_ip_iptostr(yyvsp[0].ipaddr, buf);
                        yyval.string = grad_estrdup(buf);
                ;
    break;}
case 36:
#line 318 "gram.y"
{
                        yyval.op = grad_operator_equal;
                ;
    break;}
case 37:
#line 322 "gram.y"
{
                        yyval.op = grad_operator_less_than;
                ;
    break;}
case 38:
#line 326 "gram.y"
{ 
                        yyval.op = grad_operator_greater_than;
                ;
    break;}
case 39:
#line 330 "gram.y"
{
                        yyval.op = grad_operator_not_equal;
                ;
    break;}
case 40:
#line 334 "gram.y"
{
                        yyval.op = grad_operator_less_equal;
                ;
    break;}
case 41:
#line 338 "gram.y"
{
                        yyval.op = grad_operator_greater_equal;
                ;
    break;}
case 42:
#line 344 "gram.y"
{
                        yyval.variable.name = NULL;
                        yyval.variable.type = Integer;
                        yyval.variable.datum.number = yyvsp[0].number;
                ;
    break;}
case 43:
#line 350 "gram.y"
{
                        yyval.variable.name = NULL;
                        yyval.variable.type = Ipaddress;
                        yyval.variable.datum.ipaddr = yyvsp[0].ipaddr;
                ;
    break;}
case 44:
#line 356 "gram.y"
{
                        yyval.variable.name = NULL;
                        yyval.variable.type = String;
                        yyval.variable.datum.string = grad_estrdup(yyvsp[0].string);
                ;
    break;}
case 45:
#line 362 "gram.y"
{
                        yyval.variable = *yyvsp[0].ident;
                ;
    break;}
case 46:
#line 366 "gram.y"
{
                        yyval.variable.name = NULL;
                        subscript(yyvsp[-3].ident, yyvsp[-1].string, 0, &yyval.variable);
                ;
    break;}
case 47:
#line 371 "gram.y"
{
                        yyval.variable.name = NULL;
                        subscript(yyvsp[-4].ident, yyvsp[-2].string, 1, &yyval.variable);
                ;
    break;}
case 48:
#line 376 "gram.y"
{
                        yyval.variable.name = NULL;
                        yyval.variable.type = Vector;
                        yyval.variable.datum.vector = yyvsp[0].vector;
                ;
    break;}
case 51:
#line 388 "gram.y"
{
                        var_print(&yyvsp[0].variable);
                        tempvar_free(&yyvsp[0].variable);
                ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/usr/share/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 394 "gram.y"


int
yyerror(char *s)
{
        fprintf(stderr, "%s:%lu: %s\n",
                source_locus.file, (unsigned long) source_locus.line,
                s);
}

void
parse_error(const char *fmt, ...)
{
        va_list ap;

	va_start(ap, fmt);
        fprintf(stderr, "%s:%lu: ", source_locus.file, source_locus.line);
        vfprintf(stderr, fmt, ap);
        va_end(ap);
        fprintf(stderr, "\n");
}

void
set_yydebug()
{
        extern int yydebug;
        if (debug_on(1)) {
                yydebug = 1;
        }
}

int
subscript(Variable *var, char *attr_name, int all, Variable *ret_var)
{
        grad_dict_attr_t *dict;
        grad_avp_t *pair;

        ret_var->type = Undefined;
        if (var->type != Vector) {
                parse_error("subscript on non-vector");
                return -1;
        }
        if ((dict = grad_attr_name_to_dict(attr_name)) == NULL) {
                parse_error("unknown attribute %s", attr_name);
                return -1;
        }
        
        pair = grad_avl_find(var->datum.vector, dict->value);
        if (!pair) 
                return -1;

        switch (dict->type) {
        case TYPE_STRING:
                ret_var->type = String;
                if (all) {
                        int length = 0;
                        grad_avp_t *p;
                        char *cp;
                        
                        /* First, count total length of all attribute
                           instances in the packet */
                        for (p = pair; p;
			     p = grad_avl_find(p->next, dict->value)) 
                                length += p->avp_strlength;

                        cp = ret_var->datum.string = grad_emalloc(length+1);
                        /* Fill in the string contents */
                        for (p = pair; p;
			     p = grad_avl_find(p->next, dict->value)) {
                                memcpy(cp, p->avp_strvalue, p->avp_strlength);
                                cp += p->avp_strlength;
                        }
                        *cp = 0;
                } else
                        ret_var->datum.string = grad_estrdup(pair->avp_strvalue);
                break;
        case TYPE_INTEGER:
        case TYPE_DATE:
                ret_var->type = Integer;
                ret_var->datum.number = pair->avp_lvalue;
                break;
        case TYPE_IPADDR:
                ret_var->type = Ipaddress;
                ret_var->datum.ipaddr = pair->avp_lvalue;
                break;
        default:
                grad_log(L_CRIT,
                         _("attribute %s has unknown type"),
                         dict->name);
                exit(1);
        }
        return 0;
}

