/*
 * Copyright (c) 1985, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static char sccsid[] = "@(#)ruserpass.c	8.4 (Berkeley) 4/27/95";
#endif /* not lint */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>

#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#if defined(HAVE_STDARG_H) && defined(__STDC__) && __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#include <err.h>

#include "ftp_var.h"
#include "tlsnetrc.h"

extern char *localhost __P((void));
extern char *xstrdup __P((const char *));
extern char *xmalloc __P((size_t));

/* protect agains os headers */

char tokval[100];

toktab_st toktab[]= {
  { "default",	DEFAULT },
  { "login",	LOGIN },
  { "password",	PASSWD },
  { "passwd",	PASSWD },
  { "account",	ACCOUNT },
  { "machine",	MACHINE },
  { "macdef",	MACDEF },
  { "ca",	CAFILE },
  { "crl",	CRLFILE},
  { "key",	KEY },
  { "certificate",	CERT },
  { "pgpcertificate",	PGPCERT },
  { "pgpkey",	PGPKEY },
  { "pgpring",	PGPRING },
  { "requiretls", REQUIRETLS },
  { "private", PRIVATE },
  { NULL,		0 }
};

/* returns true if the given token is in toktab
 */
int token_in_tab( const char* token)
{
toktab_st * t;

  for (t = toktab; t->tokstr; t++)
    if (!strcmp(t->tokstr, token))
      return 1;
  
  return 0;
}

FILE* netrc_open( char** myname, char** mydomain)
{
char *hdir, buf[BUFSIZ];
FILE* cfile;

  if (netrc_file == NULL)
  	netrc_file = ".ftprc";

  hdir = getenv("HOME");
  if (hdir == NULL)
    hdir = ".";
  snprintf (buf, sizeof buf, "%s/%s", hdir, netrc_file);

  cfile = fopen(buf, "r");
  if (cfile == NULL)
    {
      
      if (errno != ENOENT)
         warn("%s", buf);

      netrc_file = ".netrc";
      snprintf (buf, sizeof buf, "%s/%s", hdir, netrc_file);
      cfile = fopen(buf, "r");
      
      if (cfile == NULL) {
         if (errno != ENOENT)
  	   warn("%s", buf);
         return (0);
      }
    }
  if (cfile != NULL && verbose > 1)
     printf("Reading %s file\n", netrc_file);

  *myname = localhost ();
  if (*myname == NULL)
	*myname = xstrdup ("");
  
  *mydomain = strchr(*myname, '.');
  if (*mydomain == NULL)
	    *mydomain = xstrdup ("");

  return cfile;

}

int
ruserpass(char *host, char **aname, char **apass, char **aacct)
{
  char *tmp;
  char *myname = 0, *mydomain = 0;
  int t, i, c, usedefault = 0;
  struct stat stb;
  FILE* cfile;

  cfile = netrc_open( &myname, &mydomain);
  if (!cfile) goto bad;

 next:
  while ((t = token(cfile))) {
    switch(t)
      {
      case DEFAULT:
	usedefault = 1;
	/* FALL THROUGH */

      case MACHINE:
	if (!usedefault)
	  {
	    if (token(cfile) != ID)
	      continue;
	    /*
	     * Allow match either for user's input host name
	     * or official hostname.  Also allow match of
	     * incompletely-specified host in local domain.  */
	    if (strcasecmp(host, tokval) == 0)
	      goto match;
	    if (strcasecmp(hostname, tokval) == 0)
	      goto match;
	    if ((tmp = strchr(hostname, '.')) != NULL
		&& strcasecmp(tmp, mydomain) == 0
		&& strncasecmp(hostname, tokval, tmp-hostname) == 0
		&& tokval[tmp - hostname] == '\0')
	      goto match;
	    if ((tmp = strchr(host, '.')) != NULL
		&& strcasecmp(tmp, mydomain) == 0
		&& strncasecmp(host, tokval, tmp - host) == 0
		&& tokval[tmp - host] == '\0')
	      goto match;
	    continue;
	  }
      match:
	while ((t = token(cfile)) && t != MACHINE && t != DEFAULT) {
	  switch(t)
	    {
	    case LOGIN:
	      if (token(cfile))
		if (aname != NULL && *aname == 0)
		  {
		    *aname = xmalloc((unsigned) strlen(tokval) + 1);
		    (void) strcpy(*aname, tokval);
		  }
		else
		  {
		    if (aname != NULL && strcmp(*aname, tokval))
		      goto next;
		  }
	      break;
	    case PASSWD:
	      if ((aname == NULL || *aname == NULL || strcmp(*aname, "anonymous"))
		    && fstat(fileno(cfile), &stb) >= 0
		    && (stb.st_mode & 077) != 0)
		  {
		    warnx("Error: %s file is readable by others.", netrc_file);
		    warnx("Remove password or make file unreadable by others.");
		    goto bad;
		  }
	      if (token(cfile) && apass != NULL && *apass == 0)
		{
		  *apass = xmalloc((unsigned) strlen(tokval) + 1);
		  (void) strcpy(*apass, tokval);
		}
	      break;
	    case ACCOUNT:
	      if (fstat(fileno(cfile), &stb) >= 0
		  && (stb.st_mode & 077) != 0)
		{
		  warnx("Error: %s file is readable by others.", netrc_file);
		  warnx("Remove account or make file unreadable by others.");
		  goto bad;
		}
	      if (token(cfile) && aacct != NULL && *aacct == 0)
		{
		  *aacct = xmalloc((unsigned) strlen(tokval) + 1);
		  (void) strcpy(*aacct, tokval);
		}
	      break;
	    case MACDEF:
	      if (proxy)
		goto done;

	      while ((c=getc(cfile)) != EOF && c == ' ' || c == '\t')
		;
	      if (c == EOF || c == '\n')
		{
		  printf("Missing macdef name argument.\n");
		  goto bad;
		}
	      if (macnum == 16)
		{
		  printf("Limit of 16 macros have already been defined\n");
		  goto bad;
		}
	      tmp = macros[macnum].mac_name;
	      *tmp++ = c;
	      for (i=0; i < 8 && (c=getc(cfile)) != EOF && !isspace(c); ++i)
		{
		  *tmp++ = c;
		}
	      if (c == EOF)
		{
		  printf("Macro definition missing null line terminator.\n");
		  goto bad;
		}
	      *tmp = '\0';
	      if (c != '\n')
		{
		  while ((c = getc(cfile)) != EOF && c != '\n');
		}
	      if (c == EOF)
		{
		  printf("Macro definition missing null line terminator.\n");
		  goto bad;
		}
	      if (macnum == 0)
		{
		  macros[macnum].mac_start = macbuf;
		}
	      else
		{
		  macros[macnum].mac_start = macros[macnum-1].mac_end + 1;
		}
	      tmp = macros[macnum].mac_start;
	      while (tmp != macbuf + 4096)
		{
		  if ((c = getc (cfile)) == EOF)
		    {
		      printf("Macro definition missing null line terminator.\n");
		      goto bad;
		    }
		  *tmp = c;
		  if (*tmp == '\n')
		    {
		      if (*(tmp-1) == '\0')
			{
			  macros[macnum++].mac_end = tmp - 1;
			  break;
			}
		      *tmp = '\0';
		    }
		  tmp++;
		}
	      if (tmp == macbuf + 4096)
		{
		  printf("4K macro buffer exceeded\n");
		  goto bad;
		}
	      break;
	    default:
	      if (token_in_tab( tokval)==0)
	         warnx("Unknown %s keyword %s", tokval, netrc_file);
	      else
	         token(cfile); /* read the value and ignore it */

	      break;
	    }
	}
	goto done;
      }
  }
 done:
  (void) fclose(cfile);
  if (myname)
    free (myname);
  return (0);
 bad:
  if (cfile) fclose(cfile);
  if (myname)
    free (myname);
  return (-1);
}

int token(FILE* cfile)
{
  char *cp;
  int c;
  toktab_st *t;

  if (feof(cfile) || ferror(cfile))
    return (0);
  while ((c = getc(cfile)) != EOF &&
	 (c == '\n' || c == '\t' || c == ' ' || c == ','))
    continue;
  if (c == EOF)
    return (0);
  cp = tokval;
  if (c == '"')
    {
      while ((c = getc(cfile)) != EOF && c != '"')
	{
	  if (c == '\\')
	    c = getc(cfile);
	  *cp++ = c;
	}
    }
  else
    {
      *cp++ = c;
      while ((c = getc(cfile)) != EOF
	     && c != '\n' && c != '\t' && c != ' ' && c != ',')
	{
	  if (c == '\\')
	    c = getc(cfile);
	  *cp++ = c;
	}
    }
  *cp = 0;
  if (tokval[0] == 0)
    return (0);
  for (t = toktab; t->tokstr; t++)
    if (!strcmp(t->tokstr, tokval))
      return (t->tval);
  return (ID);
}
