/*
 * Copyright (c) 2004 Nikos Mavroyanopoulos <nmav@gnutls.org>
 *
 * This file is part of FEG GNU inetutils.
 *
 * FEG GNU inetutils is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * FEG GNU inetutils is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef TLS

#include <sys/types.h>
#include <sys/stat.h>

#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#if defined(HAVE_STDARG_H) && defined(__STDC__) && __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#include <err.h>

#include "ftp_var.h"
#include "tlsnetrc.h"

extern char *localhost __P((void));
extern char *xstrdup __P((const char *));
extern char *xmalloc __P((size_t));

int
tlsparams(char *host, tlsparams_st *st)
{
  char *hdir, buf[BUFSIZ], *tmp;
  char *myname = 0, *mydomain = 0;
  int t, i, c, usedefault = 0;
  struct stat stb;
  FILE *cfile;

  cfile = netrc_open(&myname, &mydomain);
  if (cfile == NULL)
  	goto bad;

 next:
  while ((t = token(cfile)))
    switch(t)
      {
      case DEFAULT:
	usedefault = 1;
	/* FALL THROUGH */

      case MACHINE:
	if (!usedefault)
	  {
	    if (token(cfile) != ID)
	      continue;
	    /*
	     * Allow match either for user's input host name
	     * or official hostname.  Also allow match of
	     * incompletely-specified host in local domain.  */
	    if (strcasecmp(host, tokval) == 0)
	      goto match;
	    if (hostname && strcasecmp(hostname, tokval) == 0)
	      goto match;
	    if (hostname && ((tmp = strchr(hostname, '.')) != NULL)
		&& strcasecmp(tmp, mydomain) == 0
		&& strncasecmp(hostname, tokval, tmp-hostname) == 0
		&& tokval[tmp - hostname] == '\0')
	      goto match;
	    if ((tmp = strchr(host, '.')) != NULL
		&& strcasecmp(tmp, mydomain) == 0
		&& strncasecmp(host, tokval, tmp - host) == 0
		&& tokval[tmp - host] == '\0')
	      goto match;
	    continue;
	  }
      match:
	while ((t = token(cfile)) && t != MACHINE && t != DEFAULT)
	  switch(t)
	    {
	    case CERT:
	      if (token(cfile))
		if (st->cert == 0)
		  {
		    st->cert = xmalloc((unsigned) strlen(tokval) + 1);
		    (void) strcpy(st->cert, tokval);
		  }
		else
		  {
		    if (strcmp(st->cert, tokval))
		      goto next;
		  }
	      break;
	    case KEY:
	      if (token(cfile))
		if (st->key == 0)
		  {
		    st->key = xmalloc((unsigned) strlen(tokval) + 1);
		    (void) strcpy(st->key, tokval);
		  }
		else
		  {
		    if (strcmp(st->key, tokval))
		      goto next;
		  }
	      break;
	    case PGPKEY:
	      if (token(cfile))
		if (st->pgpkey == 0)
		  {
		    st->pgpkey = xmalloc((unsigned) strlen(tokval) + 1);
		    (void) strcpy(st->pgpkey, tokval);
		  }
		else
		  {
		    if (strcmp(st->pgpkey, tokval))
		      goto next;
		  }
	      break;
	    case PGPCERT:
	      if (token(cfile))
		if (st->pgpcert == 0)
		  {
		    st->pgpcert = xmalloc((unsigned) strlen(tokval) + 1);
		    (void) strcpy(st->pgpcert, tokval);
		  }
		else
		  {
		    if (strcmp(st->pgpcert, tokval))
		      goto next;
		  }
	      break;
	    case PGPRING:
	      if (token(cfile))
		if (st->pgpring == 0)
		  {
		    st->pgpring = xmalloc((unsigned) strlen(tokval) + 1);
		    (void) strcpy(st->pgpring, tokval);
		  }
		else
		  {
		    if (strcmp(st->pgpring, tokval))
		      goto next;
		  }
	      break;
	    case CAFILE:
	      if (token(cfile))
		if (st->cafile == 0)
		  {
		    st->cafile = xmalloc((unsigned) strlen(tokval) + 1);
		    (void) strcpy(st->cafile, tokval);
		  }
		else
		  {
		    if (strcmp(st->cafile, tokval))
		      goto next;
		  }
	      break;
	    case CRLFILE:
	      if (token(cfile))
		if (st->crlfile == 0)
		  {
		    st->crlfile = xmalloc((unsigned) strlen(tokval) + 1);
		    (void) strcpy(st->crlfile, tokval);
		  }
		else
		  {
		    if (strcmp(st->crlfile, tokval))
		      goto next;
		  }
	      break;
	    case REQUIRETLS:
	      if (st->require_tls == -1)
		 st->require_tls = 1;
	      break;
	    case PRIVATE:
	      if (st->private == -1)
	         st->private = 1;
	      break;
	    default:
	      if (token_in_tab( tokval)==0)
	         warnx("Unknown %s keyword %s", tokval, netrc_file);
	      else
	         token(cfile); /* read the value and ignore it */
	      break;
	    }
	goto done;
      }
 done:
  (void) fclose(cfile);
  if (myname)
    free (myname);
  return (0);
 bad:
  if (cfile) fclose(cfile);
  if (myname)
    free (myname);
  return (-1);
}

#endif /* TLS */

