# GNU Solfege - ear training for GNOME
# Copyright (C) 2004  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

__exercise_data__ = {
    'exercise_name': 'singanswer',
    'menu_path': '%s/%s' % (_("_Chords"), _("_Sing answer")),
}
import exercise_setup
exercise_setup.register_exercise(__exercise_data__)

import gtk
import gu
import abstract
import lessonfile
import dataparser
import mpd
import utils
import const

class Teacher(abstract.LessonbasedTeacher):
    exercise_data = __exercise_data__
    OK = 1
    ERR_NO_QUESTION = 2
    def __init__(self, exname, app, lesson_collection, lesson_file, config):
        abstract.LessonbasedTeacher.__init__(self, exname, app, 
                   lesson_collection, lesson_file, config)
        self.lessonfileclass = lessonfile.SingAnswerLessonfile
        try: # the lesson file might contain errors.
            self.parse_lessonfile()
        except dataparser.DataparserException, e:
            self.m_app.m_ui.display_error_message(str(e))
    def new_question(self):
        # TODO This function is very similar to the one in src/idbyname.py
        self.q_status = const.QSTATUS_NO
        assert self.m_P
        try:
            self.m_P.select_random_question()
            self.q_status = const.QSTATUS_NEW
            return self.OK
        except lessonfile.NoQuestionException:
            return self.ERR_NO_QUESTION

class Gui(abstract.LessonbasedGui):
    def __init__(self, teacher, window):
        abstract.Gui.__init__(self, teacher, window)
        self.g_music_displayer = mpd.musicdisplayer.MusicDisplayer(utils.play_tone)
        self.practise_box.pack_start(self.g_music_displayer)
        self.g_question = gtk.Label()
        self.practise_box.pack_start(self.g_question)
        self.g_music_displayer.clear()
        self.g_new = gu.bButton(self.action_area, _("_New"), self.new_question)
        self.g_repeat = gu.bButton(self.action_area, _("_Repeat"), self.repeat_question)
        self.g_play_answer = gu.bButton(self.action_area, 
                    _("Hear _answer"), self.hear_answer)
        ##############
        # config_box #
        ##############
        self.add_select_lessonfile_gui()
        self.add_random_transpose_gui()
        self.show_all()
        self.update_gui_after_lessonfile_change()
    def new_question(self, widget):
        if self.m_t.m_P.header.have_music_displayer:
            self.g_music_displayer.clear()
        try:
            g = self.m_t.new_question()
        except lessonfile.LessonfileException, e:
            self.g_win.display_error_message("In the file %s: %s" % (self.m_t.m_P.m_filename, str(e)))
            return
        self.g_music_displayer.display(self.m_t.m_P.get_music(), 20)
        self.g_question.set_text(self.m_t.m_P.get_question()['question_text'])
        self.m_t.m_P.play_question()
    def repeat_question(self, widget):
        self.m_t.m_P.play_question()
    def hear_answer(self, widget):
        mpd.play_music(self.m_t.m_P.prepare_music_from_string('answer', self.m_t.m_P.get_question()), 120, 0, 100)
    def update_gui_after_lessonfile_change(self):
        if self.m_t.m_P:
            self.g_random_transpose.set_text(str(self.m_t.m_P.header.random_transpose))
        self.g_new.set_sensitive(bool(self.m_t.m_P))
        self.g_play_answer.set_sensitive(bool(self.m_t.m_P))
        self.g_win.set_title("Solfege - " + self.get_pretty_name())
