# GNU Solfege - ear training for GNOME
# Copyright (C) 2004  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import gtk
import os

ICON = "solfege-icon"
SHARP = "sharp"
DOUBLE_SHARP = "2sharp"
NATURAL = "natural"
FLAT = "flat"
DOUBLE_FLAT = "2flat"
ERASE_TOOL = "erase-tool"
NOTEHEAD = "notehead"

class IconFactory(gtk.IconFactory):
    def __init__(self, widget, datadir):
        gtk.IconFactory.__init__(self)
        self.add_default()
        icons = {ICON: "graphics/solfege.png",
            SHARP: "graphics/accidental-sharp.png",
            DOUBLE_SHARP: "feta/feta20-accidentals-2.xpm",
            FLAT: "feta/feta20-accidentals--1.xpm",
            DOUBLE_FLAT: "feta/feta20-accidentals--2.xpm",
            NATURAL: "feta/feta20-accidentals-0.xpm",
            ERASE_TOOL: "graphics/erase-tool.png",
            NOTEHEAD: "feta/feta20-noteheads-2.xpm",
            }
        for id, filename in icons.items():
            iconset = gtk.IconSet(gtk.gdk.pixbuf_new_from_file(os.path.join(datadir, filename)))
            self.add(id, iconset)


