/*******************************************************************
**
** HyperBase was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**	Carsten Ruseng Jakobsen (ruseng@sun.com)
**	Finn Soelvsten
**	Per Magnus Petersen
**	Poul Larsen
**	Hans Mejdahl Jeppesen
**
** at The University of Aalborg in Denmark autumn 1989, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify HyperBase without charge, but are not
** authorized to license or distribute it to anyone else except as part
** of a product or program developed by the user.
**  
** HyperBase IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING
** THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A
** PARTICULAR PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR
** TRADE PRACTICE.
**  
** HyperBase is provided with no support and without any obligation on
** the part of the authors, to assist in its use, correction,
** modification or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY HyperBase OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

#ifdef SUN3
#include <stddef.h>
#else
#define _stddef_h
#include  <bool.h>
#endif

#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <stream.h>
#include <String.h>


#include "../config/hb_config.hh"		// The config file !
#include "../block4/4b/block4b.hh"

int hb_ncb_error;		// global error var
int debug=1;			// debug !!!
int socketid=10008;


main()
{
  hb_block_4b client;
//  Hb_interface client;
  
  char a;
  char ich[50];
  char *ch=&ich[0];
  
  char *user;
  char *host;
  char *at = "@";
 

  user = getenv("USER");
  host = getenv("HOST");
  
  strcpy(ch,user);
  ch = strcat(ch,at);
  ch = strcat(ch,host);

  cerr << "HyperBase client ...... and you are: `" << ch << "'\n";

  
  char *c;
  char *str;
  int svar,ret;
  long k,kk,l;
  int j,i,t,n;
  String string;
  char hostname[20];
  
  cerr << "Host name for the hb_server ";
  cin >> hostname;
  cerr << "\n";
  
  if((ret=client.hb_Connect(hostname,ch)) != 0)
  {
    cerr << "Du fik fejl: " << ret << "\n";
    exit(0);
  }


  for(;;)
  {
    cerr << "\n0.  Write()\n";
    cerr << "1.  Read()\n";
    cerr << "2.  CreateNode()\n";
    cerr << "3.  MoveLink()\n";
    cerr << "4.  ShowEvent()\n";
    cerr << "5.  Disconnect()\n";
    cerr << "6.  GetEvent()\n";
    cerr << "7.  Delete()\n";
    cerr << "8.  Link()(From link to node)\n";
    cerr << "9.  Link()(From node to link)\n";
    cerr << "10. Event()\n";
    cerr << "11. Lock()\n";
    cerr << "12. ShowLock()\n";
    cerr << "13. RemoveLink\n";
    cerr << "14. UnLock()\n";
    cerr << "15. UnEvent()\n";
    cerr << "16. Browse()\n";
    cerr << "17. WriteFile\n";
    cerr << "18. ReadFile\n";
    cerr << "19. Read long\n";
    cerr << "------------------------------\n";
    cerr << "vaelg:  ";
    cin >> svar;

    switch(svar)
    {
    case 0:
      cerr << "Write >>> node number: ";
      cin >> kk;
      cerr << "Write >>> key number: ";
      cin >> j;
      cerr << "Write >>> write value: ";
      cin >> string; 
      c = (char *) string;
      ret = client.hb_Write(kk,j,c,strlen(c));
      cerr << "Returnvalue: " << ret << "\n";
      break;
    case 1:
      cerr << "Read >>> node number: ";
      cin >> k;
      cerr << "Read >>> key number: ";
      cin >> j;
      ret = client.hb_Read(k,j,&str,&kk);
      cerr << "Returnvalue: " << ret << "\n";
      cerr << "Read >>> Length: " << kk << "\n";
      cerr << "Read >>> Value: " << str << "\n";
      break;
    case 2:
      ret = client.hb_CreateNode(&k);
      cerr << "Returnvalue: " << ret << "\n";
      cerr << "CreateNode >>> number: " << k << "\n";
      break;
    case 3:
      cerr << "MoveLink >>> Linknode: ";
      cin >> k;
      cerr << "MoveLink >>> Newnode: ";
      cin >> l;
      ret = client.hb_MoveLink(k,l);
      cerr << "Returnvalue: " << ret << "\n";
      break;
    case 4:
      cerr << "ShowEvent >>> Entity number: ";
      cin >> k;
      cerr << "ShowEvent >>> operation number: ";
      cin >> j;
      cerr << "ShowEvent >>> key number: ";
      cin >> i;
      ret = client.hb_ShowEvent(&str,k,j,i);
      cerr << "Returnvalue: " << ret << "\n";
      cerr << "ShowEvent >>> Users: \n" << str << "\n";
      break;
    case 5:
      ret = client.hb_Disconnect();
      cerr << "Returnvalue: " << ret << "\n";
      cerr << "The client says bye!\n";
      exit(1);
      break;
    case 6:
      cerr << "GetEvent >>> timelinit: ";
      cin >> i;
      ret = client.hb_GetEvent(&str,i,&l,&n,&t);
      cerr << "Returnvalue: " << ret << "\n";
      if (ret == 0)
	cerr << "GetEvent >>> Event received: \nuser: " << str << \
	  "\nent_no: " << l << "\noperation: " << n << "\nkey: " << t << "\n";
      else
	cerr << "GetEvent >>> Time out; No event received\n";
      break;
    case 7:
      cerr << "Delete >>> node number: ";
      cin >> l;
      ret = client.hb_Delete(l);
      cerr << "Returnvalue: " << ret << "\n";
      break;
    case 8:
      cerr << "Link >>> to node: ";
      cin >> l;
      ret = client.hb_Link(&k,l);
      cerr << "Returnvalue: " << ret << "\n";
      cerr << "Link >>> node number: " << k << "\n";
      break;
    case 9:
      cerr << "Link >>> from node: ";
      cin >> k;
      cerr << "Link >>> to link: ";
      cin >> l;
      ret = client.hb_Link(&k,l);
      cerr << "Returnvalue: " << ret << "\n";
      cerr << "Link >>> node number: " << k << "\n";
      break;
    case 10:
      cerr << "Event >>> entity number: ";
      cin >> k;
      cerr << "Event >>> operation number: ";
      cin >> j;
      cerr << "Event >>> key number: ";
      cin >> i;
      ret = client.hb_Event(k,j,i);
      cerr << "Returnvalue: " << ret << "\n";
      break;
    case 11:
      cerr << "Lock >>> entity number: ";
      cin >> k;
      cerr << "Lock >>> key          : ";
      cin >> kk;
      ret = client.hb_Lock(k,kk);
      cerr << "Returnvalue: " << ret << "\n";
      break;
    case 12:
      cerr << "ShowLock >>> entity number: ";
      cin >> k;
      cerr << "ShowLock >>> key          : ";
      cin >> kk;
      ret = client.hb_ShowLock(&str,k,kk);
      cerr << "Returnvalue: " << ret << "\n";
      cerr << "ShowLock >>> user: " << str << "\n";
      break;
    case 13:
      cerr << "RemoveLink >>> Data number: ";
      cin >> k;
      cerr << "RemoveLink >>> link number: ";
      cin >> j;
      ret = client.hb_RemoveLink(k,j);
      cerr << "Returnvalue: " << ret << "\n";
      break;
    case 14:
      cerr << "UnLock >>> entity number: ";
      cin >> k;
      cerr << "UnLock >>> key          : ";
      cin >> kk;
      ret = client.hb_UnLock(k,kk);
      cerr << "Returnvalue: " << ret << "\n";
      break;
    case 15:
      cerr << "UnEvent >>> entity number: ";
      cin >> k;
      cerr << "UnEvent >>> operation number: ";
      cin >> j;
      cerr << "UnEvent >>> key number: ";
      cin >> i;
      ret = client.hb_UnEvent(k,j,i);
      cerr << "Returnvalue: " << ret << "\n";
      break;
    case 16:

      long  templ;
      long* tempstr1=&templ;
      
      cerr << "Browse() >>> node type: ";
      cin >> k;
      ret = client.hb_Browse(k,&tempstr1);
      cerr << "Returnvalue: " << ret << "\n";
      cerr << "Browse() >>> Value: "; 
      for ( ;*tempstr1 != 0;tempstr1++)
      {
	cerr << *tempstr1 << " : " ;
      }
      cerr << "\n";
      break;
    case 17:
      cerr << "WriteFile >>> node number: ";
      cin >> kk;
      j = 517;
      cerr << "WriteFile >>> Filename: ";
      FILE* fp;
      cin >> string;
      if ((fp=fopen(string, "r")) == NULL)
	cerr << "Wrong filename !!!!\n";
      else
      {
	fseek(fp,0,2);
	int len = ftell(fp);
	int length = len;
	fseek(fp,0,0);
	char *filecontents = new char[length];
	int i=0;
	while (length)
	{
	  filecontents[i] = fgetc(fp);
	  length--;
	  i++;
	}
	fclose(fp);
	ret = client.hb_Write(kk,j,filecontents,len);
	cerr << "Returnvalue: " << ret << "\n";
	delete filecontents;
      }
      break;
    case 18:
      cerr << "ReadFile >>> node number: ";
      cin >> k;
      j = 517;
      cerr << "ReadFile >>> filename: ";
      int fp2;
      cin >> string;
      if ((fp2 = open(string, O_WRONLY+O_TRUNC)) < 0)
	cerr << "Can't open file `" << string << "'\n";
      else
      {
	ret = client.hb_Read(k,j,&str,&kk);
	write(fp2, str, kk);
	close(fp2);
	cerr << "Returnvalue: " << ret << "\n";
	cerr << "ReadFile >>> Length: " << kk << "\n";
	delete str;
      }
      break;
    case 19:
      long* tempstr;
      
      cerr << "ReadLong >>> node number: ";
      cin >> k;
      cerr << "ReadLong >>> key number: ";
      cin >> j;
      ret = client.hb_Read(k,j,&str,&kk);
      tempstr = (long*)str;
      cerr << "Returnvalue: " << ret << "\n";
      cerr << "ReadLong >>> Length: " << kk << "\n";
      cerr << "ReadLong >>> Value: "; 
      for (int ii=kk/4;ii>0;ii--)
      {
	cerr << *tempstr << " : " ;
	tempstr++;
      }
      cerr << "\n";
      
      break;
    default:
      cerr << "Din n000000d !!!!\n";
    }
  }
}


  
