/*******************************************************************
**
** HyperBase was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**	Carsten Ruseng Jakobsen (ruseng@sun.com)
**	Finn Soelvsten
**	Per Magnus Petersen
**	Poul Larsen
**	Hans Mejdahl Jeppesen
**
** at The University of Aalborg in Denmark autumn 1989, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify HyperBase without charge, but are not
** authorized to license or distribute it to anyone else except as part
** of a product or program developed by the user.
**  
** HyperBase IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING
** THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A
** PARTICULAR PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR
** TRADE PRACTICE.
**  
** HyperBase is provided with no support and without any obligation on
** the part of the authors, to assist in its use, correction,
** modification or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY HyperBase OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

#include "../config/hb_config.hh"
#include "Filehandler.hh"

/*******************************************************************
** OpenE() - opens entity (datanode or linknode)
**
** input:    entity number and pointer to address of empty entity
** output:   pointer to address of datanode or linknode and,
**             0 if OK, 1 if entity not found, and -1 if error
*******************************************************************/

int Filehandler::OpenE(long ent_no, char** place)
{
  treeentity* tmpptr;

  if (ent_no <= 0L)		// error
    return -1;
  else if ((ent_no % 2) == 0)	// datanode
  {
    datanode* entptr = new datanode;
    tmpptr = datanodetree.search(ent_no);
    if (tmpptr == 0)		// datanode not found
      return 1;
    else
    {
      long addr = tmpptr->fileaddress;
      int size = sizeof(struct datanode);
      int a = datanodefile.setpos(fdnode,addr);
      a = datanodefile.readent(fdnode,size,&entptr);
      OpenEnt = TRUE;
      OpenEntNo = ent_no;
      OpenEntAddr = addr;
      *place = (char*) entptr;
      return 0;
    }
  }
  else				// linknode
  {
    linknode* entptr = new linknode;
    tmpptr = linknodetree.search(ent_no);
    if (tmpptr == 0)		// linknode not found
      return 1;
    else
    {
      long addr = tmpptr->fileaddress;
      int size = sizeof(struct linknode);
      int a = linknodefile.setpos(fdlink,addr);
      a = linknodefile.readent(fdlink,size,&entptr);
      OpenEnt = TRUE;
      OpenEntNo = ent_no;
      OpenEntAddr = addr;
      *place = (char*) entptr;
      return 0;
    }
  }
};

/*******************************************************************
** CloseE() - closes an open entity (datanode or linknode)
**
** input:    pointer to datanode or linknode
** output:   0 if OK, 1 if no open entity, and -1 if error
*******************************************************************/

int Filehandler::CloseE(char* place)
{
  int a;

  if (OpenEnt == FALSE)
    return 1;
  else if (OpenEntNo <= 0L)
    return -1;
  else if ((OpenEntNo % 2) == 0) // datanode
  {
    datanode* entptr;
    entptr = (datanode*) place;
    int size = sizeof(struct datanode);
    if (OpenEntAddr == -1L)
    {
      if ((a = datanodelist.count()) == 0)
      {
	a = datanodefile.setposeof(fdnode);
	OpenEntAddr = datanodefile.getpos(fdnode);
	treeentity* tmpptr = new treeentity;
	tmpptr->fileaddress = OpenEntAddr;
	a = datanodetree.insert(OpenEntNo,tmpptr);
      }
      else
      {
	listentity* tmpptr;
	tmpptr = datanodelist.remove_front();
	OpenEntAddr = tmpptr->fileaddress;
	a = datanodetree.insert(OpenEntNo,tmpptr);
      }
    }
    a = datanodefile.setpos(fdnode,OpenEntAddr);
    a = datanodefile.writeent(fdnode,size,entptr);
    delete(place);
    OpenEnt = FALSE;
    OpenEntNo = 0L;
    OpenEntAddr = -1L;
    return 0;
  }
  else				// linknode
  {
    linknode* entptr;
    entptr = (linknode*) place;
    int size = sizeof(struct linknode);
    if (OpenEntAddr == -1L)
    {
      if ((a = linknodelist.count()) == 0)
      {
	a = linknodefile.setposeof(fdlink);
	OpenEntAddr = linknodefile.getpos(fdlink);
	treeentity* tmpptr = new treeentity;
	tmpptr->fileaddress = OpenEntAddr;
	a = linknodetree.insert(OpenEntNo,tmpptr);
      }
      else
      {
	listentity* tmpptr;
	tmpptr = linknodelist.remove_front();
	OpenEntAddr = tmpptr->fileaddress;
	a = linknodetree.insert(OpenEntNo,tmpptr);
      }
    }
    a = linknodefile.setpos(fdlink,OpenEntAddr);
    a = linknodefile.writeent(fdlink,size,entptr);
    delete(place);
    OpenEnt = FALSE;
    OpenEntNo = 0L;
    OpenEntAddr = -1L;
    return 0;
  }
};

/*******************************************************************
** OpenNewE() - opens new entity (datanode or linknode)
**
** input:    entity type and pointer to address of empty entity
** output:   pointer to address of new datanode or linknode and,
**             0 if OK, and -1 if error (wrong type)
*******************************************************************/

int Filehandler::OpenNewE(int type,char** place)
{
  int a = 0;
  int found = FALSE;
  long entno = 0L;
  
  if (type == DATANODE)
  {
    while (found == FALSE)
    {
      if ((a = numberbitmap.next(a,0)) == -1)
      {
	a = (numberbitmap.count(1) + numberbitmap.count(0));	
	if ((a % 2) == 0)
	{
	  numberbitmap.set(a);
	  entno = long(a);
	  found = TRUE;
	}
	else
	{
	  numberbitmap.set(a+1);
	  entno = long(a+1);
	  found = TRUE;
	}
      }
      else if ((a % 2) == 0) 
      {
	numberbitmap.set(a);
	entno = long(a);
	found = TRUE;
      }
    }
    datanode* entptr = new datanode;
    entptr->datanode_no = entno;
    entptr->size = 0L;
    entptr->links_to_me = 0L;
    for(int i = 0; i < NO_OF_LINKS_IN_DATANODE; i++)
      entptr->linknum[i] = 0L;
    entptr->datalinkptr = -1L;
    entptr->double_datalinkptr = -1L;
    for(int j = 0; j < NUMBER_OF_BLOCK_PTR_IN_DATANODE; j++)
      entptr->blockptr[j] = -1L;
    entptr->datablockptr = -1L;
    entptr->double_datablockptr = -1L;
    *place = (char*) entptr;
    OpenEnt = TRUE;
    OpenEntNo = entno;
    OpenEntAddr = -1L;
    return 0;
  }
  else if (type == LINKNODE)
  {
    while (found == FALSE)
    {
      if ((a = numberbitmap.next(a,0)) == -1)
      {
	a = (numberbitmap.count(1) + numberbitmap.count(0));
	if ((a % 2) == 1)
	{
	  numberbitmap.set(a);
	  entno = long(a);
	  found = TRUE;
	}
	else
	{
	  numberbitmap.set(a+1);
	  entno = long(a+1);
	  found = TRUE;
	}
      }
      else if ((a % 2) == 1) 
      {
	numberbitmap.set(a);
	entno = long(a);
	found = TRUE;
      }
    }
    linknode* entptr = new linknode;
    entptr->linknode_no = entno;
    entptr->usecount = 0L;
    entptr->to_datanode_no = 0L;
    *place = (char*) entptr;
    OpenEnt = TRUE;
    OpenEntNo = entno;
    OpenEntAddr = -1L;
    return 0;
  }
  else				// wrong type
    return -1;
};

/*******************************************************************
** DeleteE() - deletes entity (datanode or linknode)
**
** input:    entity number
** output:   0 if OK, 1 if entity not found, and -1 if error
*******************************************************************/

int Filehandler::DeleteE(long ent_no)
{
  treeentity* treeent;
  int a;

  if (ent_no <= 0L)		// error
    return -1;
  
  /*******************************************************************
  ** CASE 1 : DATANODE
  *******************************************************************/

  else if ((ent_no % 2) == 0)	// datanode
  {
    treeent = datanodetree.search(ent_no);
    if (treeent == 0)		// datanode not found
      return 1;
    else
    {
      numberbitmap.clear(ent_no);
      datanode entptrnode;
      datanode* entptr = &entptrnode;
      long entaddr = treeent->fileaddress;
      int size = sizeof(struct datanode);
      a = datanodefile.setpos(fdnode,entaddr);
      a = datanodefile.readent(fdnode,size,&entptr);
      entptr->datanode_no = 0L;
      long datasize = entptr->size; 
      int dealloc = 1;
      int datablocks = datasize / DATABLOCKSIZE;
      if ((datasize % DATABLOCKSIZE) > 0)
        datablocks++;
      int fileblocksize = DATABLOCKSIZE + 1;
      char tmpdata[fileblocksize];
      char* tmpdataptr = &tmpdata[0];
      int x = NUMBER_OF_BLOCK_PTR_IN_DATANODE;
      int y = DATABLOCKSIZE / 4;
      long addrlong;
      long *addr = &addrlong;
      long indirectlong;
      long *indirectaddr = &indirectlong;
      long doubleindirectlong;
      long *doubleindirectaddr = &doubleindirectlong;

      /*******************************************************************
      ** deallocation of direct data blokcs
      *******************************************************************/

      for (int i = 1; i <= x; i++)
      {
        if (dealloc > datablocks) 
          break;
        *addr = entptr->blockptr[i-1];
	entptr->blockptr[i-1] = -1L;
        datablockbitmap.clear(*addr/fileblocksize + 1);
        a = datablockfile.setpos(fddata,*addr);
        a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
        tmpdataptr[0] = 0;
        a = datablockfile.setpos(fddata,*addr);
        a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
        dealloc++;
      }

      /*******************************************************************
      ** deallocation of indirect data blocks
      *******************************************************************/
      
      if (dealloc <= datablocks)
      {
        *addr = entptr->datablockptr;
        entptr->datablockptr = -1L;
        datablockbitmap.clear(*addr/fileblocksize + 1);
        a = datablockfile.setpos(fddata,*addr);
        a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
        tmpdataptr[0] = 0;
        a = datablockfile.setpos(fddata,*addr);
        a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
        *addr += 1;
        for (i = 1; i <= y; i++)
        {
          if (dealloc > datablocks) 
  	    break;
          a = datablockfile.setpos(fddata,*addr);
          a = datablockfile.readlong(fddata,&indirectaddr);
          datablockbitmap.clear(*indirectaddr/fileblocksize + 1);
          a = datablockfile.setpos(fddata,*indirectaddr);
          a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
          tmpdataptr[0] = 0;
          a = datablockfile.setpos(fddata,*indirectaddr);
          a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
          *addr += 4;
          dealloc++;
        }
      }

      /*******************************************************************
      ** deallocation of double indirect data blocks
      *******************************************************************/

      if (dealloc <= datablocks)
      {
        *addr = entptr->double_datablockptr;
        entptr->double_datablockptr = -1L;
        datablockbitmap.clear(*addr/fileblocksize + 1);
        a = datablockfile.setpos(fddata,*addr);
        a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
        tmpdataptr[0] = 0;
        a = datablockfile.setpos(fddata,*addr);
        a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
        *addr += 1;
        for (i = 1; i <= y; i++)
        {
          if (dealloc > datablocks)
            break;
          a = datablockfile.setpos(fddata,*addr);
          a = datablockfile.readlong(fddata,&indirectaddr);
          datablockbitmap.clear(*indirectaddr/fileblocksize + 1);
          a = datablockfile.setpos(fddata,*indirectaddr);
          a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
          tmpdataptr[0] = 0;
          a = datablockfile.setpos(fddata,*indirectaddr);
          a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
          *indirectaddr += 1;
          for (int j = 1; j <= y; j++)
          {
            if (dealloc > datablocks)
  	      break;
    	    a = datablockfile.setpos(fddata,*indirectaddr);
	    a = datablockfile.readlong(fddata,&doubleindirectaddr);
            datablockbitmap.clear(*doubleindirectaddr/fileblocksize + 1);
	    a = datablockfile.setpos(fddata,*doubleindirectaddr);
	    a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
	    tmpdataptr[0] = 0;
            a = datablockfile.setpos(fddata,*doubleindirectaddr);
            a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
            *indirectaddr += 4;
            dealloc++;
          }
          *addr += 4;
        }
      }

     /*******************************************************************
     ** deallocation of indirect link blocks
     *******************************************************************/

      *addr = entptr->datalinkptr;
      if (*addr != -1L)
      {
	entptr->datalinkptr = -1L;
        datablockbitmap.clear(*addr/fileblocksize + 1);
        a = datablockfile.setpos(fddata,*addr);
        a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
        tmpdataptr[0] = 0;
        a = datablockfile.setpos(fddata,*addr);
        a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
        *addr += 1;
        for (i = 1; i <= y; i++)
        {
          a = datablockfile.setpos(fddata,*addr);
          a = datablockfile.readlong(fddata,&indirectaddr);
	  if (*indirectaddr != -1L)
	  {
	    datablockbitmap.clear(*indirectaddr/fileblocksize + 1);
	    a = datablockfile.setpos(fddata,*indirectaddr);
	    a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
	    tmpdataptr[0] = 0;
	    a = datablockfile.setpos(fddata,*indirectaddr);
	    a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
	  }
          *addr += 4;
        }
      }

     /*******************************************************************
     ** deallocation of double indirect link blocks
     *******************************************************************/

      *addr = entptr->double_datalinkptr;
      if (*addr != -1L)
      {
        entptr->double_datalinkptr = -1L;
        datablockbitmap.clear(*addr/fileblocksize + 1);
        a = datablockfile.setpos(fddata,*addr);
        a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
        tmpdataptr[0] = 0;
        a = datablockfile.setpos(fddata,*addr);
        a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
        *addr += 1;
        for (i = 1; i <= y; i++)
        {
          a = datablockfile.setpos(fddata,*addr);
          a = datablockfile.readlong(fddata,&indirectaddr);
	  if (*indirectaddr != -1L)
	  {
	    datablockbitmap.clear(*indirectaddr/fileblocksize + 1);
	    a = datablockfile.setpos(fddata,*indirectaddr);
	    a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
	    tmpdataptr[0] = 0;
	    a = datablockfile.setpos(fddata,*indirectaddr);
	    a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
	    *indirectaddr += 1;
	    for (int j = 1; j <= y; j++)
	    {
	      a = datablockfile.setpos(fddata,*indirectaddr);
	      a = datablockfile.readlong(fddata,&doubleindirectaddr);
	      if (*doubleindirectaddr != -1L)
	      {
		datablockbitmap.clear(*doubleindirectaddr/fileblocksize + 1);
		a = datablockfile.setpos(fddata,*doubleindirectaddr);
		a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
		tmpdataptr[0] = 0;
		a = datablockfile.setpos(fddata,*doubleindirectaddr);
		a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
	      }
	      *indirectaddr += 4;
	    }
	  }
	  *addr += 4;
	}
      }
      a = datanodefile.setpos(fdnode,entaddr);
      a = datanodefile.writeent(fdnode,size,entptr);
      a = datanodetree.remove(ent_no);
      listentity* listent = new listentity;
      listent->fileaddress = entaddr;
      a = datanodelist.append(listent);
      delete(treeent);
      return 0;
    }
  }

  /*******************************************************************
  ** CASE 2 : LINKNODE
  *******************************************************************/

  else
  {
    treeent = linknodetree.search(ent_no);
    if (treeent == 0)		// linknode not found
      return 1;
    else
    {
      numberbitmap.clear(ent_no);
      linknode entptrnode;
      linknode* entptr = &entptrnode;
      long entaddr = treeent->fileaddress;
      int size = sizeof(struct linknode);
      a = linknodefile.setpos(fdlink,entaddr);
      a = linknodefile.readent(fdlink,size,&entptr);
      entptr->linknode_no = 0L;
      a = linknodefile.setpos(fdlink,entaddr);
      a = linknodefile.writeent(fdlink,size,entptr);
      a = linknodetree.remove(ent_no);
      listentity* listent = new listentity;
      listent->fileaddress = entaddr;
      a = linknodelist.append(listent);
      delete(treeent);
      return 0;
    }
  }    
};

/*******************************************************************
** OpenData() - opens data area in datanode
**
** input:    empty pointer to address of data area
** output:   pointer to address of data area,
**             0 if OK, 1 if no open datanode, and -1 if error
*******************************************************************/

int Filehandler::OpenData(char** place)
{
  if (OpenEnt == FALSE)		// no open entity
    return 1;
  else if (OpenEntNo <= 0L)	// error
    return -1;
  else if (OpenEntAddr == -1L)	// error: new entity - contains no data
    return -1;
  else if ((OpenEntNo % 2) == 1) // error: open entity = linknode
    return -1;
  else				// open entity = datanode
  {
    datanode entptrnode;
    datanode* entptr = &entptrnode;
    int a = datanodefile.setpos(fdnode,OpenEntAddr);
    int size = sizeof(struct datanode);
    a = datanodefile.readent(fdnode,size,&entptr);
    long datasize = entptr->size;
    int opened = 1;
    int datablocks = datasize / DATABLOCKSIZE;
    int remainder = datasize % DATABLOCKSIZE;
    if (remainder > 0)
      datablocks++;
    char *tmpstr;
    *place = new char[datasize + 1];
    tmpstr = *place;
    int fileblocksize = DATABLOCKSIZE + 1;
    char tmpdata[fileblocksize];
    char* tmpdataptr;
    tmpdataptr = &tmpdata[0];
    int x = NUMBER_OF_BLOCK_PTR_IN_DATANODE;
    int y = DATABLOCKSIZE / 4;
    long addrlong;
    long *addr = &addrlong;
    long indirectlong;
    long *indirectaddr = &indirectlong;
    long doubleindirectlong;
    long *doubleindirectaddr = &doubleindirectlong;
    
    /*******************************************************************
    ** open direct data blocks
    *******************************************************************/
    
    for (int i = 1; i <= x; i++)
    {
      if (opened > datablocks) 
	break;
      addrlong = entptrnode.blockptr[i-1];
      a = datablockfile.setpos(fddata,*addr);
      a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
      if ((opened == datablocks) && (remainder > 0))
	for (int j = 1; j <= (remainder + 1); j++)
	  *tmpstr++ = tmpdata[j];
      else
	for (j = 1; j <= DATABLOCKSIZE; j++)
	  *tmpstr++ = tmpdata[j];
      opened++;
    }

    /*******************************************************************
    ** open indirect data blocks
    *******************************************************************/

    if (opened <= datablocks)
    {
      *addr = entptr->datablockptr;
      a = datablockfile.setpos(fddata,*addr);
      a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
      *addr += 1;
      for (i = 1; i <= y; i++)
      {
        if (opened > datablocks) 
 	  break;
        a = datablockfile.setpos(fddata,*addr);
        a = datablockfile.readlong(fddata,&indirectaddr);
        a = datablockfile.setpos(fddata,*indirectaddr);
        a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
	if ((opened == datablocks) && (remainder > 0))
	  for (int j = 1; j <= (remainder + 1); j++)
	    *tmpstr++ = tmpdata[j];
	else
	  for (j = 1; j <= DATABLOCKSIZE; j++)
	    *tmpstr++ = tmpdataptr[j];
        *addr += 4;
        opened++;
      }
    }
    
    /*******************************************************************
    ** open double indirect data blocks
    *******************************************************************/
    
    if (opened <= datablocks)
    {
      *addr = entptr->double_datablockptr;
      a = datablockfile.setpos(fddata,*addr);
      a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
      *addr += 1;
      for (i = 1; i <= y; i++)
      {
        if (opened > datablocks)
	  break;
        a = datablockfile.setpos(fddata,*addr);
        a = datablockfile.readlong(fddata,&indirectaddr);
        a = datablockfile.setpos(fddata,*indirectaddr);
        a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
        *indirectaddr += 1;
        for (int j = 1; j <= y; j++)
        {
  	  if (opened > datablocks)
	    break;
  	  a = datablockfile.setpos(fddata,*indirectaddr);
	  a = datablockfile.readlong(fddata,&doubleindirectaddr);
	  a = datablockfile.setpos(fddata,*doubleindirectaddr);
	  a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
	  if ((opened == datablocks) && (remainder > 0))
	    for (int k = 1; k <= (remainder + 1); k++)
	      *tmpstr++ = tmpdata[k];
	  else
	    for (k = 1; k <= DATABLOCKSIZE; k++)
	      *tmpstr++ = tmpdataptr[k];
	  *indirectaddr += 4;
          opened++;
        }
        *addr += 4;
      }
    }
    OpenDataArea = TRUE;
    return 0;
  }
};

/*******************************************************************
** CloseData() - closes data area in datanode and datanode
**
** input:    pointer to data area
** output:   0 if OK, 1 if no open data area in datanode, and -1 if error
*******************************************************************/

int Filehandler::CloseData(char* place, long len)
{
  if (OpenDataArea == FALSE)	// no open data area
    return 1;
  else if (OpenEnt == FALSE)	// no open entity
    return 1;
  else if (OpenEntNo <= 0L)	// error
    return -1;
  else if (OpenEntAddr == -1L)	// error: new entity - not stored yet
    return -1;
  else if ((OpenEntNo % 2) == 1) // error: open entity = linknode
    return -1;
  else				// open entity = datanode
  {
    int x = NUMBER_OF_BLOCK_PTR_IN_DATANODE;
    int y = DATABLOCKSIZE / 4;
    int z = DATABLOCKSIZE;
    int maxdatasize = ( (x*z) + (y*z) + (y*y*z) );
    long constlong;
    long* constaddr = &constlong;
    *constaddr = -1L;
    long newsize = len;
    if (newsize > maxdatasize)
      return -1;		// error: to large data area
    char* tmp = place;
    datanode entptrnode;
    datanode* entptr = &entptrnode;
    int a = datanodefile.setpos(fdnode,OpenEntAddr);
    int size = sizeof(struct datanode);
    a = datanodefile.readent(fdnode,size,&entptr);
    long oldsize = entptr->size;
    int newdatablocks = newsize / DATABLOCKSIZE;
    if ((newsize % DATABLOCKSIZE) > 0)
      newdatablocks++;
    int olddatablocks = oldsize / DATABLOCKSIZE;
    if ((oldsize % DATABLOCKSIZE) > 0)
      olddatablocks++;
    int fileblocksize = DATABLOCKSIZE + 1;
    char tmpdata[fileblocksize];
    char* tmpdataptr = &tmpdata[0];
    int byteswritten = 0;
    int blockswritten = 1;
    int initblock = TRUE;
    long addrlong;
    long* addr = &addrlong;
    long indirectlong;
    long* indirectaddr = &indirectlong;
    long doubleindirectlong;
    long* doubleindirectaddr = &doubleindirectlong;

    /*******************************************************************
    ** Save data - Case 1 : newsize > oldsize
    *******************************************************************/

    if (newsize >= oldsize)
    {

      /*******************************************************************
      ** store direct blocks
      *******************************************************************/

      for (int i = 1; i <= x; i++)
      {
	if (blockswritten > newdatablocks)
	  break;
	*addr = entptr->blockptr[i-1];
	if (*addr == -1L)
	{
          if ((a = datablockbitmap.first(0)) == -1)
            a = datablockbitmap.count(1);
          datablockbitmap.set(a);
          *addr = long((a-1)*fileblocksize);
          entptr->blockptr[i-1] = *addr;
	}
	tmpdataptr[0] = 1;
	for (int j = 1; j <= DATABLOCKSIZE; j++)
	{
	  if (byteswritten >= newsize)
	    tmpdataptr[j] = NULL;
	  else
            tmpdataptr[j] = *place++;
	  byteswritten++;
	}
	a = datablockfile.setpos(fddata,*addr);
	a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
        blockswritten++;
      }

      /*******************************************************************
      ** store indirect blocks
      *******************************************************************/

      if (blockswritten <= newdatablocks)
      {
        *addr = entptr->datablockptr;
	if (*addr == -1L)
	{
          if ((a = datablockbitmap.first(0)) == -1)
            a = datablockbitmap.count(1);
          datablockbitmap.set(a);
          *addr = long((a-1)*fileblocksize);
          entptr->datablockptr = *addr;
          initblock = FALSE;
	  tmpdataptr[0] = 1;
	  a = datablockfile.setpos(fddata,*addr);
	  a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
	}
        *addr += 1;
        if (initblock == FALSE)
        {
          a = datablockfile.setpos(fddata,*addr);
          for (i = 1; i <= y; i++)
            a = datablockfile.writelong(fddata,constaddr);
          initblock = TRUE;
        }
        for (i = 1; i <= y; i++)
        {
	  if (blockswritten > newdatablocks)
	    break;
	  a = datablockfile.setpos(fddata,*addr);
	  a = datablockfile.readlong(fddata,&indirectaddr);
	  if (*indirectaddr == -1L)
	  {
	    if ((a = datablockbitmap.first(0)) == -1)
	      a = datablockbitmap.count(1);
	    datablockbitmap.set(a);
	    *indirectaddr = long((a-1)*fileblocksize);
	    a = datablockfile.setpos(fddata,*addr);
	    a = datablockfile.writelong(fddata,indirectaddr);
	  }
	  tmpdataptr[0] = 1;
	  for (int j = 1; j <= DATABLOCKSIZE; j++)
	  {
	    if (byteswritten >= newsize)
	      tmpdataptr[j] = NULL;
	    else
	      tmpdataptr[j] = *place++;
	    byteswritten++;
	  }
	  a = datablockfile.setpos(fddata,*indirectaddr);
	  a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
	  *addr += 4;
	  blockswritten++;
	} 
      }
  
      /*******************************************************************
      ** store double indirect blocks
      *******************************************************************/

      if (blockswritten <= newdatablocks)
      {
        *addr = entptr->double_datablockptr;
	if (*addr == -1L)
	{
          if ((a = datablockbitmap.first(0)) == -1)
            a = datablockbitmap.count(1);
          datablockbitmap.set(a);
          *addr = long((a-1)*fileblocksize);
          entptr->double_datablockptr = *addr;
          initblock = FALSE;
	  tmpdataptr[0] = 1;
	  a = datablockfile.setpos(fddata,*addr);
	  a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
	}
        *addr += 1;
        if (initblock == FALSE)
        {
          a = datablockfile.setpos(fddata,*addr);
          for (i = 1; i <= y; i++)
            a = datablockfile.writelong(fddata,constaddr);
          initblock = TRUE;
        }
        for (i = 1; i <= y; i++)
        {
	  if (blockswritten > newdatablocks)
	    break;
          a = datablockfile.setpos(fddata,*addr);
	  a = datablockfile.readlong(fddata,&indirectaddr);
	  if (*indirectaddr == -1L)
	  {
            if ((a = datablockbitmap.first(0)) == -1)
              a = datablockbitmap.count(1);
            datablockbitmap.set(a);
            *indirectaddr = long((a-1)*fileblocksize);
            a = datablockfile.setpos(fddata,*addr);
            a = datablockfile.writelong(fddata,indirectaddr);
            initblock = FALSE;
	    tmpdataptr[0] = 1;
	    a = datablockfile.setpos(fddata,*indirectaddr);
	    a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
	  }
          *indirectaddr += 1;
          if (initblock == FALSE)
          {
            a = datablockfile.setpos(fddata,*indirectaddr);
            for (int l = 1; l <= y; l++)
              a = datablockfile.writelong(fddata,constaddr);
            initblock = TRUE;
          }
          for (int j = 1; j <= y; j++)
          {
            if (blockswritten > newdatablocks)
              break;
            a = datablockfile.setpos(fddata,*indirectaddr);
            a = datablockfile.readlong(fddata,&doubleindirectaddr);
            if (*doubleindirectaddr == -1L)
	    {
              if ((a = datablockbitmap.first(0)) == -1)
                a = datablockbitmap.count(1);
              datablockbitmap.set(a);
              *doubleindirectaddr = long((a-1)*fileblocksize);
              a = datablockfile.setpos(fddata,*indirectaddr);
              a = datablockfile.writelong(fddata,doubleindirectaddr);
	    }
	    tmpdataptr[0] = 1;
	    for (int k = 1; k <= DATABLOCKSIZE; k++)
	    {
	      if (byteswritten >= newsize)
	        tmpdataptr[k] = NULL;
	      else
	        tmpdataptr[k] = *place++;
	      byteswritten++;
	    }
	    a = datablockfile.setpos(fddata,*doubleindirectaddr);
	    a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
            *indirectaddr += 4;
            blockswritten++;
          }
          *addr += 4;
        }
      }
      entptr->size = newsize;
      a = datanodefile.setpos(fdnode,OpenEntAddr);
      a = datanodefile.writeent(fdnode,size,entptr);
      delete(len,tmp);
      OpenDataArea = FALSE;
      OpenEnt = FALSE;
      OpenEntNo = 0L;
      OpenEntAddr = -1L;
      return 0;
    }

    /*******************************************************************
    ** Save data - Case 2 : newsize < oldsize
    *******************************************************************/

    else			// newsize < oldsize
    {

      /*******************************************************************
      ** store direct blocks
      *******************************************************************/

      for (int i = 1; i <= x; i++)
      {
	*addr = entptr->blockptr[i-1];
	if (blockswritten <= newdatablocks)
	{
	  tmpdataptr[0] = 1;
	  for (int j = 1; j <= DATABLOCKSIZE; j++)
	  {
	    if (byteswritten >= newsize)
	      tmpdataptr[j] = NULL;
	    else
	      tmpdataptr[j] = *place++;
	    byteswritten++;
	  }
	  a = datablockfile.setpos(fddata,*addr);
	  a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
	  blockswritten++;
	}
	else if (*addr != -1L)	// deallocate
	{
	  entptr->blockptr[i-1] = -1L;
	  datablockbitmap.clear(*addr/fileblocksize + 1);
	  a = datablockfile.setpos(fddata,*addr);
	  a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
	  tmpdataptr[0] = 0;
	  a = datablockfile.setpos(fddata,*addr);
	  a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
	  blockswritten++;
	}
      }

      /*******************************************************************
      ** store indirect blocks
      *******************************************************************/

      if (blockswritten <= olddatablocks)
      {
	*addr = entptr->datablockptr; 
	if ((blockswritten > newdatablocks) && (*addr != -1L)) // dealloc
	{
	  entptr->datablockptr = -1L;
	  datablockbitmap.clear(*addr/fileblocksize + 1);
	  a = datablockfile.setpos(fddata,*addr);
	  a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
	  tmpdataptr[0] = 0;
	  a = datablockfile.setpos(fddata,*addr);
	  a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
	}
	*addr += 1;
	for (i = 1; i <= y; i++)
	{
	  a = datablockfile.setpos(fddata,*addr);
	  a = datablockfile.readlong(fddata,&indirectaddr);
	  if (blockswritten <= newdatablocks)
	  {
	    for (int j = 1; j <= DATABLOCKSIZE; j++)
	    {
	      tmpdataptr[0] = 1;
	      if (byteswritten >= newsize)
		tmpdataptr[j] = NULL;
	      else
		tmpdataptr[j] = *place++;
	      byteswritten++;
	    }
	    a = datablockfile.setpos(fddata,*indirectaddr);
	    a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
	    blockswritten++;
	  }
	  else if (*indirectaddr != -1L)
	  {
	    datablockbitmap.clear(*indirectaddr/fileblocksize + 1);
	    a = datablockfile.setpos(fddata,*indirectaddr);
	    a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
	    tmpdataptr[0] = 0;
	    a = datablockfile.setpos(fddata,*indirectaddr);
	    a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
	    a = datablockfile.setpos(fddata,*addr);
	    a = datablockfile.writelong(fddata,constaddr);
	    blockswritten++;
	  }
	  *addr += 4;
	} 
      }

      /*******************************************************************
      ** store double indirect blocks
      *******************************************************************/

      if (blockswritten <= olddatablocks) // close double indirect blocks
      {
        *addr = entptr->double_datablockptr;
	if ((blockswritten > newdatablocks) && (*addr != -1L)) // dealloc
	{
	  entptr->double_datablockptr = -1L;
	  datablockbitmap.clear(*addr/fileblocksize + 1);
	  a = datablockfile.setpos(fddata,*addr);
	  a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
	  tmpdataptr[0] = 0;
	  a = datablockfile.setpos(fddata,*addr);
	  a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
	}
	*addr += 1;
        for (i = 1; i <= y; i++)
        {
	  a = datablockfile.setpos(fddata,*addr);
	  a = datablockfile.readlong(fddata,&indirectaddr);
	  if ((blockswritten > newdatablocks) && (*indirectaddr != -1L))
	  {
	    datablockbitmap.clear(*indirectaddr/fileblocksize + 1);
	    a = datablockfile.setpos(fddata,*addr);
	    a = datablockfile.writelong(fddata,constaddr);
	    a = datablockfile.setpos(fddata,*indirectaddr);
	    a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
	    tmpdataptr[0] = 0;
	    a = datablockfile.setpos(fddata,*indirectaddr);
	    a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
	  }
	  if (*indirectaddr != -1L)
	  {
	    *indirectaddr += 1;
	    for (int j = 1; j <= y; j++)
	    {
	      a = datablockfile.setpos(fddata,*indirectaddr);
	      a = datablockfile.readlong(fddata,&doubleindirectaddr);
	      if (blockswritten <= newdatablocks)
	      {
		tmpdataptr[0] = 1;
		for (int k = 1; k <= DATABLOCKSIZE; k++)
		{
		  if (byteswritten >= newsize)
		    tmpdataptr[k] = NULL;
		  else
		    tmpdataptr[k] = *place++;
		  byteswritten++;
		}
		a = datablockfile.setpos(fddata,*doubleindirectaddr);
		a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
		blockswritten++;
	      }
	      else if (*doubleindirectaddr != -1L)
	      {
		datablockbitmap.clear(*doubleindirectaddr/fileblocksize + 1);
		a = datablockfile.setpos(fddata,*doubleindirectaddr);
		a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
		tmpdataptr[0] = 0;
		a = datablockfile.setpos(fddata,*doubleindirectaddr);
		a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
		a = datablockfile.setpos(fddata,*indirectaddr);
		a = datablockfile.writelong(fddata,constaddr);
		blockswritten++;
	      }
	      *indirectaddr += 4;
	    }
	  }
	  *addr += 4;
        }
      }
      entptr->size = newsize;
      a = datanodefile.setpos(fdnode,OpenEntAddr);
      a = datanodefile.writeent(fdnode,size,entptr);
      delete(len,tmp);
      OpenDataArea = FALSE;
      OpenEnt = FALSE;
      OpenEntNo = 0L;
      OpenEntAddr = -1L;
      return 0;
    }
  }  
};

/*******************************************************************
** OpenLink() - opens link area in datanode
**
** input:    empty pointer to address of link area
** output:   pointer to address of link area,
**             0 if OK, 1 if no open datanode, and -1 if error
*******************************************************************/

int Filehandler::OpenLink(char** place)
{
  if (OpenEnt == FALSE)		// no open entity
    return 1;
  else if (OpenEntNo <= 0L)	// error
    return -1;
  else if (OpenEntAddr == -1L)	// error: new entity - contains no data
    return -1;
  else if ((OpenEntNo % 2) == 1) // error: open entity = linknode
    return -1;
  else				// open entity = datanode
  {
    datanode entptrnode;
    datanode* entptr = &entptrnode;
    int a = datanodefile.setpos(fdnode,OpenEntAddr);
    int size = sizeof(struct datanode);
    a = datanodefile.readent(fdnode,size,&entptr);
    int fileblocksize = DATABLOCKSIZE + 1;
    int count = 0;
    char tmpdata[fileblocksize];
    char* tmpdataptr = &tmpdata[0];
    int x = NO_OF_LINKS_IN_DATANODE;
    int y = DATABLOCKSIZE / 4;
    long addrlong;
    long *addr = &addrlong;
    long indirectlong;
    long *indirectaddr = &indirectlong;
    long doubleindirectlong;
    long *doubleindirectaddr = &doubleindirectlong;
    long linklong;
    long *linknumber = &linklong;

    /*******************************************************************
    ** RUN 1 : count links in datanode (first the direct)
    *******************************************************************/

    for (int i = 1; i <= x; i++)
    {
      if (entptr->linknum[i-1] != 0)
	count++;
    }

   /*******************************************************************
   ** count indirect links in datanode
   *******************************************************************/

    *addr = entptr->datalinkptr;
    if (*addr != -1L)
    {
      a = datablockfile.setpos(fddata,*addr);
      a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
      *addr += 1;
      for (i = 1; i <= y; i++)
      {
        a = datablockfile.setpos(fddata,*addr);
        a = datablockfile.readlong(fddata,&indirectaddr);
	if (*indirectaddr != -1L)
	{
	  a = datablockfile.setpos(fddata,*indirectaddr);
	  a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
	  *indirectaddr += 1;
	  for (int j = 1; j <= y; j++)
	  {
	    a = datablockfile.setpos(fddata,*indirectaddr);
	    a = datablockfile.readlong(fddata,&linknumber);
	    if (*linknumber != 0)
	      count++;
	    *indirectaddr += 4;
	  }
	}
        *addr += 4;
      }
    }

    /*******************************************************************
    ** count double indirect links in datanode
    *******************************************************************/

    *addr = entptr->double_datalinkptr;
    if (*addr != -1L)
    {
      a = datablockfile.setpos(fddata,*addr);
      a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
      *addr += 1;
      for (i = 1; i <= y; i++)
      {
        a = datablockfile.setpos(fddata,*addr);
        a = datablockfile.readlong(fddata,&indirectaddr);
	if (*indirectaddr != -1L)
	{
	  a = datablockfile.setpos(fddata,*indirectaddr);
	  a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
	  *indirectaddr += 1;
	  for (int j = 1; j <= y; j++)
	  {
	    a = datablockfile.setpos(fddata,*indirectaddr);
	    a = datablockfile.readlong(fddata,&doubleindirectaddr);
	    if (*doubleindirectaddr != -1L)
	    {
	      a = datablockfile.setpos(fddata,*doubleindirectaddr);
	      a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
	      *doubleindirectaddr += 1;
	      for (int k = 1; k <= y; k++)
	      {
		a = datablockfile.setpos(fddata,*doubleindirectaddr);
		a = datablockfile.readlong(fddata,&linknumber);
		if (*linknumber != 0)
		  count++;
		*doubleindirectaddr += 4;
	      }
	    }
	    *indirectaddr += 4;
	  }
	}
        *addr += 4;
      }
    }

    /*******************************************************************
    ** allocate buffer space for linknodes
    *******************************************************************/

    long* buffer = new long[count+1];
    count = 0;

    /*******************************************************************
    ** RUN 2 : read links in datanode (first the direct)
    *******************************************************************/

    for (i = 1; i <= x; i++)
    {
      if (entptr->linknum[i-1] != 0)
      {
	buffer[count] = entptr->linknum[i-1];
	count++;
      }
    }

    /*******************************************************************
    ** read indirect links in datanode
    *******************************************************************/

    *addr = entptr->datalinkptr;
    if (*addr != -1L)
    {
      a = datablockfile.setpos(fddata,*addr);
      a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
      *addr += 1;
      for (i = 1; i <= y; i++)
      {
        a = datablockfile.setpos(fddata,*addr);
        a = datablockfile.readlong(fddata,&indirectaddr);
	if (*indirectaddr != -1L)
	{
	  a = datablockfile.setpos(fddata,*indirectaddr);
	  a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
	  *indirectaddr += 1;
	  for (int j = 1; j <= y; j++)
	  {
	    a = datablockfile.setpos(fddata,*indirectaddr);
	    a = datablockfile.readlong(fddata,&linknumber);
	    if (*linknumber != 0)
	    {
	      buffer[count] = *linknumber;
	      count++;
	    }
	    *indirectaddr += 4;
	  }
	}
        *addr += 4;
      }
    }

    /*******************************************************************
    ** read double indirect links in datanode
    *******************************************************************/

    *addr = entptr->double_datalinkptr;
    if (*addr != -1L)
    {
      a = datablockfile.setpos(fddata,*addr);
      a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
      *addr += 1;
      for (i = 1; i <= y; i++)
      {
        a = datablockfile.setpos(fddata,*addr);
        a = datablockfile.readlong(fddata,&indirectaddr);
	if (*indirectaddr != -1L)
	{
	  a = datablockfile.setpos(fddata,*indirectaddr);
	  a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
	  *indirectaddr += 1;
	  for (int j = 1; j <= y; j++)
	  {
	    a = datablockfile.setpos(fddata,*indirectaddr);
	    a = datablockfile.readlong(fddata,&doubleindirectaddr);
	    if (*doubleindirectaddr != -1L)
	    {
	      a = datablockfile.setpos(fddata,*doubleindirectaddr);
	      a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
	      *doubleindirectaddr += 1;
	      for (int k = 1; k <= y; k++)
	      {
		a = datablockfile.setpos(fddata,*doubleindirectaddr);
		a = datablockfile.readlong(fddata,&linknumber);
		if (*linknumber != 0)
		{
		  buffer[count] = *linknumber;
		  count++;
		}
		*doubleindirectaddr += 4;
	      }
	    }
	    *indirectaddr += 4;
	  }
	}
        *addr += 4;
      }
    }
    buffer[count] = 0L;
    *place = (char*) buffer;
    OpenLinkArea = TRUE;
    return 0;
  }
};

/*******************************************************************
** CloseLink() - closes link area in datanode and datanode
**
** input:    pointer to link area
** output:   0 if OK, 1 if no open link area in datanode, and -1 if error
*******************************************************************/

int Filehandler::CloseLink(char* place)
{
  if (OpenLinkArea == FALSE)	// no open link area
    return 1;
  else if (OpenEnt == FALSE)	// no open entity
    return 1;
  else if (OpenEntNo <= 0L)	// error
    return -1;
  else if (OpenEntAddr == -1L)	// error: new entity - contains no data
    return -1;
  else if ((OpenEntNo % 2) == 1) // error: open entity = linknode
    return -1;
  else				// open entity = datanode
  {
    int x = NO_OF_LINKS_IN_DATANODE;
    int y = DATABLOCKSIZE / 4;
    int maxlinksize = ( x + (y*y) + (y*y*y) );
    long constaddrlong;
    long *constaddr = &constaddrlong;
    *constaddr = -1L;
    long constconst;
    long *constlong = &constconst;
    *constlong = 0L;
    datanode entptrnode;
    datanode* entptr = &entptrnode;
    int a = datanodefile.setpos(fdnode,OpenEntAddr);
    int size = sizeof(struct datanode);
    a = datanodefile.readent(fdnode,size,&entptr);
    int fileblocksize = DATABLOCKSIZE + 1;
    char tmpdata[fileblocksize];
    char* tmpdataptr = &tmpdata[0];
    long addrlong;
    long *addr = &addrlong;
    long indirectlong;
    long *indirectaddr = &indirectlong;
    *indirectaddr = *constaddr;
    long doubleindirectlong;
    long *doubleindirectaddr = &doubleindirectlong;
    *doubleindirectaddr = *constaddr;
    long linklong;
    long *linknumber = &linklong;
    long *linkarea = (long*) place;
    long *tmp = linkarea;
    int newlinks = 0;
    while (*tmp != 0L)
    {
      newlinks++;
      *tmp++;
    }
    if (newlinks > maxlinksize)
      return -1;		// error: to large link area
    int initblock = TRUE;
    int deallocate = FALSE;
    int deallocateindirect = FALSE;
    int linkswritten = 0;

    /*******************************************************************
    ** store direct links in datanode
    *******************************************************************/

    for (int i = 1; i <= x; i++)
    {
      if (linkswritten >= newlinks)
	entptr->linknum[i-1] = 0L;
      else
      {
	entptr->linknum[i-1] = *linkarea++;
	linkswritten++;
      }
    }

    /*******************************************************************
    ** store indirect links in datanode
    *******************************************************************/

    *addr = entptr->datalinkptr;
    if ((linkswritten >= newlinks) && (*addr != -1L)) // deallocate
    {				
      entptr->datalinkptr = -1L;
      datablockbitmap.clear(*addr/fileblocksize + 1);
      a = datablockfile.setpos(fddata,*addr);
      a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
      tmpdataptr[0] = 0;
      a = datablockfile.setpos(fddata,*addr);
      a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
      deallocate = TRUE;
    }
    if ((linkswritten < newlinks) && (*addr == -1L)) // allocate
    {				
      if ((a = datablockbitmap.first(0)) == -1)
	a = datablockbitmap.count(1);
      datablockbitmap.set(a);
      *addr = long((a-1)*fileblocksize);
      entptr->datalinkptr = *addr;
      tmpdataptr[0] = 1;
      a = datablockfile.setpos(fddata,*addr);
      a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
      initblock = FALSE;
    }
    *addr += 1;
    if ((linkswritten < newlinks) && (initblock == FALSE))
    {
      a = datablockfile.setpos(fddata,*addr);
      for(i = 1; i <= y; i++)
	a = datablockfile.writelong(fddata,constaddr);
      initblock = TRUE;
    }
    for (i = 1; i <= y; i++)
    {
      if ((linkswritten < newlinks) || (deallocate == TRUE))
      {
	a = datablockfile.setpos(fddata,*addr);
	a = datablockfile.readlong(fddata,&indirectaddr);
      }
      if ((linkswritten >= newlinks) && (*indirectaddr != -1L))	// deallocate
      {			
	datablockbitmap.clear(*indirectaddr/fileblocksize + 1);
	a = datablockfile.setpos(fddata,*indirectaddr);
	a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);	
	tmpdataptr[0] = 0;
	a = datablockfile.setpos(fddata,*indirectaddr);
	a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
	a = datablockfile.setpos(fddata,*addr);
	a = datablockfile.writelong(fddata,constaddr);
	deallocate = TRUE;
      }
      if ((linkswritten < newlinks) && (*indirectaddr == -1L)) // allocate
      {			
	if ((a = datablockbitmap.first(0)) == -1)
	  a = datablockbitmap.count(1);
	datablockbitmap.set(a);
	*indirectaddr = long((a-1)*fileblocksize);
	tmpdataptr[0] = 1;
	a = datablockfile.setpos(fddata,*indirectaddr);
	a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
	a = datablockfile.setpos(fddata,*addr);
	a = datablockfile.writelong(fddata,indirectaddr);
      }
      if (*indirectaddr != -1L)
      {
	*indirectaddr += 1;
	for (int j = 1; j <= y; j++)
	{
	  if (linkswritten >= newlinks)
	  {
	    a = datablockfile.setpos(fddata,*indirectaddr);
	    a = datablockfile.writelong(fddata,constlong);
	  }
	  else
	  {
	    *linknumber = *linkarea++;
	    a = datablockfile.setpos(fddata,*indirectaddr);
	    a = datablockfile.writelong(fddata,linknumber);
	    linkswritten++;
	  }
	  *indirectaddr += 4;
	}
      }
      *indirectaddr = -1L;
      *addr += 4;
    }
    deallocate = FALSE;
    
    /*******************************************************************
    ** store double indirect links in datanode
    *******************************************************************/

    *addr = entptr->double_datalinkptr;
    if ((linkswritten >= newlinks) && (*addr != -1L)) // deallocate
    {				
      entptr->double_datalinkptr = -1L;
      datablockbitmap.clear(*addr/fileblocksize + 1);
      a = datablockfile.setpos(fddata,*addr);
      a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
      tmpdataptr[0] = 0;
      a = datablockfile.setpos(fddata,*addr);
      a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
      deallocate = TRUE;
    }
    if ((linkswritten < newlinks) && (*addr == -1L)) // allocate
    {				
      if ((a = datablockbitmap.first(0)) == -1)
	a = datablockbitmap.count(1);
      datablockbitmap.set(a);
      *addr = long((a-1)*fileblocksize);
      entptr->double_datalinkptr = *addr;
      tmpdataptr[0] = 1;
      a = datablockfile.setpos(fddata,*addr);
      a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
      initblock = FALSE;
    }
    *addr += 1;
    if ((linkswritten < newlinks) && (initblock == FALSE))
    {
      a = datablockfile.setpos(fddata,*addr);
      for(i = 1; i <= y; i++)
	a = datablockfile.writelong(fddata,constaddr);
      initblock = TRUE;
    }
    for (i = 1; i <= y; i++)
    {
      if ((linkswritten < newlinks) || (deallocate == TRUE))
      {
	a = datablockfile.setpos(fddata,*addr);
	a = datablockfile.readlong(fddata,&indirectaddr);
      }
      if ((linkswritten >= newlinks) && (*indirectaddr != -1L))	// deallocate
      {			
	datablockbitmap.clear(*indirectaddr/fileblocksize + 1);
	a = datablockfile.setpos(fddata,*indirectaddr);
	a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
	tmpdataptr[0] = 0;
	a = datablockfile.setpos(fddata,*indirectaddr);
	a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
	a = datablockfile.setpos(fddata,*addr);
	a = datablockfile.writelong(fddata,constaddr);
	deallocate = TRUE;
	deallocateindirect = TRUE;
      }
      if ((linkswritten < newlinks) && (*indirectaddr == -1L)) // allocate
      {			
	if ((a = datablockbitmap.first(0)) == -1)
	  a = datablockbitmap.count(1);
	datablockbitmap.set(a);
	*indirectaddr = long((a-1)*fileblocksize);
	tmpdataptr[0] = 1;
	a = datablockfile.setpos(fddata,*indirectaddr);
	a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
	a = datablockfile.setpos(fddata,*addr);
	a = datablockfile.writelong(fddata,indirectaddr);
	initblock = FALSE;
      }
      *indirectaddr += 1;
      if ((linkswritten < newlinks) && (initblock == FALSE))
      {
	a = datablockfile.setpos(fddata,*indirectaddr);
	for(int l = 1; l <= y; l++)
	  a = datablockfile.writelong(fddata,constaddr);
	initblock = TRUE;
      }
      for (int j = 1; j <= y; j++)
      {
	if ((linkswritten < newlinks) || (deallocateindirect == TRUE))
	{
	  a = datablockfile.setpos(fddata,*indirectaddr);
	  a = datablockfile.readlong(fddata,&doubleindirectaddr);
	}
	if ((linkswritten >= newlinks) && (*doubleindirectaddr != -1L))	// deal
	{			
	  datablockbitmap.clear(*doubleindirectaddr/fileblocksize + 1);
	  a = datablockfile.setpos(fddata,*doubleindirectaddr);
	  a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
	  tmpdataptr[0] = 0;
	  a = datablockfile.setpos(fddata,*doubleindirectaddr);
	  a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
	  a = datablockfile.setpos(fddata,*indirectaddr);
	  a = datablockfile.writelong(fddata,constaddr);
	  deallocateindirect = TRUE;
	}
	if ((linkswritten < newlinks) && (*doubleindirectaddr == -1L)) // al
	{			
	  if ((a = datablockbitmap.first(0)) == -1)
	    a = datablockbitmap.count(1);
	  datablockbitmap.set(a);
	  *doubleindirectaddr = long((a-1)*fileblocksize);
	  tmpdataptr[0] = 1;
	  a = datablockfile.setpos(fddata,*doubleindirectaddr);
	  a = datablockfile.writeent(fddata,fileblocksize,tmpdataptr);
	  a = datablockfile.setpos(fddata,*indirectaddr);
	  a = datablockfile.writelong(fddata,doubleindirectaddr);
	}
	if (*doubleindirectaddr != -1L)
	{
	  *doubleindirectaddr += 1;
	  for (int k = 1; k <= y; k++)
	  {
	    if (linkswritten >= newlinks)
	    {
	      a = datablockfile.setpos(fddata,*doubleindirectaddr);
	      a = datablockfile.writelong(fddata,constlong);
	    }
	    else
	    {
	      *linknumber = *linkarea++;
	      a = datablockfile.setpos(fddata,*doubleindirectaddr);
	      a = datablockfile.writelong(fddata,linknumber);
	      linkswritten++;
	    }
	    *doubleindirectaddr += 4;
	  }
	}
	*doubleindirectaddr = -1L;
	*indirectaddr += 4;
      }
      deallocateindirect = FALSE;
//    if (*doubleindirectaddr == -1L)
      *indirectaddr = -1L;
      *addr += 4;
    }
    a = datanodefile.setpos(fdnode,OpenEntAddr);
    a = datanodefile.writeent(fdnode,size,entptr);
    delete(place);
    OpenLinkArea = FALSE;
    OpenEnt = FALSE;
    OpenEntNo = 0L;
    OpenEntAddr = -1L;
    return 0;
  }
};

/*******************************************************************
** Browse() - returns list of nodenumbers of specified type.
**
** input: entity type and pointers to address of empty nodenumber 
**          area and length of nodenumber area
** output: 0 if OK, and -1 if error (wrong type)
*******************************************************************/

int Filehandler::Browse(int type, long** place, long* len)
{
  if (type == DATANODE)
  {
    long count = datanodetree.count();
    long* buffer = new long[count + 1];
    long* length = new long;
    long oldval = 0;
    *length = count + 1;
    buffer[0] = oldval = datanodetree.first();
    for(int i = 1; i < count; i++)
      buffer[i] = oldval = datanodetree.next(oldval);
    buffer[count] = NULL;
    *place = buffer;
    *len = *length;
    return 0;
  }
  else if (type == LINKNODE)
  {
    long count = linknodetree.count();
    long* buffer = new long[count + 1];
    long* length = new long;
    long oldval = 0;
    *length = count + 1;
    buffer[0] = oldval = linknodetree.first();
    for(int i = 1; i < count; i++)
      buffer[i] = oldval = linknodetree.next(oldval);
    buffer[count] = NULL;
    *place = buffer;
    *len = *length;
    return 0;
  }
  else                             // wrong type
    return -1;
};


/*******************************************************************
** Private member functions
*******************************************************************/

/*******************************************************************
** initFileHandler() - initialises files, search trees, empty lists,
**                       and bitmaps.
**
** input:
** output:
*******************************************************************/

void Filehandler::initFileHandler()
{
  numberbitmap.set(0);

  fdnode = datanodefile.open("datanodes.hb");
  int a = datanodefile.reset(fdnode);
  int datasize = sizeof(struct datanode);
  while ((a = datanodefile.eof(fdnode)) != EOF)
  {
    long pos = datanodefile.getpos(fdnode);
    datanode tmpnode;
    datanode* tmpptr = &tmpnode;
    a = datanodefile.readent(fdnode,datasize,&tmpptr);
    if (tmpptr->datanode_no <= 0)
    {
      listentity* listent = new listentity;
      listent->fileaddress = pos;
      a = datanodelist.append(listent);
    }
    else
    {
      treeentity* treeent = new treeentity;
      treeent->fileaddress = pos;
      a = datanodetree.insert(tmpptr->datanode_no,treeent);
      numberbitmap.set(tmpptr->datanode_no);
    }
  }

  fdlink = linknodefile.open("linknodes.hb");
  a = linknodefile.reset(fdlink);
  int linksize = sizeof(struct linknode);
  while ((a = linknodefile.eof(fdlink)) != EOF)
  {
    long pos = linknodefile.getpos(fdlink);
    linknode tmpnode;
    linknode* tmpptr = &tmpnode;
    a = linknodefile.readent(fdlink,linksize,&tmpptr);
    if (tmpptr->linknode_no <= 0)
    {
      listentity* listent = new listentity;
      listent->fileaddress = pos;
      a = linknodelist.append(listent);
    }
    else
    {
      treeentity* treeent = new treeentity;
      treeent->fileaddress = pos;
      a = linknodetree.insert(tmpptr->linknode_no,treeent);
      numberbitmap.set(tmpptr->linknode_no);
    }
  }
  
  datablockbitmap.set(0);

  fddata = datablockfile.open("datablocks.hb");
  a = datablockfile.reset(fddata);
  int fileblocksize = DATABLOCKSIZE + 1;
  int count = 1;
  char tmpdata[fileblocksize];
  char* tmpdataptr = &tmpdata[0];
  while ((a = datablockfile.eof(fddata)) != EOF)
  {
    long pos = datablockfile.getpos(fddata);
    a = datablockfile.readent(fddata,fileblocksize,&tmpdataptr);
    if (tmpdata[0] == 1)
      datablockbitmap.set(count);
    count++;
  }

  OpenEnt = FALSE;
  OpenDataArea = FALSE;
  OpenLinkArea = FALSE;
  OpenEntNo = 0L;
  OpenEntAddr = -1L;
};
