/*******************************************************************
**
** HyperBase was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**	Carsten Ruseng Jakobsen (ruseng@sun.com)
**	Finn Soelvsten
**	Per Magnus Petersen
**	Poul Larsen
**	Hans Mejdahl Jeppesen
**
** at The University of Aalborg in Denmark autumn 1989, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify HyperBase without charge, but are not
** authorized to license or distribute it to anyone else except as part
** of a product or program developed by the user.
**  
** HyperBase IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING
** THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A
** PARTICULAR PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR
** TRADE PRACTICE.
**  
** HyperBase is provided with no support and without any obligation on
** the part of the authors, to assist in its use, correction,
** modification or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY HyperBase OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

#define MAX_NUMBER_OF_KEYS 255

class Operations 
{
  char* GetCharDataField(char* ptr,int key);
  char* GetCharLinkField(char* ptr,int key);
  int PutCharDataField(char* ptr,int key,char* Value,long len);
  int PutCharLinkField(char* ptr,int key,char* Value,long len);
public: 
  int Delete(long ent_no);                    // deletes a link or node
  int CreateNode(long* ent_no);               // creates a new node
  int Link(long* EntNo, long ToEnt);          // make pointers / links
  int MoveLink(long LinkNo,long NewNode);     // moves a link pointer
  int RemoveLink(long ent_no,long link);      // removes a pointer in a node
  int Read(long ent_no,int key,char** Value,long* len); // reads a key value
  int Write(long ent_no,int key,char* Value,long len); // writes a key value
  
  int ERead(long ent_no,char** Value);        // reads an entire entity
  int EWrite(long ent_no,char* Value);        // writes an entire entity
  int Browse(int Type,long* Result[],long* Number); // primitive browser
};


  
