/*******************************************************************
**
** HyperBase was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**	Carsten Ruseng Jakobsen (ruseng@sun.com)
**	Finn Soelvsten
**	Per Magnus Petersen
**	Poul Larsen
**	Hans Mejdahl Jeppesen
**
** at The University of Aalborg in Denmark autumn 1989, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify HyperBase without charge, but are not
** authorized to license or distribute it to anyone else except as part
** of a product or program developed by the user.
**  
** HyperBase IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING
** THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A
** PARTICULAR PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR
** TRADE PRACTICE.
**  
** HyperBase is provided with no support and without any obligation on
** the part of the authors, to assist in its use, correction,
** modification or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY HyperBase OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

#define VERSION   "0.2(beta) (Tue May 1, 1990)" // the version of HyperBase

#ifdef SUN3
#include <stddef.h>
#else
#include <bool.h>
#endif

#include <stream.h>
#include <stdio.h>
#include <signal.h>
#include <stream.h>
#include <String.h>

#include "../../config/hb_config.hh"
#include "block4a.hh"
#include "block3.hh"
#include "../../block3/MainEventLock.hh" // block3 def
extern EventLock block3;		// make a block3 instance

int block4a_init();
int handel_network_input();

int debug = 0;			// by default, the debug option is OFF
int socketid = SOCKETID;	// by default use the defalt port

extern int event_send_user;	// for the SIGPIPE
extern hb_client client[];



/*******************************************************************
** sigint_handler() --- handle ^C (interrupt)
*******************************************************************/

typedef void (*PF)();

void sigint_handler()
{
  cerr << "     \nHyperBase: Interrupt! Flushing....\n";
  exit(1);
}


/*******************************************************************
** sigpipe_handler() --- handle broken pipe (sending)
*******************************************************************/

typedef void (*PF)();

void sigpipe_handler()
{
  if (debug)
    cerr << "Got SIGPIPE from user: `"
      << event_send_user << "', disconnecting him/her(?!)\n";

  client[event_send_user].used = FALSE;		// no client
  client[event_send_user].username = "";		// no username
  close(client[event_send_user].readfd);
  close(client[event_send_user].writefd);
  close(client[event_send_user].eventfd);
  client[event_send_user].network_buf_size = 0;
  client[event_send_user].toggel_read_buffer = 0;
  if (client[event_send_user].network_buffer != NULL)
    delete client[event_send_user].network_buffer;
  (void) block3.Disconnect(event_send_user);
}


/*******************************************************************
** sigusr1_handler() --- setting debug on or off
*******************************************************************/

void sigusr1_handler()
{
  cerr << "      \nHyperBase: Debug is now ";
  if (debug == 1)
  {
    cerr << "OFF\n";
    debug = 0;
  }
  else				// debug is off
  {
    cerr << "ON\n";
    debug = 1;
  }
  signal (SIGUSR1, sigusr1_handler);
}


/*******************************************************************
** sigquit_handler() --- make a core-file (core dump)
*******************************************************************/

void sigquit_handler()
{
  cerr << "        \nHyperBase: received a SIGQUIT .... making a core file\n";
  abort();
}

/*******************************************************************
** main() --- start the whole thing
*******************************************************************/


main(int argc, char *argv[])
{
  int quiet = 0;		// defaults
  int help = 0;
  int usage = 0;

  signal(SIGINT, sigint_handler);	// setup signals
  signal(SIGUSR1, sigusr1_handler);
  signal(SIGQUIT, sigquit_handler);
  signal(SIGPIPE, sigpipe_handler);
  
  
  if (argc > 1)
  {
      for (int i=1; i<argc; i++)
      {
	  if((strcmp(argv[i],"-debug") == 0) || (strcmp(argv[i],"-d") == 0))
	      debug = 1;
	  else if(strcmp(argv[i],"-socketid") == 0)
	      if (i < argc)
		  socketid = atoi(argv[++i]);
	      else
		  usage = 1;
	  else if(strcmp(argv[i],"-q") == 0)
	      quiet = 1;
	  else if((strcmp(argv[i],"-h") == 0) || (strcmp(argv[i],"-help") == 0))
	      help = 1;
	  else
	      usage = 1;
      }
  }
  
  
  if (usage)
  {
    cout << "Usage: " << argv[0] << " [-h/-help] [-q] [-debug/-d] " << \
      "[-socketid num]\n";
    exit(1);
  }

  if (help)
  {
    cout << "\nHyperBase server version " << VERSION << "\n";
    cout << "--------------------------------------------------------" << \
      "-----\n";
    cout << "Copyright (C) 1990 Group AUC-ST19-424/E89 (see authors below)\n";
    cout << "HyperBase comes with ABSOLUTELY NO WARRANTY; for details see\n";
    cout << "the GNU General Public License.\n\n";

    cout << "Options:\n--------\n";
    cout << "-debug (or -d)     Print debug information (see also signals)\n";
    cout << "-socketid [num]    Change the uniq socket number to `num'\n";
    cout << "-q                 Be quiet, don't even say hello\n";
    cout << "-h (or -help)      Print this message\n\n";
    
    cout << "Signals:\n--------\n";
    cout << "SIGINT   (^C)      Interrupt the server and terminate with a\n";
    cout << "                     normal _exit, so files will be flushed\n";
    cout << "SIGUSR1            Change debugging ON or OFF\n";
    cout << "SIGQUIT            Make a core dump (internal use)\n\n";

    cout << "Authors:\n--------\n";
    cout << "                   P.M. Petersen (magnus@iesd.auc.dk)\n";
    cout << "                   U.K. Wiil (kock@iesd.auc.dk)\n";
    cout << "                   C.R. Jacobsen (ruseng@iesd.auc.dk)\n";
    cout << "                   F. Soelvsten (finn@iesd.auc.dk)\n";
    cout << "                   H.M. Jeppesen (lucifer@iesd.auc.dk)\n";
    cout << "                   C.B. Nielsen (cbn@iesd.auc.dk)\n";
    
    exit(1);
  }
  
  if (!quiet)
    cerr << "HyperBase server version " << VERSION << "\n" << \
      "Copyright (C) 1990 Group AUC-ST19-424/E89\n";
  
  if(!block4a_init())
  {
    cerr << "The HyperBase server failed in the init() function ..... bye!\n";
    exit(1);
  }
  
  if (debug)
    cerr << "Debug option is ON.\n";
  if (socketid != SOCKETID)
    cerr << "Socketid is: " << socketid << "\n";
  
  
  handel_network_input();	// get the ball roooooling
}







