/*******************************************************************
**
** HyperBase was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**	Carsten Ruseng Jakobsen (ruseng@sun.com)
**	Finn Soelvsten
**	Per Magnus Petersen
**	Poul Larsen
**	Hans Mejdahl Jeppesen
**
** at The University of Aalborg in Denmark autumn 1989, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify HyperBase without charge, but are not
** authorized to license or distribute it to anyone else except as part
** of a product or program developed by the user.
**  
** HyperBase IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING
** THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A
** PARTICULAR PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR
** TRADE PRACTICE.
**  
** HyperBase is provided with no support and without any obligation on
** the part of the authors, to assist in its use, correction,
** modification or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY HyperBase OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

%{
#include "config.h"
#include<stdio.h>
#include<string.h>
extern char yytext[];
yydebug = 1;
%}

%union{
    int heltal;
    int  value;
    Symbol *sym;
}

%start program
%token <value> HELTAL
%token <sym>   UNDEF VAR
%token <heltal> CONFIG OPTIONAL SET IN LINKPOINTER DATAPOINTER DATABLOCK 
%token <heltal> SIZE KEY NUMBER OF VALUE TO ID USERS  
%token <heltal> DEFINED INCLUDE LINKNODE DATANODE SOCKETID DIRECT LINKS
%token <heltal> BLOCKPOINTERS
%type <heltal> entity 
%%
program:
    CONFIG must OPTIONAL options {create_config();}   |
    CONFIG must {create_config();}

 must: must1 must | must2 must | must3 must | must1 | must2 | must3

must1:
  SET NUMBER  OF DIRECT LINKS IN entity TO HELTAL 
{
    if ($9<1) 
	execerror("There must be at least one linknumber\n", (char *)0);
    if ( (int) $7 == (int) LINKNODE)
    {
	if ($9 > 1)
	    warning("This implementation only supports one link in linknodes",(char *)0);
	install("LINKNUMBERS", (short)LINKNODE, (int) $9);
    }
    else
	install("LINKNUMBERS", (short)DATANODE, (int) $9);
} 

must2:
    SET SIZE OF DATABLOCK TO HELTAL 
{
    if ($6<1)
	execerror("The size of datablock must be larger than 0, a multipla of 512 recomended\n",(char *)0);
    (void) install("DATABLOCKSIZE",(short) DEFINED, (int) $6);
} 

options: opt1 options | opt2 options | opt3 options |opt4 options|
  opt1 | opt2 | opt3 |opt4 | opt5 | opt5 options

must3:
    SET NUMBER OF DIRECT BLOCKPOINTERS TO HELTAL
{
    install("NUMBER_OF_BLOCK_PTR_IN_DATANODE", (short)DATANODE, (int) $7);
}

opt1:
    INCLUDE KEY VAR  IN entity     
{
    if (($3->type) == UNDEF)
	($3->type) = (short) $5;
    else
	execerror("already defined",$3->name);
}


opt2:
    SET SIZE OF VAR  TO HELTAL IN entity 
{
    if (($4->type) == UNDEF)
	execerror("cannot set size on undefined key", $4->name);
    else
    {
	if (($4->type) !=  $8) 
	    execerror("wrong type for ",$4->name);
	($4->u.val) = (int) $6;
#ifdef DEBUG
	fprintf( stderr,"updated %s type %d to value %d\n",$4->name,$4->type,$4->u.val);
#endif	
    }
}

opt3:
  SET ID TO VAR 
{
  ($4->type) = ID;
}

opt4:
  SET NUMBER OF USERS TO HELTAL
{
  (void)install("MAXUSERS", (short) DEFINED, (int) $6);
}
opt5:
    SET SOCKETID TO HELTAL
{
    (void) install("SOCKETID", (short) DEFINED, (int) $4);
}

entity:
    LINKNODE 
{
    $$ = LINKNODE;
}
| DATANODE 
{
    $$ = DATANODE;
}


    
    
%%
char *progname;
int lineno = 1 ;

main(argc, argv)
int argc;
char* argv[];
{
    progname = argv[0];
    return(yyparse());
}

warning(s, t)
char *s,*t;
{
    fprintf(stderr,"%s: %s",progname, s);
    if (t)
	fprintf(stderr," %s", t);
    fprintf(stderr," near line %d\n", lineno);
}


yyerror(s)
char* s;
{
    warning(s, (char *)0);
}
yywrap()
{
  return(1);
}

execerror(s, t)
char *s,*t;
{
  warning(s, t);
  exit(3);
}
