From ames!agate!usenet.ins.cwru.edu!magnus.acs.ohio-state.edu!zaphod.mps.ohio-state.edu!darwin.sura.net!convex!seas.smu.edu!mustafa Thu Nov 12 18:40:13 PST 1992
Article: 370 of comp.graphics.gnuplot
Newsgroups: comp.graphics.gnuplot
Path: ames!agate!usenet.ins.cwru.edu!magnus.acs.ohio-state.edu!zaphod.mps.ohio-state.edu!darwin.sura.net!convex!seas.smu.edu!mustafa
From: mustafa@seas.smu.edu (Mustafa Kocaturk)
Subject: Histograms in Gnuplot
Message-ID: <1992Nov13.014817.3123@seas.smu.edu>
Summary: C filter for producing a histogram in Gnuplot
Keywords: histogram insertion sort filter
Sender: news@seas.smu.edu (USENET News System)
Nntp-Posting-Host: turbo_f.seas.smu.edu
Organization: SMU School Of Engineering and Applied Science
References: <9211121849.AA13763@aulne.lifl.fr>
Date: Fri, 13 Nov 1992 01:48:17 GMT
Lines: 108

In article <9211121849.AA13763@aulne.lifl.fr> hemery@lifl.fr writes:
>I am looking for tool like gnuplot, for drawing histogram graphics.
>
>Do you know where I can find this kind of tool ?

The short program below is a filter that calculates a histogram
from a sequence of numbers and prints the output in such a format
that it can be plotted in Gnuplot by the command sequence

    !histogram < datain > tmp
    plot "tmp" with impulses

where
    `histogram' is the program's name
    `datain' is a file containing input data samples
    `tmp' is a file to hold histogram's output

The number of points generated is 100 by default. A different
number can be given as the first command line argument.
Supplying a non-integer argument will cause a help message to be
printed to the standard error.

Another usage example is

     !myprog | histogram 50 > tmp
     plot "tmp" with impulses

The maximum number of input data points that can be handled
was chosen arbitrarily to be 50000.

Yours respectfully,

Mustafa Kocaturk     mustafa@seas.smu.edu

/* ------- cut here and save the lines below as histogram.c --------- */
/*
This source code is placed in the public domain with no guarantee
of fitness for a particular purpose or of portability, but
only with the hope that it may be useful.

I wrote `histogram.c' as a part of my effort to contribute
to a paper by two of my colleagues at SMU. The paper
discussed various programming environments such as Gnuplot,
awk, spice, and xfig.

Mustafa Kocaturk    mustafa@seas.smu.edu  EE Dept., SEAS, SMU
*/
#include <stdio.h>
#include <math.h>
#define HELP \
"This program calculates the histogram of a sequence of numbers\n\
read from the standard input until an end of file is encountered.\n\
The results are printed on the standard output as lines of the format\n\
<subinterval midpoint> <number of sample points in subinterval>\n\
\n\
Usage: %s [number of subintervals (default==100)]\n" /* Message string */

#define CALSIZ	50000 /* Number of doubles to be allocated for sort */

main(argc,argv)
 int argc;
 char **argv;
 {
 double x,t,z,*a,*b,*f,*fe,*fl;
 unsigned i=0,k=100;
 int j=1;
 char c;
 if(argc>1)j=sscanf(argv[1],"%u",&k);
 if(j!=1){fprintf(stderr,HELP,argv[0]);return 0;}
 if(NULL==(a=(double *)calloc(CALSIZ,sizeof x)))
  {
  fprintf(stderr,"%s: Unable to allocate memory\n",(argv[0]));
  return 0; /* let other work continue */
  }
 fl=a+CALSIZ-1;
 fe=a;
 b=a+1;
 for(i=0;j>0&&fe<fl;)
  {
  if((j=scanf("%lf%*[^\n]%*c",&x))>0) /* If number was recognized */
   {
   f=fe++;
   while(x<*f&&f>a) { f[1]=*f; f--; }
   f[1]=x;
   i++;
   }
  else
   j=scanf("%*[^\n]%*c");
   /* Read data until end-of-line,
   if end-of-stdin (i. e. ctrl-D) then j<0 (i. e. break the for loop) */
  }
 x=*b; /* This was Insertion sort (increasing) */
 t=*fe;
 printf("# %d points in [%lg, %lg]; Frequencies in %d subintervals:\n",
  i,x,t,k);
 t=(t-x)/k;
 x+=t;
 for(f=b,i=0;i<k;i++,x+=t)
  {
  for(j=0;x>*f&&f<=fe;j++,f++);/* Count points in the subinterval */
  printf(" %l g %d\n",x-t*.5,j); /* Print subinterval center and
			number of points in the subinterval to stdout */
  }
 }
/* ------- cut here and save the lines above as histogram.c --------- */
-- 
Mustafa KOCATURK    mustafa@seas.smu.edu  EE Dept., Room 305A, Caruth Bldg.
Home: 214-706-5954  Office: 214-768-1475  SMU Box 753190, Dallas, TX 75275


