/* 
 * general arrow routine for Gnuplot 3.4
 *
 *    Note:     for Gnuplot 3.0-3.2, modify TBOOLEAN --> BOOLEAN
 *
 * Try replacing the original function of do_arrwo() in term.c in
 * Gnuplot3.4 to the following do_arrwo(). This will give you better 
 * outputs for graph with arrows, especially for vecter maps such as 
 * the ones obtained with the help of vect2gp script.
 * 
 * I set the angle between the arrowhead and the line 15 degree.
 * The length of arrowhead varies depending on the line length 
 * within the the range [0.3*(the-tic-length), 2*(the-tic-length)].
 * No head is printed if the arrow length is zero.
 *
 *            Yasu-hiro Yamazaki(hiro@rainbow.physics.utoronto.ca)
 *            Jul 1, 1993
 */

#define COS15 (0.96593)         /* cos of 15 degree */
#define SIN15 (0.25882)         /* sin of 15 degree */

#define HEAD_LONG_LIMIT  (2.0)  /* long  limit of arrowhead length */
#define HEAD_SHORT_LIMIT (0.3)  /* short limit of arrowhead length */
                                /* their units are the "tic" length */ 

#define HEAD_COEFF  (0.3)       /* default value of head/line length ratio */

do_arrow(sx, sy, ex, ey, head)
	int sx,sy;			/* start point */
	int ex, ey;			/* end point (point of arrowhead) */
	TBOOLEAN head;
{
    register struct termentry *t = &term_tbl[term];
    float len_tic = ((double) (t->h_tic + t->v_tic) )/2.0;
                                       /* average of tic sizes */
    double dx = (double)(sx - ex);
    double dy = (double)(sy - ey);     /* (dx,dy) : vector from end to start */
    double len_arrow = sqrt( dx*dx + dy*dy );

    /* draw the line for the arrow. That's easy. */
    (*t->move)(sx, sy);
    (*t->vector)(ex, ey);

    if (head && len_arrow != 0.0) { /* no head for arrows whih length=0 */
      /* now calc the head_coeff */
      double  coeff_shortest = len_tic*HEAD_SHORT_LIMIT/len_arrow;
      double  coeff_longest  = len_tic*HEAD_LONG_LIMIT/len_arrow;
      double  head_coeff = max( coeff_shortest, 
                                min( HEAD_COEFF, coeff_longest) );
    /* now draw the arrow head. */
    /* we put the arrowhead marks at 15 degrees to line */
      int x,y;			/* one endpoint */

      x = (int)( ex + ( COS15*dx - SIN15*dy) * head_coeff );
      y = (int)( ey + ( SIN15*dx + COS15*dy) * head_coeff );
      (*t->move)(x,y);
      (*t->vector)(ex,ey);

      x = (int)( ex + ( COS15*dx + SIN15*dy) * head_coeff );
      y = (int)( ey + (-SIN15*dx + COS15*dy) * head_coeff );
     (*t->vector)(x,y);
    }
}

/* oiginal routine */
#define ROOT2 (1.41421)		/* sqrt of 2 */

org_do_arrow(sx, sy, ex, ey, head)
	int sx,sy;			/* start point */
	int ex, ey;			/* end point (point of arrowhead) */
	TBOOLEAN head;
{
    register struct termentry *t = &term_tbl[term];
    int len = (t->h_tic + t->v_tic)/2; /* arrowhead size = avg of tic sizes */

    /* draw the line for the arrow. That's easy. */
    (*t->move)(sx, sy);
    (*t->vector)(ex, ey);

    if (head) {
    /* now draw the arrow head. */
    /* we put the arrowhead marks at 45 degrees to line */
       if (sx == ex) {
	   /* vertical line, special case */
	      int delta = ((float)len / ROOT2 + 0.5);
	      if (sy < ey)
		      delta = -delta;	/* up arrow goes the other way */
	      (*t->move)(ex - delta, ey + delta);
	      (*t->vector)(ex,ey);
	      (*t->vector)(ex + delta, ey + delta);
       } else {
	      int dx = sx - ex;
	      int dy = sy - ey;
	      double coeff = len / sqrt(2.0*((double)dx*(double)dx 
				   + (double)dy*(double)dy));
	      int x,y;			/* one endpoint */

	      x = (int)( ex + (dx + dy) * coeff );
	      y = (int)( ey + (dy - dx) * coeff );
	      (*t->move)(x,y);
	      (*t->vector)(ex,ey);

	      x = (int)( ex + (dx - dy) * coeff );
	      y = (int)( ey + (dy + dx) * coeff );
	      (*t->vector)(x,y);
       }
    }
}
