# Makefile for GNU Crypto project
#
# You are free to redistribute this file. NO WARRANTY or fitness
# for purpose is implied by this notice.
#
# !!!                                                  !!!
# !!!   MAKE EDITS TO "Makefile.aj", not "Makefile"    !!!
# !!!                                                  !!!
#
# Use the "configure" command to generate the project Makefile
# from its "Makefile.in" template.
#

PROJECTROOT = @srcdir@
SOURCEDIR=$(PROJECTROOT)/source

JAVAC = @JAVA_CC@
JAVAC_OPTS = @JAVA_CC_OPTS@
JAR = @JAR_TOOL@


# Variables which define some useful constants
newline:=\\n
empty:=
space:=$(empty) $(empty)


# The list of source files for gnucrypto.jar
# If everyone used GNU/Linux we could use this:
#   $(shell find $(SOURCEDIR) -name "*.java" -print | grep "$(SOURCEDIR)/gnu")
# Unfortunately they don't.
SOURCEFILES = $(SOURCEDIR)/gnu/crypto/Registry.java \
	$(SOURCEDIR)/gnu/crypto/cipher/Anubis.java \
	$(SOURCEDIR)/gnu/crypto/cipher/BaseCipher.java \
	$(SOURCEDIR)/gnu/crypto/cipher/CipherFactory.java \
	$(SOURCEDIR)/gnu/crypto/cipher/IBlockCipher.java \
	$(SOURCEDIR)/gnu/crypto/cipher/IBlockCipherSpi.java \
	$(SOURCEDIR)/gnu/crypto/cipher/Khazad.java \
	$(SOURCEDIR)/gnu/crypto/cipher/NullCipher.java \
	$(SOURCEDIR)/gnu/crypto/cipher/Rijndael.java \
	$(SOURCEDIR)/gnu/crypto/cipher/Square.java \
	$(SOURCEDIR)/gnu/crypto/cipher/Twofish.java \
	$(SOURCEDIR)/gnu/crypto/hash/BaseHash.java \
	$(SOURCEDIR)/gnu/crypto/hash/HashFactory.java \
	$(SOURCEDIR)/gnu/crypto/hash/IMessageDigest.java \
	$(SOURCEDIR)/gnu/crypto/hash/MD5.java \
	$(SOURCEDIR)/gnu/crypto/hash/RipeMD128.java \
	$(SOURCEDIR)/gnu/crypto/hash/RipeMD160.java \
	$(SOURCEDIR)/gnu/crypto/hash/Sha160.java \
	$(SOURCEDIR)/gnu/crypto/hash/Whirlpool.java \
	$(SOURCEDIR)/gnu/crypto/jce/DSSKeyPairGeneratorSpi.java \
	$(SOURCEDIR)/gnu/crypto/jce/DSSRawSignatureSpi.java \
	$(SOURCEDIR)/gnu/crypto/jce/GnuCrypto.java \
	$(SOURCEDIR)/gnu/crypto/jce/KeyPairGeneratorAdapter.java \
	$(SOURCEDIR)/gnu/crypto/jce/MD5Spi.java \
	$(SOURCEDIR)/gnu/crypto/jce/MessageDigestAdapter.java \
	$(SOURCEDIR)/gnu/crypto/jce/RSAKeyPairGeneratorSpi.java \
	$(SOURCEDIR)/gnu/crypto/jce/RSAPSSRawSignatureSpi.java \
	$(SOURCEDIR)/gnu/crypto/jce/RipeMD128Spi.java \
	$(SOURCEDIR)/gnu/crypto/jce/RipeMD160RandomSpi.java \
	$(SOURCEDIR)/gnu/crypto/jce/RipeMD160Spi.java \
	$(SOURCEDIR)/gnu/crypto/jce/SecureRandomAdapter.java \
	$(SOURCEDIR)/gnu/crypto/jce/Sha160RandomSpi.java \
	$(SOURCEDIR)/gnu/crypto/jce/Sha160Spi.java \
	$(SOURCEDIR)/gnu/crypto/jce/SignatureAdapter.java \
	$(SOURCEDIR)/gnu/crypto/jce/WhirlpoolRandomSpi.java \
	$(SOURCEDIR)/gnu/crypto/jce/WhirlpoolSpi.java \
	$(SOURCEDIR)/gnu/crypto/mode/BaseMode.java \
	$(SOURCEDIR)/gnu/crypto/mode/CTR.java \
	$(SOURCEDIR)/gnu/crypto/mode/ECB.java \
	$(SOURCEDIR)/gnu/crypto/mode/ICM.java \
	$(SOURCEDIR)/gnu/crypto/mode/IMode.java \
	$(SOURCEDIR)/gnu/crypto/mode/ModeFactory.java \
	$(SOURCEDIR)/gnu/crypto/pad/BasePad.java \
	$(SOURCEDIR)/gnu/crypto/pad/IPad.java \
	$(SOURCEDIR)/gnu/crypto/pad/PKCS7.java \
	$(SOURCEDIR)/gnu/crypto/pad/PadFactory.java \
	$(SOURCEDIR)/gnu/crypto/pad/TBC.java \
	$(SOURCEDIR)/gnu/crypto/pad/WrongPaddingException.java \
	$(SOURCEDIR)/gnu/crypto/prng/BasePRNG.java \
	$(SOURCEDIR)/gnu/crypto/prng/ICMGenerator.java \
	$(SOURCEDIR)/gnu/crypto/prng/IRandom.java \
	$(SOURCEDIR)/gnu/crypto/prng/LimitReachedException.java \
	$(SOURCEDIR)/gnu/crypto/prng/MDGenerator.java \
	$(SOURCEDIR)/gnu/crypto/prng/PRNGFactory.java \
	$(SOURCEDIR)/gnu/crypto/sig/BaseSignature.java \
	$(SOURCEDIR)/gnu/crypto/sig/IKeyPairCodec.java \
	$(SOURCEDIR)/gnu/crypto/sig/IKeyPairGenerator.java \
	$(SOURCEDIR)/gnu/crypto/sig/ISignature.java \
	$(SOURCEDIR)/gnu/crypto/sig/ISignatureCodec.java \
	$(SOURCEDIR)/gnu/crypto/sig/KeyPairGeneratorFactory.java \
	$(SOURCEDIR)/gnu/crypto/sig/SignatureFactory.java \
	$(SOURCEDIR)/gnu/crypto/sig/dss/DSSKey.java \
	$(SOURCEDIR)/gnu/crypto/sig/dss/DSSKeyPairGenerator.java \
	$(SOURCEDIR)/gnu/crypto/sig/dss/DSSKeyPairRawCodec.java \
	$(SOURCEDIR)/gnu/crypto/sig/dss/DSSPrivateKey.java \
	$(SOURCEDIR)/gnu/crypto/sig/dss/DSSPublicKey.java \
	$(SOURCEDIR)/gnu/crypto/sig/dss/DSSSignature.java \
	$(SOURCEDIR)/gnu/crypto/sig/dss/DSSSignatureRawCodec.java \
	$(SOURCEDIR)/gnu/crypto/sig/rsa/EMSA_PSS.java \
	$(SOURCEDIR)/gnu/crypto/sig/rsa/GnuRSAKey.java \
	$(SOURCEDIR)/gnu/crypto/sig/rsa/GnuRSAPrivateKey.java \
	$(SOURCEDIR)/gnu/crypto/sig/rsa/GnuRSAPublicKey.java \
	$(SOURCEDIR)/gnu/crypto/sig/rsa/RSA.java \
	$(SOURCEDIR)/gnu/crypto/sig/rsa/RSAKeyPairGenerator.java \
	$(SOURCEDIR)/gnu/crypto/sig/rsa/RSAKeyPairRawCodec.java \
	$(SOURCEDIR)/gnu/crypto/sig/rsa/RSAPSSSignature.java \
	$(SOURCEDIR)/gnu/crypto/sig/rsa/RSAPSSSignatureRawCodec.java \
	$(SOURCEDIR)/gnu/crypto/tool/CipherSpeed.java \
	$(SOURCEDIR)/gnu/crypto/tool/HashSpeed.java \
	$(SOURCEDIR)/gnu/crypto/tool/NessieCipherTVEmitter.java \
	$(SOURCEDIR)/gnu/crypto/tool/NessieHashTVEmitter.java \
	$(SOURCEDIR)/gnu/crypto/tool/NistKat.java \
	$(SOURCEDIR)/gnu/crypto/tool/NistMCT.java \
	$(SOURCEDIR)/gnu/crypto/util/PRNG.java \
	$(SOURCEDIR)/gnu/crypto/util/Prime.java \
	$(SOURCEDIR)/gnu/crypto/util/Util.java

# The list of source files for gnucrypto-test.jar
TESTFILES = $(SOURCEDIR)/test/AllTests.java \
	$(SOURCEDIR)/test/cipher/AllTests.java \
	$(SOURCEDIR)/test/cipher/TestOfAnubis.java \
	$(SOURCEDIR)/test/cipher/TestOfCipherFactory.java \
	$(SOURCEDIR)/test/cipher/TestOfKhazad.java \
	$(SOURCEDIR)/test/cipher/TestOfNullCipher.java \
	$(SOURCEDIR)/test/cipher/TestOfRijndael.java \
	$(SOURCEDIR)/test/cipher/TestOfSquare.java \
	$(SOURCEDIR)/test/cipher/TestOfTwofish.java \
	$(SOURCEDIR)/test/hash/AllTests.java \
	$(SOURCEDIR)/test/hash/TestOfHashFactory.java \
	$(SOURCEDIR)/test/hash/TestOfMD5.java \
	$(SOURCEDIR)/test/hash/TestOfRipeMD128.java \
	$(SOURCEDIR)/test/hash/TestOfRipeMD160.java \
	$(SOURCEDIR)/test/hash/TestOfSha160.java \
	$(SOURCEDIR)/test/hash/TestOfWhirlpool.java \
	$(SOURCEDIR)/test/jce/AllTests.java \
	$(SOURCEDIR)/test/jce/TestOfKeyPairGenerator.java \
	$(SOURCEDIR)/test/jce/TestOfMessageDigest.java \
	$(SOURCEDIR)/test/jce/TestOfProvider.java \
	$(SOURCEDIR)/test/jce/TestOfSignature.java \
	$(SOURCEDIR)/test/mode/AllTests.java \
	$(SOURCEDIR)/test/mode/TestOfModeFactory.java \
	$(SOURCEDIR)/test/pad/AllTests.java \
	$(SOURCEDIR)/test/pad/TestOfPKCS7.java \
	$(SOURCEDIR)/test/pad/TestOfPadFactory.java \
	$(SOURCEDIR)/test/pad/TestOfTBC.java \
	$(SOURCEDIR)/test/prng/AllTests.java \
	$(SOURCEDIR)/test/prng/TestOfICMGenerator.java \
	$(SOURCEDIR)/test/prng/TestOfPRNGFactory.java \
	$(SOURCEDIR)/test/sig/AllTests.java \
	$(SOURCEDIR)/test/sig/TestOfKeyPairGeneratorFactory.java \
	$(SOURCEDIR)/test/sig/TestOfSignatureFactory.java \
	$(SOURCEDIR)/test/sig/dss/AllTests.java \
	$(SOURCEDIR)/test/sig/dss/TestOfDSSCodec.java \
	$(SOURCEDIR)/test/sig/dss/TestOfDSSKeyGeneration.java \
	$(SOURCEDIR)/test/sig/dss/TestOfDSSSignature.java \
	$(SOURCEDIR)/test/sig/rsa/AllTests.java \
	$(SOURCEDIR)/test/sig/rsa/TestOfRSACodec.java \
	$(SOURCEDIR)/test/sig/rsa/TestOfRSAKeyGeneration.java \
	$(SOURCEDIR)/test/sig/rsa/TestOfRSAPSSSignature.java \


# Java doc package descriptions.
PKGFILES =


# Files that should be included in the JAR file.
RELEASEFILES = $(PROJECTROOT)/AUTHORS \
	$(PROJECTROOT)/ChangeLog  \
	$(PROJECTROOT)/COPYING  \
	$(PROJECTROOT)/LICENSE  \
	$(PROJECTROOT)/README  \
	$(PROJECTROOT)/NEWS  \
	$(PROJECTROOT)/THANKS



#
# Compiler is chosen through "configure" (autoconf)
#
GCJ_OPTS = --encoding=8859_1 -fsyntax-only -femit-class-files
GCJ_COMPILE = $(GCJ) $(GCJ_OPTS) -Isource -foutput-class-dir=$(CC-DESTDIR)



#
# REAL TARGETS
#
default:	jar

all:	jar javadoc

jar:	gnucrypto.jar gnucrypto-test.jar

# Cause the JUNIT tests to be run.
test:	jar
	$(JAVA) -classpath $(wildcard $(PROJECTROOT)/lib/*.jar) test.AllTests

# Make the javadoc.
javadoc: apidoc.zip


# This is an automakejar target. 
# Run automakejar on this Makefile.aj to produce a real Make
# compatible target.
gnucrypto.jar:
	sourcedir=$(SOURCEDIR)
	sourcefiles=$(SOURCEFILES)
	classesdest=classes
	otherfiles=$(RELEASEFILES)
	manifest=$(PROJECTROOT)/etc/gnu-crypto.mf


# This is an automakejar target.
# Run automakejar on this Makefile.aj to produce a real Make
# compatible target.
gnucrypto-test.jar:
	sourcedir=$(SOURCEDIR)
	sourcefiles=$(TESTFILES)
	classpath=$(PROJECTROOT)/lib/junit3_7.jar $(PROJECTROOT)/gnucrypto.jar
	classesdest=testclasses
	otherfiles=$(RELEASEFILES)
	manifest=$(PROJECTROOT)/etc/gnu-crypto.mf


# for normal development
# must rerun "make" after this
clean:
	-rm -rf filelist gnucrypto.jar gnucrypto-test.jar  docs/api
	-rm -rf classes testclasses
	-rm -rf gnucrypto*.zip

# must rerun configure after this
distclean:	clean
	-rm -f Makefile Makefile.in config.cache config.log config.status

# must rerun autoconf, aclocal, automakejar and configure after this
mrproper:	distclean
	-rm -f configure


# Construct the documentation.
apidoc.zip:
	-rm -rf docs/api
	mkdir -p docs/api
	javadoc -d docs/api \
		-windowtitle "GNU Crypto Library" \
		-nodeprecatedlist \
		-version -use \
		-doctitle "<H1>GNU Crypto Library<BR>Programmer's Documentation</H1>" \
		\
		-header "For the latest news and information visit<BR> \
		<A HREF="http://www.gnu.org/software/classpathx/crypto">The GNU Crypto project</A>" \
		\
		-bottom "Copyright &copy;2001 <A HREF="mailto:classpathx-crypto@gnu.org"> \
		Free Software Foundation, Inc.</A> All Rights Reserved." \
		-classpath "$(SOURCEDIR)" \
		\
		-group "GNU Crypto Algorithms" \
		"gnu.crypto.cipher:gnu.crypto.hash:gnu.crypto.mode:gnu.crypto.pad:gnu.crypto.prng" \
		\
		-group "GNU Crypto Signature Schemes" \
		"gnu.crypto.sig" \
		\
		-group "GNU Crypto Tools" \
		"gnu.crypto.tool" \
		\
		-group "GNU Crypto utilities" \
		"gnu.crypto.util" \
		\
		gnu.crypto.cipher \
		gnu.crypto.hash \
		gnu.crypto.mode \
		gnu.crypto.pad \
		gnu.crypto.prng \
		gnu.crypto.tool \
		gnu.crypto.util
	jar cMf lib/$(LIBNAME)-doc.zip -C docs api


#
# RELEASE ENGINEERING:
# "full" release has source, jarfile, javadoc, and extras
#
# override VERSION in environment, like:
#  $ VERSION=1.0beta1 make -e release
#
VERSION =	dev

release: $(LIBNAME)-$(VERSION).zip


DIST_DIR =	$(LIBNAME)-$(VERSION)

# XXX ChangeLog
FILES		:= \
	AUTHORS ChangeLog COPYING LICENSE NEWS README THANKS \
	build.xml configure configure.in Makefile.in \
	etc/$(LIBNAME).mf \
	lib/$(LIBNAME).jar lib/$(LIBNAME)-test.jar  \

$(LIBNAME)-$(VERSION).zip: test javadoc $(FILES) $(SOURCEFILES) $(TESTFILES) $(PKGFILES)
	for F in $(FILES) $(SOURCEFILES) $(PKGFILES) ;\
	do \
		 mkdir -p `dirname $(DIST_DIR)/$$F` ;\
		 cp $$F $(DIST_DIR)/$$F ;\
	done
	mkdir $(DIST_DIR)/docs
	cd $(DIST_DIR)/docs; jar xf ../../lib/$(LIBNAME)-doc.zip
	chmod +x $(DIST_DIR)/configure
	# jar cMf $(LIBNAME)-$(VERSION).zip $(DIST_DIR)
	zip -qr9 $(LIBNAME)-$(VERSION).zip $(DIST_DIR)
	tar -cf $(LIBNAME)-$(VERSION).tar $(DIST_DIR)
	gzip $(LIBNAME)-$(VERSION).tar
	rm -rf $(DIST_DIR)
