/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.pki.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public final class CollectionCertStoreImpl
extends CertStoreSpi {
    private final Collection store;

    public final Collection engineGetCertificates(CertSelector selector) throws CertStoreException {
        LinkedList result = new LinkedList();
        Iterator it = this.store.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof Certificate) || !selector.match((Certificate)o)) continue;
            result.add(o);
        }
        return result;
    }

    public final Collection engineGetCRLs(CRLSelector selector) throws CertStoreException {
        LinkedList result = new LinkedList();
        Iterator it = this.store.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof CRL) || !selector.match((CRL)o)) continue;
            result.add(o);
        }
        return result;
    }

    public CollectionCertStoreImpl(CertStoreParameters params) throws InvalidAlgorithmParameterException {
        super(params);
        if (!(params instanceof CollectionCertStoreParameters)) {
            throw new InvalidAlgorithmParameterException("not a CollectionCertStoreParameters object");
        }
        this.store = ((CollectionCertStoreParameters)params).getCollection();
    }
}

