#!/usr/local/bin/tclsh7.6
# automated printing system
#  Copyright (C) 1992-2000 Michigan State University
#
#  The CAPA system is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.
#
#  The CAPA system is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with the CAPA system; see the file COPYING.  If not,
#  write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#
#  As a special exception, you have permission to link this program
#  with the TtH/TtM library and distribute executables, as long as you
#  follow the requirements of the GNU GPL in regard to all of the
#  software in the executable aside from TtH/TtM.


puts "Automated printing Version 1.1"

proc quit { } {
    global dir
    cd $dir
    exit
}

proc parseCapaConfig { } {
    global onesided twosided 

    set filename [file join [pwd] capa.config]
    set error [ catch { set fileId [open $filename "r"] } ]
    if { $error } {
        return 
    }

    while { 1 } {
        gets $fileId aline
        if { [eof $fileId ] } { break }
        switch -glob -- "$aline" {
            "lprOneSided_command *= *"
            { set onesided [lindex $aline end] }
            "lprTwoSided_command *= *"
            { set twosided [lindex $aline end] }
        }                                              
    }
    if { [string first \$PS_file $onesided] == -1 } {
	set onesided "$onesided \$PS_file"
    }

    if { [string first \$PS_file $twosided] == -1 } {
	set twosided "$twosided \$PS_file"
    }
}

proc parsesection { sec set } {
    if { [ catch { exec echo [pwd] | qzparse -sec $sec \
	    -set $set >&@ file1 } ] } {
	puts "Error occured while parsing set: $set section: $sec"
	quit
    }
}

proc latexsection { sec set } { 
    if { [ catch { cd TeX } ] } {
	puts "Unable to find [pwd]/TeX"
	quit
    }

    if { [ catch { exec latex section$sec-set$set < /dev/null >&@ file1 } ] } {
	puts "Error occured while latexing set: $set section: $sec"
	quit
    }
    cd ..
}

proc dvisection { sec set } {
    if { [ catch { cd TeX } ] } {
	puts "Unable to find [pwd]/TeX"
	quit
    }
    
    if { [ catch { exec dvips -o section$sec-set$set.ps \
	    section$sec-set$set.dvi < /dev/null >&@ file1 } ] } {
	puts "Error occured while creating dvi, set: $set section: $sec"
	quit
    }
    cd ..
}

proc printonesided { sec set Printer_selected } {
    global onesided
    if { [ catch { cd TeX } ] } {
	puts "Unable to find [pwd]/TeX"
	quit
    }
    set PS_file section$sec-set$set.ps
    if { [ catch { eval "exec $onesided < /dev/null >&@ file1" } ] } {
	puts "Error occured while printing set: $set section: $sec"
	quit
    }
    cd ..
}

proc printtwosided { sec set Printer_selected } {
    if { [ catch { cd TeX } ] } {
	puts "Unable to find [pwd]/TeX"
	quit
    }
    set PS_file section$sec-set$set.ps
    if { [ catch { eval "exec $twosided < /dev/null >&@file1" } ] } {
	puts "Error occured while printing set: $set section: $sec"
	quit
    }
    cd ..
}

proc cleanup { sec set { some 0 } } {
    set ext "dvi log aux ps tex"
    if { $some } { set ext "dvi log aux" }
    foreach ext { tex dvi ps log aux } {
	exec rm -f TeX/section$sec-set$set.$ext
    }
}

if { $argc == 6 } {
    set pathname [lindex $argv 0]
    set startsection [lindex $argv 1]
    set endsection [lindex $argv 2]
    set setnumber [lindex $argv 3]
    set sided [lindex $argv 4]
    set printqueue [lindex $argv 5]
    puts "Running class $pathname for sections $startsection:$endsection for set $setnumber on printer $printqueue, printing $sided side(s)"
} else {
    if { $argc != 0 } {
	puts "Usage is $argv0 pathname startsection endsection setnumber #sides printqueue"
	puts "       Specifying 0 sides will leave the postscript files behind and not print"
    }
    while { 1 } {
	puts "Enter the ABSOLUTE pathname of the class:"
	gets file0 pathname
	puts "Enter start section:"
	gets file0 startsection
	puts "Enter end section:"
	gets file0 endsection
	puts "Enter set:"
	gets file0 setnumber
	puts "One sided or two sided: (1 or 2)"
	gets file0 sided
	if { $sided != 0 } {
	    puts "Enter the name of the printer:"
	    gets file0 printqueue
	    puts "Run class $pathname for sections $startsection:$endsection for set $setnumber on printer $printqueue, printing $sided side(s)? (y or n)"
	} else {
	    puts "Run class $pathname for sections $startsection:$endsection for set $setnumber with no printing? (y or n)"
        }
	if { "y" == [string range [string trimleft [gets file0] ] 0 0 ] } {
	    break
	}
    }
}
set dir [pwd]

if { [ catch { cd $pathname } ] } {
    puts "Invalid class $pathname"
    quit
}

set onesided "lpr -P\$Printer_selected"
set twosided "lpspr -K2 \$PS_file | lpr -P\$Printer_selected"
parseCapaConfig

if { $endsection == 0 } {
    set endsection $startsection
}


for { set i $startsection } { $i <= $endsection } { incr i } {
    parsesection $i $setnumber
    latexsection $i $setnumber
    dvisection $i $setnumber
    if { $sided == 1 } {
	printonesided $i $setnumber $printqueue
    } elseif { $sided == 2 }  {
	printonesided $i $setnumber $printqueue
    }
    if { $sided != 0 } { cleanup $i $setnumber
    } else { cleanup $i $setnumber 1 
    }
}


