#line 1 "input.c"
/* This file is part of GNU Radius.
   Copyright (C) 2000-2025 Free Software Foundation, Inc.

   Written by Sergey Poznyakoff

   GNU Radius is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   GNU Radius is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Radius.  If not, see <http://www.gnu.org/licenses/>. */

#if defined(HAVE_CONFIG_H)
# include <config.h>
#endif

#line 24 "input.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin  )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = NULL; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = NULL;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart ( FILE *input_file  );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size  );
void yy_delete_buffer ( YY_BUFFER_STATE b  );
void yy_flush_buffer ( YY_BUFFER_STATE b  );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state ( void );

static void yyensure_buffer_stack ( void );
static void yy_load_buffer_state ( void );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file  );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size  );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len  );

void *yyalloc ( yy_size_t  );
void *yyrealloc ( void *, yy_size_t  );
void yyfree ( void *  );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */
typedef flex_uint8_t YY_CHAR;

FILE *yyin = NULL, *yyout = NULL;

typedef int yy_state_type;

extern int yylineno;
int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state ( void );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  );
static int yy_get_next_buffer ( void );
static void yynoreturn yy_fatal_error ( const char* msg  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;
#define YY_NUM_RULES 65
#define YY_END_OF_BUFFER 66
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_accept[196] =
    {   0,
        0,    0,    0,    0,    0,    0,   66,   64,   53,   55,
       63,   64,    2,   64,   64,   52,   56,   60,   57,   59,
       28,   64,   28,   28,   28,   28,   28,   28,   28,   28,
       28,   28,   28,   28,   28,   65,   47,   48,   65,   65,
       50,   53,   58,    0,   40,   39,    0,    2,    1,   35,
       36,   30,    0,    0,    3,    0,   52,    0,   62,   61,
       28,   54,   28,   28,   28,   28,   28,   28,   28,   15,
       28,   28,   28,   28,   12,   25,   28,   19,   28,   28,
       28,   28,   28,    0,   47,   48,    0,   46,   44,   46,
        0,   50,   41,   41,   41,   29,   30,    0,    0,    0,

       52,    0,    0,   28,   20,   28,   28,   28,   28,   28,
       28,   11,   28,   28,   28,   28,   18,   28,   28,   28,
       28,   28,   28,   44,   45,   42,   43,    0,   37,    0,
        0,   32,    0,    0,   52,    0,   49,    0,    5,    4,
       28,   28,   24,   28,   13,    9,   28,   28,   28,   28,
       28,    7,    0,   28,   28,   44,   45,   42,   43,    0,
        0,   31,    0,    0,   10,   16,   28,   28,   28,   21,
        6,   28,    0,    0,   27,   22,   14,    0,   38,    0,
       34,    0,    0,   28,    8,   23,   26,   33,   51,    0,
       28,   51,   17,   51,    0

    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    4,    5,    6,    7,    1,    8,    9,    1,
        1,    1,    1,    1,   10,   11,    1,   12,   12,   12,
       12,   12,   12,   12,   12,   13,   13,   14,   15,   16,
       17,   18,    8,    1,   19,   19,   19,   19,   19,   19,
       20,   20,   20,   20,   20,   20,   20,   20,   20,   20,
       20,   20,   20,   20,   20,   20,   20,   21,   20,   20,
        1,   22,    1,    1,   20,    1,   23,   24,   25,   26,

       27,   28,   29,   30,   31,   20,   32,   33,   20,   34,
       35,   36,   20,   37,   38,   39,   40,   20,   41,   42,
       20,   20,   43,    1,   44,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static const YY_CHAR yy_meta[45] =
    {   0,
        1,    1,    2,    1,    1,    3,    1,    1,    1,    4,
        5,    6,    6,    7,    1,    1,    1,    1,    8,    9,
        9,    1,    8,    8,    8,    8,    8,    8,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    3,    7
    } ;

static const flex_int16_t yy_base[220] =
    {   0,
        0,    0,   42,   43,  440,  439,  441,  444,  438,  444,
      422,   46,  435,   44,  428,   41,  444,   42,  444,  419,
        0,  432,   35,   34,   32,  399,   39,  406,   42,  397,
      394,  393,  402,   36,  398,   74,   75,  444,   62,  424,
      444,  424,  444,   79,   83,  444,   73,  422,  444,  444,
       77,  414,   79,  414,  444,   86,   95,  412,  444,  444,
        0,  444,  396,  394,  380,  389,  390,  378,  381,    0,
      376,  387,   64,  373,    0,  375,  371,    0,  371,  354,
       75,  341,  338,  107,  108,  444,   81,  444,  339,    0,
      345,  444,  444,  332,    0,  333,  332,  104,   89,  108,

      113,  328,  148,  295,    0,  293,  274,  269,  250,  236,
      247,    0,  195,  206,  197,  191,    0,  196,  189,  202,
      225,  198,  192,  212,    0,  211,    0,  124,  444,  114,
      129,  212,  123,  148,  132,  218,  444,  192,    0,    0,
      186,  187,    0,  187,    0,    0,  192,  180,  176,  174,
      175,    0,  165,  172,  178,  444,  444,  444,  444,  160,
      159,  444,  160,  191,    0,    0,  156,  150,  149,    0,
        0,  153,  183,  172,  444,    0,    0,  125,  103,   96,
      132,  165,  168,   91,    0,    0,    0,   83,  170,  111,
       35,  172,    0,  444,  444,  236,  245,  254,  263,  270,

      279,  285,  294,  303,  312,  321,  327,  331,  337,  341,
      344,  349,  358,  362,  365,  373,  382,  391,  400
    } ;

static const flex_int16_t yy_def[220] =
    {   0,
      195,    1,  196,  196,  197,  197,  195,  195,  195,  195,
      195,  198,  199,  200,  201,  195,  195,  195,  195,  195,
      202,  195,  202,  202,  202,  202,  202,  202,  202,  202,
      202,  202,  202,  202,  202,  203,  203,  195,  204,  205,
      195,  195,  195,  198,  198,  195,  206,  199,  195,  195,
      195,  207,  208,  201,  195,  195,  195,  209,  195,  195,
      202,  195,  202,  202,  202,  202,  202,  202,  202,  202,
      202,  202,  202,  202,  202,  202,  202,  202,  202,  202,
      202,  202,  202,  203,  203,  195,  204,  195,  195,  210,
      205,  195,  195,  195,  211,  207,  207,  195,  212,  195,

      195,  209,  213,  202,  202,  202,  202,  202,  202,  202,
      202,  202,  202,  202,  202,  202,  202,  202,  202,  202,
      202,  202,  202,  195,  214,  195,  215,  195,  195,  212,
      195,  195,  195,  195,  195,  216,  195,  213,  202,  202,
      202,  202,  202,  202,  202,  202,  202,  202,  202,  202,
      202,  202,  217,  202,  202,  195,  195,  195,  195,  218,
      219,  195,  195,  195,  202,  202,  202,  202,  202,  202,
      202,  202,  217,  217,  195,  202,  202,  218,  218,  219,
      219,  195,  195,  202,  202,  202,  202,  219,  195,  195,
      202,  195,  202,  195,    0,  195,  195,  195,  195,  195,

      195,  195,  195,  195,  195,  195,  195,  195,  195,  195,
      195,  195,  195,  195,  195,  195,  195,  195,  195
    } ;

static const flex_int16_t yy_nxt[489] =
    {   0,
        8,    9,   10,   11,   12,   13,   14,    8,   15,    8,
        8,   16,   16,    8,   17,   18,   19,   20,   21,   21,
       21,   22,   23,   24,   25,   26,   27,   21,   28,   21,
       29,   21,   21,   30,   31,   32,   33,   34,   21,   21,
       35,   21,    8,    8,   37,   37,   38,   38,   45,   50,
       46,   56,   57,   57,   68,   51,   51,   58,   59,   63,
       66,  193,   81,   39,   39,   82,   69,   47,   64,   75,
       67,   71,   72,   89,   65,   76,   85,   85,   86,   86,
       73,   45,   90,   46,   94,   45,   53,   46,   51,   51,
       98,   98,   89,   95,  113,   87,   87,  100,  100,  114,

       47,   90,  131,   90,   47,   56,  101,  101,  120,   85,
       85,   86,   86,  121,   95,   98,   98,  128,  133,  134,
      134,  182,   90,   56,  135,  135,  181,  131,   87,   87,
      191,  160,  132,  160,  163,  163,  161,  160,  161,  181,
      160,  188,  161,  135,  135,  161,  179,  129,  136,  136,
      137,  136,  136,  136,  136,  136,  136,  132,  133,  164,
      164,  136,  136,  136,  136,  136,  174,  175,  179,  136,
      182,  183,  183,  174,  175,  181,  189,  189,  182,  190,
      190,  192,  192,  194,  194,  175,  187,  186,  185,  184,
      136,  136,  136,  136,  137,  136,  136,  136,  136,  136,

      136,  133,  181,  179,  177,  136,  136,  136,  136,  136,
      176,  172,  171,  136,  170,  169,  168,  167,  166,  165,
      137,  162,  158,  156,  155,  154,  153,  152,  151,  150,
      149,  148,  147,  146,  136,  136,   36,   36,   36,   36,
       36,   36,   36,   36,   36,   40,   40,   40,   40,   40,
       40,   40,   40,   40,   44,   44,   44,   44,   44,   44,
       44,   44,   44,   48,   48,   48,   48,   48,   48,   48,
       48,   48,   52,  145,  144,   52,  143,   52,   52,   54,
       54,   54,   54,   54,   54,   54,   54,   54,   61,   61,
       61,  142,   61,   61,   84,   84,   84,   84,   84,   84,

       84,   84,   84,   88,  141,   88,   88,   88,   88,   88,
       88,   88,   91,   91,   91,   91,   91,   91,   91,   91,
       91,   93,  140,   93,   93,   93,   93,   93,   93,   93,
       97,   97,   97,  139,   97,   97,   99,  195,   99,   99,
      103,   96,   96,  126,  103,  103,  125,   92,  125,  127,
      124,  127,  130,  130,  130,  130,  130,  130,  138,  138,
      138,  138,  138,  138,  138,  138,  138,  157,  123,  157,
      159,  122,  159,  136,  136,  136,  136,  136,  136,  136,
      136,  136,  173,  173,  173,  173,  173,  173,  173,  173,
      173,  178,  119,  178,  178,  178,  178,  178,  178,  178,

      180,  118,  180,  180,  180,  180,  180,  180,  180,  117,
      116,  115,  112,  111,  110,  109,  108,  107,  106,  105,
      104,  102,   55,   96,   49,   42,   92,   83,   80,   79,
       78,   77,   74,   70,   62,   60,   55,   49,   43,   42,
      195,   41,   41,    7,  195,  195,  195,  195,  195,  195,
      195,  195,  195,  195,  195,  195,  195,  195,  195,  195,
      195,  195,  195,  195,  195,  195,  195,  195,  195,  195,
      195,  195,  195,  195,  195,  195,  195,  195,  195,  195,
      195,  195,  195,  195,  195,  195,  195,  195
    } ;

static const flex_int16_t yy_chk[489] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    3,    4,    3,    4,   12,   14,
       12,   16,   16,   16,   25,   14,   14,   18,   18,   23,
       24,  191,   34,    3,    4,   34,   25,   12,   23,   29,
       24,   27,   27,   39,   23,   29,   36,   37,   36,   37,
       27,   44,   39,   44,   47,   45,   14,   45,   51,   51,
       53,   53,   87,   47,   73,   36,   37,   56,   56,   73,

       44,   87,   99,   39,   45,   57,   57,   57,   81,   84,
       85,   84,   85,   81,   47,   98,   98,   98,  100,  100,
      100,  190,   87,  101,  101,  101,  188,  130,   84,   85,
      184,  128,   99,  128,  133,  133,  131,  128,  131,  180,
      128,  181,  131,  135,  135,  131,  179,   98,  103,  103,
      103,  103,  103,  103,  103,  103,  103,  130,  134,  134,
      134,  103,  103,  103,  103,  103,  153,  153,  178,  103,
      163,  163,  163,  174,  174,  181,  182,  182,  183,  183,
      183,  189,  189,  192,  192,  173,  172,  169,  168,  167,
      103,  103,  138,  138,  138,  138,  138,  138,  138,  138,

      138,  164,  161,  160,  155,  138,  138,  138,  138,  138,
      154,  151,  150,  138,  149,  148,  147,  144,  142,  141,
      136,  132,  126,  124,  123,  122,  121,  120,  119,  118,
      116,  115,  114,  113,  138,  138,  196,  196,  196,  196,
      196,  196,  196,  196,  196,  197,  197,  197,  197,  197,
      197,  197,  197,  197,  198,  198,  198,  198,  198,  198,
      198,  198,  198,  199,  199,  199,  199,  199,  199,  199,
      199,  199,  200,  111,  110,  200,  109,  200,  200,  201,
      201,  201,  201,  201,  201,  201,  201,  201,  202,  202,
      202,  108,  202,  202,  203,  203,  203,  203,  203,  203,

      203,  203,  203,  204,  107,  204,  204,  204,  204,  204,
      204,  204,  205,  205,  205,  205,  205,  205,  205,  205,
      205,  206,  106,  206,  206,  206,  206,  206,  206,  206,
      207,  207,  207,  104,  207,  207,  208,  102,  208,  208,
      209,   97,   96,   94,  209,  209,  210,   91,  210,  211,
       89,  211,  212,  212,  212,  212,  212,  212,  213,  213,
      213,  213,  213,  213,  213,  213,  213,  214,   83,  214,
      215,   82,  215,  216,  216,  216,  216,  216,  216,  216,
      216,  216,  217,  217,  217,  217,  217,  217,  217,  217,
      217,  218,   80,  218,  218,  218,  218,  218,  218,  218,

      219,   79,  219,  219,  219,  219,  219,  219,  219,   77,
       76,   74,   72,   71,   69,   68,   67,   66,   65,   64,
       63,   58,   54,   52,   48,   42,   40,   35,   33,   32,
       31,   30,   28,   26,   22,   20,   15,   13,   11,    9,
        7,    6,    5,  195,  195,  195,  195,  195,  195,  195,
      195,  195,  195,  195,  195,  195,  195,  195,  195,  195,
      195,  195,  195,  195,  195,  195,  195,  195,  195,  195,
      195,  195,  195,  195,  195,  195,  195,  195,  195,  195,
      195,  195,  195,  195,  195,  195,  195,  195
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "input.l"

#line 25 "input.l"
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <netinet/in.h>

#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include <fcntl.h>
#include <time.h>
#include <ctype.h>
#include <unistd.h>
#include <signal.h>
#include <errno.h>
#include <sys/wait.h>

#include <common.h>
#include <radius/radius.h>
#include <radtest.h>
#include "gram.h"

int interactive;                   /* Are we in interactive mode? */
char prompt_str[] = "radtest> ";   /* Prompt string for interactive mode */
grad_locus_t source_locus;         /* Current location in the source file */
static grad_strbuf_t string_buf;   /* Keeps all string literals. Gets freed
				      after compilation and (eventual)
				      execution of the statement */

size_t string_start_line;          /* In STRING and HEREDOC mode keeps
				      the line where the string definition
				      has started */

/* Here document support */
static char *heredoc_delimiter;    /* End delimiter for here document */
static int strip_tabs;             /* Strip leading tab characters */


/* Input buffer */

/* The variables below are used only in interactive mode */
static char *input_line;           /* Input line */
static size_t input_length;        /* Size of input_line */
static size_t input_pos;           /* Current position in input_line */

/* Read from the input stream at most `bufsize' character into buffer `buf' */
static int
fill_input_buffer(char *buf, int bufsize)
{
	if (interactive) {
		int rest;

		if (!input_line || input_pos == input_length) {
			if (disable_readline) {
				char buf[BUFSIZ];

				printf("%s", prompt_str);
				fflush(stdout);

				if (!fgets(buf, sizeof(buf), yyin)) {
					free (input_line);
					input_line = NULL;
					input_length = 0;
					return 0;
				}

				if (!input_line)
					input_line = grad_emalloc(sizeof(buf));
				input_length = strlen(buf);
				memcpy(input_line, buf, input_length);
				input_pos = 0;
			} else {
				free(input_line);
				input_line = grad_readline(prompt_str);
				if (!input_line)
					return 0;
				grad_add_history(input_line);
				input_length = strlen (input_line);
				input_line = realloc(input_line,
						     input_length+2);
				if (!input_line) {
					fprintf (stderr,
						 _("low core: aborting"));
					abort();
				}
				input_line[input_length++] = '\n';
				input_line[input_length] = 0;
				input_pos = 0;
			}
		}
		rest = input_length - input_pos;
		if (bufsize > rest)
			bufsize = rest;
		memcpy(buf, input_line + input_pos, bufsize);
		input_pos += bufsize;
		return bufsize;
	} else {
		return fread(buf, 1, bufsize, yyin);
	}
}

#ifdef FLEX_SCANNER
/* Input support for flex */

#undef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
  result = fill_input_buffer(buf, max_size)

#else /* !FLEX_SCANNER */
/* Input processing for AT&T Lex. Untested. */

static int
xinput(void)
{
	char c;
	if (fill_input_buffer(&c, 1) <= 0)
		return EOF;
	return c;
}

static int
xunput(int c)
{
	if (input_pos == 0)
		abort();
	return input_line[--input_pos] = c;
}

#undef unput
#define unput(c) xunput(c)
#undef input
#define input() xinput()

#endif /* FLEX_SCANNER */

static size_t string_len;
static int binary_string;

/* Forward declarations */
static void begin_str();
static void add_str(char *str, int  len);
static void add_chr(int c);
static char *end_str();
static void add_num(int skip, int base, char *text, int leng);

static int backspace(int c);

static int isemptystr(char *text);
static char *heredoc_strip_tabs(char *text);
static void heredoc_begin();

#line 791 "input.c"
#define YY_NO_INPUT 1

#line 794 "input.c"

#define INITIAL 0
#define STRING 1
#define HEREDOC 2

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals ( void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( void );

int yyget_debug ( void );

void yyset_debug ( int debug_flag  );

YY_EXTRA_TYPE yyget_extra ( void );

void yyset_extra ( YY_EXTRA_TYPE user_defined  );

FILE *yyget_in ( void );

void yyset_in  ( FILE * _in_str  );

FILE *yyget_out ( void );

void yyset_out  ( FILE * _out_str  );

			int yyget_leng ( void );

char *yyget_text ( void );

int yyget_lineno ( void );

void yyset_lineno ( int _line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( void );
#else
extern int yywrap ( void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * );
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( void );
#else
static int input ( void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE );
		}

		yy_load_buffer_state(  );
		}

	{
#line 189 "input.l"

#line 1013 "input.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 196 )
					yy_c = yy_meta[yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 444 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 190 "input.l"
{ /* a comment */
	source_locus.line++;
	return EOL;
}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 194 "input.l"
/* end-of-file comment */;
	YY_BREAK
case 3:
/* rule 3 can match eol */
YY_RULE_SETUP
#line 195 "input.l"
{
	add_str(yytext+1,yyleng-2);
	yylval.string = end_str();
	return NAME;
}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 200 "input.l"
return AUTH;
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 201 "input.l"
return ACCT;
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 202 "input.l"
return PRINT;
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 203 "input.l"
return SEND;
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 204 "input.l"
return EXPECT;
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 205 "input.l"
return EXIT;
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 206 "input.l"
return T_BEGIN;
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 207 "input.l"
return T_END;
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 208 "input.l"
return IF;
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 209 "input.l"
{
	switch (peek_ctx()) {
	case ctx_if:
		  return ELSE;

	case ctx_iferr:
		pop_ctx();
		break;

	default:
		  parse_error(_("Misplaced 'else'"));
		  /* Skip the token */
	}
}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 223 "input.l"
{
	if (peek_ctx() == ctx_doerr)
		pop_ctx();
	else
		return WHILE;
}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 229 "input.l"
return DO;
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 230 "input.l"
return BREAK;
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 231 "input.l"
return CONTINUE;
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 232 "input.l"
return NOT;
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 233 "input.l"
return OR;
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 234 "input.l"
return AND;
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 235 "input.l"
return INPUT;
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 236 "input.l"
return SHIFT;
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 237 "input.l"
return GETOPT;
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 238 "input.l"
return CASE;
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 239 "input.l"
return IN;
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 240 "input.l"
return T_RETURN;
	YY_BREAK
case 27:
/* rule 27 can match eol */
YY_RULE_SETUP
#line 241 "input.l"
{
	int argc;
	char **argv;

	grad_argcv_get(yytext, "", NULL, &argc, &argv);
	radtest_register_argv(argv);
	yylval.set.argc = argc;
	yylval.set.argv = argv;
	if (yytext[yyleng-2] == '\\')
		yyless(yyleng-2);
	else
		yyless(yyleng-1);
	return SET;
}
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 255 "input.l"
{
	int n = grad_request_name_to_code(yytext);
	if (n != 0) {
		yylval.number = n;
		return NUMBER;
	}
	add_str(yytext,yyleng);
	yylval.string = end_str();
	return NAME;
}
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 265 "input.l"
{
	add_str(yytext+1,yyleng-2);
	yylval.deref.name = end_str();
	yylval.deref.repl = NULL;
	yyless(yyleng-1);
	return IDENT;
}
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 272 "input.l"
{
	add_str(yytext+1,yyleng-1);
	yylval.deref.name = end_str();
	yylval.deref.repl = NULL;
	return IDENT;
}
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 278 "input.l"
{
	add_str(yytext+2, yyleng-4);
	yylval.deref.name = end_str();
	yylval.deref.repl = NULL;
	yyless(yyleng-1);
	return IDENT;
}
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 285 "input.l"
{
	add_str(yytext+2, yyleng-3);
	yylval.deref.name = end_str();
	yylval.deref.repl = NULL;
	return IDENT;
}
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 291 "input.l"
{
	char *p;
	add_str(yytext+2, yyleng-4);
	yylval.deref.name = end_str();
	p = strchr(yylval.deref.name, ':');
	*p++ = 0;
	yylval.deref.repl = p;
	yyless(yyleng-1);
	return IDENT;
}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 301 "input.l"
{
	char *p;
	add_str(yytext+2, yyleng-3);
	yylval.deref.name = end_str();
	p = strchr(yylval.deref.name, ':');
	*p++ = 0;
	yylval.deref.repl = p;
	return IDENT;
}
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 310 "input.l"
return ARGCOUNT;
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 311 "input.l"
{
	yylval.parm.number = strtoul(yytext+1, NULL, 0);
	yylval.parm.repl = NULL;
	return PARM;
}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 316 "input.l"
{
	yylval.parm.number = strtoul(yytext+2, NULL, 0);
	yylval.parm.repl = NULL;
	return PARM;
}
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 321 "input.l"
{
	char *p;
	yylval.parm.number = strtoul(yytext+2, &p, 0);
	p++;
	add_str(p, strlen(p)-1);
	yylval.parm.repl = end_str();
	return PARM;
}
	YY_BREAK
case 39:
/* rule 39 can match eol */
YY_RULE_SETUP
#line 329 "input.l"
{
	begin_str();
	add_str(yytext+1, yyleng-2);
	yylval.string = end_str();
	return QUOTE;
}
	YY_BREAK
case 40:
/* rule 40 can match eol */
YY_RULE_SETUP
#line 335 "input.l"
{
	BEGIN(STRING);
	begin_str();
	string_start_line = source_locus.line++;
	add_str(yytext+1, yyleng-1);
}
	YY_BREAK
case 41:
/* rule 41 can match eol */
YY_RULE_SETUP
#line 341 "input.l"
{
	BEGIN(STRING);
	begin_str();
	string_start_line = source_locus.line;
	if (yytext[yyleng-1] == '\n')
		source_locus.line++;
	add_str(yytext+1, yyleng - 3);
	add_chr(backspace(yytext[yyleng-1]));
}
	YY_BREAK
case 42:
/* rule 42 can match eol */
YY_RULE_SETUP
#line 350 "input.l"
{
	BEGIN(STRING);
	begin_str();
	add_num(0, 8, yytext+1, yyleng-1);
}
	YY_BREAK
case 43:
/* rule 43 can match eol */
YY_RULE_SETUP
#line 355 "input.l"
{
	BEGIN(STRING);
	begin_str();
	add_num(1, 16, yytext+1, yyleng-1);
}
	YY_BREAK
case 44:
/* rule 44 can match eol */
YY_RULE_SETUP
#line 360 "input.l"
{
	add_num(0, 8, yytext, yyleng);
}
	YY_BREAK
case 45:
/* rule 45 can match eol */
YY_RULE_SETUP
#line 363 "input.l"
{
	add_num(1, 16, yytext, yyleng);
}
	YY_BREAK
case 46:
/* rule 46 can match eol */
YY_RULE_SETUP
#line 366 "input.l"
{
	if (yytext[yyleng-1] == '\n')
		source_locus.line++;
	add_str(yytext, yyleng - 2);
	add_chr(backspace(yytext[yyleng-1]));
}
	YY_BREAK
case 47:
/* rule 47 can match eol */
YY_RULE_SETUP
#line 372 "input.l"
{
	source_locus.line++;
	add_str(yytext, yyleng);
	add_chr(backspace(yytext[yyleng-1]));
}
	YY_BREAK
case 48:
/* rule 48 can match eol */
YY_RULE_SETUP
#line 377 "input.l"
{
	BEGIN(INITIAL);
	add_str(yytext, yyleng - 1);
	if (binary_string) {
	    yylval.bstring.ptr = end_str();
	    yylval.bstring.length = string_len;
	    return BSTRING;
	} else {
	    yylval.string = end_str();
	    return QUOTE;
	}
}
	YY_BREAK
case 49:
/* rule 49 can match eol */
YY_RULE_SETUP
#line 389 "input.l"
{
	BEGIN(HEREDOC);
	begin_str();
	string_start_line = source_locus.line++;
	heredoc_begin();
}
	YY_BREAK
case 50:
/* rule 50 can match eol */
YY_RULE_SETUP
#line 395 "input.l"
{
	char *p = heredoc_strip_tabs (yytext);
	if (strncmp (p, heredoc_delimiter, strlen (heredoc_delimiter))
	    == 0
	    && isemptystr (p + strlen (heredoc_delimiter))) {
		free (heredoc_delimiter);
		heredoc_delimiter = NULL;
		BEGIN(INITIAL);
		yylval.string = end_str();
		yyless(yyleng-1);
		return QUOTE;
	}
	add_str(p, strlen(p));
	source_locus.line++;
}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 410 "input.l"
{
	yylval.ipaddr = grad_ip_strtoip(yytext);
	return IPADDRESS;
}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 414 "input.l"
{
	yylval.number = strtol(yytext, NULL, 0);
	return NUMBER;
}
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 418 "input.l"
;
	YY_BREAK
case 54:
/* rule 54 can match eol */
YY_RULE_SETUP
#line 419 "input.l"
source_locus.line++;
	YY_BREAK
case 55:
/* rule 55 can match eol */
YY_RULE_SETUP
#line 420 "input.l"
{ source_locus.line++; return EOL; }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 421 "input.l"
return EOL;
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 422 "input.l"
return EQ;
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 423 "input.l"
return NE;
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 424 "input.l"
return GT;
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 425 "input.l"
return LT;
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 426 "input.l"
return GE;
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 427 "input.l"
return LE;
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 428 "input.l"
return NOT;
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 429 "input.l"
return yytext[0];
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 431 "input.l"
ECHO;
	YY_BREAK
#line 1588 "input.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(STRING):
case YY_STATE_EOF(HEREDOC):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap(  ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2)  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 196 )
				yy_c = yy_meta[yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
    	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 196 )
			yy_c = yy_meta[yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	yy_is_jam = (yy_current_state == 195);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (int) ((yy_c_buf_p) - (yytext_ptr));
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap(  ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE );
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file );
	yy_load_buffer_state(  );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state(  );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2)  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf  );

	yyfree( (void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state(  );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state(  );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state(  );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr )
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg )
{
			fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
    
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = NULL;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = NULL;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 431 "input.l"


int
yywrap(void)
{
	if (YYSTATE == STRING)
		parse_error(_("Unexpected end of file in string started on line %lu"),
			    string_start_line);
	else if (YYSTATE == HEREDOC)
		parse_error(_("Unexpected end of file in multiline string started on line %lu"),
			    string_start_line);

	grad_write_history_file();
	return 1;
}

int
open_input(char *name)
{
	FILE *fp;

	string_buf = grad_strbuf_create();
	if (name && strcmp(name, "-")) {
		source_locus.file = name;
		fp = fopen(name, "r");
		if (!fp) {
			grad_log(GRAD_LOG_ERR|GRAD_LOG_PERROR,
				 _("can't open input file `%s'"), name);
			return 1;
		}
	} else {
		source_locus.file = "<teletype>";
		fp = stdin;
	}

	interactive = isatty(fileno(fp));
	grad_readline_init("radtest", interactive, radtest_command_completion);
	if (interactive)
		grad_readline_set_input(fp);
	grad_read_history_file();

	source_locus.line = 1;
#ifdef FLEX_SCANNER
	yyrestart(fp);
#else
	yyin = fp;
#endif
	return 0;
}

void
close_input(void)
{
#ifdef FLEX_SCANNER
	yy_delete_buffer(YY_CURRENT_BUFFER);
#endif
	fclose(yyin);
	yyin = NULL;
	grad_strbuf_free(string_buf);
}

/* String processing functions */

/* Read string segment ending with a numeric escape (\0.. or \x),
   and append it to the current string object.
   Arguments:
     skip     Number of characters to skip when processing the escape:
	      0 for octal escapes, 1 -- for hex ones.
     base     Conversion base for the escape.
     text     Start of the string segment.
     leng     Length of the string segment. */
void
add_num(int skip, int base, char *text, int leng)
{
	int n;

	n = 1;
	while (leng - n > 0 && text[leng - n] != '\\')
		n++;
	add_str(text, leng - n);
	n -= skip;
	add_chr(strtol(&text[leng - n + 1], NULL, base));
}

void
begin_str(void)
{
	string_len = 0;
	binary_string = 0;
}

/* Append simple string segment to the current string object */
void
add_str(char *str, int len)
{
	grad_strbuf_grow(string_buf, str, len);
	string_len += len;
}

/* Append a single character */
void
add_chr(int c)
{
	grad_strbuf_grow_char(string_buf, c);
	string_len++;
	if (c == 0)
		binary_string++;
}

/* Finish the string being constructed. Return pointer to its beginning. */
char *
end_str(void)
{
	return grad_strbuf_finish(string_buf, 0);
}

/* Translate a second part of a C escape */
int
backspace(int c)
{
	switch (c) {
	case '\\':
		return '\\';
	case 'a':
		return '\a';
	case 'b':
		return '\b';
	case 'f':
		return '\f';
	case 'n':
		return '\n';
	case 'r':
		return '\r';
	case 't':
		return '\t';
	case 'e':
		return '\033';
	}
	return c;
}

/* External interfaces to the above functions */
void
radtest_start_string(char *str)
{
	/* FIXME: Make sure no leading garbage appears */
	add_str(str, strlen(str));
}

void
radtest_add_string(char *str)
{
	add_str(str, strlen(str));
}

char *
radtest_end_string(void)
{
	return end_str();
}

/* Free all string literals */
void
radtest_free_strings(void)
{
	grad_strbuf_clear(string_buf);
}

/* This function is called when we have to remember all collected
   string literals (e.g. for a function definition).
   Current implementation simply re-initializes string stack. A
   (possibly) better approach:
   use some start_ptr and do obstack_free(&string_stk, start_ptr) in
   radtest_free_strings(). Then it should suffice to do

   obstack_1grow(&string_stk, 0);
   start_ptr = obstack_finish(&string_stk)

   here. */

void
radtest_fix_strings(void)
{
	grad_strbuf_reset(string_buf);
}

/* "Here document" support */

/* Return 1 if `text' is an empty string */
static int
isemptystr(char *text)
{
	for (; *text && isspace (*text); text++)
		;
	return *text == 0;
}

/* Strip initial tab characters from `text' */
static char *
heredoc_strip_tabs(char *text)
{
	if (strip_tabs)
		for (; *text == '\t'; text++)
			;
	return text;
}

/* Begin processing of a "here document" construct */
static void
heredoc_begin(void)
{
	char *p = yytext + 2; /* past the << marker */

	if (*p == '-') {
		strip_tabs = 1;
		p++;
	}
	else
		strip_tabs = 0;

	if (!isspace (*p)) {
		char *endp;
		int len;

		for (endp = p; *endp; endp++)
			if (isspace (*endp))
				break;

		len = endp - p;
		heredoc_delimiter = grad_emalloc(len + 1);
		memcpy(heredoc_delimiter, p, len);
		heredoc_delimiter[len] = 0;
	} else {
		heredoc_delimiter = grad_estrdup (".");
	}
}

/* End of input.l */

