/*
  File autogenerated by gengetopt version 2.12.2
  generated with the following command:
  ../src/gengetopt --input=cmdline.ggo --no-handle-version --no-handle-help --no-handle-error 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "cmdline.h"

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error);

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->input_given = 0 ;
  args_info->func_name_given = 0 ;
  args_info->arg_struct_name_given = 0 ;
  args_info->file_name_given = 0 ;
  args_info->c_extension_given = 0 ;
  args_info->header_extension_given = 0 ;
  args_info->long_help_given = 0 ;
  args_info->unamed_opts_given = 0 ;
  args_info->no_handle_help_given = 0 ;
  args_info->no_handle_version_given = 0 ;
  args_info->no_handle_error_given = 0 ;
  args_info->gen_version_given = 0 ;
  args_info->conf_parser_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  args_info->input_arg = NULL;
  args_info->func_name_arg = gengetopt_strdup ("cmdline_parser");
  args_info->arg_struct_name_arg = gengetopt_strdup ("gengetopt_args_info");
  args_info->file_name_arg = gengetopt_strdup ("cmdline");
  args_info->c_extension_arg = gengetopt_strdup ("c");
  args_info->header_extension_arg = gengetopt_strdup ("h");
  args_info->unamed_opts_arg = gengetopt_strdup ("FILES");
  args_info->gen_version_flag = 1;
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
  "Purpose:\n"
"  This program generates a C function that uses getopt_long function\n  to parse the command line options, validate them and fill a struct.\n"
  "\n"
  "Usage: %s [OPTIONS]...\n", CMDLINE_PARSER_PACKAGE);
  printf("\n");
  printf("%s\n","  -h, --help                  Print help and exit");
  printf("%s\n","  -V, --version               Print version and exit");
  printf("%s\n","  -i, --input=filename        input file (default std input)");
  printf("%s\n","  -f, --func-name=name        name of generated function  \n                                (default=`cmdline_parser')");
  printf("%s\n","      --arg-struct-name=name  name of generated args info struct  \n                                (default=`gengetopt_args_info')");
  printf("%s\n","  -F, --file-name=name        name of generated file  (default=`cmdline')");
  printf("%s\n","      --c-extension=ext       extension of c file  (default=`c')");
  printf("%s\n","      --header-extension=ext  extension of header file  (default=`h')");
  printf("%s\n","  -l, --long-help             long usage line in help");
  printf("%s\n","  -u, --unamed-opts[=STRING]  accept options without names (e.g., file names)  \n                                (default=`FILES')");
  printf("%s\n","      --no-handle-help        do not handle --help|-h automatically");
  printf("%s\n","      --no-handle-version     do not handle --version|-V automatically");
  printf("%s\n","      --no-handle-error       do not exit on errors");
  printf("%s\n","      --gen-version           put gengetopt version in the generated file  \n                                (default=on)");
  printf("%s\n","      --conf-parser           generate a config file parser");
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  
  if (args_info->input_arg)
    {
      free (args_info->input_arg); /* free previous argument */
      args_info->input_arg = 0;
    }
  if (args_info->func_name_arg)
    {
      free (args_info->func_name_arg); /* free previous argument */
      args_info->func_name_arg = 0;
    }
  if (args_info->arg_struct_name_arg)
    {
      free (args_info->arg_struct_name_arg); /* free previous argument */
      args_info->arg_struct_name_arg = 0;
    }
  if (args_info->file_name_arg)
    {
      free (args_info->file_name_arg); /* free previous argument */
      args_info->file_name_arg = 0;
    }
  if (args_info->c_extension_arg)
    {
      free (args_info->c_extension_arg); /* free previous argument */
      args_info->c_extension_arg = 0;
    }
  if (args_info->header_extension_arg)
    {
      free (args_info->header_extension_arg); /* free previous argument */
      args_info->header_extension_arg = 0;
    }
  if (args_info->unamed_opts_arg)
    {
      free (args_info->unamed_opts_arg); /* free previous argument */
      args_info->unamed_opts_arg = 0;
    }
  
  clear_given (args_info);
}

/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;

  result = cmdline_parser_internal (argc, argv, args_info, override, initialize, check_required, NULL);

  return result;
}

int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "input",	1, NULL, 'i' },
        { "func-name",	1, NULL, 'f' },
        { "arg-struct-name",	1, NULL, 0 },
        { "file-name",	1, NULL, 'F' },
        { "c-extension",	1, NULL, 0 },
        { "header-extension",	1, NULL, 0 },
        { "long-help",	0, NULL, 'l' },
        { "unamed-opts",	2, NULL, 'u' },
        { "no-handle-help",	0, NULL, 0 },
        { "no-handle-version",	0, NULL, 0 },
        { "no-handle-error",	0, NULL, 0 },
        { "gen-version",	0, NULL, 0 },
        { "conf-parser",	0, NULL, 0 },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVi:f:F:lu::", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          if (local_args_info.help_given)
            {
              fprintf (stderr, "%s: `--help' (`-h') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->help_given && ! override)
            continue;
          local_args_info.help_given = 1;
          args_info->help_given = 1;
          return 0;

        case 'V':	/* Print version and exit.  */
          if (local_args_info.version_given)
            {
              fprintf (stderr, "%s: `--version' (`-V') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->version_given && ! override)
            continue;
          local_args_info.version_given = 1;
          args_info->version_given = 1;
          return 0;

        case 'i':	/* input file (default std input).  */
          if (local_args_info.input_given)
            {
              fprintf (stderr, "%s: `--input' (`-i') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->input_given && ! override)
            continue;
          local_args_info.input_given = 1;
          args_info->input_given = 1;
          if (args_info->input_arg)
            free (args_info->input_arg); /* free previous string */
          args_info->input_arg = gengetopt_strdup (optarg);
          break;

        case 'f':	/* name of generated function.  */
          if (local_args_info.func_name_given)
            {
              fprintf (stderr, "%s: `--func-name' (`-f') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->func_name_given && ! override)
            continue;
          local_args_info.func_name_given = 1;
          args_info->func_name_given = 1;
          if (args_info->func_name_arg)
            free (args_info->func_name_arg); /* free previous string */
          args_info->func_name_arg = gengetopt_strdup (optarg);
          break;

        case 'F':	/* name of generated file.  */
          if (local_args_info.file_name_given)
            {
              fprintf (stderr, "%s: `--file-name' (`-F') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->file_name_given && ! override)
            continue;
          local_args_info.file_name_given = 1;
          args_info->file_name_given = 1;
          if (args_info->file_name_arg)
            free (args_info->file_name_arg); /* free previous string */
          args_info->file_name_arg = gengetopt_strdup (optarg);
          break;

        case 'l':	/* long usage line in help.  */
          if (local_args_info.long_help_given)
            {
              fprintf (stderr, "%s: `--long-help' (`-l') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->long_help_given && ! override)
            continue;
          local_args_info.long_help_given = 1;
          args_info->long_help_given = 1;
          break;

        case 'u':	/* accept options without names (e.g., file names).  */
          if (local_args_info.unamed_opts_given)
            {
              fprintf (stderr, "%s: `--unamed-opts' (`-u') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->unamed_opts_given && ! override)
            continue;
          local_args_info.unamed_opts_given = 1;
          args_info->unamed_opts_given = 1;
          if (optarg)
            {
              if (args_info->unamed_opts_arg)
                free (args_info->unamed_opts_arg); /* free previous string */
              args_info->unamed_opts_arg = gengetopt_strdup (optarg);
            }
          break;


        case 0:	/* Long option with no short option */
          /* name of generated args info struct.  */
          if (strcmp (long_options[option_index].name, "arg-struct-name") == 0)
          {
            if (local_args_info.arg_struct_name_given)
              {
                fprintf (stderr, "%s: `--arg-struct-name' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->arg_struct_name_given && ! override)
              continue;
            local_args_info.arg_struct_name_given = 1;
            args_info->arg_struct_name_given = 1;
            if (args_info->arg_struct_name_arg)
              free (args_info->arg_struct_name_arg); /* free previous string */
            args_info->arg_struct_name_arg = gengetopt_strdup (optarg);
          }
          
          /* extension of c file.  */
          else if (strcmp (long_options[option_index].name, "c-extension") == 0)
          {
            if (local_args_info.c_extension_given)
              {
                fprintf (stderr, "%s: `--c-extension' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->c_extension_given && ! override)
              continue;
            local_args_info.c_extension_given = 1;
            args_info->c_extension_given = 1;
            if (args_info->c_extension_arg)
              free (args_info->c_extension_arg); /* free previous string */
            args_info->c_extension_arg = gengetopt_strdup (optarg);
          }
          
          /* extension of header file.  */
          else if (strcmp (long_options[option_index].name, "header-extension") == 0)
          {
            if (local_args_info.header_extension_given)
              {
                fprintf (stderr, "%s: `--header-extension' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->header_extension_given && ! override)
              continue;
            local_args_info.header_extension_given = 1;
            args_info->header_extension_given = 1;
            if (args_info->header_extension_arg)
              free (args_info->header_extension_arg); /* free previous string */
            args_info->header_extension_arg = gengetopt_strdup (optarg);
          }
          
          /* do not handle --help|-h automatically.  */
          else if (strcmp (long_options[option_index].name, "no-handle-help") == 0)
          {
            if (local_args_info.no_handle_help_given)
              {
                fprintf (stderr, "%s: `--no-handle-help' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->no_handle_help_given && ! override)
              continue;
            local_args_info.no_handle_help_given = 1;
            args_info->no_handle_help_given = 1;
            break;
          }
          
          /* do not handle --version|-V automatically.  */
          else if (strcmp (long_options[option_index].name, "no-handle-version") == 0)
          {
            if (local_args_info.no_handle_version_given)
              {
                fprintf (stderr, "%s: `--no-handle-version' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->no_handle_version_given && ! override)
              continue;
            local_args_info.no_handle_version_given = 1;
            args_info->no_handle_version_given = 1;
            break;
          }
          
          /* do not exit on errors.  */
          else if (strcmp (long_options[option_index].name, "no-handle-error") == 0)
          {
            if (local_args_info.no_handle_error_given)
              {
                fprintf (stderr, "%s: `--no-handle-error' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->no_handle_error_given && ! override)
              continue;
            local_args_info.no_handle_error_given = 1;
            args_info->no_handle_error_given = 1;
            break;
          }
          
          /* put gengetopt version in the generated file.  */
          else if (strcmp (long_options[option_index].name, "gen-version") == 0)
          {
            if (local_args_info.gen_version_given)
              {
                fprintf (stderr, "%s: `--gen-version' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->gen_version_given && ! override)
              continue;
            local_args_info.gen_version_given = 1;
            args_info->gen_version_given = 1;
            args_info->gen_version_flag = !(args_info->gen_version_flag);
          }
          
          /* generate a config file parser.  */
          else if (strcmp (long_options[option_index].name, "conf-parser") == 0)
          {
            if (local_args_info.conf_parser_given)
              {
                fprintf (stderr, "%s: `--conf-parser' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->conf_parser_given && ! override)
              continue;
            local_args_info.conf_parser_given = 1;
            args_info->conf_parser_given = 1;
            break;
          }
          

          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



  if (check_required)
    {
    }

  if ( error )
    return (EXIT_FAILURE);

  return 0;

failure:
  return (EXIT_FAILURE);
}
