
;;; toggle-begin-end-function.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: toggle-begin-end-function.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: Toggles begin/end functions
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(defun toggle--add-comments ()
  (save-excursion
    (goto-char (point-min))
    (while (re-search-forward "^ *BEGIN_FUNCTION();" nil t)
      (delete-region
       (point-at-bol)
       (point-at-eol))
      (insert "//BEGIN_FUNCTION();")))

  (save-excursion
    (goto-char (point-min))
    (while (re-search-forward "^ *END_FUNCTION();" nil t)
      (delete-region
       (point-at-bol)
       (point-at-eol))
      (insert "//END_FUNCTION();"))))

(defun toggle--remove-comments ()
  (save-excursion
    (goto-char (point-min))
    (while (re-search-forward "^ *//BEGIN_FUNCTION();" nil t)
      (delete-region
       (point-at-bol)
       (point-at-eol))
      (insert "BEGIN_FUNCTION();")))
  (save-excursion
    (goto-char (point-min))
    (while (re-search-forward "^ *//END_FUNCTION();" nil t)
      (delete-region
       (point-at-bol)
       (point-at-eol))
      (insert "END_FUNCTION();"))))

(defun toggle-begin-end-function ()
  (interactive)
  (save-excursion
    (if (save-excursion
          (goto-char (point-min))
          (re-search-forward "^ *BEGIN_FUNCTION();" nil t))
        (toggle--add-comments)
      (toggle--remove-comments)))
  (indent-region (point-min) (point-max) nil)
  )

(provide 'toggle-begin-end-function)
;;; toggle-begin-end-function.el ends here
