#
# This file is part of KoreanCodecs.
#
# Copyright(C) Hye-Shik Chang <perky@FreeBSD.org>, 2002.
#
# KoreanCodecs is free software; you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published
# by the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# KoreanCodecs is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with KoreanCodecs; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# $Id: uhc.py,v 1.3 2002/07/19 00:01:53 perky Exp $
#

decoding_map = {
'\x81A': u'\uac02',
'\x81B': u'\uac03',
'\x81C': u'\uac05',
'\x81D': u'\uac06',
'\x81E': u'\uac0b',
'\x81F': u'\uac0c',
'\x81G': u'\uac0d',
'\x81H': u'\uac0e',
'\x81I': u'\uac0f',
'\x81J': u'\uac18',
'\x81K': u'\uac1e',
'\x81L': u'\uac1f',
'\x81M': u'\uac21',
'\x81N': u'\uac22',
'\x81O': u'\uac23',
'\x81P': u'\uac25',
'\x81Q': u'\uac26',
'\x81R': u'\uac27',
'\x81S': u'\uac28',
'\x81T': u'\uac29',
'\x81U': u'\uac2a',
'\x81V': u'\uac2b',
'\x81W': u'\uac2e',
'\x81X': u'\uac32',
'\x81Y': u'\uac33',
'\x81Z': u'\uac34',
'\x81\x81': u'\uac56',
'\x81\x82': u'\uac57',
'\x81\x83': u'\uac59',
'\x81\x84': u'\uac5a',
'\x81\x85': u'\uac5b',
'\x81\x86': u'\uac5d',
'\x81\x87': u'\uac5e',
'\x81\x88': u'\uac5f',
'\x81\x89': u'\uac60',
'\x81\x8a': u'\uac61',
'\x81\x8b': u'\uac62',
'\x81\x8c': u'\uac63',
'\x81\x8d': u'\uac64',
'\x81\x8e': u'\uac65',
'\x81\x8f': u'\uac66',
'\x81\x90': u'\uac67',
'\x81\x91': u'\uac68',
'\x81\x92': u'\uac69',
'\x81\x93': u'\uac6a',
'\x81\x94': u'\uac6b',
'\x81\x95': u'\uac6c',
'\x81\x96': u'\uac6d',
'\x81\x97': u'\uac6e',
'\x81\x98': u'\uac6f',
'\x81\x99': u'\uac72',
'\x81\x9a': u'\uac73',
'\x81\x9b': u'\uac75',
'\x81\x9c': u'\uac76',
'\x81\x9d': u'\uac79',
'\x81\x9e': u'\uac7b',
'\x81\x9f': u'\uac7c',
'\x81\xa0': u'\uac7d',
'\x81\xa1': u'\uac7e',
'\x81\xa2': u'\uac7f',
'\x81\xa3': u'\uac82',
'\x81\xa4': u'\uac87',
'\x81\xa5': u'\uac88',
'\x81\xa6': u'\uac8d',
'\x81\xa7': u'\uac8e',
'\x81\xa8': u'\uac8f',
'\x81\xa9': u'\uac91',
'\x81\xaa': u'\uac92',
'\x81\xab': u'\uac93',
'\x81\xac': u'\uac95',
'\x81\xad': u'\uac96',
'\x81\xae': u'\uac97',
'\x81\xaf': u'\uac98',
'\x81\xb0': u'\uac99',
'\x81\xb1': u'\uac9a',
'\x81\xb2': u'\uac9b',
'\x81\xb3': u'\uac9e',
'\x81\xb4': u'\uaca2',
'\x81\xb5': u'\uaca3',
'\x81\xb6': u'\uaca4',
'\x81\xb7': u'\uaca5',
'\x81\xb8': u'\uaca6',
'\x81\xb9': u'\uaca7',
'\x81\xba': u'\uacab',
'\x81\xbb': u'\uacad',
'\x81\xbc': u'\uacae',
'\x81\xbd': u'\uacb1',
'\x81\xbe': u'\uacb2',
'\x81\xbf': u'\uacb3',
'\x81\xc0': u'\uacb4',
'\x81\xc1': u'\uacb5',
'\x81\xc2': u'\uacb6',
'\x81\xc3': u'\uacb7',
'\x81\xc4': u'\uacba',
'\x81\xc5': u'\uacbe',
'\x81\xc6': u'\uacbf',
'\x81\xc7': u'\uacc0',
'\x81\xc8': u'\uacc2',
'\x81\xc9': u'\uacc3',
'\x81\xca': u'\uacc5',
'\x81\xcb': u'\uacc6',
'\x81\xcc': u'\uacc7',
'\x81\xcd': u'\uacc9',
'\x81\xce': u'\uacca',
'\x81\xcf': u'\uaccb',
'\x81\xd0': u'\uaccd',
'\x81\xd1': u'\uacce',
'\x81\xd2': u'\uaccf',
'\x81\xd3': u'\uacd0',
'\x81\xd4': u'\uacd1',
'\x81\xd5': u'\uacd2',
'\x81\xd6': u'\uacd3',
'\x81\xd7': u'\uacd4',
'\x81\xd8': u'\uacd6',
'\x81\xd9': u'\uacd8',
'\x81\xda': u'\uacd9',
'\x81\xdb': u'\uacda',
'\x81\xdc': u'\uacdb',
'\x81\xdd': u'\uacdc',
'\x81\xde': u'\uacdd',
'\x81\xdf': u'\uacde',
'\x81\xe0': u'\uacdf',
'\x81\xe1': u'\uace2',
'\x81\xe2': u'\uace3',
'\x81\xe3': u'\uace5',
'\x81\xe4': u'\uace6',
'\x81\xe5': u'\uace9',
'\x81\xe6': u'\uaceb',
'\x81\xe7': u'\uaced',
'\x81\xe8': u'\uacee',
'\x81\xe9': u'\uacf2',
'\x81\xea': u'\uacf4',
'\x81\xeb': u'\uacf7',
'\x81\xec': u'\uacf8',
'\x81\xed': u'\uacf9',
'\x81\xee': u'\uacfa',
'\x81\xef': u'\uacfb',
'\x81\xf0': u'\uacfe',
'\x81\xf1': u'\uacff',
'\x81\xf2': u'\uad01',
'\x81\xf3': u'\uad02',
'\x81\xf4': u'\uad03',
'\x81\xf5': u'\uad05',
'\x81\xf6': u'\uad07',
'\x81\xf7': u'\uad08',
'\x81\xf8': u'\uad09',
'\x81\xf9': u'\uad0a',
'\x81\xfa': u'\uad0b',
'\x81\xfb': u'\uad0e',
'\x81\xfc': u'\uad10',
'\x81\xfd': u'\uad12',
'\x81\xfe': u'\uad13',
'\x81a': u'\uac35',
'\x81b': u'\uac36',
'\x81c': u'\uac37',
'\x81d': u'\uac3a',
'\x81e': u'\uac3b',
'\x81f': u'\uac3d',
'\x81g': u'\uac3e',
'\x81h': u'\uac3f',
'\x81i': u'\uac41',
'\x81j': u'\uac42',
'\x81k': u'\uac43',
'\x81l': u'\uac44',
'\x81m': u'\uac45',
'\x81n': u'\uac46',
'\x81o': u'\uac47',
'\x81p': u'\uac48',
'\x81q': u'\uac49',
'\x81r': u'\uac4a',
'\x81s': u'\uac4c',
'\x81t': u'\uac4e',
'\x81u': u'\uac4f',
'\x81v': u'\uac50',
'\x81w': u'\uac51',
'\x81x': u'\uac52',
'\x81y': u'\uac53',
'\x81z': u'\uac55',
'\x82A': u'\uad14',
'\x82B': u'\uad15',
'\x82C': u'\uad16',
'\x82D': u'\uad17',
'\x82E': u'\uad19',
'\x82F': u'\uad1a',
'\x82G': u'\uad1b',
'\x82H': u'\uad1d',
'\x82I': u'\uad1e',
'\x82J': u'\uad1f',
'\x82K': u'\uad21',
'\x82L': u'\uad22',
'\x82M': u'\uad23',
'\x82N': u'\uad24',
'\x82O': u'\uad25',
'\x82P': u'\uad26',
'\x82Q': u'\uad27',
'\x82R': u'\uad28',
'\x82S': u'\uad2a',
'\x82T': u'\uad2b',
'\x82U': u'\uad2e',
'\x82V': u'\uad2f',
'\x82W': u'\uad30',
'\x82X': u'\uad31',
'\x82Y': u'\uad32',
'\x82Z': u'\uad33',
'\x82\x81': u'\uad59',
'\x82\x82': u'\uad5a',
'\x82\x83': u'\uad5b',
'\x82\x84': u'\uad5c',
'\x82\x85': u'\uad5d',
'\x82\x86': u'\uad5e',
'\x82\x87': u'\uad5f',
'\x82\x88': u'\uad60',
'\x82\x89': u'\uad62',
'\x82\x8a': u'\uad64',
'\x82\x8b': u'\uad65',
'\x82\x8c': u'\uad66',
'\x82\x8d': u'\uad67',
'\x82\x8e': u'\uad68',
'\x82\x8f': u'\uad69',
'\x82\x90': u'\uad6a',
'\x82\x91': u'\uad6b',
'\x82\x92': u'\uad6e',
'\x82\x93': u'\uad6f',
'\x82\x94': u'\uad71',
'\x82\x95': u'\uad72',
'\x82\x96': u'\uad77',
'\x82\x97': u'\uad78',
'\x82\x98': u'\uad79',
'\x82\x99': u'\uad7a',
'\x82\x9a': u'\uad7e',
'\x82\x9b': u'\uad80',
'\x82\x9c': u'\uad83',
'\x82\x9d': u'\uad84',
'\x82\x9e': u'\uad85',
'\x82\x9f': u'\uad86',
'\x82\xa0': u'\uad87',
'\x82\xa1': u'\uad8a',
'\x82\xa2': u'\uad8b',
'\x82\xa3': u'\uad8d',
'\x82\xa4': u'\uad8e',
'\x82\xa5': u'\uad8f',
'\x82\xa6': u'\uad91',
'\x82\xa7': u'\uad92',
'\x82\xa8': u'\uad93',
'\x82\xa9': u'\uad94',
'\x82\xaa': u'\uad95',
'\x82\xab': u'\uad96',
'\x82\xac': u'\uad97',
'\x82\xad': u'\uad98',
'\x82\xae': u'\uad99',
'\x82\xaf': u'\uad9a',
'\x82\xb0': u'\uad9b',
'\x82\xb1': u'\uad9e',
'\x82\xb2': u'\uad9f',
'\x82\xb3': u'\uada0',
'\x82\xb4': u'\uada1',
'\x82\xb5': u'\uada2',
'\x82\xb6': u'\uada3',
'\x82\xb7': u'\uada5',
'\x82\xb8': u'\uada6',
'\x82\xb9': u'\uada7',
'\x82\xba': u'\uada8',
'\x82\xbb': u'\uada9',
'\x82\xbc': u'\uadaa',
'\x82\xbd': u'\uadab',
'\x82\xbe': u'\uadac',
'\x82\xbf': u'\uadad',
'\x82\xc0': u'\uadae',
'\x82\xc1': u'\uadaf',
'\x82\xc2': u'\uadb0',
'\x82\xc3': u'\uadb1',
'\x82\xc4': u'\uadb2',
'\x82\xc5': u'\uadb3',
'\x82\xc6': u'\uadb4',
'\x82\xc7': u'\uadb5',
'\x82\xc8': u'\uadb6',
'\x82\xc9': u'\uadb8',
'\x82\xca': u'\uadb9',
'\x82\xcb': u'\uadba',
'\x82\xcc': u'\uadbb',
'\x82\xcd': u'\uadbc',
'\x82\xce': u'\uadbd',
'\x82\xcf': u'\uadbe',
'\x82\xd0': u'\uadbf',
'\x82\xd1': u'\uadc2',
'\x82\xd2': u'\uadc3',
'\x82\xd3': u'\uadc5',
'\x82\xd4': u'\uadc6',
'\x82\xd5': u'\uadc7',
'\x82\xd6': u'\uadc9',
'\x82\xd7': u'\uadca',
'\x82\xd8': u'\uadcb',
'\x82\xd9': u'\uadcc',
'\x82\xda': u'\uadcd',
'\x82\xdb': u'\uadce',
'\x82\xdc': u'\uadcf',
'\x82\xdd': u'\uadd2',
'\x82\xde': u'\uadd4',
'\x82\xdf': u'\uadd5',
'\x82\xe0': u'\uadd6',
'\x82\xe1': u'\uadd7',
'\x82\xe2': u'\uadd8',
'\x82\xe3': u'\uadd9',
'\x82\xe4': u'\uadda',
'\x82\xe5': u'\uaddb',
'\x82\xe6': u'\uaddd',
'\x82\xe7': u'\uadde',
'\x82\xe8': u'\uaddf',
'\x82\xe9': u'\uade1',
'\x82\xea': u'\uade2',
'\x82\xeb': u'\uade3',
'\x82\xec': u'\uade5',
'\x82\xed': u'\uade6',
'\x82\xee': u'\uade7',
'\x82\xef': u'\uade8',
'\x82\xf0': u'\uade9',
'\x82\xf1': u'\uadea',
'\x82\xf2': u'\uadeb',
'\x82\xf3': u'\uadec',
'\x82\xf4': u'\uaded',
'\x82\xf5': u'\uadee',
'\x82\xf6': u'\uadef',
'\x82\xf7': u'\uadf0',
'\x82\xf8': u'\uadf1',
'\x82\xf9': u'\uadf2',
'\x82\xfa': u'\uadf3',
'\x82\xfb': u'\uadf4',
'\x82\xfc': u'\uadf5',
'\x82\xfd': u'\uadf6',
'\x82\xfe': u'\uadf7',
'\x82a': u'\uad36',
'\x82b': u'\uad37',
'\x82c': u'\uad39',
'\x82d': u'\uad3a',
'\x82e': u'\uad3b',
'\x82f': u'\uad3d',
'\x82g': u'\uad3e',
'\x82h': u'\uad3f',
'\x82i': u'\uad40',
'\x82j': u'\uad41',
'\x82k': u'\uad42',
'\x82l': u'\uad43',
'\x82m': u'\uad46',
'\x82n': u'\uad48',
'\x82o': u'\uad4a',
'\x82p': u'\uad4b',
'\x82q': u'\uad4c',
'\x82r': u'\uad4d',
'\x82s': u'\uad4e',
'\x82t': u'\uad4f',
'\x82u': u'\uad51',
'\x82v': u'\uad52',
'\x82w': u'\uad53',
'\x82x': u'\uad55',
'\x82y': u'\uad56',
'\x82z': u'\uad57',
'\x83A': u'\uadfa',
'\x83B': u'\uadfb',
'\x83C': u'\uadfd',
'\x83D': u'\uadfe',
'\x83E': u'\uae02',
'\x83F': u'\uae03',
'\x83G': u'\uae04',
'\x83H': u'\uae05',
'\x83I': u'\uae06',
'\x83J': u'\uae07',
'\x83K': u'\uae0a',
'\x83L': u'\uae0c',
'\x83M': u'\uae0e',
'\x83N': u'\uae0f',
'\x83O': u'\uae10',
'\x83P': u'\uae11',
'\x83Q': u'\uae12',
'\x83R': u'\uae13',
'\x83S': u'\uae15',
'\x83T': u'\uae16',
'\x83U': u'\uae17',
'\x83V': u'\uae18',
'\x83W': u'\uae19',
'\x83X': u'\uae1a',
'\x83Y': u'\uae1b',
'\x83Z': u'\uae1c',
'\x83\x81': u'\uae3d',
'\x83\x82': u'\uae3e',
'\x83\x83': u'\uae3f',
'\x83\x84': u'\uae42',
'\x83\x85': u'\uae44',
'\x83\x86': u'\uae47',
'\x83\x87': u'\uae48',
'\x83\x88': u'\uae49',
'\x83\x89': u'\uae4b',
'\x83\x8a': u'\uae4f',
'\x83\x8b': u'\uae51',
'\x83\x8c': u'\uae52',
'\x83\x8d': u'\uae53',
'\x83\x8e': u'\uae55',
'\x83\x8f': u'\uae57',
'\x83\x90': u'\uae58',
'\x83\x91': u'\uae59',
'\x83\x92': u'\uae5a',
'\x83\x93': u'\uae5b',
'\x83\x94': u'\uae5e',
'\x83\x95': u'\uae62',
'\x83\x96': u'\uae63',
'\x83\x97': u'\uae64',
'\x83\x98': u'\uae66',
'\x83\x99': u'\uae67',
'\x83\x9a': u'\uae6a',
'\x83\x9b': u'\uae6b',
'\x83\x9c': u'\uae6d',
'\x83\x9d': u'\uae6e',
'\x83\x9e': u'\uae6f',
'\x83\x9f': u'\uae71',
'\x83\xa0': u'\uae72',
'\x83\xa1': u'\uae73',
'\x83\xa2': u'\uae74',
'\x83\xa3': u'\uae75',
'\x83\xa4': u'\uae76',
'\x83\xa5': u'\uae77',
'\x83\xa6': u'\uae7a',
'\x83\xa7': u'\uae7e',
'\x83\xa8': u'\uae7f',
'\x83\xa9': u'\uae80',
'\x83\xaa': u'\uae81',
'\x83\xab': u'\uae82',
'\x83\xac': u'\uae83',
'\x83\xad': u'\uae86',
'\x83\xae': u'\uae87',
'\x83\xaf': u'\uae88',
'\x83\xb0': u'\uae89',
'\x83\xb1': u'\uae8a',
'\x83\xb2': u'\uae8b',
'\x83\xb3': u'\uae8d',
'\x83\xb4': u'\uae8e',
'\x83\xb5': u'\uae8f',
'\x83\xb6': u'\uae90',
'\x83\xb7': u'\uae91',
'\x83\xb8': u'\uae92',
'\x83\xb9': u'\uae93',
'\x83\xba': u'\uae94',
'\x83\xbb': u'\uae95',
'\x83\xbc': u'\uae96',
'\x83\xbd': u'\uae97',
'\x83\xbe': u'\uae98',
'\x83\xbf': u'\uae99',
'\x83\xc0': u'\uae9a',
'\x83\xc1': u'\uae9b',
'\x83\xc2': u'\uae9c',
'\x83\xc3': u'\uae9d',
'\x83\xc4': u'\uae9e',
'\x83\xc5': u'\uae9f',
'\x83\xc6': u'\uaea0',
'\x83\xc7': u'\uaea1',
'\x83\xc8': u'\uaea2',
'\x83\xc9': u'\uaea3',
'\x83\xca': u'\uaea4',
'\x83\xcb': u'\uaea5',
'\x83\xcc': u'\uaea6',
'\x83\xcd': u'\uaea7',
'\x83\xce': u'\uaea8',
'\x83\xcf': u'\uaea9',
'\x83\xd0': u'\uaeaa',
'\x83\xd1': u'\uaeab',
'\x83\xd2': u'\uaeac',
'\x83\xd3': u'\uaead',
'\x83\xd4': u'\uaeae',
'\x83\xd5': u'\uaeaf',
'\x83\xd6': u'\uaeb0',
'\x83\xd7': u'\uaeb1',
'\x83\xd8': u'\uaeb2',
'\x83\xd9': u'\uaeb3',
'\x83\xda': u'\uaeb4',
'\x83\xdb': u'\uaeb5',
'\x83\xdc': u'\uaeb6',
'\x83\xdd': u'\uaeb7',
'\x83\xde': u'\uaeb8',
'\x83\xdf': u'\uaeb9',
'\x83\xe0': u'\uaeba',
'\x83\xe1': u'\uaebb',
'\x83\xe2': u'\uaebf',
'\x83\xe3': u'\uaec1',
'\x83\xe4': u'\uaec2',
'\x83\xe5': u'\uaec3',
'\x83\xe6': u'\uaec5',
'\x83\xe7': u'\uaec6',
'\x83\xe8': u'\uaec7',
'\x83\xe9': u'\uaec8',
'\x83\xea': u'\uaec9',
'\x83\xeb': u'\uaeca',
'\x83\xec': u'\uaecb',
'\x83\xed': u'\uaece',
'\x83\xee': u'\uaed2',
'\x83\xef': u'\uaed3',
'\x83\xf0': u'\uaed4',
'\x83\xf1': u'\uaed5',
'\x83\xf2': u'\uaed6',
'\x83\xf3': u'\uaed7',
'\x83\xf4': u'\uaeda',
'\x83\xf5': u'\uaedb',
'\x83\xf6': u'\uaedd',
'\x83\xf7': u'\uaede',
'\x83\xf8': u'\uaedf',
'\x83\xf9': u'\uaee0',
'\x83\xfa': u'\uaee1',
'\x83\xfb': u'\uaee2',
'\x83\xfc': u'\uaee3',
'\x83\xfd': u'\uaee4',
'\x83\xfe': u'\uaee5',
'\x83a': u'\uae1d',
'\x83b': u'\uae1e',
'\x83c': u'\uae1f',
'\x83d': u'\uae20',
'\x83e': u'\uae21',
'\x83f': u'\uae22',
'\x83g': u'\uae23',
'\x83h': u'\uae24',
'\x83i': u'\uae25',
'\x83j': u'\uae26',
'\x83k': u'\uae27',
'\x83l': u'\uae28',
'\x83m': u'\uae29',
'\x83n': u'\uae2a',
'\x83o': u'\uae2b',
'\x83p': u'\uae2c',
'\x83q': u'\uae2d',
'\x83r': u'\uae2e',
'\x83s': u'\uae2f',
'\x83t': u'\uae32',
'\x83u': u'\uae33',
'\x83v': u'\uae35',
'\x83w': u'\uae36',
'\x83x': u'\uae39',
'\x83y': u'\uae3b',
'\x83z': u'\uae3c',
'\x84A': u'\uaee6',
'\x84B': u'\uaee7',
'\x84C': u'\uaee9',
'\x84D': u'\uaeea',
'\x84E': u'\uaeec',
'\x84F': u'\uaeee',
'\x84G': u'\uaeef',
'\x84H': u'\uaef0',
'\x84I': u'\uaef1',
'\x84J': u'\uaef2',
'\x84K': u'\uaef3',
'\x84L': u'\uaef5',
'\x84M': u'\uaef6',
'\x84N': u'\uaef7',
'\x84O': u'\uaef9',
'\x84P': u'\uaefa',
'\x84Q': u'\uaefb',
'\x84R': u'\uaefd',
'\x84S': u'\uaefe',
'\x84T': u'\uaeff',
'\x84U': u'\uaf00',
'\x84V': u'\uaf01',
'\x84W': u'\uaf02',
'\x84X': u'\uaf03',
'\x84Y': u'\uaf04',
'\x84Z': u'\uaf05',
'\x84\x81': u'\uaf24',
'\x84\x82': u'\uaf25',
'\x84\x83': u'\uaf26',
'\x84\x84': u'\uaf27',
'\x84\x85': u'\uaf28',
'\x84\x86': u'\uaf29',
'\x84\x87': u'\uaf2a',
'\x84\x88': u'\uaf2b',
'\x84\x89': u'\uaf2e',
'\x84\x8a': u'\uaf2f',
'\x84\x8b': u'\uaf31',
'\x84\x8c': u'\uaf33',
'\x84\x8d': u'\uaf35',
'\x84\x8e': u'\uaf36',
'\x84\x8f': u'\uaf37',
'\x84\x90': u'\uaf38',
'\x84\x91': u'\uaf39',
'\x84\x92': u'\uaf3a',
'\x84\x93': u'\uaf3b',
'\x84\x94': u'\uaf3e',
'\x84\x95': u'\uaf40',
'\x84\x96': u'\uaf44',
'\x84\x97': u'\uaf45',
'\x84\x98': u'\uaf46',
'\x84\x99': u'\uaf47',
'\x84\x9a': u'\uaf4a',
'\x84\x9b': u'\uaf4b',
'\x84\x9c': u'\uaf4c',
'\x84\x9d': u'\uaf4d',
'\x84\x9e': u'\uaf4e',
'\x84\x9f': u'\uaf4f',
'\x84\xa0': u'\uaf51',
'\x84\xa1': u'\uaf52',
'\x84\xa2': u'\uaf53',
'\x84\xa3': u'\uaf54',
'\x84\xa4': u'\uaf55',
'\x84\xa5': u'\uaf56',
'\x84\xa6': u'\uaf57',
'\x84\xa7': u'\uaf58',
'\x84\xa8': u'\uaf59',
'\x84\xa9': u'\uaf5a',
'\x84\xaa': u'\uaf5b',
'\x84\xab': u'\uaf5e',
'\x84\xac': u'\uaf5f',
'\x84\xad': u'\uaf60',
'\x84\xae': u'\uaf61',
'\x84\xaf': u'\uaf62',
'\x84\xb0': u'\uaf63',
'\x84\xb1': u'\uaf66',
'\x84\xb2': u'\uaf67',
'\x84\xb3': u'\uaf68',
'\x84\xb4': u'\uaf69',
'\x84\xb5': u'\uaf6a',
'\x84\xb6': u'\uaf6b',
'\x84\xb7': u'\uaf6c',
'\x84\xb8': u'\uaf6d',
'\x84\xb9': u'\uaf6e',
'\x84\xba': u'\uaf6f',
'\x84\xbb': u'\uaf70',
'\x84\xbc': u'\uaf71',
'\x84\xbd': u'\uaf72',
'\x84\xbe': u'\uaf73',
'\x84\xbf': u'\uaf74',
'\x84\xc0': u'\uaf75',
'\x84\xc1': u'\uaf76',
'\x84\xc2': u'\uaf77',
'\x84\xc3': u'\uaf78',
'\x84\xc4': u'\uaf7a',
'\x84\xc5': u'\uaf7b',
'\x84\xc6': u'\uaf7c',
'\x84\xc7': u'\uaf7d',
'\x84\xc8': u'\uaf7e',
'\x84\xc9': u'\uaf7f',
'\x84\xca': u'\uaf81',
'\x84\xcb': u'\uaf82',
'\x84\xcc': u'\uaf83',
'\x84\xcd': u'\uaf85',
'\x84\xce': u'\uaf86',
'\x84\xcf': u'\uaf87',
'\x84\xd0': u'\uaf89',
'\x84\xd1': u'\uaf8a',
'\x84\xd2': u'\uaf8b',
'\x84\xd3': u'\uaf8c',
'\x84\xd4': u'\uaf8d',
'\x84\xd5': u'\uaf8e',
'\x84\xd6': u'\uaf8f',
'\x84\xd7': u'\uaf92',
'\x84\xd8': u'\uaf93',
'\x84\xd9': u'\uaf94',
'\x84\xda': u'\uaf96',
'\x84\xdb': u'\uaf97',
'\x84\xdc': u'\uaf98',
'\x84\xdd': u'\uaf99',
'\x84\xde': u'\uaf9a',
'\x84\xdf': u'\uaf9b',
'\x84\xe0': u'\uaf9d',
'\x84\xe1': u'\uaf9e',
'\x84\xe2': u'\uaf9f',
'\x84\xe3': u'\uafa0',
'\x84\xe4': u'\uafa1',
'\x84\xe5': u'\uafa2',
'\x84\xe6': u'\uafa3',
'\x84\xe7': u'\uafa4',
'\x84\xe8': u'\uafa5',
'\x84\xe9': u'\uafa6',
'\x84\xea': u'\uafa7',
'\x84\xeb': u'\uafa8',
'\x84\xec': u'\uafa9',
'\x84\xed': u'\uafaa',
'\x84\xee': u'\uafab',
'\x84\xef': u'\uafac',
'\x84\xf0': u'\uafad',
'\x84\xf1': u'\uafae',
'\x84\xf2': u'\uafaf',
'\x84\xf3': u'\uafb0',
'\x84\xf4': u'\uafb1',
'\x84\xf5': u'\uafb2',
'\x84\xf6': u'\uafb3',
'\x84\xf7': u'\uafb4',
'\x84\xf8': u'\uafb5',
'\x84\xf9': u'\uafb6',
'\x84\xfa': u'\uafb7',
'\x84\xfb': u'\uafba',
'\x84\xfc': u'\uafbb',
'\x84\xfd': u'\uafbd',
'\x84\xfe': u'\uafbe',
'\x84a': u'\uaf06',
'\x84b': u'\uaf09',
'\x84c': u'\uaf0a',
'\x84d': u'\uaf0b',
'\x84e': u'\uaf0c',
'\x84f': u'\uaf0e',
'\x84g': u'\uaf0f',
'\x84h': u'\uaf11',
'\x84i': u'\uaf12',
'\x84j': u'\uaf13',
'\x84k': u'\uaf14',
'\x84l': u'\uaf15',
'\x84m': u'\uaf16',
'\x84n': u'\uaf17',
'\x84o': u'\uaf18',
'\x84p': u'\uaf19',
'\x84q': u'\uaf1a',
'\x84r': u'\uaf1b',
'\x84s': u'\uaf1c',
'\x84t': u'\uaf1d',
'\x84u': u'\uaf1e',
'\x84v': u'\uaf1f',
'\x84w': u'\uaf20',
'\x84x': u'\uaf21',
'\x84y': u'\uaf22',
'\x84z': u'\uaf23',
'\x85A': u'\uafbf',
'\x85B': u'\uafc1',
'\x85C': u'\uafc2',
'\x85D': u'\uafc3',
'\x85E': u'\uafc4',
'\x85F': u'\uafc5',
'\x85G': u'\uafc6',
'\x85H': u'\uafca',
'\x85I': u'\uafcc',
'\x85J': u'\uafcf',
'\x85K': u'\uafd0',
'\x85L': u'\uafd1',
'\x85M': u'\uafd2',
'\x85N': u'\uafd3',
'\x85O': u'\uafd5',
'\x85P': u'\uafd6',
'\x85Q': u'\uafd7',
'\x85R': u'\uafd8',
'\x85S': u'\uafd9',
'\x85T': u'\uafda',
'\x85U': u'\uafdb',
'\x85V': u'\uafdd',
'\x85W': u'\uafde',
'\x85X': u'\uafdf',
'\x85Y': u'\uafe0',
'\x85Z': u'\uafe1',
'\x85\x81': u'\ub005',
'\x85\x82': u'\ub006',
'\x85\x83': u'\ub007',
'\x85\x84': u'\ub008',
'\x85\x85': u'\ub009',
'\x85\x86': u'\ub00a',
'\x85\x87': u'\ub00b',
'\x85\x88': u'\ub00d',
'\x85\x89': u'\ub00e',
'\x85\x8a': u'\ub00f',
'\x85\x8b': u'\ub011',
'\x85\x8c': u'\ub012',
'\x85\x8d': u'\ub013',
'\x85\x8e': u'\ub015',
'\x85\x8f': u'\ub016',
'\x85\x90': u'\ub017',
'\x85\x91': u'\ub018',
'\x85\x92': u'\ub019',
'\x85\x93': u'\ub01a',
'\x85\x94': u'\ub01b',
'\x85\x95': u'\ub01e',
'\x85\x96': u'\ub01f',
'\x85\x97': u'\ub020',
'\x85\x98': u'\ub021',
'\x85\x99': u'\ub022',
'\x85\x9a': u'\ub023',
'\x85\x9b': u'\ub024',
'\x85\x9c': u'\ub025',
'\x85\x9d': u'\ub026',
'\x85\x9e': u'\ub027',
'\x85\x9f': u'\ub029',
'\x85\xa0': u'\ub02a',
'\x85\xa1': u'\ub02b',
'\x85\xa2': u'\ub02c',
'\x85\xa3': u'\ub02d',
'\x85\xa4': u'\ub02e',
'\x85\xa5': u'\ub02f',
'\x85\xa6': u'\ub030',
'\x85\xa7': u'\ub031',
'\x85\xa8': u'\ub032',
'\x85\xa9': u'\ub033',
'\x85\xaa': u'\ub034',
'\x85\xab': u'\ub035',
'\x85\xac': u'\ub036',
'\x85\xad': u'\ub037',
'\x85\xae': u'\ub038',
'\x85\xaf': u'\ub039',
'\x85\xb0': u'\ub03a',
'\x85\xb1': u'\ub03b',
'\x85\xb2': u'\ub03c',
'\x85\xb3': u'\ub03d',
'\x85\xb4': u'\ub03e',
'\x85\xb5': u'\ub03f',
'\x85\xb6': u'\ub040',
'\x85\xb7': u'\ub041',
'\x85\xb8': u'\ub042',
'\x85\xb9': u'\ub043',
'\x85\xba': u'\ub046',
'\x85\xbb': u'\ub047',
'\x85\xbc': u'\ub049',
'\x85\xbd': u'\ub04b',
'\x85\xbe': u'\ub04d',
'\x85\xbf': u'\ub04f',
'\x85\xc0': u'\ub050',
'\x85\xc1': u'\ub051',
'\x85\xc2': u'\ub052',
'\x85\xc3': u'\ub056',
'\x85\xc4': u'\ub058',
'\x85\xc5': u'\ub05a',
'\x85\xc6': u'\ub05b',
'\x85\xc7': u'\ub05c',
'\x85\xc8': u'\ub05e',
'\x85\xc9': u'\ub05f',
'\x85\xca': u'\ub060',
'\x85\xcb': u'\ub061',
'\x85\xcc': u'\ub062',
'\x85\xcd': u'\ub063',
'\x85\xce': u'\ub064',
'\x85\xcf': u'\ub065',
'\x85\xd0': u'\ub066',
'\x85\xd1': u'\ub067',
'\x85\xd2': u'\ub068',
'\x85\xd3': u'\ub069',
'\x85\xd4': u'\ub06a',
'\x85\xd5': u'\ub06b',
'\x85\xd6': u'\ub06c',
'\x85\xd7': u'\ub06d',
'\x85\xd8': u'\ub06e',
'\x85\xd9': u'\ub06f',
'\x85\xda': u'\ub070',
'\x85\xdb': u'\ub071',
'\x85\xdc': u'\ub072',
'\x85\xdd': u'\ub073',
'\x85\xde': u'\ub074',
'\x85\xdf': u'\ub075',
'\x85\xe0': u'\ub076',
'\x85\xe1': u'\ub077',
'\x85\xe2': u'\ub078',
'\x85\xe3': u'\ub079',
'\x85\xe4': u'\ub07a',
'\x85\xe5': u'\ub07b',
'\x85\xe6': u'\ub07e',
'\x85\xe7': u'\ub07f',
'\x85\xe8': u'\ub081',
'\x85\xe9': u'\ub082',
'\x85\xea': u'\ub083',
'\x85\xeb': u'\ub085',
'\x85\xec': u'\ub086',
'\x85\xed': u'\ub087',
'\x85\xee': u'\ub088',
'\x85\xef': u'\ub089',
'\x85\xf0': u'\ub08a',
'\x85\xf1': u'\ub08b',
'\x85\xf2': u'\ub08e',
'\x85\xf3': u'\ub090',
'\x85\xf4': u'\ub092',
'\x85\xf5': u'\ub093',
'\x85\xf6': u'\ub094',
'\x85\xf7': u'\ub095',
'\x85\xf8': u'\ub096',
'\x85\xf9': u'\ub097',
'\x85\xfa': u'\ub09b',
'\x85\xfb': u'\ub09d',
'\x85\xfc': u'\ub09e',
'\x85\xfd': u'\ub0a3',
'\x85\xfe': u'\ub0a4',
'\x85a': u'\uafe2',
'\x85b': u'\uafe3',
'\x85c': u'\uafe4',
'\x85d': u'\uafe5',
'\x85e': u'\uafe6',
'\x85f': u'\uafe7',
'\x85g': u'\uafea',
'\x85h': u'\uafeb',
'\x85i': u'\uafec',
'\x85j': u'\uafed',
'\x85k': u'\uafee',
'\x85l': u'\uafef',
'\x85m': u'\uaff2',
'\x85n': u'\uaff3',
'\x85o': u'\uaff5',
'\x85p': u'\uaff6',
'\x85q': u'\uaff7',
'\x85r': u'\uaff9',
'\x85s': u'\uaffa',
'\x85t': u'\uaffb',
'\x85u': u'\uaffc',
'\x85v': u'\uaffd',
'\x85w': u'\uaffe',
'\x85x': u'\uafff',
'\x85y': u'\ub002',
'\x85z': u'\ub003',
'\x86A': u'\ub0a5',
'\x86B': u'\ub0a6',
'\x86C': u'\ub0a7',
'\x86D': u'\ub0aa',
'\x86E': u'\ub0b0',
'\x86F': u'\ub0b2',
'\x86G': u'\ub0b6',
'\x86H': u'\ub0b7',
'\x86I': u'\ub0b9',
'\x86J': u'\ub0ba',
'\x86K': u'\ub0bb',
'\x86L': u'\ub0bd',
'\x86M': u'\ub0be',
'\x86N': u'\ub0bf',
'\x86O': u'\ub0c0',
'\x86P': u'\ub0c1',
'\x86Q': u'\ub0c2',
'\x86R': u'\ub0c3',
'\x86S': u'\ub0c6',
'\x86T': u'\ub0ca',
'\x86U': u'\ub0cb',
'\x86V': u'\ub0cc',
'\x86W': u'\ub0cd',
'\x86X': u'\ub0ce',
'\x86Y': u'\ub0cf',
'\x86Z': u'\ub0d2',
'\x86\x81': u'\ub0f1',
'\x86\x82': u'\ub0f2',
'\x86\x83': u'\ub0f3',
'\x86\x84': u'\ub0f4',
'\x86\x85': u'\ub0f5',
'\x86\x86': u'\ub0f6',
'\x86\x87': u'\ub0f7',
'\x86\x88': u'\ub0f8',
'\x86\x89': u'\ub0f9',
'\x86\x8a': u'\ub0fa',
'\x86\x8b': u'\ub0fb',
'\x86\x8c': u'\ub0fc',
'\x86\x8d': u'\ub0fd',
'\x86\x8e': u'\ub0fe',
'\x86\x8f': u'\ub0ff',
'\x86\x90': u'\ub100',
'\x86\x91': u'\ub101',
'\x86\x92': u'\ub102',
'\x86\x93': u'\ub103',
'\x86\x94': u'\ub104',
'\x86\x95': u'\ub105',
'\x86\x96': u'\ub106',
'\x86\x97': u'\ub107',
'\x86\x98': u'\ub10a',
'\x86\x99': u'\ub10d',
'\x86\x9a': u'\ub10e',
'\x86\x9b': u'\ub10f',
'\x86\x9c': u'\ub111',
'\x86\x9d': u'\ub114',
'\x86\x9e': u'\ub115',
'\x86\x9f': u'\ub116',
'\x86\xa0': u'\ub117',
'\x86\xa1': u'\ub11a',
'\x86\xa2': u'\ub11e',
'\x86\xa3': u'\ub11f',
'\x86\xa4': u'\ub120',
'\x86\xa5': u'\ub121',
'\x86\xa6': u'\ub122',
'\x86\xa7': u'\ub126',
'\x86\xa8': u'\ub127',
'\x86\xa9': u'\ub129',
'\x86\xaa': u'\ub12a',
'\x86\xab': u'\ub12b',
'\x86\xac': u'\ub12d',
'\x86\xad': u'\ub12e',
'\x86\xae': u'\ub12f',
'\x86\xaf': u'\ub130',
'\x86\xb0': u'\ub131',
'\x86\xb1': u'\ub132',
'\x86\xb2': u'\ub133',
'\x86\xb3': u'\ub136',
'\x86\xb4': u'\ub13a',
'\x86\xb5': u'\ub13b',
'\x86\xb6': u'\ub13c',
'\x86\xb7': u'\ub13d',
'\x86\xb8': u'\ub13e',
'\x86\xb9': u'\ub13f',
'\x86\xba': u'\ub142',
'\x86\xbb': u'\ub143',
'\x86\xbc': u'\ub145',
'\x86\xbd': u'\ub146',
'\x86\xbe': u'\ub147',
'\x86\xbf': u'\ub149',
'\x86\xc0': u'\ub14a',
'\x86\xc1': u'\ub14b',
'\x86\xc2': u'\ub14c',
'\x86\xc3': u'\ub14d',
'\x86\xc4': u'\ub14e',
'\x86\xc5': u'\ub14f',
'\x86\xc6': u'\ub152',
'\x86\xc7': u'\ub153',
'\x86\xc8': u'\ub156',
'\x86\xc9': u'\ub157',
'\x86\xca': u'\ub159',
'\x86\xcb': u'\ub15a',
'\x86\xcc': u'\ub15b',
'\x86\xcd': u'\ub15d',
'\x86\xce': u'\ub15e',
'\x86\xcf': u'\ub15f',
'\x86\xd0': u'\ub161',
'\x86\xd1': u'\ub162',
'\x86\xd2': u'\ub163',
'\x86\xd3': u'\ub164',
'\x86\xd4': u'\ub165',
'\x86\xd5': u'\ub166',
'\x86\xd6': u'\ub167',
'\x86\xd7': u'\ub168',
'\x86\xd8': u'\ub169',
'\x86\xd9': u'\ub16a',
'\x86\xda': u'\ub16b',
'\x86\xdb': u'\ub16c',
'\x86\xdc': u'\ub16d',
'\x86\xdd': u'\ub16e',
'\x86\xde': u'\ub16f',
'\x86\xdf': u'\ub170',
'\x86\xe0': u'\ub171',
'\x86\xe1': u'\ub172',
'\x86\xe2': u'\ub173',
'\x86\xe3': u'\ub174',
'\x86\xe4': u'\ub175',
'\x86\xe5': u'\ub176',
'\x86\xe6': u'\ub177',
'\x86\xe7': u'\ub17a',
'\x86\xe8': u'\ub17b',
'\x86\xe9': u'\ub17d',
'\x86\xea': u'\ub17e',
'\x86\xeb': u'\ub17f',
'\x86\xec': u'\ub181',
'\x86\xed': u'\ub183',
'\x86\xee': u'\ub184',
'\x86\xef': u'\ub185',
'\x86\xf0': u'\ub186',
'\x86\xf1': u'\ub187',
'\x86\xf2': u'\ub18a',
'\x86\xf3': u'\ub18c',
'\x86\xf4': u'\ub18e',
'\x86\xf5': u'\ub18f',
'\x86\xf6': u'\ub190',
'\x86\xf7': u'\ub191',
'\x86\xf8': u'\ub195',
'\x86\xf9': u'\ub196',
'\x86\xfa': u'\ub197',
'\x86\xfb': u'\ub199',
'\x86\xfc': u'\ub19a',
'\x86\xfd': u'\ub19b',
'\x86\xfe': u'\ub19d',
'\x86a': u'\ub0d3',
'\x86b': u'\ub0d5',
'\x86c': u'\ub0d6',
'\x86d': u'\ub0d7',
'\x86e': u'\ub0d9',
'\x86f': u'\ub0da',
'\x86g': u'\ub0db',
'\x86h': u'\ub0dc',
'\x86i': u'\ub0dd',
'\x86j': u'\ub0de',
'\x86k': u'\ub0df',
'\x86l': u'\ub0e1',
'\x86m': u'\ub0e2',
'\x86n': u'\ub0e3',
'\x86o': u'\ub0e4',
'\x86p': u'\ub0e6',
'\x86q': u'\ub0e7',
'\x86r': u'\ub0e8',
'\x86s': u'\ub0e9',
'\x86t': u'\ub0ea',
'\x86u': u'\ub0eb',
'\x86v': u'\ub0ec',
'\x86w': u'\ub0ed',
'\x86x': u'\ub0ee',
'\x86y': u'\ub0ef',
'\x86z': u'\ub0f0',
'\x87A': u'\ub19e',
'\x87B': u'\ub19f',
'\x87C': u'\ub1a0',
'\x87D': u'\ub1a1',
'\x87E': u'\ub1a2',
'\x87F': u'\ub1a3',
'\x87G': u'\ub1a4',
'\x87H': u'\ub1a5',
'\x87I': u'\ub1a6',
'\x87J': u'\ub1a7',
'\x87K': u'\ub1a9',
'\x87L': u'\ub1aa',
'\x87M': u'\ub1ab',
'\x87N': u'\ub1ac',
'\x87O': u'\ub1ad',
'\x87P': u'\ub1ae',
'\x87Q': u'\ub1af',
'\x87R': u'\ub1b0',
'\x87S': u'\ub1b1',
'\x87T': u'\ub1b2',
'\x87U': u'\ub1b3',
'\x87V': u'\ub1b4',
'\x87W': u'\ub1b5',
'\x87X': u'\ub1b6',
'\x87Y': u'\ub1b7',
'\x87Z': u'\ub1b8',
'\x87\x81': u'\ub1d6',
'\x87\x82': u'\ub1d7',
'\x87\x83': u'\ub1d8',
'\x87\x84': u'\ub1d9',
'\x87\x85': u'\ub1da',
'\x87\x86': u'\ub1db',
'\x87\x87': u'\ub1de',
'\x87\x88': u'\ub1e0',
'\x87\x89': u'\ub1e1',
'\x87\x8a': u'\ub1e2',
'\x87\x8b': u'\ub1e3',
'\x87\x8c': u'\ub1e4',
'\x87\x8d': u'\ub1e5',
'\x87\x8e': u'\ub1e6',
'\x87\x8f': u'\ub1e7',
'\x87\x90': u'\ub1ea',
'\x87\x91': u'\ub1eb',
'\x87\x92': u'\ub1ed',
'\x87\x93': u'\ub1ee',
'\x87\x94': u'\ub1ef',
'\x87\x95': u'\ub1f1',
'\x87\x96': u'\ub1f2',
'\x87\x97': u'\ub1f3',
'\x87\x98': u'\ub1f4',
'\x87\x99': u'\ub1f5',
'\x87\x9a': u'\ub1f6',
'\x87\x9b': u'\ub1f7',
'\x87\x9c': u'\ub1f8',
'\x87\x9d': u'\ub1fa',
'\x87\x9e': u'\ub1fc',
'\x87\x9f': u'\ub1fe',
'\x87\xa0': u'\ub1ff',
'\x87\xa1': u'\ub200',
'\x87\xa2': u'\ub201',
'\x87\xa3': u'\ub202',
'\x87\xa4': u'\ub203',
'\x87\xa5': u'\ub206',
'\x87\xa6': u'\ub207',
'\x87\xa7': u'\ub209',
'\x87\xa8': u'\ub20a',
'\x87\xa9': u'\ub20d',
'\x87\xaa': u'\ub20e',
'\x87\xab': u'\ub20f',
'\x87\xac': u'\ub210',
'\x87\xad': u'\ub211',
'\x87\xae': u'\ub212',
'\x87\xaf': u'\ub213',
'\x87\xb0': u'\ub216',
'\x87\xb1': u'\ub218',
'\x87\xb2': u'\ub21a',
'\x87\xb3': u'\ub21b',
'\x87\xb4': u'\ub21c',
'\x87\xb5': u'\ub21d',
'\x87\xb6': u'\ub21e',
'\x87\xb7': u'\ub21f',
'\x87\xb8': u'\ub221',
'\x87\xb9': u'\ub222',
'\x87\xba': u'\ub223',
'\x87\xbb': u'\ub224',
'\x87\xbc': u'\ub225',
'\x87\xbd': u'\ub226',
'\x87\xbe': u'\ub227',
'\x87\xbf': u'\ub228',
'\x87\xc0': u'\ub229',
'\x87\xc1': u'\ub22a',
'\x87\xc2': u'\ub22b',
'\x87\xc3': u'\ub22c',
'\x87\xc4': u'\ub22d',
'\x87\xc5': u'\ub22e',
'\x87\xc6': u'\ub22f',
'\x87\xc7': u'\ub230',
'\x87\xc8': u'\ub231',
'\x87\xc9': u'\ub232',
'\x87\xca': u'\ub233',
'\x87\xcb': u'\ub235',
'\x87\xcc': u'\ub236',
'\x87\xcd': u'\ub237',
'\x87\xce': u'\ub238',
'\x87\xcf': u'\ub239',
'\x87\xd0': u'\ub23a',
'\x87\xd1': u'\ub23b',
'\x87\xd2': u'\ub23d',
'\x87\xd3': u'\ub23e',
'\x87\xd4': u'\ub23f',
'\x87\xd5': u'\ub240',
'\x87\xd6': u'\ub241',
'\x87\xd7': u'\ub242',
'\x87\xd8': u'\ub243',
'\x87\xd9': u'\ub244',
'\x87\xda': u'\ub245',
'\x87\xdb': u'\ub246',
'\x87\xdc': u'\ub247',
'\x87\xdd': u'\ub248',
'\x87\xde': u'\ub249',
'\x87\xdf': u'\ub24a',
'\x87\xe0': u'\ub24b',
'\x87\xe1': u'\ub24c',
'\x87\xe2': u'\ub24d',
'\x87\xe3': u'\ub24e',
'\x87\xe4': u'\ub24f',
'\x87\xe5': u'\ub250',
'\x87\xe6': u'\ub251',
'\x87\xe7': u'\ub252',
'\x87\xe8': u'\ub253',
'\x87\xe9': u'\ub254',
'\x87\xea': u'\ub255',
'\x87\xeb': u'\ub256',
'\x87\xec': u'\ub257',
'\x87\xed': u'\ub259',
'\x87\xee': u'\ub25a',
'\x87\xef': u'\ub25b',
'\x87\xf0': u'\ub25d',
'\x87\xf1': u'\ub25e',
'\x87\xf2': u'\ub25f',
'\x87\xf3': u'\ub261',
'\x87\xf4': u'\ub262',
'\x87\xf5': u'\ub263',
'\x87\xf6': u'\ub264',
'\x87\xf7': u'\ub265',
'\x87\xf8': u'\ub266',
'\x87\xf9': u'\ub267',
'\x87\xfa': u'\ub26a',
'\x87\xfb': u'\ub26b',
'\x87\xfc': u'\ub26c',
'\x87\xfd': u'\ub26d',
'\x87\xfe': u'\ub26e',
'\x87a': u'\ub1b9',
'\x87b': u'\ub1ba',
'\x87c': u'\ub1bb',
'\x87d': u'\ub1bc',
'\x87e': u'\ub1bd',
'\x87f': u'\ub1be',
'\x87g': u'\ub1bf',
'\x87h': u'\ub1c0',
'\x87i': u'\ub1c1',
'\x87j': u'\ub1c2',
'\x87k': u'\ub1c3',
'\x87l': u'\ub1c4',
'\x87m': u'\ub1c5',
'\x87n': u'\ub1c6',
'\x87o': u'\ub1c7',
'\x87p': u'\ub1c8',
'\x87q': u'\ub1c9',
'\x87r': u'\ub1ca',
'\x87s': u'\ub1cb',
'\x87t': u'\ub1cd',
'\x87u': u'\ub1ce',
'\x87v': u'\ub1cf',
'\x87w': u'\ub1d1',
'\x87x': u'\ub1d2',
'\x87y': u'\ub1d3',
'\x87z': u'\ub1d5',
'\x88A': u'\ub26f',
'\x88B': u'\ub270',
'\x88C': u'\ub271',
'\x88D': u'\ub272',
'\x88E': u'\ub273',
'\x88F': u'\ub276',
'\x88G': u'\ub277',
'\x88H': u'\ub278',
'\x88I': u'\ub279',
'\x88J': u'\ub27a',
'\x88K': u'\ub27b',
'\x88L': u'\ub27d',
'\x88M': u'\ub27e',
'\x88N': u'\ub27f',
'\x88O': u'\ub280',
'\x88P': u'\ub281',
'\x88Q': u'\ub282',
'\x88R': u'\ub283',
'\x88S': u'\ub286',
'\x88T': u'\ub287',
'\x88U': u'\ub288',
'\x88V': u'\ub28a',
'\x88W': u'\ub28b',
'\x88X': u'\ub28c',
'\x88Y': u'\ub28d',
'\x88Z': u'\ub28e',
'\x88\x81': u'\ub2b8',
'\x88\x82': u'\ub2b9',
'\x88\x83': u'\ub2ba',
'\x88\x84': u'\ub2bb',
'\x88\x85': u'\ub2bc',
'\x88\x86': u'\ub2bd',
'\x88\x87': u'\ub2be',
'\x88\x88': u'\ub2bf',
'\x88\x89': u'\ub2c0',
'\x88\x8a': u'\ub2c1',
'\x88\x8b': u'\ub2c2',
'\x88\x8c': u'\ub2c3',
'\x88\x8d': u'\ub2c4',
'\x88\x8e': u'\ub2c5',
'\x88\x8f': u'\ub2c6',
'\x88\x90': u'\ub2c7',
'\x88\x91': u'\ub2ca',
'\x88\x92': u'\ub2cb',
'\x88\x93': u'\ub2cd',
'\x88\x94': u'\ub2ce',
'\x88\x95': u'\ub2cf',
'\x88\x96': u'\ub2d1',
'\x88\x97': u'\ub2d3',
'\x88\x98': u'\ub2d4',
'\x88\x99': u'\ub2d5',
'\x88\x9a': u'\ub2d6',
'\x88\x9b': u'\ub2d7',
'\x88\x9c': u'\ub2da',
'\x88\x9d': u'\ub2dc',
'\x88\x9e': u'\ub2de',
'\x88\x9f': u'\ub2df',
'\x88\xa0': u'\ub2e0',
'\x88\xa1': u'\ub2e1',
'\x88\xa2': u'\ub2e3',
'\x88\xa3': u'\ub2e7',
'\x88\xa4': u'\ub2e9',
'\x88\xa5': u'\ub2ea',
'\x88\xa6': u'\ub2f0',
'\x88\xa7': u'\ub2f1',
'\x88\xa8': u'\ub2f2',
'\x88\xa9': u'\ub2f6',
'\x88\xaa': u'\ub2fc',
'\x88\xab': u'\ub2fd',
'\x88\xac': u'\ub2fe',
'\x88\xad': u'\ub302',
'\x88\xae': u'\ub303',
'\x88\xaf': u'\ub305',
'\x88\xb0': u'\ub306',
'\x88\xb1': u'\ub307',
'\x88\xb2': u'\ub309',
'\x88\xb3': u'\ub30a',
'\x88\xb4': u'\ub30b',
'\x88\xb5': u'\ub30c',
'\x88\xb6': u'\ub30d',
'\x88\xb7': u'\ub30e',
'\x88\xb8': u'\ub30f',
'\x88\xb9': u'\ub312',
'\x88\xba': u'\ub316',
'\x88\xbb': u'\ub317',
'\x88\xbc': u'\ub318',
'\x88\xbd': u'\ub319',
'\x88\xbe': u'\ub31a',
'\x88\xbf': u'\ub31b',
'\x88\xc0': u'\ub31d',
'\x88\xc1': u'\ub31e',
'\x88\xc2': u'\ub31f',
'\x88\xc3': u'\ub320',
'\x88\xc4': u'\ub321',
'\x88\xc5': u'\ub322',
'\x88\xc6': u'\ub323',
'\x88\xc7': u'\ub324',
'\x88\xc8': u'\ub325',
'\x88\xc9': u'\ub326',
'\x88\xca': u'\ub327',
'\x88\xcb': u'\ub328',
'\x88\xcc': u'\ub329',
'\x88\xcd': u'\ub32a',
'\x88\xce': u'\ub32b',
'\x88\xcf': u'\ub32c',
'\x88\xd0': u'\ub32d',
'\x88\xd1': u'\ub32e',
'\x88\xd2': u'\ub32f',
'\x88\xd3': u'\ub330',
'\x88\xd4': u'\ub331',
'\x88\xd5': u'\ub332',
'\x88\xd6': u'\ub333',
'\x88\xd7': u'\ub334',
'\x88\xd8': u'\ub335',
'\x88\xd9': u'\ub336',
'\x88\xda': u'\ub337',
'\x88\xdb': u'\ub338',
'\x88\xdc': u'\ub339',
'\x88\xdd': u'\ub33a',
'\x88\xde': u'\ub33b',
'\x88\xdf': u'\ub33c',
'\x88\xe0': u'\ub33d',
'\x88\xe1': u'\ub33e',
'\x88\xe2': u'\ub33f',
'\x88\xe3': u'\ub340',
'\x88\xe4': u'\ub341',
'\x88\xe5': u'\ub342',
'\x88\xe6': u'\ub343',
'\x88\xe7': u'\ub344',
'\x88\xe8': u'\ub345',
'\x88\xe9': u'\ub346',
'\x88\xea': u'\ub347',
'\x88\xeb': u'\ub348',
'\x88\xec': u'\ub349',
'\x88\xed': u'\ub34a',
'\x88\xee': u'\ub34b',
'\x88\xef': u'\ub34c',
'\x88\xf0': u'\ub34d',
'\x88\xf1': u'\ub34e',
'\x88\xf2': u'\ub34f',
'\x88\xf3': u'\ub350',
'\x88\xf4': u'\ub351',
'\x88\xf5': u'\ub352',
'\x88\xf6': u'\ub353',
'\x88\xf7': u'\ub357',
'\x88\xf8': u'\ub359',
'\x88\xf9': u'\ub35a',
'\x88\xfa': u'\ub35d',
'\x88\xfb': u'\ub360',
'\x88\xfc': u'\ub361',
'\x88\xfd': u'\ub362',
'\x88\xfe': u'\ub363',
'\x88a': u'\ub28f',
'\x88b': u'\ub292',
'\x88c': u'\ub293',
'\x88d': u'\ub295',
'\x88e': u'\ub296',
'\x88f': u'\ub297',
'\x88g': u'\ub29b',
'\x88h': u'\ub29c',
'\x88i': u'\ub29d',
'\x88j': u'\ub29e',
'\x88k': u'\ub29f',
'\x88l': u'\ub2a2',
'\x88m': u'\ub2a4',
'\x88n': u'\ub2a7',
'\x88o': u'\ub2a8',
'\x88p': u'\ub2a9',
'\x88q': u'\ub2ab',
'\x88r': u'\ub2ad',
'\x88s': u'\ub2ae',
'\x88t': u'\ub2af',
'\x88u': u'\ub2b1',
'\x88v': u'\ub2b2',
'\x88w': u'\ub2b3',
'\x88x': u'\ub2b5',
'\x88y': u'\ub2b6',
'\x88z': u'\ub2b7',
'\x89A': u'\ub366',
'\x89B': u'\ub368',
'\x89C': u'\ub36a',
'\x89D': u'\ub36c',
'\x89E': u'\ub36d',
'\x89F': u'\ub36f',
'\x89G': u'\ub372',
'\x89H': u'\ub373',
'\x89I': u'\ub375',
'\x89J': u'\ub376',
'\x89K': u'\ub377',
'\x89L': u'\ub379',
'\x89M': u'\ub37a',
'\x89N': u'\ub37b',
'\x89O': u'\ub37c',
'\x89P': u'\ub37d',
'\x89Q': u'\ub37e',
'\x89R': u'\ub37f',
'\x89S': u'\ub382',
'\x89T': u'\ub386',
'\x89U': u'\ub387',
'\x89V': u'\ub388',
'\x89W': u'\ub389',
'\x89X': u'\ub38a',
'\x89Y': u'\ub38b',
'\x89Z': u'\ub38d',
'\x89\x81': u'\ub3ae',
'\x89\x82': u'\ub3af',
'\x89\x83': u'\ub3b0',
'\x89\x84': u'\ub3b1',
'\x89\x85': u'\ub3b2',
'\x89\x86': u'\ub3b3',
'\x89\x87': u'\ub3b4',
'\x89\x88': u'\ub3b5',
'\x89\x89': u'\ub3b6',
'\x89\x8a': u'\ub3b7',
'\x89\x8b': u'\ub3b8',
'\x89\x8c': u'\ub3b9',
'\x89\x8d': u'\ub3ba',
'\x89\x8e': u'\ub3bb',
'\x89\x8f': u'\ub3bc',
'\x89\x90': u'\ub3bd',
'\x89\x91': u'\ub3be',
'\x89\x92': u'\ub3bf',
'\x89\x93': u'\ub3c0',
'\x89\x94': u'\ub3c1',
'\x89\x95': u'\ub3c2',
'\x89\x96': u'\ub3c3',
'\x89\x97': u'\ub3c6',
'\x89\x98': u'\ub3c7',
'\x89\x99': u'\ub3c9',
'\x89\x9a': u'\ub3ca',
'\x89\x9b': u'\ub3cd',
'\x89\x9c': u'\ub3cf',
'\x89\x9d': u'\ub3d1',
'\x89\x9e': u'\ub3d2',
'\x89\x9f': u'\ub3d3',
'\x89\xa0': u'\ub3d6',
'\x89\xa1': u'\ub3d8',
'\x89\xa2': u'\ub3da',
'\x89\xa3': u'\ub3dc',
'\x89\xa4': u'\ub3de',
'\x89\xa5': u'\ub3df',
'\x89\xa6': u'\ub3e1',
'\x89\xa7': u'\ub3e2',
'\x89\xa8': u'\ub3e3',
'\x89\xa9': u'\ub3e5',
'\x89\xaa': u'\ub3e6',
'\x89\xab': u'\ub3e7',
'\x89\xac': u'\ub3e9',
'\x89\xad': u'\ub3ea',
'\x89\xae': u'\ub3eb',
'\x89\xaf': u'\ub3ec',
'\x89\xb0': u'\ub3ed',
'\x89\xb1': u'\ub3ee',
'\x89\xb2': u'\ub3ef',
'\x89\xb3': u'\ub3f0',
'\x89\xb4': u'\ub3f1',
'\x89\xb5': u'\ub3f2',
'\x89\xb6': u'\ub3f3',
'\x89\xb7': u'\ub3f4',
'\x89\xb8': u'\ub3f5',
'\x89\xb9': u'\ub3f6',
'\x89\xba': u'\ub3f7',
'\x89\xbb': u'\ub3f8',
'\x89\xbc': u'\ub3f9',
'\x89\xbd': u'\ub3fa',
'\x89\xbe': u'\ub3fb',
'\x89\xbf': u'\ub3fd',
'\x89\xc0': u'\ub3fe',
'\x89\xc1': u'\ub3ff',
'\x89\xc2': u'\ub400',
'\x89\xc3': u'\ub401',
'\x89\xc4': u'\ub402',
'\x89\xc5': u'\ub403',
'\x89\xc6': u'\ub404',
'\x89\xc7': u'\ub405',
'\x89\xc8': u'\ub406',
'\x89\xc9': u'\ub407',
'\x89\xca': u'\ub408',
'\x89\xcb': u'\ub409',
'\x89\xcc': u'\ub40a',
'\x89\xcd': u'\ub40b',
'\x89\xce': u'\ub40c',
'\x89\xcf': u'\ub40d',
'\x89\xd0': u'\ub40e',
'\x89\xd1': u'\ub40f',
'\x89\xd2': u'\ub411',
'\x89\xd3': u'\ub412',
'\x89\xd4': u'\ub413',
'\x89\xd5': u'\ub414',
'\x89\xd6': u'\ub415',
'\x89\xd7': u'\ub416',
'\x89\xd8': u'\ub417',
'\x89\xd9': u'\ub419',
'\x89\xda': u'\ub41a',
'\x89\xdb': u'\ub41b',
'\x89\xdc': u'\ub41d',
'\x89\xdd': u'\ub41e',
'\x89\xde': u'\ub41f',
'\x89\xdf': u'\ub421',
'\x89\xe0': u'\ub422',
'\x89\xe1': u'\ub423',
'\x89\xe2': u'\ub424',
'\x89\xe3': u'\ub425',
'\x89\xe4': u'\ub426',
'\x89\xe5': u'\ub427',
'\x89\xe6': u'\ub42a',
'\x89\xe7': u'\ub42c',
'\x89\xe8': u'\ub42d',
'\x89\xe9': u'\ub42e',
'\x89\xea': u'\ub42f',
'\x89\xeb': u'\ub430',
'\x89\xec': u'\ub431',
'\x89\xed': u'\ub432',
'\x89\xee': u'\ub433',
'\x89\xef': u'\ub435',
'\x89\xf0': u'\ub436',
'\x89\xf1': u'\ub437',
'\x89\xf2': u'\ub438',
'\x89\xf3': u'\ub439',
'\x89\xf4': u'\ub43a',
'\x89\xf5': u'\ub43b',
'\x89\xf6': u'\ub43c',
'\x89\xf7': u'\ub43d',
'\x89\xf8': u'\ub43e',
'\x89\xf9': u'\ub43f',
'\x89\xfa': u'\ub440',
'\x89\xfb': u'\ub441',
'\x89\xfc': u'\ub442',
'\x89\xfd': u'\ub443',
'\x89\xfe': u'\ub444',
'\x89a': u'\ub38e',
'\x89b': u'\ub38f',
'\x89c': u'\ub391',
'\x89d': u'\ub392',
'\x89e': u'\ub393',
'\x89f': u'\ub395',
'\x89g': u'\ub396',
'\x89h': u'\ub397',
'\x89i': u'\ub398',
'\x89j': u'\ub399',
'\x89k': u'\ub39a',
'\x89l': u'\ub39b',
'\x89m': u'\ub39c',
'\x89n': u'\ub39d',
'\x89o': u'\ub39e',
'\x89p': u'\ub39f',
'\x89q': u'\ub3a2',
'\x89r': u'\ub3a3',
'\x89s': u'\ub3a4',
'\x89t': u'\ub3a5',
'\x89u': u'\ub3a6',
'\x89v': u'\ub3a7',
'\x89w': u'\ub3a9',
'\x89x': u'\ub3aa',
'\x89y': u'\ub3ab',
'\x89z': u'\ub3ad',
'\x8aA': u'\ub445',
'\x8aB': u'\ub446',
'\x8aC': u'\ub447',
'\x8aD': u'\ub448',
'\x8aE': u'\ub449',
'\x8aF': u'\ub44a',
'\x8aG': u'\ub44b',
'\x8aH': u'\ub44c',
'\x8aI': u'\ub44d',
'\x8aJ': u'\ub44e',
'\x8aK': u'\ub44f',
'\x8aL': u'\ub452',
'\x8aM': u'\ub453',
'\x8aN': u'\ub455',
'\x8aO': u'\ub456',
'\x8aP': u'\ub457',
'\x8aQ': u'\ub459',
'\x8aR': u'\ub45a',
'\x8aS': u'\ub45b',
'\x8aT': u'\ub45c',
'\x8aU': u'\ub45d',
'\x8aV': u'\ub45e',
'\x8aW': u'\ub45f',
'\x8aX': u'\ub462',
'\x8aY': u'\ub464',
'\x8aZ': u'\ub466',
'\x8a\x81': u'\ub483',
'\x8a\x82': u'\ub484',
'\x8a\x83': u'\ub485',
'\x8a\x84': u'\ub486',
'\x8a\x85': u'\ub487',
'\x8a\x86': u'\ub489',
'\x8a\x87': u'\ub48a',
'\x8a\x88': u'\ub48b',
'\x8a\x89': u'\ub48c',
'\x8a\x8a': u'\ub48d',
'\x8a\x8b': u'\ub48e',
'\x8a\x8c': u'\ub48f',
'\x8a\x8d': u'\ub490',
'\x8a\x8e': u'\ub491',
'\x8a\x8f': u'\ub492',
'\x8a\x90': u'\ub493',
'\x8a\x91': u'\ub494',
'\x8a\x92': u'\ub495',
'\x8a\x93': u'\ub496',
'\x8a\x94': u'\ub497',
'\x8a\x95': u'\ub498',
'\x8a\x96': u'\ub499',
'\x8a\x97': u'\ub49a',
'\x8a\x98': u'\ub49b',
'\x8a\x99': u'\ub49c',
'\x8a\x9a': u'\ub49e',
'\x8a\x9b': u'\ub49f',
'\x8a\x9c': u'\ub4a0',
'\x8a\x9d': u'\ub4a1',
'\x8a\x9e': u'\ub4a2',
'\x8a\x9f': u'\ub4a3',
'\x8a\xa0': u'\ub4a5',
'\x8a\xa1': u'\ub4a6',
'\x8a\xa2': u'\ub4a7',
'\x8a\xa3': u'\ub4a9',
'\x8a\xa4': u'\ub4aa',
'\x8a\xa5': u'\ub4ab',
'\x8a\xa6': u'\ub4ad',
'\x8a\xa7': u'\ub4ae',
'\x8a\xa8': u'\ub4af',
'\x8a\xa9': u'\ub4b0',
'\x8a\xaa': u'\ub4b1',
'\x8a\xab': u'\ub4b2',
'\x8a\xac': u'\ub4b3',
'\x8a\xad': u'\ub4b4',
'\x8a\xae': u'\ub4b6',
'\x8a\xaf': u'\ub4b8',
'\x8a\xb0': u'\ub4ba',
'\x8a\xb1': u'\ub4bb',
'\x8a\xb2': u'\ub4bc',
'\x8a\xb3': u'\ub4bd',
'\x8a\xb4': u'\ub4be',
'\x8a\xb5': u'\ub4bf',
'\x8a\xb6': u'\ub4c1',
'\x8a\xb7': u'\ub4c2',
'\x8a\xb8': u'\ub4c3',
'\x8a\xb9': u'\ub4c5',
'\x8a\xba': u'\ub4c6',
'\x8a\xbb': u'\ub4c7',
'\x8a\xbc': u'\ub4c9',
'\x8a\xbd': u'\ub4ca',
'\x8a\xbe': u'\ub4cb',
'\x8a\xbf': u'\ub4cc',
'\x8a\xc0': u'\ub4cd',
'\x8a\xc1': u'\ub4ce',
'\x8a\xc2': u'\ub4cf',
'\x8a\xc3': u'\ub4d1',
'\x8a\xc4': u'\ub4d2',
'\x8a\xc5': u'\ub4d3',
'\x8a\xc6': u'\ub4d4',
'\x8a\xc7': u'\ub4d6',
'\x8a\xc8': u'\ub4d7',
'\x8a\xc9': u'\ub4d8',
'\x8a\xca': u'\ub4d9',
'\x8a\xcb': u'\ub4da',
'\x8a\xcc': u'\ub4db',
'\x8a\xcd': u'\ub4de',
'\x8a\xce': u'\ub4df',
'\x8a\xcf': u'\ub4e1',
'\x8a\xd0': u'\ub4e2',
'\x8a\xd1': u'\ub4e5',
'\x8a\xd2': u'\ub4e7',
'\x8a\xd3': u'\ub4e8',
'\x8a\xd4': u'\ub4e9',
'\x8a\xd5': u'\ub4ea',
'\x8a\xd6': u'\ub4eb',
'\x8a\xd7': u'\ub4ee',
'\x8a\xd8': u'\ub4f0',
'\x8a\xd9': u'\ub4f2',
'\x8a\xda': u'\ub4f3',
'\x8a\xdb': u'\ub4f4',
'\x8a\xdc': u'\ub4f5',
'\x8a\xdd': u'\ub4f6',
'\x8a\xde': u'\ub4f7',
'\x8a\xdf': u'\ub4f9',
'\x8a\xe0': u'\ub4fa',
'\x8a\xe1': u'\ub4fb',
'\x8a\xe2': u'\ub4fc',
'\x8a\xe3': u'\ub4fd',
'\x8a\xe4': u'\ub4fe',
'\x8a\xe5': u'\ub4ff',
'\x8a\xe6': u'\ub500',
'\x8a\xe7': u'\ub501',
'\x8a\xe8': u'\ub502',
'\x8a\xe9': u'\ub503',
'\x8a\xea': u'\ub504',
'\x8a\xeb': u'\ub505',
'\x8a\xec': u'\ub506',
'\x8a\xed': u'\ub507',
'\x8a\xee': u'\ub508',
'\x8a\xef': u'\ub509',
'\x8a\xf0': u'\ub50a',
'\x8a\xf1': u'\ub50b',
'\x8a\xf2': u'\ub50c',
'\x8a\xf3': u'\ub50d',
'\x8a\xf4': u'\ub50e',
'\x8a\xf5': u'\ub50f',
'\x8a\xf6': u'\ub510',
'\x8a\xf7': u'\ub511',
'\x8a\xf8': u'\ub512',
'\x8a\xf9': u'\ub513',
'\x8a\xfa': u'\ub516',
'\x8a\xfb': u'\ub517',
'\x8a\xfc': u'\ub519',
'\x8a\xfd': u'\ub51a',
'\x8a\xfe': u'\ub51d',
'\x8aa': u'\ub467',
'\x8ab': u'\ub468',
'\x8ac': u'\ub469',
'\x8ad': u'\ub46a',
'\x8ae': u'\ub46b',
'\x8af': u'\ub46d',
'\x8ag': u'\ub46e',
'\x8ah': u'\ub46f',
'\x8ai': u'\ub470',
'\x8aj': u'\ub471',
'\x8ak': u'\ub472',
'\x8al': u'\ub473',
'\x8am': u'\ub474',
'\x8an': u'\ub475',
'\x8ao': u'\ub476',
'\x8ap': u'\ub477',
'\x8aq': u'\ub478',
'\x8ar': u'\ub479',
'\x8as': u'\ub47a',
'\x8at': u'\ub47b',
'\x8au': u'\ub47c',
'\x8av': u'\ub47d',
'\x8aw': u'\ub47e',
'\x8ax': u'\ub47f',
'\x8ay': u'\ub481',
'\x8az': u'\ub482',
'\x8bA': u'\ub51e',
'\x8bB': u'\ub51f',
'\x8bC': u'\ub520',
'\x8bD': u'\ub521',
'\x8bE': u'\ub522',
'\x8bF': u'\ub523',
'\x8bG': u'\ub526',
'\x8bH': u'\ub52b',
'\x8bI': u'\ub52c',
'\x8bJ': u'\ub52d',
'\x8bK': u'\ub52e',
'\x8bL': u'\ub52f',
'\x8bM': u'\ub532',
'\x8bN': u'\ub533',
'\x8bO': u'\ub535',
'\x8bP': u'\ub536',
'\x8bQ': u'\ub537',
'\x8bR': u'\ub539',
'\x8bS': u'\ub53a',
'\x8bT': u'\ub53b',
'\x8bU': u'\ub53c',
'\x8bV': u'\ub53d',
'\x8bW': u'\ub53e',
'\x8bX': u'\ub53f',
'\x8bY': u'\ub542',
'\x8bZ': u'\ub546',
'\x8b\x81': u'\ub56b',
'\x8b\x82': u'\ub56c',
'\x8b\x83': u'\ub56d',
'\x8b\x84': u'\ub56e',
'\x8b\x85': u'\ub56f',
'\x8b\x86': u'\ub570',
'\x8b\x87': u'\ub571',
'\x8b\x88': u'\ub572',
'\x8b\x89': u'\ub573',
'\x8b\x8a': u'\ub574',
'\x8b\x8b': u'\ub575',
'\x8b\x8c': u'\ub576',
'\x8b\x8d': u'\ub577',
'\x8b\x8e': u'\ub578',
'\x8b\x8f': u'\ub579',
'\x8b\x90': u'\ub57a',
'\x8b\x91': u'\ub57b',
'\x8b\x92': u'\ub57c',
'\x8b\x93': u'\ub57d',
'\x8b\x94': u'\ub57e',
'\x8b\x95': u'\ub57f',
'\x8b\x96': u'\ub580',
'\x8b\x97': u'\ub581',
'\x8b\x98': u'\ub582',
'\x8b\x99': u'\ub583',
'\x8b\x9a': u'\ub584',
'\x8b\x9b': u'\ub585',
'\x8b\x9c': u'\ub586',
'\x8b\x9d': u'\ub587',
'\x8b\x9e': u'\ub588',
'\x8b\x9f': u'\ub589',
'\x8b\xa0': u'\ub58a',
'\x8b\xa1': u'\ub58b',
'\x8b\xa2': u'\ub58c',
'\x8b\xa3': u'\ub58d',
'\x8b\xa4': u'\ub58e',
'\x8b\xa5': u'\ub58f',
'\x8b\xa6': u'\ub590',
'\x8b\xa7': u'\ub591',
'\x8b\xa8': u'\ub592',
'\x8b\xa9': u'\ub593',
'\x8b\xaa': u'\ub594',
'\x8b\xab': u'\ub595',
'\x8b\xac': u'\ub596',
'\x8b\xad': u'\ub597',
'\x8b\xae': u'\ub598',
'\x8b\xaf': u'\ub599',
'\x8b\xb0': u'\ub59a',
'\x8b\xb1': u'\ub59b',
'\x8b\xb2': u'\ub59c',
'\x8b\xb3': u'\ub59d',
'\x8b\xb4': u'\ub59e',
'\x8b\xb5': u'\ub59f',
'\x8b\xb6': u'\ub5a2',
'\x8b\xb7': u'\ub5a3',
'\x8b\xb8': u'\ub5a5',
'\x8b\xb9': u'\ub5a6',
'\x8b\xba': u'\ub5a7',
'\x8b\xbb': u'\ub5a9',
'\x8b\xbc': u'\ub5ac',
'\x8b\xbd': u'\ub5ad',
'\x8b\xbe': u'\ub5ae',
'\x8b\xbf': u'\ub5af',
'\x8b\xc0': u'\ub5b2',
'\x8b\xc1': u'\ub5b6',
'\x8b\xc2': u'\ub5b7',
'\x8b\xc3': u'\ub5b8',
'\x8b\xc4': u'\ub5b9',
'\x8b\xc5': u'\ub5ba',
'\x8b\xc6': u'\ub5be',
'\x8b\xc7': u'\ub5bf',
'\x8b\xc8': u'\ub5c1',
'\x8b\xc9': u'\ub5c2',
'\x8b\xca': u'\ub5c3',
'\x8b\xcb': u'\ub5c5',
'\x8b\xcc': u'\ub5c6',
'\x8b\xcd': u'\ub5c7',
'\x8b\xce': u'\ub5c8',
'\x8b\xcf': u'\ub5c9',
'\x8b\xd0': u'\ub5ca',
'\x8b\xd1': u'\ub5cb',
'\x8b\xd2': u'\ub5ce',
'\x8b\xd3': u'\ub5d2',
'\x8b\xd4': u'\ub5d3',
'\x8b\xd5': u'\ub5d4',
'\x8b\xd6': u'\ub5d5',
'\x8b\xd7': u'\ub5d6',
'\x8b\xd8': u'\ub5d7',
'\x8b\xd9': u'\ub5d9',
'\x8b\xda': u'\ub5da',
'\x8b\xdb': u'\ub5db',
'\x8b\xdc': u'\ub5dc',
'\x8b\xdd': u'\ub5dd',
'\x8b\xde': u'\ub5de',
'\x8b\xdf': u'\ub5df',
'\x8b\xe0': u'\ub5e0',
'\x8b\xe1': u'\ub5e1',
'\x8b\xe2': u'\ub5e2',
'\x8b\xe3': u'\ub5e3',
'\x8b\xe4': u'\ub5e4',
'\x8b\xe5': u'\ub5e5',
'\x8b\xe6': u'\ub5e6',
'\x8b\xe7': u'\ub5e7',
'\x8b\xe8': u'\ub5e8',
'\x8b\xe9': u'\ub5e9',
'\x8b\xea': u'\ub5ea',
'\x8b\xeb': u'\ub5eb',
'\x8b\xec': u'\ub5ed',
'\x8b\xed': u'\ub5ee',
'\x8b\xee': u'\ub5ef',
'\x8b\xef': u'\ub5f0',
'\x8b\xf0': u'\ub5f1',
'\x8b\xf1': u'\ub5f2',
'\x8b\xf2': u'\ub5f3',
'\x8b\xf3': u'\ub5f4',
'\x8b\xf4': u'\ub5f5',
'\x8b\xf5': u'\ub5f6',
'\x8b\xf6': u'\ub5f7',
'\x8b\xf7': u'\ub5f8',
'\x8b\xf8': u'\ub5f9',
'\x8b\xf9': u'\ub5fa',
'\x8b\xfa': u'\ub5fb',
'\x8b\xfb': u'\ub5fc',
'\x8b\xfc': u'\ub5fd',
'\x8b\xfd': u'\ub5fe',
'\x8b\xfe': u'\ub5ff',
'\x8ba': u'\ub547',
'\x8bb': u'\ub548',
'\x8bc': u'\ub549',
'\x8bd': u'\ub54a',
'\x8be': u'\ub54e',
'\x8bf': u'\ub54f',
'\x8bg': u'\ub551',
'\x8bh': u'\ub552',
'\x8bi': u'\ub553',
'\x8bj': u'\ub555',
'\x8bk': u'\ub556',
'\x8bl': u'\ub557',
'\x8bm': u'\ub558',
'\x8bn': u'\ub559',
'\x8bo': u'\ub55a',
'\x8bp': u'\ub55b',
'\x8bq': u'\ub55e',
'\x8br': u'\ub562',
'\x8bs': u'\ub563',
'\x8bt': u'\ub564',
'\x8bu': u'\ub565',
'\x8bv': u'\ub566',
'\x8bw': u'\ub567',
'\x8bx': u'\ub568',
'\x8by': u'\ub569',
'\x8bz': u'\ub56a',
'\x8cA': u'\ub600',
'\x8cB': u'\ub601',
'\x8cC': u'\ub602',
'\x8cD': u'\ub603',
'\x8cE': u'\ub604',
'\x8cF': u'\ub605',
'\x8cG': u'\ub606',
'\x8cH': u'\ub607',
'\x8cI': u'\ub608',
'\x8cJ': u'\ub609',
'\x8cK': u'\ub60a',
'\x8cL': u'\ub60b',
'\x8cM': u'\ub60c',
'\x8cN': u'\ub60d',
'\x8cO': u'\ub60e',
'\x8cP': u'\ub60f',
'\x8cQ': u'\ub612',
'\x8cR': u'\ub613',
'\x8cS': u'\ub615',
'\x8cT': u'\ub616',
'\x8cU': u'\ub617',
'\x8cV': u'\ub619',
'\x8cW': u'\ub61a',
'\x8cX': u'\ub61b',
'\x8cY': u'\ub61c',
'\x8cZ': u'\ub61d',
'\x8c\x81': u'\ub63b',
'\x8c\x82': u'\ub63c',
'\x8c\x83': u'\ub63d',
'\x8c\x84': u'\ub63e',
'\x8c\x85': u'\ub63f',
'\x8c\x86': u'\ub640',
'\x8c\x87': u'\ub641',
'\x8c\x88': u'\ub642',
'\x8c\x89': u'\ub643',
'\x8c\x8a': u'\ub644',
'\x8c\x8b': u'\ub645',
'\x8c\x8c': u'\ub646',
'\x8c\x8d': u'\ub647',
'\x8c\x8e': u'\ub649',
'\x8c\x8f': u'\ub64a',
'\x8c\x90': u'\ub64b',
'\x8c\x91': u'\ub64c',
'\x8c\x92': u'\ub64d',
'\x8c\x93': u'\ub64e',
'\x8c\x94': u'\ub64f',
'\x8c\x95': u'\ub650',
'\x8c\x96': u'\ub651',
'\x8c\x97': u'\ub652',
'\x8c\x98': u'\ub653',
'\x8c\x99': u'\ub654',
'\x8c\x9a': u'\ub655',
'\x8c\x9b': u'\ub656',
'\x8c\x9c': u'\ub657',
'\x8c\x9d': u'\ub658',
'\x8c\x9e': u'\ub659',
'\x8c\x9f': u'\ub65a',
'\x8c\xa0': u'\ub65b',
'\x8c\xa1': u'\ub65c',
'\x8c\xa2': u'\ub65d',
'\x8c\xa3': u'\ub65e',
'\x8c\xa4': u'\ub65f',
'\x8c\xa5': u'\ub660',
'\x8c\xa6': u'\ub661',
'\x8c\xa7': u'\ub662',
'\x8c\xa8': u'\ub663',
'\x8c\xa9': u'\ub665',
'\x8c\xaa': u'\ub666',
'\x8c\xab': u'\ub667',
'\x8c\xac': u'\ub669',
'\x8c\xad': u'\ub66a',
'\x8c\xae': u'\ub66b',
'\x8c\xaf': u'\ub66c',
'\x8c\xb0': u'\ub66d',
'\x8c\xb1': u'\ub66e',
'\x8c\xb2': u'\ub66f',
'\x8c\xb3': u'\ub670',
'\x8c\xb4': u'\ub671',
'\x8c\xb5': u'\ub672',
'\x8c\xb6': u'\ub673',
'\x8c\xb7': u'\ub674',
'\x8c\xb8': u'\ub675',
'\x8c\xb9': u'\ub676',
'\x8c\xba': u'\ub677',
'\x8c\xbb': u'\ub678',
'\x8c\xbc': u'\ub679',
'\x8c\xbd': u'\ub67a',
'\x8c\xbe': u'\ub67b',
'\x8c\xbf': u'\ub67c',
'\x8c\xc0': u'\ub67d',
'\x8c\xc1': u'\ub67e',
'\x8c\xc2': u'\ub67f',
'\x8c\xc3': u'\ub680',
'\x8c\xc4': u'\ub681',
'\x8c\xc5': u'\ub682',
'\x8c\xc6': u'\ub683',
'\x8c\xc7': u'\ub684',
'\x8c\xc8': u'\ub685',
'\x8c\xc9': u'\ub686',
'\x8c\xca': u'\ub687',
'\x8c\xcb': u'\ub688',
'\x8c\xcc': u'\ub689',
'\x8c\xcd': u'\ub68a',
'\x8c\xce': u'\ub68b',
'\x8c\xcf': u'\ub68c',
'\x8c\xd0': u'\ub68d',
'\x8c\xd1': u'\ub68e',
'\x8c\xd2': u'\ub68f',
'\x8c\xd3': u'\ub690',
'\x8c\xd4': u'\ub691',
'\x8c\xd5': u'\ub692',
'\x8c\xd6': u'\ub693',
'\x8c\xd7': u'\ub694',
'\x8c\xd8': u'\ub695',
'\x8c\xd9': u'\ub696',
'\x8c\xda': u'\ub697',
'\x8c\xdb': u'\ub698',
'\x8c\xdc': u'\ub699',
'\x8c\xdd': u'\ub69a',
'\x8c\xde': u'\ub69b',
'\x8c\xdf': u'\ub69e',
'\x8c\xe0': u'\ub69f',
'\x8c\xe1': u'\ub6a1',
'\x8c\xe2': u'\ub6a2',
'\x8c\xe3': u'\ub6a3',
'\x8c\xe4': u'\ub6a5',
'\x8c\xe5': u'\ub6a6',
'\x8c\xe6': u'\ub6a7',
'\x8c\xe7': u'\ub6a8',
'\x8c\xe8': u'\ub6a9',
'\x8c\xe9': u'\ub6aa',
'\x8c\xea': u'\ub6ad',
'\x8c\xeb': u'\ub6ae',
'\x8c\xec': u'\ub6af',
'\x8c\xed': u'\ub6b0',
'\x8c\xee': u'\ub6b2',
'\x8c\xef': u'\ub6b3',
'\x8c\xf0': u'\ub6b4',
'\x8c\xf1': u'\ub6b5',
'\x8c\xf2': u'\ub6b6',
'\x8c\xf3': u'\ub6b7',
'\x8c\xf4': u'\ub6b8',
'\x8c\xf5': u'\ub6b9',
'\x8c\xf6': u'\ub6ba',
'\x8c\xf7': u'\ub6bb',
'\x8c\xf8': u'\ub6bc',
'\x8c\xf9': u'\ub6bd',
'\x8c\xfa': u'\ub6be',
'\x8c\xfb': u'\ub6bf',
'\x8c\xfc': u'\ub6c0',
'\x8c\xfd': u'\ub6c1',
'\x8c\xfe': u'\ub6c2',
'\x8ca': u'\ub61e',
'\x8cb': u'\ub61f',
'\x8cc': u'\ub620',
'\x8cd': u'\ub621',
'\x8ce': u'\ub622',
'\x8cf': u'\ub623',
'\x8cg': u'\ub624',
'\x8ch': u'\ub626',
'\x8ci': u'\ub627',
'\x8cj': u'\ub628',
'\x8ck': u'\ub629',
'\x8cl': u'\ub62a',
'\x8cm': u'\ub62b',
'\x8cn': u'\ub62d',
'\x8co': u'\ub62e',
'\x8cp': u'\ub62f',
'\x8cq': u'\ub630',
'\x8cr': u'\ub631',
'\x8cs': u'\ub632',
'\x8ct': u'\ub633',
'\x8cu': u'\ub635',
'\x8cv': u'\ub636',
'\x8cw': u'\ub637',
'\x8cx': u'\ub638',
'\x8cy': u'\ub639',
'\x8cz': u'\ub63a',
'\x8dA': u'\ub6c3',
'\x8dB': u'\ub6c4',
'\x8dC': u'\ub6c5',
'\x8dD': u'\ub6c6',
'\x8dE': u'\ub6c7',
'\x8dF': u'\ub6c8',
'\x8dG': u'\ub6c9',
'\x8dH': u'\ub6ca',
'\x8dI': u'\ub6cb',
'\x8dJ': u'\ub6cc',
'\x8dK': u'\ub6cd',
'\x8dL': u'\ub6ce',
'\x8dM': u'\ub6cf',
'\x8dN': u'\ub6d0',
'\x8dO': u'\ub6d1',
'\x8dP': u'\ub6d2',
'\x8dQ': u'\ub6d3',
'\x8dR': u'\ub6d5',
'\x8dS': u'\ub6d6',
'\x8dT': u'\ub6d7',
'\x8dU': u'\ub6d8',
'\x8dV': u'\ub6d9',
'\x8dW': u'\ub6da',
'\x8dX': u'\ub6db',
'\x8dY': u'\ub6dc',
'\x8dZ': u'\ub6dd',
'\x8d\x81': u'\ub6fb',
'\x8d\x82': u'\ub6fc',
'\x8d\x83': u'\ub6fd',
'\x8d\x84': u'\ub6fe',
'\x8d\x85': u'\ub6ff',
'\x8d\x86': u'\ub702',
'\x8d\x87': u'\ub703',
'\x8d\x88': u'\ub704',
'\x8d\x89': u'\ub706',
'\x8d\x8a': u'\ub707',
'\x8d\x8b': u'\ub708',
'\x8d\x8c': u'\ub709',
'\x8d\x8d': u'\ub70a',
'\x8d\x8e': u'\ub70b',
'\x8d\x8f': u'\ub70c',
'\x8d\x90': u'\ub70d',
'\x8d\x91': u'\ub70e',
'\x8d\x92': u'\ub70f',
'\x8d\x93': u'\ub710',
'\x8d\x94': u'\ub711',
'\x8d\x95': u'\ub712',
'\x8d\x96': u'\ub713',
'\x8d\x97': u'\ub714',
'\x8d\x98': u'\ub715',
'\x8d\x99': u'\ub716',
'\x8d\x9a': u'\ub717',
'\x8d\x9b': u'\ub718',
'\x8d\x9c': u'\ub719',
'\x8d\x9d': u'\ub71a',
'\x8d\x9e': u'\ub71b',
'\x8d\x9f': u'\ub71c',
'\x8d\xa0': u'\ub71d',
'\x8d\xa1': u'\ub71e',
'\x8d\xa2': u'\ub71f',
'\x8d\xa3': u'\ub720',
'\x8d\xa4': u'\ub721',
'\x8d\xa5': u'\ub722',
'\x8d\xa6': u'\ub723',
'\x8d\xa7': u'\ub724',
'\x8d\xa8': u'\ub725',
'\x8d\xa9': u'\ub726',
'\x8d\xaa': u'\ub727',
'\x8d\xab': u'\ub72a',
'\x8d\xac': u'\ub72b',
'\x8d\xad': u'\ub72d',
'\x8d\xae': u'\ub72e',
'\x8d\xaf': u'\ub731',
'\x8d\xb0': u'\ub732',
'\x8d\xb1': u'\ub733',
'\x8d\xb2': u'\ub734',
'\x8d\xb3': u'\ub735',
'\x8d\xb4': u'\ub736',
'\x8d\xb5': u'\ub737',
'\x8d\xb6': u'\ub73a',
'\x8d\xb7': u'\ub73c',
'\x8d\xb8': u'\ub73d',
'\x8d\xb9': u'\ub73e',
'\x8d\xba': u'\ub73f',
'\x8d\xbb': u'\ub740',
'\x8d\xbc': u'\ub741',
'\x8d\xbd': u'\ub742',
'\x8d\xbe': u'\ub743',
'\x8d\xbf': u'\ub745',
'\x8d\xc0': u'\ub746',
'\x8d\xc1': u'\ub747',
'\x8d\xc2': u'\ub749',
'\x8d\xc3': u'\ub74a',
'\x8d\xc4': u'\ub74b',
'\x8d\xc5': u'\ub74d',
'\x8d\xc6': u'\ub74e',
'\x8d\xc7': u'\ub74f',
'\x8d\xc8': u'\ub750',
'\x8d\xc9': u'\ub751',
'\x8d\xca': u'\ub752',
'\x8d\xcb': u'\ub753',
'\x8d\xcc': u'\ub756',
'\x8d\xcd': u'\ub757',
'\x8d\xce': u'\ub758',
'\x8d\xcf': u'\ub759',
'\x8d\xd0': u'\ub75a',
'\x8d\xd1': u'\ub75b',
'\x8d\xd2': u'\ub75c',
'\x8d\xd3': u'\ub75d',
'\x8d\xd4': u'\ub75e',
'\x8d\xd5': u'\ub75f',
'\x8d\xd6': u'\ub761',
'\x8d\xd7': u'\ub762',
'\x8d\xd8': u'\ub763',
'\x8d\xd9': u'\ub765',
'\x8d\xda': u'\ub766',
'\x8d\xdb': u'\ub767',
'\x8d\xdc': u'\ub769',
'\x8d\xdd': u'\ub76a',
'\x8d\xde': u'\ub76b',
'\x8d\xdf': u'\ub76c',
'\x8d\xe0': u'\ub76d',
'\x8d\xe1': u'\ub76e',
'\x8d\xe2': u'\ub76f',
'\x8d\xe3': u'\ub772',
'\x8d\xe4': u'\ub774',
'\x8d\xe5': u'\ub776',
'\x8d\xe6': u'\ub777',
'\x8d\xe7': u'\ub778',
'\x8d\xe8': u'\ub779',
'\x8d\xe9': u'\ub77a',
'\x8d\xea': u'\ub77b',
'\x8d\xeb': u'\ub77e',
'\x8d\xec': u'\ub77f',
'\x8d\xed': u'\ub781',
'\x8d\xee': u'\ub782',
'\x8d\xef': u'\ub783',
'\x8d\xf0': u'\ub785',
'\x8d\xf1': u'\ub786',
'\x8d\xf2': u'\ub787',
'\x8d\xf3': u'\ub788',
'\x8d\xf4': u'\ub789',
'\x8d\xf5': u'\ub78a',
'\x8d\xf6': u'\ub78b',
'\x8d\xf7': u'\ub78e',
'\x8d\xf8': u'\ub793',
'\x8d\xf9': u'\ub794',
'\x8d\xfa': u'\ub795',
'\x8d\xfb': u'\ub79a',
'\x8d\xfc': u'\ub79b',
'\x8d\xfd': u'\ub79d',
'\x8d\xfe': u'\ub79e',
'\x8da': u'\ub6de',
'\x8db': u'\ub6df',
'\x8dc': u'\ub6e0',
'\x8dd': u'\ub6e1',
'\x8de': u'\ub6e2',
'\x8df': u'\ub6e3',
'\x8dg': u'\ub6e4',
'\x8dh': u'\ub6e5',
'\x8di': u'\ub6e6',
'\x8dj': u'\ub6e7',
'\x8dk': u'\ub6e8',
'\x8dl': u'\ub6e9',
'\x8dm': u'\ub6ea',
'\x8dn': u'\ub6eb',
'\x8do': u'\ub6ec',
'\x8dp': u'\ub6ed',
'\x8dq': u'\ub6ee',
'\x8dr': u'\ub6ef',
'\x8ds': u'\ub6f1',
'\x8dt': u'\ub6f2',
'\x8du': u'\ub6f3',
'\x8dv': u'\ub6f5',
'\x8dw': u'\ub6f6',
'\x8dx': u'\ub6f7',
'\x8dy': u'\ub6f9',
'\x8dz': u'\ub6fa',
'\x8eA': u'\ub79f',
'\x8eB': u'\ub7a1',
'\x8eC': u'\ub7a2',
'\x8eD': u'\ub7a3',
'\x8eE': u'\ub7a4',
'\x8eF': u'\ub7a5',
'\x8eG': u'\ub7a6',
'\x8eH': u'\ub7a7',
'\x8eI': u'\ub7aa',
'\x8eJ': u'\ub7ae',
'\x8eK': u'\ub7af',
'\x8eL': u'\ub7b0',
'\x8eM': u'\ub7b1',
'\x8eN': u'\ub7b2',
'\x8eO': u'\ub7b3',
'\x8eP': u'\ub7b6',
'\x8eQ': u'\ub7b7',
'\x8eR': u'\ub7b9',
'\x8eS': u'\ub7ba',
'\x8eT': u'\ub7bb',
'\x8eU': u'\ub7bc',
'\x8eV': u'\ub7bd',
'\x8eW': u'\ub7be',
'\x8eX': u'\ub7bf',
'\x8eY': u'\ub7c0',
'\x8eZ': u'\ub7c1',
'\x8e\x81': u'\ub7de',
'\x8e\x82': u'\ub7df',
'\x8e\x83': u'\ub7e0',
'\x8e\x84': u'\ub7e1',
'\x8e\x85': u'\ub7e2',
'\x8e\x86': u'\ub7e3',
'\x8e\x87': u'\ub7e4',
'\x8e\x88': u'\ub7e5',
'\x8e\x89': u'\ub7e6',
'\x8e\x8a': u'\ub7e7',
'\x8e\x8b': u'\ub7e8',
'\x8e\x8c': u'\ub7e9',
'\x8e\x8d': u'\ub7ea',
'\x8e\x8e': u'\ub7eb',
'\x8e\x8f': u'\ub7ee',
'\x8e\x90': u'\ub7ef',
'\x8e\x91': u'\ub7f1',
'\x8e\x92': u'\ub7f2',
'\x8e\x93': u'\ub7f3',
'\x8e\x94': u'\ub7f5',
'\x8e\x95': u'\ub7f6',
'\x8e\x96': u'\ub7f7',
'\x8e\x97': u'\ub7f8',
'\x8e\x98': u'\ub7f9',
'\x8e\x99': u'\ub7fa',
'\x8e\x9a': u'\ub7fb',
'\x8e\x9b': u'\ub7fe',
'\x8e\x9c': u'\ub802',
'\x8e\x9d': u'\ub803',
'\x8e\x9e': u'\ub804',
'\x8e\x9f': u'\ub805',
'\x8e\xa0': u'\ub806',
'\x8e\xa1': u'\ub80a',
'\x8e\xa2': u'\ub80b',
'\x8e\xa3': u'\ub80d',
'\x8e\xa4': u'\ub80e',
'\x8e\xa5': u'\ub80f',
'\x8e\xa6': u'\ub811',
'\x8e\xa7': u'\ub812',
'\x8e\xa8': u'\ub813',
'\x8e\xa9': u'\ub814',
'\x8e\xaa': u'\ub815',
'\x8e\xab': u'\ub816',
'\x8e\xac': u'\ub817',
'\x8e\xad': u'\ub81a',
'\x8e\xae': u'\ub81c',
'\x8e\xaf': u'\ub81e',
'\x8e\xb0': u'\ub81f',
'\x8e\xb1': u'\ub820',
'\x8e\xb2': u'\ub821',
'\x8e\xb3': u'\ub822',
'\x8e\xb4': u'\ub823',
'\x8e\xb5': u'\ub826',
'\x8e\xb6': u'\ub827',
'\x8e\xb7': u'\ub829',
'\x8e\xb8': u'\ub82a',
'\x8e\xb9': u'\ub82b',
'\x8e\xba': u'\ub82d',
'\x8e\xbb': u'\ub82e',
'\x8e\xbc': u'\ub82f',
'\x8e\xbd': u'\ub830',
'\x8e\xbe': u'\ub831',
'\x8e\xbf': u'\ub832',
'\x8e\xc0': u'\ub833',
'\x8e\xc1': u'\ub836',
'\x8e\xc2': u'\ub83a',
'\x8e\xc3': u'\ub83b',
'\x8e\xc4': u'\ub83c',
'\x8e\xc5': u'\ub83d',
'\x8e\xc6': u'\ub83e',
'\x8e\xc7': u'\ub83f',
'\x8e\xc8': u'\ub841',
'\x8e\xc9': u'\ub842',
'\x8e\xca': u'\ub843',
'\x8e\xcb': u'\ub845',
'\x8e\xcc': u'\ub846',
'\x8e\xcd': u'\ub847',
'\x8e\xce': u'\ub848',
'\x8e\xcf': u'\ub849',
'\x8e\xd0': u'\ub84a',
'\x8e\xd1': u'\ub84b',
'\x8e\xd2': u'\ub84c',
'\x8e\xd3': u'\ub84d',
'\x8e\xd4': u'\ub84e',
'\x8e\xd5': u'\ub84f',
'\x8e\xd6': u'\ub850',
'\x8e\xd7': u'\ub852',
'\x8e\xd8': u'\ub854',
'\x8e\xd9': u'\ub855',
'\x8e\xda': u'\ub856',
'\x8e\xdb': u'\ub857',
'\x8e\xdc': u'\ub858',
'\x8e\xdd': u'\ub859',
'\x8e\xde': u'\ub85a',
'\x8e\xdf': u'\ub85b',
'\x8e\xe0': u'\ub85e',
'\x8e\xe1': u'\ub85f',
'\x8e\xe2': u'\ub861',
'\x8e\xe3': u'\ub862',
'\x8e\xe4': u'\ub863',
'\x8e\xe5': u'\ub865',
'\x8e\xe6': u'\ub866',
'\x8e\xe7': u'\ub867',
'\x8e\xe8': u'\ub868',
'\x8e\xe9': u'\ub869',
'\x8e\xea': u'\ub86a',
'\x8e\xeb': u'\ub86b',
'\x8e\xec': u'\ub86e',
'\x8e\xed': u'\ub870',
'\x8e\xee': u'\ub872',
'\x8e\xef': u'\ub873',
'\x8e\xf0': u'\ub874',
'\x8e\xf1': u'\ub875',
'\x8e\xf2': u'\ub876',
'\x8e\xf3': u'\ub877',
'\x8e\xf4': u'\ub879',
'\x8e\xf5': u'\ub87a',
'\x8e\xf6': u'\ub87b',
'\x8e\xf7': u'\ub87d',
'\x8e\xf8': u'\ub87e',
'\x8e\xf9': u'\ub87f',
'\x8e\xfa': u'\ub880',
'\x8e\xfb': u'\ub881',
'\x8e\xfc': u'\ub882',
'\x8e\xfd': u'\ub883',
'\x8e\xfe': u'\ub884',
'\x8ea': u'\ub7c2',
'\x8eb': u'\ub7c3',
'\x8ec': u'\ub7c4',
'\x8ed': u'\ub7c5',
'\x8ee': u'\ub7c6',
'\x8ef': u'\ub7c8',
'\x8eg': u'\ub7ca',
'\x8eh': u'\ub7cb',
'\x8ei': u'\ub7cc',
'\x8ej': u'\ub7cd',
'\x8ek': u'\ub7ce',
'\x8el': u'\ub7cf',
'\x8em': u'\ub7d0',
'\x8en': u'\ub7d1',
'\x8eo': u'\ub7d2',
'\x8ep': u'\ub7d3',
'\x8eq': u'\ub7d4',
'\x8er': u'\ub7d5',
'\x8es': u'\ub7d6',
'\x8et': u'\ub7d7',
'\x8eu': u'\ub7d8',
'\x8ev': u'\ub7d9',
'\x8ew': u'\ub7da',
'\x8ex': u'\ub7db',
'\x8ey': u'\ub7dc',
'\x8ez': u'\ub7dd',
'\x8fA': u'\ub885',
'\x8fB': u'\ub886',
'\x8fC': u'\ub887',
'\x8fD': u'\ub888',
'\x8fE': u'\ub889',
'\x8fF': u'\ub88a',
'\x8fG': u'\ub88b',
'\x8fH': u'\ub88c',
'\x8fI': u'\ub88e',
'\x8fJ': u'\ub88f',
'\x8fK': u'\ub890',
'\x8fL': u'\ub891',
'\x8fM': u'\ub892',
'\x8fN': u'\ub893',
'\x8fO': u'\ub894',
'\x8fP': u'\ub895',
'\x8fQ': u'\ub896',
'\x8fR': u'\ub897',
'\x8fS': u'\ub898',
'\x8fT': u'\ub899',
'\x8fU': u'\ub89a',
'\x8fV': u'\ub89b',
'\x8fW': u'\ub89c',
'\x8fX': u'\ub89d',
'\x8fY': u'\ub89e',
'\x8fZ': u'\ub89f',
'\x8f\x81': u'\ub8be',
'\x8f\x82': u'\ub8bf',
'\x8f\x83': u'\ub8c2',
'\x8f\x84': u'\ub8c4',
'\x8f\x85': u'\ub8c6',
'\x8f\x86': u'\ub8c7',
'\x8f\x87': u'\ub8c8',
'\x8f\x88': u'\ub8c9',
'\x8f\x89': u'\ub8ca',
'\x8f\x8a': u'\ub8cb',
'\x8f\x8b': u'\ub8cd',
'\x8f\x8c': u'\ub8ce',
'\x8f\x8d': u'\ub8cf',
'\x8f\x8e': u'\ub8d1',
'\x8f\x8f': u'\ub8d2',
'\x8f\x90': u'\ub8d3',
'\x8f\x91': u'\ub8d5',
'\x8f\x92': u'\ub8d6',
'\x8f\x93': u'\ub8d7',
'\x8f\x94': u'\ub8d8',
'\x8f\x95': u'\ub8d9',
'\x8f\x96': u'\ub8da',
'\x8f\x97': u'\ub8db',
'\x8f\x98': u'\ub8dc',
'\x8f\x99': u'\ub8de',
'\x8f\x9a': u'\ub8e0',
'\x8f\x9b': u'\ub8e2',
'\x8f\x9c': u'\ub8e3',
'\x8f\x9d': u'\ub8e4',
'\x8f\x9e': u'\ub8e5',
'\x8f\x9f': u'\ub8e6',
'\x8f\xa0': u'\ub8e7',
'\x8f\xa1': u'\ub8ea',
'\x8f\xa2': u'\ub8eb',
'\x8f\xa3': u'\ub8ed',
'\x8f\xa4': u'\ub8ee',
'\x8f\xa5': u'\ub8ef',
'\x8f\xa6': u'\ub8f1',
'\x8f\xa7': u'\ub8f2',
'\x8f\xa8': u'\ub8f3',
'\x8f\xa9': u'\ub8f4',
'\x8f\xaa': u'\ub8f5',
'\x8f\xab': u'\ub8f6',
'\x8f\xac': u'\ub8f7',
'\x8f\xad': u'\ub8fa',
'\x8f\xae': u'\ub8fc',
'\x8f\xaf': u'\ub8fe',
'\x8f\xb0': u'\ub8ff',
'\x8f\xb1': u'\ub900',
'\x8f\xb2': u'\ub901',
'\x8f\xb3': u'\ub902',
'\x8f\xb4': u'\ub903',
'\x8f\xb5': u'\ub905',
'\x8f\xb6': u'\ub906',
'\x8f\xb7': u'\ub907',
'\x8f\xb8': u'\ub908',
'\x8f\xb9': u'\ub909',
'\x8f\xba': u'\ub90a',
'\x8f\xbb': u'\ub90b',
'\x8f\xbc': u'\ub90c',
'\x8f\xbd': u'\ub90d',
'\x8f\xbe': u'\ub90e',
'\x8f\xbf': u'\ub90f',
'\x8f\xc0': u'\ub910',
'\x8f\xc1': u'\ub911',
'\x8f\xc2': u'\ub912',
'\x8f\xc3': u'\ub913',
'\x8f\xc4': u'\ub914',
'\x8f\xc5': u'\ub915',
'\x8f\xc6': u'\ub916',
'\x8f\xc7': u'\ub917',
'\x8f\xc8': u'\ub919',
'\x8f\xc9': u'\ub91a',
'\x8f\xca': u'\ub91b',
'\x8f\xcb': u'\ub91c',
'\x8f\xcc': u'\ub91d',
'\x8f\xcd': u'\ub91e',
'\x8f\xce': u'\ub91f',
'\x8f\xcf': u'\ub921',
'\x8f\xd0': u'\ub922',
'\x8f\xd1': u'\ub923',
'\x8f\xd2': u'\ub924',
'\x8f\xd3': u'\ub925',
'\x8f\xd4': u'\ub926',
'\x8f\xd5': u'\ub927',
'\x8f\xd6': u'\ub928',
'\x8f\xd7': u'\ub929',
'\x8f\xd8': u'\ub92a',
'\x8f\xd9': u'\ub92b',
'\x8f\xda': u'\ub92c',
'\x8f\xdb': u'\ub92d',
'\x8f\xdc': u'\ub92e',
'\x8f\xdd': u'\ub92f',
'\x8f\xde': u'\ub930',
'\x8f\xdf': u'\ub931',
'\x8f\xe0': u'\ub932',
'\x8f\xe1': u'\ub933',
'\x8f\xe2': u'\ub934',
'\x8f\xe3': u'\ub935',
'\x8f\xe4': u'\ub936',
'\x8f\xe5': u'\ub937',
'\x8f\xe6': u'\ub938',
'\x8f\xe7': u'\ub939',
'\x8f\xe8': u'\ub93a',
'\x8f\xe9': u'\ub93b',
'\x8f\xea': u'\ub93e',
'\x8f\xeb': u'\ub93f',
'\x8f\xec': u'\ub941',
'\x8f\xed': u'\ub942',
'\x8f\xee': u'\ub943',
'\x8f\xef': u'\ub945',
'\x8f\xf0': u'\ub946',
'\x8f\xf1': u'\ub947',
'\x8f\xf2': u'\ub948',
'\x8f\xf3': u'\ub949',
'\x8f\xf4': u'\ub94a',
'\x8f\xf5': u'\ub94b',
'\x8f\xf6': u'\ub94d',
'\x8f\xf7': u'\ub94e',
'\x8f\xf8': u'\ub950',
'\x8f\xf9': u'\ub952',
'\x8f\xfa': u'\ub953',
'\x8f\xfb': u'\ub954',
'\x8f\xfc': u'\ub955',
'\x8f\xfd': u'\ub956',
'\x8f\xfe': u'\ub957',
'\x8fa': u'\ub8a0',
'\x8fb': u'\ub8a1',
'\x8fc': u'\ub8a2',
'\x8fd': u'\ub8a3',
'\x8fe': u'\ub8a4',
'\x8ff': u'\ub8a5',
'\x8fg': u'\ub8a6',
'\x8fh': u'\ub8a7',
'\x8fi': u'\ub8a9',
'\x8fj': u'\ub8aa',
'\x8fk': u'\ub8ab',
'\x8fl': u'\ub8ac',
'\x8fm': u'\ub8ad',
'\x8fn': u'\ub8ae',
'\x8fo': u'\ub8af',
'\x8fp': u'\ub8b1',
'\x8fq': u'\ub8b2',
'\x8fr': u'\ub8b3',
'\x8fs': u'\ub8b5',
'\x8ft': u'\ub8b6',
'\x8fu': u'\ub8b7',
'\x8fv': u'\ub8b9',
'\x8fw': u'\ub8ba',
'\x8fx': u'\ub8bb',
'\x8fy': u'\ub8bc',
'\x8fz': u'\ub8bd',
'\x90A': u'\ub95a',
'\x90B': u'\ub95b',
'\x90C': u'\ub95d',
'\x90D': u'\ub95e',
'\x90E': u'\ub95f',
'\x90F': u'\ub961',
'\x90G': u'\ub962',
'\x90H': u'\ub963',
'\x90I': u'\ub964',
'\x90J': u'\ub965',
'\x90K': u'\ub966',
'\x90L': u'\ub967',
'\x90M': u'\ub96a',
'\x90N': u'\ub96c',
'\x90O': u'\ub96e',
'\x90P': u'\ub96f',
'\x90Q': u'\ub970',
'\x90R': u'\ub971',
'\x90S': u'\ub972',
'\x90T': u'\ub973',
'\x90U': u'\ub976',
'\x90V': u'\ub977',
'\x90W': u'\ub979',
'\x90X': u'\ub97a',
'\x90Y': u'\ub97b',
'\x90Z': u'\ub97d',
'\x90\x81': u'\ub99f',
'\x90\x82': u'\ub9a0',
'\x90\x83': u'\ub9a1',
'\x90\x84': u'\ub9a2',
'\x90\x85': u'\ub9a3',
'\x90\x86': u'\ub9a4',
'\x90\x87': u'\ub9a5',
'\x90\x88': u'\ub9a6',
'\x90\x89': u'\ub9a7',
'\x90\x8a': u'\ub9a8',
'\x90\x8b': u'\ub9a9',
'\x90\x8c': u'\ub9aa',
'\x90\x8d': u'\ub9ab',
'\x90\x8e': u'\ub9ae',
'\x90\x8f': u'\ub9af',
'\x90\x90': u'\ub9b1',
'\x90\x91': u'\ub9b2',
'\x90\x92': u'\ub9b3',
'\x90\x93': u'\ub9b5',
'\x90\x94': u'\ub9b6',
'\x90\x95': u'\ub9b7',
'\x90\x96': u'\ub9b8',
'\x90\x97': u'\ub9b9',
'\x90\x98': u'\ub9ba',
'\x90\x99': u'\ub9bb',
'\x90\x9a': u'\ub9be',
'\x90\x9b': u'\ub9c0',
'\x90\x9c': u'\ub9c2',
'\x90\x9d': u'\ub9c3',
'\x90\x9e': u'\ub9c4',
'\x90\x9f': u'\ub9c5',
'\x90\xa0': u'\ub9c6',
'\x90\xa1': u'\ub9c7',
'\x90\xa2': u'\ub9ca',
'\x90\xa3': u'\ub9cb',
'\x90\xa4': u'\ub9cd',
'\x90\xa5': u'\ub9d3',
'\x90\xa6': u'\ub9d4',
'\x90\xa7': u'\ub9d5',
'\x90\xa8': u'\ub9d6',
'\x90\xa9': u'\ub9d7',
'\x90\xaa': u'\ub9da',
'\x90\xab': u'\ub9dc',
'\x90\xac': u'\ub9df',
'\x90\xad': u'\ub9e0',
'\x90\xae': u'\ub9e2',
'\x90\xaf': u'\ub9e6',
'\x90\xb0': u'\ub9e7',
'\x90\xb1': u'\ub9e9',
'\x90\xb2': u'\ub9ea',
'\x90\xb3': u'\ub9eb',
'\x90\xb4': u'\ub9ed',
'\x90\xb5': u'\ub9ee',
'\x90\xb6': u'\ub9ef',
'\x90\xb7': u'\ub9f0',
'\x90\xb8': u'\ub9f1',
'\x90\xb9': u'\ub9f2',
'\x90\xba': u'\ub9f3',
'\x90\xbb': u'\ub9f6',
'\x90\xbc': u'\ub9fb',
'\x90\xbd': u'\ub9fc',
'\x90\xbe': u'\ub9fd',
'\x90\xbf': u'\ub9fe',
'\x90\xc0': u'\ub9ff',
'\x90\xc1': u'\uba02',
'\x90\xc2': u'\uba03',
'\x90\xc3': u'\uba04',
'\x90\xc4': u'\uba05',
'\x90\xc5': u'\uba06',
'\x90\xc6': u'\uba07',
'\x90\xc7': u'\uba09',
'\x90\xc8': u'\uba0a',
'\x90\xc9': u'\uba0b',
'\x90\xca': u'\uba0c',
'\x90\xcb': u'\uba0d',
'\x90\xcc': u'\uba0e',
'\x90\xcd': u'\uba0f',
'\x90\xce': u'\uba10',
'\x90\xcf': u'\uba11',
'\x90\xd0': u'\uba12',
'\x90\xd1': u'\uba13',
'\x90\xd2': u'\uba14',
'\x90\xd3': u'\uba16',
'\x90\xd4': u'\uba17',
'\x90\xd5': u'\uba18',
'\x90\xd6': u'\uba19',
'\x90\xd7': u'\uba1a',
'\x90\xd8': u'\uba1b',
'\x90\xd9': u'\uba1c',
'\x90\xda': u'\uba1d',
'\x90\xdb': u'\uba1e',
'\x90\xdc': u'\uba1f',
'\x90\xdd': u'\uba20',
'\x90\xde': u'\uba21',
'\x90\xdf': u'\uba22',
'\x90\xe0': u'\uba23',
'\x90\xe1': u'\uba24',
'\x90\xe2': u'\uba25',
'\x90\xe3': u'\uba26',
'\x90\xe4': u'\uba27',
'\x90\xe5': u'\uba28',
'\x90\xe6': u'\uba29',
'\x90\xe7': u'\uba2a',
'\x90\xe8': u'\uba2b',
'\x90\xe9': u'\uba2c',
'\x90\xea': u'\uba2d',
'\x90\xeb': u'\uba2e',
'\x90\xec': u'\uba2f',
'\x90\xed': u'\uba30',
'\x90\xee': u'\uba31',
'\x90\xef': u'\uba32',
'\x90\xf0': u'\uba33',
'\x90\xf1': u'\uba34',
'\x90\xf2': u'\uba35',
'\x90\xf3': u'\uba36',
'\x90\xf4': u'\uba37',
'\x90\xf5': u'\uba3a',
'\x90\xf6': u'\uba3b',
'\x90\xf7': u'\uba3d',
'\x90\xf8': u'\uba3e',
'\x90\xf9': u'\uba3f',
'\x90\xfa': u'\uba41',
'\x90\xfb': u'\uba43',
'\x90\xfc': u'\uba44',
'\x90\xfd': u'\uba45',
'\x90\xfe': u'\uba46',
'\x90a': u'\ub97e',
'\x90b': u'\ub97f',
'\x90c': u'\ub980',
'\x90d': u'\ub981',
'\x90e': u'\ub982',
'\x90f': u'\ub983',
'\x90g': u'\ub986',
'\x90h': u'\ub988',
'\x90i': u'\ub98b',
'\x90j': u'\ub98c',
'\x90k': u'\ub98f',
'\x90l': u'\ub990',
'\x90m': u'\ub991',
'\x90n': u'\ub992',
'\x90o': u'\ub993',
'\x90p': u'\ub994',
'\x90q': u'\ub995',
'\x90r': u'\ub996',
'\x90s': u'\ub997',
'\x90t': u'\ub998',
'\x90u': u'\ub999',
'\x90v': u'\ub99a',
'\x90w': u'\ub99b',
'\x90x': u'\ub99c',
'\x90y': u'\ub99d',
'\x90z': u'\ub99e',
'\x91A': u'\uba47',
'\x91B': u'\uba4a',
'\x91C': u'\uba4c',
'\x91D': u'\uba4f',
'\x91E': u'\uba50',
'\x91F': u'\uba51',
'\x91G': u'\uba52',
'\x91H': u'\uba56',
'\x91I': u'\uba57',
'\x91J': u'\uba59',
'\x91K': u'\uba5a',
'\x91L': u'\uba5b',
'\x91M': u'\uba5d',
'\x91N': u'\uba5e',
'\x91O': u'\uba5f',
'\x91P': u'\uba60',
'\x91Q': u'\uba61',
'\x91R': u'\uba62',
'\x91S': u'\uba63',
'\x91T': u'\uba66',
'\x91U': u'\uba6a',
'\x91V': u'\uba6b',
'\x91W': u'\uba6c',
'\x91X': u'\uba6d',
'\x91Y': u'\uba6e',
'\x91Z': u'\uba6f',
'\x91\x81': u'\uba93',
'\x91\x82': u'\uba94',
'\x91\x83': u'\uba95',
'\x91\x84': u'\uba96',
'\x91\x85': u'\uba97',
'\x91\x86': u'\uba98',
'\x91\x87': u'\uba99',
'\x91\x88': u'\uba9a',
'\x91\x89': u'\uba9b',
'\x91\x8a': u'\uba9c',
'\x91\x8b': u'\uba9d',
'\x91\x8c': u'\uba9e',
'\x91\x8d': u'\uba9f',
'\x91\x8e': u'\ubaa0',
'\x91\x8f': u'\ubaa1',
'\x91\x90': u'\ubaa2',
'\x91\x91': u'\ubaa3',
'\x91\x92': u'\ubaa4',
'\x91\x93': u'\ubaa5',
'\x91\x94': u'\ubaa6',
'\x91\x95': u'\ubaa7',
'\x91\x96': u'\ubaaa',
'\x91\x97': u'\ubaad',
'\x91\x98': u'\ubaae',
'\x91\x99': u'\ubaaf',
'\x91\x9a': u'\ubab1',
'\x91\x9b': u'\ubab3',
'\x91\x9c': u'\ubab4',
'\x91\x9d': u'\ubab5',
'\x91\x9e': u'\ubab6',
'\x91\x9f': u'\ubab7',
'\x91\xa0': u'\ubaba',
'\x91\xa1': u'\ubabc',
'\x91\xa2': u'\ubabe',
'\x91\xa3': u'\ubabf',
'\x91\xa4': u'\ubac0',
'\x91\xa5': u'\ubac1',
'\x91\xa6': u'\ubac2',
'\x91\xa7': u'\ubac3',
'\x91\xa8': u'\ubac5',
'\x91\xa9': u'\ubac6',
'\x91\xaa': u'\ubac7',
'\x91\xab': u'\ubac9',
'\x91\xac': u'\ubaca',
'\x91\xad': u'\ubacb',
'\x91\xae': u'\ubacc',
'\x91\xaf': u'\ubacd',
'\x91\xb0': u'\ubace',
'\x91\xb1': u'\ubacf',
'\x91\xb2': u'\ubad0',
'\x91\xb3': u'\ubad1',
'\x91\xb4': u'\ubad2',
'\x91\xb5': u'\ubad3',
'\x91\xb6': u'\ubad4',
'\x91\xb7': u'\ubad5',
'\x91\xb8': u'\ubad6',
'\x91\xb9': u'\ubad7',
'\x91\xba': u'\ubada',
'\x91\xbb': u'\ubadb',
'\x91\xbc': u'\ubadc',
'\x91\xbd': u'\ubadd',
'\x91\xbe': u'\ubade',
'\x91\xbf': u'\ubadf',
'\x91\xc0': u'\ubae0',
'\x91\xc1': u'\ubae1',
'\x91\xc2': u'\ubae2',
'\x91\xc3': u'\ubae3',
'\x91\xc4': u'\ubae4',
'\x91\xc5': u'\ubae5',
'\x91\xc6': u'\ubae6',
'\x91\xc7': u'\ubae7',
'\x91\xc8': u'\ubae8',
'\x91\xc9': u'\ubae9',
'\x91\xca': u'\ubaea',
'\x91\xcb': u'\ubaeb',
'\x91\xcc': u'\ubaec',
'\x91\xcd': u'\ubaed',
'\x91\xce': u'\ubaee',
'\x91\xcf': u'\ubaef',
'\x91\xd0': u'\ubaf0',
'\x91\xd1': u'\ubaf1',
'\x91\xd2': u'\ubaf2',
'\x91\xd3': u'\ubaf3',
'\x91\xd4': u'\ubaf4',
'\x91\xd5': u'\ubaf5',
'\x91\xd6': u'\ubaf6',
'\x91\xd7': u'\ubaf7',
'\x91\xd8': u'\ubaf8',
'\x91\xd9': u'\ubaf9',
'\x91\xda': u'\ubafa',
'\x91\xdb': u'\ubafb',
'\x91\xdc': u'\ubafd',
'\x91\xdd': u'\ubafe',
'\x91\xde': u'\ubaff',
'\x91\xdf': u'\ubb01',
'\x91\xe0': u'\ubb02',
'\x91\xe1': u'\ubb03',
'\x91\xe2': u'\ubb05',
'\x91\xe3': u'\ubb06',
'\x91\xe4': u'\ubb07',
'\x91\xe5': u'\ubb08',
'\x91\xe6': u'\ubb09',
'\x91\xe7': u'\ubb0a',
'\x91\xe8': u'\ubb0b',
'\x91\xe9': u'\ubb0c',
'\x91\xea': u'\ubb0e',
'\x91\xeb': u'\ubb10',
'\x91\xec': u'\ubb12',
'\x91\xed': u'\ubb13',
'\x91\xee': u'\ubb14',
'\x91\xef': u'\ubb15',
'\x91\xf0': u'\ubb16',
'\x91\xf1': u'\ubb17',
'\x91\xf2': u'\ubb19',
'\x91\xf3': u'\ubb1a',
'\x91\xf4': u'\ubb1b',
'\x91\xf5': u'\ubb1d',
'\x91\xf6': u'\ubb1e',
'\x91\xf7': u'\ubb1f',
'\x91\xf8': u'\ubb21',
'\x91\xf9': u'\ubb22',
'\x91\xfa': u'\ubb23',
'\x91\xfb': u'\ubb24',
'\x91\xfc': u'\ubb25',
'\x91\xfd': u'\ubb26',
'\x91\xfe': u'\ubb27',
'\x91a': u'\uba72',
'\x91b': u'\uba73',
'\x91c': u'\uba75',
'\x91d': u'\uba76',
'\x91e': u'\uba77',
'\x91f': u'\uba79',
'\x91g': u'\uba7a',
'\x91h': u'\uba7b',
'\x91i': u'\uba7c',
'\x91j': u'\uba7d',
'\x91k': u'\uba7e',
'\x91l': u'\uba7f',
'\x91m': u'\uba80',
'\x91n': u'\uba81',
'\x91o': u'\uba82',
'\x91p': u'\uba86',
'\x91q': u'\uba88',
'\x91r': u'\uba89',
'\x91s': u'\uba8a',
'\x91t': u'\uba8b',
'\x91u': u'\uba8d',
'\x91v': u'\uba8e',
'\x91w': u'\uba8f',
'\x91x': u'\uba90',
'\x91y': u'\uba91',
'\x91z': u'\uba92',
'\x92A': u'\ubb28',
'\x92B': u'\ubb2a',
'\x92C': u'\ubb2c',
'\x92D': u'\ubb2d',
'\x92E': u'\ubb2e',
'\x92F': u'\ubb2f',
'\x92G': u'\ubb30',
'\x92H': u'\ubb31',
'\x92I': u'\ubb32',
'\x92J': u'\ubb33',
'\x92K': u'\ubb37',
'\x92L': u'\ubb39',
'\x92M': u'\ubb3a',
'\x92N': u'\ubb3f',
'\x92O': u'\ubb40',
'\x92P': u'\ubb41',
'\x92Q': u'\ubb42',
'\x92R': u'\ubb43',
'\x92S': u'\ubb46',
'\x92T': u'\ubb48',
'\x92U': u'\ubb4a',
'\x92V': u'\ubb4b',
'\x92W': u'\ubb4c',
'\x92X': u'\ubb4e',
'\x92Y': u'\ubb51',
'\x92Z': u'\ubb52',
'\x92\x81': u'\ubb72',
'\x92\x82': u'\ubb73',
'\x92\x83': u'\ubb74',
'\x92\x84': u'\ubb75',
'\x92\x85': u'\ubb76',
'\x92\x86': u'\ubb77',
'\x92\x87': u'\ubb78',
'\x92\x88': u'\ubb79',
'\x92\x89': u'\ubb7a',
'\x92\x8a': u'\ubb7b',
'\x92\x8b': u'\ubb7c',
'\x92\x8c': u'\ubb7d',
'\x92\x8d': u'\ubb7e',
'\x92\x8e': u'\ubb7f',
'\x92\x8f': u'\ubb80',
'\x92\x90': u'\ubb81',
'\x92\x91': u'\ubb82',
'\x92\x92': u'\ubb83',
'\x92\x93': u'\ubb84',
'\x92\x94': u'\ubb85',
'\x92\x95': u'\ubb86',
'\x92\x96': u'\ubb87',
'\x92\x97': u'\ubb89',
'\x92\x98': u'\ubb8a',
'\x92\x99': u'\ubb8b',
'\x92\x9a': u'\ubb8d',
'\x92\x9b': u'\ubb8e',
'\x92\x9c': u'\ubb8f',
'\x92\x9d': u'\ubb91',
'\x92\x9e': u'\ubb92',
'\x92\x9f': u'\ubb93',
'\x92\xa0': u'\ubb94',
'\x92\xa1': u'\ubb95',
'\x92\xa2': u'\ubb96',
'\x92\xa3': u'\ubb97',
'\x92\xa4': u'\ubb98',
'\x92\xa5': u'\ubb99',
'\x92\xa6': u'\ubb9a',
'\x92\xa7': u'\ubb9b',
'\x92\xa8': u'\ubb9c',
'\x92\xa9': u'\ubb9d',
'\x92\xaa': u'\ubb9e',
'\x92\xab': u'\ubb9f',
'\x92\xac': u'\ubba0',
'\x92\xad': u'\ubba1',
'\x92\xae': u'\ubba2',
'\x92\xaf': u'\ubba3',
'\x92\xb0': u'\ubba5',
'\x92\xb1': u'\ubba6',
'\x92\xb2': u'\ubba7',
'\x92\xb3': u'\ubba9',
'\x92\xb4': u'\ubbaa',
'\x92\xb5': u'\ubbab',
'\x92\xb6': u'\ubbad',
'\x92\xb7': u'\ubbae',
'\x92\xb8': u'\ubbaf',
'\x92\xb9': u'\ubbb0',
'\x92\xba': u'\ubbb1',
'\x92\xbb': u'\ubbb2',
'\x92\xbc': u'\ubbb3',
'\x92\xbd': u'\ubbb5',
'\x92\xbe': u'\ubbb6',
'\x92\xbf': u'\ubbb8',
'\x92\xc0': u'\ubbb9',
'\x92\xc1': u'\ubbba',
'\x92\xc2': u'\ubbbb',
'\x92\xc3': u'\ubbbc',
'\x92\xc4': u'\ubbbd',
'\x92\xc5': u'\ubbbe',
'\x92\xc6': u'\ubbbf',
'\x92\xc7': u'\ubbc1',
'\x92\xc8': u'\ubbc2',
'\x92\xc9': u'\ubbc3',
'\x92\xca': u'\ubbc5',
'\x92\xcb': u'\ubbc6',
'\x92\xcc': u'\ubbc7',
'\x92\xcd': u'\ubbc9',
'\x92\xce': u'\ubbca',
'\x92\xcf': u'\ubbcb',
'\x92\xd0': u'\ubbcc',
'\x92\xd1': u'\ubbcd',
'\x92\xd2': u'\ubbce',
'\x92\xd3': u'\ubbcf',
'\x92\xd4': u'\ubbd1',
'\x92\xd5': u'\ubbd2',
'\x92\xd6': u'\ubbd4',
'\x92\xd7': u'\ubbd5',
'\x92\xd8': u'\ubbd6',
'\x92\xd9': u'\ubbd7',
'\x92\xda': u'\ubbd8',
'\x92\xdb': u'\ubbd9',
'\x92\xdc': u'\ubbda',
'\x92\xdd': u'\ubbdb',
'\x92\xde': u'\ubbdc',
'\x92\xdf': u'\ubbdd',
'\x92\xe0': u'\ubbde',
'\x92\xe1': u'\ubbdf',
'\x92\xe2': u'\ubbe0',
'\x92\xe3': u'\ubbe1',
'\x92\xe4': u'\ubbe2',
'\x92\xe5': u'\ubbe3',
'\x92\xe6': u'\ubbe4',
'\x92\xe7': u'\ubbe5',
'\x92\xe8': u'\ubbe6',
'\x92\xe9': u'\ubbe7',
'\x92\xea': u'\ubbe8',
'\x92\xeb': u'\ubbe9',
'\x92\xec': u'\ubbea',
'\x92\xed': u'\ubbeb',
'\x92\xee': u'\ubbec',
'\x92\xef': u'\ubbed',
'\x92\xf0': u'\ubbee',
'\x92\xf1': u'\ubbef',
'\x92\xf2': u'\ubbf0',
'\x92\xf3': u'\ubbf1',
'\x92\xf4': u'\ubbf2',
'\x92\xf5': u'\ubbf3',
'\x92\xf6': u'\ubbf4',
'\x92\xf7': u'\ubbf5',
'\x92\xf8': u'\ubbf6',
'\x92\xf9': u'\ubbf7',
'\x92\xfa': u'\ubbfa',
'\x92\xfb': u'\ubbfb',
'\x92\xfc': u'\ubbfd',
'\x92\xfd': u'\ubbfe',
'\x92\xfe': u'\ubc01',
'\x92a': u'\ubb53',
'\x92b': u'\ubb55',
'\x92c': u'\ubb56',
'\x92d': u'\ubb57',
'\x92e': u'\ubb59',
'\x92f': u'\ubb5a',
'\x92g': u'\ubb5b',
'\x92h': u'\ubb5c',
'\x92i': u'\ubb5d',
'\x92j': u'\ubb5e',
'\x92k': u'\ubb5f',
'\x92l': u'\ubb60',
'\x92m': u'\ubb62',
'\x92n': u'\ubb64',
'\x92o': u'\ubb65',
'\x92p': u'\ubb66',
'\x92q': u'\ubb67',
'\x92r': u'\ubb68',
'\x92s': u'\ubb69',
'\x92t': u'\ubb6a',
'\x92u': u'\ubb6b',
'\x92v': u'\ubb6d',
'\x92w': u'\ubb6e',
'\x92x': u'\ubb6f',
'\x92y': u'\ubb70',
'\x92z': u'\ubb71',
'\x93A': u'\ubc03',
'\x93B': u'\ubc04',
'\x93C': u'\ubc05',
'\x93D': u'\ubc06',
'\x93E': u'\ubc07',
'\x93F': u'\ubc0a',
'\x93G': u'\ubc0e',
'\x93H': u'\ubc10',
'\x93I': u'\ubc12',
'\x93J': u'\ubc13',
'\x93K': u'\ubc19',
'\x93L': u'\ubc1a',
'\x93M': u'\ubc20',
'\x93N': u'\ubc21',
'\x93O': u'\ubc22',
'\x93P': u'\ubc23',
'\x93Q': u'\ubc26',
'\x93R': u'\ubc28',
'\x93S': u'\ubc2a',
'\x93T': u'\ubc2b',
'\x93U': u'\ubc2c',
'\x93V': u'\ubc2e',
'\x93W': u'\ubc2f',
'\x93X': u'\ubc32',
'\x93Y': u'\ubc33',
'\x93Z': u'\ubc35',
'\x93\x81': u'\ubc5a',
'\x93\x82': u'\ubc5b',
'\x93\x83': u'\ubc5c',
'\x93\x84': u'\ubc5e',
'\x93\x85': u'\ubc5f',
'\x93\x86': u'\ubc60',
'\x93\x87': u'\ubc61',
'\x93\x88': u'\ubc62',
'\x93\x89': u'\ubc63',
'\x93\x8a': u'\ubc64',
'\x93\x8b': u'\ubc65',
'\x93\x8c': u'\ubc66',
'\x93\x8d': u'\ubc67',
'\x93\x8e': u'\ubc68',
'\x93\x8f': u'\ubc69',
'\x93\x90': u'\ubc6a',
'\x93\x91': u'\ubc6b',
'\x93\x92': u'\ubc6c',
'\x93\x93': u'\ubc6d',
'\x93\x94': u'\ubc6e',
'\x93\x95': u'\ubc6f',
'\x93\x96': u'\ubc70',
'\x93\x97': u'\ubc71',
'\x93\x98': u'\ubc72',
'\x93\x99': u'\ubc73',
'\x93\x9a': u'\ubc74',
'\x93\x9b': u'\ubc75',
'\x93\x9c': u'\ubc76',
'\x93\x9d': u'\ubc77',
'\x93\x9e': u'\ubc78',
'\x93\x9f': u'\ubc79',
'\x93\xa0': u'\ubc7a',
'\x93\xa1': u'\ubc7b',
'\x93\xa2': u'\ubc7c',
'\x93\xa3': u'\ubc7d',
'\x93\xa4': u'\ubc7e',
'\x93\xa5': u'\ubc7f',
'\x93\xa6': u'\ubc80',
'\x93\xa7': u'\ubc81',
'\x93\xa8': u'\ubc82',
'\x93\xa9': u'\ubc83',
'\x93\xaa': u'\ubc86',
'\x93\xab': u'\ubc87',
'\x93\xac': u'\ubc89',
'\x93\xad': u'\ubc8a',
'\x93\xae': u'\ubc8d',
'\x93\xaf': u'\ubc8f',
'\x93\xb0': u'\ubc90',
'\x93\xb1': u'\ubc91',
'\x93\xb2': u'\ubc92',
'\x93\xb3': u'\ubc93',
'\x93\xb4': u'\ubc96',
'\x93\xb5': u'\ubc98',
'\x93\xb6': u'\ubc9b',
'\x93\xb7': u'\ubc9c',
'\x93\xb8': u'\ubc9d',
'\x93\xb9': u'\ubc9e',
'\x93\xba': u'\ubc9f',
'\x93\xbb': u'\ubca2',
'\x93\xbc': u'\ubca3',
'\x93\xbd': u'\ubca5',
'\x93\xbe': u'\ubca6',
'\x93\xbf': u'\ubca9',
'\x93\xc0': u'\ubcaa',
'\x93\xc1': u'\ubcab',
'\x93\xc2': u'\ubcac',
'\x93\xc3': u'\ubcad',
'\x93\xc4': u'\ubcae',
'\x93\xc5': u'\ubcaf',
'\x93\xc6': u'\ubcb2',
'\x93\xc7': u'\ubcb6',
'\x93\xc8': u'\ubcb7',
'\x93\xc9': u'\ubcb8',
'\x93\xca': u'\ubcb9',
'\x93\xcb': u'\ubcba',
'\x93\xcc': u'\ubcbb',
'\x93\xcd': u'\ubcbe',
'\x93\xce': u'\ubcbf',
'\x93\xcf': u'\ubcc1',
'\x93\xd0': u'\ubcc2',
'\x93\xd1': u'\ubcc3',
'\x93\xd2': u'\ubcc5',
'\x93\xd3': u'\ubcc6',
'\x93\xd4': u'\ubcc7',
'\x93\xd5': u'\ubcc8',
'\x93\xd6': u'\ubcc9',
'\x93\xd7': u'\ubcca',
'\x93\xd8': u'\ubccb',
'\x93\xd9': u'\ubccc',
'\x93\xda': u'\ubcce',
'\x93\xdb': u'\ubcd2',
'\x93\xdc': u'\ubcd3',
'\x93\xdd': u'\ubcd4',
'\x93\xde': u'\ubcd6',
'\x93\xdf': u'\ubcd7',
'\x93\xe0': u'\ubcd9',
'\x93\xe1': u'\ubcda',
'\x93\xe2': u'\ubcdb',
'\x93\xe3': u'\ubcdd',
'\x93\xe4': u'\ubcde',
'\x93\xe5': u'\ubcdf',
'\x93\xe6': u'\ubce0',
'\x93\xe7': u'\ubce1',
'\x93\xe8': u'\ubce2',
'\x93\xe9': u'\ubce3',
'\x93\xea': u'\ubce4',
'\x93\xeb': u'\ubce5',
'\x93\xec': u'\ubce6',
'\x93\xed': u'\ubce7',
'\x93\xee': u'\ubce8',
'\x93\xef': u'\ubce9',
'\x93\xf0': u'\ubcea',
'\x93\xf1': u'\ubceb',
'\x93\xf2': u'\ubcec',
'\x93\xf3': u'\ubced',
'\x93\xf4': u'\ubcee',
'\x93\xf5': u'\ubcef',
'\x93\xf6': u'\ubcf0',
'\x93\xf7': u'\ubcf1',
'\x93\xf8': u'\ubcf2',
'\x93\xf9': u'\ubcf3',
'\x93\xfa': u'\ubcf7',
'\x93\xfb': u'\ubcf9',
'\x93\xfc': u'\ubcfa',
'\x93\xfd': u'\ubcfb',
'\x93\xfe': u'\ubcfd',
'\x93a': u'\ubc36',
'\x93b': u'\ubc37',
'\x93c': u'\ubc39',
'\x93d': u'\ubc3a',
'\x93e': u'\ubc3b',
'\x93f': u'\ubc3c',
'\x93g': u'\ubc3d',
'\x93h': u'\ubc3e',
'\x93i': u'\ubc3f',
'\x93j': u'\ubc42',
'\x93k': u'\ubc46',
'\x93l': u'\ubc47',
'\x93m': u'\ubc48',
'\x93n': u'\ubc4a',
'\x93o': u'\ubc4b',
'\x93p': u'\ubc4e',
'\x93q': u'\ubc4f',
'\x93r': u'\ubc51',
'\x93s': u'\ubc52',
'\x93t': u'\ubc53',
'\x93u': u'\ubc54',
'\x93v': u'\ubc55',
'\x93w': u'\ubc56',
'\x93x': u'\ubc57',
'\x93y': u'\ubc58',
'\x93z': u'\ubc59',
'\x94A': u'\ubcfe',
'\x94B': u'\ubcff',
'\x94C': u'\ubd00',
'\x94D': u'\ubd01',
'\x94E': u'\ubd02',
'\x94F': u'\ubd03',
'\x94G': u'\ubd06',
'\x94H': u'\ubd08',
'\x94I': u'\ubd0a',
'\x94J': u'\ubd0b',
'\x94K': u'\ubd0c',
'\x94L': u'\ubd0d',
'\x94M': u'\ubd0e',
'\x94N': u'\ubd0f',
'\x94O': u'\ubd11',
'\x94P': u'\ubd12',
'\x94Q': u'\ubd13',
'\x94R': u'\ubd15',
'\x94S': u'\ubd16',
'\x94T': u'\ubd17',
'\x94U': u'\ubd18',
'\x94V': u'\ubd19',
'\x94W': u'\ubd1a',
'\x94X': u'\ubd1b',
'\x94Y': u'\ubd1c',
'\x94Z': u'\ubd1d',
'\x94\x81': u'\ubd3a',
'\x94\x82': u'\ubd3b',
'\x94\x83': u'\ubd3c',
'\x94\x84': u'\ubd3d',
'\x94\x85': u'\ubd3e',
'\x94\x86': u'\ubd3f',
'\x94\x87': u'\ubd41',
'\x94\x88': u'\ubd42',
'\x94\x89': u'\ubd43',
'\x94\x8a': u'\ubd44',
'\x94\x8b': u'\ubd45',
'\x94\x8c': u'\ubd46',
'\x94\x8d': u'\ubd47',
'\x94\x8e': u'\ubd4a',
'\x94\x8f': u'\ubd4b',
'\x94\x90': u'\ubd4d',
'\x94\x91': u'\ubd4e',
'\x94\x92': u'\ubd4f',
'\x94\x93': u'\ubd51',
'\x94\x94': u'\ubd52',
'\x94\x95': u'\ubd53',
'\x94\x96': u'\ubd54',
'\x94\x97': u'\ubd55',
'\x94\x98': u'\ubd56',
'\x94\x99': u'\ubd57',
'\x94\x9a': u'\ubd5a',
'\x94\x9b': u'\ubd5b',
'\x94\x9c': u'\ubd5c',
'\x94\x9d': u'\ubd5d',
'\x94\x9e': u'\ubd5e',
'\x94\x9f': u'\ubd5f',
'\x94\xa0': u'\ubd60',
'\x94\xa1': u'\ubd61',
'\x94\xa2': u'\ubd62',
'\x94\xa3': u'\ubd63',
'\x94\xa4': u'\ubd65',
'\x94\xa5': u'\ubd66',
'\x94\xa6': u'\ubd67',
'\x94\xa7': u'\ubd69',
'\x94\xa8': u'\ubd6a',
'\x94\xa9': u'\ubd6b',
'\x94\xaa': u'\ubd6c',
'\x94\xab': u'\ubd6d',
'\x94\xac': u'\ubd6e',
'\x94\xad': u'\ubd6f',
'\x94\xae': u'\ubd70',
'\x94\xaf': u'\ubd71',
'\x94\xb0': u'\ubd72',
'\x94\xb1': u'\ubd73',
'\x94\xb2': u'\ubd74',
'\x94\xb3': u'\ubd75',
'\x94\xb4': u'\ubd76',
'\x94\xb5': u'\ubd77',
'\x94\xb6': u'\ubd78',
'\x94\xb7': u'\ubd79',
'\x94\xb8': u'\ubd7a',
'\x94\xb9': u'\ubd7b',
'\x94\xba': u'\ubd7c',
'\x94\xbb': u'\ubd7d',
'\x94\xbc': u'\ubd7e',
'\x94\xbd': u'\ubd7f',
'\x94\xbe': u'\ubd82',
'\x94\xbf': u'\ubd83',
'\x94\xc0': u'\ubd85',
'\x94\xc1': u'\ubd86',
'\x94\xc2': u'\ubd8b',
'\x94\xc3': u'\ubd8c',
'\x94\xc4': u'\ubd8d',
'\x94\xc5': u'\ubd8e',
'\x94\xc6': u'\ubd8f',
'\x94\xc7': u'\ubd92',
'\x94\xc8': u'\ubd94',
'\x94\xc9': u'\ubd96',
'\x94\xca': u'\ubd97',
'\x94\xcb': u'\ubd98',
'\x94\xcc': u'\ubd9b',
'\x94\xcd': u'\ubd9d',
'\x94\xce': u'\ubd9e',
'\x94\xcf': u'\ubd9f',
'\x94\xd0': u'\ubda0',
'\x94\xd1': u'\ubda1',
'\x94\xd2': u'\ubda2',
'\x94\xd3': u'\ubda3',
'\x94\xd4': u'\ubda5',
'\x94\xd5': u'\ubda6',
'\x94\xd6': u'\ubda7',
'\x94\xd7': u'\ubda8',
'\x94\xd8': u'\ubda9',
'\x94\xd9': u'\ubdaa',
'\x94\xda': u'\ubdab',
'\x94\xdb': u'\ubdac',
'\x94\xdc': u'\ubdad',
'\x94\xdd': u'\ubdae',
'\x94\xde': u'\ubdaf',
'\x94\xdf': u'\ubdb1',
'\x94\xe0': u'\ubdb2',
'\x94\xe1': u'\ubdb3',
'\x94\xe2': u'\ubdb4',
'\x94\xe3': u'\ubdb5',
'\x94\xe4': u'\ubdb6',
'\x94\xe5': u'\ubdb7',
'\x94\xe6': u'\ubdb9',
'\x94\xe7': u'\ubdba',
'\x94\xe8': u'\ubdbb',
'\x94\xe9': u'\ubdbc',
'\x94\xea': u'\ubdbd',
'\x94\xeb': u'\ubdbe',
'\x94\xec': u'\ubdbf',
'\x94\xed': u'\ubdc0',
'\x94\xee': u'\ubdc1',
'\x94\xef': u'\ubdc2',
'\x94\xf0': u'\ubdc3',
'\x94\xf1': u'\ubdc4',
'\x94\xf2': u'\ubdc5',
'\x94\xf3': u'\ubdc6',
'\x94\xf4': u'\ubdc7',
'\x94\xf5': u'\ubdc8',
'\x94\xf6': u'\ubdc9',
'\x94\xf7': u'\ubdca',
'\x94\xf8': u'\ubdcb',
'\x94\xf9': u'\ubdcc',
'\x94\xfa': u'\ubdcd',
'\x94\xfb': u'\ubdce',
'\x94\xfc': u'\ubdcf',
'\x94\xfd': u'\ubdd0',
'\x94\xfe': u'\ubdd1',
'\x94a': u'\ubd1e',
'\x94b': u'\ubd1f',
'\x94c': u'\ubd20',
'\x94d': u'\ubd21',
'\x94e': u'\ubd22',
'\x94f': u'\ubd23',
'\x94g': u'\ubd25',
'\x94h': u'\ubd26',
'\x94i': u'\ubd27',
'\x94j': u'\ubd28',
'\x94k': u'\ubd29',
'\x94l': u'\ubd2a',
'\x94m': u'\ubd2b',
'\x94n': u'\ubd2d',
'\x94o': u'\ubd2e',
'\x94p': u'\ubd2f',
'\x94q': u'\ubd30',
'\x94r': u'\ubd31',
'\x94s': u'\ubd32',
'\x94t': u'\ubd33',
'\x94u': u'\ubd34',
'\x94v': u'\ubd35',
'\x94w': u'\ubd36',
'\x94x': u'\ubd37',
'\x94y': u'\ubd38',
'\x94z': u'\ubd39',
'\x95A': u'\ubdd2',
'\x95B': u'\ubdd3',
'\x95C': u'\ubdd6',
'\x95D': u'\ubdd7',
'\x95E': u'\ubdd9',
'\x95F': u'\ubdda',
'\x95G': u'\ubddb',
'\x95H': u'\ubddd',
'\x95I': u'\ubdde',
'\x95J': u'\ubddf',
'\x95K': u'\ubde0',
'\x95L': u'\ubde1',
'\x95M': u'\ubde2',
'\x95N': u'\ubde3',
'\x95O': u'\ubde4',
'\x95P': u'\ubde5',
'\x95Q': u'\ubde6',
'\x95R': u'\ubde7',
'\x95S': u'\ubde8',
'\x95T': u'\ubdea',
'\x95U': u'\ubdeb',
'\x95V': u'\ubdec',
'\x95W': u'\ubded',
'\x95X': u'\ubdee',
'\x95Y': u'\ubdef',
'\x95Z': u'\ubdf1',
'\x95\x81': u'\ube15',
'\x95\x82': u'\ube16',
'\x95\x83': u'\ube17',
'\x95\x84': u'\ube18',
'\x95\x85': u'\ube19',
'\x95\x86': u'\ube1a',
'\x95\x87': u'\ube1b',
'\x95\x88': u'\ube1e',
'\x95\x89': u'\ube20',
'\x95\x8a': u'\ube21',
'\x95\x8b': u'\ube22',
'\x95\x8c': u'\ube23',
'\x95\x8d': u'\ube24',
'\x95\x8e': u'\ube25',
'\x95\x8f': u'\ube26',
'\x95\x90': u'\ube27',
'\x95\x91': u'\ube28',
'\x95\x92': u'\ube29',
'\x95\x93': u'\ube2a',
'\x95\x94': u'\ube2b',
'\x95\x95': u'\ube2c',
'\x95\x96': u'\ube2d',
'\x95\x97': u'\ube2e',
'\x95\x98': u'\ube2f',
'\x95\x99': u'\ube30',
'\x95\x9a': u'\ube31',
'\x95\x9b': u'\ube32',
'\x95\x9c': u'\ube33',
'\x95\x9d': u'\ube34',
'\x95\x9e': u'\ube35',
'\x95\x9f': u'\ube36',
'\x95\xa0': u'\ube37',
'\x95\xa1': u'\ube38',
'\x95\xa2': u'\ube39',
'\x95\xa3': u'\ube3a',
'\x95\xa4': u'\ube3b',
'\x95\xa5': u'\ube3c',
'\x95\xa6': u'\ube3d',
'\x95\xa7': u'\ube3e',
'\x95\xa8': u'\ube3f',
'\x95\xa9': u'\ube40',
'\x95\xaa': u'\ube41',
'\x95\xab': u'\ube42',
'\x95\xac': u'\ube43',
'\x95\xad': u'\ube46',
'\x95\xae': u'\ube47',
'\x95\xaf': u'\ube49',
'\x95\xb0': u'\ube4a',
'\x95\xb1': u'\ube4b',
'\x95\xb2': u'\ube4d',
'\x95\xb3': u'\ube4f',
'\x95\xb4': u'\ube50',
'\x95\xb5': u'\ube51',
'\x95\xb6': u'\ube52',
'\x95\xb7': u'\ube53',
'\x95\xb8': u'\ube56',
'\x95\xb9': u'\ube58',
'\x95\xba': u'\ube5c',
'\x95\xbb': u'\ube5d',
'\x95\xbc': u'\ube5e',
'\x95\xbd': u'\ube5f',
'\x95\xbe': u'\ube62',
'\x95\xbf': u'\ube63',
'\x95\xc0': u'\ube65',
'\x95\xc1': u'\ube66',
'\x95\xc2': u'\ube67',
'\x95\xc3': u'\ube69',
'\x95\xc4': u'\ube6b',
'\x95\xc5': u'\ube6c',
'\x95\xc6': u'\ube6d',
'\x95\xc7': u'\ube6e',
'\x95\xc8': u'\ube6f',
'\x95\xc9': u'\ube72',
'\x95\xca': u'\ube76',
'\x95\xcb': u'\ube77',
'\x95\xcc': u'\ube78',
'\x95\xcd': u'\ube79',
'\x95\xce': u'\ube7a',
'\x95\xcf': u'\ube7e',
'\x95\xd0': u'\ube7f',
'\x95\xd1': u'\ube81',
'\x95\xd2': u'\ube82',
'\x95\xd3': u'\ube83',
'\x95\xd4': u'\ube85',
'\x95\xd5': u'\ube86',
'\x95\xd6': u'\ube87',
'\x95\xd7': u'\ube88',
'\x95\xd8': u'\ube89',
'\x95\xd9': u'\ube8a',
'\x95\xda': u'\ube8b',
'\x95\xdb': u'\ube8e',
'\x95\xdc': u'\ube92',
'\x95\xdd': u'\ube93',
'\x95\xde': u'\ube94',
'\x95\xdf': u'\ube95',
'\x95\xe0': u'\ube96',
'\x95\xe1': u'\ube97',
'\x95\xe2': u'\ube9a',
'\x95\xe3': u'\ube9b',
'\x95\xe4': u'\ube9c',
'\x95\xe5': u'\ube9d',
'\x95\xe6': u'\ube9e',
'\x95\xe7': u'\ube9f',
'\x95\xe8': u'\ubea0',
'\x95\xe9': u'\ubea1',
'\x95\xea': u'\ubea2',
'\x95\xeb': u'\ubea3',
'\x95\xec': u'\ubea4',
'\x95\xed': u'\ubea5',
'\x95\xee': u'\ubea6',
'\x95\xef': u'\ubea7',
'\x95\xf0': u'\ubea9',
'\x95\xf1': u'\ubeaa',
'\x95\xf2': u'\ubeab',
'\x95\xf3': u'\ubeac',
'\x95\xf4': u'\ubead',
'\x95\xf5': u'\ubeae',
'\x95\xf6': u'\ubeaf',
'\x95\xf7': u'\ubeb0',
'\x95\xf8': u'\ubeb1',
'\x95\xf9': u'\ubeb2',
'\x95\xfa': u'\ubeb3',
'\x95\xfb': u'\ubeb4',
'\x95\xfc': u'\ubeb5',
'\x95\xfd': u'\ubeb6',
'\x95\xfe': u'\ubeb7',
'\x95a': u'\ubdf2',
'\x95b': u'\ubdf3',
'\x95c': u'\ubdf5',
'\x95d': u'\ubdf6',
'\x95e': u'\ubdf7',
'\x95f': u'\ubdf9',
'\x95g': u'\ubdfa',
'\x95h': u'\ubdfb',
'\x95i': u'\ubdfc',
'\x95j': u'\ubdfd',
'\x95k': u'\ubdfe',
'\x95l': u'\ubdff',
'\x95m': u'\ube01',
'\x95n': u'\ube02',
'\x95o': u'\ube04',
'\x95p': u'\ube06',
'\x95q': u'\ube07',
'\x95r': u'\ube08',
'\x95s': u'\ube09',
'\x95t': u'\ube0a',
'\x95u': u'\ube0b',
'\x95v': u'\ube0e',
'\x95w': u'\ube0f',
'\x95x': u'\ube11',
'\x95y': u'\ube12',
'\x95z': u'\ube13',
'\x96A': u'\ubeb8',
'\x96B': u'\ubeb9',
'\x96C': u'\ubeba',
'\x96D': u'\ubebb',
'\x96E': u'\ubebc',
'\x96F': u'\ubebd',
'\x96G': u'\ubebe',
'\x96H': u'\ubebf',
'\x96I': u'\ubec0',
'\x96J': u'\ubec1',
'\x96K': u'\ubec2',
'\x96L': u'\ubec3',
'\x96M': u'\ubec4',
'\x96N': u'\ubec5',
'\x96O': u'\ubec6',
'\x96P': u'\ubec7',
'\x96Q': u'\ubec8',
'\x96R': u'\ubec9',
'\x96S': u'\ubeca',
'\x96T': u'\ubecb',
'\x96U': u'\ubecc',
'\x96V': u'\ubecd',
'\x96W': u'\ubece',
'\x96X': u'\ubecf',
'\x96Y': u'\ubed2',
'\x96Z': u'\ubed3',
'\x96\x81': u'\ubef6',
'\x96\x82': u'\ubef7',
'\x96\x83': u'\ubef8',
'\x96\x84': u'\ubef9',
'\x96\x85': u'\ubefa',
'\x96\x86': u'\ubefb',
'\x96\x87': u'\ubefc',
'\x96\x88': u'\ubefd',
'\x96\x89': u'\ubefe',
'\x96\x8a': u'\ubeff',
'\x96\x8b': u'\ubf00',
'\x96\x8c': u'\ubf02',
'\x96\x8d': u'\ubf03',
'\x96\x8e': u'\ubf04',
'\x96\x8f': u'\ubf05',
'\x96\x90': u'\ubf06',
'\x96\x91': u'\ubf07',
'\x96\x92': u'\ubf0a',
'\x96\x93': u'\ubf0b',
'\x96\x94': u'\ubf0c',
'\x96\x95': u'\ubf0d',
'\x96\x96': u'\ubf0e',
'\x96\x97': u'\ubf0f',
'\x96\x98': u'\ubf10',
'\x96\x99': u'\ubf11',
'\x96\x9a': u'\ubf12',
'\x96\x9b': u'\ubf13',
'\x96\x9c': u'\ubf14',
'\x96\x9d': u'\ubf15',
'\x96\x9e': u'\ubf16',
'\x96\x9f': u'\ubf17',
'\x96\xa0': u'\ubf1a',
'\x96\xa1': u'\ubf1e',
'\x96\xa2': u'\ubf1f',
'\x96\xa3': u'\ubf20',
'\x96\xa4': u'\ubf21',
'\x96\xa5': u'\ubf22',
'\x96\xa6': u'\ubf23',
'\x96\xa7': u'\ubf24',
'\x96\xa8': u'\ubf25',
'\x96\xa9': u'\ubf26',
'\x96\xaa': u'\ubf27',
'\x96\xab': u'\ubf28',
'\x96\xac': u'\ubf29',
'\x96\xad': u'\ubf2a',
'\x96\xae': u'\ubf2b',
'\x96\xaf': u'\ubf2c',
'\x96\xb0': u'\ubf2d',
'\x96\xb1': u'\ubf2e',
'\x96\xb2': u'\ubf2f',
'\x96\xb3': u'\ubf30',
'\x96\xb4': u'\ubf31',
'\x96\xb5': u'\ubf32',
'\x96\xb6': u'\ubf33',
'\x96\xb7': u'\ubf34',
'\x96\xb8': u'\ubf35',
'\x96\xb9': u'\ubf36',
'\x96\xba': u'\ubf37',
'\x96\xbb': u'\ubf38',
'\x96\xbc': u'\ubf39',
'\x96\xbd': u'\ubf3a',
'\x96\xbe': u'\ubf3b',
'\x96\xbf': u'\ubf3c',
'\x96\xc0': u'\ubf3d',
'\x96\xc1': u'\ubf3e',
'\x96\xc2': u'\ubf3f',
'\x96\xc3': u'\ubf42',
'\x96\xc4': u'\ubf43',
'\x96\xc5': u'\ubf45',
'\x96\xc6': u'\ubf46',
'\x96\xc7': u'\ubf47',
'\x96\xc8': u'\ubf49',
'\x96\xc9': u'\ubf4a',
'\x96\xca': u'\ubf4b',
'\x96\xcb': u'\ubf4c',
'\x96\xcc': u'\ubf4d',
'\x96\xcd': u'\ubf4e',
'\x96\xce': u'\ubf4f',
'\x96\xcf': u'\ubf52',
'\x96\xd0': u'\ubf53',
'\x96\xd1': u'\ubf54',
'\x96\xd2': u'\ubf56',
'\x96\xd3': u'\ubf57',
'\x96\xd4': u'\ubf58',
'\x96\xd5': u'\ubf59',
'\x96\xd6': u'\ubf5a',
'\x96\xd7': u'\ubf5b',
'\x96\xd8': u'\ubf5c',
'\x96\xd9': u'\ubf5d',
'\x96\xda': u'\ubf5e',
'\x96\xdb': u'\ubf5f',
'\x96\xdc': u'\ubf60',
'\x96\xdd': u'\ubf61',
'\x96\xde': u'\ubf62',
'\x96\xdf': u'\ubf63',
'\x96\xe0': u'\ubf64',
'\x96\xe1': u'\ubf65',
'\x96\xe2': u'\ubf66',
'\x96\xe3': u'\ubf67',
'\x96\xe4': u'\ubf68',
'\x96\xe5': u'\ubf69',
'\x96\xe6': u'\ubf6a',
'\x96\xe7': u'\ubf6b',
'\x96\xe8': u'\ubf6c',
'\x96\xe9': u'\ubf6d',
'\x96\xea': u'\ubf6e',
'\x96\xeb': u'\ubf6f',
'\x96\xec': u'\ubf70',
'\x96\xed': u'\ubf71',
'\x96\xee': u'\ubf72',
'\x96\xef': u'\ubf73',
'\x96\xf0': u'\ubf74',
'\x96\xf1': u'\ubf75',
'\x96\xf2': u'\ubf76',
'\x96\xf3': u'\ubf77',
'\x96\xf4': u'\ubf78',
'\x96\xf5': u'\ubf79',
'\x96\xf6': u'\ubf7a',
'\x96\xf7': u'\ubf7b',
'\x96\xf8': u'\ubf7c',
'\x96\xf9': u'\ubf7d',
'\x96\xfa': u'\ubf7e',
'\x96\xfb': u'\ubf7f',
'\x96\xfc': u'\ubf80',
'\x96\xfd': u'\ubf81',
'\x96\xfe': u'\ubf82',
'\x96a': u'\ubed5',
'\x96b': u'\ubed6',
'\x96c': u'\ubed9',
'\x96d': u'\ubeda',
'\x96e': u'\ubedb',
'\x96f': u'\ubedc',
'\x96g': u'\ubedd',
'\x96h': u'\ubede',
'\x96i': u'\ubedf',
'\x96j': u'\ubee1',
'\x96k': u'\ubee2',
'\x96l': u'\ubee6',
'\x96m': u'\ubee7',
'\x96n': u'\ubee8',
'\x96o': u'\ubee9',
'\x96p': u'\ubeea',
'\x96q': u'\ubeeb',
'\x96r': u'\ubeed',
'\x96s': u'\ubeee',
'\x96t': u'\ubeef',
'\x96u': u'\ubef0',
'\x96v': u'\ubef1',
'\x96w': u'\ubef2',
'\x96x': u'\ubef3',
'\x96y': u'\ubef4',
'\x96z': u'\ubef5',
'\x97A': u'\ubf83',
'\x97B': u'\ubf84',
'\x97C': u'\ubf85',
'\x97D': u'\ubf86',
'\x97E': u'\ubf87',
'\x97F': u'\ubf88',
'\x97G': u'\ubf89',
'\x97H': u'\ubf8a',
'\x97I': u'\ubf8b',
'\x97J': u'\ubf8c',
'\x97K': u'\ubf8d',
'\x97L': u'\ubf8e',
'\x97M': u'\ubf8f',
'\x97N': u'\ubf90',
'\x97O': u'\ubf91',
'\x97P': u'\ubf92',
'\x97Q': u'\ubf93',
'\x97R': u'\ubf95',
'\x97S': u'\ubf96',
'\x97T': u'\ubf97',
'\x97U': u'\ubf98',
'\x97V': u'\ubf99',
'\x97W': u'\ubf9a',
'\x97X': u'\ubf9b',
'\x97Y': u'\ubf9c',
'\x97Z': u'\ubf9d',
'\x97\x81': u'\ubfb9',
'\x97\x82': u'\ubfba',
'\x97\x83': u'\ubfbb',
'\x97\x84': u'\ubfbc',
'\x97\x85': u'\ubfbd',
'\x97\x86': u'\ubfbe',
'\x97\x87': u'\ubfbf',
'\x97\x88': u'\ubfc0',
'\x97\x89': u'\ubfc1',
'\x97\x8a': u'\ubfc2',
'\x97\x8b': u'\ubfc3',
'\x97\x8c': u'\ubfc4',
'\x97\x8d': u'\ubfc6',
'\x97\x8e': u'\ubfc7',
'\x97\x8f': u'\ubfc8',
'\x97\x90': u'\ubfc9',
'\x97\x91': u'\ubfca',
'\x97\x92': u'\ubfcb',
'\x97\x93': u'\ubfce',
'\x97\x94': u'\ubfcf',
'\x97\x95': u'\ubfd1',
'\x97\x96': u'\ubfd2',
'\x97\x97': u'\ubfd3',
'\x97\x98': u'\ubfd5',
'\x97\x99': u'\ubfd6',
'\x97\x9a': u'\ubfd7',
'\x97\x9b': u'\ubfd8',
'\x97\x9c': u'\ubfd9',
'\x97\x9d': u'\ubfda',
'\x97\x9e': u'\ubfdb',
'\x97\x9f': u'\ubfdd',
'\x97\xa0': u'\ubfde',
'\x97\xa1': u'\ubfe0',
'\x97\xa2': u'\ubfe2',
'\x97\xa3': u'\ubfe3',
'\x97\xa4': u'\ubfe4',
'\x97\xa5': u'\ubfe5',
'\x97\xa6': u'\ubfe6',
'\x97\xa7': u'\ubfe7',
'\x97\xa8': u'\ubfe8',
'\x97\xa9': u'\ubfe9',
'\x97\xaa': u'\ubfea',
'\x97\xab': u'\ubfeb',
'\x97\xac': u'\ubfec',
'\x97\xad': u'\ubfed',
'\x97\xae': u'\ubfee',
'\x97\xaf': u'\ubfef',
'\x97\xb0': u'\ubff0',
'\x97\xb1': u'\ubff1',
'\x97\xb2': u'\ubff2',
'\x97\xb3': u'\ubff3',
'\x97\xb4': u'\ubff4',
'\x97\xb5': u'\ubff5',
'\x97\xb6': u'\ubff6',
'\x97\xb7': u'\ubff7',
'\x97\xb8': u'\ubff8',
'\x97\xb9': u'\ubff9',
'\x97\xba': u'\ubffa',
'\x97\xbb': u'\ubffb',
'\x97\xbc': u'\ubffc',
'\x97\xbd': u'\ubffd',
'\x97\xbe': u'\ubffe',
'\x97\xbf': u'\ubfff',
'\x97\xc0': u'\uc000',
'\x97\xc1': u'\uc001',
'\x97\xc2': u'\uc002',
'\x97\xc3': u'\uc003',
'\x97\xc4': u'\uc004',
'\x97\xc5': u'\uc005',
'\x97\xc6': u'\uc006',
'\x97\xc7': u'\uc007',
'\x97\xc8': u'\uc008',
'\x97\xc9': u'\uc009',
'\x97\xca': u'\uc00a',
'\x97\xcb': u'\uc00b',
'\x97\xcc': u'\uc00c',
'\x97\xcd': u'\uc00d',
'\x97\xce': u'\uc00e',
'\x97\xcf': u'\uc00f',
'\x97\xd0': u'\uc010',
'\x97\xd1': u'\uc011',
'\x97\xd2': u'\uc012',
'\x97\xd3': u'\uc013',
'\x97\xd4': u'\uc014',
'\x97\xd5': u'\uc015',
'\x97\xd6': u'\uc016',
'\x97\xd7': u'\uc017',
'\x97\xd8': u'\uc018',
'\x97\xd9': u'\uc019',
'\x97\xda': u'\uc01a',
'\x97\xdb': u'\uc01b',
'\x97\xdc': u'\uc01c',
'\x97\xdd': u'\uc01d',
'\x97\xde': u'\uc01e',
'\x97\xdf': u'\uc01f',
'\x97\xe0': u'\uc020',
'\x97\xe1': u'\uc021',
'\x97\xe2': u'\uc022',
'\x97\xe3': u'\uc023',
'\x97\xe4': u'\uc024',
'\x97\xe5': u'\uc025',
'\x97\xe6': u'\uc026',
'\x97\xe7': u'\uc027',
'\x97\xe8': u'\uc028',
'\x97\xe9': u'\uc029',
'\x97\xea': u'\uc02a',
'\x97\xeb': u'\uc02b',
'\x97\xec': u'\uc02c',
'\x97\xed': u'\uc02d',
'\x97\xee': u'\uc02e',
'\x97\xef': u'\uc02f',
'\x97\xf0': u'\uc030',
'\x97\xf1': u'\uc031',
'\x97\xf2': u'\uc032',
'\x97\xf3': u'\uc033',
'\x97\xf4': u'\uc034',
'\x97\xf5': u'\uc035',
'\x97\xf6': u'\uc036',
'\x97\xf7': u'\uc037',
'\x97\xf8': u'\uc038',
'\x97\xf9': u'\uc039',
'\x97\xfa': u'\uc03a',
'\x97\xfb': u'\uc03b',
'\x97\xfc': u'\uc03d',
'\x97\xfd': u'\uc03e',
'\x97\xfe': u'\uc03f',
'\x97a': u'\ubf9e',
'\x97b': u'\ubf9f',
'\x97c': u'\ubfa0',
'\x97d': u'\ubfa1',
'\x97e': u'\ubfa2',
'\x97f': u'\ubfa3',
'\x97g': u'\ubfa4',
'\x97h': u'\ubfa5',
'\x97i': u'\ubfa6',
'\x97j': u'\ubfa7',
'\x97k': u'\ubfa8',
'\x97l': u'\ubfa9',
'\x97m': u'\ubfaa',
'\x97n': u'\ubfab',
'\x97o': u'\ubfac',
'\x97p': u'\ubfad',
'\x97q': u'\ubfae',
'\x97r': u'\ubfaf',
'\x97s': u'\ubfb1',
'\x97t': u'\ubfb2',
'\x97u': u'\ubfb3',
'\x97v': u'\ubfb4',
'\x97w': u'\ubfb5',
'\x97x': u'\ubfb6',
'\x97y': u'\ubfb7',
'\x97z': u'\ubfb8',
'\x98A': u'\uc040',
'\x98B': u'\uc041',
'\x98C': u'\uc042',
'\x98D': u'\uc043',
'\x98E': u'\uc044',
'\x98F': u'\uc045',
'\x98G': u'\uc046',
'\x98H': u'\uc047',
'\x98I': u'\uc048',
'\x98J': u'\uc049',
'\x98K': u'\uc04a',
'\x98L': u'\uc04b',
'\x98M': u'\uc04c',
'\x98N': u'\uc04d',
'\x98O': u'\uc04e',
'\x98P': u'\uc04f',
'\x98Q': u'\uc050',
'\x98R': u'\uc052',
'\x98S': u'\uc053',
'\x98T': u'\uc054',
'\x98U': u'\uc055',
'\x98V': u'\uc056',
'\x98W': u'\uc057',
'\x98X': u'\uc059',
'\x98Y': u'\uc05a',
'\x98Z': u'\uc05b',
'\x98\x81': u'\uc07a',
'\x98\x82': u'\uc07b',
'\x98\x83': u'\uc07c',
'\x98\x84': u'\uc07d',
'\x98\x85': u'\uc07e',
'\x98\x86': u'\uc07f',
'\x98\x87': u'\uc080',
'\x98\x88': u'\uc081',
'\x98\x89': u'\uc082',
'\x98\x8a': u'\uc083',
'\x98\x8b': u'\uc084',
'\x98\x8c': u'\uc085',
'\x98\x8d': u'\uc086',
'\x98\x8e': u'\uc087',
'\x98\x8f': u'\uc088',
'\x98\x90': u'\uc089',
'\x98\x91': u'\uc08a',
'\x98\x92': u'\uc08b',
'\x98\x93': u'\uc08c',
'\x98\x94': u'\uc08d',
'\x98\x95': u'\uc08e',
'\x98\x96': u'\uc08f',
'\x98\x97': u'\uc092',
'\x98\x98': u'\uc093',
'\x98\x99': u'\uc095',
'\x98\x9a': u'\uc096',
'\x98\x9b': u'\uc097',
'\x98\x9c': u'\uc099',
'\x98\x9d': u'\uc09a',
'\x98\x9e': u'\uc09b',
'\x98\x9f': u'\uc09c',
'\x98\xa0': u'\uc09d',
'\x98\xa1': u'\uc09e',
'\x98\xa2': u'\uc09f',
'\x98\xa3': u'\uc0a2',
'\x98\xa4': u'\uc0a4',
'\x98\xa5': u'\uc0a6',
'\x98\xa6': u'\uc0a7',
'\x98\xa7': u'\uc0a8',
'\x98\xa8': u'\uc0a9',
'\x98\xa9': u'\uc0aa',
'\x98\xaa': u'\uc0ab',
'\x98\xab': u'\uc0ae',
'\x98\xac': u'\uc0b1',
'\x98\xad': u'\uc0b2',
'\x98\xae': u'\uc0b7',
'\x98\xaf': u'\uc0b8',
'\x98\xb0': u'\uc0b9',
'\x98\xb1': u'\uc0ba',
'\x98\xb2': u'\uc0bb',
'\x98\xb3': u'\uc0be',
'\x98\xb4': u'\uc0c2',
'\x98\xb5': u'\uc0c3',
'\x98\xb6': u'\uc0c4',
'\x98\xb7': u'\uc0c6',
'\x98\xb8': u'\uc0c7',
'\x98\xb9': u'\uc0ca',
'\x98\xba': u'\uc0cb',
'\x98\xbb': u'\uc0cd',
'\x98\xbc': u'\uc0ce',
'\x98\xbd': u'\uc0cf',
'\x98\xbe': u'\uc0d1',
'\x98\xbf': u'\uc0d2',
'\x98\xc0': u'\uc0d3',
'\x98\xc1': u'\uc0d4',
'\x98\xc2': u'\uc0d5',
'\x98\xc3': u'\uc0d6',
'\x98\xc4': u'\uc0d7',
'\x98\xc5': u'\uc0da',
'\x98\xc6': u'\uc0de',
'\x98\xc7': u'\uc0df',
'\x98\xc8': u'\uc0e0',
'\x98\xc9': u'\uc0e1',
'\x98\xca': u'\uc0e2',
'\x98\xcb': u'\uc0e3',
'\x98\xcc': u'\uc0e6',
'\x98\xcd': u'\uc0e7',
'\x98\xce': u'\uc0e9',
'\x98\xcf': u'\uc0ea',
'\x98\xd0': u'\uc0eb',
'\x98\xd1': u'\uc0ed',
'\x98\xd2': u'\uc0ee',
'\x98\xd3': u'\uc0ef',
'\x98\xd4': u'\uc0f0',
'\x98\xd5': u'\uc0f1',
'\x98\xd6': u'\uc0f2',
'\x98\xd7': u'\uc0f3',
'\x98\xd8': u'\uc0f6',
'\x98\xd9': u'\uc0f8',
'\x98\xda': u'\uc0fa',
'\x98\xdb': u'\uc0fb',
'\x98\xdc': u'\uc0fc',
'\x98\xdd': u'\uc0fd',
'\x98\xde': u'\uc0fe',
'\x98\xdf': u'\uc0ff',
'\x98\xe0': u'\uc101',
'\x98\xe1': u'\uc102',
'\x98\xe2': u'\uc103',
'\x98\xe3': u'\uc105',
'\x98\xe4': u'\uc106',
'\x98\xe5': u'\uc107',
'\x98\xe6': u'\uc109',
'\x98\xe7': u'\uc10a',
'\x98\xe8': u'\uc10b',
'\x98\xe9': u'\uc10c',
'\x98\xea': u'\uc10d',
'\x98\xeb': u'\uc10e',
'\x98\xec': u'\uc10f',
'\x98\xed': u'\uc111',
'\x98\xee': u'\uc112',
'\x98\xef': u'\uc113',
'\x98\xf0': u'\uc114',
'\x98\xf1': u'\uc116',
'\x98\xf2': u'\uc117',
'\x98\xf3': u'\uc118',
'\x98\xf4': u'\uc119',
'\x98\xf5': u'\uc11a',
'\x98\xf6': u'\uc11b',
'\x98\xf7': u'\uc121',
'\x98\xf8': u'\uc122',
'\x98\xf9': u'\uc125',
'\x98\xfa': u'\uc128',
'\x98\xfb': u'\uc129',
'\x98\xfc': u'\uc12a',
'\x98\xfd': u'\uc12b',
'\x98\xfe': u'\uc12e',
'\x98a': u'\uc05d',
'\x98b': u'\uc05e',
'\x98c': u'\uc05f',
'\x98d': u'\uc061',
'\x98e': u'\uc062',
'\x98f': u'\uc063',
'\x98g': u'\uc064',
'\x98h': u'\uc065',
'\x98i': u'\uc066',
'\x98j': u'\uc067',
'\x98k': u'\uc06a',
'\x98l': u'\uc06b',
'\x98m': u'\uc06c',
'\x98n': u'\uc06d',
'\x98o': u'\uc06e',
'\x98p': u'\uc06f',
'\x98q': u'\uc070',
'\x98r': u'\uc071',
'\x98s': u'\uc072',
'\x98t': u'\uc073',
'\x98u': u'\uc074',
'\x98v': u'\uc075',
'\x98w': u'\uc076',
'\x98x': u'\uc077',
'\x98y': u'\uc078',
'\x98z': u'\uc079',
'\x99A': u'\uc132',
'\x99B': u'\uc133',
'\x99C': u'\uc134',
'\x99D': u'\uc135',
'\x99E': u'\uc137',
'\x99F': u'\uc13a',
'\x99G': u'\uc13b',
'\x99H': u'\uc13d',
'\x99I': u'\uc13e',
'\x99J': u'\uc13f',
'\x99K': u'\uc141',
'\x99L': u'\uc142',
'\x99M': u'\uc143',
'\x99N': u'\uc144',
'\x99O': u'\uc145',
'\x99P': u'\uc146',
'\x99Q': u'\uc147',
'\x99R': u'\uc14a',
'\x99S': u'\uc14e',
'\x99T': u'\uc14f',
'\x99U': u'\uc150',
'\x99V': u'\uc151',
'\x99W': u'\uc152',
'\x99X': u'\uc153',
'\x99Y': u'\uc156',
'\x99Z': u'\uc157',
'\x99\x81': u'\uc17c',
'\x99\x82': u'\uc17d',
'\x99\x83': u'\uc17e',
'\x99\x84': u'\uc17f',
'\x99\x85': u'\uc180',
'\x99\x86': u'\uc181',
'\x99\x87': u'\uc182',
'\x99\x88': u'\uc183',
'\x99\x89': u'\uc184',
'\x99\x8a': u'\uc186',
'\x99\x8b': u'\uc187',
'\x99\x8c': u'\uc188',
'\x99\x8d': u'\uc189',
'\x99\x8e': u'\uc18a',
'\x99\x8f': u'\uc18b',
'\x99\x90': u'\uc18f',
'\x99\x91': u'\uc191',
'\x99\x92': u'\uc192',
'\x99\x93': u'\uc193',
'\x99\x94': u'\uc195',
'\x99\x95': u'\uc197',
'\x99\x96': u'\uc198',
'\x99\x97': u'\uc199',
'\x99\x98': u'\uc19a',
'\x99\x99': u'\uc19b',
'\x99\x9a': u'\uc19e',
'\x99\x9b': u'\uc1a0',
'\x99\x9c': u'\uc1a2',
'\x99\x9d': u'\uc1a3',
'\x99\x9e': u'\uc1a4',
'\x99\x9f': u'\uc1a6',
'\x99\xa0': u'\uc1a7',
'\x99\xa1': u'\uc1aa',
'\x99\xa2': u'\uc1ab',
'\x99\xa3': u'\uc1ad',
'\x99\xa4': u'\uc1ae',
'\x99\xa5': u'\uc1af',
'\x99\xa6': u'\uc1b1',
'\x99\xa7': u'\uc1b2',
'\x99\xa8': u'\uc1b3',
'\x99\xa9': u'\uc1b4',
'\x99\xaa': u'\uc1b5',
'\x99\xab': u'\uc1b6',
'\x99\xac': u'\uc1b7',
'\x99\xad': u'\uc1b8',
'\x99\xae': u'\uc1b9',
'\x99\xaf': u'\uc1ba',
'\x99\xb0': u'\uc1bb',
'\x99\xb1': u'\uc1bc',
'\x99\xb2': u'\uc1be',
'\x99\xb3': u'\uc1bf',
'\x99\xb4': u'\uc1c0',
'\x99\xb5': u'\uc1c1',
'\x99\xb6': u'\uc1c2',
'\x99\xb7': u'\uc1c3',
'\x99\xb8': u'\uc1c5',
'\x99\xb9': u'\uc1c6',
'\x99\xba': u'\uc1c7',
'\x99\xbb': u'\uc1c9',
'\x99\xbc': u'\uc1ca',
'\x99\xbd': u'\uc1cb',
'\x99\xbe': u'\uc1cd',
'\x99\xbf': u'\uc1ce',
'\x99\xc0': u'\uc1cf',
'\x99\xc1': u'\uc1d0',
'\x99\xc2': u'\uc1d1',
'\x99\xc3': u'\uc1d2',
'\x99\xc4': u'\uc1d3',
'\x99\xc5': u'\uc1d5',
'\x99\xc6': u'\uc1d6',
'\x99\xc7': u'\uc1d9',
'\x99\xc8': u'\uc1da',
'\x99\xc9': u'\uc1db',
'\x99\xca': u'\uc1dc',
'\x99\xcb': u'\uc1dd',
'\x99\xcc': u'\uc1de',
'\x99\xcd': u'\uc1df',
'\x99\xce': u'\uc1e1',
'\x99\xcf': u'\uc1e2',
'\x99\xd0': u'\uc1e3',
'\x99\xd1': u'\uc1e5',
'\x99\xd2': u'\uc1e6',
'\x99\xd3': u'\uc1e7',
'\x99\xd4': u'\uc1e9',
'\x99\xd5': u'\uc1ea',
'\x99\xd6': u'\uc1eb',
'\x99\xd7': u'\uc1ec',
'\x99\xd8': u'\uc1ed',
'\x99\xd9': u'\uc1ee',
'\x99\xda': u'\uc1ef',
'\x99\xdb': u'\uc1f2',
'\x99\xdc': u'\uc1f4',
'\x99\xdd': u'\uc1f5',
'\x99\xde': u'\uc1f6',
'\x99\xdf': u'\uc1f7',
'\x99\xe0': u'\uc1f8',
'\x99\xe1': u'\uc1f9',
'\x99\xe2': u'\uc1fa',
'\x99\xe3': u'\uc1fb',
'\x99\xe4': u'\uc1fe',
'\x99\xe5': u'\uc1ff',
'\x99\xe6': u'\uc201',
'\x99\xe7': u'\uc202',
'\x99\xe8': u'\uc203',
'\x99\xe9': u'\uc205',
'\x99\xea': u'\uc206',
'\x99\xeb': u'\uc207',
'\x99\xec': u'\uc208',
'\x99\xed': u'\uc209',
'\x99\xee': u'\uc20a',
'\x99\xef': u'\uc20b',
'\x99\xf0': u'\uc20e',
'\x99\xf1': u'\uc210',
'\x99\xf2': u'\uc212',
'\x99\xf3': u'\uc213',
'\x99\xf4': u'\uc214',
'\x99\xf5': u'\uc215',
'\x99\xf6': u'\uc216',
'\x99\xf7': u'\uc217',
'\x99\xf8': u'\uc21a',
'\x99\xf9': u'\uc21b',
'\x99\xfa': u'\uc21d',
'\x99\xfb': u'\uc21e',
'\x99\xfc': u'\uc221',
'\x99\xfd': u'\uc222',
'\x99\xfe': u'\uc223',
'\x99a': u'\uc159',
'\x99b': u'\uc15a',
'\x99c': u'\uc15b',
'\x99d': u'\uc15d',
'\x99e': u'\uc15e',
'\x99f': u'\uc15f',
'\x99g': u'\uc160',
'\x99h': u'\uc161',
'\x99i': u'\uc162',
'\x99j': u'\uc163',
'\x99k': u'\uc166',
'\x99l': u'\uc16a',
'\x99m': u'\uc16b',
'\x99n': u'\uc16c',
'\x99o': u'\uc16d',
'\x99p': u'\uc16e',
'\x99q': u'\uc16f',
'\x99r': u'\uc171',
'\x99s': u'\uc172',
'\x99t': u'\uc173',
'\x99u': u'\uc175',
'\x99v': u'\uc176',
'\x99w': u'\uc177',
'\x99x': u'\uc179',
'\x99y': u'\uc17a',
'\x99z': u'\uc17b',
'\x9aA': u'\uc224',
'\x9aB': u'\uc225',
'\x9aC': u'\uc226',
'\x9aD': u'\uc227',
'\x9aE': u'\uc22a',
'\x9aF': u'\uc22c',
'\x9aG': u'\uc22e',
'\x9aH': u'\uc230',
'\x9aI': u'\uc233',
'\x9aJ': u'\uc235',
'\x9aK': u'\uc236',
'\x9aL': u'\uc237',
'\x9aM': u'\uc238',
'\x9aN': u'\uc239',
'\x9aO': u'\uc23a',
'\x9aP': u'\uc23b',
'\x9aQ': u'\uc23c',
'\x9aR': u'\uc23d',
'\x9aS': u'\uc23e',
'\x9aT': u'\uc23f',
'\x9aU': u'\uc240',
'\x9aV': u'\uc241',
'\x9aW': u'\uc242',
'\x9aX': u'\uc243',
'\x9aY': u'\uc244',
'\x9aZ': u'\uc245',
'\x9a\x81': u'\uc267',
'\x9a\x82': u'\uc268',
'\x9a\x83': u'\uc269',
'\x9a\x84': u'\uc26a',
'\x9a\x85': u'\uc26b',
'\x9a\x86': u'\uc26e',
'\x9a\x87': u'\uc26f',
'\x9a\x88': u'\uc271',
'\x9a\x89': u'\uc272',
'\x9a\x8a': u'\uc273',
'\x9a\x8b': u'\uc275',
'\x9a\x8c': u'\uc276',
'\x9a\x8d': u'\uc277',
'\x9a\x8e': u'\uc278',
'\x9a\x8f': u'\uc279',
'\x9a\x90': u'\uc27a',
'\x9a\x91': u'\uc27b',
'\x9a\x92': u'\uc27e',
'\x9a\x93': u'\uc280',
'\x9a\x94': u'\uc282',
'\x9a\x95': u'\uc283',
'\x9a\x96': u'\uc284',
'\x9a\x97': u'\uc285',
'\x9a\x98': u'\uc286',
'\x9a\x99': u'\uc287',
'\x9a\x9a': u'\uc28a',
'\x9a\x9b': u'\uc28b',
'\x9a\x9c': u'\uc28c',
'\x9a\x9d': u'\uc28d',
'\x9a\x9e': u'\uc28e',
'\x9a\x9f': u'\uc28f',
'\x9a\xa0': u'\uc291',
'\x9a\xa1': u'\uc292',
'\x9a\xa2': u'\uc293',
'\x9a\xa3': u'\uc294',
'\x9a\xa4': u'\uc295',
'\x9a\xa5': u'\uc296',
'\x9a\xa6': u'\uc297',
'\x9a\xa7': u'\uc299',
'\x9a\xa8': u'\uc29a',
'\x9a\xa9': u'\uc29c',
'\x9a\xaa': u'\uc29e',
'\x9a\xab': u'\uc29f',
'\x9a\xac': u'\uc2a0',
'\x9a\xad': u'\uc2a1',
'\x9a\xae': u'\uc2a2',
'\x9a\xaf': u'\uc2a3',
'\x9a\xb0': u'\uc2a6',
'\x9a\xb1': u'\uc2a7',
'\x9a\xb2': u'\uc2a9',
'\x9a\xb3': u'\uc2aa',
'\x9a\xb4': u'\uc2ab',
'\x9a\xb5': u'\uc2ae',
'\x9a\xb6': u'\uc2af',
'\x9a\xb7': u'\uc2b0',
'\x9a\xb8': u'\uc2b1',
'\x9a\xb9': u'\uc2b2',
'\x9a\xba': u'\uc2b3',
'\x9a\xbb': u'\uc2b6',
'\x9a\xbc': u'\uc2b8',
'\x9a\xbd': u'\uc2ba',
'\x9a\xbe': u'\uc2bb',
'\x9a\xbf': u'\uc2bc',
'\x9a\xc0': u'\uc2bd',
'\x9a\xc1': u'\uc2be',
'\x9a\xc2': u'\uc2bf',
'\x9a\xc3': u'\uc2c0',
'\x9a\xc4': u'\uc2c1',
'\x9a\xc5': u'\uc2c2',
'\x9a\xc6': u'\uc2c3',
'\x9a\xc7': u'\uc2c4',
'\x9a\xc8': u'\uc2c5',
'\x9a\xc9': u'\uc2c6',
'\x9a\xca': u'\uc2c7',
'\x9a\xcb': u'\uc2c8',
'\x9a\xcc': u'\uc2c9',
'\x9a\xcd': u'\uc2ca',
'\x9a\xce': u'\uc2cb',
'\x9a\xcf': u'\uc2cc',
'\x9a\xd0': u'\uc2cd',
'\x9a\xd1': u'\uc2ce',
'\x9a\xd2': u'\uc2cf',
'\x9a\xd3': u'\uc2d0',
'\x9a\xd4': u'\uc2d1',
'\x9a\xd5': u'\uc2d2',
'\x9a\xd6': u'\uc2d3',
'\x9a\xd7': u'\uc2d4',
'\x9a\xd8': u'\uc2d5',
'\x9a\xd9': u'\uc2d6',
'\x9a\xda': u'\uc2d7',
'\x9a\xdb': u'\uc2d8',
'\x9a\xdc': u'\uc2d9',
'\x9a\xdd': u'\uc2da',
'\x9a\xde': u'\uc2db',
'\x9a\xdf': u'\uc2de',
'\x9a\xe0': u'\uc2df',
'\x9a\xe1': u'\uc2e1',
'\x9a\xe2': u'\uc2e2',
'\x9a\xe3': u'\uc2e5',
'\x9a\xe4': u'\uc2e6',
'\x9a\xe5': u'\uc2e7',
'\x9a\xe6': u'\uc2e8',
'\x9a\xe7': u'\uc2e9',
'\x9a\xe8': u'\uc2ea',
'\x9a\xe9': u'\uc2ee',
'\x9a\xea': u'\uc2f0',
'\x9a\xeb': u'\uc2f2',
'\x9a\xec': u'\uc2f3',
'\x9a\xed': u'\uc2f4',
'\x9a\xee': u'\uc2f5',
'\x9a\xef': u'\uc2f7',
'\x9a\xf0': u'\uc2fa',
'\x9a\xf1': u'\uc2fd',
'\x9a\xf2': u'\uc2fe',
'\x9a\xf3': u'\uc2ff',
'\x9a\xf4': u'\uc301',
'\x9a\xf5': u'\uc302',
'\x9a\xf6': u'\uc303',
'\x9a\xf7': u'\uc304',
'\x9a\xf8': u'\uc305',
'\x9a\xf9': u'\uc306',
'\x9a\xfa': u'\uc307',
'\x9a\xfb': u'\uc30a',
'\x9a\xfc': u'\uc30b',
'\x9a\xfd': u'\uc30e',
'\x9a\xfe': u'\uc30f',
'\x9aa': u'\uc246',
'\x9ab': u'\uc247',
'\x9ac': u'\uc249',
'\x9ad': u'\uc24a',
'\x9ae': u'\uc24b',
'\x9af': u'\uc24c',
'\x9ag': u'\uc24d',
'\x9ah': u'\uc24e',
'\x9ai': u'\uc24f',
'\x9aj': u'\uc252',
'\x9ak': u'\uc253',
'\x9al': u'\uc255',
'\x9am': u'\uc256',
'\x9an': u'\uc257',
'\x9ao': u'\uc259',
'\x9ap': u'\uc25a',
'\x9aq': u'\uc25b',
'\x9ar': u'\uc25c',
'\x9as': u'\uc25d',
'\x9at': u'\uc25e',
'\x9au': u'\uc25f',
'\x9av': u'\uc261',
'\x9aw': u'\uc262',
'\x9ax': u'\uc263',
'\x9ay': u'\uc264',
'\x9az': u'\uc266',
'\x9bA': u'\uc310',
'\x9bB': u'\uc311',
'\x9bC': u'\uc312',
'\x9bD': u'\uc316',
'\x9bE': u'\uc317',
'\x9bF': u'\uc319',
'\x9bG': u'\uc31a',
'\x9bH': u'\uc31b',
'\x9bI': u'\uc31d',
'\x9bJ': u'\uc31e',
'\x9bK': u'\uc31f',
'\x9bL': u'\uc320',
'\x9bM': u'\uc321',
'\x9bN': u'\uc322',
'\x9bO': u'\uc323',
'\x9bP': u'\uc326',
'\x9bQ': u'\uc327',
'\x9bR': u'\uc32a',
'\x9bS': u'\uc32b',
'\x9bT': u'\uc32c',
'\x9bU': u'\uc32d',
'\x9bV': u'\uc32e',
'\x9bW': u'\uc32f',
'\x9bX': u'\uc330',
'\x9bY': u'\uc331',
'\x9bZ': u'\uc332',
'\x9b\x81': u'\uc34e',
'\x9b\x82': u'\uc34f',
'\x9b\x83': u'\uc350',
'\x9b\x84': u'\uc351',
'\x9b\x85': u'\uc352',
'\x9b\x86': u'\uc353',
'\x9b\x87': u'\uc354',
'\x9b\x88': u'\uc355',
'\x9b\x89': u'\uc356',
'\x9b\x8a': u'\uc357',
'\x9b\x8b': u'\uc358',
'\x9b\x8c': u'\uc359',
'\x9b\x8d': u'\uc35a',
'\x9b\x8e': u'\uc35b',
'\x9b\x8f': u'\uc35c',
'\x9b\x90': u'\uc35d',
'\x9b\x91': u'\uc35e',
'\x9b\x92': u'\uc35f',
'\x9b\x93': u'\uc360',
'\x9b\x94': u'\uc361',
'\x9b\x95': u'\uc362',
'\x9b\x96': u'\uc363',
'\x9b\x97': u'\uc364',
'\x9b\x98': u'\uc365',
'\x9b\x99': u'\uc366',
'\x9b\x9a': u'\uc367',
'\x9b\x9b': u'\uc36a',
'\x9b\x9c': u'\uc36b',
'\x9b\x9d': u'\uc36d',
'\x9b\x9e': u'\uc36e',
'\x9b\x9f': u'\uc36f',
'\x9b\xa0': u'\uc371',
'\x9b\xa1': u'\uc373',
'\x9b\xa2': u'\uc374',
'\x9b\xa3': u'\uc375',
'\x9b\xa4': u'\uc376',
'\x9b\xa5': u'\uc377',
'\x9b\xa6': u'\uc37a',
'\x9b\xa7': u'\uc37b',
'\x9b\xa8': u'\uc37e',
'\x9b\xa9': u'\uc37f',
'\x9b\xaa': u'\uc380',
'\x9b\xab': u'\uc381',
'\x9b\xac': u'\uc382',
'\x9b\xad': u'\uc383',
'\x9b\xae': u'\uc385',
'\x9b\xaf': u'\uc386',
'\x9b\xb0': u'\uc387',
'\x9b\xb1': u'\uc389',
'\x9b\xb2': u'\uc38a',
'\x9b\xb3': u'\uc38b',
'\x9b\xb4': u'\uc38d',
'\x9b\xb5': u'\uc38e',
'\x9b\xb6': u'\uc38f',
'\x9b\xb7': u'\uc390',
'\x9b\xb8': u'\uc391',
'\x9b\xb9': u'\uc392',
'\x9b\xba': u'\uc393',
'\x9b\xbb': u'\uc394',
'\x9b\xbc': u'\uc395',
'\x9b\xbd': u'\uc396',
'\x9b\xbe': u'\uc397',
'\x9b\xbf': u'\uc398',
'\x9b\xc0': u'\uc399',
'\x9b\xc1': u'\uc39a',
'\x9b\xc2': u'\uc39b',
'\x9b\xc3': u'\uc39c',
'\x9b\xc4': u'\uc39d',
'\x9b\xc5': u'\uc39e',
'\x9b\xc6': u'\uc39f',
'\x9b\xc7': u'\uc3a0',
'\x9b\xc8': u'\uc3a1',
'\x9b\xc9': u'\uc3a2',
'\x9b\xca': u'\uc3a3',
'\x9b\xcb': u'\uc3a4',
'\x9b\xcc': u'\uc3a5',
'\x9b\xcd': u'\uc3a6',
'\x9b\xce': u'\uc3a7',
'\x9b\xcf': u'\uc3a8',
'\x9b\xd0': u'\uc3a9',
'\x9b\xd1': u'\uc3aa',
'\x9b\xd2': u'\uc3ab',
'\x9b\xd3': u'\uc3ac',
'\x9b\xd4': u'\uc3ad',
'\x9b\xd5': u'\uc3ae',
'\x9b\xd6': u'\uc3af',
'\x9b\xd7': u'\uc3b0',
'\x9b\xd8': u'\uc3b1',
'\x9b\xd9': u'\uc3b2',
'\x9b\xda': u'\uc3b3',
'\x9b\xdb': u'\uc3b4',
'\x9b\xdc': u'\uc3b5',
'\x9b\xdd': u'\uc3b6',
'\x9b\xde': u'\uc3b7',
'\x9b\xdf': u'\uc3b8',
'\x9b\xe0': u'\uc3b9',
'\x9b\xe1': u'\uc3ba',
'\x9b\xe2': u'\uc3bb',
'\x9b\xe3': u'\uc3bc',
'\x9b\xe4': u'\uc3bd',
'\x9b\xe5': u'\uc3be',
'\x9b\xe6': u'\uc3bf',
'\x9b\xe7': u'\uc3c1',
'\x9b\xe8': u'\uc3c2',
'\x9b\xe9': u'\uc3c3',
'\x9b\xea': u'\uc3c4',
'\x9b\xeb': u'\uc3c5',
'\x9b\xec': u'\uc3c6',
'\x9b\xed': u'\uc3c7',
'\x9b\xee': u'\uc3c8',
'\x9b\xef': u'\uc3c9',
'\x9b\xf0': u'\uc3ca',
'\x9b\xf1': u'\uc3cb',
'\x9b\xf2': u'\uc3cc',
'\x9b\xf3': u'\uc3cd',
'\x9b\xf4': u'\uc3ce',
'\x9b\xf5': u'\uc3cf',
'\x9b\xf6': u'\uc3d0',
'\x9b\xf7': u'\uc3d1',
'\x9b\xf8': u'\uc3d2',
'\x9b\xf9': u'\uc3d3',
'\x9b\xfa': u'\uc3d4',
'\x9b\xfb': u'\uc3d5',
'\x9b\xfc': u'\uc3d6',
'\x9b\xfd': u'\uc3d7',
'\x9b\xfe': u'\uc3da',
'\x9ba': u'\uc333',
'\x9bb': u'\uc334',
'\x9bc': u'\uc335',
'\x9bd': u'\uc336',
'\x9be': u'\uc337',
'\x9bf': u'\uc338',
'\x9bg': u'\uc339',
'\x9bh': u'\uc33a',
'\x9bi': u'\uc33b',
'\x9bj': u'\uc33c',
'\x9bk': u'\uc33d',
'\x9bl': u'\uc33e',
'\x9bm': u'\uc33f',
'\x9bn': u'\uc340',
'\x9bo': u'\uc341',
'\x9bp': u'\uc342',
'\x9bq': u'\uc343',
'\x9br': u'\uc344',
'\x9bs': u'\uc346',
'\x9bt': u'\uc347',
'\x9bu': u'\uc348',
'\x9bv': u'\uc349',
'\x9bw': u'\uc34a',
'\x9bx': u'\uc34b',
'\x9by': u'\uc34c',
'\x9bz': u'\uc34d',
'\x9cA': u'\uc3db',
'\x9cB': u'\uc3dd',
'\x9cC': u'\uc3de',
'\x9cD': u'\uc3e1',
'\x9cE': u'\uc3e3',
'\x9cF': u'\uc3e4',
'\x9cG': u'\uc3e5',
'\x9cH': u'\uc3e6',
'\x9cI': u'\uc3e7',
'\x9cJ': u'\uc3ea',
'\x9cK': u'\uc3eb',
'\x9cL': u'\uc3ec',
'\x9cM': u'\uc3ee',
'\x9cN': u'\uc3ef',
'\x9cO': u'\uc3f0',
'\x9cP': u'\uc3f1',
'\x9cQ': u'\uc3f2',
'\x9cR': u'\uc3f3',
'\x9cS': u'\uc3f6',
'\x9cT': u'\uc3f7',
'\x9cU': u'\uc3f9',
'\x9cV': u'\uc3fa',
'\x9cW': u'\uc3fb',
'\x9cX': u'\uc3fc',
'\x9cY': u'\uc3fd',
'\x9cZ': u'\uc3fe',
'\x9c\x81': u'\uc41b',
'\x9c\x82': u'\uc41c',
'\x9c\x83': u'\uc41d',
'\x9c\x84': u'\uc41e',
'\x9c\x85': u'\uc41f',
'\x9c\x86': u'\uc420',
'\x9c\x87': u'\uc421',
'\x9c\x88': u'\uc422',
'\x9c\x89': u'\uc423',
'\x9c\x8a': u'\uc425',
'\x9c\x8b': u'\uc426',
'\x9c\x8c': u'\uc427',
'\x9c\x8d': u'\uc428',
'\x9c\x8e': u'\uc429',
'\x9c\x8f': u'\uc42a',
'\x9c\x90': u'\uc42b',
'\x9c\x91': u'\uc42d',
'\x9c\x92': u'\uc42e',
'\x9c\x93': u'\uc42f',
'\x9c\x94': u'\uc431',
'\x9c\x95': u'\uc432',
'\x9c\x96': u'\uc433',
'\x9c\x97': u'\uc435',
'\x9c\x98': u'\uc436',
'\x9c\x99': u'\uc437',
'\x9c\x9a': u'\uc438',
'\x9c\x9b': u'\uc439',
'\x9c\x9c': u'\uc43a',
'\x9c\x9d': u'\uc43b',
'\x9c\x9e': u'\uc43e',
'\x9c\x9f': u'\uc43f',
'\x9c\xa0': u'\uc440',
'\x9c\xa1': u'\uc441',
'\x9c\xa2': u'\uc442',
'\x9c\xa3': u'\uc443',
'\x9c\xa4': u'\uc444',
'\x9c\xa5': u'\uc445',
'\x9c\xa6': u'\uc446',
'\x9c\xa7': u'\uc447',
'\x9c\xa8': u'\uc449',
'\x9c\xa9': u'\uc44a',
'\x9c\xaa': u'\uc44b',
'\x9c\xab': u'\uc44c',
'\x9c\xac': u'\uc44d',
'\x9c\xad': u'\uc44e',
'\x9c\xae': u'\uc44f',
'\x9c\xaf': u'\uc450',
'\x9c\xb0': u'\uc451',
'\x9c\xb1': u'\uc452',
'\x9c\xb2': u'\uc453',
'\x9c\xb3': u'\uc454',
'\x9c\xb4': u'\uc455',
'\x9c\xb5': u'\uc456',
'\x9c\xb6': u'\uc457',
'\x9c\xb7': u'\uc458',
'\x9c\xb8': u'\uc459',
'\x9c\xb9': u'\uc45a',
'\x9c\xba': u'\uc45b',
'\x9c\xbb': u'\uc45c',
'\x9c\xbc': u'\uc45d',
'\x9c\xbd': u'\uc45e',
'\x9c\xbe': u'\uc45f',
'\x9c\xbf': u'\uc460',
'\x9c\xc0': u'\uc461',
'\x9c\xc1': u'\uc462',
'\x9c\xc2': u'\uc463',
'\x9c\xc3': u'\uc466',
'\x9c\xc4': u'\uc467',
'\x9c\xc5': u'\uc469',
'\x9c\xc6': u'\uc46a',
'\x9c\xc7': u'\uc46b',
'\x9c\xc8': u'\uc46d',
'\x9c\xc9': u'\uc46e',
'\x9c\xca': u'\uc46f',
'\x9c\xcb': u'\uc470',
'\x9c\xcc': u'\uc471',
'\x9c\xcd': u'\uc472',
'\x9c\xce': u'\uc473',
'\x9c\xcf': u'\uc476',
'\x9c\xd0': u'\uc477',
'\x9c\xd1': u'\uc478',
'\x9c\xd2': u'\uc47a',
'\x9c\xd3': u'\uc47b',
'\x9c\xd4': u'\uc47c',
'\x9c\xd5': u'\uc47d',
'\x9c\xd6': u'\uc47e',
'\x9c\xd7': u'\uc47f',
'\x9c\xd8': u'\uc481',
'\x9c\xd9': u'\uc482',
'\x9c\xda': u'\uc483',
'\x9c\xdb': u'\uc484',
'\x9c\xdc': u'\uc485',
'\x9c\xdd': u'\uc486',
'\x9c\xde': u'\uc487',
'\x9c\xdf': u'\uc488',
'\x9c\xe0': u'\uc489',
'\x9c\xe1': u'\uc48a',
'\x9c\xe2': u'\uc48b',
'\x9c\xe3': u'\uc48c',
'\x9c\xe4': u'\uc48d',
'\x9c\xe5': u'\uc48e',
'\x9c\xe6': u'\uc48f',
'\x9c\xe7': u'\uc490',
'\x9c\xe8': u'\uc491',
'\x9c\xe9': u'\uc492',
'\x9c\xea': u'\uc493',
'\x9c\xeb': u'\uc495',
'\x9c\xec': u'\uc496',
'\x9c\xed': u'\uc497',
'\x9c\xee': u'\uc498',
'\x9c\xef': u'\uc499',
'\x9c\xf0': u'\uc49a',
'\x9c\xf1': u'\uc49b',
'\x9c\xf2': u'\uc49d',
'\x9c\xf3': u'\uc49e',
'\x9c\xf4': u'\uc49f',
'\x9c\xf5': u'\uc4a0',
'\x9c\xf6': u'\uc4a1',
'\x9c\xf7': u'\uc4a2',
'\x9c\xf8': u'\uc4a3',
'\x9c\xf9': u'\uc4a4',
'\x9c\xfa': u'\uc4a5',
'\x9c\xfb': u'\uc4a6',
'\x9c\xfc': u'\uc4a7',
'\x9c\xfd': u'\uc4a8',
'\x9c\xfe': u'\uc4a9',
'\x9ca': u'\uc3ff',
'\x9cb': u'\uc400',
'\x9cc': u'\uc401',
'\x9cd': u'\uc402',
'\x9ce': u'\uc403',
'\x9cf': u'\uc404',
'\x9cg': u'\uc405',
'\x9ch': u'\uc406',
'\x9ci': u'\uc407',
'\x9cj': u'\uc409',
'\x9ck': u'\uc40a',
'\x9cl': u'\uc40b',
'\x9cm': u'\uc40c',
'\x9cn': u'\uc40d',
'\x9co': u'\uc40e',
'\x9cp': u'\uc40f',
'\x9cq': u'\uc411',
'\x9cr': u'\uc412',
'\x9cs': u'\uc413',
'\x9ct': u'\uc414',
'\x9cu': u'\uc415',
'\x9cv': u'\uc416',
'\x9cw': u'\uc417',
'\x9cx': u'\uc418',
'\x9cy': u'\uc419',
'\x9cz': u'\uc41a',
'\x9dA': u'\uc4aa',
'\x9dB': u'\uc4ab',
'\x9dC': u'\uc4ac',
'\x9dD': u'\uc4ad',
'\x9dE': u'\uc4ae',
'\x9dF': u'\uc4af',
'\x9dG': u'\uc4b0',
'\x9dH': u'\uc4b1',
'\x9dI': u'\uc4b2',
'\x9dJ': u'\uc4b3',
'\x9dK': u'\uc4b4',
'\x9dL': u'\uc4b5',
'\x9dM': u'\uc4b6',
'\x9dN': u'\uc4b7',
'\x9dO': u'\uc4b9',
'\x9dP': u'\uc4ba',
'\x9dQ': u'\uc4bb',
'\x9dR': u'\uc4bd',
'\x9dS': u'\uc4be',
'\x9dT': u'\uc4bf',
'\x9dU': u'\uc4c0',
'\x9dV': u'\uc4c1',
'\x9dW': u'\uc4c2',
'\x9dX': u'\uc4c3',
'\x9dY': u'\uc4c4',
'\x9dZ': u'\uc4c5',
'\x9d\x81': u'\uc4e0',
'\x9d\x82': u'\uc4e1',
'\x9d\x83': u'\uc4e2',
'\x9d\x84': u'\uc4e3',
'\x9d\x85': u'\uc4e4',
'\x9d\x86': u'\uc4e5',
'\x9d\x87': u'\uc4e6',
'\x9d\x88': u'\uc4e7',
'\x9d\x89': u'\uc4e8',
'\x9d\x8a': u'\uc4ea',
'\x9d\x8b': u'\uc4eb',
'\x9d\x8c': u'\uc4ec',
'\x9d\x8d': u'\uc4ed',
'\x9d\x8e': u'\uc4ee',
'\x9d\x8f': u'\uc4ef',
'\x9d\x90': u'\uc4f2',
'\x9d\x91': u'\uc4f3',
'\x9d\x92': u'\uc4f5',
'\x9d\x93': u'\uc4f6',
'\x9d\x94': u'\uc4f7',
'\x9d\x95': u'\uc4f9',
'\x9d\x96': u'\uc4fb',
'\x9d\x97': u'\uc4fc',
'\x9d\x98': u'\uc4fd',
'\x9d\x99': u'\uc4fe',
'\x9d\x9a': u'\uc502',
'\x9d\x9b': u'\uc503',
'\x9d\x9c': u'\uc504',
'\x9d\x9d': u'\uc505',
'\x9d\x9e': u'\uc506',
'\x9d\x9f': u'\uc507',
'\x9d\xa0': u'\uc508',
'\x9d\xa1': u'\uc509',
'\x9d\xa2': u'\uc50a',
'\x9d\xa3': u'\uc50b',
'\x9d\xa4': u'\uc50d',
'\x9d\xa5': u'\uc50e',
'\x9d\xa6': u'\uc50f',
'\x9d\xa7': u'\uc511',
'\x9d\xa8': u'\uc512',
'\x9d\xa9': u'\uc513',
'\x9d\xaa': u'\uc515',
'\x9d\xab': u'\uc516',
'\x9d\xac': u'\uc517',
'\x9d\xad': u'\uc518',
'\x9d\xae': u'\uc519',
'\x9d\xaf': u'\uc51a',
'\x9d\xb0': u'\uc51b',
'\x9d\xb1': u'\uc51d',
'\x9d\xb2': u'\uc51e',
'\x9d\xb3': u'\uc51f',
'\x9d\xb4': u'\uc520',
'\x9d\xb5': u'\uc521',
'\x9d\xb6': u'\uc522',
'\x9d\xb7': u'\uc523',
'\x9d\xb8': u'\uc524',
'\x9d\xb9': u'\uc525',
'\x9d\xba': u'\uc526',
'\x9d\xbb': u'\uc527',
'\x9d\xbc': u'\uc52a',
'\x9d\xbd': u'\uc52b',
'\x9d\xbe': u'\uc52d',
'\x9d\xbf': u'\uc52e',
'\x9d\xc0': u'\uc52f',
'\x9d\xc1': u'\uc531',
'\x9d\xc2': u'\uc532',
'\x9d\xc3': u'\uc533',
'\x9d\xc4': u'\uc534',
'\x9d\xc5': u'\uc535',
'\x9d\xc6': u'\uc536',
'\x9d\xc7': u'\uc537',
'\x9d\xc8': u'\uc53a',
'\x9d\xc9': u'\uc53c',
'\x9d\xca': u'\uc53e',
'\x9d\xcb': u'\uc53f',
'\x9d\xcc': u'\uc540',
'\x9d\xcd': u'\uc541',
'\x9d\xce': u'\uc542',
'\x9d\xcf': u'\uc543',
'\x9d\xd0': u'\uc546',
'\x9d\xd1': u'\uc547',
'\x9d\xd2': u'\uc54b',
'\x9d\xd3': u'\uc54f',
'\x9d\xd4': u'\uc550',
'\x9d\xd5': u'\uc551',
'\x9d\xd6': u'\uc552',
'\x9d\xd7': u'\uc556',
'\x9d\xd8': u'\uc55a',
'\x9d\xd9': u'\uc55b',
'\x9d\xda': u'\uc55c',
'\x9d\xdb': u'\uc55f',
'\x9d\xdc': u'\uc562',
'\x9d\xdd': u'\uc563',
'\x9d\xde': u'\uc565',
'\x9d\xdf': u'\uc566',
'\x9d\xe0': u'\uc567',
'\x9d\xe1': u'\uc569',
'\x9d\xe2': u'\uc56a',
'\x9d\xe3': u'\uc56b',
'\x9d\xe4': u'\uc56c',
'\x9d\xe5': u'\uc56d',
'\x9d\xe6': u'\uc56e',
'\x9d\xe7': u'\uc56f',
'\x9d\xe8': u'\uc572',
'\x9d\xe9': u'\uc576',
'\x9d\xea': u'\uc577',
'\x9d\xeb': u'\uc578',
'\x9d\xec': u'\uc579',
'\x9d\xed': u'\uc57a',
'\x9d\xee': u'\uc57b',
'\x9d\xef': u'\uc57e',
'\x9d\xf0': u'\uc57f',
'\x9d\xf1': u'\uc581',
'\x9d\xf2': u'\uc582',
'\x9d\xf3': u'\uc583',
'\x9d\xf4': u'\uc585',
'\x9d\xf5': u'\uc586',
'\x9d\xf6': u'\uc588',
'\x9d\xf7': u'\uc589',
'\x9d\xf8': u'\uc58a',
'\x9d\xf9': u'\uc58b',
'\x9d\xfa': u'\uc58e',
'\x9d\xfb': u'\uc590',
'\x9d\xfc': u'\uc592',
'\x9d\xfd': u'\uc593',
'\x9d\xfe': u'\uc594',
'\x9da': u'\uc4c6',
'\x9db': u'\uc4c7',
'\x9dc': u'\uc4c8',
'\x9dd': u'\uc4c9',
'\x9de': u'\uc4ca',
'\x9df': u'\uc4cb',
'\x9dg': u'\uc4cc',
'\x9dh': u'\uc4cd',
'\x9di': u'\uc4ce',
'\x9dj': u'\uc4cf',
'\x9dk': u'\uc4d0',
'\x9dl': u'\uc4d1',
'\x9dm': u'\uc4d2',
'\x9dn': u'\uc4d3',
'\x9do': u'\uc4d4',
'\x9dp': u'\uc4d5',
'\x9dq': u'\uc4d6',
'\x9dr': u'\uc4d7',
'\x9ds': u'\uc4d8',
'\x9dt': u'\uc4d9',
'\x9du': u'\uc4da',
'\x9dv': u'\uc4db',
'\x9dw': u'\uc4dc',
'\x9dx': u'\uc4dd',
'\x9dy': u'\uc4de',
'\x9dz': u'\uc4df',
'\x9eA': u'\uc596',
'\x9eB': u'\uc599',
'\x9eC': u'\uc59a',
'\x9eD': u'\uc59b',
'\x9eE': u'\uc59d',
'\x9eF': u'\uc59e',
'\x9eG': u'\uc59f',
'\x9eH': u'\uc5a1',
'\x9eI': u'\uc5a2',
'\x9eJ': u'\uc5a3',
'\x9eK': u'\uc5a4',
'\x9eL': u'\uc5a5',
'\x9eM': u'\uc5a6',
'\x9eN': u'\uc5a7',
'\x9eO': u'\uc5a8',
'\x9eP': u'\uc5aa',
'\x9eQ': u'\uc5ab',
'\x9eR': u'\uc5ac',
'\x9eS': u'\uc5ad',
'\x9eT': u'\uc5ae',
'\x9eU': u'\uc5af',
'\x9eV': u'\uc5b0',
'\x9eW': u'\uc5b1',
'\x9eX': u'\uc5b2',
'\x9eY': u'\uc5b3',
'\x9eZ': u'\uc5b6',
'\x9e\x81': u'\uc5e8',
'\x9e\x82': u'\uc5e9',
'\x9e\x83': u'\uc5ea',
'\x9e\x84': u'\uc5eb',
'\x9e\x85': u'\uc5ef',
'\x9e\x86': u'\uc5f1',
'\x9e\x87': u'\uc5f2',
'\x9e\x88': u'\uc5f3',
'\x9e\x89': u'\uc5f5',
'\x9e\x8a': u'\uc5f8',
'\x9e\x8b': u'\uc5f9',
'\x9e\x8c': u'\uc5fa',
'\x9e\x8d': u'\uc5fb',
'\x9e\x8e': u'\uc602',
'\x9e\x8f': u'\uc603',
'\x9e\x90': u'\uc604',
'\x9e\x91': u'\uc609',
'\x9e\x92': u'\uc60a',
'\x9e\x93': u'\uc60b',
'\x9e\x94': u'\uc60d',
'\x9e\x95': u'\uc60e',
'\x9e\x96': u'\uc60f',
'\x9e\x97': u'\uc611',
'\x9e\x98': u'\uc612',
'\x9e\x99': u'\uc613',
'\x9e\x9a': u'\uc614',
'\x9e\x9b': u'\uc615',
'\x9e\x9c': u'\uc616',
'\x9e\x9d': u'\uc617',
'\x9e\x9e': u'\uc61a',
'\x9e\x9f': u'\uc61d',
'\x9e\xa0': u'\uc61e',
'\x9e\xa1': u'\uc61f',
'\x9e\xa2': u'\uc620',
'\x9e\xa3': u'\uc621',
'\x9e\xa4': u'\uc622',
'\x9e\xa5': u'\uc623',
'\x9e\xa6': u'\uc626',
'\x9e\xa7': u'\uc627',
'\x9e\xa8': u'\uc629',
'\x9e\xa9': u'\uc62a',
'\x9e\xaa': u'\uc62b',
'\x9e\xab': u'\uc62f',
'\x9e\xac': u'\uc631',
'\x9e\xad': u'\uc632',
'\x9e\xae': u'\uc636',
'\x9e\xaf': u'\uc638',
'\x9e\xb0': u'\uc63a',
'\x9e\xb1': u'\uc63c',
'\x9e\xb2': u'\uc63d',
'\x9e\xb3': u'\uc63e',
'\x9e\xb4': u'\uc63f',
'\x9e\xb5': u'\uc642',
'\x9e\xb6': u'\uc643',
'\x9e\xb7': u'\uc645',
'\x9e\xb8': u'\uc646',
'\x9e\xb9': u'\uc647',
'\x9e\xba': u'\uc649',
'\x9e\xbb': u'\uc64a',
'\x9e\xbc': u'\uc64b',
'\x9e\xbd': u'\uc64c',
'\x9e\xbe': u'\uc64d',
'\x9e\xbf': u'\uc64e',
'\x9e\xc0': u'\uc64f',
'\x9e\xc1': u'\uc652',
'\x9e\xc2': u'\uc656',
'\x9e\xc3': u'\uc657',
'\x9e\xc4': u'\uc658',
'\x9e\xc5': u'\uc659',
'\x9e\xc6': u'\uc65a',
'\x9e\xc7': u'\uc65b',
'\x9e\xc8': u'\uc65e',
'\x9e\xc9': u'\uc65f',
'\x9e\xca': u'\uc661',
'\x9e\xcb': u'\uc662',
'\x9e\xcc': u'\uc663',
'\x9e\xcd': u'\uc664',
'\x9e\xce': u'\uc665',
'\x9e\xcf': u'\uc666',
'\x9e\xd0': u'\uc667',
'\x9e\xd1': u'\uc668',
'\x9e\xd2': u'\uc669',
'\x9e\xd3': u'\uc66a',
'\x9e\xd4': u'\uc66b',
'\x9e\xd5': u'\uc66d',
'\x9e\xd6': u'\uc66e',
'\x9e\xd7': u'\uc670',
'\x9e\xd8': u'\uc672',
'\x9e\xd9': u'\uc673',
'\x9e\xda': u'\uc674',
'\x9e\xdb': u'\uc675',
'\x9e\xdc': u'\uc676',
'\x9e\xdd': u'\uc677',
'\x9e\xde': u'\uc67a',
'\x9e\xdf': u'\uc67b',
'\x9e\xe0': u'\uc67d',
'\x9e\xe1': u'\uc67e',
'\x9e\xe2': u'\uc67f',
'\x9e\xe3': u'\uc681',
'\x9e\xe4': u'\uc682',
'\x9e\xe5': u'\uc683',
'\x9e\xe6': u'\uc684',
'\x9e\xe7': u'\uc685',
'\x9e\xe8': u'\uc686',
'\x9e\xe9': u'\uc687',
'\x9e\xea': u'\uc68a',
'\x9e\xeb': u'\uc68c',
'\x9e\xec': u'\uc68e',
'\x9e\xed': u'\uc68f',
'\x9e\xee': u'\uc690',
'\x9e\xef': u'\uc691',
'\x9e\xf0': u'\uc692',
'\x9e\xf1': u'\uc693',
'\x9e\xf2': u'\uc696',
'\x9e\xf3': u'\uc697',
'\x9e\xf4': u'\uc699',
'\x9e\xf5': u'\uc69a',
'\x9e\xf6': u'\uc69b',
'\x9e\xf7': u'\uc69d',
'\x9e\xf8': u'\uc69e',
'\x9e\xf9': u'\uc69f',
'\x9e\xfa': u'\uc6a0',
'\x9e\xfb': u'\uc6a1',
'\x9e\xfc': u'\uc6a2',
'\x9e\xfd': u'\uc6a3',
'\x9e\xfe': u'\uc6a6',
'\x9ea': u'\uc5b7',
'\x9eb': u'\uc5ba',
'\x9ec': u'\uc5bf',
'\x9ed': u'\uc5c0',
'\x9ee': u'\uc5c1',
'\x9ef': u'\uc5c2',
'\x9eg': u'\uc5c3',
'\x9eh': u'\uc5cb',
'\x9ei': u'\uc5cd',
'\x9ej': u'\uc5cf',
'\x9ek': u'\uc5d2',
'\x9el': u'\uc5d3',
'\x9em': u'\uc5d5',
'\x9en': u'\uc5d6',
'\x9eo': u'\uc5d7',
'\x9ep': u'\uc5d9',
'\x9eq': u'\uc5da',
'\x9er': u'\uc5db',
'\x9es': u'\uc5dc',
'\x9et': u'\uc5dd',
'\x9eu': u'\uc5de',
'\x9ev': u'\uc5df',
'\x9ew': u'\uc5e2',
'\x9ex': u'\uc5e4',
'\x9ey': u'\uc5e6',
'\x9ez': u'\uc5e7',
'\x9fA': u'\uc6a8',
'\x9fB': u'\uc6aa',
'\x9fC': u'\uc6ab',
'\x9fD': u'\uc6ac',
'\x9fE': u'\uc6ad',
'\x9fF': u'\uc6ae',
'\x9fG': u'\uc6af',
'\x9fH': u'\uc6b2',
'\x9fI': u'\uc6b3',
'\x9fJ': u'\uc6b5',
'\x9fK': u'\uc6b6',
'\x9fL': u'\uc6b7',
'\x9fM': u'\uc6bb',
'\x9fN': u'\uc6bc',
'\x9fO': u'\uc6bd',
'\x9fP': u'\uc6be',
'\x9fQ': u'\uc6bf',
'\x9fR': u'\uc6c2',
'\x9fS': u'\uc6c4',
'\x9fT': u'\uc6c6',
'\x9fU': u'\uc6c7',
'\x9fV': u'\uc6c8',
'\x9fW': u'\uc6c9',
'\x9fX': u'\uc6ca',
'\x9fY': u'\uc6cb',
'\x9fZ': u'\uc6ce',
'\x9f\x81': u'\uc6f3',
'\x9f\x82': u'\uc6f4',
'\x9f\x83': u'\uc6f5',
'\x9f\x84': u'\uc6f6',
'\x9f\x85': u'\uc6f7',
'\x9f\x86': u'\uc6fa',
'\x9f\x87': u'\uc6fb',
'\x9f\x88': u'\uc6fc',
'\x9f\x89': u'\uc6fe',
'\x9f\x8a': u'\uc6ff',
'\x9f\x8b': u'\uc700',
'\x9f\x8c': u'\uc701',
'\x9f\x8d': u'\uc702',
'\x9f\x8e': u'\uc703',
'\x9f\x8f': u'\uc706',
'\x9f\x90': u'\uc707',
'\x9f\x91': u'\uc709',
'\x9f\x92': u'\uc70a',
'\x9f\x93': u'\uc70b',
'\x9f\x94': u'\uc70d',
'\x9f\x95': u'\uc70e',
'\x9f\x96': u'\uc70f',
'\x9f\x97': u'\uc710',
'\x9f\x98': u'\uc711',
'\x9f\x99': u'\uc712',
'\x9f\x9a': u'\uc713',
'\x9f\x9b': u'\uc716',
'\x9f\x9c': u'\uc718',
'\x9f\x9d': u'\uc71a',
'\x9f\x9e': u'\uc71b',
'\x9f\x9f': u'\uc71c',
'\x9f\xa0': u'\uc71d',
'\x9f\xa1': u'\uc71e',
'\x9f\xa2': u'\uc71f',
'\x9f\xa3': u'\uc722',
'\x9f\xa4': u'\uc723',
'\x9f\xa5': u'\uc725',
'\x9f\xa6': u'\uc726',
'\x9f\xa7': u'\uc727',
'\x9f\xa8': u'\uc729',
'\x9f\xa9': u'\uc72a',
'\x9f\xaa': u'\uc72b',
'\x9f\xab': u'\uc72c',
'\x9f\xac': u'\uc72d',
'\x9f\xad': u'\uc72e',
'\x9f\xae': u'\uc72f',
'\x9f\xaf': u'\uc732',
'\x9f\xb0': u'\uc734',
'\x9f\xb1': u'\uc736',
'\x9f\xb2': u'\uc738',
'\x9f\xb3': u'\uc739',
'\x9f\xb4': u'\uc73a',
'\x9f\xb5': u'\uc73b',
'\x9f\xb6': u'\uc73e',
'\x9f\xb7': u'\uc73f',
'\x9f\xb8': u'\uc741',
'\x9f\xb9': u'\uc742',
'\x9f\xba': u'\uc743',
'\x9f\xbb': u'\uc745',
'\x9f\xbc': u'\uc746',
'\x9f\xbd': u'\uc747',
'\x9f\xbe': u'\uc748',
'\x9f\xbf': u'\uc749',
'\x9f\xc0': u'\uc74b',
'\x9f\xc1': u'\uc74e',
'\x9f\xc2': u'\uc750',
'\x9f\xc3': u'\uc759',
'\x9f\xc4': u'\uc75a',
'\x9f\xc5': u'\uc75b',
'\x9f\xc6': u'\uc75d',
'\x9f\xc7': u'\uc75e',
'\x9f\xc8': u'\uc75f',
'\x9f\xc9': u'\uc761',
'\x9f\xca': u'\uc762',
'\x9f\xcb': u'\uc763',
'\x9f\xcc': u'\uc764',
'\x9f\xcd': u'\uc765',
'\x9f\xce': u'\uc766',
'\x9f\xcf': u'\uc767',
'\x9f\xd0': u'\uc769',
'\x9f\xd1': u'\uc76a',
'\x9f\xd2': u'\uc76c',
'\x9f\xd3': u'\uc76d',
'\x9f\xd4': u'\uc76e',
'\x9f\xd5': u'\uc76f',
'\x9f\xd6': u'\uc770',
'\x9f\xd7': u'\uc771',
'\x9f\xd8': u'\uc772',
'\x9f\xd9': u'\uc773',
'\x9f\xda': u'\uc776',
'\x9f\xdb': u'\uc777',
'\x9f\xdc': u'\uc779',
'\x9f\xdd': u'\uc77a',
'\x9f\xde': u'\uc77b',
'\x9f\xdf': u'\uc77f',
'\x9f\xe0': u'\uc780',
'\x9f\xe1': u'\uc781',
'\x9f\xe2': u'\uc782',
'\x9f\xe3': u'\uc786',
'\x9f\xe4': u'\uc78b',
'\x9f\xe5': u'\uc78c',
'\x9f\xe6': u'\uc78d',
'\x9f\xe7': u'\uc78f',
'\x9f\xe8': u'\uc792',
'\x9f\xe9': u'\uc793',
'\x9f\xea': u'\uc795',
'\x9f\xeb': u'\uc799',
'\x9f\xec': u'\uc79b',
'\x9f\xed': u'\uc79c',
'\x9f\xee': u'\uc79d',
'\x9f\xef': u'\uc79e',
'\x9f\xf0': u'\uc79f',
'\x9f\xf1': u'\uc7a2',
'\x9f\xf2': u'\uc7a7',
'\x9f\xf3': u'\uc7a8',
'\x9f\xf4': u'\uc7a9',
'\x9f\xf5': u'\uc7aa',
'\x9f\xf6': u'\uc7ab',
'\x9f\xf7': u'\uc7ae',
'\x9f\xf8': u'\uc7af',
'\x9f\xf9': u'\uc7b1',
'\x9f\xfa': u'\uc7b2',
'\x9f\xfb': u'\uc7b3',
'\x9f\xfc': u'\uc7b5',
'\x9f\xfd': u'\uc7b6',
'\x9f\xfe': u'\uc7b7',
'\x9fa': u'\uc6cf',
'\x9fb': u'\uc6d1',
'\x9fc': u'\uc6d2',
'\x9fd': u'\uc6d3',
'\x9fe': u'\uc6d5',
'\x9ff': u'\uc6d6',
'\x9fg': u'\uc6d7',
'\x9fh': u'\uc6d8',
'\x9fi': u'\uc6d9',
'\x9fj': u'\uc6da',
'\x9fk': u'\uc6db',
'\x9fl': u'\uc6de',
'\x9fm': u'\uc6df',
'\x9fn': u'\uc6e2',
'\x9fo': u'\uc6e3',
'\x9fp': u'\uc6e4',
'\x9fq': u'\uc6e5',
'\x9fr': u'\uc6e6',
'\x9fs': u'\uc6e7',
'\x9ft': u'\uc6ea',
'\x9fu': u'\uc6eb',
'\x9fv': u'\uc6ed',
'\x9fw': u'\uc6ee',
'\x9fx': u'\uc6ef',
'\x9fy': u'\uc6f1',
'\x9fz': u'\uc6f2',
'\xa0A': u'\uc7b8',
'\xa0B': u'\uc7b9',
'\xa0C': u'\uc7ba',
'\xa0D': u'\uc7bb',
'\xa0E': u'\uc7be',
'\xa0F': u'\uc7c2',
'\xa0G': u'\uc7c3',
'\xa0H': u'\uc7c4',
'\xa0I': u'\uc7c5',
'\xa0J': u'\uc7c6',
'\xa0K': u'\uc7c7',
'\xa0L': u'\uc7ca',
'\xa0M': u'\uc7cb',
'\xa0N': u'\uc7cd',
'\xa0O': u'\uc7cf',
'\xa0P': u'\uc7d1',
'\xa0Q': u'\uc7d2',
'\xa0R': u'\uc7d3',
'\xa0S': u'\uc7d4',
'\xa0T': u'\uc7d5',
'\xa0U': u'\uc7d6',
'\xa0V': u'\uc7d7',
'\xa0W': u'\uc7d9',
'\xa0X': u'\uc7da',
'\xa0Y': u'\uc7db',
'\xa0Z': u'\uc7dc',
'\xa0\x81': u'\uc7fb',
'\xa0\x82': u'\uc7fc',
'\xa0\x83': u'\uc7fd',
'\xa0\x84': u'\uc7fe',
'\xa0\x85': u'\uc7ff',
'\xa0\x86': u'\uc802',
'\xa0\x87': u'\uc803',
'\xa0\x88': u'\uc805',
'\xa0\x89': u'\uc806',
'\xa0\x8a': u'\uc807',
'\xa0\x8b': u'\uc809',
'\xa0\x8c': u'\uc80b',
'\xa0\x8d': u'\uc80c',
'\xa0\x8e': u'\uc80d',
'\xa0\x8f': u'\uc80e',
'\xa0\x90': u'\uc80f',
'\xa0\x91': u'\uc812',
'\xa0\x92': u'\uc814',
'\xa0\x93': u'\uc817',
'\xa0\x94': u'\uc818',
'\xa0\x95': u'\uc819',
'\xa0\x96': u'\uc81a',
'\xa0\x97': u'\uc81b',
'\xa0\x98': u'\uc81e',
'\xa0\x99': u'\uc81f',
'\xa0\x9a': u'\uc821',
'\xa0\x9b': u'\uc822',
'\xa0\x9c': u'\uc823',
'\xa0\x9d': u'\uc825',
'\xa0\x9e': u'\uc826',
'\xa0\x9f': u'\uc827',
'\xa0\xa0': u'\uc828',
'\xa0\xa1': u'\uc829',
'\xa0\xa2': u'\uc82a',
'\xa0\xa3': u'\uc82b',
'\xa0\xa4': u'\uc82e',
'\xa0\xa5': u'\uc830',
'\xa0\xa6': u'\uc832',
'\xa0\xa7': u'\uc833',
'\xa0\xa8': u'\uc834',
'\xa0\xa9': u'\uc835',
'\xa0\xaa': u'\uc836',
'\xa0\xab': u'\uc837',
'\xa0\xac': u'\uc839',
'\xa0\xad': u'\uc83a',
'\xa0\xae': u'\uc83b',
'\xa0\xaf': u'\uc83d',
'\xa0\xb0': u'\uc83e',
'\xa0\xb1': u'\uc83f',
'\xa0\xb2': u'\uc841',
'\xa0\xb3': u'\uc842',
'\xa0\xb4': u'\uc843',
'\xa0\xb5': u'\uc844',
'\xa0\xb6': u'\uc845',
'\xa0\xb7': u'\uc846',
'\xa0\xb8': u'\uc847',
'\xa0\xb9': u'\uc84a',
'\xa0\xba': u'\uc84b',
'\xa0\xbb': u'\uc84e',
'\xa0\xbc': u'\uc84f',
'\xa0\xbd': u'\uc850',
'\xa0\xbe': u'\uc851',
'\xa0\xbf': u'\uc852',
'\xa0\xc0': u'\uc853',
'\xa0\xc1': u'\uc855',
'\xa0\xc2': u'\uc856',
'\xa0\xc3': u'\uc857',
'\xa0\xc4': u'\uc858',
'\xa0\xc5': u'\uc859',
'\xa0\xc6': u'\uc85a',
'\xa0\xc7': u'\uc85b',
'\xa0\xc8': u'\uc85c',
'\xa0\xc9': u'\uc85d',
'\xa0\xca': u'\uc85e',
'\xa0\xcb': u'\uc85f',
'\xa0\xcc': u'\uc860',
'\xa0\xcd': u'\uc861',
'\xa0\xce': u'\uc862',
'\xa0\xcf': u'\uc863',
'\xa0\xd0': u'\uc864',
'\xa0\xd1': u'\uc865',
'\xa0\xd2': u'\uc866',
'\xa0\xd3': u'\uc867',
'\xa0\xd4': u'\uc868',
'\xa0\xd5': u'\uc869',
'\xa0\xd6': u'\uc86a',
'\xa0\xd7': u'\uc86b',
'\xa0\xd8': u'\uc86c',
'\xa0\xd9': u'\uc86d',
'\xa0\xda': u'\uc86e',
'\xa0\xdb': u'\uc86f',
'\xa0\xdc': u'\uc872',
'\xa0\xdd': u'\uc873',
'\xa0\xde': u'\uc875',
'\xa0\xdf': u'\uc876',
'\xa0\xe0': u'\uc877',
'\xa0\xe1': u'\uc879',
'\xa0\xe2': u'\uc87b',
'\xa0\xe3': u'\uc87c',
'\xa0\xe4': u'\uc87d',
'\xa0\xe5': u'\uc87e',
'\xa0\xe6': u'\uc87f',
'\xa0\xe7': u'\uc882',
'\xa0\xe8': u'\uc884',
'\xa0\xe9': u'\uc888',
'\xa0\xea': u'\uc889',
'\xa0\xeb': u'\uc88a',
'\xa0\xec': u'\uc88e',
'\xa0\xed': u'\uc88f',
'\xa0\xee': u'\uc890',
'\xa0\xef': u'\uc891',
'\xa0\xf0': u'\uc892',
'\xa0\xf1': u'\uc893',
'\xa0\xf2': u'\uc895',
'\xa0\xf3': u'\uc896',
'\xa0\xf4': u'\uc897',
'\xa0\xf5': u'\uc898',
'\xa0\xf6': u'\uc899',
'\xa0\xf7': u'\uc89a',
'\xa0\xf8': u'\uc89b',
'\xa0\xf9': u'\uc89c',
'\xa0\xfa': u'\uc89e',
'\xa0\xfb': u'\uc8a0',
'\xa0\xfc': u'\uc8a2',
'\xa0\xfd': u'\uc8a3',
'\xa0\xfe': u'\uc8a4',
'\xa0a': u'\uc7de',
'\xa0b': u'\uc7df',
'\xa0c': u'\uc7e0',
'\xa0d': u'\uc7e1',
'\xa0e': u'\uc7e2',
'\xa0f': u'\uc7e3',
'\xa0g': u'\uc7e5',
'\xa0h': u'\uc7e6',
'\xa0i': u'\uc7e7',
'\xa0j': u'\uc7e9',
'\xa0k': u'\uc7ea',
'\xa0l': u'\uc7eb',
'\xa0m': u'\uc7ed',
'\xa0n': u'\uc7ee',
'\xa0o': u'\uc7ef',
'\xa0p': u'\uc7f0',
'\xa0q': u'\uc7f1',
'\xa0r': u'\uc7f2',
'\xa0s': u'\uc7f3',
'\xa0t': u'\uc7f4',
'\xa0u': u'\uc7f5',
'\xa0v': u'\uc7f6',
'\xa0w': u'\uc7f7',
'\xa0x': u'\uc7f8',
'\xa0y': u'\uc7f9',
'\xa0z': u'\uc7fa',
'\xa1A': u'\uc8a5',
'\xa1B': u'\uc8a6',
'\xa1C': u'\uc8a7',
'\xa1D': u'\uc8a9',
'\xa1E': u'\uc8aa',
'\xa1F': u'\uc8ab',
'\xa1G': u'\uc8ac',
'\xa1H': u'\uc8ad',
'\xa1I': u'\uc8ae',
'\xa1J': u'\uc8af',
'\xa1K': u'\uc8b0',
'\xa1L': u'\uc8b1',
'\xa1M': u'\uc8b2',
'\xa1N': u'\uc8b3',
'\xa1O': u'\uc8b4',
'\xa1P': u'\uc8b5',
'\xa1Q': u'\uc8b6',
'\xa1R': u'\uc8b7',
'\xa1S': u'\uc8b8',
'\xa1T': u'\uc8b9',
'\xa1U': u'\uc8ba',
'\xa1V': u'\uc8bb',
'\xa1W': u'\uc8be',
'\xa1X': u'\uc8bf',
'\xa1Y': u'\uc8c0',
'\xa1Z': u'\uc8c1',
'\xa1\x81': u'\uc8e6',
'\xa1\x82': u'\uc8e7',
'\xa1\x83': u'\uc8e8',
'\xa1\x84': u'\uc8e9',
'\xa1\x85': u'\uc8ea',
'\xa1\x86': u'\uc8eb',
'\xa1\x87': u'\uc8ec',
'\xa1\x88': u'\uc8ed',
'\xa1\x89': u'\uc8ee',
'\xa1\x8a': u'\uc8ef',
'\xa1\x8b': u'\uc8f0',
'\xa1\x8c': u'\uc8f1',
'\xa1\x8d': u'\uc8f2',
'\xa1\x8e': u'\uc8f3',
'\xa1\x8f': u'\uc8f4',
'\xa1\x90': u'\uc8f6',
'\xa1\x91': u'\uc8f7',
'\xa1\x92': u'\uc8f8',
'\xa1\x93': u'\uc8f9',
'\xa1\x94': u'\uc8fa',
'\xa1\x95': u'\uc8fb',
'\xa1\x96': u'\uc8fe',
'\xa1\x97': u'\uc8ff',
'\xa1\x98': u'\uc901',
'\xa1\x99': u'\uc902',
'\xa1\x9a': u'\uc903',
'\xa1\x9b': u'\uc907',
'\xa1\x9c': u'\uc908',
'\xa1\x9d': u'\uc909',
'\xa1\x9e': u'\uc90a',
'\xa1\x9f': u'\uc90b',
'\xa1\xa0': u'\uc90e',
'\xa1a': u'\uc8c2',
'\xa1b': u'\uc8c3',
'\xa1c': u'\uc8c5',
'\xa1d': u'\uc8c6',
'\xa1e': u'\uc8c7',
'\xa1f': u'\uc8c9',
'\xa1g': u'\uc8ca',
'\xa1h': u'\uc8cb',
'\xa1i': u'\uc8cd',
'\xa1j': u'\uc8ce',
'\xa1k': u'\uc8cf',
'\xa1l': u'\uc8d0',
'\xa1m': u'\uc8d1',
'\xa1n': u'\uc8d2',
'\xa1o': u'\uc8d3',
'\xa1p': u'\uc8d6',
'\xa1q': u'\uc8d8',
'\xa1r': u'\uc8da',
'\xa1s': u'\uc8db',
'\xa1t': u'\uc8dc',
'\xa1u': u'\uc8dd',
'\xa1v': u'\uc8de',
'\xa1w': u'\uc8df',
'\xa1x': u'\uc8e2',
'\xa1y': u'\uc8e3',
'\xa1z': u'\uc8e5',
'\xa2A': u'\uc910',
'\xa2B': u'\uc912',
'\xa2C': u'\uc913',
'\xa2D': u'\uc914',
'\xa2E': u'\uc915',
'\xa2F': u'\uc916',
'\xa2G': u'\uc917',
'\xa2H': u'\uc919',
'\xa2I': u'\uc91a',
'\xa2J': u'\uc91b',
'\xa2K': u'\uc91c',
'\xa2L': u'\uc91d',
'\xa2M': u'\uc91e',
'\xa2N': u'\uc91f',
'\xa2O': u'\uc920',
'\xa2P': u'\uc921',
'\xa2Q': u'\uc922',
'\xa2R': u'\uc923',
'\xa2S': u'\uc924',
'\xa2T': u'\uc925',
'\xa2U': u'\uc926',
'\xa2V': u'\uc927',
'\xa2W': u'\uc928',
'\xa2X': u'\uc929',
'\xa2Y': u'\uc92a',
'\xa2Z': u'\uc92b',
'\xa2\x81': u'\uc948',
'\xa2\x82': u'\uc949',
'\xa2\x83': u'\uc94a',
'\xa2\x84': u'\uc94b',
'\xa2\x85': u'\uc94c',
'\xa2\x86': u'\uc94d',
'\xa2\x87': u'\uc94e',
'\xa2\x88': u'\uc94f',
'\xa2\x89': u'\uc952',
'\xa2\x8a': u'\uc953',
'\xa2\x8b': u'\uc955',
'\xa2\x8c': u'\uc956',
'\xa2\x8d': u'\uc957',
'\xa2\x8e': u'\uc959',
'\xa2\x8f': u'\uc95a',
'\xa2\x90': u'\uc95b',
'\xa2\x91': u'\uc95c',
'\xa2\x92': u'\uc95d',
'\xa2\x93': u'\uc95e',
'\xa2\x94': u'\uc95f',
'\xa2\x95': u'\uc962',
'\xa2\x96': u'\uc964',
'\xa2\x97': u'\uc965',
'\xa2\x98': u'\uc966',
'\xa2\x99': u'\uc967',
'\xa2\x9a': u'\uc968',
'\xa2\x9b': u'\uc969',
'\xa2\x9c': u'\uc96a',
'\xa2\x9d': u'\uc96b',
'\xa2\x9e': u'\uc96d',
'\xa2\x9f': u'\uc96e',
'\xa2\xa0': u'\uc96f',
'\xa2a': u'\uc92d',
'\xa2b': u'\uc92e',
'\xa2c': u'\uc92f',
'\xa2d': u'\uc930',
'\xa2e': u'\uc931',
'\xa2f': u'\uc932',
'\xa2g': u'\uc933',
'\xa2h': u'\uc935',
'\xa2i': u'\uc936',
'\xa2j': u'\uc937',
'\xa2k': u'\uc938',
'\xa2l': u'\uc939',
'\xa2m': u'\uc93a',
'\xa2n': u'\uc93b',
'\xa2o': u'\uc93c',
'\xa2p': u'\uc93d',
'\xa2q': u'\uc93e',
'\xa2r': u'\uc93f',
'\xa2s': u'\uc940',
'\xa2t': u'\uc941',
'\xa2u': u'\uc942',
'\xa2v': u'\uc943',
'\xa2w': u'\uc944',
'\xa2x': u'\uc945',
'\xa2y': u'\uc946',
'\xa2z': u'\uc947',
'\xa3A': u'\uc971',
'\xa3B': u'\uc972',
'\xa3C': u'\uc973',
'\xa3D': u'\uc975',
'\xa3E': u'\uc976',
'\xa3F': u'\uc977',
'\xa3G': u'\uc978',
'\xa3H': u'\uc979',
'\xa3I': u'\uc97a',
'\xa3J': u'\uc97b',
'\xa3K': u'\uc97d',
'\xa3L': u'\uc97e',
'\xa3M': u'\uc97f',
'\xa3N': u'\uc980',
'\xa3O': u'\uc981',
'\xa3P': u'\uc982',
'\xa3Q': u'\uc983',
'\xa3R': u'\uc984',
'\xa3S': u'\uc985',
'\xa3T': u'\uc986',
'\xa3U': u'\uc987',
'\xa3V': u'\uc98a',
'\xa3W': u'\uc98b',
'\xa3X': u'\uc98d',
'\xa3Y': u'\uc98e',
'\xa3Z': u'\uc98f',
'\xa3\x81': u'\uc9af',
'\xa3\x82': u'\uc9b0',
'\xa3\x83': u'\uc9b1',
'\xa3\x84': u'\uc9b2',
'\xa3\x85': u'\uc9b3',
'\xa3\x86': u'\uc9b4',
'\xa3\x87': u'\uc9b5',
'\xa3\x88': u'\uc9b6',
'\xa3\x89': u'\uc9b7',
'\xa3\x8a': u'\uc9b8',
'\xa3\x8b': u'\uc9b9',
'\xa3\x8c': u'\uc9ba',
'\xa3\x8d': u'\uc9bb',
'\xa3\x8e': u'\uc9bc',
'\xa3\x8f': u'\uc9bd',
'\xa3\x90': u'\uc9be',
'\xa3\x91': u'\uc9bf',
'\xa3\x92': u'\uc9c2',
'\xa3\x93': u'\uc9c3',
'\xa3\x94': u'\uc9c5',
'\xa3\x95': u'\uc9c6',
'\xa3\x96': u'\uc9c9',
'\xa3\x97': u'\uc9cb',
'\xa3\x98': u'\uc9cc',
'\xa3\x99': u'\uc9cd',
'\xa3\x9a': u'\uc9ce',
'\xa3\x9b': u'\uc9cf',
'\xa3\x9c': u'\uc9d2',
'\xa3\x9d': u'\uc9d4',
'\xa3\x9e': u'\uc9d7',
'\xa3\x9f': u'\uc9d8',
'\xa3\xa0': u'\uc9db',
'\xa3a': u'\uc991',
'\xa3b': u'\uc992',
'\xa3c': u'\uc993',
'\xa3d': u'\uc994',
'\xa3e': u'\uc995',
'\xa3f': u'\uc996',
'\xa3g': u'\uc997',
'\xa3h': u'\uc99a',
'\xa3i': u'\uc99c',
'\xa3j': u'\uc99e',
'\xa3k': u'\uc99f',
'\xa3l': u'\uc9a0',
'\xa3m': u'\uc9a1',
'\xa3n': u'\uc9a2',
'\xa3o': u'\uc9a3',
'\xa3p': u'\uc9a4',
'\xa3q': u'\uc9a5',
'\xa3r': u'\uc9a6',
'\xa3s': u'\uc9a7',
'\xa3t': u'\uc9a8',
'\xa3u': u'\uc9a9',
'\xa3v': u'\uc9aa',
'\xa3w': u'\uc9ab',
'\xa3x': u'\uc9ac',
'\xa3y': u'\uc9ad',
'\xa3z': u'\uc9ae',
'\xa4A': u'\uc9de',
'\xa4B': u'\uc9df',
'\xa4C': u'\uc9e1',
'\xa4D': u'\uc9e3',
'\xa4E': u'\uc9e5',
'\xa4F': u'\uc9e6',
'\xa4G': u'\uc9e8',
'\xa4H': u'\uc9e9',
'\xa4I': u'\uc9ea',
'\xa4J': u'\uc9eb',
'\xa4K': u'\uc9ee',
'\xa4L': u'\uc9f2',
'\xa4M': u'\uc9f3',
'\xa4N': u'\uc9f4',
'\xa4O': u'\uc9f5',
'\xa4P': u'\uc9f6',
'\xa4Q': u'\uc9f7',
'\xa4R': u'\uc9fa',
'\xa4S': u'\uc9fb',
'\xa4T': u'\uc9fd',
'\xa4U': u'\uc9fe',
'\xa4V': u'\uc9ff',
'\xa4W': u'\uca01',
'\xa4X': u'\uca02',
'\xa4Y': u'\uca03',
'\xa4Z': u'\uca04',
'\xa4\x81': u'\uca26',
'\xa4\x82': u'\uca27',
'\xa4\x83': u'\uca28',
'\xa4\x84': u'\uca2a',
'\xa4\x85': u'\uca2b',
'\xa4\x86': u'\uca2c',
'\xa4\x87': u'\uca2d',
'\xa4\x88': u'\uca2e',
'\xa4\x89': u'\uca2f',
'\xa4\x8a': u'\uca30',
'\xa4\x8b': u'\uca31',
'\xa4\x8c': u'\uca32',
'\xa4\x8d': u'\uca33',
'\xa4\x8e': u'\uca34',
'\xa4\x8f': u'\uca35',
'\xa4\x90': u'\uca36',
'\xa4\x91': u'\uca37',
'\xa4\x92': u'\uca38',
'\xa4\x93': u'\uca39',
'\xa4\x94': u'\uca3a',
'\xa4\x95': u'\uca3b',
'\xa4\x96': u'\uca3c',
'\xa4\x97': u'\uca3d',
'\xa4\x98': u'\uca3e',
'\xa4\x99': u'\uca3f',
'\xa4\x9a': u'\uca40',
'\xa4\x9b': u'\uca41',
'\xa4\x9c': u'\uca42',
'\xa4\x9d': u'\uca43',
'\xa4\x9e': u'\uca44',
'\xa4\x9f': u'\uca45',
'\xa4\xa0': u'\uca46',
'\xa4a': u'\uca05',
'\xa4b': u'\uca06',
'\xa4c': u'\uca07',
'\xa4d': u'\uca0a',
'\xa4e': u'\uca0e',
'\xa4f': u'\uca0f',
'\xa4g': u'\uca10',
'\xa4h': u'\uca11',
'\xa4i': u'\uca12',
'\xa4j': u'\uca13',
'\xa4k': u'\uca15',
'\xa4l': u'\uca16',
'\xa4m': u'\uca17',
'\xa4n': u'\uca19',
'\xa4o': u'\uca1a',
'\xa4p': u'\uca1b',
'\xa4q': u'\uca1c',
'\xa4r': u'\uca1d',
'\xa4s': u'\uca1e',
'\xa4t': u'\uca1f',
'\xa4u': u'\uca20',
'\xa4v': u'\uca21',
'\xa4w': u'\uca22',
'\xa4x': u'\uca23',
'\xa4y': u'\uca24',
'\xa4z': u'\uca25',
'\xa5A': u'\uca47',
'\xa5B': u'\uca48',
'\xa5C': u'\uca49',
'\xa5D': u'\uca4a',
'\xa5E': u'\uca4b',
'\xa5F': u'\uca4e',
'\xa5G': u'\uca4f',
'\xa5H': u'\uca51',
'\xa5I': u'\uca52',
'\xa5J': u'\uca53',
'\xa5K': u'\uca55',
'\xa5L': u'\uca56',
'\xa5M': u'\uca57',
'\xa5N': u'\uca58',
'\xa5O': u'\uca59',
'\xa5P': u'\uca5a',
'\xa5Q': u'\uca5b',
'\xa5R': u'\uca5e',
'\xa5S': u'\uca62',
'\xa5T': u'\uca63',
'\xa5U': u'\uca64',
'\xa5V': u'\uca65',
'\xa5W': u'\uca66',
'\xa5X': u'\uca67',
'\xa5Y': u'\uca69',
'\xa5Z': u'\uca6a',
'\xa5\x81': u'\uca87',
'\xa5\x82': u'\uca88',
'\xa5\x83': u'\uca89',
'\xa5\x84': u'\uca8a',
'\xa5\x85': u'\uca8b',
'\xa5\x86': u'\uca8c',
'\xa5\x87': u'\uca8d',
'\xa5\x88': u'\uca8e',
'\xa5\x89': u'\uca8f',
'\xa5\x8a': u'\uca90',
'\xa5\x8b': u'\uca91',
'\xa5\x8c': u'\uca92',
'\xa5\x8d': u'\uca93',
'\xa5\x8e': u'\uca94',
'\xa5\x8f': u'\uca95',
'\xa5\x90': u'\uca96',
'\xa5\x91': u'\uca97',
'\xa5\x92': u'\uca99',
'\xa5\x93': u'\uca9a',
'\xa5\x94': u'\uca9b',
'\xa5\x95': u'\uca9c',
'\xa5\x96': u'\uca9d',
'\xa5\x97': u'\uca9e',
'\xa5\x98': u'\uca9f',
'\xa5\x99': u'\ucaa0',
'\xa5\x9a': u'\ucaa1',
'\xa5\x9b': u'\ucaa2',
'\xa5\x9c': u'\ucaa3',
'\xa5\x9d': u'\ucaa4',
'\xa5\x9e': u'\ucaa5',
'\xa5\x9f': u'\ucaa6',
'\xa5\xa0': u'\ucaa7',
'\xa5a': u'\uca6b',
'\xa5b': u'\uca6c',
'\xa5c': u'\uca6d',
'\xa5d': u'\uca6e',
'\xa5e': u'\uca6f',
'\xa5f': u'\uca70',
'\xa5g': u'\uca71',
'\xa5h': u'\uca72',
'\xa5i': u'\uca73',
'\xa5j': u'\uca74',
'\xa5k': u'\uca75',
'\xa5l': u'\uca76',
'\xa5m': u'\uca77',
'\xa5n': u'\uca78',
'\xa5o': u'\uca79',
'\xa5p': u'\uca7a',
'\xa5q': u'\uca7b',
'\xa5r': u'\uca7c',
'\xa5s': u'\uca7e',
'\xa5t': u'\uca7f',
'\xa5u': u'\uca80',
'\xa5v': u'\uca81',
'\xa5w': u'\uca82',
'\xa5x': u'\uca83',
'\xa5y': u'\uca85',
'\xa5z': u'\uca86',
'\xa6A': u'\ucaa8',
'\xa6B': u'\ucaa9',
'\xa6C': u'\ucaaa',
'\xa6D': u'\ucaab',
'\xa6E': u'\ucaac',
'\xa6F': u'\ucaad',
'\xa6G': u'\ucaae',
'\xa6H': u'\ucaaf',
'\xa6I': u'\ucab0',
'\xa6J': u'\ucab1',
'\xa6K': u'\ucab2',
'\xa6L': u'\ucab3',
'\xa6M': u'\ucab4',
'\xa6N': u'\ucab5',
'\xa6O': u'\ucab6',
'\xa6P': u'\ucab7',
'\xa6Q': u'\ucab8',
'\xa6R': u'\ucab9',
'\xa6S': u'\ucaba',
'\xa6T': u'\ucabb',
'\xa6U': u'\ucabe',
'\xa6V': u'\ucabf',
'\xa6W': u'\ucac1',
'\xa6X': u'\ucac2',
'\xa6Y': u'\ucac3',
'\xa6Z': u'\ucac5',
'\xa6\x81': u'\ucae8',
'\xa6\x82': u'\ucae9',
'\xa6\x83': u'\ucaea',
'\xa6\x84': u'\ucaeb',
'\xa6\x85': u'\ucaed',
'\xa6\x86': u'\ucaee',
'\xa6\x87': u'\ucaef',
'\xa6\x88': u'\ucaf0',
'\xa6\x89': u'\ucaf1',
'\xa6\x8a': u'\ucaf2',
'\xa6\x8b': u'\ucaf3',
'\xa6\x8c': u'\ucaf5',
'\xa6\x8d': u'\ucaf6',
'\xa6\x8e': u'\ucaf7',
'\xa6\x8f': u'\ucaf8',
'\xa6\x90': u'\ucaf9',
'\xa6\x91': u'\ucafa',
'\xa6\x92': u'\ucafb',
'\xa6\x93': u'\ucafc',
'\xa6\x94': u'\ucafd',
'\xa6\x95': u'\ucafe',
'\xa6\x96': u'\ucaff',
'\xa6\x97': u'\ucb00',
'\xa6\x98': u'\ucb01',
'\xa6\x99': u'\ucb02',
'\xa6\x9a': u'\ucb03',
'\xa6\x9b': u'\ucb04',
'\xa6\x9c': u'\ucb05',
'\xa6\x9d': u'\ucb06',
'\xa6\x9e': u'\ucb07',
'\xa6\x9f': u'\ucb09',
'\xa6\xa0': u'\ucb0a',
'\xa6a': u'\ucac6',
'\xa6b': u'\ucac7',
'\xa6c': u'\ucac8',
'\xa6d': u'\ucac9',
'\xa6e': u'\ucaca',
'\xa6f': u'\ucacb',
'\xa6g': u'\ucace',
'\xa6h': u'\ucad0',
'\xa6i': u'\ucad2',
'\xa6j': u'\ucad4',
'\xa6k': u'\ucad5',
'\xa6l': u'\ucad6',
'\xa6m': u'\ucad7',
'\xa6n': u'\ucada',
'\xa6o': u'\ucadb',
'\xa6p': u'\ucadc',
'\xa6q': u'\ucadd',
'\xa6r': u'\ucade',
'\xa6s': u'\ucadf',
'\xa6t': u'\ucae1',
'\xa6u': u'\ucae2',
'\xa6v': u'\ucae3',
'\xa6w': u'\ucae4',
'\xa6x': u'\ucae5',
'\xa6y': u'\ucae6',
'\xa6z': u'\ucae7',
'\xa7A': u'\ucb0b',
'\xa7B': u'\ucb0c',
'\xa7C': u'\ucb0d',
'\xa7D': u'\ucb0e',
'\xa7E': u'\ucb0f',
'\xa7F': u'\ucb11',
'\xa7G': u'\ucb12',
'\xa7H': u'\ucb13',
'\xa7I': u'\ucb15',
'\xa7J': u'\ucb16',
'\xa7K': u'\ucb17',
'\xa7L': u'\ucb19',
'\xa7M': u'\ucb1a',
'\xa7N': u'\ucb1b',
'\xa7O': u'\ucb1c',
'\xa7P': u'\ucb1d',
'\xa7Q': u'\ucb1e',
'\xa7R': u'\ucb1f',
'\xa7S': u'\ucb22',
'\xa7T': u'\ucb23',
'\xa7U': u'\ucb24',
'\xa7V': u'\ucb25',
'\xa7W': u'\ucb26',
'\xa7X': u'\ucb27',
'\xa7Y': u'\ucb28',
'\xa7Z': u'\ucb29',
'\xa7\x81': u'\ucb45',
'\xa7\x82': u'\ucb46',
'\xa7\x83': u'\ucb47',
'\xa7\x84': u'\ucb4a',
'\xa7\x85': u'\ucb4b',
'\xa7\x86': u'\ucb4d',
'\xa7\x87': u'\ucb4e',
'\xa7\x88': u'\ucb4f',
'\xa7\x89': u'\ucb51',
'\xa7\x8a': u'\ucb52',
'\xa7\x8b': u'\ucb53',
'\xa7\x8c': u'\ucb54',
'\xa7\x8d': u'\ucb55',
'\xa7\x8e': u'\ucb56',
'\xa7\x8f': u'\ucb57',
'\xa7\x90': u'\ucb5a',
'\xa7\x91': u'\ucb5b',
'\xa7\x92': u'\ucb5c',
'\xa7\x93': u'\ucb5e',
'\xa7\x94': u'\ucb5f',
'\xa7\x95': u'\ucb60',
'\xa7\x96': u'\ucb61',
'\xa7\x97': u'\ucb62',
'\xa7\x98': u'\ucb63',
'\xa7\x99': u'\ucb65',
'\xa7\x9a': u'\ucb66',
'\xa7\x9b': u'\ucb67',
'\xa7\x9c': u'\ucb68',
'\xa7\x9d': u'\ucb69',
'\xa7\x9e': u'\ucb6a',
'\xa7\x9f': u'\ucb6b',
'\xa7\xa0': u'\ucb6c',
'\xa7a': u'\ucb2a',
'\xa7b': u'\ucb2b',
'\xa7c': u'\ucb2c',
'\xa7d': u'\ucb2d',
'\xa7e': u'\ucb2e',
'\xa7f': u'\ucb2f',
'\xa7g': u'\ucb30',
'\xa7h': u'\ucb31',
'\xa7i': u'\ucb32',
'\xa7j': u'\ucb33',
'\xa7k': u'\ucb34',
'\xa7l': u'\ucb35',
'\xa7m': u'\ucb36',
'\xa7n': u'\ucb37',
'\xa7o': u'\ucb38',
'\xa7p': u'\ucb39',
'\xa7q': u'\ucb3a',
'\xa7r': u'\ucb3b',
'\xa7s': u'\ucb3c',
'\xa7t': u'\ucb3d',
'\xa7u': u'\ucb3e',
'\xa7v': u'\ucb3f',
'\xa7w': u'\ucb40',
'\xa7x': u'\ucb42',
'\xa7y': u'\ucb43',
'\xa7z': u'\ucb44',
'\xa8A': u'\ucb6d',
'\xa8B': u'\ucb6e',
'\xa8C': u'\ucb6f',
'\xa8D': u'\ucb70',
'\xa8E': u'\ucb71',
'\xa8F': u'\ucb72',
'\xa8G': u'\ucb73',
'\xa8H': u'\ucb74',
'\xa8I': u'\ucb75',
'\xa8J': u'\ucb76',
'\xa8K': u'\ucb77',
'\xa8L': u'\ucb7a',
'\xa8M': u'\ucb7b',
'\xa8N': u'\ucb7c',
'\xa8O': u'\ucb7d',
'\xa8P': u'\ucb7e',
'\xa8Q': u'\ucb7f',
'\xa8R': u'\ucb80',
'\xa8S': u'\ucb81',
'\xa8T': u'\ucb82',
'\xa8U': u'\ucb83',
'\xa8V': u'\ucb84',
'\xa8W': u'\ucb85',
'\xa8X': u'\ucb86',
'\xa8Y': u'\ucb87',
'\xa8Z': u'\ucb88',
'\xa8\x81': u'\ucba4',
'\xa8\x82': u'\ucba5',
'\xa8\x83': u'\ucba6',
'\xa8\x84': u'\ucba7',
'\xa8\x85': u'\ucba8',
'\xa8\x86': u'\ucba9',
'\xa8\x87': u'\ucbaa',
'\xa8\x88': u'\ucbab',
'\xa8\x89': u'\ucbac',
'\xa8\x8a': u'\ucbad',
'\xa8\x8b': u'\ucbae',
'\xa8\x8c': u'\ucbaf',
'\xa8\x8d': u'\ucbb0',
'\xa8\x8e': u'\ucbb1',
'\xa8\x8f': u'\ucbb2',
'\xa8\x90': u'\ucbb3',
'\xa8\x91': u'\ucbb4',
'\xa8\x92': u'\ucbb5',
'\xa8\x93': u'\ucbb6',
'\xa8\x94': u'\ucbb7',
'\xa8\x95': u'\ucbb9',
'\xa8\x96': u'\ucbba',
'\xa8\x97': u'\ucbbb',
'\xa8\x98': u'\ucbbc',
'\xa8\x99': u'\ucbbd',
'\xa8\x9a': u'\ucbbe',
'\xa8\x9b': u'\ucbbf',
'\xa8\x9c': u'\ucbc0',
'\xa8\x9d': u'\ucbc1',
'\xa8\x9e': u'\ucbc2',
'\xa8\x9f': u'\ucbc3',
'\xa8\xa0': u'\ucbc4',
'\xa8a': u'\ucb89',
'\xa8b': u'\ucb8a',
'\xa8c': u'\ucb8b',
'\xa8d': u'\ucb8c',
'\xa8e': u'\ucb8d',
'\xa8f': u'\ucb8e',
'\xa8g': u'\ucb8f',
'\xa8h': u'\ucb90',
'\xa8i': u'\ucb91',
'\xa8j': u'\ucb92',
'\xa8k': u'\ucb93',
'\xa8l': u'\ucb94',
'\xa8m': u'\ucb95',
'\xa8n': u'\ucb96',
'\xa8o': u'\ucb97',
'\xa8p': u'\ucb98',
'\xa8q': u'\ucb99',
'\xa8r': u'\ucb9a',
'\xa8s': u'\ucb9b',
'\xa8t': u'\ucb9d',
'\xa8u': u'\ucb9e',
'\xa8v': u'\ucb9f',
'\xa8w': u'\ucba0',
'\xa8x': u'\ucba1',
'\xa8y': u'\ucba2',
'\xa8z': u'\ucba3',
'\xa9A': u'\ucbc5',
'\xa9B': u'\ucbc6',
'\xa9C': u'\ucbc7',
'\xa9D': u'\ucbc8',
'\xa9E': u'\ucbc9',
'\xa9F': u'\ucbca',
'\xa9G': u'\ucbcb',
'\xa9H': u'\ucbcc',
'\xa9I': u'\ucbcd',
'\xa9J': u'\ucbce',
'\xa9K': u'\ucbcf',
'\xa9L': u'\ucbd0',
'\xa9M': u'\ucbd1',
'\xa9N': u'\ucbd2',
'\xa9O': u'\ucbd3',
'\xa9P': u'\ucbd5',
'\xa9Q': u'\ucbd6',
'\xa9R': u'\ucbd7',
'\xa9S': u'\ucbd8',
'\xa9T': u'\ucbd9',
'\xa9U': u'\ucbda',
'\xa9V': u'\ucbdb',
'\xa9W': u'\ucbdc',
'\xa9X': u'\ucbdd',
'\xa9Y': u'\ucbde',
'\xa9Z': u'\ucbdf',
'\xa9\x81': u'\ucbfd',
'\xa9\x82': u'\ucbfe',
'\xa9\x83': u'\ucbff',
'\xa9\x84': u'\ucc00',
'\xa9\x85': u'\ucc01',
'\xa9\x86': u'\ucc02',
'\xa9\x87': u'\ucc03',
'\xa9\x88': u'\ucc04',
'\xa9\x89': u'\ucc05',
'\xa9\x8a': u'\ucc06',
'\xa9\x8b': u'\ucc07',
'\xa9\x8c': u'\ucc08',
'\xa9\x8d': u'\ucc09',
'\xa9\x8e': u'\ucc0a',
'\xa9\x8f': u'\ucc0b',
'\xa9\x90': u'\ucc0e',
'\xa9\x91': u'\ucc0f',
'\xa9\x92': u'\ucc11',
'\xa9\x93': u'\ucc12',
'\xa9\x94': u'\ucc13',
'\xa9\x95': u'\ucc15',
'\xa9\x96': u'\ucc16',
'\xa9\x97': u'\ucc17',
'\xa9\x98': u'\ucc18',
'\xa9\x99': u'\ucc19',
'\xa9\x9a': u'\ucc1a',
'\xa9\x9b': u'\ucc1b',
'\xa9\x9c': u'\ucc1e',
'\xa9\x9d': u'\ucc1f',
'\xa9\x9e': u'\ucc20',
'\xa9\x9f': u'\ucc23',
'\xa9\xa0': u'\ucc24',
'\xa9a': u'\ucbe0',
'\xa9b': u'\ucbe1',
'\xa9c': u'\ucbe2',
'\xa9d': u'\ucbe3',
'\xa9e': u'\ucbe5',
'\xa9f': u'\ucbe6',
'\xa9g': u'\ucbe8',
'\xa9h': u'\ucbea',
'\xa9i': u'\ucbeb',
'\xa9j': u'\ucbec',
'\xa9k': u'\ucbed',
'\xa9l': u'\ucbee',
'\xa9m': u'\ucbef',
'\xa9n': u'\ucbf0',
'\xa9o': u'\ucbf1',
'\xa9p': u'\ucbf2',
'\xa9q': u'\ucbf3',
'\xa9r': u'\ucbf4',
'\xa9s': u'\ucbf5',
'\xa9t': u'\ucbf6',
'\xa9u': u'\ucbf7',
'\xa9v': u'\ucbf8',
'\xa9w': u'\ucbf9',
'\xa9x': u'\ucbfa',
'\xa9y': u'\ucbfb',
'\xa9z': u'\ucbfc',
'\xaaA': u'\ucc25',
'\xaaB': u'\ucc26',
'\xaaC': u'\ucc2a',
'\xaaD': u'\ucc2b',
'\xaaE': u'\ucc2d',
'\xaaF': u'\ucc2f',
'\xaaG': u'\ucc31',
'\xaaH': u'\ucc32',
'\xaaI': u'\ucc33',
'\xaaJ': u'\ucc34',
'\xaaK': u'\ucc35',
'\xaaL': u'\ucc36',
'\xaaM': u'\ucc37',
'\xaaN': u'\ucc3a',
'\xaaO': u'\ucc3f',
'\xaaP': u'\ucc40',
'\xaaQ': u'\ucc41',
'\xaaR': u'\ucc42',
'\xaaS': u'\ucc43',
'\xaaT': u'\ucc46',
'\xaaU': u'\ucc47',
'\xaaV': u'\ucc49',
'\xaaW': u'\ucc4a',
'\xaaX': u'\ucc4b',
'\xaaY': u'\ucc4d',
'\xaaZ': u'\ucc4e',
'\xaa\x81': u'\ucc73',
'\xaa\x82': u'\ucc74',
'\xaa\x83': u'\ucc76',
'\xaa\x84': u'\ucc77',
'\xaa\x85': u'\ucc78',
'\xaa\x86': u'\ucc79',
'\xaa\x87': u'\ucc7a',
'\xaa\x88': u'\ucc7b',
'\xaa\x89': u'\ucc7c',
'\xaa\x8a': u'\ucc7d',
'\xaa\x8b': u'\ucc7e',
'\xaa\x8c': u'\ucc7f',
'\xaa\x8d': u'\ucc80',
'\xaa\x8e': u'\ucc81',
'\xaa\x8f': u'\ucc82',
'\xaa\x90': u'\ucc83',
'\xaa\x91': u'\ucc84',
'\xaa\x92': u'\ucc85',
'\xaa\x93': u'\ucc86',
'\xaa\x94': u'\ucc87',
'\xaa\x95': u'\ucc88',
'\xaa\x96': u'\ucc89',
'\xaa\x97': u'\ucc8a',
'\xaa\x98': u'\ucc8b',
'\xaa\x99': u'\ucc8c',
'\xaa\x9a': u'\ucc8d',
'\xaa\x9b': u'\ucc8e',
'\xaa\x9c': u'\ucc8f',
'\xaa\x9d': u'\ucc90',
'\xaa\x9e': u'\ucc91',
'\xaa\x9f': u'\ucc92',
'\xaa\xa0': u'\ucc93',
'\xaaa': u'\ucc4f',
'\xaab': u'\ucc50',
'\xaac': u'\ucc51',
'\xaad': u'\ucc52',
'\xaae': u'\ucc53',
'\xaaf': u'\ucc56',
'\xaag': u'\ucc5a',
'\xaah': u'\ucc5b',
'\xaai': u'\ucc5c',
'\xaaj': u'\ucc5d',
'\xaak': u'\ucc5e',
'\xaal': u'\ucc5f',
'\xaam': u'\ucc61',
'\xaan': u'\ucc62',
'\xaao': u'\ucc63',
'\xaap': u'\ucc65',
'\xaaq': u'\ucc67',
'\xaar': u'\ucc69',
'\xaas': u'\ucc6a',
'\xaat': u'\ucc6b',
'\xaau': u'\ucc6c',
'\xaav': u'\ucc6d',
'\xaaw': u'\ucc6e',
'\xaax': u'\ucc6f',
'\xaay': u'\ucc71',
'\xaaz': u'\ucc72',
'\xabA': u'\ucc94',
'\xabB': u'\ucc95',
'\xabC': u'\ucc96',
'\xabD': u'\ucc97',
'\xabE': u'\ucc9a',
'\xabF': u'\ucc9b',
'\xabG': u'\ucc9d',
'\xabH': u'\ucc9e',
'\xabI': u'\ucc9f',
'\xabJ': u'\ucca1',
'\xabK': u'\ucca2',
'\xabL': u'\ucca3',
'\xabM': u'\ucca4',
'\xabN': u'\ucca5',
'\xabO': u'\ucca6',
'\xabP': u'\ucca7',
'\xabQ': u'\uccaa',
'\xabR': u'\uccae',
'\xabS': u'\uccaf',
'\xabT': u'\uccb0',
'\xabU': u'\uccb1',
'\xabV': u'\uccb2',
'\xabW': u'\uccb3',
'\xabX': u'\uccb6',
'\xabY': u'\uccb7',
'\xabZ': u'\uccb9',
'\xab\x81': u'\uccdb',
'\xab\x82': u'\uccdc',
'\xab\x83': u'\uccdd',
'\xab\x84': u'\uccde',
'\xab\x85': u'\uccdf',
'\xab\x86': u'\ucce0',
'\xab\x87': u'\ucce1',
'\xab\x88': u'\ucce2',
'\xab\x89': u'\ucce3',
'\xab\x8a': u'\ucce5',
'\xab\x8b': u'\ucce6',
'\xab\x8c': u'\ucce7',
'\xab\x8d': u'\ucce8',
'\xab\x8e': u'\ucce9',
'\xab\x8f': u'\uccea',
'\xab\x90': u'\ucceb',
'\xab\x91': u'\ucced',
'\xab\x92': u'\uccee',
'\xab\x93': u'\uccef',
'\xab\x94': u'\uccf1',
'\xab\x95': u'\uccf2',
'\xab\x96': u'\uccf3',
'\xab\x97': u'\uccf4',
'\xab\x98': u'\uccf5',
'\xab\x99': u'\uccf6',
'\xab\x9a': u'\uccf7',
'\xab\x9b': u'\uccf8',
'\xab\x9c': u'\uccf9',
'\xab\x9d': u'\uccfa',
'\xab\x9e': u'\uccfb',
'\xab\x9f': u'\uccfc',
'\xab\xa0': u'\uccfd',
'\xaba': u'\uccba',
'\xabb': u'\uccbb',
'\xabc': u'\uccbd',
'\xabd': u'\uccbe',
'\xabe': u'\uccbf',
'\xabf': u'\uccc0',
'\xabg': u'\uccc1',
'\xabh': u'\uccc2',
'\xabi': u'\uccc3',
'\xabj': u'\uccc6',
'\xabk': u'\uccc8',
'\xabl': u'\uccca',
'\xabm': u'\ucccb',
'\xabn': u'\ucccc',
'\xabo': u'\ucccd',
'\xabp': u'\uccce',
'\xabq': u'\ucccf',
'\xabr': u'\uccd1',
'\xabs': u'\uccd2',
'\xabt': u'\uccd3',
'\xabu': u'\uccd5',
'\xabv': u'\uccd6',
'\xabw': u'\uccd7',
'\xabx': u'\uccd8',
'\xaby': u'\uccd9',
'\xabz': u'\uccda',
'\xacA': u'\uccfe',
'\xacB': u'\uccff',
'\xacC': u'\ucd00',
'\xacD': u'\ucd02',
'\xacE': u'\ucd03',
'\xacF': u'\ucd04',
'\xacG': u'\ucd05',
'\xacH': u'\ucd06',
'\xacI': u'\ucd07',
'\xacJ': u'\ucd0a',
'\xacK': u'\ucd0b',
'\xacL': u'\ucd0d',
'\xacM': u'\ucd0e',
'\xacN': u'\ucd0f',
'\xacO': u'\ucd11',
'\xacP': u'\ucd12',
'\xacQ': u'\ucd13',
'\xacR': u'\ucd14',
'\xacS': u'\ucd15',
'\xacT': u'\ucd16',
'\xacU': u'\ucd17',
'\xacV': u'\ucd1a',
'\xacW': u'\ucd1c',
'\xacX': u'\ucd1e',
'\xacY': u'\ucd1f',
'\xacZ': u'\ucd20',
'\xac\x81': u'\ucd3f',
'\xac\x82': u'\ucd40',
'\xac\x83': u'\ucd41',
'\xac\x84': u'\ucd42',
'\xac\x85': u'\ucd43',
'\xac\x86': u'\ucd44',
'\xac\x87': u'\ucd45',
'\xac\x88': u'\ucd46',
'\xac\x89': u'\ucd47',
'\xac\x8a': u'\ucd48',
'\xac\x8b': u'\ucd49',
'\xac\x8c': u'\ucd4a',
'\xac\x8d': u'\ucd4b',
'\xac\x8e': u'\ucd4c',
'\xac\x8f': u'\ucd4d',
'\xac\x90': u'\ucd4e',
'\xac\x91': u'\ucd4f',
'\xac\x92': u'\ucd50',
'\xac\x93': u'\ucd51',
'\xac\x94': u'\ucd52',
'\xac\x95': u'\ucd53',
'\xac\x96': u'\ucd54',
'\xac\x97': u'\ucd55',
'\xac\x98': u'\ucd56',
'\xac\x99': u'\ucd57',
'\xac\x9a': u'\ucd58',
'\xac\x9b': u'\ucd59',
'\xac\x9c': u'\ucd5a',
'\xac\x9d': u'\ucd5b',
'\xac\x9e': u'\ucd5d',
'\xac\x9f': u'\ucd5e',
'\xac\xa0': u'\ucd5f',
'\xaca': u'\ucd21',
'\xacb': u'\ucd22',
'\xacc': u'\ucd23',
'\xacd': u'\ucd25',
'\xace': u'\ucd26',
'\xacf': u'\ucd27',
'\xacg': u'\ucd29',
'\xach': u'\ucd2a',
'\xaci': u'\ucd2b',
'\xacj': u'\ucd2d',
'\xack': u'\ucd2e',
'\xacl': u'\ucd2f',
'\xacm': u'\ucd30',
'\xacn': u'\ucd31',
'\xaco': u'\ucd32',
'\xacp': u'\ucd33',
'\xacq': u'\ucd34',
'\xacr': u'\ucd35',
'\xacs': u'\ucd36',
'\xact': u'\ucd37',
'\xacu': u'\ucd38',
'\xacv': u'\ucd3a',
'\xacw': u'\ucd3b',
'\xacx': u'\ucd3c',
'\xacy': u'\ucd3d',
'\xacz': u'\ucd3e',
'\xadA': u'\ucd61',
'\xadB': u'\ucd62',
'\xadC': u'\ucd63',
'\xadD': u'\ucd65',
'\xadE': u'\ucd66',
'\xadF': u'\ucd67',
'\xadG': u'\ucd68',
'\xadH': u'\ucd69',
'\xadI': u'\ucd6a',
'\xadJ': u'\ucd6b',
'\xadK': u'\ucd6e',
'\xadL': u'\ucd70',
'\xadM': u'\ucd72',
'\xadN': u'\ucd73',
'\xadO': u'\ucd74',
'\xadP': u'\ucd75',
'\xadQ': u'\ucd76',
'\xadR': u'\ucd77',
'\xadS': u'\ucd79',
'\xadT': u'\ucd7a',
'\xadU': u'\ucd7b',
'\xadV': u'\ucd7c',
'\xadW': u'\ucd7d',
'\xadX': u'\ucd7e',
'\xadY': u'\ucd7f',
'\xadZ': u'\ucd80',
'\xad\x81': u'\ucda0',
'\xad\x82': u'\ucda1',
'\xad\x83': u'\ucda2',
'\xad\x84': u'\ucda3',
'\xad\x85': u'\ucda6',
'\xad\x86': u'\ucda8',
'\xad\x87': u'\ucdaa',
'\xad\x88': u'\ucdab',
'\xad\x89': u'\ucdac',
'\xad\x8a': u'\ucdad',
'\xad\x8b': u'\ucdae',
'\xad\x8c': u'\ucdaf',
'\xad\x8d': u'\ucdb1',
'\xad\x8e': u'\ucdb2',
'\xad\x8f': u'\ucdb3',
'\xad\x90': u'\ucdb4',
'\xad\x91': u'\ucdb5',
'\xad\x92': u'\ucdb6',
'\xad\x93': u'\ucdb7',
'\xad\x94': u'\ucdb8',
'\xad\x95': u'\ucdb9',
'\xad\x96': u'\ucdba',
'\xad\x97': u'\ucdbb',
'\xad\x98': u'\ucdbc',
'\xad\x99': u'\ucdbd',
'\xad\x9a': u'\ucdbe',
'\xad\x9b': u'\ucdbf',
'\xad\x9c': u'\ucdc0',
'\xad\x9d': u'\ucdc1',
'\xad\x9e': u'\ucdc2',
'\xad\x9f': u'\ucdc3',
'\xad\xa0': u'\ucdc5',
'\xada': u'\ucd81',
'\xadb': u'\ucd82',
'\xadc': u'\ucd83',
'\xadd': u'\ucd84',
'\xade': u'\ucd85',
'\xadf': u'\ucd86',
'\xadg': u'\ucd87',
'\xadh': u'\ucd89',
'\xadi': u'\ucd8a',
'\xadj': u'\ucd8b',
'\xadk': u'\ucd8c',
'\xadl': u'\ucd8d',
'\xadm': u'\ucd8e',
'\xadn': u'\ucd8f',
'\xado': u'\ucd90',
'\xadp': u'\ucd91',
'\xadq': u'\ucd92',
'\xadr': u'\ucd93',
'\xads': u'\ucd96',
'\xadt': u'\ucd97',
'\xadu': u'\ucd99',
'\xadv': u'\ucd9a',
'\xadw': u'\ucd9b',
'\xadx': u'\ucd9d',
'\xady': u'\ucd9e',
'\xadz': u'\ucd9f',
'\xaeA': u'\ucdc6',
'\xaeB': u'\ucdc7',
'\xaeC': u'\ucdc8',
'\xaeD': u'\ucdc9',
'\xaeE': u'\ucdca',
'\xaeF': u'\ucdcb',
'\xaeG': u'\ucdcd',
'\xaeH': u'\ucdce',
'\xaeI': u'\ucdcf',
'\xaeJ': u'\ucdd1',
'\xaeK': u'\ucdd2',
'\xaeL': u'\ucdd3',
'\xaeM': u'\ucdd4',
'\xaeN': u'\ucdd5',
'\xaeO': u'\ucdd6',
'\xaeP': u'\ucdd7',
'\xaeQ': u'\ucdd8',
'\xaeR': u'\ucdd9',
'\xaeS': u'\ucdda',
'\xaeT': u'\ucddb',
'\xaeU': u'\ucddc',
'\xaeV': u'\ucddd',
'\xaeW': u'\ucdde',
'\xaeX': u'\ucddf',
'\xaeY': u'\ucde0',
'\xaeZ': u'\ucde1',
'\xae\x81': u'\uce03',
'\xae\x82': u'\uce05',
'\xae\x83': u'\uce06',
'\xae\x84': u'\uce07',
'\xae\x85': u'\uce09',
'\xae\x86': u'\uce0a',
'\xae\x87': u'\uce0b',
'\xae\x88': u'\uce0d',
'\xae\x89': u'\uce0e',
'\xae\x8a': u'\uce0f',
'\xae\x8b': u'\uce10',
'\xae\x8c': u'\uce11',
'\xae\x8d': u'\uce12',
'\xae\x8e': u'\uce13',
'\xae\x8f': u'\uce15',
'\xae\x90': u'\uce16',
'\xae\x91': u'\uce17',
'\xae\x92': u'\uce18',
'\xae\x93': u'\uce1a',
'\xae\x94': u'\uce1b',
'\xae\x95': u'\uce1c',
'\xae\x96': u'\uce1d',
'\xae\x97': u'\uce1e',
'\xae\x98': u'\uce1f',
'\xae\x99': u'\uce22',
'\xae\x9a': u'\uce23',
'\xae\x9b': u'\uce25',
'\xae\x9c': u'\uce26',
'\xae\x9d': u'\uce27',
'\xae\x9e': u'\uce29',
'\xae\x9f': u'\uce2a',
'\xae\xa0': u'\uce2b',
'\xaea': u'\ucde2',
'\xaeb': u'\ucde3',
'\xaec': u'\ucde4',
'\xaed': u'\ucde5',
'\xaee': u'\ucde6',
'\xaef': u'\ucde7',
'\xaeg': u'\ucde9',
'\xaeh': u'\ucdea',
'\xaei': u'\ucdeb',
'\xaej': u'\ucded',
'\xaek': u'\ucdee',
'\xael': u'\ucdef',
'\xaem': u'\ucdf1',
'\xaen': u'\ucdf2',
'\xaeo': u'\ucdf3',
'\xaep': u'\ucdf4',
'\xaeq': u'\ucdf5',
'\xaer': u'\ucdf6',
'\xaes': u'\ucdf7',
'\xaet': u'\ucdfa',
'\xaeu': u'\ucdfc',
'\xaev': u'\ucdfe',
'\xaew': u'\ucdff',
'\xaex': u'\uce00',
'\xaey': u'\uce01',
'\xaez': u'\uce02',
'\xafA': u'\uce2c',
'\xafB': u'\uce2d',
'\xafC': u'\uce2e',
'\xafD': u'\uce2f',
'\xafE': u'\uce32',
'\xafF': u'\uce34',
'\xafG': u'\uce36',
'\xafH': u'\uce37',
'\xafI': u'\uce38',
'\xafJ': u'\uce39',
'\xafK': u'\uce3a',
'\xafL': u'\uce3b',
'\xafM': u'\uce3c',
'\xafN': u'\uce3d',
'\xafO': u'\uce3e',
'\xafP': u'\uce3f',
'\xafQ': u'\uce40',
'\xafR': u'\uce41',
'\xafS': u'\uce42',
'\xafT': u'\uce43',
'\xafU': u'\uce44',
'\xafV': u'\uce45',
'\xafW': u'\uce46',
'\xafX': u'\uce47',
'\xafY': u'\uce48',
'\xafZ': u'\uce49',
'\xaf\x81': u'\uce6e',
'\xaf\x82': u'\uce6f',
'\xaf\x83': u'\uce70',
'\xaf\x84': u'\uce71',
'\xaf\x85': u'\uce72',
'\xaf\x86': u'\uce73',
'\xaf\x87': u'\uce76',
'\xaf\x88': u'\uce77',
'\xaf\x89': u'\uce79',
'\xaf\x8a': u'\uce7a',
'\xaf\x8b': u'\uce7b',
'\xaf\x8c': u'\uce7d',
'\xaf\x8d': u'\uce7e',
'\xaf\x8e': u'\uce7f',
'\xaf\x8f': u'\uce80',
'\xaf\x90': u'\uce81',
'\xaf\x91': u'\uce82',
'\xaf\x92': u'\uce83',
'\xaf\x93': u'\uce86',
'\xaf\x94': u'\uce88',
'\xaf\x95': u'\uce8a',
'\xaf\x96': u'\uce8b',
'\xaf\x97': u'\uce8c',
'\xaf\x98': u'\uce8d',
'\xaf\x99': u'\uce8e',
'\xaf\x9a': u'\uce8f',
'\xaf\x9b': u'\uce92',
'\xaf\x9c': u'\uce93',
'\xaf\x9d': u'\uce95',
'\xaf\x9e': u'\uce96',
'\xaf\x9f': u'\uce97',
'\xaf\xa0': u'\uce99',
'\xafa': u'\uce4a',
'\xafb': u'\uce4b',
'\xafc': u'\uce4c',
'\xafd': u'\uce4d',
'\xafe': u'\uce4e',
'\xaff': u'\uce4f',
'\xafg': u'\uce50',
'\xafh': u'\uce51',
'\xafi': u'\uce52',
'\xafj': u'\uce53',
'\xafk': u'\uce54',
'\xafl': u'\uce55',
'\xafm': u'\uce56',
'\xafn': u'\uce57',
'\xafo': u'\uce5a',
'\xafp': u'\uce5b',
'\xafq': u'\uce5d',
'\xafr': u'\uce5e',
'\xafs': u'\uce62',
'\xaft': u'\uce63',
'\xafu': u'\uce64',
'\xafv': u'\uce65',
'\xafw': u'\uce66',
'\xafx': u'\uce67',
'\xafy': u'\uce6a',
'\xafz': u'\uce6c',
'\xb0A': u'\uce9a',
'\xb0B': u'\uce9b',
'\xb0C': u'\uce9c',
'\xb0D': u'\uce9d',
'\xb0E': u'\uce9e',
'\xb0F': u'\uce9f',
'\xb0G': u'\ucea2',
'\xb0H': u'\ucea6',
'\xb0I': u'\ucea7',
'\xb0J': u'\ucea8',
'\xb0K': u'\ucea9',
'\xb0L': u'\uceaa',
'\xb0M': u'\uceab',
'\xb0N': u'\uceae',
'\xb0O': u'\uceaf',
'\xb0P': u'\uceb0',
'\xb0Q': u'\uceb1',
'\xb0R': u'\uceb2',
'\xb0S': u'\uceb3',
'\xb0T': u'\uceb4',
'\xb0U': u'\uceb5',
'\xb0V': u'\uceb6',
'\xb0W': u'\uceb7',
'\xb0X': u'\uceb8',
'\xb0Y': u'\uceb9',
'\xb0Z': u'\uceba',
'\xb0\x81': u'\uced6',
'\xb0\x82': u'\uced7',
'\xb0\x83': u'\uced8',
'\xb0\x84': u'\uced9',
'\xb0\x85': u'\uceda',
'\xb0\x86': u'\ucedb',
'\xb0\x87': u'\ucedc',
'\xb0\x88': u'\ucedd',
'\xb0\x89': u'\ucede',
'\xb0\x8a': u'\ucedf',
'\xb0\x8b': u'\ucee0',
'\xb0\x8c': u'\ucee1',
'\xb0\x8d': u'\ucee2',
'\xb0\x8e': u'\ucee3',
'\xb0\x8f': u'\ucee6',
'\xb0\x90': u'\ucee7',
'\xb0\x91': u'\ucee9',
'\xb0\x92': u'\uceea',
'\xb0\x93': u'\uceed',
'\xb0\x94': u'\uceee',
'\xb0\x95': u'\uceef',
'\xb0\x96': u'\ucef0',
'\xb0\x97': u'\ucef1',
'\xb0\x98': u'\ucef2',
'\xb0\x99': u'\ucef3',
'\xb0\x9a': u'\ucef6',
'\xb0\x9b': u'\ucefa',
'\xb0\x9c': u'\ucefb',
'\xb0\x9d': u'\ucefc',
'\xb0\x9e': u'\ucefd',
'\xb0\x9f': u'\ucefe',
'\xb0\xa0': u'\uceff',
'\xb0a': u'\ucebb',
'\xb0b': u'\ucebc',
'\xb0c': u'\ucebd',
'\xb0d': u'\ucebe',
'\xb0e': u'\ucebf',
'\xb0f': u'\ucec0',
'\xb0g': u'\ucec2',
'\xb0h': u'\ucec3',
'\xb0i': u'\ucec4',
'\xb0j': u'\ucec5',
'\xb0k': u'\ucec6',
'\xb0l': u'\ucec7',
'\xb0m': u'\ucec8',
'\xb0n': u'\ucec9',
'\xb0o': u'\uceca',
'\xb0p': u'\ucecb',
'\xb0q': u'\ucecc',
'\xb0r': u'\ucecd',
'\xb0s': u'\ucece',
'\xb0t': u'\ucecf',
'\xb0u': u'\uced0',
'\xb0v': u'\uced1',
'\xb0w': u'\uced2',
'\xb0x': u'\uced3',
'\xb0y': u'\uced4',
'\xb0z': u'\uced5',
'\xb1A': u'\ucf02',
'\xb1B': u'\ucf03',
'\xb1C': u'\ucf05',
'\xb1D': u'\ucf06',
'\xb1E': u'\ucf07',
'\xb1F': u'\ucf09',
'\xb1G': u'\ucf0a',
'\xb1H': u'\ucf0b',
'\xb1I': u'\ucf0c',
'\xb1J': u'\ucf0d',
'\xb1K': u'\ucf0e',
'\xb1L': u'\ucf0f',
'\xb1M': u'\ucf12',
'\xb1N': u'\ucf14',
'\xb1O': u'\ucf16',
'\xb1P': u'\ucf17',
'\xb1Q': u'\ucf18',
'\xb1R': u'\ucf19',
'\xb1S': u'\ucf1a',
'\xb1T': u'\ucf1b',
'\xb1U': u'\ucf1d',
'\xb1V': u'\ucf1e',
'\xb1W': u'\ucf1f',
'\xb1X': u'\ucf21',
'\xb1Y': u'\ucf22',
'\xb1Z': u'\ucf23',
'\xb1\x81': u'\ucf45',
'\xb1\x82': u'\ucf46',
'\xb1\x83': u'\ucf47',
'\xb1\x84': u'\ucf48',
'\xb1\x85': u'\ucf49',
'\xb1\x86': u'\ucf4a',
'\xb1\x87': u'\ucf4b',
'\xb1\x88': u'\ucf4c',
'\xb1\x89': u'\ucf4d',
'\xb1\x8a': u'\ucf4e',
'\xb1\x8b': u'\ucf4f',
'\xb1\x8c': u'\ucf50',
'\xb1\x8d': u'\ucf51',
'\xb1\x8e': u'\ucf52',
'\xb1\x8f': u'\ucf53',
'\xb1\x90': u'\ucf56',
'\xb1\x91': u'\ucf57',
'\xb1\x92': u'\ucf59',
'\xb1\x93': u'\ucf5a',
'\xb1\x94': u'\ucf5b',
'\xb1\x95': u'\ucf5d',
'\xb1\x96': u'\ucf5e',
'\xb1\x97': u'\ucf5f',
'\xb1\x98': u'\ucf60',
'\xb1\x99': u'\ucf61',
'\xb1\x9a': u'\ucf62',
'\xb1\x9b': u'\ucf63',
'\xb1\x9c': u'\ucf66',
'\xb1\x9d': u'\ucf68',
'\xb1\x9e': u'\ucf6a',
'\xb1\x9f': u'\ucf6b',
'\xb1\xa0': u'\ucf6c',
'\xb1a': u'\ucf25',
'\xb1b': u'\ucf26',
'\xb1c': u'\ucf27',
'\xb1d': u'\ucf28',
'\xb1e': u'\ucf29',
'\xb1f': u'\ucf2a',
'\xb1g': u'\ucf2b',
'\xb1h': u'\ucf2e',
'\xb1i': u'\ucf32',
'\xb1j': u'\ucf33',
'\xb1k': u'\ucf34',
'\xb1l': u'\ucf35',
'\xb1m': u'\ucf36',
'\xb1n': u'\ucf37',
'\xb1o': u'\ucf39',
'\xb1p': u'\ucf3a',
'\xb1q': u'\ucf3b',
'\xb1r': u'\ucf3c',
'\xb1s': u'\ucf3d',
'\xb1t': u'\ucf3e',
'\xb1u': u'\ucf3f',
'\xb1v': u'\ucf40',
'\xb1w': u'\ucf41',
'\xb1x': u'\ucf42',
'\xb1y': u'\ucf43',
'\xb1z': u'\ucf44',
'\xb2A': u'\ucf6d',
'\xb2B': u'\ucf6e',
'\xb2C': u'\ucf6f',
'\xb2D': u'\ucf72',
'\xb2E': u'\ucf73',
'\xb2F': u'\ucf75',
'\xb2G': u'\ucf76',
'\xb2H': u'\ucf77',
'\xb2I': u'\ucf79',
'\xb2J': u'\ucf7a',
'\xb2K': u'\ucf7b',
'\xb2L': u'\ucf7c',
'\xb2M': u'\ucf7d',
'\xb2N': u'\ucf7e',
'\xb2O': u'\ucf7f',
'\xb2P': u'\ucf81',
'\xb2Q': u'\ucf82',
'\xb2R': u'\ucf83',
'\xb2S': u'\ucf84',
'\xb2T': u'\ucf86',
'\xb2U': u'\ucf87',
'\xb2V': u'\ucf88',
'\xb2W': u'\ucf89',
'\xb2X': u'\ucf8a',
'\xb2Y': u'\ucf8b',
'\xb2Z': u'\ucf8d',
'\xb2\x81': u'\ucfaa',
'\xb2\x82': u'\ucfab',
'\xb2\x83': u'\ucfac',
'\xb2\x84': u'\ucfad',
'\xb2\x85': u'\ucfae',
'\xb2\x86': u'\ucfaf',
'\xb2\x87': u'\ucfb1',
'\xb2\x88': u'\ucfb2',
'\xb2\x89': u'\ucfb3',
'\xb2\x8a': u'\ucfb4',
'\xb2\x8b': u'\ucfb5',
'\xb2\x8c': u'\ucfb6',
'\xb2\x8d': u'\ucfb7',
'\xb2\x8e': u'\ucfb8',
'\xb2\x8f': u'\ucfb9',
'\xb2\x90': u'\ucfba',
'\xb2\x91': u'\ucfbb',
'\xb2\x92': u'\ucfbc',
'\xb2\x93': u'\ucfbd',
'\xb2\x94': u'\ucfbe',
'\xb2\x95': u'\ucfbf',
'\xb2\x96': u'\ucfc0',
'\xb2\x97': u'\ucfc1',
'\xb2\x98': u'\ucfc2',
'\xb2\x99': u'\ucfc3',
'\xb2\x9a': u'\ucfc5',
'\xb2\x9b': u'\ucfc6',
'\xb2\x9c': u'\ucfc7',
'\xb2\x9d': u'\ucfc8',
'\xb2\x9e': u'\ucfc9',
'\xb2\x9f': u'\ucfca',
'\xb2\xa0': u'\ucfcb',
'\xb2a': u'\ucf8e',
'\xb2b': u'\ucf8f',
'\xb2c': u'\ucf90',
'\xb2d': u'\ucf91',
'\xb2e': u'\ucf92',
'\xb2f': u'\ucf93',
'\xb2g': u'\ucf94',
'\xb2h': u'\ucf95',
'\xb2i': u'\ucf96',
'\xb2j': u'\ucf97',
'\xb2k': u'\ucf98',
'\xb2l': u'\ucf99',
'\xb2m': u'\ucf9a',
'\xb2n': u'\ucf9b',
'\xb2o': u'\ucf9c',
'\xb2p': u'\ucf9d',
'\xb2q': u'\ucf9e',
'\xb2r': u'\ucf9f',
'\xb2s': u'\ucfa0',
'\xb2t': u'\ucfa2',
'\xb2u': u'\ucfa3',
'\xb2v': u'\ucfa4',
'\xb2w': u'\ucfa5',
'\xb2x': u'\ucfa6',
'\xb2y': u'\ucfa7',
'\xb2z': u'\ucfa9',
'\xb3A': u'\ucfcc',
'\xb3B': u'\ucfcd',
'\xb3C': u'\ucfce',
'\xb3D': u'\ucfcf',
'\xb3E': u'\ucfd0',
'\xb3F': u'\ucfd1',
'\xb3G': u'\ucfd2',
'\xb3H': u'\ucfd3',
'\xb3I': u'\ucfd4',
'\xb3J': u'\ucfd5',
'\xb3K': u'\ucfd6',
'\xb3L': u'\ucfd7',
'\xb3M': u'\ucfd8',
'\xb3N': u'\ucfd9',
'\xb3O': u'\ucfda',
'\xb3P': u'\ucfdb',
'\xb3Q': u'\ucfdc',
'\xb3R': u'\ucfdd',
'\xb3S': u'\ucfde',
'\xb3T': u'\ucfdf',
'\xb3U': u'\ucfe2',
'\xb3V': u'\ucfe3',
'\xb3W': u'\ucfe5',
'\xb3X': u'\ucfe6',
'\xb3Y': u'\ucfe7',
'\xb3Z': u'\ucfe9',
'\xb3\x81': u'\ud00b',
'\xb3\x82': u'\ud00c',
'\xb3\x83': u'\ud00d',
'\xb3\x84': u'\ud00e',
'\xb3\x85': u'\ud00f',
'\xb3\x86': u'\ud010',
'\xb3\x87': u'\ud012',
'\xb3\x88': u'\ud013',
'\xb3\x89': u'\ud014',
'\xb3\x8a': u'\ud015',
'\xb3\x8b': u'\ud016',
'\xb3\x8c': u'\ud017',
'\xb3\x8d': u'\ud019',
'\xb3\x8e': u'\ud01a',
'\xb3\x8f': u'\ud01b',
'\xb3\x90': u'\ud01c',
'\xb3\x91': u'\ud01d',
'\xb3\x92': u'\ud01e',
'\xb3\x93': u'\ud01f',
'\xb3\x94': u'\ud020',
'\xb3\x95': u'\ud021',
'\xb3\x96': u'\ud022',
'\xb3\x97': u'\ud023',
'\xb3\x98': u'\ud024',
'\xb3\x99': u'\ud025',
'\xb3\x9a': u'\ud026',
'\xb3\x9b': u'\ud027',
'\xb3\x9c': u'\ud028',
'\xb3\x9d': u'\ud029',
'\xb3\x9e': u'\ud02a',
'\xb3\x9f': u'\ud02b',
'\xb3\xa0': u'\ud02c',
'\xb3a': u'\ucfea',
'\xb3b': u'\ucfeb',
'\xb3c': u'\ucfec',
'\xb3d': u'\ucfed',
'\xb3e': u'\ucfee',
'\xb3f': u'\ucfef',
'\xb3g': u'\ucff2',
'\xb3h': u'\ucff4',
'\xb3i': u'\ucff6',
'\xb3j': u'\ucff7',
'\xb3k': u'\ucff8',
'\xb3l': u'\ucff9',
'\xb3m': u'\ucffa',
'\xb3n': u'\ucffb',
'\xb3o': u'\ucffd',
'\xb3p': u'\ucffe',
'\xb3q': u'\ucfff',
'\xb3r': u'\ud001',
'\xb3s': u'\ud002',
'\xb3t': u'\ud003',
'\xb3u': u'\ud005',
'\xb3v': u'\ud006',
'\xb3w': u'\ud007',
'\xb3x': u'\ud008',
'\xb3y': u'\ud009',
'\xb3z': u'\ud00a',
'\xb4A': u'\ud02e',
'\xb4B': u'\ud02f',
'\xb4C': u'\ud030',
'\xb4D': u'\ud031',
'\xb4E': u'\ud032',
'\xb4F': u'\ud033',
'\xb4G': u'\ud036',
'\xb4H': u'\ud037',
'\xb4I': u'\ud039',
'\xb4J': u'\ud03a',
'\xb4K': u'\ud03b',
'\xb4L': u'\ud03d',
'\xb4M': u'\ud03e',
'\xb4N': u'\ud03f',
'\xb4O': u'\ud040',
'\xb4P': u'\ud041',
'\xb4Q': u'\ud042',
'\xb4R': u'\ud043',
'\xb4S': u'\ud046',
'\xb4T': u'\ud048',
'\xb4U': u'\ud04a',
'\xb4V': u'\ud04b',
'\xb4W': u'\ud04c',
'\xb4X': u'\ud04d',
'\xb4Y': u'\ud04e',
'\xb4Z': u'\ud04f',
'\xb4\x81': u'\ud071',
'\xb4\x82': u'\ud072',
'\xb4\x83': u'\ud073',
'\xb4\x84': u'\ud075',
'\xb4\x85': u'\ud076',
'\xb4\x86': u'\ud077',
'\xb4\x87': u'\ud078',
'\xb4\x88': u'\ud079',
'\xb4\x89': u'\ud07a',
'\xb4\x8a': u'\ud07b',
'\xb4\x8b': u'\ud07e',
'\xb4\x8c': u'\ud07f',
'\xb4\x8d': u'\ud080',
'\xb4\x8e': u'\ud082',
'\xb4\x8f': u'\ud083',
'\xb4\x90': u'\ud084',
'\xb4\x91': u'\ud085',
'\xb4\x92': u'\ud086',
'\xb4\x93': u'\ud087',
'\xb4\x94': u'\ud088',
'\xb4\x95': u'\ud089',
'\xb4\x96': u'\ud08a',
'\xb4\x97': u'\ud08b',
'\xb4\x98': u'\ud08c',
'\xb4\x99': u'\ud08d',
'\xb4\x9a': u'\ud08e',
'\xb4\x9b': u'\ud08f',
'\xb4\x9c': u'\ud090',
'\xb4\x9d': u'\ud091',
'\xb4\x9e': u'\ud092',
'\xb4\x9f': u'\ud093',
'\xb4\xa0': u'\ud094',
'\xb4a': u'\ud051',
'\xb4b': u'\ud052',
'\xb4c': u'\ud053',
'\xb4d': u'\ud055',
'\xb4e': u'\ud056',
'\xb4f': u'\ud057',
'\xb4g': u'\ud059',
'\xb4h': u'\ud05a',
'\xb4i': u'\ud05b',
'\xb4j': u'\ud05c',
'\xb4k': u'\ud05d',
'\xb4l': u'\ud05e',
'\xb4m': u'\ud05f',
'\xb4n': u'\ud061',
'\xb4o': u'\ud062',
'\xb4p': u'\ud063',
'\xb4q': u'\ud064',
'\xb4r': u'\ud065',
'\xb4s': u'\ud066',
'\xb4t': u'\ud067',
'\xb4u': u'\ud068',
'\xb4v': u'\ud069',
'\xb4w': u'\ud06a',
'\xb4x': u'\ud06b',
'\xb4y': u'\ud06e',
'\xb4z': u'\ud06f',
'\xb5A': u'\ud095',
'\xb5B': u'\ud096',
'\xb5C': u'\ud097',
'\xb5D': u'\ud098',
'\xb5E': u'\ud099',
'\xb5F': u'\ud09a',
'\xb5G': u'\ud09b',
'\xb5H': u'\ud09c',
'\xb5I': u'\ud09d',
'\xb5J': u'\ud09e',
'\xb5K': u'\ud09f',
'\xb5L': u'\ud0a0',
'\xb5M': u'\ud0a1',
'\xb5N': u'\ud0a2',
'\xb5O': u'\ud0a3',
'\xb5P': u'\ud0a6',
'\xb5Q': u'\ud0a7',
'\xb5R': u'\ud0a9',
'\xb5S': u'\ud0aa',
'\xb5T': u'\ud0ab',
'\xb5U': u'\ud0ad',
'\xb5V': u'\ud0ae',
'\xb5W': u'\ud0af',
'\xb5X': u'\ud0b0',
'\xb5Y': u'\ud0b1',
'\xb5Z': u'\ud0b2',
'\xb5\x81': u'\ud0db',
'\xb5\x82': u'\ud0de',
'\xb5\x83': u'\ud0df',
'\xb5\x84': u'\ud0e1',
'\xb5\x85': u'\ud0e2',
'\xb5\x86': u'\ud0e3',
'\xb5\x87': u'\ud0e5',
'\xb5\x88': u'\ud0e6',
'\xb5\x89': u'\ud0e7',
'\xb5\x8a': u'\ud0e8',
'\xb5\x8b': u'\ud0e9',
'\xb5\x8c': u'\ud0ea',
'\xb5\x8d': u'\ud0eb',
'\xb5\x8e': u'\ud0ee',
'\xb5\x8f': u'\ud0f2',
'\xb5\x90': u'\ud0f3',
'\xb5\x91': u'\ud0f4',
'\xb5\x92': u'\ud0f5',
'\xb5\x93': u'\ud0f6',
'\xb5\x94': u'\ud0f7',
'\xb5\x95': u'\ud0f9',
'\xb5\x96': u'\ud0fa',
'\xb5\x97': u'\ud0fb',
'\xb5\x98': u'\ud0fc',
'\xb5\x99': u'\ud0fd',
'\xb5\x9a': u'\ud0fe',
'\xb5\x9b': u'\ud0ff',
'\xb5\x9c': u'\ud100',
'\xb5\x9d': u'\ud101',
'\xb5\x9e': u'\ud102',
'\xb5\x9f': u'\ud103',
'\xb5\xa0': u'\ud104',
'\xb5a': u'\ud0b3',
'\xb5b': u'\ud0b6',
'\xb5c': u'\ud0b8',
'\xb5d': u'\ud0ba',
'\xb5e': u'\ud0bb',
'\xb5f': u'\ud0bc',
'\xb5g': u'\ud0bd',
'\xb5h': u'\ud0be',
'\xb5i': u'\ud0bf',
'\xb5j': u'\ud0c2',
'\xb5k': u'\ud0c3',
'\xb5l': u'\ud0c5',
'\xb5m': u'\ud0c6',
'\xb5n': u'\ud0c7',
'\xb5o': u'\ud0ca',
'\xb5p': u'\ud0cb',
'\xb5q': u'\ud0cc',
'\xb5r': u'\ud0cd',
'\xb5s': u'\ud0ce',
'\xb5t': u'\ud0cf',
'\xb5u': u'\ud0d2',
'\xb5v': u'\ud0d6',
'\xb5w': u'\ud0d7',
'\xb5x': u'\ud0d8',
'\xb5y': u'\ud0d9',
'\xb5z': u'\ud0da',
'\xb6A': u'\ud105',
'\xb6B': u'\ud106',
'\xb6C': u'\ud107',
'\xb6D': u'\ud108',
'\xb6E': u'\ud109',
'\xb6F': u'\ud10a',
'\xb6G': u'\ud10b',
'\xb6H': u'\ud10c',
'\xb6I': u'\ud10e',
'\xb6J': u'\ud10f',
'\xb6K': u'\ud110',
'\xb6L': u'\ud111',
'\xb6M': u'\ud112',
'\xb6N': u'\ud113',
'\xb6O': u'\ud114',
'\xb6P': u'\ud115',
'\xb6Q': u'\ud116',
'\xb6R': u'\ud117',
'\xb6S': u'\ud118',
'\xb6T': u'\ud119',
'\xb6U': u'\ud11a',
'\xb6V': u'\ud11b',
'\xb6W': u'\ud11c',
'\xb6X': u'\ud11d',
'\xb6Y': u'\ud11e',
'\xb6Z': u'\ud11f',
'\xb6\x81': u'\ud13f',
'\xb6\x82': u'\ud142',
'\xb6\x83': u'\ud146',
'\xb6\x84': u'\ud147',
'\xb6\x85': u'\ud148',
'\xb6\x86': u'\ud149',
'\xb6\x87': u'\ud14a',
'\xb6\x88': u'\ud14b',
'\xb6\x89': u'\ud14e',
'\xb6\x8a': u'\ud14f',
'\xb6\x8b': u'\ud151',
'\xb6\x8c': u'\ud152',
'\xb6\x8d': u'\ud153',
'\xb6\x8e': u'\ud155',
'\xb6\x8f': u'\ud156',
'\xb6\x90': u'\ud157',
'\xb6\x91': u'\ud158',
'\xb6\x92': u'\ud159',
'\xb6\x93': u'\ud15a',
'\xb6\x94': u'\ud15b',
'\xb6\x95': u'\ud15e',
'\xb6\x96': u'\ud160',
'\xb6\x97': u'\ud162',
'\xb6\x98': u'\ud163',
'\xb6\x99': u'\ud164',
'\xb6\x9a': u'\ud165',
'\xb6\x9b': u'\ud166',
'\xb6\x9c': u'\ud167',
'\xb6\x9d': u'\ud169',
'\xb6\x9e': u'\ud16a',
'\xb6\x9f': u'\ud16b',
'\xb6\xa0': u'\ud16d',
'\xb6a': u'\ud120',
'\xb6b': u'\ud121',
'\xb6c': u'\ud122',
'\xb6d': u'\ud123',
'\xb6e': u'\ud124',
'\xb6f': u'\ud125',
'\xb6g': u'\ud126',
'\xb6h': u'\ud127',
'\xb6i': u'\ud128',
'\xb6j': u'\ud129',
'\xb6k': u'\ud12a',
'\xb6l': u'\ud12b',
'\xb6m': u'\ud12c',
'\xb6n': u'\ud12d',
'\xb6o': u'\ud12e',
'\xb6p': u'\ud12f',
'\xb6q': u'\ud132',
'\xb6r': u'\ud133',
'\xb6s': u'\ud135',
'\xb6t': u'\ud136',
'\xb6u': u'\ud137',
'\xb6v': u'\ud139',
'\xb6w': u'\ud13b',
'\xb6x': u'\ud13c',
'\xb6y': u'\ud13d',
'\xb6z': u'\ud13e',
'\xb7A': u'\ud16e',
'\xb7B': u'\ud16f',
'\xb7C': u'\ud170',
'\xb7D': u'\ud171',
'\xb7E': u'\ud172',
'\xb7F': u'\ud173',
'\xb7G': u'\ud174',
'\xb7H': u'\ud175',
'\xb7I': u'\ud176',
'\xb7J': u'\ud177',
'\xb7K': u'\ud178',
'\xb7L': u'\ud179',
'\xb7M': u'\ud17a',
'\xb7N': u'\ud17b',
'\xb7O': u'\ud17d',
'\xb7P': u'\ud17e',
'\xb7Q': u'\ud17f',
'\xb7R': u'\ud180',
'\xb7S': u'\ud181',
'\xb7T': u'\ud182',
'\xb7U': u'\ud183',
'\xb7V': u'\ud185',
'\xb7W': u'\ud186',
'\xb7X': u'\ud187',
'\xb7Y': u'\ud189',
'\xb7Z': u'\ud18a',
'\xb7\x81': u'\ud1a9',
'\xb7\x82': u'\ud1aa',
'\xb7\x83': u'\ud1ab',
'\xb7\x84': u'\ud1ac',
'\xb7\x85': u'\ud1ad',
'\xb7\x86': u'\ud1ae',
'\xb7\x87': u'\ud1af',
'\xb7\x88': u'\ud1b2',
'\xb7\x89': u'\ud1b4',
'\xb7\x8a': u'\ud1b6',
'\xb7\x8b': u'\ud1b7',
'\xb7\x8c': u'\ud1b8',
'\xb7\x8d': u'\ud1b9',
'\xb7\x8e': u'\ud1bb',
'\xb7\x8f': u'\ud1bd',
'\xb7\x90': u'\ud1be',
'\xb7\x91': u'\ud1bf',
'\xb7\x92': u'\ud1c1',
'\xb7\x93': u'\ud1c2',
'\xb7\x94': u'\ud1c3',
'\xb7\x95': u'\ud1c4',
'\xb7\x96': u'\ud1c5',
'\xb7\x97': u'\ud1c6',
'\xb7\x98': u'\ud1c7',
'\xb7\x99': u'\ud1c8',
'\xb7\x9a': u'\ud1c9',
'\xb7\x9b': u'\ud1ca',
'\xb7\x9c': u'\ud1cb',
'\xb7\x9d': u'\ud1cc',
'\xb7\x9e': u'\ud1cd',
'\xb7\x9f': u'\ud1ce',
'\xb7\xa0': u'\ud1cf',
'\xb7a': u'\ud18b',
'\xb7b': u'\ud18c',
'\xb7c': u'\ud18d',
'\xb7d': u'\ud18e',
'\xb7e': u'\ud18f',
'\xb7f': u'\ud190',
'\xb7g': u'\ud191',
'\xb7h': u'\ud192',
'\xb7i': u'\ud193',
'\xb7j': u'\ud194',
'\xb7k': u'\ud195',
'\xb7l': u'\ud196',
'\xb7m': u'\ud197',
'\xb7n': u'\ud198',
'\xb7o': u'\ud199',
'\xb7p': u'\ud19a',
'\xb7q': u'\ud19b',
'\xb7r': u'\ud19c',
'\xb7s': u'\ud19d',
'\xb7t': u'\ud19e',
'\xb7u': u'\ud19f',
'\xb7v': u'\ud1a2',
'\xb7w': u'\ud1a3',
'\xb7x': u'\ud1a5',
'\xb7y': u'\ud1a6',
'\xb7z': u'\ud1a7',
'\xb8A': u'\ud1d0',
'\xb8B': u'\ud1d1',
'\xb8C': u'\ud1d2',
'\xb8D': u'\ud1d3',
'\xb8E': u'\ud1d4',
'\xb8F': u'\ud1d5',
'\xb8G': u'\ud1d6',
'\xb8H': u'\ud1d7',
'\xb8I': u'\ud1d9',
'\xb8J': u'\ud1da',
'\xb8K': u'\ud1db',
'\xb8L': u'\ud1dc',
'\xb8M': u'\ud1dd',
'\xb8N': u'\ud1de',
'\xb8O': u'\ud1df',
'\xb8P': u'\ud1e0',
'\xb8Q': u'\ud1e1',
'\xb8R': u'\ud1e2',
'\xb8S': u'\ud1e3',
'\xb8T': u'\ud1e4',
'\xb8U': u'\ud1e5',
'\xb8V': u'\ud1e6',
'\xb8W': u'\ud1e7',
'\xb8X': u'\ud1e8',
'\xb8Y': u'\ud1e9',
'\xb8Z': u'\ud1ea',
'\xb8\x81': u'\ud208',
'\xb8\x82': u'\ud20a',
'\xb8\x83': u'\ud20b',
'\xb8\x84': u'\ud20c',
'\xb8\x85': u'\ud20d',
'\xb8\x86': u'\ud20e',
'\xb8\x87': u'\ud20f',
'\xb8\x88': u'\ud211',
'\xb8\x89': u'\ud212',
'\xb8\x8a': u'\ud213',
'\xb8\x8b': u'\ud214',
'\xb8\x8c': u'\ud215',
'\xb8\x8d': u'\ud216',
'\xb8\x8e': u'\ud217',
'\xb8\x8f': u'\ud218',
'\xb8\x90': u'\ud219',
'\xb8\x91': u'\ud21a',
'\xb8\x92': u'\ud21b',
'\xb8\x93': u'\ud21c',
'\xb8\x94': u'\ud21d',
'\xb8\x95': u'\ud21e',
'\xb8\x96': u'\ud21f',
'\xb8\x97': u'\ud220',
'\xb8\x98': u'\ud221',
'\xb8\x99': u'\ud222',
'\xb8\x9a': u'\ud223',
'\xb8\x9b': u'\ud224',
'\xb8\x9c': u'\ud225',
'\xb8\x9d': u'\ud226',
'\xb8\x9e': u'\ud227',
'\xb8\x9f': u'\ud228',
'\xb8\xa0': u'\ud229',
'\xb8a': u'\ud1eb',
'\xb8b': u'\ud1ec',
'\xb8c': u'\ud1ed',
'\xb8d': u'\ud1ee',
'\xb8e': u'\ud1ef',
'\xb8f': u'\ud1f0',
'\xb8g': u'\ud1f1',
'\xb8h': u'\ud1f2',
'\xb8i': u'\ud1f3',
'\xb8j': u'\ud1f5',
'\xb8k': u'\ud1f6',
'\xb8l': u'\ud1f7',
'\xb8m': u'\ud1f9',
'\xb8n': u'\ud1fa',
'\xb8o': u'\ud1fb',
'\xb8p': u'\ud1fc',
'\xb8q': u'\ud1fd',
'\xb8r': u'\ud1fe',
'\xb8s': u'\ud1ff',
'\xb8t': u'\ud200',
'\xb8u': u'\ud201',
'\xb8v': u'\ud202',
'\xb8w': u'\ud203',
'\xb8x': u'\ud204',
'\xb8y': u'\ud205',
'\xb8z': u'\ud206',
'\xb9A': u'\ud22a',
'\xb9B': u'\ud22b',
'\xb9C': u'\ud22e',
'\xb9D': u'\ud22f',
'\xb9E': u'\ud231',
'\xb9F': u'\ud232',
'\xb9G': u'\ud233',
'\xb9H': u'\ud235',
'\xb9I': u'\ud236',
'\xb9J': u'\ud237',
'\xb9K': u'\ud238',
'\xb9L': u'\ud239',
'\xb9M': u'\ud23a',
'\xb9N': u'\ud23b',
'\xb9O': u'\ud23e',
'\xb9P': u'\ud240',
'\xb9Q': u'\ud242',
'\xb9R': u'\ud243',
'\xb9S': u'\ud244',
'\xb9T': u'\ud245',
'\xb9U': u'\ud246',
'\xb9V': u'\ud247',
'\xb9W': u'\ud249',
'\xb9X': u'\ud24a',
'\xb9Y': u'\ud24b',
'\xb9Z': u'\ud24c',
'\xb9\x81': u'\ud269',
'\xb9\x82': u'\ud26a',
'\xb9\x83': u'\ud26b',
'\xb9\x84': u'\ud26c',
'\xb9\x85': u'\ud26d',
'\xb9\x86': u'\ud26e',
'\xb9\x87': u'\ud26f',
'\xb9\x88': u'\ud270',
'\xb9\x89': u'\ud271',
'\xb9\x8a': u'\ud272',
'\xb9\x8b': u'\ud273',
'\xb9\x8c': u'\ud274',
'\xb9\x8d': u'\ud275',
'\xb9\x8e': u'\ud276',
'\xb9\x8f': u'\ud277',
'\xb9\x90': u'\ud278',
'\xb9\x91': u'\ud279',
'\xb9\x92': u'\ud27a',
'\xb9\x93': u'\ud27b',
'\xb9\x94': u'\ud27c',
'\xb9\x95': u'\ud27d',
'\xb9\x96': u'\ud27e',
'\xb9\x97': u'\ud27f',
'\xb9\x98': u'\ud282',
'\xb9\x99': u'\ud283',
'\xb9\x9a': u'\ud285',
'\xb9\x9b': u'\ud286',
'\xb9\x9c': u'\ud287',
'\xb9\x9d': u'\ud289',
'\xb9\x9e': u'\ud28a',
'\xb9\x9f': u'\ud28b',
'\xb9\xa0': u'\ud28c',
'\xb9a': u'\ud24d',
'\xb9b': u'\ud24e',
'\xb9c': u'\ud24f',
'\xb9d': u'\ud250',
'\xb9e': u'\ud251',
'\xb9f': u'\ud252',
'\xb9g': u'\ud253',
'\xb9h': u'\ud254',
'\xb9i': u'\ud255',
'\xb9j': u'\ud256',
'\xb9k': u'\ud257',
'\xb9l': u'\ud258',
'\xb9m': u'\ud259',
'\xb9n': u'\ud25a',
'\xb9o': u'\ud25b',
'\xb9p': u'\ud25d',
'\xb9q': u'\ud25e',
'\xb9r': u'\ud25f',
'\xb9s': u'\ud260',
'\xb9t': u'\ud261',
'\xb9u': u'\ud262',
'\xb9v': u'\ud263',
'\xb9w': u'\ud265',
'\xb9x': u'\ud266',
'\xb9y': u'\ud267',
'\xb9z': u'\ud268',
'\xbaA': u'\ud28d',
'\xbaB': u'\ud28e',
'\xbaC': u'\ud28f',
'\xbaD': u'\ud292',
'\xbaE': u'\ud293',
'\xbaF': u'\ud294',
'\xbaG': u'\ud296',
'\xbaH': u'\ud297',
'\xbaI': u'\ud298',
'\xbaJ': u'\ud299',
'\xbaK': u'\ud29a',
'\xbaL': u'\ud29b',
'\xbaM': u'\ud29d',
'\xbaN': u'\ud29e',
'\xbaO': u'\ud29f',
'\xbaP': u'\ud2a1',
'\xbaQ': u'\ud2a2',
'\xbaR': u'\ud2a3',
'\xbaS': u'\ud2a5',
'\xbaT': u'\ud2a6',
'\xbaU': u'\ud2a7',
'\xbaV': u'\ud2a8',
'\xbaW': u'\ud2a9',
'\xbaX': u'\ud2aa',
'\xbaY': u'\ud2ab',
'\xbaZ': u'\ud2ad',
'\xba\x81': u'\ud2d2',
'\xba\x82': u'\ud2d3',
'\xba\x83': u'\ud2d5',
'\xba\x84': u'\ud2d6',
'\xba\x85': u'\ud2d7',
'\xba\x86': u'\ud2d9',
'\xba\x87': u'\ud2da',
'\xba\x88': u'\ud2db',
'\xba\x89': u'\ud2dd',
'\xba\x8a': u'\ud2de',
'\xba\x8b': u'\ud2df',
'\xba\x8c': u'\ud2e0',
'\xba\x8d': u'\ud2e1',
'\xba\x8e': u'\ud2e2',
'\xba\x8f': u'\ud2e3',
'\xba\x90': u'\ud2e6',
'\xba\x91': u'\ud2e7',
'\xba\x92': u'\ud2e8',
'\xba\x93': u'\ud2e9',
'\xba\x94': u'\ud2ea',
'\xba\x95': u'\ud2eb',
'\xba\x96': u'\ud2ec',
'\xba\x97': u'\ud2ed',
'\xba\x98': u'\ud2ee',
'\xba\x99': u'\ud2ef',
'\xba\x9a': u'\ud2f2',
'\xba\x9b': u'\ud2f3',
'\xba\x9c': u'\ud2f5',
'\xba\x9d': u'\ud2f6',
'\xba\x9e': u'\ud2f7',
'\xba\x9f': u'\ud2f9',
'\xba\xa0': u'\ud2fa',
'\xbaa': u'\ud2ae',
'\xbab': u'\ud2af',
'\xbac': u'\ud2b0',
'\xbad': u'\ud2b2',
'\xbae': u'\ud2b3',
'\xbaf': u'\ud2b4',
'\xbag': u'\ud2b5',
'\xbah': u'\ud2b6',
'\xbai': u'\ud2b7',
'\xbaj': u'\ud2ba',
'\xbak': u'\ud2bb',
'\xbal': u'\ud2bd',
'\xbam': u'\ud2be',
'\xban': u'\ud2c1',
'\xbao': u'\ud2c3',
'\xbap': u'\ud2c4',
'\xbaq': u'\ud2c5',
'\xbar': u'\ud2c6',
'\xbas': u'\ud2c7',
'\xbat': u'\ud2ca',
'\xbau': u'\ud2cc',
'\xbav': u'\ud2cd',
'\xbaw': u'\ud2ce',
'\xbax': u'\ud2cf',
'\xbay': u'\ud2d0',
'\xbaz': u'\ud2d1',
'\xbbA': u'\ud2fb',
'\xbbB': u'\ud2fc',
'\xbbC': u'\ud2fd',
'\xbbD': u'\ud2fe',
'\xbbE': u'\ud2ff',
'\xbbF': u'\ud302',
'\xbbG': u'\ud304',
'\xbbH': u'\ud306',
'\xbbI': u'\ud307',
'\xbbJ': u'\ud308',
'\xbbK': u'\ud309',
'\xbbL': u'\ud30a',
'\xbbM': u'\ud30b',
'\xbbN': u'\ud30f',
'\xbbO': u'\ud311',
'\xbbP': u'\ud312',
'\xbbQ': u'\ud313',
'\xbbR': u'\ud315',
'\xbbS': u'\ud317',
'\xbbT': u'\ud318',
'\xbbU': u'\ud319',
'\xbbV': u'\ud31a',
'\xbbW': u'\ud31b',
'\xbbX': u'\ud31e',
'\xbbY': u'\ud322',
'\xbbZ': u'\ud323',
'\xbb\x81': u'\ud34a',
'\xbb\x82': u'\ud34b',
'\xbb\x83': u'\ud34c',
'\xbb\x84': u'\ud34d',
'\xbb\x85': u'\ud34e',
'\xbb\x86': u'\ud34f',
'\xbb\x87': u'\ud350',
'\xbb\x88': u'\ud351',
'\xbb\x89': u'\ud352',
'\xbb\x8a': u'\ud353',
'\xbb\x8b': u'\ud354',
'\xbb\x8c': u'\ud355',
'\xbb\x8d': u'\ud356',
'\xbb\x8e': u'\ud357',
'\xbb\x8f': u'\ud358',
'\xbb\x90': u'\ud359',
'\xbb\x91': u'\ud35a',
'\xbb\x92': u'\ud35b',
'\xbb\x93': u'\ud35c',
'\xbb\x94': u'\ud35d',
'\xbb\x95': u'\ud35e',
'\xbb\x96': u'\ud35f',
'\xbb\x97': u'\ud360',
'\xbb\x98': u'\ud361',
'\xbb\x99': u'\ud362',
'\xbb\x9a': u'\ud363',
'\xbb\x9b': u'\ud364',
'\xbb\x9c': u'\ud365',
'\xbb\x9d': u'\ud366',
'\xbb\x9e': u'\ud367',
'\xbb\x9f': u'\ud368',
'\xbb\xa0': u'\ud369',
'\xbba': u'\ud324',
'\xbbb': u'\ud326',
'\xbbc': u'\ud327',
'\xbbd': u'\ud32a',
'\xbbe': u'\ud32b',
'\xbbf': u'\ud32d',
'\xbbg': u'\ud32e',
'\xbbh': u'\ud32f',
'\xbbi': u'\ud331',
'\xbbj': u'\ud332',
'\xbbk': u'\ud333',
'\xbbl': u'\ud334',
'\xbbm': u'\ud335',
'\xbbn': u'\ud336',
'\xbbo': u'\ud337',
'\xbbp': u'\ud33a',
'\xbbq': u'\ud33e',
'\xbbr': u'\ud33f',
'\xbbs': u'\ud340',
'\xbbt': u'\ud341',
'\xbbu': u'\ud342',
'\xbbv': u'\ud343',
'\xbbw': u'\ud346',
'\xbbx': u'\ud347',
'\xbby': u'\ud348',
'\xbbz': u'\ud349',
'\xbcA': u'\ud36a',
'\xbcB': u'\ud36b',
'\xbcC': u'\ud36c',
'\xbcD': u'\ud36d',
'\xbcE': u'\ud36e',
'\xbcF': u'\ud36f',
'\xbcG': u'\ud370',
'\xbcH': u'\ud371',
'\xbcI': u'\ud372',
'\xbcJ': u'\ud373',
'\xbcK': u'\ud374',
'\xbcL': u'\ud375',
'\xbcM': u'\ud376',
'\xbcN': u'\ud377',
'\xbcO': u'\ud378',
'\xbcP': u'\ud379',
'\xbcQ': u'\ud37a',
'\xbcR': u'\ud37b',
'\xbcS': u'\ud37e',
'\xbcT': u'\ud37f',
'\xbcU': u'\ud381',
'\xbcV': u'\ud382',
'\xbcW': u'\ud383',
'\xbcX': u'\ud385',
'\xbcY': u'\ud386',
'\xbcZ': u'\ud387',
'\xbc\x81': u'\ud3af',
'\xbc\x82': u'\ud3b0',
'\xbc\x83': u'\ud3b1',
'\xbc\x84': u'\ud3b2',
'\xbc\x85': u'\ud3b3',
'\xbc\x86': u'\ud3b5',
'\xbc\x87': u'\ud3b6',
'\xbc\x88': u'\ud3b7',
'\xbc\x89': u'\ud3b9',
'\xbc\x8a': u'\ud3ba',
'\xbc\x8b': u'\ud3bb',
'\xbc\x8c': u'\ud3bd',
'\xbc\x8d': u'\ud3be',
'\xbc\x8e': u'\ud3bf',
'\xbc\x8f': u'\ud3c0',
'\xbc\x90': u'\ud3c1',
'\xbc\x91': u'\ud3c2',
'\xbc\x92': u'\ud3c3',
'\xbc\x93': u'\ud3c6',
'\xbc\x94': u'\ud3c7',
'\xbc\x95': u'\ud3ca',
'\xbc\x96': u'\ud3cb',
'\xbc\x97': u'\ud3cc',
'\xbc\x98': u'\ud3cd',
'\xbc\x99': u'\ud3ce',
'\xbc\x9a': u'\ud3cf',
'\xbc\x9b': u'\ud3d1',
'\xbc\x9c': u'\ud3d2',
'\xbc\x9d': u'\ud3d3',
'\xbc\x9e': u'\ud3d4',
'\xbc\x9f': u'\ud3d5',
'\xbc\xa0': u'\ud3d6',
'\xbca': u'\ud388',
'\xbcb': u'\ud389',
'\xbcc': u'\ud38a',
'\xbcd': u'\ud38b',
'\xbce': u'\ud38e',
'\xbcf': u'\ud392',
'\xbcg': u'\ud393',
'\xbch': u'\ud394',
'\xbci': u'\ud395',
'\xbcj': u'\ud396',
'\xbck': u'\ud397',
'\xbcl': u'\ud39a',
'\xbcm': u'\ud39b',
'\xbcn': u'\ud39d',
'\xbco': u'\ud39e',
'\xbcp': u'\ud39f',
'\xbcq': u'\ud3a1',
'\xbcr': u'\ud3a2',
'\xbcs': u'\ud3a3',
'\xbct': u'\ud3a4',
'\xbcu': u'\ud3a5',
'\xbcv': u'\ud3a6',
'\xbcw': u'\ud3a7',
'\xbcx': u'\ud3aa',
'\xbcy': u'\ud3ac',
'\xbcz': u'\ud3ae',
'\xbdA': u'\ud3d7',
'\xbdB': u'\ud3d9',
'\xbdC': u'\ud3da',
'\xbdD': u'\ud3db',
'\xbdE': u'\ud3dc',
'\xbdF': u'\ud3dd',
'\xbdG': u'\ud3de',
'\xbdH': u'\ud3df',
'\xbdI': u'\ud3e0',
'\xbdJ': u'\ud3e2',
'\xbdK': u'\ud3e4',
'\xbdL': u'\ud3e5',
'\xbdM': u'\ud3e6',
'\xbdN': u'\ud3e7',
'\xbdO': u'\ud3e8',
'\xbdP': u'\ud3e9',
'\xbdQ': u'\ud3ea',
'\xbdR': u'\ud3eb',
'\xbdS': u'\ud3ee',
'\xbdT': u'\ud3ef',
'\xbdU': u'\ud3f1',
'\xbdV': u'\ud3f2',
'\xbdW': u'\ud3f3',
'\xbdX': u'\ud3f5',
'\xbdY': u'\ud3f6',
'\xbdZ': u'\ud3f7',
'\xbd\x81': u'\ud417',
'\xbd\x82': u'\ud418',
'\xbd\x83': u'\ud419',
'\xbd\x84': u'\ud41a',
'\xbd\x85': u'\ud41b',
'\xbd\x86': u'\ud41c',
'\xbd\x87': u'\ud41e',
'\xbd\x88': u'\ud41f',
'\xbd\x89': u'\ud420',
'\xbd\x8a': u'\ud421',
'\xbd\x8b': u'\ud422',
'\xbd\x8c': u'\ud423',
'\xbd\x8d': u'\ud424',
'\xbd\x8e': u'\ud425',
'\xbd\x8f': u'\ud426',
'\xbd\x90': u'\ud427',
'\xbd\x91': u'\ud428',
'\xbd\x92': u'\ud429',
'\xbd\x93': u'\ud42a',
'\xbd\x94': u'\ud42b',
'\xbd\x95': u'\ud42c',
'\xbd\x96': u'\ud42d',
'\xbd\x97': u'\ud42e',
'\xbd\x98': u'\ud42f',
'\xbd\x99': u'\ud430',
'\xbd\x9a': u'\ud431',
'\xbd\x9b': u'\ud432',
'\xbd\x9c': u'\ud433',
'\xbd\x9d': u'\ud434',
'\xbd\x9e': u'\ud435',
'\xbd\x9f': u'\ud436',
'\xbd\xa0': u'\ud437',
'\xbda': u'\ud3f8',
'\xbdb': u'\ud3f9',
'\xbdc': u'\ud3fa',
'\xbdd': u'\ud3fb',
'\xbde': u'\ud3fe',
'\xbdf': u'\ud400',
'\xbdg': u'\ud402',
'\xbdh': u'\ud403',
'\xbdi': u'\ud404',
'\xbdj': u'\ud405',
'\xbdk': u'\ud406',
'\xbdl': u'\ud407',
'\xbdm': u'\ud409',
'\xbdn': u'\ud40a',
'\xbdo': u'\ud40b',
'\xbdp': u'\ud40c',
'\xbdq': u'\ud40d',
'\xbdr': u'\ud40e',
'\xbds': u'\ud40f',
'\xbdt': u'\ud410',
'\xbdu': u'\ud411',
'\xbdv': u'\ud412',
'\xbdw': u'\ud413',
'\xbdx': u'\ud414',
'\xbdy': u'\ud415',
'\xbdz': u'\ud416',
'\xbeA': u'\ud438',
'\xbeB': u'\ud439',
'\xbeC': u'\ud43a',
'\xbeD': u'\ud43b',
'\xbeE': u'\ud43c',
'\xbeF': u'\ud43d',
'\xbeG': u'\ud43e',
'\xbeH': u'\ud43f',
'\xbeI': u'\ud441',
'\xbeJ': u'\ud442',
'\xbeK': u'\ud443',
'\xbeL': u'\ud445',
'\xbeM': u'\ud446',
'\xbeN': u'\ud447',
'\xbeO': u'\ud448',
'\xbeP': u'\ud449',
'\xbeQ': u'\ud44a',
'\xbeR': u'\ud44b',
'\xbeS': u'\ud44c',
'\xbeT': u'\ud44d',
'\xbeU': u'\ud44e',
'\xbeV': u'\ud44f',
'\xbeW': u'\ud450',
'\xbeX': u'\ud451',
'\xbeY': u'\ud452',
'\xbeZ': u'\ud453',
'\xbe\x81': u'\ud473',
'\xbe\x82': u'\ud474',
'\xbe\x83': u'\ud475',
'\xbe\x84': u'\ud476',
'\xbe\x85': u'\ud477',
'\xbe\x86': u'\ud47a',
'\xbe\x87': u'\ud47b',
'\xbe\x88': u'\ud47d',
'\xbe\x89': u'\ud47e',
'\xbe\x8a': u'\ud481',
'\xbe\x8b': u'\ud483',
'\xbe\x8c': u'\ud484',
'\xbe\x8d': u'\ud485',
'\xbe\x8e': u'\ud486',
'\xbe\x8f': u'\ud487',
'\xbe\x90': u'\ud48a',
'\xbe\x91': u'\ud48c',
'\xbe\x92': u'\ud48e',
'\xbe\x93': u'\ud48f',
'\xbe\x94': u'\ud490',
'\xbe\x95': u'\ud491',
'\xbe\x96': u'\ud492',
'\xbe\x97': u'\ud493',
'\xbe\x98': u'\ud495',
'\xbe\x99': u'\ud496',
'\xbe\x9a': u'\ud497',
'\xbe\x9b': u'\ud498',
'\xbe\x9c': u'\ud499',
'\xbe\x9d': u'\ud49a',
'\xbe\x9e': u'\ud49b',
'\xbe\x9f': u'\ud49c',
'\xbe\xa0': u'\ud49d',
'\xbea': u'\ud454',
'\xbeb': u'\ud455',
'\xbec': u'\ud456',
'\xbed': u'\ud457',
'\xbee': u'\ud458',
'\xbef': u'\ud459',
'\xbeg': u'\ud45a',
'\xbeh': u'\ud45b',
'\xbei': u'\ud45d',
'\xbej': u'\ud45e',
'\xbek': u'\ud45f',
'\xbel': u'\ud461',
'\xbem': u'\ud462',
'\xben': u'\ud463',
'\xbeo': u'\ud465',
'\xbep': u'\ud466',
'\xbeq': u'\ud467',
'\xber': u'\ud468',
'\xbes': u'\ud469',
'\xbet': u'\ud46a',
'\xbeu': u'\ud46b',
'\xbev': u'\ud46c',
'\xbew': u'\ud46e',
'\xbex': u'\ud470',
'\xbey': u'\ud471',
'\xbez': u'\ud472',
'\xbfA': u'\ud49e',
'\xbfB': u'\ud49f',
'\xbfC': u'\ud4a0',
'\xbfD': u'\ud4a1',
'\xbfE': u'\ud4a2',
'\xbfF': u'\ud4a3',
'\xbfG': u'\ud4a4',
'\xbfH': u'\ud4a5',
'\xbfI': u'\ud4a6',
'\xbfJ': u'\ud4a7',
'\xbfK': u'\ud4a8',
'\xbfL': u'\ud4aa',
'\xbfM': u'\ud4ab',
'\xbfN': u'\ud4ac',
'\xbfO': u'\ud4ad',
'\xbfP': u'\ud4ae',
'\xbfQ': u'\ud4af',
'\xbfR': u'\ud4b0',
'\xbfS': u'\ud4b1',
'\xbfT': u'\ud4b2',
'\xbfU': u'\ud4b3',
'\xbfV': u'\ud4b4',
'\xbfW': u'\ud4b5',
'\xbfX': u'\ud4b6',
'\xbfY': u'\ud4b7',
'\xbfZ': u'\ud4b8',
'\xbf\x81': u'\ud4d6',
'\xbf\x82': u'\ud4d7',
'\xbf\x83': u'\ud4d8',
'\xbf\x84': u'\ud4d9',
'\xbf\x85': u'\ud4da',
'\xbf\x86': u'\ud4db',
'\xbf\x87': u'\ud4dd',
'\xbf\x88': u'\ud4de',
'\xbf\x89': u'\ud4e0',
'\xbf\x8a': u'\ud4e1',
'\xbf\x8b': u'\ud4e2',
'\xbf\x8c': u'\ud4e3',
'\xbf\x8d': u'\ud4e4',
'\xbf\x8e': u'\ud4e5',
'\xbf\x8f': u'\ud4e6',
'\xbf\x90': u'\ud4e7',
'\xbf\x91': u'\ud4e9',
'\xbf\x92': u'\ud4ea',
'\xbf\x93': u'\ud4eb',
'\xbf\x94': u'\ud4ed',
'\xbf\x95': u'\ud4ee',
'\xbf\x96': u'\ud4ef',
'\xbf\x97': u'\ud4f1',
'\xbf\x98': u'\ud4f2',
'\xbf\x99': u'\ud4f3',
'\xbf\x9a': u'\ud4f4',
'\xbf\x9b': u'\ud4f5',
'\xbf\x9c': u'\ud4f6',
'\xbf\x9d': u'\ud4f7',
'\xbf\x9e': u'\ud4f9',
'\xbf\x9f': u'\ud4fa',
'\xbf\xa0': u'\ud4fc',
'\xbfa': u'\ud4b9',
'\xbfb': u'\ud4ba',
'\xbfc': u'\ud4bb',
'\xbfd': u'\ud4bc',
'\xbfe': u'\ud4bd',
'\xbff': u'\ud4be',
'\xbfg': u'\ud4bf',
'\xbfh': u'\ud4c0',
'\xbfi': u'\ud4c1',
'\xbfj': u'\ud4c2',
'\xbfk': u'\ud4c3',
'\xbfl': u'\ud4c4',
'\xbfm': u'\ud4c5',
'\xbfn': u'\ud4c6',
'\xbfo': u'\ud4c7',
'\xbfp': u'\ud4c8',
'\xbfq': u'\ud4c9',
'\xbfr': u'\ud4ca',
'\xbfs': u'\ud4cb',
'\xbft': u'\ud4cd',
'\xbfu': u'\ud4ce',
'\xbfv': u'\ud4cf',
'\xbfw': u'\ud4d1',
'\xbfx': u'\ud4d2',
'\xbfy': u'\ud4d3',
'\xbfz': u'\ud4d5',
'\xc0A': u'\ud4fe',
'\xc0B': u'\ud4ff',
'\xc0C': u'\ud500',
'\xc0D': u'\ud501',
'\xc0E': u'\ud502',
'\xc0F': u'\ud503',
'\xc0G': u'\ud505',
'\xc0H': u'\ud506',
'\xc0I': u'\ud507',
'\xc0J': u'\ud509',
'\xc0K': u'\ud50a',
'\xc0L': u'\ud50b',
'\xc0M': u'\ud50d',
'\xc0N': u'\ud50e',
'\xc0O': u'\ud50f',
'\xc0P': u'\ud510',
'\xc0Q': u'\ud511',
'\xc0R': u'\ud512',
'\xc0S': u'\ud513',
'\xc0T': u'\ud516',
'\xc0U': u'\ud518',
'\xc0V': u'\ud519',
'\xc0W': u'\ud51a',
'\xc0X': u'\ud51b',
'\xc0Y': u'\ud51c',
'\xc0Z': u'\ud51d',
'\xc0\x81': u'\ud538',
'\xc0\x82': u'\ud539',
'\xc0\x83': u'\ud53a',
'\xc0\x84': u'\ud53b',
'\xc0\x85': u'\ud53e',
'\xc0\x86': u'\ud53f',
'\xc0\x87': u'\ud541',
'\xc0\x88': u'\ud542',
'\xc0\x89': u'\ud543',
'\xc0\x8a': u'\ud545',
'\xc0\x8b': u'\ud546',
'\xc0\x8c': u'\ud547',
'\xc0\x8d': u'\ud548',
'\xc0\x8e': u'\ud549',
'\xc0\x8f': u'\ud54a',
'\xc0\x90': u'\ud54b',
'\xc0\x91': u'\ud54e',
'\xc0\x92': u'\ud550',
'\xc0\x93': u'\ud552',
'\xc0\x94': u'\ud553',
'\xc0\x95': u'\ud554',
'\xc0\x96': u'\ud555',
'\xc0\x97': u'\ud556',
'\xc0\x98': u'\ud557',
'\xc0\x99': u'\ud55a',
'\xc0\x9a': u'\ud55b',
'\xc0\x9b': u'\ud55d',
'\xc0\x9c': u'\ud55e',
'\xc0\x9d': u'\ud55f',
'\xc0\x9e': u'\ud561',
'\xc0\x9f': u'\ud562',
'\xc0\xa0': u'\ud563',
'\xc0a': u'\ud51e',
'\xc0b': u'\ud51f',
'\xc0c': u'\ud520',
'\xc0d': u'\ud521',
'\xc0e': u'\ud522',
'\xc0f': u'\ud523',
'\xc0g': u'\ud524',
'\xc0h': u'\ud525',
'\xc0i': u'\ud526',
'\xc0j': u'\ud527',
'\xc0k': u'\ud528',
'\xc0l': u'\ud529',
'\xc0m': u'\ud52a',
'\xc0n': u'\ud52b',
'\xc0o': u'\ud52c',
'\xc0p': u'\ud52d',
'\xc0q': u'\ud52e',
'\xc0r': u'\ud52f',
'\xc0s': u'\ud530',
'\xc0t': u'\ud531',
'\xc0u': u'\ud532',
'\xc0v': u'\ud533',
'\xc0w': u'\ud534',
'\xc0x': u'\ud535',
'\xc0y': u'\ud536',
'\xc0z': u'\ud537',
'\xc1A': u'\ud564',
'\xc1B': u'\ud566',
'\xc1C': u'\ud567',
'\xc1D': u'\ud56a',
'\xc1E': u'\ud56c',
'\xc1F': u'\ud56e',
'\xc1G': u'\ud56f',
'\xc1H': u'\ud570',
'\xc1I': u'\ud571',
'\xc1J': u'\ud572',
'\xc1K': u'\ud573',
'\xc1L': u'\ud576',
'\xc1M': u'\ud577',
'\xc1N': u'\ud579',
'\xc1O': u'\ud57a',
'\xc1P': u'\ud57b',
'\xc1Q': u'\ud57d',
'\xc1R': u'\ud57e',
'\xc1S': u'\ud57f',
'\xc1T': u'\ud580',
'\xc1U': u'\ud581',
'\xc1V': u'\ud582',
'\xc1W': u'\ud583',
'\xc1X': u'\ud586',
'\xc1Y': u'\ud58a',
'\xc1Z': u'\ud58b',
'\xc1\x81': u'\ud5a8',
'\xc1\x82': u'\ud5a9',
'\xc1\x83': u'\ud5aa',
'\xc1\x84': u'\ud5ab',
'\xc1\x85': u'\ud5ac',
'\xc1\x86': u'\ud5ad',
'\xc1\x87': u'\ud5ae',
'\xc1\x88': u'\ud5af',
'\xc1\x89': u'\ud5b0',
'\xc1\x8a': u'\ud5b1',
'\xc1\x8b': u'\ud5b2',
'\xc1\x8c': u'\ud5b3',
'\xc1\x8d': u'\ud5b4',
'\xc1\x8e': u'\ud5b5',
'\xc1\x8f': u'\ud5b6',
'\xc1\x90': u'\ud5b7',
'\xc1\x91': u'\ud5b8',
'\xc1\x92': u'\ud5b9',
'\xc1\x93': u'\ud5ba',
'\xc1\x94': u'\ud5bb',
'\xc1\x95': u'\ud5bc',
'\xc1\x96': u'\ud5bd',
'\xc1\x97': u'\ud5be',
'\xc1\x98': u'\ud5bf',
'\xc1\x99': u'\ud5c0',
'\xc1\x9a': u'\ud5c1',
'\xc1\x9b': u'\ud5c2',
'\xc1\x9c': u'\ud5c3',
'\xc1\x9d': u'\ud5c4',
'\xc1\x9e': u'\ud5c5',
'\xc1\x9f': u'\ud5c6',
'\xc1\xa0': u'\ud5c7',
'\xc1a': u'\ud58c',
'\xc1b': u'\ud58d',
'\xc1c': u'\ud58e',
'\xc1d': u'\ud58f',
'\xc1e': u'\ud591',
'\xc1f': u'\ud592',
'\xc1g': u'\ud593',
'\xc1h': u'\ud594',
'\xc1i': u'\ud595',
'\xc1j': u'\ud596',
'\xc1k': u'\ud597',
'\xc1l': u'\ud598',
'\xc1m': u'\ud599',
'\xc1n': u'\ud59a',
'\xc1o': u'\ud59b',
'\xc1p': u'\ud59c',
'\xc1q': u'\ud59d',
'\xc1r': u'\ud59e',
'\xc1s': u'\ud59f',
'\xc1t': u'\ud5a0',
'\xc1u': u'\ud5a1',
'\xc1v': u'\ud5a2',
'\xc1w': u'\ud5a3',
'\xc1x': u'\ud5a4',
'\xc1y': u'\ud5a6',
'\xc1z': u'\ud5a7',
'\xc2A': u'\ud5ca',
'\xc2B': u'\ud5cb',
'\xc2C': u'\ud5cd',
'\xc2D': u'\ud5ce',
'\xc2E': u'\ud5cf',
'\xc2F': u'\ud5d1',
'\xc2G': u'\ud5d3',
'\xc2H': u'\ud5d4',
'\xc2I': u'\ud5d5',
'\xc2J': u'\ud5d6',
'\xc2K': u'\ud5d7',
'\xc2L': u'\ud5da',
'\xc2M': u'\ud5dc',
'\xc2N': u'\ud5de',
'\xc2O': u'\ud5df',
'\xc2P': u'\ud5e0',
'\xc2Q': u'\ud5e1',
'\xc2R': u'\ud5e2',
'\xc2S': u'\ud5e3',
'\xc2T': u'\ud5e6',
'\xc2U': u'\ud5e7',
'\xc2V': u'\ud5e9',
'\xc2W': u'\ud5ea',
'\xc2X': u'\ud5eb',
'\xc2Y': u'\ud5ed',
'\xc2Z': u'\ud5ee',
'\xc2\x81': u'\ud616',
'\xc2\x82': u'\ud617',
'\xc2\x83': u'\ud618',
'\xc2\x84': u'\ud619',
'\xc2\x85': u'\ud61a',
'\xc2\x86': u'\ud61b',
'\xc2\x87': u'\ud61d',
'\xc2\x88': u'\ud61e',
'\xc2\x89': u'\ud61f',
'\xc2\x8a': u'\ud621',
'\xc2\x8b': u'\ud622',
'\xc2\x8c': u'\ud623',
'\xc2\x8d': u'\ud625',
'\xc2\x8e': u'\ud626',
'\xc2\x8f': u'\ud627',
'\xc2\x90': u'\ud628',
'\xc2\x91': u'\ud629',
'\xc2\x92': u'\ud62a',
'\xc2\x93': u'\ud62b',
'\xc2\x94': u'\ud62c',
'\xc2\x95': u'\ud62e',
'\xc2\x96': u'\ud62f',
'\xc2\x97': u'\ud630',
'\xc2\x98': u'\ud631',
'\xc2\x99': u'\ud632',
'\xc2\x9a': u'\ud633',
'\xc2\x9b': u'\ud634',
'\xc2\x9c': u'\ud635',
'\xc2\x9d': u'\ud636',
'\xc2\x9e': u'\ud637',
'\xc2\x9f': u'\ud63a',
'\xc2\xa0': u'\ud63b',
'\xc2a': u'\ud5ef',
'\xc2b': u'\ud5f0',
'\xc2c': u'\ud5f1',
'\xc2d': u'\ud5f2',
'\xc2e': u'\ud5f3',
'\xc2f': u'\ud5f6',
'\xc2g': u'\ud5f8',
'\xc2h': u'\ud5fa',
'\xc2i': u'\ud5fb',
'\xc2j': u'\ud5fc',
'\xc2k': u'\ud5fd',
'\xc2l': u'\ud5fe',
'\xc2m': u'\ud5ff',
'\xc2n': u'\ud602',
'\xc2o': u'\ud603',
'\xc2p': u'\ud605',
'\xc2q': u'\ud606',
'\xc2r': u'\ud607',
'\xc2s': u'\ud609',
'\xc2t': u'\ud60a',
'\xc2u': u'\ud60b',
'\xc2v': u'\ud60c',
'\xc2w': u'\ud60d',
'\xc2x': u'\ud60e',
'\xc2y': u'\ud60f',
'\xc2z': u'\ud612',
'\xc3A': u'\ud63d',
'\xc3B': u'\ud63e',
'\xc3C': u'\ud63f',
'\xc3D': u'\ud641',
'\xc3E': u'\ud642',
'\xc3F': u'\ud643',
'\xc3G': u'\ud644',
'\xc3H': u'\ud646',
'\xc3I': u'\ud647',
'\xc3J': u'\ud64a',
'\xc3K': u'\ud64c',
'\xc3L': u'\ud64e',
'\xc3M': u'\ud64f',
'\xc3N': u'\ud650',
'\xc3O': u'\ud652',
'\xc3P': u'\ud653',
'\xc3Q': u'\ud656',
'\xc3R': u'\ud657',
'\xc3S': u'\ud659',
'\xc3T': u'\ud65a',
'\xc3U': u'\ud65b',
'\xc3V': u'\ud65d',
'\xc3W': u'\ud65e',
'\xc3X': u'\ud65f',
'\xc3Y': u'\ud660',
'\xc3Z': u'\ud661',
'\xc3\x81': u'\ud681',
'\xc3\x82': u'\ud682',
'\xc3\x83': u'\ud684',
'\xc3\x84': u'\ud686',
'\xc3\x85': u'\ud687',
'\xc3\x86': u'\ud688',
'\xc3\x87': u'\ud689',
'\xc3\x88': u'\ud68a',
'\xc3\x89': u'\ud68b',
'\xc3\x8a': u'\ud68e',
'\xc3\x8b': u'\ud68f',
'\xc3\x8c': u'\ud691',
'\xc3\x8d': u'\ud692',
'\xc3\x8e': u'\ud693',
'\xc3\x8f': u'\ud695',
'\xc3\x90': u'\ud696',
'\xc3\x91': u'\ud697',
'\xc3\x92': u'\ud698',
'\xc3\x93': u'\ud699',
'\xc3\x94': u'\ud69a',
'\xc3\x95': u'\ud69b',
'\xc3\x96': u'\ud69c',
'\xc3\x97': u'\ud69e',
'\xc3\x98': u'\ud6a0',
'\xc3\x99': u'\ud6a2',
'\xc3\x9a': u'\ud6a3',
'\xc3\x9b': u'\ud6a4',
'\xc3\x9c': u'\ud6a5',
'\xc3\x9d': u'\ud6a6',
'\xc3\x9e': u'\ud6a7',
'\xc3\x9f': u'\ud6a9',
'\xc3\xa0': u'\ud6aa',
'\xc3a': u'\ud662',
'\xc3b': u'\ud663',
'\xc3c': u'\ud664',
'\xc3d': u'\ud665',
'\xc3e': u'\ud666',
'\xc3f': u'\ud668',
'\xc3g': u'\ud66a',
'\xc3h': u'\ud66b',
'\xc3i': u'\ud66c',
'\xc3j': u'\ud66d',
'\xc3k': u'\ud66e',
'\xc3l': u'\ud66f',
'\xc3m': u'\ud672',
'\xc3n': u'\ud673',
'\xc3o': u'\ud675',
'\xc3p': u'\ud676',
'\xc3q': u'\ud677',
'\xc3r': u'\ud678',
'\xc3s': u'\ud679',
'\xc3t': u'\ud67a',
'\xc3u': u'\ud67b',
'\xc3v': u'\ud67c',
'\xc3w': u'\ud67d',
'\xc3x': u'\ud67e',
'\xc3y': u'\ud67f',
'\xc3z': u'\ud680',
'\xc4A': u'\ud6ab',
'\xc4B': u'\ud6ad',
'\xc4C': u'\ud6ae',
'\xc4D': u'\ud6af',
'\xc4E': u'\ud6b1',
'\xc4F': u'\ud6b2',
'\xc4G': u'\ud6b3',
'\xc4H': u'\ud6b4',
'\xc4I': u'\ud6b5',
'\xc4J': u'\ud6b6',
'\xc4K': u'\ud6b7',
'\xc4L': u'\ud6b8',
'\xc4M': u'\ud6ba',
'\xc4N': u'\ud6bc',
'\xc4O': u'\ud6bd',
'\xc4P': u'\ud6be',
'\xc4Q': u'\ud6bf',
'\xc4R': u'\ud6c0',
'\xc4S': u'\ud6c1',
'\xc4T': u'\ud6c2',
'\xc4U': u'\ud6c3',
'\xc4V': u'\ud6c6',
'\xc4W': u'\ud6c7',
'\xc4X': u'\ud6c9',
'\xc4Y': u'\ud6ca',
'\xc4Z': u'\ud6cb',
'\xc4\x81': u'\ud6ee',
'\xc4\x82': u'\ud6ef',
'\xc4\x83': u'\ud6f1',
'\xc4\x84': u'\ud6f2',
'\xc4\x85': u'\ud6f3',
'\xc4\x86': u'\ud6f4',
'\xc4\x87': u'\ud6f6',
'\xc4\x88': u'\ud6f7',
'\xc4\x89': u'\ud6f8',
'\xc4\x8a': u'\ud6f9',
'\xc4\x8b': u'\ud6fa',
'\xc4\x8c': u'\ud6fb',
'\xc4\x8d': u'\ud6fe',
'\xc4\x8e': u'\ud6ff',
'\xc4\x8f': u'\ud701',
'\xc4\x90': u'\ud702',
'\xc4\x91': u'\ud703',
'\xc4\x92': u'\ud705',
'\xc4\x93': u'\ud706',
'\xc4\x94': u'\ud707',
'\xc4\x95': u'\ud708',
'\xc4\x96': u'\ud709',
'\xc4\x97': u'\ud70a',
'\xc4\x98': u'\ud70b',
'\xc4\x99': u'\ud70c',
'\xc4\x9a': u'\ud70d',
'\xc4\x9b': u'\ud70e',
'\xc4\x9c': u'\ud70f',
'\xc4\x9d': u'\ud710',
'\xc4\x9e': u'\ud712',
'\xc4\x9f': u'\ud713',
'\xc4\xa0': u'\ud714',
'\xc4a': u'\ud6cd',
'\xc4b': u'\ud6ce',
'\xc4c': u'\ud6cf',
'\xc4d': u'\ud6d0',
'\xc4e': u'\ud6d2',
'\xc4f': u'\ud6d3',
'\xc4g': u'\ud6d5',
'\xc4h': u'\ud6d6',
'\xc4i': u'\ud6d8',
'\xc4j': u'\ud6da',
'\xc4k': u'\ud6db',
'\xc4l': u'\ud6dc',
'\xc4m': u'\ud6dd',
'\xc4n': u'\ud6de',
'\xc4o': u'\ud6df',
'\xc4p': u'\ud6e1',
'\xc4q': u'\ud6e2',
'\xc4r': u'\ud6e3',
'\xc4s': u'\ud6e5',
'\xc4t': u'\ud6e6',
'\xc4u': u'\ud6e7',
'\xc4v': u'\ud6e9',
'\xc4w': u'\ud6ea',
'\xc4x': u'\ud6eb',
'\xc4y': u'\ud6ec',
'\xc4z': u'\ud6ed',
'\xc5A': u'\ud715',
'\xc5B': u'\ud716',
'\xc5C': u'\ud717',
'\xc5D': u'\ud71a',
'\xc5E': u'\ud71b',
'\xc5F': u'\ud71d',
'\xc5G': u'\ud71e',
'\xc5H': u'\ud71f',
'\xc5I': u'\ud721',
'\xc5J': u'\ud722',
'\xc5K': u'\ud723',
'\xc5L': u'\ud724',
'\xc5M': u'\ud725',
'\xc5N': u'\ud726',
'\xc5O': u'\ud727',
'\xc5P': u'\ud72a',
'\xc5Q': u'\ud72c',
'\xc5R': u'\ud72e',
'\xc5S': u'\ud72f',
'\xc5T': u'\ud730',
'\xc5U': u'\ud731',
'\xc5V': u'\ud732',
'\xc5W': u'\ud733',
'\xc5X': u'\ud736',
'\xc5Y': u'\ud737',
'\xc5Z': u'\ud739',
'\xc5\x81': u'\ud75f',
'\xc5\x82': u'\ud762',
'\xc5\x83': u'\ud764',
'\xc5\x84': u'\ud766',
'\xc5\x85': u'\ud767',
'\xc5\x86': u'\ud768',
'\xc5\x87': u'\ud76a',
'\xc5\x88': u'\ud76b',
'\xc5\x89': u'\ud76d',
'\xc5\x8a': u'\ud76e',
'\xc5\x8b': u'\ud76f',
'\xc5\x8c': u'\ud771',
'\xc5\x8d': u'\ud772',
'\xc5\x8e': u'\ud773',
'\xc5\x8f': u'\ud775',
'\xc5\x90': u'\ud776',
'\xc5\x91': u'\ud777',
'\xc5\x92': u'\ud778',
'\xc5\x93': u'\ud779',
'\xc5\x94': u'\ud77a',
'\xc5\x95': u'\ud77b',
'\xc5\x96': u'\ud77e',
'\xc5\x97': u'\ud77f',
'\xc5\x98': u'\ud780',
'\xc5\x99': u'\ud782',
'\xc5\x9a': u'\ud783',
'\xc5\x9b': u'\ud784',
'\xc5\x9c': u'\ud785',
'\xc5\x9d': u'\ud786',
'\xc5\x9e': u'\ud787',
'\xc5\x9f': u'\ud78a',
'\xc5\xa0': u'\ud78b',
'\xc5a': u'\ud73a',
'\xc5b': u'\ud73b',
'\xc5c': u'\ud73d',
'\xc5d': u'\ud73e',
'\xc5e': u'\ud73f',
'\xc5f': u'\ud740',
'\xc5g': u'\ud741',
'\xc5h': u'\ud742',
'\xc5i': u'\ud743',
'\xc5j': u'\ud745',
'\xc5k': u'\ud746',
'\xc5l': u'\ud748',
'\xc5m': u'\ud74a',
'\xc5n': u'\ud74b',
'\xc5o': u'\ud74c',
'\xc5p': u'\ud74d',
'\xc5q': u'\ud74e',
'\xc5r': u'\ud74f',
'\xc5s': u'\ud752',
'\xc5t': u'\ud753',
'\xc5u': u'\ud755',
'\xc5v': u'\ud75a',
'\xc5w': u'\ud75b',
'\xc5x': u'\ud75c',
'\xc5y': u'\ud75d',
'\xc5z': u'\ud75e',
'\xc6A': u'\ud78d',
'\xc6B': u'\ud78e',
'\xc6C': u'\ud78f',
'\xc6D': u'\ud791',
'\xc6E': u'\ud792',
'\xc6F': u'\ud793',
'\xc6G': u'\ud794',
'\xc6H': u'\ud795',
'\xc6I': u'\ud796',
'\xc6J': u'\ud797',
'\xc6K': u'\ud79a',
'\xc6L': u'\ud79c',
'\xc6M': u'\ud79e',
'\xc6N': u'\ud79f',
'\xc6O': u'\ud7a0',
'\xc6P': u'\ud7a1',
'\xc6Q': u'\ud7a2',
'\xc6R': u'\ud7a3',
}

encoding_map = {}
for k, v in decoding_map.items():
    encoding_map[v] = k
