/* C interfaces to CAPA for manager
   Copyright (C) 1992-2000 Michigan State University

   The CAPA system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CAPA system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with the CAPA system; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   As a special exception, you have permission to link this program
   with the TtH/TtM library and distribute executables, as long as you
   follow the requirements of the GNU GPL in regard to all of the
   software in the executable aside from TtH/TtM.
*/

/*
 * manager.funct.c
 * Guy Albertelli II 1996-1999
 */
#include <stdio.h>
#include <tk.h>
#include <pProj/capaCommon.h>
#include <manager.h>

int capaCTcreateSummary (ClientData clientdata, Tcl_Interp *interp, int argc, char *argv[])
{    
  int          section, set;
  int          studentCount,currentStudent;
  int          setScores, termScores, validScores, termValids;
  int          setIndex, maxSet=0;
  int          whatSection;
  char         fmt[64];
  char         grades[4], sectionChar[4], *answersPtr, buf[BUFFER_SIZE], *who,*which,*sortOne,*sortTwo;
  T_student   *studentPtr, *currentStudentPtr;
  FILE        *outputFile;

      sprintf(buf,"summary.section.%s",argv[2]);
  section = atoi(Tcl_GetVar2(interp,"gCT",buf,TCL_GLOBAL_ONLY));
      sprintf(buf,"summary.set.%s",argv[2]);
  set = atoi(Tcl_GetVar2(interp,"gCT",buf,TCL_GLOBAL_ONLY)); 
      sprintf(buf,"summary.who.%s",argv[2]);
  who=Tcl_GetVar2(interp,"gCT",buf,TCL_GLOBAL_ONLY);
      sprintf(buf,"summary.which.%s",argv[2]);
  which=Tcl_GetVar2(interp,"gCT",buf,TCL_GLOBAL_ONLY);
      sprintf(buf,"summary.first.%s",argv[2]);
  sortOne=Tcl_GetVar2(interp,"gCT",buf,TCL_GLOBAL_ONLY);
      sprintf(buf,"summary.second.%s",argv[2]);
  sortTwo=Tcl_GetVar2(interp,"gCT",buf,TCL_GLOBAL_ONLY);
  maxSet=howManySetDBFile();
  if (((strcmp(which,"upto") == 0) && ((set <= 0) || (set >= NUM_SET_LIMIT))) || (set > maxSet)) {
    sprintf(buf,"displayError \"The set number (%d) doesn't exist.\"",set);
    Tcl_Eval(interp,buf);
    Tcl_ResetResult(interp);
    Tcl_AppendResult(interp,"Error",NULL);
    return TCL_ERROR;
  }
  outputFile=fopen(argv[1],"w");
  if ( strcmp(who,"all") == 0 ) {
    whatSection = GET_ALL_SECTIONS;
  } else {
    whatSection = section;
  }
  studentCount = capa_get_section(&studentPtr, whatSection);

  sprintf(buf,"updateStatusMessage \"Creating primary sort key\" %s",argv[2]);
  if (Tcl_Eval(interp,buf) != TCL_OK) {
    free_students(studentPtr);
    fclose(outputFile);
    return TCL_ERROR;
  }

  if( studentCount > 0 ) {
    switch (sortOne[1]) 
      {
      case 'a': /*BY_NAME*/   
	for(currentStudentPtr=studentPtr,currentStudent=1;currentStudentPtr;
	    currentStudentPtr=currentStudentPtr->s_next,currentStudent++)  {
	  sprintf(buf,"updateStatusBar %f %s",(float)currentStudent/(float)studentCount,
		  argv[2]);
	  Tcl_Eval(interp,buf);
	  sprintf(currentStudentPtr->s_key,"%s",currentStudentPtr->s_nm);
	}
	break;
      case 'u': /*BY_NUMBER*/  
	for(currentStudentPtr=studentPtr,currentStudent=1;currentStudentPtr;
	    currentStudentPtr=currentStudentPtr->s_next,currentStudent++)  {
	  sprintf(buf,"updateStatusBar %f %s",(float)currentStudent/(float)studentCount,
		  argv[2]);
	  Tcl_Eval(interp,buf);
	  sprintf(currentStudentPtr->s_key,"%s",currentStudentPtr->s_sn);
	}
	break;
      case 'e': /*BY_SECTION*/ 
	for(currentStudentPtr=studentPtr,currentStudent=1;currentStudentPtr;
	    currentStudentPtr=currentStudentPtr->s_next,currentStudent++)  {
	  sprintf(buf,"updateStatusBar %f %s",(float)currentStudent/(float)studentCount,
		  argv[2]);
	  Tcl_Eval(interp,buf);
	  sprintf(currentStudentPtr->s_key,"%03d",currentStudentPtr->s_sec);
	}
	break;
      case 'r': /*BY_GRADE*/
	if(strcmp(which,"specific") == 0 ) {
	  for(currentStudentPtr=studentPtr,currentStudent=1;currentStudentPtr;
	      currentStudentPtr=currentStudentPtr->s_next,currentStudent++) {
	   sprintf(buf,"updateStatusBar %f %s",(float)currentStudent/(float)studentCount,
		  argv[2]);
	    Tcl_Eval(interp,buf);
	    if( (setScores = capa_get_score(currentStudentPtr->s_sn,set,
					    &validScores,&answersPtr)) == -2 ) 
	      break;
	    if( setScores < 0 ) {
	      sprintf(currentStudentPtr->s_key,"-");
	    } else {
	      sprintf(currentStudentPtr->s_key,"%03d",setScores);
	    }
	    capa_mfree(answersPtr);
	  } 
	} else {
	  for(currentStudentPtr=studentPtr,currentStudent=1;currentStudentPtr;
	      currentStudentPtr=currentStudentPtr->s_next,currentStudent++) {
	   sprintf(buf,"updateStatusBar %f %s",(float)currentStudent/(float)studentCount,
		  argv[2]);
	    Tcl_Eval(interp,buf);
	    for(termScores=0, termValids=0, setIndex=1; setIndex <= set; setIndex++) {
	      if( (setScores = capa_get_score(currentStudentPtr->s_sn,setIndex,
					      &validScores,&answersPtr)) >= 0 ) {
		termScores += setScores;
	      }
	      capa_mfree(answersPtr);
	      termValids += validScores; 
	    }
	    sprintf(currentStudentPtr->s_key,"%03d",termScores);
	  }
	}
	break;
      }

    sprintf(buf,"updateStatusMessage \"Creating secondary sort key\" %s",argv[2]);
    if (Tcl_Eval(interp,buf) != TCL_OK) {
      free_students(studentPtr);
      fclose(outputFile);
      return TCL_ERROR;
    }
    switch (sortTwo[1]) 
      {
      case 'a':/*BY_NAME*/    
	for(currentStudentPtr=studentPtr,currentStudent=1;currentStudentPtr;
	    currentStudentPtr=currentStudentPtr->s_next,currentStudent++) {
	  sprintf(buf,"updateStatusBar %f %s",(float)currentStudent/(float)studentCount,
		  argv[2]);
	  Tcl_Eval(interp,buf);
	  strcat(currentStudentPtr->s_key,currentStudentPtr->s_nm);
	}
	break;
      case 'u':/*BY_NUMBER*/  
	for(currentStudentPtr=studentPtr,currentStudent=1;currentStudentPtr;
	    currentStudentPtr=currentStudentPtr->s_next,currentStudent++) {
	  sprintf(buf,"updateStatusBar %f %s",(float)currentStudent/(float)studentCount,
		  argv[2]);
	  Tcl_Eval(interp,buf);
	  strcat(currentStudentPtr->s_key,currentStudentPtr->s_sn);
	}
	break;
      case 'e':/*BY_SECTION*/ 
	for(currentStudentPtr=studentPtr,currentStudent=1;currentStudentPtr;
	    currentStudentPtr=currentStudentPtr->s_next,currentStudent++) {
	  sprintf(buf,"updateStatusBar %f %s",(float)currentStudent/(float)studentCount,
		  argv[2]);
	  Tcl_Eval(interp,buf);
	  sprintf(sectionChar,"%03d",currentStudentPtr->s_sec); 
	  strcat(currentStudentPtr->s_key,sectionChar);
	}
	break;
      case 'r':/*BY_GRADE*/
	if(strcmp(which,"specific") == 0 ) {
	  for(currentStudentPtr=studentPtr,currentStudent=1;currentStudentPtr;
	      currentStudentPtr=currentStudentPtr->s_next,currentStudent++) {
	   sprintf(buf,"updateStatusBar %f %s",(float)currentStudent/(float)studentCount,
		  argv[2]);
	    Tcl_Eval(interp,buf);
	    if( (setScores = capa_get_score(currentStudentPtr->s_sn,set,&validScores,
					    &answersPtr) ) == -2 ) {
	      break;
	    }
	    if( setScores < 0 ) {
	      strcat(currentStudentPtr->s_key,"-");
	    } else {
	      sprintf(grades,"%03d",setScores);
	      strcat(currentStudentPtr->s_key,grades);
	    }
	    capa_mfree(answersPtr);
	  } 
	} else {
	  for(currentStudentPtr=studentPtr,currentStudent=1;currentStudentPtr;
	      currentStudentPtr=currentStudentPtr->s_next,currentStudent++) {
	   sprintf(buf,"updateStatusBar %f %s",(float)currentStudent/(float)studentCount,
		  argv[2]);
	    Tcl_Eval(interp,buf);
	    for (termScores=0, termValids=0, setIndex=1;setIndex<=set;setIndex++) {
	      if( (setScores = capa_get_score(currentStudentPtr->s_sn,setIndex,
					      &validScores,&answersPtr) ) >= 0 ) {
		termScores += setScores;
	      }
	      capa_mfree(answersPtr);
	      termValids += validScores; 
	    }
	    sprintf(grades,"%03d",termScores);
	    strcat(currentStudentPtr->s_key,grades);
	  }
	}
	break;
      }
    sprintf(buf,"updateStatusMessage \"Sorting\" %s",argv[2]);
    if (Tcl_Eval(interp,buf) != TCL_OK) {
      free_students(studentPtr);
      fclose(outputFile);
      return TCL_ERROR;
    }
    msort_main(&studentPtr);
    Tcl_ResetResult(interp);
    
    sprintf(fmt,"%%-%ds\t%%-%ds %%2d\t", MAX_NAME_CHAR,MAX_STUDENT_NUMBER);
    sprintf(buf,"updateStatusMessage \"Creating Report\" %s",argv[2]);
    if (Tcl_Eval(interp,buf) != TCL_OK) {
      free_students(studentPtr);
      fclose(outputFile);
      return TCL_ERROR;
    }
    for(currentStudentPtr=studentPtr,currentStudent=1;currentStudentPtr;
	currentStudentPtr=currentStudentPtr->s_next,currentStudent++) {
      
      sprintf(buf,"updateStatusBar %f %s",(float)currentStudent/(float)studentCount,
	      argv[2]);
      Tcl_Eval(interp,buf);
      fprintf(outputFile,fmt,currentStudentPtr->s_nm,currentStudentPtr->s_sn,
	      currentStudentPtr->s_sec);
      if( strcmp(which,"specific") == 0) {
	setScores = 0; validScores = 0;
	if( (setScores = capa_get_score(currentStudentPtr->s_sn,set,&validScores,&answersPtr) ) == -2 ) {
	  break;
	}
	if( setScores < 0 ) {
	  fprintf(outputFile, "  -\t%3d\n", validScores);
	} else {
	  fprintf(outputFile, "%3d\t%3d\n",setScores, validScores);
	}
	capa_mfree(answersPtr);
      } else {
	for( setScores=0, validScores=0, termScores = 0, termValids = 0, setIndex = 1; 
	     setIndex <= set; setIndex++) {
	  if( (setScores = capa_get_score(currentStudentPtr->s_sn,setIndex,
					  &validScores,&answersPtr) ) >= 0 ) {
	    termScores += setScores;
	  }
	  capa_mfree(answersPtr);
	  termValids += validScores;
	  if( setScores >= 0 ) {
	    fprintf(outputFile, "%3d ",setScores);
	  } else {
	    fprintf(outputFile, "  - ");
	  }
	}
	fprintf(outputFile, "\t %3d\t%3d\n",termScores,termValids);
      }
    }
    free_students(studentPtr);
  }
  fclose(outputFile);
  return TCL_OK;
}
