/* ,file-id archive://[lord]/438/rx/posix.h/1998-05-18
 */
#ifndef RXPOSIXH
#define RXPOSIXH
/*	Copyright (C) 1997 Tom Lord
 * 
 * This program is provided to you under the terms of the Liberty Software
 * License.  You are NOT permitted to redistribute, modify, or use it
 * except in very specific ways described by that license.
 *
 * This software comes with NO WARRANTY.
 * 
 * You should have received a copy of the Liberty Software License
 * along with this software; see the file =LICENSE.  If not, write to
 * the Tom Lord, 1810 Francisco St. #2, Berkeley CA, 94703, USA.  
 */




typedef struct rx_registers regmatch_t;

struct rx_posix_regex
{
  struct rx_exp_node * pattern;
  struct rx_exp_node ** subexps;
  int re_nsub;
  unsigned char * translate;
  unsigned int newline_anchor:1;/* If true, an anchor at a newline matches.*/
  unsigned int no_sub:1;	/* If set, don't  return register offsets. */
  unsigned int is_anchored:1;
  unsigned int is_nullable:1;
  unsigned char fastmap[256];
  void * owner_data;
};

typedef struct rx_posix_regex regex_t;



/*
 * POSIX `cflags' bits (i.e., information for `regcomp').
 */

/* If this bit is set, then use extended regular expression syntax.
 * If not set, then use basic regular expression syntax.  
 */
#define REG_EXTENDED 1

/* If this bit is set, then ignore case when matching.
 * If not set, then case is significant.
 */
#define REG_ICASE (REG_EXTENDED << 1)
 
/* If this bit is set, then anchors do not match at newline
 *   characters in the string.
 * If not set, then anchors do match at newlines.  
 */
#define REG_NEWLINE (REG_ICASE << 1)

/* If this bit is set, then report only success or fail in regexec.
 * If not set, then returns differ between not matching and errors.  
 */
#define REG_NOSUB (REG_NEWLINE << 1)

/* If this bit is set, then restrict the pattern language to patterns
 * that compile to efficient state machines.
 */
#define REG_DFA_ONLY (REG_NOSUB << 1)


/*
 * POSIX `eflags' bits (i.e., information for regexec).  
 */

/* If this bit is set, then the beginning-of-line operator doesn't match
 *   the beginning of the string (presumably because it's not the
 *   beginning of a line).
 * If not set, then the beginning-of-line operator does match the
 *   beginning of the string.  
 */
#define REG_NOTBOL 1

/* Like REG_NOTBOL, except for the end-of-line.  
 */
#define REG_NOTEOL (REG_NOTBOL << 1)

/* For regnexec only.  Allocate register storage and return that. */
#define REG_ALLOC_REGS (REG_NOTEOL << 1)



/* automatically generated __STDC__ prototypes */
extern int regncomp (regex_t * preg, const char * pattern, int len, int cflags);
extern int regtreecomp (regex_t * preg, struct rx_exp_node * pattern, int cflags);
extern int regcomp (regex_t * preg, const char * pattern, int cflags);
extern int regerror (int errcode, const regex_t *preg,
		     char *errbuf, int errbuf_size);
extern int rx_regmatch (regmatch_t pmatch[],
			const regex_t *preg,
			struct rx_context_rules * rules,
			int start,
			int end,
			const char *string);
extern int rx_regexec (regmatch_t pmatch[],
		       const regex_t *preg,
		       struct rx_context_rules * rules,
		       int start,
		       int end,
		       const char *string);
extern int regnexec (const regex_t *preg,
		     const char *string,
		     int len,
		     int nmatch,
		     regmatch_t **pmatch,
		     int eflags);
extern int regexec (const regex_t *preg,
		    const char *string,
		    int nmatch,
		    regmatch_t pmatch[],
		    int eflags);
extern void regfree (regex_t *preg);
#endif /* RXPOSIXH */
