/* ,file-id archive://[lord]/410/vu/./xmalloc.c/1998-05-18
*/
/*	Copyright (C) 1997 Tom Lord
 * 
 * This program is provided to you under the terms of the Liberty Software
 * License.  You are NOT permitted to redistribute, modify, or use it
 * except in very specific ways described by that license.
 *
 * This software comes with NO WARRANTY.
 * 
 * You should have received a copy of the Liberty Software License
 * along with this software; see the file =LICENSE.  If not, write to
 * the Tom Lord, 1810 Francisco St. #2, Berkeley CA, 94703, USA.  
 */



#include <malloc.h>
#include "xmalloc.h"



/* An allocator for C must use unsigned
 * long to represent allocation sizes.
 * The only alternatives are allocation units larger
 * than one byte, or upper bounds on the amount 
 * of the address space obtainable with a 
 * single allocation.
 */

void *
xmalloc (unsigned long amt)
{
  void * a;
  a = (void *)malloc (amt);
  if (!a)
    panic ("out of memory");
  return a;
}

void *
xrealloc (void * ptr, unsigned long amt)
{
  void * a;
  a = (void *)realloc (ptr, amt);
  if (!a)
    panic ("out of memory");
  return a;
}

void
xfree (void * ptr)
{
  free (ptr);
}

char *
xstrsav (char * str)
{
  char * it;
  int len;
  len = strlen (str);
  it = (char *)xmalloc (len + 1);
  strcpy (it, str);
  return it;
}

char *
xstrnsav (char * str, int len)
{
  char * it;
  it = (char *)xmalloc (len + 1);
  memcpy (it, str, len);
  it[len] = 0;
  return it;
}

char *
xstrcat (char * str1, char * str2)
{
  if (!str1 && !str2)
    return 0;
  if (!str1)
    return xstrsav (str2);
  if (!str2)
    return xstrsav (str1);
  {
    char * it;
    int len;
    len = strlen (str1) + strlen (str2) + 1;
    it = (char *)xmalloc (len);
    strcpy (it, str1);
    strcat (it, str2);
    return it;
  }
}

