# Generated by default/object.tt
package Paws::DevOpsGuru::CloudWatchMetricsDetail;
  use Moose;
  has Dimensions => (is => 'ro', isa => 'ArrayRef[Paws::DevOpsGuru::CloudWatchMetricsDimension]');
  has MetricName => (is => 'ro', isa => 'Str');
  has Namespace => (is => 'ro', isa => 'Str');
  has Period => (is => 'ro', isa => 'Int');
  has Stat => (is => 'ro', isa => 'Str');
  has Unit => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DevOpsGuru::CloudWatchMetricsDetail

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DevOpsGuru::CloudWatchMetricsDetail object:

  $service_obj->Method(Att1 => { Dimensions => $value, ..., Unit => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DevOpsGuru::CloudWatchMetricsDetail object:

  $result = $service_obj->Method(...);
  $result->Att1->Dimensions

=head1 DESCRIPTION

Information about an Amazon CloudWatch metric.

=head1 ATTRIBUTES


=head2 Dimensions => ArrayRef[L<Paws::DevOpsGuru::CloudWatchMetricsDimension>]

An array of CloudWatch dimensions associated with


=head2 MetricName => Str

The name of the CloudWatch metric.


=head2 Namespace => Str

The namespace of the CloudWatch metric. A namespace is a container for
CloudWatch metrics.


=head2 Period => Int

The length of time associated with the CloudWatch metric in number of
seconds.


=head2 Stat => Str

The type of statistic associated with the CloudWatch metric. For more
information, see Statistics
(https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic)
in the I<Amazon CloudWatch User Guide>.


=head2 Unit => Str

The unit of measure used for the CloudWatch metric. For example,
C<Bytes>, C<Seconds>, C<Count>, and C<Percent>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DevOpsGuru>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

