# Generated by default/object.tt
package Paws::EKS::KubernetesNetworkConfigResponse;
  use Moose;
  has ServiceIpv4Cidr => (is => 'ro', isa => 'Str', request_name => 'serviceIpv4Cidr', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::EKS::KubernetesNetworkConfigResponse

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::EKS::KubernetesNetworkConfigResponse object:

  $service_obj->Method(Att1 => { ServiceIpv4Cidr => $value, ..., ServiceIpv4Cidr => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::EKS::KubernetesNetworkConfigResponse object:

  $result = $service_obj->Method(...);
  $result->Att1->ServiceIpv4Cidr

=head1 DESCRIPTION

The Kubernetes network configuration for the cluster.

=head1 ATTRIBUTES


=head2 ServiceIpv4Cidr => Str

The CIDR block that Kubernetes service IP addresses are assigned from.
If you didn't specify a CIDR block when you created the cluster, then
Kubernetes assigns addresses from either the 10.100.0.0/16 or
172.20.0.0/16 CIDR blocks. If this was specified, then it was specified
when the cluster was created and it cannot be changed.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::EKS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

