#!/usr/bin/env perl

use strict;
use warnings;

use Test::More tests => 2;

use Games::Sudoku::Html qw( sudoku_html_page );
 
my @sudokus = (
    '..............3.85..1.2.......5.7.....4...1...9.......5......73..2.1........4...9',
    '.......12........3..23..4....18....5.6..7.8.......9.....85.....9...4.5..47...6...',
    '.2..5.7..4..1....68....3...2....8..3.4..2.5.....6...1...2.9.....9......57.4...9..',
    '........3..1..56...9..4..7......9.5.7.......8.5.4.2....8..2..9...35..1..6........',
    '12.3....435....1....4........54..2..6...7.........8.9...31..5.......9.7.....6...8',
    '1.......2.9.4...5...6...7...5.9.3.......7.......85..4.7.....6...3...9.8...2.....1',
    '.......39.....1..5..3.5.8....8.9...6.7...2...1..4.......9.8..5..2....6..4..7.....',
    '12.3.....4.....3....3.5......42..5......8...9.6...5.7...15..2......9..6......7..8',
    '..3..6.8....1..2......7...4..9..8.6..3..4...1.7.2.....3....5.....5...6..98.....5.',
    '1.......9..67...2..8....4......75.3...5..2....6.3......9....8..6...4...1..25...6.',
    );

my $count = 0;
my @puzzles = ();
foreach my $sudoku (@sudokus) {
  $count++;
  push @puzzles, [$sudoku, "Sudoku #$count"];
}

my $html_page = sudoku_html_page(\@puzzles);
like($html_page, qr/^\s*<!DOCTYPE html>\s*<html/s, "is html string"); 
like($html_page, qr|<title>[^<]*$count[^<]*</title>|is, "puzzle count in title"); 
