package Tk::Scrollbar;
require Tk;
import Tk qw($XS_VERSION);
use AutoLoader;
use vars qw($VERSION);
$VERSION = '3.014'; # $Id: //depot/Tk8/Scrollbar/Scrollbar.pm#14 $
use base  qw(Tk::Widget);
Construct Tk::Widget 'Scrollbar';
bootstrap Tk::Scrollbar;
sub Tk_cmd{\&Tk::scrollbar}Tk::Methods('activate','delta','fraction','get','identify','set');
sub Needed{my($sb)=@_;
my@val=$sb->get;
return 1 unless(@val==2);
return 1 if$val[0]!=0.0;
return 1 if$val[1]!=1.0;
return 0;}sub ClassInit{my($class,$mw)=@_;
$mw->bind($class,'<Enter>','Enter');
$mw->bind($class,'<Motion>','Motion');
$mw->bind($class,'<Leave>','Leave');
$mw->bind($class,'<1>','ButtonDown');
$mw->bind($class,'<B1-Motion>','Drag');
$mw->bind($class,'<ButtonRelease-1>','ButtonUp');
$mw->bind($class,'<B1-Leave>','NoOp');
$mw->bind($class,'<B1-Enter>','NoOp');
$mw->bind($class,'<Control-1>','ScrlTopBottom');
$mw->bind($class,'<2>','ButtonDown');
$mw->bind($class,'<B2-Motion>','Drag');
$mw->bind($class,'<ButtonRelease-2>','ButtonUp');
$mw->bind($class,'<B2-Leave>','NoOp');
$mw->bind($class,'<B2-Enter>','NoOp');
$mw->bind($class,'<Control-2>','ScrlTopBottom');
$mw->bind($class,'<Up>',['ScrlByUnits','v',-1]);
$mw->bind($class,'<Down>',['ScrlByUnits','v',1]);
$mw->bind($class,'<Control-Up>',['ScrlByPages','v',-1]);
$mw->bind($class,'<Control-Down>',['ScrlByPages','v',1]);
$mw->bind($class,'<Left>',['ScrlByUnits','h',-1]);
$mw->bind($class,'<Right>',['ScrlByUnits','h',1]);
$mw->bind($class,'<Control-Left>',['ScrlByPages','h',-1]);
$mw->bind($class,'<Control-Right>',['ScrlByPages','h',1]);
$mw->bind($class,'<Prior>',['ScrlByPages','hv',-1]);
$mw->bind($class,'<Next>',['ScrlByPages','hv',1]);
$mw->bind($class,'<Home>',['ScrlToPos',0]);
$mw->bind($class,'<End>',['ScrlToPos',1]);
return$class;}1;
__END__
sub Enter{my$w=shift;
my$e=$w->XEvent;
if($Tk::strictMotif){my$bg=$w->cget('-background');
$activeBg=$w->cget('-activebackground');
$w->configure('-activebackground'=>$bg);}$w->activate($w->identify($e->x,$e->y));}sub Leave{my$w=shift;
if($Tk::strictMotif){$w->configure('-activebackground'=>$activeBg)if(defined$activeBg);}$w->activate('');}sub Motion{my$w=shift;
my$e=$w->XEvent;
$w->activate($w->identify($e->x,$e->y));}sub ButtonDown{my$w=shift;
my$e=$w->XEvent;
my$element=$w->identify($e->x,$e->y);
$w->configure('-activerelief'=>'sunken');
if($e->b==1 and(defined($element)&&$element eq 'slider')){$w->StartDrag($e->x,$e->y);}elsif($e->b==2 and(defined($element)&&$element=~/^(trough[12]|slider)$/o)){my$pos=$w->fraction($e->x,$e->y);
my($head,$tail)=$w->get;
my$len=$tail-$head;
$head=$pos-$len/2;
$tail=$pos+$len/2;
if($head<0){$head=0;
$tail=$len;}elsif($tail>1){$head=1-$len;
$tail=1;}$w->ScrlToPos($head);
$w->set($head,$tail);
$w->StartDrag($e->x,$e->y);}else{$w->Select($element,'initial');}}sub ButtonUp{my$w=shift;
my$e=$w->XEvent;
$w->CancelRepeat;
$w->configure('-activerelief'=>'raised');
$w->EndDrag($e->x,$e->y);
$w->activate($w->identify($e->x,$e->y));}sub Select{my$w=shift;
my$element=shift;
my$repeat=shift;
return unless defined($element);
if($element eq 'arrow1'){$w->ScrlByUnits('hv',-1);}elsif($element eq 'trough1'){$w->ScrlByPages('hv',-1);}elsif($element eq 'trough2'){$w->ScrlByPages('hv',1);}elsif($element eq 'arrow2'){$w->ScrlByUnits('hv',1);}else{return;}if($repeat eq 'again'){$w->RepeatId($w->after($w->cget('-repeatinterval'),['Select',$w,$element,'again']));}elsif($repeat eq 'initial'){$w->RepeatId($w->after($w->cget('-repeatdelay'),['Select',$w,$element,'again']));}}sub StartDrag{my$w=shift;
my$x=shift;
my$y=shift;
return unless(defined($w->cget('-command')));
$initMouse=$w->fraction($x,$y);
@initValues=$w->get();
if(@initValues==2){$initPos=$initValues[0];}else{$initPos=$initValues[2]/$initValues[0];}}sub Drag{my$w=shift;
my$e=$w->XEvent;
return unless(defined$initMouse);
my$f=$w->fraction($e->x,$e->y);
my$delta=$f-$initMouse;
if($w->cget('-jump')){if(@initValues==2){$w->set($initValues[0]+$delta,$initValues[1]+$delta);}else{$delta=int($delta*$initValues[0]);
$initValues[2]+=$delta;
$initValues[3]+=$delta;
$w->set(@initValues);}}else{$w->ScrlToPos($initPos+$delta);}}sub EndDrag{my$w=shift;
my$x=shift;
my$y=shift;
return unless defined($initMouse);
if($w->cget('-jump')){$w->ScrlToPos($initPos+$w->fraction($x,$y)-$initMouse);}undef$initMouse;}sub ScrlByUnits{my$w=shift;
my$orient=shift;
my$amount=shift;
my$cmd=$w->cget('-command');
return unless(defined$cmd);
return if(index($orient,substr($w->cget('-orient'),0,1))<0);
my@info=$w->get;
if(@info==2){$cmd->Call('scroll',$amount,'units');}else{$cmd->Call($info[2]+$amount);}}sub ScrlByPages{my$w=shift;
my$orient=shift;
my$amount=shift;
my$cmd=$w->cget('-command');
return unless(defined$cmd);
return if(index($orient,substr($w->cget('-orient'),0,1))<0);
my@info=$w->get;
if(@info==2){$cmd->Call('scroll',$amount,'pages');}else{$cmd->Call($info[2]+$amount*($info[1]-1));}}sub ScrlToPos{my$w=shift;
my$pos=shift;
my$cmd=$w->cget('-command');
return unless(defined$cmd);
my@info=$w->get;
if(@info==2){$cmd->Call('moveto',$pos);}else{$cmd->Call(int($info[0]*$pos));}}sub ScrlTopBottom{my$w=shift;
my$e=$w->XEvent;
my$element=$w->identify($e->x,$e->y);
return unless($element);
if($element=~/1$/){$w->ScrlToPos(0);}elsif($element=~/2$/){$w->ScrlToPos(1);}}
