
######################################################################
## $Id: WizardSelector.pm 7953 2006-10-16 19:16:56Z spadkins $
######################################################################

package App::Widget::WizardSelector;
$VERSION = (q$Revision: 7953 $ =~ /(\d[\d\.]*)/)[0];  # VERSION numbers generated by svn

use App;
use App::Widget::HierSelector;
use Data::Dumper;
@ISA = ( "App::Widget::HierSelector" );

use strict;

=head1 NAME

App::Widget::WizardSelector - A screen selector widget

=head1 SYNOPSIS

   use App::Widget::WizardSelector;

   $name = "get_data";
   $w = App::Widget::WizardSelector->new($name);
   print $w->html();

=cut

=head1 DESCRIPTION

This class implements a simple wizard screen selector.

=cut

######################################################################
# INITIALIZATION
######################################################################

sub _init {
    my $self = shift;
    $self->SUPER::_init(@_);
    if (! $self->{selected}) {
        $self->select_first();
    }
}

sub select {
    my ($self, $nodeattrib, $value) = @_;
    my $success = $self->SUPER::select($nodeattrib, $value);
    $self->open_selected_exclusively();
    return($success);
}

sub open_exclusively {
    my ($self, $opennodenumber) = @_;
    #$self->{debug} .= "open_exclusively($opennodenumber)<br>";
    $self->SUPER::open_exclusively($opennodenumber);
    $self->select_first_open_leaf($opennodenumber);
}


# return the next enabled page in sequence.
sub next {
    &App::sub_entry if ($App::trace);
    my ($self) = @_;

    my $context = $self->{context};
    my $name    = $self->{name};
    my $node    = $self->node_list();

    my $selected_nodenumber = $self->{selected};
    my @nodeidx = split(/\./,$selected_nodenumber);

    my $nodelevel = $nodeidx[0];
    my $nodebase  = "";

    if (defined $node->{1} && !defined $node->{2}) {
        $nodelevel = 1;
        $nodebase = "1.";
    }

    my $auth = $context->authorization();
    my ($auth_name);

    my $found = 0;
    my $next;

    for (; $nodelevel <= $#nodeidx; $nodelevel++) {
        my $nodeidx = 1;
        my $nodenumber = "$nodebase$nodeidx"; # create its node number
        while (defined $node->{$nodenumber}) {

            # the current node has been found, check to see if this page is the next active page in
            # sequence.  if so, then we're done.
            if ($found) {
                if (defined $node->{$nodenumber}) {
                    $auth_name = $node->{$nodenumber}{auth_name};
                    if (!$auth_name || $auth->is_authorized("/App/SessionObject/$name/$auth_name")) {
                        if ($node->{$nodenumber}{enabled} == 1) {
                            $next = $node->{$nodenumber}{wname};
                            last;
                        }
                    }
                }
            }

            # if this is the current page, then mark it, and continue the traversal of pages for the next
            # active page in the sequence.
            $found = 1 if ($selected_nodenumber eq $nodenumber);

            $nodeidx++;
            $nodenumber = "$nodebase$nodeidx"; # create its node number
        }

        $nodebase .= "$nodeidx[$nodelevel].";
    }

    &App::sub_exit($next) if ($App::trace);
    return($next);
}


# return the previous enabled page in sequence.
sub prev {
    &App::sub_entry if ($App::trace);
    my ($self) = @_;

    my $context = $self->{context};
    my $name    = $self->{name};
    my $node    = $self->node_list();

    my $selected_nodenumber = $self->{selected};
    my @nodeidx = split(/\./,$selected_nodenumber);

    my $nodelevel = $nodeidx[0];
    my $nodeidx   = $nodeidx[1];
    my $nodebase  = "";

    if (defined $node->{1} && !defined $node->{2}) {
        $nodelevel = 1;
        $nodebase = "1.";
    }

    my $auth = $context->authorization();
    my ($auth_name);

    my $found = 0;
    my $prev;

    my $nodenumber = "$nodebase$nodeidx"; # create its node number

    while ($nodeidx >=0 && defined $node->{$nodenumber}) {

        if ($found) {
            if (defined $node->{$nodenumber}) {
                $auth_name = $node->{$nodenumber}{auth_name};
                if (!$auth_name || $auth->is_authorized("/App/SessionObject/$name/$auth_name")) {
                    if ($node->{$nodenumber}{enabled} == 1) {
                        $prev = $node->{$nodenumber}{wname};
                        last;
                    }
                }
            }
        }

        $found = 1 if ($selected_nodenumber eq $nodenumber);

        $nodeidx--;
        $nodenumber = "$nodebase$nodeidx"; # create its node number
    }

    &App::sub_exit($prev) if ($App::trace);
    return($prev);
}

# enable or disable a page in the selectors collection of pages.
sub enable {
    &App::sub_entry if ($App::trace);
    my ($self, $nodeattrib, $value, $enable) = @_;
    my $success = 0;
    my $node = $self->{node};

    $enable = ($enable =~ /y|yes|true|1/i) ? 1 : 0;

    foreach my $nodenumber (keys %$node) {
        if ($node->{$nodenumber}{$nodeattrib} eq $value) {
            $node->{$nodenumber}{enabled} = $enable;
            $success = 1;
            last;
        }
    }
    &App::sub_exit($success) if ($App::trace);
    return($success);
}



######################################################################
# OUTPUT METHODS
######################################################################

sub html {
    my $self = shift;
    my ($html, $label, $icon);
    my $context = $self->{context};
    my $name    = $self->{name};
    my $node    = $self->node_list();

    my ($bgcolor, $width, $fontface, $fontsize, $fontcolor, $fontbegin, $fontend);
    my ($html_url_dir, $xgif);

    $bgcolor   = $self->{bgcolor}   || "#cccccc";
    $width     = $self->{width}     || "100%";
    $fontface  = $self->{fontface}  || "verdana,geneva,arial,sans-serif";
    $fontsize  = $self->{fontsize}  || "-2";
    $fontcolor = $self->{fontcolor} || "#ffffff";

    $bgcolor = " bgcolor=\"$bgcolor\"";

    #$fontbegin = "<font face=\"$fontface\" size=\"$fontsize\" color=\"$fontcolor\">";
    #$fontend   = "</font>";

    my ($nodebase, $nodeidx, $nodenumber, $nodelabel, $parentnodenumber, $nodelevel, $opennodenumber);
    my (@nodeidx, $selected_nodenumber, $w);

    $selected_nodenumber = $self->{selected};
    @nodeidx = split(/\./,$selected_nodenumber);

    $html_url_dir = $context->get_option("html_url_dir");
    $xgif = "$html_url_dir/images/Widget/dot_clear.gif";

    $html = $self->{debug} || "";

    $nodelevel = 0;
    $nodebase = "";
    if (defined $node->{1} && !defined $node->{2}) {
        $nodelevel = 1;
        $nodebase = "1.";
    }
    my $auth = $context->authorization();
    my ($auth_name);
    for (; $nodelevel <= $#nodeidx; $nodelevel++) {
        $html .= '<table border="0" cellpadding="0" cellspacing="0" width="100%">' . "\n";
        $html .= "  <tr><td rowspan=\"3\" width=\"1%\" height=\"19\" nowrap>";

        $nodeidx = 1;
        $nodenumber = "$nodebase$nodeidx"; # create its node number
        while (defined $node->{$nodenumber}) {

            $auth_name = $node->{$nodenumber}{auth_name};
            if (!$auth_name || $auth->is_authorized("/App/SessionObject/$name/$auth_name")) {
                $label = $node->{$nodenumber}{label};
                $label = $node->{$nodenumber}{value} if (!defined $label);
                $label = "" if (!defined $label);

                if ($node->{$nodenumber}{enabled} == 1) {
                    $w = $context->widget("$name-button$nodenumber",
                        class => "App::Widget::ImageButton",
                        image_script => "App/app-button",
                        volatile     => 1,
                        height       => "19",
                        width        => "127",
                        bevel        => "2",
                        label        => $label,
                        event_target => $name,
                        event        => "open_exclusively",
                        args         => $nodenumber,
                        type         => "tab",
                    );

                    #$w->set("selected", $node->{$nodenumber}{open} ? 1 : 0);
                    if ($node->{$nodenumber}{open}) {
                        $w->set("selected", 1);
                    }
                    else {
                        $w->set("selected", 0);
                    }

                    $html .= $w->html();
                } else {
                    # $html .= "DISABLED <br>";
                }

                $html .= "<!--  -->";
            }

            $nodeidx++;
            $nodenumber = "$nodebase$nodeidx"; # create its node number
        }
        $nodebase .= "$nodeidx[$nodelevel].";
        $html .= "</td>\n";
        $html .= "    <td height=16 width=\"99%\"$bgcolor><img src=transp.gif height=16 width=1></td>\n";
        $html .= "    <td height=\"16\" width=\"99%\"></td>\n";
        $html .= "  </tr>\n";
        $html .= "  <tr>\n";
        $html .= "    <td height=\"1\" width=\"99%\" bgcolor=\"#000000\"><img src=\"$xgif\" height=\"1\" width=\"1\"></td>\n";
        $html .= "  </tr>\n";
        $html .= "  <tr>\n";
        $html .= "    <td height=\"2\" width=\"99%\" bgcolor=\"#ffffff\"><img src=\"$xgif\" height=\"2\" width=\"1\"></td>\n";
        $html .= "  </tr>\n";
        $html .= "</table>\n";
    }

    $html;
}
1;
