# Generated by default/object.tt
package Paws::CostExplorer::NetworkResourceUtilization;
  use Moose;
  has NetworkInBytesPerSecond => (is => 'ro', isa => 'Str');
  has NetworkOutBytesPerSecond => (is => 'ro', isa => 'Str');
  has NetworkPacketsInPerSecond => (is => 'ro', isa => 'Str');
  has NetworkPacketsOutPerSecond => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CostExplorer::NetworkResourceUtilization

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CostExplorer::NetworkResourceUtilization object:

  $service_obj->Method(Att1 => { NetworkInBytesPerSecond => $value, ..., NetworkPacketsOutPerSecond => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CostExplorer::NetworkResourceUtilization object:

  $result = $service_obj->Method(...);
  $result->Att1->NetworkInBytesPerSecond

=head1 DESCRIPTION

The network field that contains a list of network metrics associated
with the current instance.

=head1 ATTRIBUTES


=head2 NetworkInBytesPerSecond => Str

The network ingress throughput utilization measured in Bytes per
second.


=head2 NetworkOutBytesPerSecond => Str

The network outgress throughput utilization measured in Bytes per
second.


=head2 NetworkPacketsInPerSecond => Str

The network ingress packets measured in packets per second.


=head2 NetworkPacketsOutPerSecond => Str

The network outgress packets measured in packets per second.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CostExplorer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

