# Generated by default/object.tt
package Paws::Appflow::ErrorHandlingConfig;
  use Moose;
  has BucketName => (is => 'ro', isa => 'Str', request_name => 'bucketName', traits => ['NameInRequest']);
  has BucketPrefix => (is => 'ro', isa => 'Str', request_name => 'bucketPrefix', traits => ['NameInRequest']);
  has FailOnFirstDestinationError => (is => 'ro', isa => 'Bool', request_name => 'failOnFirstDestinationError', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Appflow::ErrorHandlingConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Appflow::ErrorHandlingConfig object:

  $service_obj->Method(Att1 => { BucketName => $value, ..., FailOnFirstDestinationError => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Appflow::ErrorHandlingConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->BucketName

=head1 DESCRIPTION

The settings that determine how Amazon AppFlow handles an error when
placing data in the destination. For example, this setting would
determine if the flow should fail after one insertion error, or
continue and attempt to insert every record regardless of the initial
failure. C<ErrorHandlingConfig> is a part of the destination connector
details.

=head1 ATTRIBUTES


=head2 BucketName => Str

Specifies the name of the Amazon S3 bucket.


=head2 BucketPrefix => Str

Specifies the Amazon S3 bucket prefix.


=head2 FailOnFirstDestinationError => Bool

Specifies if the flow should fail after the first instance of a failure
when attempting to place data in the destination.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Appflow>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

