# Generated by default/object.tt
package Paws::Athena::DataCatalog;
  use Moose;
  has Description => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str', required => 1);
  has Parameters => (is => 'ro', isa => 'Paws::Athena::ParametersMap');
  has Type => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Athena::DataCatalog

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Athena::DataCatalog object:

  $service_obj->Method(Att1 => { Description => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Athena::DataCatalog object:

  $result = $service_obj->Method(...);
  $result->Att1->Description

=head1 DESCRIPTION

Contains information about a data catalog in an AWS account.

=head1 ATTRIBUTES


=head2 Description => Str

An optional description of the data catalog.


=head2 B<REQUIRED> Name => Str

The name of the data catalog. The catalog name must be unique for the
AWS account and can use a maximum of 128 alphanumeric, underscore, at
sign, or hyphen characters.


=head2 Parameters => L<Paws::Athena::ParametersMap>

Specifies the Lambda function or functions to use for the data catalog.
This is a mapping whose values depend on the catalog type.

=over

=item *

For the C<HIVE> data catalog type, use the following syntax. The
C<metadata-function> parameter is required. C<The sdk-version>
parameter is optional and defaults to the currently supported version.

C<metadata-function=I<lambda_arn>, sdk-version=I<version_number>>

=item *

For the C<LAMBDA> data catalog type, use one of the following sets of
required parameters, but not both.

=over

=item *

If you have one Lambda function that processes metadata and another for
reading the actual data, use the following syntax. Both parameters are
required.

C<metadata-function=I<lambda_arn>, record-function=I<lambda_arn>>

=item *

If you have a composite Lambda function that processes both metadata
and data, use the following syntax to specify your Lambda function.

C<function=I<lambda_arn>>

=back

=back



=head2 B<REQUIRED> Type => Str

The type of data catalog: C<LAMBDA> for a federated catalog or C<HIVE>
for an external hive metastore. C<GLUE> refers to the C<AwsDataCatalog>
that already exists in your account, of which you can have only one.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Athena>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

