# Generated by default/object.tt
package Paws::SSOAdmin::PermissionSetProvisioningStatus;
  use Moose;
  has AccountId => (is => 'ro', isa => 'Str');
  has CreatedDate => (is => 'ro', isa => 'Str');
  has FailureReason => (is => 'ro', isa => 'Str');
  has PermissionSetArn => (is => 'ro', isa => 'Str');
  has RequestId => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSOAdmin::PermissionSetProvisioningStatus

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSOAdmin::PermissionSetProvisioningStatus object:

  $service_obj->Method(Att1 => { AccountId => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSOAdmin::PermissionSetProvisioningStatus object:

  $result = $service_obj->Method(...);
  $result->Att1->AccountId

=head1 DESCRIPTION

A structure that is used to provide the status of the provisioning
operation for a specified permission set.

=head1 ATTRIBUTES


=head2 AccountId => Str

The identifier of the AWS account from which to list the assignments.


=head2 CreatedDate => Str

The date that the permission set was created.


=head2 FailureReason => Str

The message that contains an error or exception in case of an operation
failure.


=head2 PermissionSetArn => Str

The ARN of the permission set that is being provisioned. For more
information about ARNs, see Amazon Resource Names (ARNs) and AWS
Service Namespaces in the I<AWS General Reference>.


=head2 RequestId => Str

The identifier for tracking the request operation that is generated by
the universally unique identifier (UUID) workflow.


=head2 Status => Str

The status of the permission set provisioning process.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSOAdmin>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

