package API::MailboxOrg::API::Passwordreset;

# ABSTRACT: MailboxOrg::API::Passwordreset

# ---
# This class is auto-generated by bin/get_mailbox_api.pl
# ---

use v5.24;

use strict;
use warnings;

use Moo;
use Types::Standard qw(Enum Str Int InstanceOf ArrayRef);
use API::MailboxOrg::Types qw(HashRefRestricted Boolean);
use Params::ValidationCompiler qw(validation_for);

extends 'API::MailboxOrg::APIBase';

with 'MooX::Singleton';

use feature 'signatures';
no warnings 'experimental::signatures';

our $VERSION = '1.0.2'; # VERSION

my %validators = (
    'listmethods' => validation_for(
        params => {
            mail => { type => Str, optional => 0 },

        },
    ),
    'sendsms' => validation_for(
        params => {
            mail       => { type => Str, optional => 0 },
            cell_phone => { type => Str, optional => 0 },

        },
    ),
    'setpassword' => validation_for(
        params => {
            mail     => { type => Str, optional => 0 },
            token    => { type => Str, optional => 0 },
            password => { type => Str, optional => 0 },

        },
    ),

);


sub listmethods ($self, %params) {
    my $validator = $validators{'listmethods'};
    %params       = $validator->(%params) if $validator;

    my %opt = ();

    return $self->_request( 'mail.passwordreset.listmethods', \%params, \%opt );
}

sub sendsms ($self, %params) {
    my $validator = $validators{'sendsms'};
    %params       = $validator->(%params) if $validator;

    my %opt = ();

    return $self->_request( 'mail.passwordreset.sendsms', \%params, \%opt );
}

sub setpassword ($self, %params) {
    my $validator = $validators{'setpassword'};
    %params       = $validator->(%params) if $validator;

    my %opt = ();

    return $self->_request( 'mail.passwordreset.setpassword', \%params, \%opt );
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

API::MailboxOrg::API::Passwordreset - MailboxOrg::API::Passwordreset

=head1 VERSION

version 1.0.2

=head1 SYNOPSIS

    use API::MailboxOrg;

    my $user     = '1234abc';
    my $password = '1234abc';

    my $api      = API::MailboxOrg->new(
        user     => $user,
        password => $password,
    );

=head1 METHODS

=head2 listmethods

Returns a list of available password reset methods for the given user

Parameters:

=over 4

=item * mail

=back

returns: array

    $api->passwordreset->listmethods(%params);

=head2 sendsms

Send a password reset token by SMS

Parameters:

=over 4

=item * mail

=item * cell_phone

=back

returns: boolean

    $api->passwordreset->sendsms(%params);

=head2 setpassword

Set a new password using a password reset token

Parameters:

=over 4

=item * mail

=item * token

=item * password

=back

returns: boolean

    $api->passwordreset->setpassword(%params);

=head1 AUTHOR

Renee Baecker <reneeb@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2022 by Renee Baecker.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
