#!/usr/bin/perl

package eBay::API::XML::DataType::ItemBidDetailsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ItemBidDetailsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ItemBidDetailsType

=head1 DESCRIPTION

Contains bidding details information of a user on an item.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ItemBidDetailsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::ItemIDType;
use eBay::API::XML::DataType::UserIDType;


my @gaProperties = ( [ 'BidCount', 'xs:int', '', '', '' ]
	, [ 'CategoryID', 'xs:string', '', '', '' ]
	, [ 'ItemID', 'ns:ItemIDType', ''
	     ,'eBay::API::XML::DataType::ItemIDType', '1' ]
	, [ 'LastBidTime', 'xs:dateTime', '', '', '' ]
	, [ 'SellerID', 'ns:UserIDType', ''
	     ,'eBay::API::XML::DataType::UserIDType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setBidCount()

The total number of bids the user placed on the item.

#    Argument: 'xs:int'

=cut

sub setBidCount {
  my $self = shift;
  $self->{'BidCount'} = shift
}

=head2 getBidCount()

  Calls: GetAllBidders
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getBidCount {
  my $self = shift;
  return $self->{'BidCount'};
}


=head2 setCategoryID()

Numeric ID for the category that the item belongs to.

#    Argument: 'xs:string'

=cut

sub setCategoryID {
  my $self = shift;
  $self->{'CategoryID'} = shift
}

=head2 getCategoryID()

  Calls: GetAllBidders
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getCategoryID {
  my $self = shift;
  return $self->{'CategoryID'};
}


=head2 setItemID()

The unique identifier of an item listed on the eBay site.
For GetAllBidders, an anonymous user ID is returned.
<br><br>
Since a bidder's user info is anonymous, this tag will contain the real ID value only for that bidder, and the seller of an item that the user is
bidding on. For all other users, the real ID value will be replaced with the anonymous value, according to these rules:
<br><br>
When bidding on items listed on the US site: UserID is replaced with the value "a****b" where a and b are random characters from the UserID. For example, if the UserID = IBidALot, it might be displayed as, "I****A". 	<br>
Note that in this format, the anonymous bidder ID stays the same for every auction. 
<br><br>
(GetMyeBayBuying only) when bidding on items listed on the US site: UserID is replaced with the value "a****b" where a and b are random characters from the UserID. 
<br><br>
When bidding on items listed on the the UK and AU sites: UserID is replaced with the value "Bidder X" where X is a number indicating the order of that user's first bid. For example, if the user was the third bidder, 
UserID = Bidder 3. <br>
Note that in this format, the anonymous bidder ID stays the same for a given auction, but is different for different auctions. For example, a bidder who is the third and then the seventh bidder in an auction will be listed for both bids as "Bidder 3". However, if that same bidder is the first bidder on a different auction, the bidder will be listed for that auction as "Bidder 1", 
not "Bidder 3".
<br><br>
(GetMyeBayBuying only) when bidding on items listed on the UK and AU sites: UserID is replaced with the string "High Bidder". 
<br><br>
(GetBestOffers only) - all sites: The last part of the user ID is replaced with asterisks for users that submit best offers on an item. The seller of the item will be able to see the full UserID. 
See <a href="http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AnonymousUserInfo">Working with Anonymous User Information</a> in the eBay Web Services Guide for more information.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AnonymousUserInfo
Title: Working with Anonymous User Information

#    Argument: 'ns:ItemIDType'

=cut

sub setItemID {
  my $self = shift;
  $self->{'ItemID'} = shift
}

=head2 getItemID()

  Calls: GetAllBidders
  Returned: Conditionally

#    Returns: 'ns:ItemIDType'

=cut

sub getItemID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemID'
		,'eBay::API::XML::DataType::ItemIDType');
}


=head2 setLastBidTime()

The time at which the user placed the last bid on the item.

#    Argument: 'xs:dateTime'

=cut

sub setLastBidTime {
  my $self = shift;
  $self->{'LastBidTime'} = shift
}

=head2 getLastBidTime()

  Calls: GetAllBidders
  Returned: Conditionally

#    Returns: 'xs:dateTime'

=cut

sub getLastBidTime {
  my $self = shift;
  return $self->{'LastBidTime'};
}


=head2 setSellerID()

The eBay ID of the seller who listed the item.
<br><br>
Starting Jan 2007, when a bidder's user info is made
anonymous, this tag will be returned with the anonymous
value "Seller X", where X indicates where the seller falls
in the sequence of sellers that the user has purchased items
from. For example, if the seller is the third seller that
the user has purchased items from, the value "Seller 3" is
returned.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AnonymousUserInfo
Title: Working with Anonymous User Information

#    Argument: 'ns:UserIDType'

=cut

sub setSellerID {
  my $self = shift;
  $self->{'SellerID'} = shift
}

=head2 getSellerID()

  Calls: GetAllBidders
  Returned: Conditionally

#    Returns: 'ns:UserIDType'

=cut

sub getSellerID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SellerID'
		,'eBay::API::XML::DataType::UserIDType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
