# Generated by default/object.tt
package Paws::NimbleStudio::UpdateStudioComponentInput;
  use Moose;
  has Configuration => (is => 'ro', isa => 'Paws::NimbleStudio::StudioComponentConfiguration', request_name => 'configuration', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has Ec2SecurityGroupIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'ec2SecurityGroupIds', traits => ['NameInRequest']);
  has InitializationScripts => (is => 'ro', isa => 'ArrayRef[Paws::NimbleStudio::StudioComponentInitializationScript]', request_name => 'initializationScripts', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has ScriptParameters => (is => 'ro', isa => 'ArrayRef[Paws::NimbleStudio::ScriptParameterKeyValue]', request_name => 'scriptParameters', traits => ['NameInRequest']);
  has Subtype => (is => 'ro', isa => 'Str', request_name => 'subtype', traits => ['NameInRequest']);
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::NimbleStudio::UpdateStudioComponentInput

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NimbleStudio::UpdateStudioComponentInput object:

  $service_obj->Method(Att1 => { Configuration => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NimbleStudio::UpdateStudioComponentInput object:

  $result = $service_obj->Method(...);
  $result->Att1->Configuration

=head1 DESCRIPTION

This class has no description

=head1 ATTRIBUTES


=head2 Configuration => L<Paws::NimbleStudio::StudioComponentConfiguration>

The configuration of the studio component, based on component type.


=head2 Description => Str

The description.


=head2 Ec2SecurityGroupIds => ArrayRef[Str|Undef]

The EC2 security groups that control access to the studio component.


=head2 InitializationScripts => ArrayRef[L<Paws::NimbleStudio::StudioComponentInitializationScript>]

Initialization scripts for studio components.


=head2 Name => Str

The name for the studio component.


=head2 ScriptParameters => ArrayRef[L<Paws::NimbleStudio::ScriptParameterKeyValue>]

Parameters for the studio component scripts.


=head2 Subtype => Str

The specific subtype of a studio component.


=head2 Type => Str

The type of the studio component.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NimbleStudio>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

