# Generated by default/object.tt
package Paws::ImageBuilder::TargetContainerRepository;
  use Moose;
  has RepositoryName => (is => 'ro', isa => 'Str', request_name => 'repositoryName', traits => ['NameInRequest'], required => 1);
  has Service => (is => 'ro', isa => 'Str', request_name => 'service', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ImageBuilder::TargetContainerRepository

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ImageBuilder::TargetContainerRepository object:

  $service_obj->Method(Att1 => { RepositoryName => $value, ..., Service => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ImageBuilder::TargetContainerRepository object:

  $result = $service_obj->Method(...);
  $result->Att1->RepositoryName

=head1 DESCRIPTION

The container repository where the output container image is stored.

=head1 ATTRIBUTES


=head2 B<REQUIRED> RepositoryName => Str

The name of the container repository where the output container image
is stored. This name is prefixed by the repository location.


=head2 B<REQUIRED> Service => Str

Specifies the service in which this image was registered.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ImageBuilder>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

