# Generated by default/object.tt
package Paws::LexModelsV2::OutputContext;
  use Moose;
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest'], required => 1);
  has TimeToLiveInSeconds => (is => 'ro', isa => 'Int', request_name => 'timeToLiveInSeconds', traits => ['NameInRequest'], required => 1);
  has TurnsToLive => (is => 'ro', isa => 'Int', request_name => 'turnsToLive', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModelsV2::OutputContext

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModelsV2::OutputContext object:

  $service_obj->Method(Att1 => { Name => $value, ..., TurnsToLive => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModelsV2::OutputContext object:

  $result = $service_obj->Method(...);
  $result->Att1->Name

=head1 DESCRIPTION

Describes a session context that is activated when an intent is
fulfilled.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Name => Str

The name of the output context.


=head2 B<REQUIRED> TimeToLiveInSeconds => Int

The amount of time, in seconds, that the output context should remain
active. The time is figured from the first time the context is sent to
the user.


=head2 B<REQUIRED> TurnsToLive => Int

The number of conversation turns that the output context should remain
active. The number of turns is counted from the first time that the
context is sent to the user.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModelsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

