/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.streaming;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.poi.xssf.streaming.SheetDataWriter;

public class GZIPSheetDataWriter
extends SheetDataWriter {
    public File createTempFile() throws IOException {
        File fd = File.createTempFile("poi-sxssf-sheet-xml", ".gz");
        fd.deleteOnExit();
        return fd;
    }

    public Writer createWriter(File fd) throws IOException {
        return new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(fd)));
    }

    public InputStream getWorksheetXMLInputStream() throws IOException {
        File fd = this.getTempFile();
        return new GZIPInputStream(new FileInputStream(fd));
    }
}

