/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.util.Comparator;
import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.MAMath;
import ucar.nc2.Group;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;

public class CoordinateAxis
extends VariableDS {
    private static Logger log = LoggerFactory.getLogger(CoordinateAxis.class);
    private static final int axisSizeToCache = 100000;
    protected NetcdfDataset ncd;
    protected AxisType axisType = null;
    protected String positive = null;
    protected String boundaryRef = null;
    protected boolean isContiguous = true;
    private MAMath.MinMax minmax = null;
    private int hashCode = 0;

    public static CoordinateAxis factory(NetcdfDataset ncd, VariableDS vds) {
        if (vds.getRank() == 1 || vds.getRank() == 2 && vds.getDataType() == DataType.CHAR) {
            return new CoordinateAxis1D(ncd, vds);
        }
        if (vds.getRank() == 2) {
            return new CoordinateAxis2D(ncd, vds);
        }
        return new CoordinateAxis(ncd, vds);
    }

    protected CoordinateAxis(NetcdfDataset ncd, VariableDS vds) {
        super(vds, false);
        this.ncd = ncd;
        if (vds instanceof CoordinateAxis) {
            CoordinateAxis axis = (CoordinateAxis)vds;
            this.axisType = axis.axisType;
            this.boundaryRef = axis.boundaryRef;
            this.isContiguous = axis.isContiguous;
            this.positive = axis.positive;
        }
        this.setSizeToCache(100000);
    }

    public CoordinateAxis(NetcdfDataset ds, Group group, String shortName, DataType dataType, String dims, String units, String desc) {
        super(ds, group, null, shortName, dataType, dims, units, desc);
        this.ncd = ds;
        this.setSizeToCache(100000);
    }

    public CoordinateAxis copyNoCache() {
        CoordinateAxis axis = new CoordinateAxis(this.ncd, this.getParentGroup(), this.getShortName(), this.getDataType(), this.getDimensionsString(), this.getUnitsString(), this.getDescription());
        axis.axisType = this.axisType;
        axis.boundaryRef = this.boundaryRef;
        axis.isContiguous = this.isContiguous;
        axis.positive = this.positive;
        axis.cache = new Variable.Cache();
        return axis;
    }

    protected Variable copy() {
        return new CoordinateAxis(this.ncd, this);
    }

    public AxisType getAxisType() {
        return this.axisType;
    }

    public void setAxisType(AxisType axisType) {
        this.axisType = axisType;
    }

    public String getUnitsString() {
        String units = super.getUnitsString();
        return units == null ? "" : units;
    }

    public boolean isNumeric() {
        return this.getDataType() != DataType.CHAR && this.getDataType() != DataType.STRING && this.getDataType() != DataType.STRUCTURE;
    }

    public boolean isContiguous() {
        return this.isContiguous;
    }

    public String getPositive() {
        return this.positive;
    }

    public void setPositive(String positive) {
        this.positive = positive;
    }

    public String getBoundaryRef() {
        return this.boundaryRef;
    }

    public void setBoundaryRef(String boundaryRef) {
        this.boundaryRef = boundaryRef;
    }

    private void init() {
        try {
            Array data = this.read();
            this.minmax = MAMath.getMinMax(data);
        }
        catch (IOException ioe) {
            log.error("Error reading coordinate values ", ioe);
            throw new IllegalStateException(ioe);
        }
    }

    public double getMinValue() {
        if (this.minmax == null) {
            this.init();
        }
        return this.minmax.min;
    }

    public double getMaxValue() {
        if (this.minmax == null) {
            this.init();
        }
        return this.minmax.max;
    }

    public void getInfo(Formatter buf) {
        buf.format("%-30s", this.getNameAndDimensions());
        buf.format("%-20s", this.getUnitsString());
        if (this.axisType != null) {
            buf.format("%-10s", this.axisType.toString());
        }
        buf.format("%s", this.getDescription());
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof CoordinateAxis)) {
            return false;
        }
        if (!super.equals(oo)) {
            return false;
        }
        CoordinateAxis o = (CoordinateAxis)oo;
        if (this.getAxisType() != null && !this.getAxisType().equals((Object)o.getAxisType())) {
            return false;
        }
        return this.getPositive() == null || this.getPositive().equals(o.getPositive());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = super.hashCode();
            if (this.getAxisType() != null) {
                result = 37 * result + this.getAxisType().hashCode();
            }
            if (this.getPositive() != null) {
                result = 37 * result + this.getPositive().hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AxisComparator
    implements Comparator<CoordinateAxis> {
        @Override
        public int compare(CoordinateAxis c1, CoordinateAxis c2) {
            AxisType t1 = c1.getAxisType();
            AxisType t2 = c2.getAxisType();
            if (t1 == null && t2 == null) {
                return c1.getName().compareTo(c2.getName());
            }
            if (t1 == null) {
                return -1;
            }
            if (t2 == null) {
                return 1;
            }
            return t1.axisOrder() - t2.axisOrder();
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }
    }
}

